/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder;

import GiciEntropyCoder.ProbabilityTable;
import java.math.BigInteger;
import java.util.Arrays;

public class StaticProbabilityTable
implements ProbabilityTable {
    private final BigInteger[] rangeBounds;
    private final BigInteger totalRange;

    protected StaticProbabilityTable(BigInteger[] bigIntegerArray) {
        assert (bigIntegerArray.length > 2);
        assert (bigIntegerArray[bigIntegerArray.length - 1].bitLength() == bigIntegerArray[bigIntegerArray.length - 1].getLowestSetBit() + 1);
        this.rangeBounds = new BigInteger[bigIntegerArray.length];
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            assert (bigIntegerArray[i] != null);
            this.rangeBounds[i] = bigIntegerArray[i];
        }
        this.totalRange = bigIntegerArray[bigIntegerArray.length - 1];
    }

    @Override
    public BigInteger getSymbolCount() {
        return BigInteger.valueOf(this.rangeBounds.length - 1);
    }

    @Override
    public BigInteger getObservationCount() {
        return this.totalRange;
    }

    private int bigIntegerToIndex(BigInteger bigInteger) {
        int n = bigInteger.intValue();
        assert (n >= 0 && n < this.rangeBounds.length);
        return n;
    }

    @Override
    public BigInteger getCumulativeFrequency(BigInteger bigInteger) {
        return this.rangeBounds[this.bigIntegerToIndex(bigInteger)];
    }

    @Override
    public BigInteger getFrequency(BigInteger bigInteger) {
        int n = this.bigIntegerToIndex(bigInteger);
        return this.rangeBounds[n + 1].subtract(this.rangeBounds[n]);
    }

    @Override
    public BigInteger findSymbolFromFrequency(BigInteger bigInteger) {
        assert (bigInteger.compareTo(BigInteger.ZERO) >= 0);
        assert (bigInteger.compareTo(this.totalRange) < 0);
        int n = Arrays.binarySearch(this.rangeBounds, bigInteger);
        if (n < 0) {
            int n2 = -n - 1;
            n = n2 - 1;
        }
        assert (n >= 0 && n < this.rangeBounds.length - 1);
        return BigInteger.valueOf(n);
    }

    @Override
    public final int getSymbolByteSize() {
        int n = this.totalRange.bitLength() - 1;
        return n / 8 + (n % 8 != 0 ? 1 : 0);
    }

    public final void updateState(BigInteger bigInteger) {
    }
}

