/*
 * Decompiled with CFR 0.152.
 */
package GiciFile;

import GiciException.WarningException;
import GiciFile.JaiWrapper;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.zip.GZIPInputStream;

public class LoadFile {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int zBegin;
    Class[] samplesType;
    boolean RGBComponents = false;
    int[] signedPixels = null;

    public void LoadPGM(String string) throws WarningException {
        try {
            int n;
            int n2;
            int n3;
            Object object;
            String string2 = "";
            int n4 = string.lastIndexOf(".");
            if (n4 >= 0) {
                string2 = string.substring(n4 + 1, string.length());
            }
            BufferedReader bufferedReader = null;
            bufferedReader = string2.compareToIgnoreCase("gz") == 0 ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))) : new BufferedReader(new FileReader(string));
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n5 = 0;
            do {
                string3 = bufferedReader.readLine();
                n5 += string3.length() + 1;
            } while (string3.startsWith("#"));
            if (!string3.equals("P5") && !string3.equals("P2")) {
                throw new WarningException("File \"" + string + "\" can not be loaded. Problems with the magic number");
            }
            do {
                string4 = bufferedReader.readLine();
                n5 += string4.length() + 1;
            } while (string4.startsWith("#"));
            String string6 = string4.substring(0, string4.indexOf(" "));
            String string7 = string4.substring(string4.indexOf(" ") + 1, string4.length());
            this.xSize = Integer.parseInt(string6);
            this.ySize = Integer.parseInt(string7);
            this.zSize = 1;
            do {
                string5 = bufferedReader.readLine();
                n5 += string5.length() + 1;
            } while (string5.startsWith("#"));
            int n6 = Integer.parseInt(string5);
            this.imageSamples = new float[this.zSize][this.ySize][this.xSize];
            this.samplesType = new Class[this.zSize];
            this.samplesType[0] = n6 <= 255 ? Byte.TYPE : Short.TYPE;
            if (string3.equals("P5")) {
                int n7;
                object = null;
                object = string2.compareToIgnoreCase("gz") == 0 ? new DataInputStream(new GZIPInputStream(new FileInputStream(string))) : new DataInputStream(new FileInputStream(string));
                for (n7 = 0; n7 < n5; ++n7) {
                    ((DataInputStream)object).readByte();
                }
                if (this.samplesType[0] == Byte.TYPE) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(this.xSize);
                    for (n3 = 0; n3 < this.ySize; ++n3) {
                        n2 = 0;
                        n = 0;
                        try {
                            byte[] byArray = byteBuffer.array();
                            while ((n2 = ((DataInputStream)object).read(byArray, n += n2, this.xSize - n)) >= 0 && n2 + n < this.xSize) {
                            }
                            if (n2 >= 0) {
                                n2 += n;
                            }
                        }
                        catch (IOException iOException) {
                            throw new WarningException("I/O file reading error.");
                        }
                        if (n2 < 0) {
                            throw new WarningException("File reading error (end of file reached before the full file has been read).");
                        }
                        if (n2 != this.xSize) {
                            throw new WarningException("File reading error (" + n2 + " bytes read, but " + this.xSize + " needed).");
                        }
                        for (int i = 0; i < this.xSize; ++i) {
                            this.imageSamples[0][n3][i] = byteBuffer.get(i) & 0xFF;
                        }
                        byteBuffer.clear();
                    }
                } else {
                    for (n7 = 0; n7 < this.ySize; ++n7) {
                        for (n3 = 0; n3 < this.xSize; ++n3) {
                            this.imageSamples[0][n7][n3] = ((DataInputStream)object).readChar();
                        }
                    }
                }
                object = null;
            } else {
                object = bufferedReader.readLine();
                int[] nArray = this.getIntegerArray((String)object);
                n3 = 0;
                for (n2 = 0; n2 < this.ySize; ++n2) {
                    for (n = 0; n < this.xSize; ++n) {
                        if (n3 == nArray.length) {
                            n3 = 0;
                            object = bufferedReader.readLine();
                            nArray = this.getIntegerArray((String)object);
                        }
                        this.imageSamples[0][n2][n] = nArray[n3];
                        ++n3;
                    }
                }
            }
            bufferedReader = null;
            this.signedPixels = new int[this.zSize];
            for (int i = 0; i < this.zSize; ++i) {
                this.signedPixels[i] = 0;
            }
        }
        catch (Exception exception) {
            throw new WarningException("File \"" + string + "\" can not be loaded.");
        }
    }

    int[] getIntegerArray(String string) {
        int[] nArray = null;
        if (string != null) {
            String[] stringArray = string.split(" ");
            nArray = new int[stringArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
        }
        return nArray;
    }

    public LoadFile(String string) throws WarningException {
        int n;
        String string2 = "";
        int n2 = string.lastIndexOf(".");
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1, string.length());
        }
        if ((n = string.lastIndexOf(".", n2 - 1)) >= 0 && string2.compareToIgnoreCase("gz") == 0) {
            string2 = string.substring(n + 1, n2);
        }
        if (string2.compareToIgnoreCase("pgm") != 0) {
            BufferedImage bufferedImage = JaiWrapper.jaiLoad(string);
            this.zSize = bufferedImage.getRaster().getNumBands();
            this.ySize = bufferedImage.getHeight();
            this.xSize = bufferedImage.getWidth();
            this.imageSamples = new float[this.zSize][this.ySize][this.xSize];
            this.samplesType = new Class[this.zSize];
            block15: for (int i = 0; i < this.zSize; ++i) {
                switch (bufferedImage.getType()) {
                    case 5: {
                        this.samplesType[i] = Byte.TYPE;
                        this.RGBComponents = true;
                        continue block15;
                    }
                    case 6: {
                        this.samplesType[i] = Byte.TYPE;
                        continue block15;
                    }
                    case 7: {
                        this.samplesType[i] = Byte.TYPE;
                        continue block15;
                    }
                    case 12: {
                        this.samplesType[i] = Byte.TYPE;
                        continue block15;
                    }
                    case 10: {
                        this.samplesType[i] = Byte.TYPE;
                        continue block15;
                    }
                    case 13: {
                        this.samplesType[i] = Byte.TYPE;
                        continue block15;
                    }
                    case 2: {
                        this.samplesType[i] = Integer.TYPE;
                        continue block15;
                    }
                    case 3: {
                        this.samplesType[i] = Integer.TYPE;
                        continue block15;
                    }
                    case 4: {
                        this.samplesType[i] = Integer.TYPE;
                        continue block15;
                    }
                    case 1: {
                        this.samplesType[i] = Integer.TYPE;
                        this.RGBComponents = true;
                        continue block15;
                    }
                    case 9: {
                        this.samplesType[i] = Short.TYPE;
                        this.RGBComponents = true;
                        continue block15;
                    }
                    case 8: {
                        this.samplesType[i] = Short.TYPE;
                        this.RGBComponents = true;
                        continue block15;
                    }
                    case 11: {
                        this.samplesType[i] = Short.TYPE;
                        continue block15;
                    }
                    default: {
                        int[] nArray = bufferedImage.getColorModel().getComponentSize();
                        if (nArray[i] <= 8) {
                            this.samplesType[i] = Byte.TYPE;
                        } else if (nArray[i] <= 16) {
                            this.samplesType[i] = Short.TYPE;
                        } else if (nArray[i] <= 32) {
                            this.samplesType[i] = Integer.TYPE;
                        } else if (nArray[i] <= 64) {
                            this.samplesType[i] = Long.TYPE;
                        } else {
                            throw new WarningException("Unrecognized sample type loading " + string + ".");
                        }
                        if (this.zSize != 3) continue block15;
                        this.RGBComponents = true;
                    }
                }
            }
            float[] fArray = new float[this.zSize];
            for (int i = bufferedImage.getMinY(); i < bufferedImage.getMinY() + this.ySize; ++i) {
                for (int j = bufferedImage.getMinX(); j < bufferedImage.getMinX() + this.xSize; ++j) {
                    bufferedImage.getRaster().getPixel(j, i, fArray);
                    for (int k = 0; k < this.zSize; ++k) {
                        this.imageSamples[k][i][j] = fArray[k];
                    }
                }
            }
            bufferedImage.flush();
            bufferedImage = null;
        } else {
            this.LoadPGM(string);
        }
    }

    public LoadFile(String string, int n, int n2, int n3, int n4, int n5, boolean bl) throws WarningException {
        this(string, n, n2, n3, n4, n5, bl, 0);
    }

    public LoadFile(String string, int n, int n2, int n3, int n4, int n5, boolean bl, int n6) throws WarningException {
        this.setSignedPixels(n4, n);
        this.zBegin = n6;
        this.rawLoad(string, n, n2, n3, LoadFile.getClass(n4), n5, bl);
    }

    public LoadFile(String string, int n, int n2, int n3, Class clazz, int n4, boolean bl) throws WarningException {
        this(string, n, n2, n3, clazz, n4, bl, 0);
    }

    public LoadFile(String string, int n, int n2, int n3, Class clazz, int n4, boolean bl, int n5) throws WarningException {
        this.zBegin = n5;
        this.rawLoad(string, n, n2, n3, clazz, n4, bl);
    }

    public static boolean isRaw(String string) {
        return string.endsWith(".raw") || string.endsWith(".img") || string.endsWith(".rawl") || string.endsWith(".raw.gz") || string.endsWith(".img.gz");
    }

    public void rawLoad(String string, int n, int n2, int n3, Class clazz, int n4, boolean bl) throws WarningException {
        int n5;
        int n6;
        assert (string != null);
        this.zSize = n;
        this.ySize = n2;
        this.xSize = n3;
        this.imageSamples = new float[n][n2][n3];
        this.samplesType = new Class[n];
        for (n6 = 0; n6 < n; ++n6) {
            this.samplesType[n6] = clazz;
        }
        this.RGBComponents = bl;
        n6 = 0;
        int n7 = string.lastIndexOf(".");
        if (n7 >= 0) {
            n6 = string.substring(n7 + 1, string.length()).compareToIgnoreCase("gz") == 0 ? 1 : 0;
        }
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = n6 != 0 ? new GZIPInputStream((InputStream)new FileInputStream(string), 0x100000) : new BufferedInputStream(new FileInputStream(string), 0x100000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WarningException("File \"" + string + "\" not found.");
        }
        catch (IOException iOException) {
            throw new WarningException("File \"" + string + "\" may be corrupted (or not in gzip format).");
        }
        DataInputStream dataInputStream = new DataInputStream(filterInputStream);
        int n8 = LoadFile.getType(clazz.getName());
        switch (n8) {
            case 0: {
                n5 = n3;
                break;
            }
            case 1: {
                n5 = n3;
                break;
            }
            case 2: {
                n5 = 2 * n3;
                break;
            }
            case 3: {
                n5 = 2 * n3;
                break;
            }
            case 4: {
                n5 = 4 * n3;
                break;
            }
            case 5: {
                n5 = 8 * n3;
                break;
            }
            case 6: {
                n5 = 4 * n3;
                break;
            }
            case 7: {
                n5 = 8 * n3;
                break;
            }
            default: {
                throw new WarningException("Sample type unrecognized.");
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n5);
        switch (n4) {
            case 0: {
                byteBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 1: {
                byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        }
        if (this.zBegin != 0) {
            try {
                dataInputStream.skip((long)this.zBegin * (long)n2 * (long)n5);
            }
            catch (IOException iOException) {
                throw new WarningException("I/O file skipping error.");
            }
        }
        for (int i = 0; i < n; ++i) {
            block35: for (int j = 0; j < n2; ++j) {
                int n9 = 0;
                int n10 = 0;
                try {
                    while ((n9 = dataInputStream.read(byteBuffer.array(), n10 += n9, n5 - n10)) >= 0 && n9 + n10 < n5) {
                    }
                    if (n9 >= 0) {
                        n9 += n10;
                    }
                }
                catch (IOException iOException) {
                    throw new WarningException("I/O file reading error.");
                }
                if (n9 < 0) {
                    throw new WarningException("File reading error (end of file reached before the full file has been read).");
                }
                if (n9 != n5) {
                    throw new WarningException("File reading error (" + n9 + " bytes read, but " + n5 + " needed).");
                }
                switch (n8) {
                    case 0: {
                        for (int k = 0; k < n3; ++k) {
                            this.imageSamples[i][j][k] = byteBuffer.get(k) == 0 ? 0.0f : 1.0f;
                        }
                        continue block35;
                    }
                    case 1: {
                        for (int k = 0; k < n3; ++k) {
                            this.imageSamples[i][j][k] = byteBuffer.get(k) & 0xFF;
                        }
                        continue block35;
                    }
                    case 2: {
                        CharBuffer charBuffer = byteBuffer.asCharBuffer();
                        for (int k = 0; k < n3; ++k) {
                            this.imageSamples[i][j][k] = charBuffer.get(k) & 0xFFFF;
                        }
                        continue block35;
                    }
                    case 3: {
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        for (int k = 0; k < n3; ++k) {
                            this.imageSamples[i][j][k] = shortBuffer.get(k);
                        }
                        continue block35;
                    }
                    case 4: {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        for (int k = 0; k < n3; ++k) {
                            this.imageSamples[i][j][k] = intBuffer.get(k);
                        }
                        continue block35;
                    }
                    case 5: {
                        LongBuffer longBuffer = byteBuffer.asLongBuffer();
                        for (int k = 0; k < n3; ++k) {
                            this.imageSamples[i][j][k] = longBuffer.get(k);
                        }
                        continue block35;
                    }
                    case 6: {
                        byteBuffer.asFloatBuffer().get(this.imageSamples[i][j]);
                        continue block35;
                    }
                    case 7: {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        for (int k = 0; k < n3; ++k) {
                            this.imageSamples[i][j][k] = (float)doubleBuffer.get(k);
                        }
                        continue block35;
                    }
                }
            }
        }
        try {
            ((InputStream)filterInputStream).close();
        }
        catch (IOException iOException) {
            throw new WarningException("Error closing file \"" + string + "\".");
        }
    }

    public float[][][] getImage() {
        return this.imageSamples;
    }

    public Class[] getTypes() {
        return this.samplesType;
    }

    public boolean getRGBComponents() {
        return this.RGBComponents;
    }

    public int[] getPixelBitDepth() {
        int[] nArray = new int[this.zSize];
        for (int i = 0; i < this.zSize; ++i) {
            if (this.samplesType[i] == Byte.TYPE) {
                nArray[i] = 8;
                continue;
            }
            if (this.samplesType[i] == Character.TYPE) {
                nArray[i] = 16;
                continue;
            }
            if (this.samplesType[i] == Short.TYPE) {
                nArray[i] = 16;
                continue;
            }
            if (this.samplesType[i] == Integer.TYPE) {
                nArray[i] = 32;
                continue;
            }
            if (this.samplesType[i] == Long.TYPE) {
                nArray[i] = 64;
                continue;
            }
            if (this.samplesType[i] == Float.TYPE) {
                nArray[i] = 32;
                continue;
            }
            if (this.samplesType[i] != Double.TYPE) continue;
            nArray[i] = 64;
        }
        return nArray;
    }

    public void setSignedPixels(int n, int n2) {
        this.signedPixels = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.signedPixels[i] = n == 3 || n == 4 || n == 5 || n == 6 || n == 7 ? 1 : 0;
        }
    }

    public int[] getSignedPixels() {
        return this.signedPixels;
    }

    public static int getType(String string) {
        int n = -1;
        if (string.compareTo("boolean") == 0) {
            n = 0;
        } else if (string.compareTo("byte") == 0) {
            n = 1;
        } else if (string.compareTo("char") == 0) {
            n = 2;
        } else if (string.compareTo("short") == 0) {
            n = 3;
        } else if (string.compareTo("int") == 0) {
            n = 4;
        } else if (string.compareTo("long") == 0) {
            n = 5;
        } else if (string.compareTo("float") == 0) {
            n = 6;
        } else if (string.compareTo("double") == 0) {
            n = 7;
        }
        return n;
    }

    public static Class getClass(int n) {
        Class<Comparable<Boolean>> clazz = null;
        switch (n) {
            case 0: {
                clazz = Boolean.TYPE;
                break;
            }
            case 1: {
                clazz = Byte.TYPE;
                break;
            }
            case 2: {
                clazz = Character.TYPE;
                break;
            }
            case 3: {
                clazz = Short.TYPE;
                break;
            }
            case 4: {
                clazz = Integer.TYPE;
                break;
            }
            case 5: {
                clazz = Long.TYPE;
                break;
            }
            case 6: {
                clazz = Float.TYPE;
                break;
            }
            case 7: {
                clazz = Double.TYPE;
            }
        }
        return clazz;
    }
}

