/*
 * Decompiled with CFR 0.152.
 */
package GiciFile.RawImage;

import GiciFile.RawImage.DoubleLinkedList;
import GiciFile.RawImage.LinkedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Cache<T> {
    private Map<Integer, Block> pages;
    private DoubleLinkedList<Integer> policy;
    private int numElements;

    public Cache(int n) {
        this.numElements = n;
        this.pages = new HashMap<Integer, Block>();
        this.policy = new DoubleLinkedList();
    }

    public Block get(int n) {
        Block block = this.pages.get(n);
        if (block != null) {
            LinkedElement<Integer> linkedElement = block.element;
            this.policy.remove(linkedElement);
            block.element = this.policy.add((Integer)linkedElement.key);
            return block;
        }
        return null;
    }

    public Block set(Block block) {
        Block block2 = this.get(block.position);
        if (block2 != null) {
            block2.data = block.data;
            block2.dirty = true;
            return null;
        }
        this.pages.put(block.position, block);
        block.element = this.policy.add(block.position);
        Block block3 = null;
        if (this.policy.size() > this.numElements) {
            int n = (Integer)this.policy.poll().key;
            block3 = this.pages.remove(n);
        }
        return block3;
    }

    public void markDirty(int n) throws NoSuchElementException {
        Block block = this.pages.get(n);
        if (block == null) {
            throw new NoSuchElementException("Can't mark as dirty element " + n + " because it's not cached");
        }
        block.dirty = true;
    }

    public ArrayList<Block> flush() {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        Iterator<Integer> iterator = this.policy.iterator();
        while (iterator.hasNext()) {
            Block block = this.pages.get(iterator.next());
            if (!block.dirty) continue;
            arrayList.add(block);
            block.dirty = false;
        }
        return arrayList;
    }

    public class Block {
        protected LinkedElement<Integer> element = null;
        public T data;
        public int position;
        public boolean dirty;

        public Block(T t, int n, boolean bl) {
            this.data = t;
            this.position = n;
            this.dirty = bl;
        }
    }
}

