/*
 * Decompiled with CFR 0.152.
 */
package GiciFile.RawImage;

import GiciFile.RawImage.RawImageIterator;
import java.io.File;
import java.io.IOException;
import java.util.ListIterator;
import java.util.Vector;

public class RawImage {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int RW = 3;
    private int[] geo;
    private File file;
    private int[] pixelOrder;
    private int mode;
    private Vector<RawImageIterator<?>> iterators;

    public RawImage(String string, int[] nArray, int[] nArray2, int n) {
        this(new File(string), nArray, nArray2, n);
    }

    public RawImage(File file, int[] nArray, int[] nArray2, int n) {
        this.file = file;
        this.geo = nArray;
        this.mode = n;
        this.pixelOrder = nArray2;
        this.iterators = new Vector();
    }

    public <T> ListIterator<T> getIterator(T t, int[] nArray, int n, boolean bl) throws IOException, UnsupportedOperationException, IndexOutOfBoundsException, ClassCastException {
        if ((n & 1) > (this.mode & 1) || (n & 2) > (this.mode & 2)) {
            throw new UnsupportedOperationException("The operation " + n + " is not available in mode " + this.mode);
        }
        RawImageIterator<T> rawImageIterator = new RawImageIterator<T>(this, t, this.file, this.geo, this.pixelOrder, nArray, n, bl);
        this.iterators.add(rawImageIterator);
        return rawImageIterator;
    }

    public <T> ListIterator<T> getIteratorByBand(T t, int[] nArray, int n, boolean bl, int n2) throws IOException, UnsupportedOperationException, IndexOutOfBoundsException, ClassCastException {
        if ((n & 1) > (this.mode & 1) || (n & 2) > (this.mode & 2)) {
            throw new UnsupportedOperationException("The operation " + n + " is not available in mode " + this.mode);
        }
        RawImageIterator<T> rawImageIterator = new RawImageIterator<T>(this, t, this.file, this.geo, this.pixelOrder, nArray, n, bl, n2);
        this.iterators.add(rawImageIterator);
        return rawImageIterator;
    }

    public <T> void close(ListIterator<T> listIterator) throws ClassCastException, IOException {
        if (!(listIterator instanceof RawImageIterator)) {
            throw new ClassCastException("close need a RawImageIterator<T>");
        }
        RawImageIterator rawImageIterator = (RawImageIterator)listIterator;
        this.iterators.remove(rawImageIterator);
        rawImageIterator.close();
    }

    public void finalize() throws Throwable {
        try {
            while (!this.iterators.isEmpty()) {
                this.close(this.iterators.remove(0));
            }
        }
        finally {
            super.finalize();
        }
    }
}

