/*
 * Decompiled with CFR 0.152.
 */
package GiciFile.RawImage;

import GiciException.LackOfPrecisionError;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class TypeConverter<T> {
    public static final int INT_ARRAY = 0;
    public static final int LONG_ARRAY = 1;
    public static final int FLOAT_ARRAY = 2;
    private final int[] geo;
    private final boolean lossless;
    private final int type;
    private final int size;
    private final ByteOrder byteOrder;

    public TypeConverter(T t, int[] nArray, boolean bl) throws ClassCastException {
        if (t instanceof int[]) {
            this.type = 0;
        } else if (t instanceof long[]) {
            this.type = 1;
        } else if (t instanceof float[]) {
            this.type = 2;
        } else {
            throw new ClassCastException("The only types accepted are int[], long[] and float[]");
        }
        this.geo = nArray;
        this.lossless = bl;
        int[] nArray2 = new int[]{1, 1, 2, 2, 4, 8, 4, 8};
        this.size = nArray2[nArray[3]];
        if (nArray[4] == 0) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            assert (nArray[4] == 1);
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
    }

    private static boolean isInteger(double d) {
        long l = (long)d;
        return (double)l == d;
    }

    private static boolean fitsInFloat(double d) {
        float f = (float)d;
        return (double)f == d;
    }

    private static boolean fitsInFloat(long l) {
        float f = l;
        return (long)f == l;
    }

    private static boolean fitsInDouble(long l) {
        double d = l;
        return (long)d == l;
    }

    public byte[] TtoByte(T t) {
        switch (this.type) {
            case 0: {
                int[] nArray = (int[])t;
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.size * nArray.length).order(this.byteOrder);
                switch (this.geo[3]) {
                    case 0: {
                        for (int i = 0; i < nArray.length; ++i) {
                            byteBuffer.put((byte)(nArray[i] != 0 ? 1 : 0));
                        }
                        break;
                    }
                    case 1: {
                        if (this.lossless) {
                            for (int i = 0; i < nArray.length; ++i) {
                                if (nArray[i] < 0 || nArray[i] > 255) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                byteBuffer.put((byte)nArray[i]);
                            }
                        } else {
                            for (int i = 0; i < nArray.length; ++i) {
                                byte by = (byte)Math.max(Math.min(nArray[i], 255), 0);
                                byteBuffer.put(by);
                            }
                        }
                        break;
                    }
                    case 2: {
                        CharBuffer charBuffer = byteBuffer.asCharBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < nArray.length; ++i) {
                                if (nArray[i] < 0 || nArray[i] > 65535) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                charBuffer.put((char)nArray[i]);
                            }
                        } else {
                            for (int i = 0; i < nArray.length; ++i) {
                                char c = (char)Math.max(Math.min(nArray[i], 65535), 0);
                                charBuffer.put(c);
                            }
                        }
                        break;
                    }
                    case 3: {
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < nArray.length; ++i) {
                                if (nArray[i] < Short.MIN_VALUE || nArray[i] > Short.MAX_VALUE) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                shortBuffer.put((short)nArray[i]);
                            }
                        } else {
                            for (int i = 0; i < nArray.length; ++i) {
                                short s = (short)Math.max(Math.min(nArray[i], Short.MAX_VALUE), Short.MIN_VALUE);
                                shortBuffer.put(s);
                            }
                        }
                        break;
                    }
                    case 4: {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        intBuffer.put(nArray);
                        break;
                    }
                    case 5: {
                        LongBuffer longBuffer = byteBuffer.asLongBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            longBuffer.put(nArray[i]);
                        }
                        break;
                    }
                    case 6: {
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            if (!TypeConverter.fitsInFloat(nArray[i]) && this.lossless) {
                                throw new LackOfPrecisionError("Lack of precision with one pixel");
                            }
                            floatBuffer.put(nArray[i]);
                        }
                        break;
                    }
                    case 7: {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            doubleBuffer.put(nArray[i]);
                        }
                        break;
                    }
                }
                return byteBuffer.array();
            }
            case 1: {
                long[] lArray = (long[])t;
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.size * lArray.length).order(this.byteOrder);
                switch (this.geo[3]) {
                    case 0: {
                        for (int i = 0; i < lArray.length; ++i) {
                            byteBuffer.put((byte)(lArray[i] != 0L ? 1 : 0));
                        }
                        break;
                    }
                    case 1: {
                        if (this.lossless) {
                            for (int i = 0; i < lArray.length; ++i) {
                                if (lArray[i] < 0L || lArray[i] > 255L) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                byteBuffer.put((byte)lArray[i]);
                            }
                        } else {
                            for (int i = 0; i < lArray.length; ++i) {
                                byte by = (byte)Math.max(Math.min(lArray[i], 255L), 0L);
                                byteBuffer.put(by);
                            }
                        }
                        break;
                    }
                    case 2: {
                        CharBuffer charBuffer = byteBuffer.asCharBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < lArray.length; ++i) {
                                if (lArray[i] < 0L || lArray[i] > 65535L) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                charBuffer.put((char)lArray[i]);
                            }
                        } else {
                            for (int i = 0; i < lArray.length; ++i) {
                                char c = (char)Math.max(Math.min(lArray[i], 65535L), 0L);
                                charBuffer.put(c);
                            }
                        }
                        break;
                    }
                    case 3: {
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < lArray.length; ++i) {
                                if (lArray[i] < -32768L || lArray[i] > 32767L) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                shortBuffer.put((short)lArray[i]);
                            }
                        } else {
                            for (int i = 0; i < lArray.length; ++i) {
                                short s = (short)Math.max(Math.min(lArray[i], 32767L), -32768L);
                                shortBuffer.put(s);
                            }
                        }
                        break;
                    }
                    case 4: {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < lArray.length; ++i) {
                                if (lArray[i] < Integer.MIN_VALUE || lArray[i] > Integer.MAX_VALUE) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                intBuffer.put((int)lArray[i]);
                            }
                        } else {
                            for (int i = 0; i < lArray.length; ++i) {
                                int n = (int)Math.max(Math.min(lArray[i], Integer.MAX_VALUE), Integer.MIN_VALUE);
                                intBuffer.put(n);
                            }
                        }
                        break;
                    }
                    case 5: {
                        byteBuffer.asLongBuffer().put(lArray);
                        break;
                    }
                    case 6: {
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        for (int i = 0; i < lArray.length; ++i) {
                            if (!TypeConverter.fitsInFloat(lArray[i]) && this.lossless) {
                                throw new LackOfPrecisionError("Lack of precision with one pixel");
                            }
                            floatBuffer.put(lArray[i]);
                        }
                        break;
                    }
                    case 7: {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        for (int i = 0; i < lArray.length; ++i) {
                            if (!TypeConverter.fitsInDouble(lArray[i]) && this.lossless) {
                                throw new LackOfPrecisionError("Lack of precision with one pixel");
                            }
                            doubleBuffer.put(lArray[i]);
                        }
                        break;
                    }
                }
                return byteBuffer.array();
            }
            case 2: {
                float[] fArray = (float[])t;
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.size * fArray.length).order(this.byteOrder);
                switch (this.geo[3]) {
                    case 0: {
                        for (int i = 0; i < fArray.length; ++i) {
                            byteBuffer.put((byte)(fArray[i] != 0.0f ? 1 : 0));
                        }
                        break;
                    }
                    case 1: {
                        if (this.lossless) {
                            for (int i = 0; i < fArray.length; ++i) {
                                if (fArray[i] < 0.0f || fArray[i] > 255.0f) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                if (!TypeConverter.isInteger(fArray[i])) {
                                    throw new LackOfPrecisionError("Lack of precision with one pixel");
                                }
                                byteBuffer.put((byte)fArray[i]);
                            }
                        } else {
                            for (int i = 0; i < fArray.length; ++i) {
                                byte by = (byte)Math.max(Math.min(fArray[i], 255.0f), 0.0f);
                                byteBuffer.put(by);
                            }
                        }
                        break;
                    }
                    case 2: {
                        CharBuffer charBuffer = byteBuffer.asCharBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < fArray.length; ++i) {
                                if (fArray[i] < 0.0f || fArray[i] > 65535.0f) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                if (!TypeConverter.isInteger(fArray[i])) {
                                    throw new LackOfPrecisionError("Lack of precision with one pixel");
                                }
                                charBuffer.put((char)fArray[i]);
                            }
                        } else {
                            for (int i = 0; i < fArray.length; ++i) {
                                char c = (char)Math.max(Math.min(fArray[i], 65535.0f), 0.0f);
                                charBuffer.put(c);
                            }
                        }
                        break;
                    }
                    case 3: {
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < fArray.length; ++i) {
                                if (fArray[i] < -32768.0f || fArray[i] > 32767.0f) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                if (!TypeConverter.isInteger(fArray[i])) {
                                    throw new LackOfPrecisionError("Lack of precision with one pixel");
                                }
                                shortBuffer.put((short)fArray[i]);
                            }
                        } else {
                            for (int i = 0; i < fArray.length; ++i) {
                                short s = (short)Math.max(Math.min(fArray[i], 32767.0f), -32768.0f);
                                shortBuffer.put(s);
                            }
                        }
                        break;
                    }
                    case 4: {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < fArray.length; ++i) {
                                if (fArray[i] < -2.1474836E9f || fArray[i] > 2.1474836E9f) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                if (!TypeConverter.isInteger(fArray[i])) {
                                    throw new LackOfPrecisionError("Lack of precision with one pixel");
                                }
                                intBuffer.put((int)fArray[i]);
                            }
                        } else {
                            for (int i = 0; i < fArray.length; ++i) {
                                int n = (int)Math.max(Math.min(fArray[i], 2.1474836E9f), -2.1474836E9f);
                                intBuffer.put(n);
                            }
                        }
                        break;
                    }
                    case 5: {
                        LongBuffer longBuffer = byteBuffer.asLongBuffer();
                        if (this.lossless) {
                            for (int i = 0; i < fArray.length; ++i) {
                                if (fArray[i] < -9.223372E18f || fArray[i] > 9.223372E18f) {
                                    throw new LackOfPrecisionError("Pixel out of range");
                                }
                                if (!TypeConverter.isInteger(fArray[i])) {
                                    throw new LackOfPrecisionError("Lack of precision with one pixel");
                                }
                                longBuffer.put((long)fArray[i]);
                            }
                        } else {
                            for (int i = 0; i < fArray.length; ++i) {
                                long l = (long)Math.max(Math.min(fArray[i], 9.223372E18f), -9.223372E18f);
                                longBuffer.put(l);
                            }
                        }
                        break;
                    }
                    case 6: {
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        floatBuffer.put(fArray);
                        break;
                    }
                    case 7: {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        for (int i = 0; i < fArray.length; ++i) {
                            doubleBuffer.put(fArray[i]);
                        }
                        break;
                    }
                }
                return byteBuffer.array();
            }
        }
        return null;
    }

    public T bytetoT(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(this.byteOrder);
        int n = this.geo[3];
        switch (this.type) {
            case 0: {
                int[] nArray = new int[byArray.length / this.size];
                switch (n) {
                    case 0: {
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = byteBuffer.get() == 0 ? 0 : 1;
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = byteBuffer.get();
                        }
                        break;
                    }
                    case 2: {
                        CharBuffer charBuffer = byteBuffer.asCharBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = charBuffer.get() & 0xFFFF;
                        }
                        break;
                    }
                    case 3: {
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = shortBuffer.get();
                        }
                        break;
                    }
                    case 4: {
                        byteBuffer.asIntBuffer().get(nArray);
                        break;
                    }
                    case 5: {
                        LongBuffer longBuffer = byteBuffer.asLongBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            long l = longBuffer.get();
                            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                                throw new LackOfPrecisionError("Pixel out of range");
                            }
                            nArray[i] = (int)l;
                        }
                        break;
                    }
                    case 6: {
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            float f = floatBuffer.get();
                            if (f < -2.1474836E9f || f > 2.1474836E9f) {
                                throw new LackOfPrecisionError("Pixel out of range");
                            }
                            if (!TypeConverter.isInteger(f) && this.lossless) {
                                throw new LackOfPrecisionError("Lack of precision with one pixel");
                            }
                            nArray[i] = (int)f;
                        }
                        break;
                    }
                    case 7: {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            double d = doubleBuffer.get();
                            if (d < -2.147483648E9 || d > 2.147483647E9) {
                                throw new LackOfPrecisionError("Pixel out of range");
                            }
                            if (!TypeConverter.isInteger(d) && this.lossless) {
                                throw new LackOfPrecisionError("Lack of precision with one pixel");
                            }
                            nArray[i] = (int)d;
                        }
                        break;
                    }
                }
                return (T)nArray;
            }
            case 1: {
                long[] lArray = new long[byArray.length / this.size];
                switch (n) {
                    case 0: {
                        for (int i = 0; i < lArray.length; ++i) {
                            lArray[i] = byteBuffer.get() == 0 ? 0L : 1L;
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < lArray.length; ++i) {
                            lArray[i] = byteBuffer.get();
                        }
                        break;
                    }
                    case 2: {
                        CharBuffer charBuffer = byteBuffer.asCharBuffer();
                        for (int i = 0; i < lArray.length; ++i) {
                            lArray[i] = charBuffer.get() & 0xFFFF;
                        }
                        break;
                    }
                    case 3: {
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        for (int i = 0; i < lArray.length; ++i) {
                            lArray[i] = shortBuffer.get();
                        }
                        break;
                    }
                    case 4: {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        for (int i = 0; i < lArray.length; ++i) {
                            lArray[i] = intBuffer.get();
                        }
                        break;
                    }
                    case 5: {
                        byteBuffer.asLongBuffer().get(lArray);
                        break;
                    }
                    case 6: {
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        for (int i = 0; i < lArray.length; ++i) {
                            float f = floatBuffer.get();
                            if (f < -9.223372E18f || f > 9.223372E18f) {
                                throw new LackOfPrecisionError("Pixel out of range");
                            }
                            if (!TypeConverter.isInteger(f) && this.lossless) {
                                throw new LackOfPrecisionError("Lack of precision with one pixel");
                            }
                            lArray[i] = (long)f;
                        }
                        break;
                    }
                    case 7: {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        for (int i = 0; i < lArray.length; ++i) {
                            double d = doubleBuffer.get();
                            if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                                throw new LackOfPrecisionError("Pixel out of range");
                            }
                            if (!TypeConverter.isInteger(d) && this.lossless) {
                                throw new LackOfPrecisionError("Lack of precision with one pixel");
                            }
                            lArray[i] = (long)d;
                        }
                        break;
                    }
                }
                return (T)lArray;
            }
            case 2: {
                float[] fArray = new float[byArray.length / this.size];
                switch (n) {
                    case 0: {
                        for (int i = 0; i < fArray.length; ++i) {
                            fArray[i] = byteBuffer.get() == 0 ? 0.0f : 1.0f;
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < fArray.length; ++i) {
                            fArray[i] = byteBuffer.get();
                        }
                        break;
                    }
                    case 2: {
                        CharBuffer charBuffer = byteBuffer.asCharBuffer();
                        for (int i = 0; i < fArray.length; ++i) {
                            fArray[i] = charBuffer.get() & 0xFFFF;
                        }
                        break;
                    }
                    case 3: {
                        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                        for (int i = 0; i < fArray.length; ++i) {
                            fArray[i] = shortBuffer.get();
                        }
                        break;
                    }
                    case 4: {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        for (int i = 0; i < fArray.length; ++i) {
                            fArray[i] = intBuffer.get();
                        }
                        break;
                    }
                    case 5: {
                        LongBuffer longBuffer = byteBuffer.asLongBuffer();
                        for (int i = 0; i < fArray.length; ++i) {
                            fArray[i] = longBuffer.get();
                        }
                        break;
                    }
                    case 6: {
                        byteBuffer.asFloatBuffer().get(fArray);
                        break;
                    }
                    case 7: {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        for (int i = 0; i < fArray.length; ++i) {
                            double d = doubleBuffer.get();
                            if (d < -3.4028234663852886E38 || d > 3.4028234663852886E38) {
                                throw new LackOfPrecisionError("Pixel out of range");
                            }
                            if (!TypeConverter.fitsInFloat(d) && this.lossless) {
                                throw new LackOfPrecisionError("Lack of precision with one pixel");
                            }
                            fArray[i] = (float)d;
                        }
                        break;
                    }
                }
                return (T)fArray;
            }
        }
        return null;
    }
}

