/*
 * Decompiled with CFR 0.152.
 */
package GiciFile;

import GiciException.ParameterException;
import GiciException.WarningException;
import GiciFile.JaiWrapper;
import GiciFile.SaveRawFile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class SaveFile {
    public static void SaveFileFormat(float[][][] fArray, String string, int n) throws WarningException {
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        float[][] fArray2 = new float[n2][n3 * n4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n4; ++k) {
                    fArray2[i][j * n4 + k] = fArray[i][j][k];
                }
            }
        }
        DataBufferFloat dataBufferFloat = new DataBufferFloat(fArray2, n3 * n4);
        Raster raster = JaiWrapper.createRaster(n4, n3, n2, dataBufferFloat);
        BufferedImage bufferedImage = null;
        switch (n2) {
            case 1: {
                bufferedImage = new BufferedImage(n4, n3, 10);
                break;
            }
            case 3: {
                bufferedImage = new BufferedImage(n4, n3, 5);
                break;
            }
            default: {
                throw new WarningException("This format only supports 1 or 3 components.");
            }
        }
        bufferedImage.setData(raster);
        switch (n) {
            case 0: {
                JaiWrapper.jaiSave(bufferedImage, string, "PNM");
                break;
            }
            case 1: {
                JaiWrapper.jaiSave(bufferedImage, string, "TIFF");
                break;
            }
            case 2: {
                JaiWrapper.jaiSave(bufferedImage, string, "PNG");
                break;
            }
            case 3: {
                JaiWrapper.jaiSave(bufferedImage, string, "JPEG");
                break;
            }
            case 4: {
                JaiWrapper.jaiSave(bufferedImage, string, "BMP");
                break;
            }
            default: {
                throw new WarningException("Format file unrecognized.");
            }
        }
        fArray2 = null;
        dataBufferFloat = null;
        bufferedImage = null;
    }

    public static void SaveFileRaw(float[][][] fArray, String string, int n, int n2) throws WarningException {
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            if (file.exists()) {
                file.delete();
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WarningException("File \"" + string + "\" can not be open.");
        }
        catch (IOException iOException) {
            throw new WarningException("I/O error saving file \"" + string + "\".");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        String string2 = "";
        int n5 = string.lastIndexOf(".");
        if (n5 >= 0) {
            string2 = string.substring(string.lastIndexOf(".") + 1, string.length());
        }
        if (string2.compareToIgnoreCase("pgm") == 0) {
            String string3 = "P5\n" + String.valueOf(n4) + " " + String.valueOf(n3) + "\n";
            string3 = n == 1 ? string3 + "255\n" : string3 + "65535\n";
            try {
                dataOutputStream.writeBytes(string3);
            }
            catch (IOException iOException) {
                throw new WarningException("I/O error saving file \"" + string + "\".");
            }
            finally {
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new WarningException("I/O error saving file \"" + string + "\".");
                }
            }
        }
        try {
            SaveRawFile.saveRawData(fArray, dataOutputStream, n, n2);
        }
        catch (IOException iOException) {
            throw new WarningException("I/O error saving file \"" + string + "\".");
        }
        try {
            dataOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new WarningException("Error closing file \"" + string + "\".");
        }
    }

    public static void SaveFileExtension(float[][][] fArray, int[] nArray, String string, int[] nArray2) throws WarningException {
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (n < 0) {
            throw new WarningException("The file does not have any extension.");
        }
        string2 = string.substring(string.lastIndexOf(".") + 1, string.length());
        int n2 = -1;
        if (string2.compareToIgnoreCase("pnm") == 0) {
            n2 = 0;
        } else if (string2.compareToIgnoreCase("pgm") == 0) {
            n2 = 0;
        } else if (string2.compareToIgnoreCase("ppm") == 0) {
            n2 = 0;
        } else if (string2.compareToIgnoreCase("tiff") == 0) {
            n2 = 1;
        } else if (string2.compareToIgnoreCase("tif") == 0) {
            n2 = 1;
        } else if (string2.compareToIgnoreCase("png") == 0) {
            n2 = 2;
        } else if (string2.compareToIgnoreCase("jpg") == 0) {
            n2 = 3;
        } else if (string2.compareToIgnoreCase("jpeg") == 0) {
            n2 = 3;
        } else if (string2.compareToIgnoreCase("bmp") == 0) {
            n2 = 4;
        } else if (string2.compareToIgnoreCase("raw") == 0) {
            n2 = -1;
        } else if (string2.compareToIgnoreCase("img") == 0) {
            n2 = -1;
        }
        int n3 = fArray.length;
        int n4 = fArray[0].length;
        int n5 = fArray[0][0].length;
        float[][][] fArray2 = new float[n3][n4][n5];
        if (n2 >= 0 && n2 <= 4) {
            int n6;
            for (n6 = 0; n6 < n3; ++n6) {
                if (nArray[n6] <= 8) continue;
                throw new WarningException("This format only allow a bit depth <= 8 bits.");
            }
            if (n3 != 1 && n3 != 3) {
                throw new WarningException("This format only allow 1 or 3 image components.");
            }
            for (n6 = 0; n6 < fArray.length; ++n6) {
                for (int i = 0; i < fArray[n6].length; ++i) {
                    for (int j = 0; j < fArray[n6][i].length; ++j) {
                        fArray2[n6][i][j] = Math.round(fArray[n6][i][j]);
                    }
                }
            }
            SaveFile.SaveFileFormat(fArray2, string, n2);
        } else {
            if (nArray2 == null) {
                throw new WarningException("Trying to save to a raw file without specifying geometry.");
            }
            if (nArray2[0] < 6) {
                n3 = fArray.length;
                n4 = fArray[0].length;
                n5 = fArray[0][0].length;
                fArray2 = new float[n3][n4][n5];
                for (int i = 0; i < fArray.length; ++i) {
                    for (int j = 0; j < fArray[i].length; ++j) {
                        for (int k = 0; k < fArray[i][j].length; ++k) {
                            fArray2[i][j][k] = Math.round(fArray[i][j][k]);
                        }
                    }
                }
                SaveFile.SaveFileRaw(fArray2, string, nArray2[0], nArray2[1]);
            }
            SaveFile.SaveFileRaw(fArray, string, nArray2[0], nArray2[1]);
        }
        fArray2 = null;
    }

    public static void SaveFileByExtension(float[][][] fArray, String string, int[] nArray) throws WarningException, ParameterException {
        int n = SaveFile.getFormat(string);
        if (n >= 0 && n <= 4) {
            if (nArray != null && n == 0 && nArray[3] != 1) {
                throw new WarningException("PGM, PNM and PPM format only support 8 bits per pixel.");
            }
            SaveFile.SaveFileFormat(fArray, string, n);
        } else if (n == 5) {
            if (nArray == null) {
                throw new ParameterException("To store in raw format imageGeometry is mandatory.");
            }
            if (nArray.length != 6) {
                throw new ParameterException("Incorrect number of parameters in imageGeometry.");
            }
            int n2 = nArray[3];
            int n3 = nArray[4];
            SaveFile.SaveFileRaw(fArray, string, n2, n3);
        } else {
            throw new WarningException("The file does not have any known extension.");
        }
    }

    public static void SaveFileByExtensionAndName(float[][][] fArray, String string, int[] nArray, String string2) throws WarningException, ParameterException {
        int n;
        int n2 = SaveFile.getFormat(string);
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = new int[nArray.length + 1];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = nArray[n];
            }
            nArray2[nArray.length] = 0;
        }
        if (n2 >= 0 && n2 <= 4) {
            if (nArray2 != null && n2 == 0 && nArray2[3] != 1) {
                throw new WarningException("PGM, PNM and PPM format only support 8 bits per pixel.");
            }
            SaveFile.SaveFileFormat(fArray, string2, n2);
        } else if (n2 == 5) {
            if (nArray2 == null) {
                throw new ParameterException("To store in raw format imageGeometry is mandatory.");
            }
            if (nArray2.length != 6) {
                throw new ParameterException("Incorrect number of parameters in imageGeometry.");
            }
            n = nArray2[3];
            int n3 = nArray2[4];
            SaveFile.SaveFileRaw(fArray, string2, n, n3);
        } else {
            throw new WarningException("The file does not have any known extension.");
        }
    }

    public static int getFormat(String string) throws WarningException {
        String string2 = "";
        int n = string.lastIndexOf(".");
        int n2 = -1;
        if (n >= 0) {
            string2 = string.substring(string.lastIndexOf(".") + 1, string.length());
            if (string2.compareToIgnoreCase("pnm") == 0) {
                n2 = 0;
            } else if (string2.compareToIgnoreCase("pgm") == 0) {
                n2 = 0;
            } else if (string2.compareToIgnoreCase("ppm") == 0) {
                n2 = 0;
            } else if (string2.compareToIgnoreCase("tiff") == 0) {
                n2 = 1;
            } else if (string2.compareToIgnoreCase("tif") == 0) {
                n2 = 1;
            } else if (string2.compareToIgnoreCase("png") == 0) {
                n2 = 2;
            } else if (string2.compareToIgnoreCase("jpg") == 0) {
                n2 = 3;
            } else if (string2.compareToIgnoreCase("jpeg") == 0) {
                n2 = 3;
            } else if (string2.compareToIgnoreCase("bmp") == 0) {
                n2 = 4;
            } else if (string2.compareToIgnoreCase("raw") == 0) {
                n2 = 5;
            } else if (string2.compareToIgnoreCase("img") == 0) {
                n2 = 5;
            }
        } else {
            throw new WarningException("The file does not have any extension.");
        }
        return n2;
    }
}

