/*
 * Decompiled with CFR 0.152.
 */
package GiciImageExtension;

import GiciException.ParameterException;

public class ImageDeExtension {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int zOriginalSize;
    int yOriginalSize;
    int xOriginalSize;
    boolean parametersSet = false;

    public ImageDeExtension(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
    }

    public void setParameters(int n, int n2, int n3) {
        this.parametersSet = true;
        this.xOriginalSize = n;
        this.yOriginalSize = n2;
        this.zOriginalSize = n3;
    }

    public float[][][] run() throws Exception {
        if (!this.parametersSet) {
            throw new ParameterException("ImageDeExtension cannot run if parameters are not set.");
        }
        float[][][] fArray = new float[this.zOriginalSize][this.yOriginalSize][this.xOriginalSize];
        int n = this.imageSamples.length;
        if (n < this.zOriginalSize) {
            throw new ParameterException("zOriginalSize parameter was not properly set.");
        }
        for (int i = 0; i < this.zOriginalSize; ++i) {
            int n2 = this.imageSamples[i].length;
            if (n2 < this.yOriginalSize) {
                throw new ParameterException("yOriginalSize parameter was not properly set.");
            }
            for (int j = 0; j < this.yOriginalSize; ++j) {
                int n3 = this.imageSamples[i][j].length;
                if (n3 < this.xOriginalSize) {
                    throw new ParameterException("xOriginalSize parameter was not properly set.");
                }
                for (int k = 0; k < this.xOriginalSize; ++k) {
                    fArray[i][j][k] = this.imageSamples[i][j][k];
                }
            }
        }
        return fArray;
    }
}

