/*
 * Decompiled with CFR 0.152.
 */
package GiciMask;

import GiciException.ErrorException;
import GiciStream.BitStream;

public class QuadTreeEncoding {
    protected boolean parameters = false;
    protected int zSize = 0;
    protected int ySize = 0;
    protected int xSize = 0;
    protected int blockWidth = 0;
    protected int blockHeight = 0;
    protected byte[][][] mask = null;
    protected BitStream bs = null;

    public QuadTreeEncoding(byte[][][] byArray) {
        this.mask = byArray;
        this.zSize = byArray.length;
        this.ySize = byArray[0].length;
        this.xSize = byArray[0][0].length;
        this.bs = new BitStream();
    }

    public void setParameters(int n, int n2) throws ErrorException {
        this.parameters = true;
        if (n < 0 || n2 < 0) {
            throw new ErrorException("Block dimensions to encoding the mask must be positives: " + n + " " + n2);
        }
        this.blockWidth = n;
        this.blockHeight = n2;
    }

    public void encodeMask() throws ErrorException {
        if (!this.parameters) {
            throw new ErrorException("Parameters must be set to encode the mask.");
        }
        int n = (int)Math.pow(2.0, this.blockWidth);
        int n2 = (int)Math.pow(2.0, this.blockHeight);
        int n3 = (int)Math.ceil((double)this.xSize / (double)n);
        int n4 = (int)Math.ceil((double)this.ySize / (double)n2);
        for (int i = 0; i < this.zSize; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n5 = k * n;
                    int n6 = j * n2;
                    this.bs.addBitStream(this.encodeBlock(i, n5, n6, n, n2));
                }
            }
        }
    }

    protected BitStream encodeBlock(int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        BitStream bitStream = new BitStream();
        if (n2 >= this.xSize || n3 >= this.ySize) {
            return bitStream;
        }
        byte by = this.mask[n][n3][n2];
        for (int i = n3; i < n3 + n5; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                if (j >= this.xSize || i >= this.ySize || this.mask[n][i][j] == by) continue;
                bl = true;
                bitStream.addBits(2, 2);
                bitStream.addBitStream(this.encodeBlock(n, n2, n3, n4 / 2, n5 / 2));
                bitStream.addBitStream(this.encodeBlock(n, n2 + n4 / 2, n3, n4 / 2, n5 / 2));
                bitStream.addBitStream(this.encodeBlock(n, n2, n3 + n5 / 2, n4 / 2, n5 / 2));
                bitStream.addBitStream(this.encodeBlock(n, n2 + n4 / 2, n3 + n5 / 2, n4 / 2, n5 / 2));
                i = n3 + n5;
                j = n2 + n4;
            }
        }
        if (!bl) {
            bitStream.addBits(by, 2);
        }
        return bitStream;
    }

    public BitStream getBs() {
        return this.bs;
    }
}

