/*
 * Decompiled with CFR 0.152.
 */
package GiciMatrix;

import GiciMatrix.MatrixAlgebra;

public class QRDecomposition {
    private float[][] a;
    private float[][] q;
    private float[][] r;
    private boolean ran = false;

    public QRDecomposition(float[][] fArray) {
        this.a = MatrixAlgebra.copy(fArray);
        this.q = MatrixAlgebra.identityUH(fArray.length);
    }

    private void applyGivensRotationRows(float[][] fArray, int n, int n2, double d, double d2) {
        int n3 = Math.min(fArray[n].length, fArray[n2].length);
        int n4 = Math.max(fArray[n].length - fArray[n2].length, 0);
        int n5 = Math.max(fArray[n2].length - fArray[n].length, 0);
        for (int i = 0; i < n3; ++i) {
            float f = fArray[n][i + n4];
            float f2 = fArray[n2][i + n5];
            fArray[n][i + n4] = (float)(d * (double)f + d2 * (double)f2);
            fArray[n2][i + n5] = (float)(-d2 * (double)f + d * (double)f2);
        }
    }

    private void applyGivensRotationCols(float[][] fArray, int n, int n2, double d, double d2) {
        int n3 = Math.min(fArray.length, Math.min(n, n2) + 2);
        for (int i = 0; i < n3; ++i) {
            int n4 = Math.max(i - 1, 0);
            float f = fArray[i][n - n4];
            float f2 = fArray[i][n2 - n4];
            fArray[i][n - n4] = (float)(d * (double)f + d2 * (double)f2);
            fArray[i][n2 - n4] = (float)(-d2 * (double)f + d * (double)f2);
        }
    }

    private double[] getCandS(double d, double d2) {
        double[] dArray = new double[]{0.0, 0.0};
        if (Math.abs(d2) < (double)1.4E-45f) {
            dArray[0] = -Math.signum(d);
            dArray[1] = 0.0;
        } else if (Math.abs(d) < (double)1.4E-45f) {
            dArray[0] = 0.0;
            dArray[1] = -Math.signum(d2);
        } else if (Math.abs(d) > Math.abs(d2)) {
            double d3 = d2 / d;
            double d4 = Math.copySign(Math.sqrt(1.0 + d3 * d3), d);
            dArray[0] = 1.0 / d4;
            dArray[1] = d3 / d4;
        } else {
            double d5 = d / d2;
            double d6 = Math.copySign(Math.sqrt(1.0 + d5 * d5), d2);
            dArray[1] = 1.0 / d6;
            dArray[0] = d5 / d6;
        }
        return dArray;
    }

    public final void run() {
        this.ran = true;
        double d = (double)(this.a[this.a.length - 2][1] - this.a[this.a.length - 1][1]) / 2.0;
        double d2 = this.a[this.a.length - 1][0] * this.a[this.a.length - 1][0];
        double d3 = (double)this.a[this.a.length - 1][1] - d2 / (d + Math.copySign(Math.sqrt(d * d + d2), d));
        double d4 = (double)this.a[0][0] - d3;
        double d5 = this.a[1][0];
        for (int i = 0; i < this.a.length - 1; ++i) {
            double[] dArray = this.getCandS(d4, d5);
            double d6 = dArray[0];
            double d7 = dArray[1];
            this.applyGivensRotationRows(this.a, i, i + 1, d6, d7);
            this.applyGivensRotationCols(this.q, i, i + 1, d6, d7);
            this.a[i + 1][0] = 0.0f;
            if (i + 1 >= this.a.length - 1) continue;
            d4 = this.a[i + 1][1];
            d5 = this.a[i + 2][0];
        }
        this.r = MatrixAlgebra.cutUHUT(this.a);
    }

    public final float[][] getQ() {
        assert (this.ran);
        return this.q;
    }

    public final float[][] getR() {
        assert (this.ran);
        return this.r;
    }
}

