/*
 * Decompiled with CFR 0.152.
 */
package GiciParallel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BatchExecutorService<T> {
    private static ThreadPoolExecutor tpe = null;
    private static Thread angelThreadInstance = null;
    private Queue<Future<T>> localTasks = new ConcurrentLinkedQueue<Future<T>>();
    private static final ThreadLocal<Boolean> sonOfABES = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchExecutorService() {
        Class<BatchExecutorService> clazz = BatchExecutorService.class;
        synchronized (BatchExecutorService.class) {
            if (tpe == null) {
                tpe = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
                angelThreadInstance = new AngelThread();
                angelThreadInstance.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<BatchExecutorService> clazz = BatchExecutorService.class;
                        synchronized (BatchExecutorService.class) {
                            if (tpe != null) {
                                tpe.shutdown();
                                tpe = null;
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            angelThreadInstance.interrupt();
                            return;
                        }
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final void submitAndRememberFuture(final Callable<T> callable) {
        this.localTasks.add(tpe.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Boolean bl = sonOfABES.get();
                sonOfABES.set(true);
                Object v = callable.call();
                sonOfABES.set(bl);
                return v;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final List<T> awaitAllLocalTasks() {
        ArrayList arrayList = new ArrayList();
        try {
            Object object;
            Boolean bl = sonOfABES.get();
            if (bl.booleanValue()) {
                System.out.println("increase");
                object = BatchExecutorService.class;
                // MONITORENTER : GiciParallel.BatchExecutorService.class
                tpe.setCorePoolSize(tpe.getMaximumPoolSize() + 1);
                tpe.setMaximumPoolSize(tpe.getMaximumPoolSize() + 1);
                // MONITOREXIT : object
            }
            while ((object = this.localTasks.poll()) != null) {
                arrayList.add(object.get());
            }
            if (bl == false) return arrayList;
            Class<BatchExecutorService> clazz = BatchExecutorService.class;
            // MONITORENTER : GiciParallel.BatchExecutorService.class
            tpe.setCorePoolSize(tpe.getMaximumPoolSize() - 1);
            tpe.setMaximumPoolSize(tpe.getMaximumPoolSize() - 1);
            // MONITOREXIT : clazz
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new Error("Error in parallel execution handler (Thread Interrupted)");
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            executionException.getCause().printStackTrace();
            throw new Error("Error in parallel execution handler (thread threw interruption)");
        }
        finally {
            this.localTasks.clear();
        }
    }

    private class AngelThread
    extends Thread {
        private AngelThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int n = 0;
            while (tpe != null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean bl = false;
                Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
                for (Thread thread : map.keySet()) {
                    if (!thread.getName().equals("DestroyJavaVM")) continue;
                    bl = true;
                }
                if (!bl) continue;
                Class<BatchExecutorService> clazz = BatchExecutorService.class;
                // MONITORENTER : GiciParallel.BatchExecutorService.class
                if (tpe != null) {
                    ++n;
                }
                if (n > 2) {
                    System.err.println("Is your application not exiting with System.exit()?");
                    System.err.println("ShutDownHooks required by a BatchExecutorService are not getting called because of that.");
                    System.err.println("Trying to shutdown a ThreadPoolExecutor forcefully.");
                    System.err.println("Trutly yours, your angel thread.");
                    tpe.shutdown();
                    tpe = null;
                }
                // MONITOREXIT : clazz
            }
        }
    }
}

