/*
 * Decompiled with CFR 0.152.
 */
package GiciParser;

import GiciException.ErrorException;
import GiciException.ParameterException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ArgumentsParser {
    String[][] argumentsSpecification = null;

    public void parse(String[][] stringArray, String[] stringArray2, Object object, Method method) throws ParameterException, ErrorException {
        int n;
        int n2;
        int n3;
        this.argumentsSpecification = stringArray;
        int n4 = 0;
        int[] nArray = new int[stringArray.length];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            nArray[n3] = 0;
        }
        while (n4 < stringArray2.length) {
            n3 = this.argFind(stringArray2[n4]);
            if (n3 != -1) {
                int n5 = n3;
                nArray[n5] = nArray[n5] + 1;
                for (n2 = n4 + 1; n2 < stringArray2.length && this.argFind(stringArray2[n2]) == -1; ++n2) {
                }
                n = n2 - n4;
                String[] stringArray3 = new String[n];
                System.arraycopy(stringArray2, n4, stringArray3, 0, n);
                n4 = n2;
                try {
                    method.invoke(object, n3, stringArray3);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ErrorException("Illegal access invocating parse argument function.");
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new ParameterException("Wrong parameters for argument \"" + stringArray3[0] + "\": " + invocationTargetException.getCause().getLocalizedMessage());
                }
            }
            throw new ParameterException("Argument \"" + stringArray2[n4] + "\" unrecognized.");
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n2 = 0;
            n = 0;
            try {
                n2 = Integer.parseInt(stringArray[n3][4]);
                n = Integer.parseInt(stringArray[n3][5]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ErrorException("Malformed arguments specification.");
            }
            if (nArray[n3] < n2) {
                throw new ParameterException("Argument \"" + stringArray[n3][0] + "\" must must appear " + n2 + " times minimum  (\"-h\" displays help).");
            }
            if (n <= 0 || nArray[n3] <= n) continue;
            throw new ParameterException("Argument \"" + stringArray[n3][0] + "\" can appear " + n + " times maximum (\"-h\" displays help).");
        }
    }

    protected int argFind(String string) {
        int n = 0;
        boolean bl = false;
        while (n < this.argumentsSpecification.length && !bl) {
            if (string.compareTo(this.argumentsSpecification[n][0]) == 0 || string.compareTo(this.argumentsSpecification[n][1]) == 0) {
                bl = true;
                continue;
            }
            ++n;
        }
        return bl ? n : -1;
    }

    public void showArgsInfo() {
        System.out.println("Arguments specification: ");
        for (int i = 0; i < this.argumentsSpecification.length; ++i) {
            char c = '{';
            char c2 = '}';
            if (this.argumentsSpecification[i][4].compareTo("0") == 0) {
                c = '[';
                c2 = ']';
            }
            System.out.print("\n" + c + " ");
            System.out.print("{" + this.argumentsSpecification[i][0] + "|" + this.argumentsSpecification[i][1] + "} " + this.argumentsSpecification[i][2]);
            System.out.println(" " + c2);
            System.out.println("  Explanation:\n    " + this.argumentsSpecification[i][6]);
            System.out.println("  Default value: " + this.argumentsSpecification[i][3]);
            String string = "";
            string = this.argumentsSpecification[i][5].compareTo("0") == 0 ? "inf" : this.argumentsSpecification[i][5];
            System.out.println("  Minimum/Maximum occurences: " + this.argumentsSpecification[i][4] + "/" + string);
        }
    }

    public void showArgsInfoLatexTable() {
        for (int i = 0; i < this.argumentsSpecification.length; ++i) {
            System.out.println("\\begin{center}\\begin{tabular}{|rr|rl|rl|}");
            String string = this.argumentsSpecification[i][1].replace("-", "$-$");
            String string2 = this.argumentsSpecification[i][0].replace("-", "$-$");
            String string3 = this.argumentsSpecification[i][2].replace("{", "$\\{$").replace("}", "$\\}$").replace("[", "$[$").replace("]", "$]$");
            String string4 = this.argumentsSpecification[i][4].compareTo("0") == 0 ? "No" : "Yes";
            String string5 = this.argumentsSpecification[i][5].compareTo("0") == 0 ? "$\\infty$" : this.argumentsSpecification[i][5];
            String string6 = this.argumentsSpecification[i][6].replace("\n", "\\newline").replace("    ", " ");
            String string7 = this.argumentsSpecification[i][3];
            System.out.println("\\hline\n\\multicolumn{2}{|l|}{\\textbf{" + string + "}} & \\multicolumn{4}{|l|}{" + string3 + "} \\\\\n\\cline{3-6}");
            System.out.println("\\multicolumn{2}{|l|}{\\textbf{" + string2 + "}} & \\emph{Mandatory:} & " + string4 + " & \\emph{Max reps:} & " + string5 + " \\\\\n\\hline");
            System.out.println("\\emph{Explanation:} & \\multicolumn{5}{|p{12cm}|}{" + string6 + "} \\\\\n\\hline");
            System.out.println("\\emph{Default:} & \\multicolumn{5}{|p{12cm}|}{" + string7 + "} \\\\\n\\hline");
            System.out.println("\\end{tabular}\\end{center}");
        }
    }

    public boolean parseBoolean(String[] stringArray) throws ParameterException {
        boolean bl = false;
        if (stringArray.length == 2) {
            try {
                int n = Integer.parseInt(stringArray[1]);
                if (n < 0 || n > 1) {
                    throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" must be 0 or 1.");
                }
                bl = n != 0;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        return bl;
    }

    public int parseIntegerPositive(String[] stringArray) throws ParameterException {
        int n;
        block4: {
            n = 0;
            if (stringArray.length == 2) {
                try {
                    n = Integer.parseInt(stringArray[1]);
                    if (n < 0) {
                        throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is must be a positive integer.");
                    }
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
                }
            }
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        return n;
    }

    public int parseInteger(String[] stringArray) throws ParameterException {
        int n = 0;
        if (stringArray.length == 2) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        return n;
    }

    public long parseLongPositive(String[] stringArray) throws ParameterException {
        long l;
        block4: {
            l = 0L;
            if (stringArray.length == 2) {
                try {
                    l = Long.parseLong(stringArray[1]);
                    if (l < 0L) {
                        throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is must be a positive long.");
                    }
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is not a parsable long.");
                }
            }
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        return l;
    }

    public float parseFloatPositive(String[] stringArray) throws ParameterException {
        float f;
        block4: {
            f = 0.0f;
            if (stringArray.length == 2) {
                try {
                    f = Float.parseFloat(stringArray[1]);
                    if (f < 0.0f) {
                        throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is must be a positive float.");
                    }
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is not a parsable float.");
                }
            }
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        return f;
    }

    public String parseString(String[] stringArray) throws ParameterException {
        String string = "";
        if (stringArray.length != 2) {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        string = stringArray[1];
        return string;
    }

    public String[] parseStrings(String[] stringArray) throws ParameterException {
        String[] stringArray2 = null;
        if (stringArray.length != 2) {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        stringArray2 = stringArray[1].split(",");
        return stringArray2;
    }

    String[] parseStringArray(String[] stringArray, int n) throws Exception {
        String[] stringArray2 = new String[n];
        if (stringArray.length == n + 1) {
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[1 + i];
            }
        } else {
            throw new Exception("Argument \"" + stringArray[0] + "\" takes " + n + " option. Try \"-h\" to display help.");
        }
        return stringArray2;
    }

    public boolean[] parseBooleanArray(String[] stringArray, int n) throws ParameterException {
        boolean[] blArray = null;
        if (stringArray.length == n + 1) {
            blArray = new boolean[stringArray.length - 1];
            int[] nArray = new int[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    nArray[i - 1] = Integer.parseInt(stringArray[i]);
                    if (nArray[i - 1] < 0 || nArray[i - 1] > 1) {
                        throw new ParameterException("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" must be 0 or 1.");
                    }
                    blArray[i - 1] = nArray[i - 1] != 0;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
                }
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes " + n + " options. Try \"-h\" to display help.");
        }
        return blArray;
    }

    public int[] parseIntegerArray(String[] stringArray) throws ParameterException {
        int[] nArray = null;
        if (stringArray.length >= 2) {
            nArray = new int[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    nArray[i - 1] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
                }
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one or more options. Try \"-h\" to display help.");
        }
        return nArray;
    }

    public int[] parseIntegerArray(String[] stringArray, int n) throws ParameterException {
        int[] nArray = null;
        if (stringArray.length == n + 1) {
            nArray = new int[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    nArray[i - 1] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
                }
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes " + n + " options. Try \"-h\" to display help.");
        }
        return nArray;
    }

    public long[] parseLongArray(String[] stringArray) throws ParameterException {
        long[] lArray = null;
        if (stringArray.length >= 2) {
            lArray = new long[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    lArray[i - 1] = Long.parseLong(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable long.");
                }
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one or more options. Try \"-h\" to display help.");
        }
        return lArray;
    }

    public long[] parseLongArray(String[] stringArray, int n) throws ParameterException {
        long[] lArray = null;
        if (stringArray.length == n + 1) {
            lArray = new long[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    lArray[i - 1] = Long.parseLong(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable long.");
                }
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes " + n + " options. Try \"-h\" to display help.");
        }
        return lArray;
    }

    public float[] parseFloatArray(String[] stringArray) throws ParameterException {
        float[] fArray = null;
        if (stringArray.length >= 2) {
            fArray = new float[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    fArray[i - 1] = Float.parseFloat(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable float.");
                }
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes one or more options. Try \"-h\" to display help.");
        }
        return fArray;
    }

    public float[] parseFloatArray(String[] stringArray, int n) throws ParameterException {
        float[] fArray = null;
        if (stringArray.length == n + 1) {
            fArray = new float[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    fArray[i - 1] = Float.parseFloat(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterException("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable float.");
                }
            }
        } else {
            throw new ParameterException("Argument \"" + stringArray[0] + "\" takes " + n + " options. Try \"-h\" to display help.");
        }
        return fArray;
    }
}

