/*
 * Decompiled with CFR 0.152.
 */
package GiciStream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends FilterOutputStream {
    private static final int BITS_PER_BYTE = 8;
    private static final int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private int buffer = 0;
    private int bitsToGo = 8;

    public BitOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void flush() throws IOException {
        if (this.bitsToGo != 8) {
            this.out.write(this.buffer << this.bitsToGo);
            this.buffer = 0;
            this.bitsToGo = 8;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void write(int n, int n2) throws IOException {
        if (n > 32 || n < 0) {
            throw new RuntimeException("BitInputStream can only write from 0 to 32 bits.");
        }
        n2 &= bmask[n];
        while (n >= this.bitsToGo) {
            this.buffer = this.buffer << this.bitsToGo | n2 >>> n - this.bitsToGo;
            this.out.write(this.buffer);
            n2 &= bmask[n - this.bitsToGo];
            n -= this.bitsToGo;
            this.bitsToGo = 8;
            this.buffer = 0;
        }
        if (n > 0) {
            this.buffer = this.buffer << n | n2;
            this.bitsToGo -= n;
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.write(n, 8);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            this.write(byArray[i]);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }
}

