/*
 * Decompiled with CFR 0.152.
 */
package GiciStream;

import GiciException.WarningException;

public class BitStream {
    byte[] bitBuffer = null;
    long numBits;
    long actualPosition;
    int buffAllocation = 64;

    public BitStream() {
        this.bitBuffer = new byte[this.buffAllocation];
        this.numBits = 0L;
        this.actualPosition = 0L;
    }

    public BitStream(int n) {
        this.bitBuffer = new byte[n / 8];
        this.buffAllocation = n / 8;
        this.numBits = 0L;
        this.actualPosition = 0L;
    }

    public BitStream(byte[] byArray) {
        this.bitBuffer = byArray;
        this.numBits = 8 * byArray.length;
        this.actualPosition = 0L;
    }

    public void addBit(boolean bl) {
        int n = (int)(this.numBits / 8L);
        if (bl) {
            int n2 = 1;
            n2 = (byte)(n2 << (int)(7L - this.numBits % 8L));
            int n3 = n;
            this.bitBuffer[n3] = (byte)(this.bitBuffer[n3] | n2);
        }
        ++this.numBits;
        if (this.numBits / 8L == (long)this.bitBuffer.length) {
            byte[] byArray = new byte[this.bitBuffer.length + this.buffAllocation];
            for (int i = 0; i < this.bitBuffer.length; ++i) {
                byArray[i] = this.bitBuffer[i];
            }
            this.bitBuffer = byArray;
        }
    }

    public void addBit(int n) {
        if (n == 0) {
            this.addBit(false);
        } else {
            this.addBit(true);
        }
    }

    public void addByte(int n) {
        for (int i = 7; i >= 0; --i) {
            this.addBit(n & 1 << i);
        }
    }

    public void addBits(int n, int n2) {
        for (int i = n2 - 1; i >= 0; --i) {
            this.addBit(n & 1 << i);
        }
    }

    public void addBitStream(BitStream bitStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        byte[] byArray = null;
        if (bitStream != null) {
            byArray = bitStream.getBitStream();
            l = bitStream.getNumBits() / 8L;
            n = (int)(bitStream.getNumBits() % 8L);
            n3 = 0;
            while ((long)n3 < l) {
                this.addByte(byArray[n3]);
                ++n3;
            }
            for (int i = 7; i > 7 - n; --i) {
                n2 = 1 << i;
                this.addBit(byArray[n3] & n2);
            }
        }
    }

    public void deleteEndBit() {
        this.deleteEndBits(1L);
    }

    public void deleteEndBits(long l) {
        int n;
        int n2 = (int)((this.numBits - 1L) / 8L);
        this.numBits = this.numBits - l < 0L ? 0L : this.numBits - l;
        int n3 = (int)((this.numBits - 1L) / 8L);
        int n4 = (int)(this.numBits % 8L);
        if (n4 > 0) {
            int n5;
            n = 1;
            for (n5 = 1; n5 < n4; ++n5) {
                n = (byte)((n << 1) + 1);
            }
            while (n5 < 8) {
                n = (byte)(n << 1);
                ++n5;
            }
            int n6 = n3;
            this.bitBuffer[n6] = (byte)(this.bitBuffer[n6] & n);
        }
        for (n = n3 + 1; n <= n2; ++n) {
            this.bitBuffer[n] = 0;
        }
    }

    public void deleteBeginBit() throws WarningException {
        this.deleteBeginBits(1L);
    }

    public void deleteBeginBits(long l) throws WarningException {
        if (l < this.numBits) {
            BitStream bitStream = new BitStream();
            for (long i = l; i < this.numBits; ++i) {
                bitStream.addBit(this.getBit(i));
            }
            this.bitBuffer = bitStream.getBitStream();
            this.numBits -= l;
            this.actualPosition = 0L;
        } else {
            this.bitBuffer = new byte[this.buffAllocation];
            this.numBits = 0L;
            this.actualPosition = 0L;
        }
    }

    public boolean getBit(long l) throws WarningException {
        if (l >= 0L && l < this.numBits) {
            int n = (int)(l / 8L);
            byte by = this.bitBuffer[n];
            int n2 = 1;
            return ((n2 = (int)((byte)(n2 << (int)(7L - l % 8L)))) & by) != 0;
        }
        throw new WarningException("Bit number must be between 0 and number of bits of bitstream.");
    }

    public boolean getBit() throws WarningException {
        return this.getBit(this.actualPosition++);
    }

    public int getBits(int n) throws WarningException {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 1;
            if (!this.getBit()) continue;
            ++n2;
        }
        return n2;
    }

    public byte[] getBitStream() {
        return this.bitBuffer;
    }

    public long getNumBits() {
        return this.numBits;
    }

    public byte getByte(int n) throws WarningException {
        if (n >= 0 && (long)n < this.getNumBytes()) {
            return this.bitBuffer[n];
        }
        throw new WarningException("Byte number must be between 0 and number of bytes of bytestream.");
    }

    public long getNumBytes() {
        return this.numBits <= 0L ? 0L : (this.numBits - 1L) / 8L + 1L;
    }

    public long getActualPosition() {
        return this.actualPosition;
    }

    public void reset() {
        this.bitBuffer = null;
        this.bitBuffer = new byte[this.buffAllocation];
        this.numBits = 0L;
        this.actualPosition = 0L;
    }

    public void rewindBits(long l) throws WarningException {
        if (this.actualPosition >= l && l > 0L) {
            this.actualPosition -= l;
        } else {
            throw new WarningException("It is not possible to rewind this number of bits, since it is greater than the available");
        }
    }
}

