/*
 * Decompiled with CFR 0.152.
 */
package GiciStream;

import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class BufferedDataInputStream
implements DataInput {
    private ReentrantLock lock = null;
    private volatile byte[] buf = null;
    private int pos;
    private int count;
    private int offset;
    private RandomAccessFile file = null;
    private long filePos;
    private boolean EOFInBuffer;
    private boolean readFromFile;
    private static int DEFAULT_BUFFER_SIZE = 1000;
    private static int DEFAULT_EXPECTED_LINE_LENGTH = 80;

    public BufferedDataInputStream(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n];
        this.count = 0;
        this.offset = 0;
        this.filePos = 0L;
        this.pos = 0;
        this.readFromFile = false;
        this.lock = new ReentrantLock();
    }

    public BufferedDataInputStream(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.buf = byArray;
        this.count = byArray.length;
        this.offset = 0;
        this.filePos = 0L;
        this.pos = 0;
        this.readFromFile = false;
        this.lock = new ReentrantLock();
    }

    public BufferedDataInputStream(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.buf = byArray;
        this.count = this.buf.length - n + 1;
        this.offset = n;
        this.filePos = 0L;
        this.pos = n;
        this.readFromFile = false;
        this.lock = new ReentrantLock();
    }

    public BufferedDataInputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null);
    }

    public BufferedDataInputStream(File file) throws FileNotFoundException {
        this(new RandomAccessFile(file, "r"));
    }

    public BufferedDataInputStream(RandomAccessFile randomAccessFile) throws FileNotFoundException {
        this.file = randomAccessFile;
        this.buf = new byte[DEFAULT_BUFFER_SIZE];
        this.count = 0;
        this.offset = 0;
        this.filePos = 0L;
        this.pos = 0;
        this.readFromFile = true;
        this.lock = new ReentrantLock();
    }

    public int read() throws EOFException, IOException {
        return this.read1() & 0xFF;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws EOFException, IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n2 > 0) {
            if (this.pos < this.count) {
                n3 = Math.min(this.count - this.pos, n2);
                System.arraycopy(this.buf, this.pos, byArray, n, n3);
                this.pos += n3;
                n += n3;
                n2 -= n3;
                continue;
            }
            if (this.EOFInBuffer) {
                throw new EOFException();
            }
            this.readBuffer();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.skipBytes((long)n);
        return 0;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return false;
    }

    @Override
    public byte readByte() throws EOFException, IOException {
        return (byte)this.read1();
    }

    @Override
    public int readUnsignedByte() throws EOFException, IOException {
        return this.read1();
    }

    @Override
    public short readShort() throws EOFException, IOException {
        return (short)(this.read1() << 8 | this.read1());
    }

    @Override
    public int readUnsignedShort() throws EOFException, IOException {
        return this.read1() << 8 | this.read1();
    }

    @Override
    public char readChar() throws EOFException, IOException {
        return (char)(this.read1() << 8 | this.read1());
    }

    @Override
    public int readInt() throws EOFException, IOException {
        return this.read1() << 24 | this.read1() << 16 | this.read1() << 8 | this.read1();
    }

    @Override
    public long readLong() throws EOFException, IOException {
        return (long)this.read1() << 56 | (long)this.read1() << 48 | (long)this.read1() << 40 | (long)this.read1() << 32 | (long)this.read1() << 24 | (long)this.read1() << 16 | (long)this.read1() << 8 | (long)this.read1();
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        return this.readLine(true, false);
    }

    @Override
    public String readUTF() throws IOException {
        return null;
    }

    public String readUTF(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return new String(byArray, "UTF8");
    }

    String readLine(boolean bl, boolean bl2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl && !bl2) {
            throw new IllegalArgumentException("Both arguments cannot be false at time");
        }
        if (this.length() <= 0L) {
            return null;
        }
        boolean bl3 = false;
        while (!bl3) {
            char c;
            char c2 = (char)this.read1();
            while (this.length() > 0L && c2 != '\r' && c2 != '\n') {
                stringBuffer.append(c2);
                c2 = (char)this.read1();
            }
            if (this.length() == 0L) break;
            if (c2 == '\n') {
                if (bl2) continue;
                bl3 = true;
                continue;
            }
            if (c2 != '\r' || bl || (c = (char)this.read1()) == '\n') continue;
            this.seek(this.getPos() - 1L);
        }
        return stringBuffer.toString();
    }

    public void seek(long l) throws IOException {
        if (this.readFromFile) {
            this.filePos = l;
            this.file.seek(this.filePos);
            this.count = 0;
            this.readBuffer();
        } else {
            if (l < (long)this.offset || l > (long)this.count) {
                throw new IndexOutOfBoundsException();
            }
            this.pos = (int)l;
        }
    }

    public long getPos() {
        if (this.readFromFile) {
            return this.filePos + (long)this.pos;
        }
        return this.pos;
    }

    public long skipBytes(long l) throws IOException {
        long l2 = l;
        if (l < 0L) {
            throw new IOException();
        }
        if (this.readFromFile) {
            if (l > this.length()) {
                l2 = 0L;
            } else if ((long)this.pos + l < (long)this.count) {
                this.pos = (int)((long)this.pos + l);
            } else {
                this.filePos += (long)this.pos + l;
                this.file.seek(this.filePos);
                this.count = 0;
                this.readBuffer();
            }
        } else {
            if ((long)this.offset + l > (long)this.count) {
                throw new IndexOutOfBoundsException();
            }
            this.pos = (int)((long)this.pos + l);
        }
        return l2;
    }

    public int getCapacity() {
        return this.buf.length;
    }

    public long available() throws IOException {
        return this.count - this.pos;
    }

    public long length() {
        if (this.readFromFile) {
            try {
                return this.file.length() - (this.filePos + (long)this.pos);
            }
            catch (IOException iOException) {
                return -1L;
            }
        }
        return this.count - this.pos;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.lock.tryLock(l, timeUnit);
    }

    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public String toString() {
        Object object = "";
        object = this.readFromFile ? (String)object + "Data source: FILE\n" : (String)object + "Data source: BUFFER\n";
        object = (String)object + "Length: " + this.count + "\n";
        object = (String)object + "Offset: " + this.offset + "\n";
        object = (String)object + "DATA: ";
        for (int i = 0; i < this.buf.length; ++i) {
            if ((0xFF & this.buf[i]) < 16) {
                object = (String)object + "0";
            }
            object = (String)object + Integer.toHexString(0xFF & this.buf[i]);
        }
        object = (String)object + "\n";
        return object;
    }

    public void list(PrintStream printStream) {
        printStream.println("-- Buffered Data Input Stream --");
        printStream.println("Not implemented yet!");
        printStream.flush();
    }

    private final int read1() throws IOException, EOFException {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        if (this.EOFInBuffer) {
            this.pos = this.count + 1;
            throw new EOFException();
        }
        if (this.readFromFile) {
            this.readBuffer();
            return this.read1();
        }
        throw new EOFException();
    }

    private void readBuffer() throws EOFException, IOException {
        this.filePos += (long)this.count;
        this.offset = 0;
        this.pos = 0;
        if (this.filePos >= this.file.length()) {
            throw new EOFException();
        }
        this.file.seek(this.filePos);
        this.count = this.file.read(this.buf, 0, this.buf.length);
        if (this.count == -1) {
            this.count = 0;
            this.EOFInBuffer = true;
        } else {
            this.EOFInBuffer = this.count < this.buf.length;
        }
    }
}

