/*
 * Decompiled with CFR 0.152.
 */
package GiciStream;

import GiciException.WarningException;

public class ByteStream {
    private byte[] byteBuffer = null;
    private int index = -1;
    private final int initialBuffAllocation = 8;
    private final int maxBuffAllocation = 512;

    public ByteStream() {
        this.byteBuffer = new byte[8];
    }

    public ByteStream(int n) {
        this.byteBuffer = new byte[n];
    }

    public ByteStream(byte[] byArray, int n) {
        this.byteBuffer = byArray;
        this.index = n - 1;
    }

    public void addByte(byte by) {
        ++this.index;
        if (this.index == this.byteBuffer.length) {
            byte[] byArray = null;
            byArray = this.byteBuffer.length < 512 ? new byte[this.byteBuffer.length + this.byteBuffer.length] : new byte[this.byteBuffer.length + 512];
            System.arraycopy(this.byteBuffer, 0, byArray, 0, this.byteBuffer.length);
            this.byteBuffer = byArray;
        }
        this.byteBuffer[this.index] = by;
    }

    public void addBytes(byte[] byArray, int n) {
        if (this.index + n >= this.byteBuffer.length) {
            byte[] byArray2 = new byte[this.byteBuffer.length + n + (this.byteBuffer.length + n >= 512 ? 512 : this.byteBuffer.length + n)];
            System.arraycopy(this.byteBuffer, 0, byArray2, 0, this.index + 1);
            this.byteBuffer = byArray2;
        }
        System.arraycopy(byArray, 0, this.byteBuffer, this.index + 1, n);
        this.index += n;
    }

    public void deleteEndBytes(int n) {
        this.index = this.index - n < -1 ? -1 : this.index - n;
    }

    public void deleteBeginBytes(int n) {
        if (n <= this.index) {
            byte[] byArray = new byte[this.byteBuffer.length];
            System.arraycopy(this.byteBuffer, n, byArray, 0, this.index + 1 - n);
            this.byteBuffer = byArray;
            this.index -= n;
        } else {
            this.index = -1;
        }
    }

    public byte getByte(int n) throws WarningException {
        if (n >= 0 && n <= this.index) {
            return this.byteBuffer[n];
        }
        throw new WarningException("Byte number must be between 0 and number of bytes of bytestream.");
    }

    public byte[] getByteStream() {
        return this.byteBuffer;
    }

    public int getNumBytes() {
        return this.index + 1;
    }
}

