/*
 * Decompiled with CFR 0.152.
 */
package GiciStream;

import GiciException.WarningException;
import GiciStream.BitStream;
import java.nio.ByteBuffer;

public class IODataStream {
    public static void writeBoolean(BitStream bitStream, boolean bl) {
        bitStream.addBit(bl);
    }

    public static boolean readBoolean(BitStream bitStream) throws WarningException {
        return bitStream.getBit();
    }

    public static void writeByte(BitStream bitStream, byte by) {
        for (int i = 7; i >= 0; --i) {
            bitStream.addBit((by & (byte)(1 << i)) != 0);
        }
    }

    public static byte readByte(BitStream bitStream) throws WarningException {
        byte by = 0;
        for (int i = 7; i >= 0; --i) {
            if (!bitStream.getBit()) continue;
            by = (byte)(by | (byte)(1 << i));
        }
        return by;
    }

    public static void writeShort(BitStream bitStream, short s) {
        for (int i = 15; i >= 0; --i) {
            bitStream.addBit((s & (short)(1 << i)) != 0);
        }
    }

    public static short readShort(BitStream bitStream) throws WarningException {
        short s = 0;
        for (int i = 15; i >= 0; --i) {
            if (!bitStream.getBit()) continue;
            s = (short)(s | (short)(1 << i));
        }
        return s;
    }

    public static void writeInteger(BitStream bitStream, int n) {
        for (int i = 31; i >= 0; --i) {
            bitStream.addBit((n & 1 << i) != 0);
        }
    }

    public static int readInteger(BitStream bitStream) throws WarningException {
        int n = 0;
        for (int i = 31; i >= 0; --i) {
            if (!bitStream.getBit()) continue;
            n |= 1 << i;
        }
        return n;
    }

    public static void writeLong(BitStream bitStream, long l) {
        for (long i = 63L; i >= 0L; --i) {
            bitStream.addBit((l & 1L << (int)i) != 0L);
        }
    }

    public static long readLong(BitStream bitStream) throws WarningException {
        long l = 0L;
        for (long i = 63L; i >= 0L; --i) {
            if (!bitStream.getBit()) continue;
            l |= 1L << (int)i;
        }
        return l;
    }

    public static void writeFloat(BitStream bitStream, float f) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.asFloatBuffer().put(f);
        for (int i = 0; i < 4; ++i) {
            IODataStream.writeByte(bitStream, byteBuffer.get(i));
        }
    }

    public static float readFloat(BitStream bitStream) throws WarningException {
        float f = 0.0f;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        for (int i = 0; i < 4; ++i) {
            byteBuffer.put(IODataStream.readByte(bitStream));
        }
        byteBuffer.rewind();
        f = byteBuffer.getFloat();
        return f;
    }

    public static void writeDouble(BitStream bitStream, double d) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.asDoubleBuffer().put(d);
        for (int i = 0; i < 8; ++i) {
            IODataStream.writeByte(bitStream, byteBuffer.get(i));
        }
    }

    public static double readDouble(BitStream bitStream) throws WarningException {
        double d = 0.0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        for (int i = 0; i < 8; ++i) {
            byteBuffer.put(IODataStream.readByte(bitStream));
        }
        byteBuffer.rewind();
        d = byteBuffer.getDouble();
        return d;
    }

    public static void writeBitsUnsignedInteger(BitStream bitStream, int n, int n2) throws WarningException {
        if (n > 0 && (double)n2 < Math.log(n) / Math.log(2.0)) {
            throw new WarningException("The value cannot be saved with the passed number of bits.");
        }
        if (n < 0) {
            throw new WarningException("Only positive values allowed.");
        }
        for (int i = n2 - 1; i >= 0; --i) {
            bitStream.addBit((n & 1 << i) != 0);
        }
    }

    public static int readBitsUnsignedInteger(BitStream bitStream, int n) throws WarningException {
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            if (!bitStream.getBit()) continue;
            n2 |= 1 << i;
        }
        return n2;
    }

    public static void writeBitsSignedInteger(BitStream bitStream, int n, int n2) throws WarningException {
        bitStream.addBit(n < 0);
        IODataStream.writeBitsUnsignedInteger(bitStream, Math.abs(n), n2 - 1);
    }

    public static int readBitsSignedInteger(BitStream bitStream, int n) throws WarningException {
        int n2 = bitStream.getBit() ? -1 : 1;
        int n3 = IODataStream.readBitsUnsignedInteger(bitStream, n - 1);
        return n3 * n2;
    }
}

