/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class ColourTransform {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int ICCType;
    int ICCforward;
    static float[][] SRGB_for = new float[][]{{3.2406f, -1.5372f, -0.4986f}, {-0.9689f, 1.8758f, 0.0415f}, {0.0557f, -0.204f, 1.057f}};
    static float[][] SRGB_inv = new float[][]{{0.4124f, 0.3576f, 0.1805f}, {0.2126f, 0.7152f, 0.0722f}, {0.0193f, 0.1192f, 0.9505f}};
    boolean parametersSet = false;

    public ColourTransform(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int n, int n2) {
        this.parametersSet = true;
        this.ICCType = n;
        this.ICCforward = n2;
    }

    public float[][][] run() throws ErrorException {
        block7: {
            block6: {
                if (!this.parametersSet) {
                    throw new ErrorException("Parameters not set.");
                }
                if (this.ICCType == 0) break block6;
                switch (this.ICCType) {
                    case 1: {
                        if (this.ICCforward == 1) {
                            this.ICCforwardTransformSRGB();
                        } else {
                            this.ICCinverseTransformSRGB();
                        }
                        break block7;
                    }
                    default: {
                        throw new ErrorException("Unrecognized colour transform type.");
                    }
                }
            }
            throw new ErrorException("Unrecognized colour transform type.");
        }
        return this.imageSamples;
    }

    public void ICCforwardTransformSRGB() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.ySize; ++n4) {
            for (n3 = 0; n3 < this.xSize; ++n3) {
                float f = this.imageSamples[0][n4][n3];
                float f2 = this.imageSamples[1][n4][n3];
                float f3 = this.imageSamples[2][n4][n3];
                for (n2 = 0; n2 < 3; ++n2) {
                    this.imageSamples[n2][n4][n3] = f * SRGB_for[n2][0] + f2 * SRGB_for[n2][1] + f3 * SRGB_for[n2][2];
                }
            }
        }
        n4 = 0;
        n3 = 0;
        for (n = 0; n < this.ySize; ++n) {
            for (int i = 0; i < this.xSize; ++i) {
                if (this.imageSamples[0][n][i] == 255.0f && this.imageSamples[1][n][i] == 255.0f && this.imageSamples[2][n][i] == 255.0f) {
                    ++n4;
                }
                if (this.imageSamples[0][n][i] == 0.0f && this.imageSamples[1][n][i] == 0.0f && this.imageSamples[2][n][i] == 0.0f) {
                    ++n3;
                }
                for (int j = 0; j < this.zSize; ++j) {
                    if ((double)this.imageSamples[j][n][i] <= 0.0031308) {
                        float[] fArray = this.imageSamples[j][n];
                        int n5 = i;
                        fArray[n5] = (float)((double)fArray[n5] * 12.92);
                        continue;
                    }
                    this.imageSamples[j][n][i] = (float)(1.055 * Math.pow(this.imageSamples[j][n][i], 0.4166666666666667) - 0.055);
                }
            }
        }
        n = n4 - n3;
        for (int i = 0; i < this.ySize; ++i) {
            for (int j = 0; j < this.xSize; ++j) {
                for (n2 = 0; n2 < this.zSize; ++n2) {
                    this.imageSamples[n2][i][j] = ((float)n * this.imageSamples[n2][i][j] + (float)n3) * 255.0f;
                }
            }
        }
    }

    public void ICCinverseTransformSRGB() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < 5; ++n3) {
            for (n2 = 0; n2 < 5; ++n2) {
                System.out.println("(" + this.imageSamples[0][n3][n2] + "," + this.imageSamples[1][n3][n2] + "," + this.imageSamples[2][n3][n2] + ")");
            }
        }
        for (n3 = 0; n3 < this.ySize; ++n3) {
            for (n2 = 0; n2 < this.xSize; ++n2) {
                for (n = 0; n < this.zSize; ++n) {
                    float[] fArray = this.imageSamples[n][n3];
                    int n4 = n2;
                    fArray[n4] = fArray[n4] / 255.0f;
                }
            }
        }
        for (n3 = 0; n3 < this.ySize; ++n3) {
            for (n2 = 0; n2 < this.xSize; ++n2) {
                for (n = 0; n < this.zSize; ++n) {
                    if ((double)this.imageSamples[n][n3][n2] <= 0.04045) {
                        float[] fArray = this.imageSamples[n][n3];
                        int n5 = n2;
                        fArray[n5] = (float)((double)fArray[n5] / 12.92);
                        continue;
                    }
                    this.imageSamples[n][n3][n2] = (float)Math.pow(((double)this.imageSamples[n][n3][n2] + 0.055) / 1.055, 2.4);
                }
            }
        }
        for (n3 = 0; n3 < this.ySize; ++n3) {
            for (n2 = 0; n2 < this.xSize; ++n2) {
                float f = this.imageSamples[0][n3][n2];
                float f2 = this.imageSamples[1][n3][n2];
                float f3 = this.imageSamples[2][n3][n2];
                for (int i = 0; i < 3; ++i) {
                    this.imageSamples[i][n3][n2] = f * SRGB_inv[i][0] + f2 * SRGB_inv[i][1] + f3 * SRGB_inv[i][2];
                }
            }
        }
        for (n3 = 0; n3 < this.ySize; ++n3) {
            for (n2 = 0; n2 < this.xSize; ++n2) {
                for (int i = 0; i < this.zSize; ++i) {
                    float[] fArray = this.imageSamples[i][n3];
                    int n6 = n2;
                    fArray[n6] = fArray[n6] / 255.0f;
                }
            }
        }
    }
}

