/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class DPCMSpectralDecorrelator {
    float[][][] imageSamples = null;

    public DPCMSpectralDecorrelator(float[][][] fArray) {
        this.imageSamples = fArray;
    }

    public float[][][] forwardDPCM() throws ErrorException {
        int n = this.imageSamples.length;
        int n2 = this.imageSamples[0].length;
        int n3 = this.imageSamples[0][0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = n - 1; k > 0; --k) {
                    float[] fArray = this.imageSamples[k][i];
                    int n4 = j;
                    fArray[n4] = fArray[n4] - this.imageSamples[k - 1][i][j];
                }
            }
        }
        return this.imageSamples;
    }

    public float[][][] inverseDPCM() throws ErrorException {
        int n = this.imageSamples.length;
        int n2 = this.imageSamples[0].length;
        int n3 = this.imageSamples[0][0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 1; k < n; ++k) {
                    float[] fArray = this.imageSamples[k][i];
                    int n4 = j;
                    fArray[n4] = fArray[n4] + this.imageSamples[k - 1][i][j];
                }
            }
        }
        return this.imageSamples;
    }

    public float[][][] forwardDPCM(int n) throws ErrorException {
        int n2 = this.imageSamples.length;
        int n3 = this.imageSamples[0].length;
        int n4 = this.imageSamples[0][0].length;
        if (n == 0) {
            n = n2;
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = n2 - 1; k > 0; --k) {
                    if (k % n == 0) continue;
                    float[] fArray = this.imageSamples[k][i];
                    int n5 = j;
                    fArray[n5] = fArray[n5] - this.imageSamples[k - 1][i][j];
                }
            }
        }
        return this.imageSamples;
    }

    public float[][][] inverseDPCM(int n) throws ErrorException {
        int n2 = this.imageSamples.length;
        int n3 = this.imageSamples[0].length;
        int n4 = this.imageSamples[0][0].length;
        if (n == 0) {
            n = n2;
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 1; k < n2; ++k) {
                    if (k % n == 0) continue;
                    float[] fArray = this.imageSamples[k][i];
                    int n5 = j;
                    fArray[n5] = fArray[n5] + this.imageSamples[k - 1][i][j];
                }
            }
        }
        return this.imageSamples;
    }

    public float[][][] forwardDC() throws ErrorException {
        int n = this.imageSamples.length;
        int n2 = this.imageSamples[0].length;
        int n3 = this.imageSamples[0][0].length;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                f2 = this.imageSamples[0][i][j];
                for (int k = 1; k < n; ++k) {
                    f = f2;
                    f2 = this.imageSamples[k][i][j];
                    this.imageSamples[k][i][j] = f2 - f;
                }
            }
        }
        return this.imageSamples;
    }

    public float[][][] inverseDC() throws ErrorException {
        int n = this.imageSamples.length;
        int n2 = this.imageSamples[0].length;
        int n3 = this.imageSamples[0][0].length;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 1; k < n; ++k) {
                    f = this.imageSamples[k - 1][i][j];
                    f2 = this.imageSamples[k][i][j];
                    this.imageSamples[k][i][j] = f2 + f;
                }
            }
        }
        return this.imageSamples;
    }

    public float[][][] forwardDifferentialReference(int n) throws ErrorException {
        int n2 = this.imageSamples.length;
        int n3 = this.imageSamples[0].length;
        int n4 = this.imageSamples[0][0].length;
        if (n < 0 || n >= n2) {
            throw new ErrorException("Reference index is not is the proper range");
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (k == n) continue;
                    float[] fArray = this.imageSamples[k][i];
                    int n5 = j;
                    fArray[n5] = fArray[n5] - this.imageSamples[n][i][j];
                }
            }
        }
        return this.imageSamples;
    }

    public float[][][] inverseDifferentialReference(int n) throws ErrorException {
        int n2 = this.imageSamples.length;
        int n3 = this.imageSamples[0].length;
        int n4 = this.imageSamples[0][0].length;
        if (n < 0 || n >= n2) {
            throw new ErrorException("Reference index is not is the proper range");
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (k == n) continue;
                    float[] fArray = this.imageSamples[k][i];
                    int n5 = j;
                    fArray[n5] = fArray[n5] + this.imageSamples[n][i][j];
                }
            }
        }
        return this.imageSamples;
    }
}

