/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;
import GiciTransform.ForwardDWTCore;

public class ForwardNonPyramidal3D {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] WTTypes = null;
    int[] WTLevels = null;
    int WTOrder;
    int WTModel;
    boolean parametersSet = false;

    public ForwardNonPyramidal3D(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = 4;
        this.WTModel = 1;
    }

    public void setParameters(int[] nArray, int[] nArray2, int n, int n2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = n;
        this.WTModel = n2;
    }

    public float[][][] run() throws ErrorException {
        ForwardDWTCore forwardDWTCore;
        block58: {
            if (!this.parametersSet) {
                throw new ErrorException("Parameters not set.");
            }
            int n = this.xSize;
            int n2 = this.ySize;
            int n3 = this.zSize;
            if (this.WTLevels[0] < 0 || this.WTLevels[1] < 0 || this.WTLevels[2] < 0) {
                throw new ErrorException("All the transform levels to apply must be no negative.");
            }
            forwardDWTCore = new ForwardDWTCore(this.imageSamples);
            block0 : switch (this.WTModel) {
                case 0: {
                    switch (this.WTOrder) {
                        case 0: {
                            int n4;
                            if (this.WTLevels[0] != this.WTLevels[1]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions.");
                            }
                            for (n4 = 0; n4 < this.WTLevels[0]; ++n4) {
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, n2 - 1, 0, n - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n2 - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n = n / 2 + n % 2;
                                n2 = n2 / 2 + n2 % 2;
                            }
                            for (n4 = 0; n4 < this.WTLevels[2]; ++n4) {
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, this.ySize - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n3 = n3 / 2 + n3 % 2;
                            }
                            break block0;
                        }
                        case 1: {
                            int n5;
                            if (this.WTLevels[0] != this.WTLevels[2]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            for (n5 = 0; n5 < this.WTLevels[0]; ++n5) {
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n = n / 2 + n % 2;
                                n3 = n3 / 2 + n3 % 2;
                            }
                            for (n5 = 0; n5 < this.WTLevels[1]; ++n5) {
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n2 = n2 / 2 + n2 % 2;
                            }
                            break block0;
                        }
                        case 2: {
                            int n6;
                            if (this.WTLevels[1] != this.WTLevels[0]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            for (n6 = 0; n6 < this.WTLevels[1]; ++n6) {
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n2 - 1, 0, n - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, n2 - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n2 = n2 / 2 + n2 % 2;
                                n = n / 2 + n % 2;
                            }
                            for (n6 = 0; n6 < this.WTLevels[2]; ++n6) {
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, this.ySize - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n3 = n3 / 2 + n3 % 2;
                            }
                            break block0;
                        }
                        case 3: {
                            int n7;
                            if (this.WTLevels[1] != this.WTLevels[2]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            for (n7 = 0; n7 < this.WTLevels[1]; ++n7) {
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n2 = n2 / 2 + n2 % 2;
                                n3 = n3 / 2 + n3 % 2;
                            }
                            for (n7 = 0; n7 < this.WTLevels[0]; ++n7) {
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n = n / 2 + n % 2;
                            }
                            break block0;
                        }
                        case 4: {
                            int n8;
                            if (this.WTLevels[2] != this.WTLevels[0]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            for (n8 = 0; n8 < this.WTLevels[2]; ++n8) {
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n3 = n3 / 2 + n3 % 2;
                                n = n / 2 + n % 2;
                            }
                            for (n8 = 0; n8 < this.WTLevels[1]; ++n8) {
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n2 = n2 / 2 + n2 % 2;
                            }
                            break block0;
                        }
                        case 5: {
                            int n9;
                            if (this.WTLevels[2] != this.WTLevels[1]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            for (n9 = 0; n9 < this.WTLevels[2]; ++n9) {
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n3 = n3 / 2 + n3 % 2;
                                n2 = n2 / 2 + n2 % 2;
                            }
                            for (n9 = 0; n9 < this.WTLevels[0]; ++n9) {
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n = n / 2 + n % 2;
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.WTOrder) {
                        case 0: {
                            int n10;
                            if (this.WTLevels[1] != this.WTLevels[2]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            for (n10 = 0; n10 < this.WTLevels[0]; ++n10) {
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n = n / 2 + n % 2;
                            }
                            for (n10 = 0; n10 < this.WTLevels[1]; ++n10) {
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n2 = n2 / 2 + n2 % 2;
                                n3 = n3 / 2 + n3 % 2;
                            }
                            break block58;
                        }
                        case 1: {
                            int n11;
                            if (this.WTLevels[2] != this.WTLevels[1]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            for (n11 = 0; n11 < this.WTLevels[0]; ++n11) {
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n = n / 2 + n % 2;
                            }
                            for (n11 = 0; n11 < this.WTLevels[2]; ++n11) {
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n3 = n3 / 2 + n3 % 2;
                                n2 = n2 / 2 + n2 % 2;
                            }
                            break block58;
                        }
                        case 2: {
                            int n12;
                            if (this.WTLevels[0] != this.WTLevels[2]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            for (n12 = 0; n12 < this.WTLevels[1]; ++n12) {
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n2 = n2 / 2 + n2 % 2;
                            }
                            for (n12 = 0; n12 < this.WTLevels[0]; ++n12) {
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n = n / 2 + n % 2;
                                n3 = n3 / 2 + n3 % 2;
                            }
                            break block58;
                        }
                        case 3: {
                            int n13;
                            if (this.WTLevels[2] != this.WTLevels[0]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            for (n13 = 0; n13 < this.WTLevels[1]; ++n13) {
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n2 - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n2 = n2 / 2 + n2 % 2;
                            }
                            for (n13 = 0; n13 < this.WTLevels[2]; ++n13) {
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, this.ySize - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n3 = n3 / 2 + n3 % 2;
                                n = n / 2 + n % 2;
                            }
                            break block58;
                        }
                        case 4: {
                            int n14;
                            if (this.WTLevels[0] != this.WTLevels[1]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            for (n14 = 0; n14 < this.WTLevels[2]; ++n14) {
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, this.ySize - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n3 = n3 / 2 + n3 % 2;
                            }
                            for (n14 = 0; n14 < this.WTLevels[0]; ++n14) {
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, n2 - 1, 0, n - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n2 - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n = n / 2 + n % 2;
                                n2 = n2 / 2 + n2 % 2;
                            }
                            break block58;
                        }
                        case 5: {
                            int n15;
                            if (this.WTLevels[1] != this.WTLevels[0]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            for (n15 = 0; n15 < this.WTLevels[2]; ++n15) {
                                forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, this.ySize - 1, 0, this.xSize - 1);
                                forwardDWTCore.run();
                                n3 = n3 / 2 + n3 % 2;
                            }
                            for (n15 = 0; n15 < this.WTLevels[1]; ++n15) {
                                forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n2 - 1, 0, n - 1);
                                forwardDWTCore.run();
                                forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, n2 - 1, 0, n - 1);
                                forwardDWTCore.run();
                                n2 = n2 / 2 + n2 % 2;
                                n = n / 2 + n % 2;
                            }
                        }
                    }
                }
            }
        }
        return forwardDWTCore.getImageSamples();
    }
}

