/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;
import GiciTransform.InverseDWTCore;

public class InverseNonPyramidal3D {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] WTTypes = null;
    int[] WTLevels = null;
    int WTOrder;
    int WTModel;
    boolean parametersSet = false;
    int[] xSubBandSizes = null;
    int[] ySubBandSizes = null;
    int[] zSubBandSizes = null;

    public InverseNonPyramidal3D(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = 4;
        this.WTModel = 1;
    }

    public void setParameters(int[] nArray, int[] nArray2, int n, int n2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = n;
        this.WTModel = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float[][][] run() throws ErrorException {
        InverseDWTCore inverseDWTCore;
        block78: {
            if (!this.parametersSet) {
                throw new ErrorException("Parameters not set.");
            }
            if (this.WTLevels[0] < 0 || this.WTLevels[1] < 0 || this.WTLevels[2] < 0) {
                throw new ErrorException("All the transform levels to apply must be no negative.");
            }
            if (this.WTLevels[0] == 0 && this.WTLevels[1] == 0 && this.WTLevels[2] == 0) {
                return this.imageSamples;
            }
            this.computeSubBandSizes();
            inverseDWTCore = new InverseDWTCore(this.imageSamples);
            switch (this.WTModel) {
                case 0: {
                    switch (this.WTOrder) {
                        case 0: {
                            int n;
                            if (this.WTLevels[0] != this.WTLevels[1]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            if (this.WTLevels[2] > 0) {
                                for (n = 0; n < this.WTLevels[2]; ++n) {
                                    int n2 = this.zSubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n2 - 1, 0, this.ySize - 1, 0, this.xSize - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[0] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[0]; ++n) {
                                int n3 = this.xSubBandSizes[n];
                                int n4 = this.ySubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n4 - 1, 0, n3 - 1);
                                inverseDWTCore.run();
                                inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, n4 - 1, 0, n3 - 1);
                                inverseDWTCore.run();
                            }
                            return inverseDWTCore.getImageSamples();
                        }
                        case 1: {
                            int n;
                            if (this.WTLevels[0] != this.WTLevels[2]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            if (this.WTLevels[1] > 0) {
                                for (n = 0; n < this.WTLevels[1]; ++n) {
                                    int n5 = this.ySubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n5 - 1, 0, this.xSize - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[0] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[0]; ++n) {
                                int n6 = this.xSubBandSizes[n];
                                int n7 = this.zSubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n7 - 1, 0, this.ySize - 1, 0, n6 - 1);
                                inverseDWTCore.run();
                                inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n7 - 1, 0, this.ySize - 1, 0, n6 - 1);
                                inverseDWTCore.run();
                            }
                            return inverseDWTCore.getImageSamples();
                        }
                        case 2: {
                            int n;
                            if (this.WTLevels[1] != this.WTLevels[0]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            if (this.WTLevels[2] > 0) {
                                for (n = 0; n < this.WTLevels[2]; ++n) {
                                    int n8 = this.zSubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n8 - 1, 0, this.ySize - 1, 0, this.xSize - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[1] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[1]; ++n) {
                                int n9 = this.xSubBandSizes[n];
                                int n10 = this.ySubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, n10 - 1, 0, n9 - 1);
                                inverseDWTCore.run();
                                inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n10 - 1, 0, n9 - 1);
                                inverseDWTCore.run();
                            }
                            return inverseDWTCore.getImageSamples();
                        }
                        case 3: {
                            int n;
                            if (this.WTLevels[1] != this.WTLevels[2]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            if (this.WTLevels[0] > 0) {
                                for (n = 0; n < this.WTLevels[0]; ++n) {
                                    int n11 = this.xSubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, this.ySize - 1, 0, n11 - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[1] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[1]; ++n) {
                                int n12 = this.ySubBandSizes[n];
                                int n13 = this.zSubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n13 - 1, 0, n12 - 1, 0, this.xSize - 1);
                                inverseDWTCore.run();
                                inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n13 - 1, 0, n12 - 1, 0, this.xSize - 1);
                                inverseDWTCore.run();
                            }
                            return inverseDWTCore.getImageSamples();
                        }
                        case 4: {
                            int n;
                            if (this.WTLevels[2] != this.WTLevels[0]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            if (this.WTLevels[1] > 0) {
                                for (n = 0; n < this.WTLevels[1]; ++n) {
                                    int n14 = this.ySubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n14 - 1, 0, this.xSize - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[2] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[2]; ++n) {
                                int n15 = this.xSubBandSizes[n];
                                int n16 = this.zSubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n16 - 1, 0, this.ySize - 1, 0, n15 - 1);
                                inverseDWTCore.run();
                                inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n16 - 1, 0, this.ySize - 1, 0, n15 - 1);
                                inverseDWTCore.run();
                            }
                            return inverseDWTCore.getImageSamples();
                        }
                        case 5: {
                            int n;
                            if (this.WTLevels[2] != this.WTLevels[1]) {
                                throw new ErrorException("The transform levels to apply must be equal for the first two dimensions");
                            }
                            if (this.WTLevels[0] > 0) {
                                for (n = 0; n < this.WTLevels[0]; ++n) {
                                    int n17 = this.xSubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, this.ySize - 1, 0, n17 - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[2] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[2]; ++n) {
                                int n18 = this.zSubBandSizes[n];
                                int n19 = this.ySubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n18 - 1, 0, n19 - 1, 0, this.xSize - 1);
                                inverseDWTCore.run();
                                inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n18 - 1, 0, n19 - 1, 0, this.xSize - 1);
                                inverseDWTCore.run();
                            }
                        }
                        default: {
                            return inverseDWTCore.getImageSamples();
                        }
                    }
                }
                case 1: {
                    switch (this.WTOrder) {
                        case 0: {
                            int n;
                            if (this.WTLevels[1] != this.WTLevels[2]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            if (this.WTLevels[1] > 0) {
                                for (n = 0; n < this.WTLevels[1]; ++n) {
                                    int n20 = this.ySubBandSizes[n];
                                    int n21 = this.zSubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n21 - 1, 0, n20 - 1, 0, this.xSize - 1);
                                    inverseDWTCore.run();
                                    inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n21 - 1, 0, n20 - 1, 0, this.xSize - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[0] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[0]; ++n) {
                                int n22 = this.xSubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, this.ySize - 1, 0, n22 - 1);
                                inverseDWTCore.run();
                            }
                            break block78;
                        }
                        case 1: {
                            int n;
                            if (this.WTLevels[2] != this.WTLevels[1]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            if (this.WTLevels[2] > 0) {
                                for (n = 0; n < this.WTLevels[2]; ++n) {
                                    int n23 = this.ySubBandSizes[n];
                                    int n24 = this.zSubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n24 - 1, 0, n23 - 1, 0, this.xSize - 1);
                                    inverseDWTCore.run();
                                    inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n24 - 1, 0, n23 - 1, 0, this.xSize - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[0] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[0]; ++n) {
                                int n25 = this.xSubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, this.ySize - 1, 0, n25 - 1);
                                inverseDWTCore.run();
                            }
                            break block78;
                        }
                        case 2: {
                            int n;
                            if (this.WTLevels[0] != this.WTLevels[2]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            if (this.WTLevels[0] > 0) {
                                for (n = 0; n < this.WTLevels[0]; ++n) {
                                    int n26 = this.xSubBandSizes[n];
                                    int n27 = this.zSubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n27 - 1, 0, this.ySize - 1, 0, n26 - 1);
                                    inverseDWTCore.run();
                                    inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n27 - 1, 0, this.ySize - 1, 0, n26 - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[1] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[1]; ++n) {
                                int n28 = this.ySubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n28 - 1, 0, this.xSize - 1);
                                inverseDWTCore.run();
                            }
                            break block78;
                        }
                        case 3: {
                            int n;
                            if (this.WTLevels[2] != this.WTLevels[0]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            if (this.WTLevels[2] > 0) {
                                for (n = 0; n < this.WTLevels[2]; ++n) {
                                    int n29 = this.xSubBandSizes[n];
                                    int n30 = this.zSubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n30 - 1, 0, this.ySize - 1, 0, n29 - 1);
                                    inverseDWTCore.run();
                                    inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n30 - 1, 0, this.ySize - 1, 0, n29 - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[1] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[1]; ++n) {
                                int n31 = this.ySubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n31 - 1, 0, this.xSize - 1);
                                inverseDWTCore.run();
                            }
                            break block78;
                        }
                        case 4: {
                            int n;
                            if (this.WTLevels[0] != this.WTLevels[1]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            if (this.WTLevels[0] > 0) {
                                for (n = 0; n < this.WTLevels[0]; ++n) {
                                    int n32 = this.xSubBandSizes[n];
                                    int n33 = this.ySubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n33 - 1, 0, n32 - 1);
                                    inverseDWTCore.run();
                                    inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, n33 - 1, 0, n32 - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[2] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[2]; ++n) {
                                int n34 = this.zSubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n34 - 1, 0, this.ySize - 1, 0, this.xSize - 1);
                                inverseDWTCore.run();
                            }
                            break block78;
                        }
                        case 5: {
                            int n;
                            if (this.WTLevels[1] != this.WTLevels[0]) {
                                throw new ErrorException("The transform levels to apply must be equal for the last two dimensions");
                            }
                            if (this.WTLevels[1] > 0) {
                                for (n = 0; n < this.WTLevels[1]; ++n) {
                                    int n35 = this.xSubBandSizes[n];
                                    int n36 = this.ySubBandSizes[n];
                                    inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, this.zSize - 1, 0, n36 - 1, 0, n35 - 1);
                                    inverseDWTCore.run();
                                    inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, this.zSize - 1, 0, n36 - 1, 0, n35 - 1);
                                    inverseDWTCore.run();
                                }
                            }
                            if (this.WTLevels[2] <= 0) return inverseDWTCore.getImageSamples();
                            for (n = 0; n < this.WTLevels[2]; ++n) {
                                int n37 = this.zSubBandSizes[n];
                                inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n37 - 1, 0, this.ySize - 1, 0, this.xSize - 1);
                                inverseDWTCore.run();
                            }
                        }
                    }
                }
            }
        }
        return inverseDWTCore.getImageSamples();
    }

    private void computeSubBandSizes() {
        int n;
        this.xSubBandSizes = new int[this.WTLevels[0] > 0 ? this.WTLevels[0] : Math.max(this.WTLevels[1], this.WTLevels[2])];
        this.ySubBandSizes = new int[this.WTLevels[1] > 0 ? this.WTLevels[1] : Math.max(this.WTLevels[0], this.WTLevels[2])];
        this.zSubBandSizes = new int[this.WTLevels[2] > 0 ? this.WTLevels[2] : Math.max(this.WTLevels[0], this.WTLevels[1])];
        if (this.WTLevels[0] > 0) {
            this.xSubBandSizes[this.WTLevels[0] - 1] = this.xSize;
            for (n = this.WTLevels[0] - 2; n >= 0; --n) {
                this.xSubBandSizes[n] = this.xSubBandSizes[n + 1] / 2 + this.xSubBandSizes[n + 1] % 2;
            }
        } else {
            for (n = Math.max(this.WTLevels[1], this.WTLevels[2]) - 1; n >= 0; --n) {
                this.xSubBandSizes[n] = this.xSize;
            }
        }
        if (this.WTLevels[1] > 0) {
            this.ySubBandSizes[this.WTLevels[1] - 1] = this.ySize;
            for (n = this.WTLevels[1] - 2; n >= 0; --n) {
                this.ySubBandSizes[n] = this.ySubBandSizes[n + 1] / 2 + this.ySubBandSizes[n + 1] % 2;
            }
        } else {
            for (n = Math.max(this.WTLevels[0], this.WTLevels[2]) - 1; n >= 0; --n) {
                this.ySubBandSizes[n] = this.ySize;
            }
        }
        if (this.WTLevels[2] > 0) {
            this.zSubBandSizes[this.WTLevels[2] - 1] = this.zSize;
            for (n = this.WTLevels[2] - 2; n >= 0; --n) {
                this.zSubBandSizes[n] = this.zSubBandSizes[n + 1] / 2 + this.zSubBandSizes[n + 1] % 2;
            }
        } else {
            for (n = Math.max(this.WTLevels[0], this.WTLevels[1]) - 1; n >= 0; --n) {
                this.zSubBandSizes[n] = this.zSize;
            }
        }
    }
}

