/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;
import GiciTransform.InverseDWTCore;

public class InversePyramidal3D {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] WTTypes = null;
    int[] WTLevels = null;
    int WTOrder;
    boolean parametersSet = false;
    int[] xSubBandSizes = null;
    int[] ySubBandSizes = null;
    int[] zSubBandSizes = null;

    public InversePyramidal3D(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = 0;
    }

    public void setParameters(int[] nArray, int[] nArray2, int n) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = n;
    }

    public float[][][] run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Parameters not set.");
        }
        if (this.WTLevels[0] < 0 || this.WTLevels[1] < 0 || this.WTLevels[2] < 0) {
            throw new ErrorException("All the transform levels to apply must be no negative.");
        }
        if (this.WTLevels[0] == 0 && this.WTLevels[1] == 0 && this.WTLevels[2] == 0) {
            return this.imageSamples;
        }
        this.computeSubBandSizes();
        InverseDWTCore inverseDWTCore = new InverseDWTCore(this.imageSamples);
        if (this.WTLevels[0] != this.WTLevels[1] || this.WTLevels[1] != this.WTLevels[2]) {
            throw new ErrorException("The transform levels to apply must be equal for every dimension");
        }
        if (this.WTLevels[0] > 0) {
            switch (this.WTOrder) {
                case 0: {
                    for (int i = 0; i < this.WTLevels[0]; ++i) {
                        int n = this.xSubBandSizes[i];
                        int n2 = this.ySubBandSizes[i];
                        int n3 = this.zSubBandSizes[i];
                        inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                        inverseDWTCore.run();
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.WTLevels[0]; ++i) {
                        int n = this.xSubBandSizes[i];
                        int n4 = this.ySubBandSizes[i];
                        int n5 = this.zSubBandSizes[i];
                        inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n5 - 1, 0, n4 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n5 - 1, 0, n4 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n5 - 1, 0, n4 - 1, 0, n - 1);
                        inverseDWTCore.run();
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.WTLevels[0]; ++i) {
                        int n = this.xSubBandSizes[i];
                        int n6 = this.ySubBandSizes[i];
                        int n7 = this.zSubBandSizes[i];
                        inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n7 - 1, 0, n6 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n7 - 1, 0, n6 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n7 - 1, 0, n6 - 1, 0, n - 1);
                        inverseDWTCore.run();
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.WTLevels[0]; ++i) {
                        int n = this.xSubBandSizes[i];
                        int n8 = this.ySubBandSizes[i];
                        int n9 = this.zSubBandSizes[i];
                        inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n9 - 1, 0, n8 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n9 - 1, 0, n8 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n9 - 1, 0, n8 - 1, 0, n - 1);
                        inverseDWTCore.run();
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.WTLevels[0]; ++i) {
                        int n = this.xSubBandSizes[i];
                        int n10 = this.ySubBandSizes[i];
                        int n11 = this.zSubBandSizes[i];
                        inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n11 - 1, 0, n10 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n11 - 1, 0, n10 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n11 - 1, 0, n10 - 1, 0, n - 1);
                        inverseDWTCore.run();
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < this.WTLevels[0]; ++i) {
                        int n = this.xSubBandSizes[i];
                        int n12 = this.ySubBandSizes[i];
                        int n13 = this.zSubBandSizes[i];
                        inverseDWTCore.setParameters(this.WTTypes[0], 0, 0, n13 - 1, 0, n12 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[1], 1, 0, n13 - 1, 0, n12 - 1, 0, n - 1);
                        inverseDWTCore.run();
                        inverseDWTCore.setParameters(this.WTTypes[2], 2, 0, n13 - 1, 0, n12 - 1, 0, n - 1);
                        inverseDWTCore.run();
                    }
                    break;
                }
            }
        }
        return inverseDWTCore.getImageSamples();
    }

    private void computeSubBandSizes() {
        int n;
        this.xSubBandSizes = new int[this.WTLevels[0] > 0 ? this.WTLevels[0] : Math.max(this.WTLevels[1], this.WTLevels[2])];
        this.ySubBandSizes = new int[this.WTLevels[1] > 0 ? this.WTLevels[1] : Math.max(this.WTLevels[0], this.WTLevels[2])];
        this.zSubBandSizes = new int[this.WTLevels[2] > 0 ? this.WTLevels[2] : Math.max(this.WTLevels[0], this.WTLevels[1])];
        if (this.WTLevels[0] > 0) {
            this.xSubBandSizes[this.WTLevels[0] - 1] = this.xSize;
            for (n = this.WTLevels[0] - 2; n >= 0; --n) {
                this.xSubBandSizes[n] = this.xSubBandSizes[n + 1] / 2 + this.xSubBandSizes[n + 1] % 2;
            }
        } else {
            for (n = Math.max(this.WTLevels[1], this.WTLevels[2]) - 1; n >= 0; --n) {
                this.xSubBandSizes[n] = this.xSize;
            }
        }
        if (this.WTLevels[1] > 0) {
            this.ySubBandSizes[this.WTLevels[1] - 1] = this.ySize;
            for (n = this.WTLevels[1] - 2; n >= 0; --n) {
                this.ySubBandSizes[n] = this.ySubBandSizes[n + 1] / 2 + this.ySubBandSizes[n + 1] % 2;
            }
        } else {
            for (n = Math.max(this.WTLevels[0], this.WTLevels[2]) - 1; n >= 0; --n) {
                this.ySubBandSizes[n] = this.ySize;
            }
        }
        if (this.WTLevels[2] > 0) {
            this.zSubBandSizes[this.WTLevels[2] - 1] = this.zSize;
            for (n = this.WTLevels[2] - 2; n >= 0; --n) {
                this.zSubBandSizes[n] = this.zSubBandSizes[n + 1] / 2 + this.zSubBandSizes[n + 1] % 2;
            }
        } else {
            for (n = Math.max(this.WTLevels[0], this.WTLevels[1]) - 1; n >= 0; --n) {
                this.zSubBandSizes[n] = this.zSize;
            }
        }
    }
}

