/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class InverseWaveletTransform {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] WTTypes = null;
    int[] WTLevels = null;
    int[] WTOrder;
    boolean parametersSet = false;
    int rLevel = 0;

    public InverseWaveletTransform(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
    }

    public void setParameters(int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = new int[this.zSize];
        for (int i = 0; i < this.zSize; ++i) {
            this.WTOrder[i] = 1;
        }
    }

    public void setParameters(int[] nArray, int[] nArray2, int[] nArray3) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = nArray3;
    }

    public static boolean verifyParameters(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0 || nArray[i] > 4) {
                return false;
            }
            if (nArray2[i] < 0) {
                return false;
            }
            if (nArray3[i] >= 0 && nArray3[i] <= 2) continue;
            return false;
        }
        return true;
    }

    public float[][][] run() throws Exception {
        if (!this.parametersSet) {
            throw new Exception("Discrete wavelet transform cannot run if parameters are not set.");
        }
        for (int i = 0; i < this.zSize; ++i) {
            int n;
            this.ySize = this.imageSamples[i].length;
            this.xSize = this.imageSamples[i][0].length;
            if (this.WTTypes[i] == 0 || this.WTLevels[i] <= 0) continue;
            int[] nArray = new int[this.WTLevels[i]];
            int[] nArray2 = new int[this.WTLevels[i]];
            nArray[this.WTLevels[i] - 1] = this.xSize;
            nArray2[this.WTLevels[i] - 1] = this.ySize;
            for (n = this.WTLevels[i] - 2; n >= 0; --n) {
                nArray[n] = nArray[n + 1] / 2 + nArray[n + 1] % 2;
                nArray2[n] = nArray2[n + 1] / 2 + nArray2[n + 1] % 2;
            }
            for (n = 0; n < this.WTLevels[i]; ++n) {
                int n2;
                float[] fArray;
                int n3;
                this.rLevel = this.WTLevels[i] - n;
                int n4 = nArray[n];
                int n5 = nArray2[n];
                if (this.WTOrder[i] == 2) {
                    n5 = this.ySize;
                }
                if (this.WTOrder[i] == 0) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        fArray = new float[n5];
                        for (n2 = 0; n2 < n5; ++n2) {
                            fArray[n2] = this.imageSamples[i][n2][n3];
                        }
                        fArray = this.filtering(fArray, i);
                        for (n2 = 0; n2 < n5; ++n2) {
                            this.imageSamples[i][n2][n3] = fArray[n2];
                        }
                    }
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    fArray = new float[n4];
                    for (n2 = 0; n2 < n4; ++n2) {
                        fArray[n2] = this.imageSamples[i][n3][n2];
                    }
                    fArray = this.filtering(fArray, i);
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.imageSamples[i][n3][n2] = fArray[n2];
                    }
                }
                if (this.WTOrder[i] != 1 || this.WTOrder[i] == 2) continue;
                for (n3 = 0; n3 < n4; ++n3) {
                    fArray = new float[n5];
                    for (n2 = 0; n2 < n5; ++n2) {
                        fArray[n2] = this.imageSamples[i][n2][n3];
                    }
                    fArray = this.filtering(fArray, i);
                    for (n2 = 0; n2 < n5; ++n2) {
                        this.imageSamples[i][n2][n3] = fArray[n2];
                    }
                }
            }
        }
        return this.imageSamples;
    }

    private float[] filtering(float[] fArray, int n) throws ErrorException {
        if (fArray.length == 1) {
            return fArray;
        }
        if (fArray.length % 2 == 0) {
            return this.evenFiltering(fArray, n);
        }
        return this.oddFiltering(fArray, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float[] evenFiltering(float[] fArray, int n) throws ErrorException {
        int n2;
        int n3 = fArray.length;
        int n4 = n3 / 2;
        float[] fArray2 = new float[n3];
        for (n2 = 0; n2 < n4; ++n2) {
            fArray2[2 * n2] = fArray[n2];
            fArray2[2 * n2 + 1] = fArray[n4 + n2];
        }
        if (this.WTTypes[n] == 1) {
            fArray2[0] = fArray2[0] - (float)Math.floor((fArray2[1] + fArray2[1] + 2.0f) / 4.0f);
            for (n2 = 2; n2 < n3 - 1; n2 += 2) {
                fArray2[n2] = fArray2[n2] - (float)Math.floor((fArray2[n2 - 1] + fArray2[n2 + 1] + 2.0f) / 4.0f);
            }
            for (n2 = 1; n2 < n3 - 1; n2 += 2) {
                fArray2[n2] = fArray2[n2] + (float)Math.floor((fArray2[n2 - 1] + fArray2[n2 + 1]) / 2.0f);
            }
            fArray2[n3 - 1] = fArray2[n3 - 1] + (float)Math.floor((fArray2[n3 - 2] + fArray2[n3 - 2]) / 2.0f);
            return fArray2;
        } else if (this.WTTypes[n] == 2 || this.WTTypes[n] == 3) {
            int n5;
            float f;
            float f2;
            if (this.WTTypes[n] == 2) {
                f2 = 1.2301741f;
                f = 1.0f / f2;
            } else {
                f = 1.1496043f;
                f2 = -1.0f / f;
            }
            for (n5 = 0; n5 < n3; n5 += 2) {
                fArray2[n5] = fArray2[n5] / f;
                fArray2[n5 + 1] = fArray2[n5 + 1] / f2;
            }
            fArray2[0] = fArray2[0] - 0.44350687f * (fArray2[1] + fArray2[1]);
            for (n5 = 2; n5 < n3; n5 += 2) {
                fArray2[n5] = fArray2[n5] - 0.44350687f * (fArray2[n5 - 1] + fArray2[n5 + 1]);
            }
            for (n5 = 1; n5 < n3 - 2; n5 += 2) {
                fArray2[n5] = fArray2[n5] - 0.8829111f * (fArray2[n5 - 1] + fArray2[n5 + 1]);
            }
            fArray2[n3 - 1] = fArray2[n3 - 1] - 0.8829111f * (fArray2[n3 - 2] + fArray2[n3 - 2]);
            fArray2[0] = fArray2[0] - -0.052980117f * (fArray2[1] + fArray2[1]);
            for (n5 = 2; n5 < n3; n5 += 2) {
                fArray2[n5] = fArray2[n5] - -0.052980117f * (fArray2[n5 - 1] + fArray2[n5 + 1]);
            }
            for (n5 = 1; n5 < n3 - 2; n5 += 2) {
                fArray2[n5] = fArray2[n5] - -1.5861343f * (fArray2[n5 - 1] + fArray2[n5 + 1]);
            }
            fArray2[n3 - 1] = fArray2[n3 - 1] - -1.5861343f * (fArray2[n3 - 2] + fArray2[n3 - 2]);
            return fArray2;
        } else if (this.WTTypes[n] == 4) {
            int n6;
            if (n3 < 6) throw new ErrorException("Size should be greater or equal than 6 in order to perform 9/7M");
            fArray2[0] = fArray2[0] + (float)Math.floor((double)(-0.25f * (fArray2[1] + fArray2[1])) + 0.5);
            for (n6 = 2; n6 < n3; n6 += 2) {
                fArray2[n6] = fArray2[n6] + (float)Math.floor((double)(-0.25f * (fArray2[n6 - 1] + fArray2[n6 + 1])) + 0.5);
            }
            fArray2[1] = fArray2[1] + (float)Math.floor((double)(0.5625f * (fArray2[0] + fArray2[2]) - 0.0625f * (fArray2[2] + fArray2[4])) + 0.5);
            for (n6 = 3; n6 < n3 - 3; n6 += 2) {
                fArray2[n6] = fArray2[n6] + (float)Math.floor((double)(0.5625f * (fArray2[n6 - 1] + fArray2[n6 + 1]) - 0.0625f * (fArray2[n6 - 3] + fArray2[n6 + 3])) + 0.5);
            }
            fArray2[n3 - 3] = fArray2[n3 - 3] + (float)Math.floor((double)(0.5625f * (fArray2[n3 - 4] + fArray2[n3 - 2]) - 0.0625f * (fArray2[n3 - 6] + fArray2[n3 - 2])) + 0.5);
            fArray2[n3 - 1] = fArray2[n3 - 1] + (float)Math.floor((double)(0.5625f * (fArray2[n3 - 2] + fArray2[n3 - 2]) - 0.0625f * (fArray2[n3 - 4] + fArray2[n3 - 4])) + 0.5);
            return fArray2;
        } else if (this.WTTypes[n] == 5 || this.WTTypes[n] == 6) {
            int n7;
            float f;
            float f3;
            float f4;
            float f5;
            if (this.WTTypes[n] == 6) {
                f5 = -1.5861598f;
                f4 = -0.05297864f;
                f3 = 0.8829336f;
                f = 0.4435048f;
            } else {
                f5 = -0.5f;
                f4 = 0.25f;
                f3 = 0.0f;
                f = 0.0f;
            }
            if (this.WTTypes[n] == 6) {
                fArray2[0] = fArray2[0] - (float)Math.floor((double)(f * (fArray2[1] + fArray2[1])) + 0.5);
                for (n7 = 2; n7 < n3; n7 += 2) {
                    fArray2[n7] = fArray2[n7] - (float)Math.floor((double)(f * (fArray2[n7 - 1] + fArray2[n7 + 1])) + 0.5);
                }
                for (n7 = 1; n7 < n3 - 2; n7 += 2) {
                    fArray2[n7] = fArray2[n7] - (float)Math.floor((double)(f3 * (fArray2[n7 - 1] + fArray2[n7 + 1])) + 0.5);
                }
                fArray2[n3 - 1] = fArray2[n3 - 1] - (float)Math.floor((double)(f3 * (fArray2[n3 - 2] + fArray2[n3 - 2])) + 0.5);
            }
            fArray2[0] = fArray2[0] - (float)Math.floor((double)(f4 * (fArray2[1] + fArray2[1])) + 0.5);
            for (n7 = 2; n7 < n3; n7 += 2) {
                fArray2[n7] = fArray2[n7] - (float)Math.floor((double)(f4 * (fArray2[n7 - 1] + fArray2[n7 + 1])) + 0.5);
            }
            for (n7 = 1; n7 < n3 - 2; n7 += 2) {
                fArray2[n7] = fArray2[n7] - (float)Math.floor((double)(f5 * (fArray2[n7 - 1] + fArray2[n7 + 1])) + 0.5);
            }
            fArray2[n3 - 1] = fArray2[n3 - 1] - (float)Math.floor((double)(f5 * (fArray2[n3 - 2] + fArray2[n3 - 2])) + 0.5);
            return fArray2;
        } else if (this.WTTypes[n] == 7) {
            float f = 0.0f;
            float f6 = 0.0f;
            float f7 = (float)Math.sqrt(2.0);
            for (int i = 0; i < n3; i += 2) {
                f = fArray2[i] + fArray2[i + 1];
                f6 = fArray2[i] - fArray2[i + 1];
                fArray2[i] = f * f7;
                fArray2[i + 1] = f6 * f7;
            }
            return fArray2;
        } else {
            if (this.WTTypes[n] != 8) throw new ErrorException("Unrecognized wavelet transform type.");
            float f = 0.0f;
            for (int i = 0; i < n3; i += 2) {
                f = fArray2[i] - (float)Math.floor(fArray2[i + 1] / 2.0f);
                fArray2[i] = fArray2[i + 1] + f;
                fArray2[i + 1] = f;
            }
        }
        return fArray2;
    }

    private float[] oddFiltering(float[] fArray, int n) throws ErrorException {
        int n2;
        int n3 = fArray.length;
        int n4 = n3 / 2;
        float[] fArray2 = new float[n3];
        for (n2 = 0; n2 < n4; ++n2) {
            fArray2[2 * n2] = fArray[n2];
            fArray2[2 * n2 + 1] = fArray[n4 + n2 + 1];
        }
        fArray2[n3 - 1] = fArray[n4];
        if (this.WTTypes[n] == 1) {
            fArray2[0] = fArray2[0] - (float)Math.floor((fArray2[1] + fArray2[1] + 2.0f) / 4.0f);
            for (n2 = 2; n2 < n3 - 1; n2 += 2) {
                fArray2[n2] = fArray2[n2] - (float)Math.floor((fArray2[n2 - 1] + fArray2[n2 + 1] + 2.0f) / 4.0f);
            }
            fArray2[n3 - 1] = fArray2[n3 - 1] - (float)Math.floor((fArray2[n3 - 2] + fArray2[n3 - 2] + 2.0f) / 4.0f);
            for (n2 = 1; n2 < n3 - 1; n2 += 2) {
                fArray2[n2] = fArray2[n2] + (float)Math.floor((fArray2[n2 - 1] + fArray2[n2 + 1]) / 2.0f);
            }
        } else if (this.WTTypes[n] == 2 || this.WTTypes[n] == 3) {
            int n5;
            float f;
            float f2;
            if (this.WTTypes[n] == 2) {
                f2 = 1.2301741f;
                f = 1.0f / f2;
            } else {
                f2 = 1.1496043f;
                f = -1.0f / f2;
            }
            for (n5 = 0; n5 < n3 - 1; n5 += 2) {
                fArray2[n5] = fArray2[n5] / f;
                fArray2[n5 + 1] = fArray2[n5 + 1] / f2;
            }
            fArray2[n3 - 1] = fArray2[n3 - 1] / f;
            fArray2[0] = fArray2[0] - 0.44350687f * (fArray2[1] + fArray2[1]);
            for (n5 = 2; n5 < n3 - 1; n5 += 2) {
                fArray2[n5] = fArray2[n5] - 0.44350687f * (fArray2[n5 - 1] + fArray2[n5 + 1]);
            }
            fArray2[n3 - 1] = fArray2[n3 - 1] - 0.44350687f * (fArray2[n3 - 2] + fArray2[n3 - 2]);
            for (n5 = 1; n5 < n3 - 1; n5 += 2) {
                fArray2[n5] = fArray2[n5] - 0.8829111f * (fArray2[n5 - 1] + fArray2[n5 + 1]);
            }
            fArray2[0] = fArray2[0] - -0.052980117f * (fArray2[1] + fArray2[1]);
            for (n5 = 2; n5 < n3 - 1; n5 += 2) {
                fArray2[n5] = fArray2[n5] - -0.052980117f * (fArray2[n5 - 1] + fArray2[n5 + 1]);
            }
            fArray2[n3 - 1] = fArray2[n3 - 1] - -0.052980117f * (fArray2[n3 - 2] + fArray2[n3 - 2]);
            for (n5 = 1; n5 < n3 - 1; n5 += 2) {
                fArray2[n5] = fArray2[n5] - -1.5861343f * (fArray2[n5 - 1] + fArray2[n5 + 1]);
            }
        } else {
            if (this.WTTypes[n] == 4) {
                throw new ErrorException("Integer 9/7M CCSDS Recommended is not implemented for odd signals.!!!");
            }
            if (this.WTTypes[n] == 5 || this.WTTypes[n] == 6) {
                int n6;
                float f;
                float f3;
                float f4;
                float f5;
                if (this.WTTypes[n] == 6) {
                    f5 = -1.5861598f;
                    f4 = -0.05297864f;
                    f3 = 0.8829336f;
                    f = 0.4435048f;
                } else {
                    f5 = -0.5f;
                    f4 = 0.25f;
                    f3 = 0.0f;
                    f = 0.0f;
                }
                if (this.WTTypes[n] == 6) {
                    fArray2[0] = fArray2[0] - (float)Math.floor((double)(f * (fArray2[1] + fArray2[1])) + 0.5);
                    for (n6 = 2; n6 < n3 - 1; n6 += 2) {
                        fArray2[n6] = fArray2[n6] - (float)Math.floor((double)(f * (fArray2[n6 - 1] + fArray2[n6 + 1])) + 0.5);
                    }
                    fArray2[n3 - 1] = fArray2[n3 - 1] - (float)Math.floor((double)(f * (fArray2[n3 - 2] + fArray2[n3 - 2])) + 0.5);
                    for (n6 = 1; n6 < n3 - 1; n6 += 2) {
                        fArray2[n6] = fArray2[n6] - (float)Math.floor((double)(f3 * (fArray2[n6 - 1] + fArray2[n6 + 1])) + 0.5);
                    }
                }
                fArray2[0] = fArray2[0] - (float)Math.floor((double)(f4 * (fArray2[1] + fArray2[1])) + 0.5);
                for (n6 = 2; n6 < n3 - 1; n6 += 2) {
                    fArray2[n6] = fArray2[n6] - (float)Math.floor((double)(f4 * (fArray2[n6 - 1] + fArray2[n6 + 1])) + 0.5);
                }
                fArray2[n3 - 1] = fArray2[n3 - 1] - (float)Math.floor((double)(f4 * (fArray2[n3 - 2] + fArray2[n3 - 2])) + 0.5);
                for (n6 = 1; n6 < n3 - 1; n6 += 2) {
                    fArray2[n6] = fArray2[n6] - (float)Math.floor((double)(f5 * (fArray2[n6 - 1] + fArray2[n6 + 1])) + 0.5);
                }
            } else if (this.WTTypes[n] == 7) {
                float f = 0.0f;
                float f6 = 0.0f;
                float f7 = (float)Math.sqrt(2.0);
                for (int i = 0; i < n3 - 1; i += 2) {
                    f = fArray2[i] + fArray2[i + 1];
                    f6 = fArray2[i] - fArray2[i + 1];
                    fArray2[i] = f * f7;
                    fArray2[i + 1] = f6 * f7;
                }
                fArray2[n3 - 1] = fArray2[n3 - 1];
            } else if (this.WTTypes[n] == 8) {
                float f = 0.0f;
                for (int i = 0; i < n3 - 1; i += 2) {
                    f = fArray2[i] - (float)Math.floor(fArray2[i + 1] / 2.0f);
                    fArray2[i] = fArray2[i + 1] + f;
                    fArray2[i + 1] = f;
                }
                fArray2[n3 - 1] = fArray2[n3 - 1];
            } else {
                throw new ErrorException("Unrecognized wavelet transform type.");
            }
        }
        return fArray2;
    }
}

