/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciAnalysis.ImageCovariance;
import GiciMatrix.MatrixAlgebra;
import java.util.Arrays;

public class KarhunenLoeveTransform {
    public static float[][][] generateTransform2(float[][] fArray) {
        double d;
        double d2;
        assert (fArray.length == 2 && fArray[0].length == 2 && fArray[1].length == 1);
        float f = fArray[0][0];
        float f2 = fArray[0][1];
        float f3 = fArray[1][0];
        assert (f >= 0.0f && f3 >= 0.0f);
        float f4 = Math.signum(f2);
        if ((double)Math.abs(f2) < 1.0E-5) {
            f4 = 1.0f;
        }
        if ((d2 = Math.sqrt((d = (double)(f - f3)) * d + (double)(4.0f * (f2 * f2)))) < 1.0E-4) {
            float[][][] fArrayArray = new float[][][]{new float[][]{{1.0f, 0.0f}, {0.0f, 1.0f}}, new float[][]{{(f + f3) / 2.0f, 0.0f}, {0.0f, (f + f3) / 2.0f}}};
            return fArrayArray;
        }
        float f5 = (float)Math.sqrt(0.5 + d / (2.0 * d2));
        float f6 = f4 * (float)Math.sqrt(0.5 - d / (2.0 * d2));
        float f7 = -f6;
        float f8 = f5;
        float f9 = (f + f3 + (float)d2) / 2.0f;
        float f10 = (f + f3 - (float)d2) / 2.0f;
        assert (!(Double.isInfinite(d) || Double.isInfinite(d2) || Float.isInfinite(f5) || Float.isInfinite(f7) || Float.isInfinite(f9) || Float.isInfinite(f10)));
        float[][] fArrayArray = new float[][]{{f5, f7}, {f6, f8}};
        float[][] fArrayArray2 = new float[][]{{f9, 0.0f}, {0.0f, f10}};
        float[][][] fArrayArray3 = new float[][][]{fArrayArray, fArrayArray2};
        return fArrayArray3;
    }

    public static float[][][] generateTransform(float[][] fArray) {
        if (fArray.length == 2) {
            return KarhunenLoeveTransform.generateTransform2(fArray);
        }
        try {
            KarhunenLoeveTransform karhunenLoeveTransform = new KarhunenLoeveTransform();
            return karhunenLoeveTransform.doKLT(KarhunenLoeveTransform.toCompleteMirrorFill(fArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error(exception.getMessage());
        }
    }

    public static float[][] toCompleteMirrorFill(float[][] fArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < fArray.length; ++n) {
            n2 = Math.max(n2, fArray[n].length);
        }
        float[][] fArray2 = new float[fArray.length][n2];
        for (n = 0; n < fArray.length; ++n) {
            for (int i = 0; i < fArray[n].length; ++i) {
                float f = fArray[n][i];
                fArray2[n][i + n2 - fArray[n].length] = f;
                fArray2[i + n2 - fArray[n].length][n] = f;
            }
        }
        return fArray2;
    }

    public static float[][] run(float[][][] fArray) {
        float[][] fArray2 = ImageCovariance.generateCovarianceMatrix(fArray, 0);
        return KarhunenLoeveTransform.generateTransform(fArray2)[0];
    }

    public static float[][][] runWithDiagonal(float[][][] fArray) {
        return KarhunenLoeveTransform.generateTransform(ImageCovariance.generateCovarianceMatrix(fArray, 0));
    }

    float[][][] doKLT(float[][] fArray) throws Exception {
        int n;
        assert (fArray.length > 0 && fArray[0].length == fArray.length);
        int n2 = fArray.length;
        assert (this.noNaNs(fArray));
        gsl_matrix gsl_matrix2 = new gsl_matrix(fArray);
        fArray = null;
        gsl_vector gsl_vector2 = new gsl_vector(n2);
        gsl_matrix gsl_matrix3 = new gsl_matrix(n2, n2);
        gsl_eigen_symmv_workspace gsl_eigen_symmv_workspace2 = new gsl_eigen_symmv_workspace(n2);
        this.gsl_eigen_symmv(gsl_matrix2, gsl_vector2, gsl_matrix3, gsl_eigen_symmv_workspace2);
        this.gsl_eigen_symmv_sort(gsl_vector2, gsl_matrix3);
        float[][] fArray2 = MatrixAlgebra.identityC(n2);
        float[][] fArray3 = MatrixAlgebra.identityC(n2);
        for (n = 0; n < gsl_matrix3.size1; ++n) {
            for (int i = 0; i < gsl_matrix3.size2; ++i) {
                fArray2[n][i] = (float)gsl_matrix3.data[gsl_matrix3.start + n * gsl_matrix3.tda + i];
            }
        }
        for (n = 0; n < gsl_vector2.size; ++n) {
            fArray3[n][n] = (float)this.gsl_vector_get(gsl_vector2, n);
        }
        float[][][] fArrayArray = new float[][][]{fArray2, fArray3};
        assert (this.noNaNs(fArray2));
        assert (this.noNaNs(fArray3));
        return fArrayArray;
    }

    boolean noNaNs(float[][] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                if (!Float.isInfinite(fArray[i][j]) && !Float.isNaN(fArray[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    double gsl_matrix_get(gsl_matrix gsl_matrix2, int n, int n2) {
        assert (n < gsl_matrix2.size1 && n >= 0);
        assert (n2 < gsl_matrix2.size2 && n >= 0);
        return gsl_matrix2.data[gsl_matrix2.start + n * gsl_matrix2.tda + n2];
    }

    void gsl_matrix_set(gsl_matrix gsl_matrix2, int n, int n2, double d) {
        assert (n < gsl_matrix2.size1 && n >= 0);
        assert (n2 < gsl_matrix2.size2 && n >= 0);
        gsl_matrix2.data[gsl_matrix2.start + n * gsl_matrix2.tda + n2] = d;
    }

    void gsl_matrix_set_identity(gsl_matrix gsl_matrix2) {
        double[] dArray = gsl_matrix2.data;
        int n = gsl_matrix2.size1;
        int n2 = gsl_matrix2.size2;
        int n3 = gsl_matrix2.tda;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[gsl_matrix2.start + i * n3 + j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    gsl_vector_view gsl_matrix_column(gsl_matrix gsl_matrix2, int n) {
        assert (n < gsl_matrix2.size2);
        gsl_vector gsl_vector2 = new gsl_vector();
        gsl_vector_view gsl_vector_view2 = new gsl_vector_view();
        gsl_vector2.data = gsl_matrix2.data;
        gsl_vector2.start = gsl_matrix2.start + n;
        gsl_vector2.size = gsl_matrix2.size1;
        gsl_vector2.stride = gsl_matrix2.tda;
        gsl_vector_view2.vector = gsl_vector2;
        return gsl_vector_view2;
    }

    void gsl_matrix_swap_columns(gsl_matrix gsl_matrix2, int n, int n2) {
        int n3 = gsl_matrix2.size1;
        if (n != n2) {
            for (int i = 0; i < n3; ++i) {
                int n4 = i * gsl_matrix2.tda;
                double d = gsl_matrix2.data[gsl_matrix2.start + n4 + n];
                gsl_matrix2.data[gsl_matrix2.start + n4 + n] = gsl_matrix2.data[gsl_matrix2.start + n4 + n2];
                gsl_matrix2.data[gsl_matrix2.start + n4 + n2] = d;
            }
        }
    }

    gsl_matrix_view gsl_matrix_submatrix(gsl_matrix gsl_matrix2, int n, int n2, int n3, int n4) throws Exception {
        if (n >= gsl_matrix2.size1) {
            throw new Exception("row index is out of range");
        }
        if (n2 >= gsl_matrix2.size2) {
            throw new Exception("column index is out of range");
        }
        if (n3 == 0) {
            throw new Exception("first dimension must be non-zero");
        }
        if (n4 == 0) {
            throw new Exception("second dimension must be non-zero");
        }
        if (n + n3 > gsl_matrix2.size1) {
            throw new Exception("first dimension overflows matrix");
        }
        if (n2 + n4 > gsl_matrix2.size2) {
            throw new Exception("second dimension overflows matrix");
        }
        gsl_matrix_view gsl_matrix_view2 = new gsl_matrix_view();
        gsl_matrix gsl_matrix3 = new gsl_matrix();
        gsl_matrix3.data = gsl_matrix2.data;
        gsl_matrix3.start = gsl_matrix2.start + (n * gsl_matrix2.tda + n2);
        gsl_matrix3.size1 = n3;
        gsl_matrix3.size2 = n4;
        gsl_matrix3.tda = gsl_matrix2.tda;
        gsl_matrix_view2.matrix = gsl_matrix3;
        return gsl_matrix_view2;
    }

    double gsl_vector_get(gsl_vector gsl_vector2, int n) throws Exception {
        if (n >= gsl_vector2.size || n < 0) {
            throw new Exception("int out of range");
        }
        return gsl_vector2.data[gsl_vector2.start + n * gsl_vector2.stride];
    }

    void gsl_vector_set(gsl_vector gsl_vector2, int n, double d) throws Exception {
        if (n >= gsl_vector2.size || n < 0) {
            throw new Exception("int out of range");
        }
        gsl_vector2.data[gsl_vector2.start + n * gsl_vector2.stride] = d;
    }

    void gsl_vector_swap_elements(gsl_vector gsl_vector2, int n, int n2) {
        double[] dArray = gsl_vector2.data;
        int n3 = gsl_vector2.stride;
        int n4 = gsl_vector2.start;
        if (n != n2) {
            double d = dArray[n2 * n3 + n4];
            dArray[n2 * n3 + n4] = dArray[n * n3 + n4];
            dArray[n * n3 + n4] = d;
        }
    }

    gsl_vector_view gsl_vector_subvector(gsl_vector gsl_vector2, int n, int n2) throws Exception {
        if (n2 == 0) {
            throw new Exception("vector length n must be positive integer");
        }
        if (n + (n2 - 1) >= gsl_vector2.size) {
            throw new Exception("view would extend past end of vector");
        }
        gsl_vector gsl_vector3 = new gsl_vector();
        gsl_vector_view gsl_vector_view2 = new gsl_vector_view();
        gsl_vector3.data = gsl_vector2.data;
        gsl_vector3.start = gsl_vector2.start + gsl_vector2.stride * n;
        gsl_vector3.size = n2;
        gsl_vector3.stride = gsl_vector2.stride;
        gsl_vector_view2.vector = gsl_vector3;
        return gsl_vector_view2;
    }

    int OFFSET(int n, int n2) {
        return n2 > 0 ? 0 : (n - 1) * -n2;
    }

    double cblas_dnrm2(int n, double[] dArray, int n2, int n3) {
        double d = 0.0;
        double d2 = 1.0;
        int n4 = n3;
        if (n <= 0 || n2 <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(dArray[0 + n3]);
        }
        for (int i = 0; i < n; ++i) {
            double d3 = dArray[n4];
            if (d3 != 0.0) {
                double d4 = Math.abs(d3);
                if (d < d4) {
                    d2 = 1.0 + d2 * (d / d4) * (d / d4);
                    d = d4;
                } else {
                    d2 += d4 / d * (d4 / d);
                }
            }
            n4 += n2;
        }
        return d * Math.sqrt(d2);
    }

    void cblas_dscal(int n, double d, double[] dArray, int n2, int n3) {
        if (n2 <= 0) {
            return;
        }
        int n4 = this.OFFSET(n, n2);
        for (int i = 0; i < n; ++i) {
            int n5 = n3 + n4;
            dArray[n5] = dArray[n5] * d;
            n4 += n2;
        }
    }

    void cblas_dsyr2(CBLAS_ORDER cBLAS_ORDER, CBLAS_UPLO cBLAS_UPLO, int n, double d, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, double[] dArray3, int n6, int n7) throws Exception {
        if (n == 0) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        if (cBLAS_ORDER == CBLAS_ORDER.CblasRowMajor && cBLAS_UPLO == CBLAS_UPLO.CblasLower || cBLAS_ORDER == CBLAS_ORDER.CblasColMajor && cBLAS_UPLO == CBLAS_UPLO.CblasUpper) {
            int n8 = n3;
            int n9 = n5;
            for (int i = 0; i < n; ++i) {
                double d2 = d * dArray[n8];
                double d3 = d * dArray2[n9];
                int n10 = n3;
                int n11 = n5;
                for (int j = 0; j <= i; ++j) {
                    int n12 = n6 * i + j + n7;
                    dArray3[n12] = dArray3[n12] + (d2 * dArray2[n11] + d3 * dArray[n10]);
                    n10 += n2;
                    n11 += n4;
                }
                n8 += n2;
                n9 += n4;
            }
        } else {
            throw new Exception("unrecognized operation");
        }
    }

    void cblas_dsymv(CBLAS_ORDER cBLAS_ORDER, CBLAS_UPLO cBLAS_UPLO, int n, double d, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, double d2, double[] dArray3, int n6, int n7) throws Exception {
        int n8;
        int n9;
        if (d == 0.0 && d2 == 1.0) {
            return;
        }
        if (d2 == 0.0) {
            n9 = this.OFFSET(n, n6);
            for (n8 = 0; n8 < n; ++n8) {
                dArray3[n9 + n7] = 0.0;
                n9 += n6;
            }
        } else if (d2 != 1.0) {
            n9 = this.OFFSET(n, n6);
            for (n8 = 0; n8 < n; ++n8) {
                int n10 = n9 + n7;
                dArray3[n10] = dArray3[n10] * d2;
                n9 += n6;
            }
        }
        if (d == 0.0) {
            return;
        }
        if (cBLAS_ORDER == CBLAS_ORDER.CblasRowMajor && cBLAS_UPLO == CBLAS_UPLO.CblasLower || cBLAS_ORDER == CBLAS_ORDER.CblasColMajor && cBLAS_UPLO == CBLAS_UPLO.CblasUpper) {
            n9 = this.OFFSET(n, n4) + (n - 1) * n4 + n5;
            int n11 = this.OFFSET(n, n6) + (n - 1) * n6 + n7;
            n8 = n;
            while (n8 > 0 && n8-- != 0) {
                double d3 = d * dArray2[n9];
                double d4 = 0.0;
                int n12 = n8;
                int n13 = 0 * n4 + n5;
                int n14 = 0 * n6 + n7;
                int n15 = n11;
                dArray3[n15] = dArray3[n15] + d3 * dArray[n2 * n8 + n8 + n3];
                for (int i = 0; i < n12; ++i) {
                    int n16 = n14;
                    dArray3[n16] = dArray3[n16] + d3 * dArray[n2 * n8 + i + n3];
                    d4 += dArray2[n13] * dArray[n2 * n8 + i + n3];
                    n13 += n4;
                    n14 += n6;
                }
                int n17 = n11;
                dArray3[n17] = dArray3[n17] + d * d4;
                n9 -= n4;
                n11 -= n6;
            }
        } else {
            throw new Exception("unrecognized operation");
        }
    }

    double gsl_blas_dnrm2(gsl_vector gsl_vector2) {
        return this.cblas_dnrm2(gsl_vector2.size, gsl_vector2.data, gsl_vector2.stride, gsl_vector2.start);
    }

    void gsl_blas_dsymv(CBLAS_UPLO cBLAS_UPLO, double d, gsl_matrix gsl_matrix2, gsl_vector gsl_vector2, double d2, gsl_vector gsl_vector3) throws Exception {
        int n = gsl_matrix2.size1;
        int n2 = gsl_matrix2.size2;
        if (n != n2) {
            throw new Exception("matrix must be square");
        }
        if (n2 != gsl_vector2.size || n2 != gsl_vector3.size) {
            throw new Exception("invalid length");
        }
        this.cblas_dsymv(CBLAS_ORDER.CblasRowMajor, cBLAS_UPLO, n2, d, gsl_matrix2.data, gsl_matrix2.tda, gsl_matrix2.start, gsl_vector2.data, gsl_vector2.stride, gsl_vector2.start, d2, gsl_vector3.data, gsl_vector3.stride, gsl_vector3.start);
    }

    void gsl_blas_dsyr2(CBLAS_UPLO cBLAS_UPLO, double d, gsl_vector gsl_vector2, gsl_vector gsl_vector3, gsl_matrix gsl_matrix2) throws Exception {
        int n = gsl_matrix2.size1;
        int n2 = gsl_matrix2.size2;
        if (n != n2) {
            throw new Exception("matrix must be square");
        }
        if (gsl_vector2.size != n2 || gsl_vector3.size != n2) {
            throw new Exception("invalid length");
        }
        this.cblas_dsyr2(CBLAS_ORDER.CblasRowMajor, cBLAS_UPLO, n2, d, gsl_vector2.data, gsl_vector2.stride, gsl_vector2.start, gsl_vector3.data, gsl_vector3.stride, gsl_vector3.start, gsl_matrix2.data, gsl_matrix2.tda, gsl_matrix2.start);
    }

    void gsl_blas_dscal(double d, gsl_vector gsl_vector2) {
        this.cblas_dscal(gsl_vector2.size, d, gsl_vector2.data, gsl_vector2.stride, gsl_vector2.start);
    }

    void gsl_blas_daxpy(double d, gsl_vector gsl_vector2, gsl_vector gsl_vector3) throws Exception {
        if (gsl_vector2.size != gsl_vector3.size) {
            throw new Exception("invalid length");
        }
        int n = gsl_vector2.size;
        double[] dArray = gsl_vector2.data;
        int n2 = gsl_vector2.stride;
        double[] dArray2 = gsl_vector3.data;
        int n3 = gsl_vector3.stride;
        int n4 = gsl_vector2.start;
        int n5 = gsl_vector3.start;
        if (d == 0.0) {
            return;
        }
        assert (n2 > 0 && n3 > 0);
        int n6 = n4;
        int n7 = n5;
        for (int i = 0; i < n; ++i) {
            int n8 = n7;
            dArray2[n8] = dArray2[n8] + d * dArray[n6];
            n6 += n2;
            n7 += n3;
        }
    }

    double gsl_blas_ddot(gsl_vector gsl_vector2, gsl_vector gsl_vector3) throws Exception {
        if (gsl_vector2.size != gsl_vector3.size) {
            throw new Exception("invalid length");
        }
        int n = gsl_vector2.size;
        double[] dArray = gsl_vector2.data;
        int n2 = gsl_vector2.stride;
        int n3 = gsl_vector2.start;
        double[] dArray2 = gsl_vector3.data;
        int n4 = gsl_vector3.stride;
        int n5 = gsl_vector3.start;
        double d = 0.0;
        assert (n2 > 0 && n4 > 0);
        int n6 = n3;
        int n7 = n5;
        for (int i = 0; i < n; ++i) {
            d += dArray[n6] * dArray2[n7];
            n6 += n2;
            n7 += n4;
        }
        return d;
    }

    double gsl_linalg_householder_transform(gsl_vector gsl_vector2) throws Exception {
        int n = gsl_vector2.size;
        if (n == 1) {
            return 0.0;
        }
        gsl_vector_view gsl_vector_view2 = this.gsl_vector_subvector(gsl_vector2, 1, n - 1);
        double d = this.gsl_blas_dnrm2(gsl_vector_view2.vector);
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = this.gsl_vector_get(gsl_vector2, 0);
        double d3 = -(d2 >= 0.0 ? 1.0 : -1.0) * Math.hypot(d2, d);
        double d4 = (d3 - d2) / d3;
        this.gsl_blas_dscal(1.0 / (d2 - d3), gsl_vector_view2.vector);
        this.gsl_vector_set(gsl_vector2, 0, d3);
        return d4;
    }

    void gsl_linalg_householder_hm(double d, gsl_vector gsl_vector2, gsl_matrix gsl_matrix2) throws Exception {
        if (d == 0.0) {
            return;
        }
        gsl_vector_view gsl_vector_view2 = this.gsl_vector_subvector(gsl_vector2, 1, gsl_vector2.size - 1);
        gsl_matrix_view gsl_matrix_view2 = this.gsl_matrix_submatrix(gsl_matrix2, 1, 0, gsl_matrix2.size1 - 1, gsl_matrix2.size2);
        gsl_vector gsl_vector3 = new gsl_vector();
        gsl_vector3.data = gsl_matrix_view2.matrix.data;
        gsl_vector3.size = gsl_matrix_view2.matrix.size1;
        gsl_vector3.stride = gsl_matrix_view2.matrix.tda;
        gsl_vector3.start = gsl_matrix_view2.matrix.start;
        for (int i = 0; i < gsl_matrix2.size2; ++i) {
            double d2 = gsl_matrix2.data[gsl_matrix2.start + i];
            double d3 = this.gsl_blas_ddot(gsl_vector3, gsl_vector_view2.vector) + d2;
            gsl_matrix2.data[gsl_matrix2.start + i] = d2 - d * d3;
            this.gsl_blas_daxpy(-d * d3, gsl_vector_view2.vector, gsl_vector3);
            ++gsl_vector3.start;
        }
    }

    void gsl_linalg_symmtd_decomp(gsl_matrix gsl_matrix2, gsl_vector gsl_vector2) throws Exception {
        if (gsl_matrix2.size1 != gsl_matrix2.size2) {
            throw new Exception("symmetric tridiagonal decomposition requires square matrix");
        }
        if (gsl_vector2.size + 1 != gsl_matrix2.size1) {
            throw new Exception("size of tau must be (matrix size - 1)");
        }
        int n = gsl_matrix2.size1;
        for (int i = 0; i < n - 2; ++i) {
            gsl_vector_view gsl_vector_view2 = this.gsl_matrix_column(gsl_matrix2, i);
            gsl_vector_view gsl_vector_view3 = this.gsl_vector_subvector(gsl_vector_view2.vector, i + 1, n - (i + 1));
            double d = this.gsl_linalg_householder_transform(gsl_vector_view3.vector);
            if (d != 0.0) {
                gsl_matrix_view gsl_matrix_view2 = this.gsl_matrix_submatrix(gsl_matrix2, i + 1, i + 1, n - (i + 1), n - (i + 1));
                double d2 = this.gsl_vector_get(gsl_vector_view3.vector, 0);
                gsl_vector_view gsl_vector_view4 = this.gsl_vector_subvector(gsl_vector2, i, n - (i + 1));
                this.gsl_vector_set(gsl_vector_view3.vector, 0, 1.0);
                this.gsl_blas_dsymv(CBLAS_UPLO.CblasLower, d, gsl_matrix_view2.matrix, gsl_vector_view3.vector, 0.0, gsl_vector_view4.vector);
                double d3 = this.gsl_blas_ddot(gsl_vector_view4.vector, gsl_vector_view3.vector);
                double d4 = -(d / 2.0) * d3;
                this.gsl_blas_daxpy(d4, gsl_vector_view3.vector, gsl_vector_view4.vector);
                this.gsl_blas_dsyr2(CBLAS_UPLO.CblasLower, -1.0, gsl_vector_view3.vector, gsl_vector_view4.vector, gsl_matrix_view2.matrix);
                this.gsl_vector_set(gsl_vector_view3.vector, 0, d2);
            }
            this.gsl_vector_set(gsl_vector2, i, d);
        }
    }

    void gsl_linalg_symmtd_unpack(gsl_matrix gsl_matrix2, gsl_vector gsl_vector2, gsl_matrix gsl_matrix3, gsl_vector gsl_vector3, gsl_vector gsl_vector4) throws Exception {
        if (gsl_matrix2.size1 != gsl_matrix2.size2) {
            throw new Exception("matrix A must be square");
        }
        if (gsl_vector2.size + 1 != gsl_matrix2.size1) {
            throw new Exception("size of tau must be (matrix size - 1)");
        }
        if (gsl_matrix3.size1 != gsl_matrix2.size1 || gsl_matrix3.size2 != gsl_matrix2.size1) {
            throw new Exception("size of Q must match size of A");
        }
        if (gsl_vector3.size != gsl_matrix2.size1) {
            throw new Exception("size of diagonal must match size of A");
        }
        if (gsl_vector4.size + 1 != gsl_matrix2.size1) {
            throw new Exception("size of subdiagonal must be (matrix size - 1)");
        }
        int n = gsl_matrix2.size1;
        this.gsl_matrix_set_identity(gsl_matrix3);
        int n2 = n - 2;
        while (n2-- > 0) {
            gsl_vector_view gsl_vector_view2 = this.gsl_matrix_column(gsl_matrix2, n2);
            gsl_vector_view gsl_vector_view3 = this.gsl_vector_subvector(gsl_vector_view2.vector, n2 + 1, n - (n2 + 1));
            double d = this.gsl_vector_get(gsl_vector2, n2);
            gsl_matrix_view gsl_matrix_view2 = this.gsl_matrix_submatrix(gsl_matrix3, n2 + 1, n2 + 1, n - (n2 + 1), n - (n2 + 1));
            this.gsl_linalg_householder_hm(d, gsl_vector_view3.vector, gsl_matrix_view2.matrix);
        }
        for (n2 = 0; n2 < n; ++n2) {
            double d = this.gsl_matrix_get(gsl_matrix2, n2, n2);
            this.gsl_vector_set(gsl_vector3, n2, d);
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            double d = this.gsl_matrix_get(gsl_matrix2, n2 + 1, n2);
            this.gsl_vector_set(gsl_vector4, n2, d);
        }
    }

    void chop_small_elements(int n, double[] dArray, double[] dArray2) {
        double d = dArray[0];
        for (int i = 0; i < n - 1; ++i) {
            double d2 = dArray2[i];
            double d3 = dArray[i + 1];
            double d4 = 2.220446049250313E-16;
            if (Math.abs(d2) < d4 * (Math.abs(d) + Math.abs(d3))) {
                dArray2[i] = 0.0;
            }
            d = d3;
        }
    }

    double[] create_givens(double d, double d2) {
        double d3;
        double d4;
        double d5;
        if (d2 == 0.0) {
            d5 = 1.0;
            d4 = 0.0;
        } else if (Math.abs(d2) > Math.abs(d)) {
            double d6;
            d3 = -d / d2;
            d4 = d6 = 1.0 / Math.sqrt(1.0 + d3 * d3);
            d5 = d6 * d3;
        } else {
            double d7;
            d3 = -d2 / d;
            d5 = d7 = 1.0 / Math.sqrt(1.0 + d3 * d3);
            d4 = d7 * d3;
        }
        double[] dArray = new double[]{d5, d4};
        return dArray;
    }

    double trailing_eigenvalue(int n, double[] dArray, double[] dArray2, int n2) {
        double d = dArray[n - 2 + n2];
        double d2 = dArray[n - 1 + n2];
        double d3 = dArray2[n - 2 + n2];
        double d4 = (d - d2) / 2.0;
        double d5 = d4 > 0.0 ? d2 - d3 * (d3 / (d4 + Math.hypot(d4, d3))) : (d4 == 0.0 ? d2 - Math.abs(d3) : d2 + d3 * (d3 / (-d4 + Math.hypot(d4, d3))));
        return d5;
    }

    void qrstep(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
        double d = this.trailing_eigenvalue(n, dArray, dArray2, n2);
        double d2 = dArray[0 + n2] - d;
        double d3 = dArray2[0 + n2];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = dArray[0 + n2];
        double d8 = dArray2[0 + n2];
        double d9 = dArray[1 + n2];
        if (n == 2) {
            double[] dArray5 = this.create_givens(d2, d3);
            double d10 = dArray5[0];
            double d11 = dArray5[1];
            if (dArray3 != null) {
                dArray3[0] = d10;
            }
            if (dArray4 != null) {
                dArray4[0] = d11;
            }
            double d12 = d10 * (d10 * d7 - d11 * d8) + d11 * (d11 * d9 - d10 * d8);
            double d13 = d10 * (d11 * d7 + d10 * d8) - d11 * (d11 * d8 + d10 * d9);
            double d14 = d11 * (d11 * d7 + d10 * d8) + d10 * (d11 * d8 + d10 * d9);
            d4 = d12;
            d5 = d13;
            d7 = d14;
            dArray[0 + n2] = d4;
            dArray2[0 + n2] = d5;
            dArray[1 + n2] = d7;
            return;
        }
        double d15 = dArray2[1 + n2];
        for (int i = 0; i < n - 1; ++i) {
            double[] dArray6 = this.create_givens(d2, d3);
            double d16 = dArray6[0];
            double d17 = dArray6[1];
            if (dArray3 != null) {
                dArray3[i] = d16;
            }
            if (dArray4 != null) {
                dArray4[i] = d17;
            }
            double d18 = d16 * d5 - d17 * d6;
            double d19 = d16 * (d16 * d7 - d17 * d8) + d17 * (d17 * d9 - d16 * d8);
            double d20 = d16 * (d17 * d7 + d16 * d8) - d17 * (d17 * d8 + d16 * d9);
            double d21 = -d17 * d15;
            double d22 = d17 * (d17 * d7 + d16 * d8) + d16 * (d17 * d8 + d16 * d9);
            double d23 = d16 * d15;
            d4 = d19;
            d5 = d20;
            d6 = d21;
            d7 = d22;
            d8 = d23;
            if (i < n - 2) {
                d9 = dArray[i + 2 + n2];
            }
            if (i < n - 3) {
                d15 = dArray2[i + 2 + n2];
            }
            dArray[i + n2] = d4;
            if (i > 0) {
                dArray2[i - 1 + n2] = d18;
            }
            if (i < n - 2) {
                dArray2[i + 1 + n2] = d8;
            }
            d2 = d5;
            d3 = d6;
        }
        dArray[i + n2] = d7;
        dArray2[i - 1 + n2] = d5;
    }

    void gsl_eigen_symmv(gsl_matrix gsl_matrix2, gsl_vector gsl_vector2, gsl_matrix gsl_matrix3, gsl_eigen_symmv_workspace gsl_eigen_symmv_workspace2) throws Exception {
        if (gsl_matrix2.size1 != gsl_matrix2.size2) {
            throw new Exception("matrix must be square to compute eigenvalues");
        }
        if (gsl_vector2.size != gsl_matrix2.size1) {
            throw new Exception("eigenvalue vector must match matrix size");
        }
        if (gsl_matrix3.size1 != gsl_matrix2.size1 || gsl_matrix3.size2 != gsl_matrix2.size1) {
            throw new Exception("eigenvector matrix must match matrix size");
        }
        double[] dArray = gsl_eigen_symmv_workspace2.d;
        double[] dArray2 = gsl_eigen_symmv_workspace2.sd;
        int n = gsl_matrix2.size1;
        if (n == 1) {
            double d = this.gsl_matrix_get(gsl_matrix2, 0, 0);
            this.gsl_vector_set(gsl_vector2, 0, d);
            this.gsl_matrix_set(gsl_matrix3, 0, 0, 1.0);
            return;
        }
        gsl_vector_view gsl_vector_view2 = new gsl_vector_view(dArray, n);
        gsl_vector_view gsl_vector_view3 = new gsl_vector_view(dArray2, n - 1);
        Object object = new gsl_vector_view(dArray2, n - 1);
        this.gsl_linalg_symmtd_decomp(gsl_matrix2, ((gsl_vector_view)object).vector);
        this.gsl_linalg_symmtd_unpack(gsl_matrix2, ((gsl_vector_view)object).vector, gsl_matrix3, gsl_vector_view2.vector, gsl_vector_view3.vector);
        gsl_matrix2 = null;
        this.chop_small_elements(n, dArray, dArray2);
        int n2 = n - 1;
        while (n2 > 0) {
            int n3;
            if (dArray2[n2 - 1] == 0.0 || Double.isNaN(dArray2[n2 - 1])) {
                --n2;
                continue;
            }
            for (n3 = n2 - 1; n3 > 0 && dArray2[n3 - 1] != 0.0; --n3) {
            }
            int n4 = n2 - n3 + 1;
            object = gsl_eigen_symmv_workspace2.gc;
            double[] dArray3 = gsl_eigen_symmv_workspace2.gs;
            this.qrstep(n4, dArray, dArray2, (double[])object, dArray3, n3);
            for (int i = 0; i < n4 - 1; ++i) {
                Object object2 = object[i];
                double d = dArray3[i];
                double[] dArray4 = gsl_matrix3.data;
                int n5 = gsl_matrix3.start + n3 + i;
                for (int j = 0; j < n; ++j) {
                    double d2 = dArray4[n5];
                    double d3 = dArray4[n5 + 1];
                    dArray4[n5] = d2 * object2 - d3 * d;
                    dArray4[n5 + 1] = d2 * d + d3 * object2;
                    n5 += gsl_matrix3.tda;
                }
            }
            this.chop_small_elements(n, dArray, dArray2);
        }
        gsl_vector_view gsl_vector_view4 = new gsl_vector_view(dArray, n);
        for (int i = 0; i < n; ++i) {
            this.gsl_vector_set(gsl_vector2, i, this.gsl_vector_get(gsl_vector_view4.vector, i));
        }
    }

    void gsl_eigen_symmv_sort(gsl_vector gsl_vector2, gsl_matrix gsl_matrix2) throws Exception {
        if (gsl_matrix2.size1 != gsl_matrix2.size2) {
            throw new Exception("eigenvector matrix must be square");
        }
        if (gsl_vector2.size != gsl_matrix2.size1) {
            throw new Exception("eigenvalues must match eigenvector matrix");
        }
        int n = gsl_vector2.size;
        for (int i = 0; i < n - 1; ++i) {
            int n2 = i;
            double d = this.gsl_vector_get(gsl_vector2, i);
            for (int j = i + 1; j < n; ++j) {
                boolean bl;
                double d2 = this.gsl_vector_get(gsl_vector2, j);
                boolean bl2 = bl = Math.abs(d2) > Math.abs(d);
                if (!bl) continue;
                n2 = j;
                d = d2;
            }
            if (n2 == i) continue;
            this.gsl_vector_swap_elements(gsl_vector2, i, n2);
            this.gsl_matrix_swap_columns(gsl_matrix2, i, n2);
        }
    }

    static enum CBLAS_ORDER {
        CblasRowMajor,
        CblasColMajor;

    }

    static enum CBLAS_UPLO {
        CblasUpper,
        CblasLower;

    }

    class gsl_matrix_view {
        gsl_matrix matrix;

        gsl_matrix_view() {
        }
    }

    class gsl_vector_view {
        gsl_vector vector;

        gsl_vector_view() {
        }

        gsl_vector_view(double[] dArray, int n) throws Exception {
            if (n == 0) {
                throw new Exception("vector length n must be positive integer");
            }
            this.vector = new gsl_vector();
            this.vector.data = dArray;
            this.vector.size = n;
            this.vector.stride = 1;
        }
    }

    class gsl_vector {
        int size;
        int stride;
        int start;
        double[] data;

        gsl_vector() {
        }

        gsl_vector(double[] dArray) {
            this.stride = 1;
            this.size = dArray.length;
            this.start = 0;
            this.data = Arrays.copyOf(dArray, dArray.length);
        }

        gsl_vector(int n) {
            this.data = new double[n];
            this.size = n;
            this.stride = 1;
        }
    }

    class gsl_matrix {
        int size1;
        int size2;
        int tda;
        int start;
        double[] data;

        gsl_matrix() {
        }

        gsl_matrix(int n, int n2) {
            this.size1 = n;
            this.size2 = n2;
            this.tda = this.size1;
            this.start = 0;
            this.data = new double[this.size1 * this.size2];
        }

        gsl_matrix(float[][] fArray) {
            assert (fArray.length > 0);
            this.size1 = fArray.length;
            this.size2 = fArray[0].length;
            this.tda = this.size1;
            this.start = 0;
            this.data = new double[this.size1 * this.size2];
            for (int i = 0; i < fArray.length; ++i) {
                assert (fArray[i].length == fArray[0].length);
                for (int j = 0; j < fArray[i].length; ++j) {
                    this.data[i * this.size1 + j] = fArray[i][j];
                }
            }
        }
    }

    class gsl_eigen_symmv_workspace {
        int size;
        double[] d;
        double[] sd;
        double[] gc;
        double[] gs;

        public gsl_eigen_symmv_workspace(int n) throws Exception {
            if (n == 0) {
                throw new Exception("matrix dimension must be positive integer");
            }
            this.d = new double[n];
            this.sd = new double[n];
            this.gc = new double[n];
            this.gs = new double[n];
            this.size = n;
        }
    }
}

