/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class LevelUnshift {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int LSType;
    boolean[] LSComponents = null;
    int[] LSSubsValues = null;
    int[] QComponentsBits = null;
    boolean parametersSet = false;

    public LevelUnshift(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int n, boolean[] blArray, int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.LSType = n;
        this.LSComponents = blArray;
        this.LSSubsValues = nArray;
        this.QComponentsBits = nArray2;
    }

    public float[][][] run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Parameters not set.");
        }
        if (this.LSType != 0) {
            int n;
            if (this.LSSubsValues == null) {
                this.LSSubsValues = new int[this.zSize];
            }
            switch (this.LSType) {
                case 1: {
                    for (n = 0; n < this.zSize; ++n) {
                        this.LSSubsValues[n] = (int)Math.pow(2.0, this.QComponentsBits[n] - 1);
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new ErrorException("Unrecognized level unshift type.");
                }
            }
            for (n = 0; n < this.zSize; ++n) {
                if (this.LSComponents[n]) {
                    if (this.LSSubsValues[n] == 0) continue;
                    for (int i = 0; i < this.ySize; ++i) {
                        int n2 = 0;
                        while (n2 < this.xSize) {
                            float[] fArray = this.imageSamples[n][i];
                            int n3 = n2++;
                            fArray[n3] = fArray[n3] + (float)this.LSSubsValues[n];
                        }
                    }
                    continue;
                }
                this.LSSubsValues[n] = 0;
            }
        }
        return this.imageSamples;
    }
}

