/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class MaskWaveletDomainByteMap {
    byte[][][] bitMap = null;
    byte[][][] nextRlevelBitMap = null;
    long[][][] imageSamples = null;
    byte[][][] maskSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] WTLevels = null;
    int[] WTTypes = null;
    int[] RroiValues;
    boolean parametersSet = false;
    int[][][] subbandSizes = null;
    private final int[][] filter_5_3_EvenEven = new int[][]{{0, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, -1, 1}, {0, 0, 2}, {0, -1, 2}, {-1, 0, 2}, {-1, -1, 2}, {0, 0, 3}};
    private final int[][] filter_5_3_EvenOdd = new int[][]{{-1, 1, 0}, {0, 1, 0}, {0, 1, 1}, {-1, 1, 2}, {0, 1, 2}, {0, 1, 3}};
    private final int[][] filter_5_3_OddEven = new int[][]{{1, 0, 0}, {1, 0, 1}, {1, -1, 1}, {1, -1, 2}, {1, 0, 2}, {1, 0, 3}};
    private final int[][] filter_5_3_OddOdd = new int[][]{{1, 1, 0}, {1, 1, 1}, {1, 0, 2}, {0, 1, 2}, {1, 1, 2}, {1, 1, 3}};
    private final int[][] filter_9_7_AnyAny = new int[][]{{-2, -1, 0}, {-2, 0, 0}, {-2, 1, 0}, {-2, 2, 0}, {-1, -1, 0}, {-1, 0, 0}, {-1, 1, 0}, {-1, 2, 0}, {0, -1, 0}, {0, 0, 0}, {0, 1, 0}, {0, 2, 0}, {1, -1, 0}, {1, 0, 0}, {1, 1, 0}, {1, 2, 0}, {2, -1, 0}, {2, 0, 0}, {2, 1, 0}, {2, 2, 0}, {-1, -2, 1}, {-1, -1, 1}, {-1, 0, 1}, {-1, 1, 1}, {-1, 2, 1}, {0, -2, 1}, {0, -1, 1}, {0, 0, 1}, {0, 1, 1}, {0, 2, 1}, {1, -2, 1}, {1, -1, 1}, {1, 0, 1}, {1, 1, 1}, {1, 2, 1}, {2, -2, 1}, {2, -1, 1}, {2, 0, 1}, {2, 1, 1}, {2, 2, 1}, {-2, -2, 2}, {-2, -1, 2}, {-2, 0, 2}, {-2, 1, 2}, {-2, 2, 2}, {-1, -2, 2}, {-1, -1, 2}, {-1, 0, 2}, {-1, 1, 2}, {-1, 2, 2}, {0, -2, 2}, {0, -1, 2}, {0, 0, 2}, {0, 1, 2}, {0, 2, 2}, {1, -2, 2}, {1, -1, 2}, {1, 0, 2}, {1, 1, 2}, {1, 2, 2}, {2, -2, 2}, {2, -1, 2}, {2, 0, 2}, {2, 1, 2}, {2, 2, 2}, {-1, -1, 3}, {-1, 0, 3}, {-1, 1, 3}, {-1, 2, 3}, {0, -1, 3}, {0, 0, 3}, {0, 1, 3}, {0, 2, 3}, {1, -1, 3}, {1, 0, 3}, {1, 1, 3}, {1, 2, 3}, {2, -1, 3}, {2, 0, 3}, {2, 1, 3}, {2, 2, 3}};
    private final int[][] filter_9_7_AnyAny_dist_0_1_2 = new int[][]{{-2, -1, 0, 1}, {-2, 0, 0, 1}, {-2, 1, 0, 1}, {-2, 2, 0, 1}, {-1, -1, 0, 3}, {-1, 0, 0, 3}, {-1, 1, 0, 3}, {-1, 2, 0, 1}, {0, -1, 0, 3}, {0, 0, 0, 5}, {0, 1, 0, 3}, {0, 2, 0, 1}, {1, -1, 0, 3}, {1, 0, 0, 3}, {1, 1, 0, 3}, {1, 2, 0, 1}, {2, -1, 0, 1}, {2, 0, 0, 1}, {2, 1, 0, 1}, {2, 2, 0, 1}, {-1, -2, 1, 1}, {-1, -1, 1, 3}, {-1, 0, 1, 3}, {-1, 1, 1, 3}, {-1, 2, 1, 1}, {0, -2, 1, 1}, {0, -1, 1, 3}, {0, 0, 1, 5}, {0, 1, 1, 3}, {0, 2, 1, 1}, {1, -2, 1, 1}, {1, -1, 1, 3}, {1, 0, 1, 3}, {1, 1, 1, 3}, {1, 2, 1, 1}, {2, -2, 1, 1}, {2, -1, 1, 1}, {2, 0, 1, 1}, {2, 1, 1, 1}, {2, 2, 1, 1}, {-2, -2, 2, 1}, {-2, -1, 2, 1}, {-2, 0, 2, 1}, {-2, 1, 2, 1}, {-2, 2, 2, 1}, {-1, -2, 2, 1}, {-1, -1, 2, 3}, {-1, 0, 2, 3}, {-1, 1, 2, 3}, {-1, 2, 2, 1}, {0, -2, 2, 1}, {0, -1, 2, 3}, {0, 0, 2, 5}, {0, 1, 2, 3}, {0, 2, 2, 1}, {1, -2, 2, 1}, {1, -1, 2, 3}, {1, 0, 2, 3}, {1, 1, 2, 3}, {1, 2, 2, 1}, {2, -2, 2, 1}, {2, -1, 2, 1}, {2, 0, 2, 1}, {2, 1, 2, 1}, {2, 2, 2, 1}, {-1, -1, 3, 3}, {-1, 0, 3, 3}, {-1, 1, 3, 3}, {-1, 2, 3, 1}, {0, -1, 3, 3}, {0, 0, 3, 5}, {0, 1, 3, 3}, {0, 2, 3, 1}, {1, -1, 3, 3}, {1, 0, 3, 3}, {1, 1, 3, 3}, {1, 2, 3, 1}, {2, -1, 3, 1}, {2, 0, 3, 1}, {2, 1, 3, 1}, {2, 2, 3, 1}};
    private final int[][] filter_9_7_AnyAny_dist_0 = new int[][]{{0, 0, 0, 5}, {0, 0, 1, 5}, {0, 0, 2, 5}, {0, 0, 3, 5}};
    private final int[][] filter_9_7_AnyAny_dist_0_1 = new int[][]{{-1, -1, 0, 3}, {-1, 0, 0, 3}, {-1, 1, 0, 3}, {0, -1, 0, 3}, {0, 0, 0, 3}, {0, 1, 0, 3}, {1, -1, 0, 3}, {1, 0, 0, 3}, {1, 1, 0, 3}, {-1, -1, 1, 3}, {-1, 0, 1, 3}, {-1, 1, 1, 3}, {0, -1, 1, 3}, {0, 0, 1, 3}, {0, 1, 1, 3}, {1, -1, 1, 3}, {1, 0, 1, 3}, {1, 1, 1, 3}, {-1, -1, 2, 3}, {-1, 0, 2, 3}, {-1, 1, 2, 3}, {0, -1, 2, 3}, {0, 0, 2, 3}, {0, 1, 2, 3}, {1, -1, 2, 3}, {1, 0, 2, 3}, {1, 1, 2, 3}, {-1, -1, 3, 3}, {-1, 0, 3, 3}, {-1, 1, 3, 3}, {0, -1, 3, 3}, {0, 0, 3, 3}, {0, 1, 3, 3}, {1, -1, 3, 3}, {1, 0, 3, 3}, {1, 1, 3, 3}};
    private final int[][] filter_9_7_AnyAny_x = new int[][]{{2, -1, 0}, {2, 0, 0}, {2, 1, 0}, {2, 2, 0}, {2, -2, 1}, {2, -1, 1}, {2, 0, 1}, {2, 1, 1}, {2, 2, 1}, {2, -2, 2}, {2, -1, 2}, {2, 0, 2}, {2, 1, 2}, {2, 2, 2}, {2, -1, 3}, {2, 0, 3}, {2, 1, 3}, {2, 2, 3}};
    private final int[][] filter_9_7_AnyAny_y = new int[][]{{-2, 2, 0}, {-1, 2, 0}, {0, 2, 0}, {1, 2, 0}, {2, 2, 0}, {-1, 2, 1}, {0, 2, 1}, {1, 2, 1}, {2, 2, 1}, {-2, 2, 2}, {-1, 2, 2}, {0, 2, 2}, {1, 2, 2}, {2, 2, 2}, {-1, 2, 3}, {0, 2, 3}, {1, 2, 3}, {2, 2, 3}};
    int z = 0;
    int maxRLevel;
    int[][][] involvedCoeffs = null;
    int roiValue = 0;

    public MaskWaveletDomainByteMap(long[][][] lArray) {
        this.imageSamples = lArray;
        this.zSize = lArray.length;
        this.ySize = lArray[0].length;
        this.xSize = lArray[0][0].length;
    }

    public void setParameters(byte[][][] byArray, int[] nArray, int[] nArray2, int[] nArray3) {
        this.parametersSet = true;
        this.maskSamples = byArray;
        this.WTLevels = nArray;
        this.WTTypes = nArray2;
        this.RroiValues = nArray3;
        if (this.involvedCoeffs != null) {
            this.involvedCoeffs = new int[this.zSize][][];
            for (int i = 0; i < this.zSize; ++i) {
                this.involvedCoeffs[i] = new int[nArray[i]][3];
            }
            this.involvedCoeffs = this.involvedCoeffs;
        }
    }

    public void run() throws ErrorException {
        this.bitMap = new byte[this.RroiValues.length][this.ySize][this.xSize];
        this.roiValue = 0;
        while (this.roiValue < this.RroiValues.length) {
            int n;
            int n2;
            this.subbandSizes = new int[this.WTLevels[this.z]][3][4];
            this.SubbandSizesCalculation(this.z, this.subbandSizes);
            this.nextRlevelBitMap = new byte[this.WTLevels[this.z]][][];
            for (n2 = 0; n2 < this.WTLevels[this.z]; ++n2) {
                this.nextRlevelBitMap[n2] = new byte[this.subbandSizes[n2][1][0]][this.subbandSizes[n2][0][1]];
                for (n = 0; n < this.subbandSizes[n2][1][0]; ++n) {
                    for (int i = 0; i < this.subbandSizes[n2][0][1]; ++i) {
                        this.nextRlevelBitMap[n2][n][i] = -1;
                    }
                }
            }
            for (n2 = 0; n2 < this.ySize; ++n2) {
                for (n = 0; n < this.xSize; ++n) {
                    this.bitMap[this.roiValue][n2][n] = -1;
                }
            }
            if (this.WTLevels[this.z] == 0) {
                for (n2 = 0; n2 < this.ySize; ++n2) {
                    for (n = 0; n < this.xSize; ++n) {
                        if (!this.isRoi(this.z, n2, n)) continue;
                        this.bitMap[this.roiValue][n2][n] = 1;
                    }
                }
            } else {
                this.maxRLevel = this.WTLevels[this.z] - 1;
                switch (this.WTTypes[this.z]) {
                    case 1: {
                        this.rasterWavelet5_3(this.z);
                        break;
                    }
                    case 2: {
                        this.rasterWavelet9_7(this.z);
                    }
                }
            }
            ++this.roiValue;
        }
    }

    protected void rasterWavelet5_3(int n) {
        for (int i = 0; i < this.WTLevels[n]; ++i) {
            for (int j = 0; j < this.subbandSizes[i][1][2]; ++j) {
                for (int k = 0; k < this.subbandSizes[i][0][3]; ++k) {
                    if (i == 0) {
                        if (!this.isRoi(n, j, k)) continue;
                        if (k % 2 == 0 && j % 2 == 0) {
                            this.evenEven(n, i, j, k);
                            continue;
                        }
                        if (k % 2 == 0 && j % 2 == 1) {
                            if (j > 1 && k < this.xSize - 1) {
                                if (this.isRoi(n, j - 1, k) || this.isRoi(n, j - 1, k + 1)) {
                                    this.evenOdd(n, i, j, k);
                                    continue;
                                }
                                this.evenEven(n, i, j, k);
                                this.evenOdd(n, i, j, k);
                                continue;
                            }
                            this.evenEven(n, i, j, k);
                            this.evenOdd(n, i, j, k);
                            continue;
                        }
                        if (k % 2 == 1 && j % 2 == 0) {
                            if (j > 1 && k < this.xSize - 1) {
                                if (this.isRoi(n, j, k - 1)) {
                                    this.oddEven(n, i, j, k);
                                    continue;
                                }
                                this.evenEven(n, i, j, k);
                                this.oddEven(n, i, j, k);
                                continue;
                            }
                            this.evenEven(n, i, j, k);
                            this.oddEven(n, i, j, k);
                            continue;
                        }
                        if (k % 2 != 1 || j % 2 != 1) continue;
                        if (j > 1 && k < this.xSize - 1) {
                            if (this.isRoi(n, j, k - 1) && this.isRoi(n, j - 1, k)) {
                                this.oddOdd(n, i, j, k);
                                continue;
                            }
                            this.evenEven(n, i, j, k);
                            this.oddEven(n, i, j, k);
                            this.evenOdd(n, i, j, k);
                            this.oddOdd(n, i, j, k);
                            continue;
                        }
                        this.evenEven(n, i, j, k);
                        this.oddEven(n, i, j, k);
                        this.evenOdd(n, i, j, k);
                        this.oddOdd(n, i, j, k);
                        continue;
                    }
                    if (!this.isMarked(n, i, j, k)) continue;
                    if (k % 2 == 0 && j % 2 == 0) {
                        this.evenEven(n, i, j, k);
                        continue;
                    }
                    if (k % 2 == 0 && j % 2 == 1) {
                        if (j > 1 && k < this.xSize - 1) {
                            if (this.isMarked(n, i, j - 1, k) || this.isMarked(n, i, j - 1, k + 1)) {
                                this.evenOdd(n, i, j, k);
                                continue;
                            }
                            this.evenEven(n, i, j, k);
                            this.evenOdd(n, i, j, k);
                            continue;
                        }
                        this.evenEven(n, i, j, k);
                        this.evenOdd(n, i, j, k);
                        continue;
                    }
                    if (k % 2 == 1 && j % 2 == 0) {
                        if (j > 1 && k < this.xSize - 1) {
                            if (this.isMarked(n, i, j, k - 1)) {
                                this.oddEven(n, i, j, k);
                                continue;
                            }
                            this.evenEven(n, i, j, k);
                            this.oddEven(n, i, j, k);
                            continue;
                        }
                        this.evenEven(n, i, j, k);
                        this.oddEven(n, i, j, k);
                        continue;
                    }
                    if (k % 2 != 1 || j % 2 != 1) continue;
                    if (j > 1 && k < this.xSize - 1) {
                        if (this.isMarked(n, i, j, k - 1) && this.isMarked(n, i, j - 1, k)) {
                            this.oddOdd(n, i, j, k);
                            continue;
                        }
                        this.evenEven(n, i, j, k);
                        this.oddEven(n, i, j, k);
                        this.evenOdd(n, i, j, k);
                        this.oddOdd(n, i, j, k);
                        continue;
                    }
                    this.evenEven(n, i, j, k);
                    this.oddEven(n, i, j, k);
                    this.evenOdd(n, i, j, k);
                    this.oddOdd(n, i, j, k);
                }
            }
        }
    }

    protected void rasterWavelet9_7(int n) {
        for (int i = 0; i < this.WTLevels[n]; ++i) {
            for (int j = 0; j < this.subbandSizes[i][1][2]; ++j) {
                for (int k = 0; k < this.subbandSizes[i][0][3]; ++k) {
                    if (i == 0) {
                        if (!this.isRoi(n, j, k)) continue;
                        if (k % 2 == 0 && j % 2 == 0) {
                            if (j > 1 && k > 0 && k < this.xSize - 1) {
                                if (this.isRoi(n, j - 2, k) || this.isRoi(n, j - 1, k) || this.isRoi(n, j - 2, k + 1) || this.isRoi(n, j - 1, k + 1)) {
                                    this.anyAny_y(n, i, j, k);
                                    continue;
                                }
                                if (this.isRoi(n, j, k - 2) || this.isRoi(n, j, k - 1)) {
                                    this.anyAny_x(n, i, j, k);
                                    continue;
                                }
                                this.anyAny(n, i, j, k);
                                continue;
                            }
                            this.anyAny(n, i, j, k);
                            continue;
                        }
                        if (k % 2 == 0 && j % 2 == 1) {
                            if (j > 2 && k > 2 && k < this.xSize - 1) {
                                if (this.isRoi(n, j - 3, k) || this.isRoi(n, j - 2, k) || this.isRoi(n, j - 3, k + 1) || this.isRoi(n, j - 2, k + 1)) {
                                    if (this.isRoi(n, j - 1, k) && this.isRoi(n, j - 1, k + 1)) continue;
                                    this.anyAny_y(n, i, j, k);
                                    continue;
                                }
                                if (this.isRoi(n, j, k - 2) || this.isRoi(n, j, k - 1) || this.isRoi(n, j - 1, k - 2) || this.isRoi(n, j - 1, k - 1)) {
                                    this.anyAny_x(n, i, j, k);
                                    continue;
                                }
                                this.anyAny(n, i, j, k);
                                continue;
                            }
                            this.anyAny(n, i, j, k);
                            continue;
                        }
                        if (k % 2 == 1 && j % 2 == 0) {
                            if (j > 2 && k > 1 && k < this.xSize - 1) {
                                if (this.isRoi(n, j - 2, k) || this.isRoi(n, j - 1, k) || this.isRoi(n, j - 2, k - 1) || this.isRoi(n, j - 1, k - 1)) {
                                    if (this.isRoi(n, j, k - 1)) continue;
                                    this.anyAny_y(n, i, j, k);
                                    continue;
                                }
                                if (this.isRoi(n, j, k - 2) || this.isRoi(n, j, k - 1)) {
                                    this.anyAny_x(n, i, j, k);
                                    continue;
                                }
                                this.anyAny(n, i, j, k);
                                continue;
                            }
                            this.anyAny(n, i, j, k);
                            continue;
                        }
                        if (k % 2 != 1 || j % 2 != 1) continue;
                        if (j > 1 && k > 1) {
                            if (this.isRoi(n, j - 2, k) || this.isRoi(n, j - 1, k) || this.isRoi(n, j - 2, k - 1) || this.isRoi(n, j - 1, k - 1)) {
                                if (this.isRoi(n, j - 1, k) && this.isRoi(n, j - 1, k - 1) && this.isRoi(n, j, k - 1)) continue;
                                this.anyAny_y(n, i, j, k);
                                continue;
                            }
                            if (this.isRoi(n, j - 1, k - 2) || this.isRoi(n, j - 1, k - 1) || this.isRoi(n, j, k - 2) || this.isRoi(n, j, k - 1)) {
                                this.anyAny_x(n, i, j, k);
                                continue;
                            }
                            this.anyAny(n, i, j, k);
                            continue;
                        }
                        if (this.isRoi(n, j - 1, k) && this.isRoi(n, j - 1, k - 1) && this.isRoi(n, j, k - 1)) continue;
                        this.anyAny(n, i, j, k);
                        continue;
                    }
                    if (!this.isMarked(n, i, j, k)) continue;
                    if (k % 2 == 0 && j % 2 == 0) {
                        if (j > 1 && k > 0 && k < this.xSize - 1) {
                            if (this.isMarked(n, i, j - 2, k) || this.isMarked(n, i, j - 1, k) || this.isMarked(n, i, j - 2, k + 1) || this.isMarked(n, i, j - 1, k + 1)) {
                                this.anyAny_y(n, i, j, k);
                                continue;
                            }
                            if (this.isMarked(n, i, j, k - 2) || this.isMarked(n, i, j, k - 1)) {
                                this.anyAny_x(n, i, j, k);
                                continue;
                            }
                            this.anyAny(n, i, j, k);
                            continue;
                        }
                        this.anyAny(n, i, j, k);
                        continue;
                    }
                    if (k % 2 == 0 && j % 2 == 1) {
                        if (j > 2 && k > 2 && k < this.xSize - 1) {
                            if (this.isMarked(n, i, j - 3, k) || this.isMarked(n, i, j - 2, k) || this.isMarked(n, i, j - 3, k + 1) || this.isMarked(n, i, j - 2, k + 1)) {
                                if (this.isMarked(n, i, j - 1, k) && this.isMarked(n, i, j - 1, k + 1)) continue;
                                this.anyAny_y(n, i, j, k);
                                continue;
                            }
                            if (this.isMarked(n, i, j, k - 2) || this.isMarked(n, i, j, k - 1) || this.isMarked(n, i, j - 1, k - 2) || this.isMarked(n, i, j - 1, k - 1)) {
                                this.anyAny_x(n, i, j, k);
                                continue;
                            }
                            this.anyAny(n, i, j, k);
                            continue;
                        }
                        this.anyAny(n, i, j, k);
                        continue;
                    }
                    if (k % 2 == 1 && j % 2 == 0) {
                        if (j > 2 && k > 1 && k < this.xSize - 1) {
                            if (this.isMarked(n, i, j - 2, k) || this.isMarked(n, i, j - 1, k) || this.isMarked(n, i, j - 2, k - 1) || this.isMarked(n, i, j - 1, k - 1)) {
                                if (this.isMarked(n, i, j, k - 1)) continue;
                                this.anyAny_y(n, i, j, k);
                                continue;
                            }
                            if (this.isMarked(n, i, j, k - 2) || this.isMarked(n, i, j, k - 1)) {
                                this.anyAny_x(n, i, j, k);
                                continue;
                            }
                            this.anyAny(n, i, j, k);
                            continue;
                        }
                        this.anyAny(n, i, j, k);
                        continue;
                    }
                    if (k % 2 != 1 || j % 2 != 1) continue;
                    if (j > 1 && k > 1) {
                        if (this.isMarked(n, i, j - 2, k) || this.isMarked(n, i, j - 1, k) || this.isMarked(n, i, j - 2, k - 1) || this.isMarked(n, i, j - 1, k - 1)) {
                            if (this.isMarked(n, i, j - 1, k) && this.isMarked(n, i, j - 1, k - 1) && this.isMarked(n, i, j, k - 1)) continue;
                            this.anyAny_y(n, i, j, k);
                            continue;
                        }
                        if (this.isMarked(n, i, j - 1, k - 2) || this.isMarked(n, i, j - 1, k - 1) || this.isMarked(n, i, j, k - 2) || this.isMarked(n, i, j, k - 1)) {
                            this.anyAny_x(n, i, j, k);
                            continue;
                        }
                        this.anyAny(n, i, j, k);
                        continue;
                    }
                    if (this.isMarked(n, i, j - 1, k) && this.isMarked(n, i, j - 1, k - 1) && this.isMarked(n, i, j, k - 1)) continue;
                    this.anyAny(n, i, j, k);
                }
            }
        }
    }

    protected void shift(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n2 != this.maxRLevel) {
            if (n3 < this.ySize && n3 + this.subbandSizes[n2][n5][0] < this.subbandSizes[n2][n5][2] && n4 < this.xSize && n4 + this.subbandSizes[n2][n5][1] < this.subbandSizes[n2][n5][3]) {
                bl = true;
            }
        } else if (n3 < this.ySize && n3 < this.subbandSizes[n2][1][0] && n4 < this.xSize && n4 < this.subbandSizes[n2][0][1]) {
            bl = true;
        }
        if (bl) {
            if (n5 != 3 && n2 < this.WTLevels[n]) {
                n3 += this.subbandSizes[n2][n5][0];
                n4 += this.subbandSizes[n2][n5][1];
            }
            if (n3 > this.ySize) {
                n3 -= n3 - this.ySize;
            }
            if (n3 == this.ySize) {
                --n3;
            }
            if (n4 > this.xSize) {
                n4 -= n4 - this.xSize;
            }
            if (n4 == this.xSize) {
                --n4;
            }
            if (n3 >= 0 && n3 <= this.ySize && n4 >= 0 && n4 <= this.xSize && this.bitMap[this.roiValue][n3][n4] == -1) {
                this.bitMap[this.roiValue][n3][n4] = (byte)n6;
            }
        }
    }

    protected void mark(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n3 < this.subbandSizes[n2][1][0] && n4 < this.subbandSizes[n2][0][1] && this.nextRlevelBitMap[n2][n3][n4] == -1) {
            this.nextRlevelBitMap[n2][n3][n4] = (byte)(n2 + 1);
        }
    }

    protected boolean isMarked(int n, int n2, int n3, int n4) {
        if (--n2 == -1) {
            n2 = 0;
        }
        boolean bl = false;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n3 >= 0 && n3 < this.subbandSizes[n2][1][0] && n4 >= 0 && n4 < this.subbandSizes[n2][0][1] && this.nextRlevelBitMap[n2][n3][n4] != -1) {
            bl = true;
        }
        return bl;
    }

    protected void anyAny(int n, int n2, int n3, int n4) {
        int n5;
        if (n4 % 2 == 0 && n3 % 2 == 0) {
            n4 /= 2;
            n3 /= 2;
        } else if (n4 % 2 == 0 && n3 % 2 == 1) {
            n3 = n3-- / 2;
            n4 /= 2;
        } else if (n4 % 2 == 1 && n3 % 2 == 0) {
            n4 = n4-- / 2;
            n3 /= 2;
        } else if (n4 % 2 == 1 && n3 % 2 == 1) {
            n4 = n4-- / 2;
            n3 = n3-- / 2;
        }
        for (n5 = 0; n5 < this.filter_9_7_AnyAny.length - 16; ++n5) {
            this.shift(n, n2, n3 + this.filter_9_7_AnyAny[n5][1], n4 + this.filter_9_7_AnyAny[n5][0], this.filter_9_7_AnyAny[n5][2], this.filter_9_7_AnyAny_dist_0_1_2[n5][3]);
        }
        for (n5 = this.filter_9_7_AnyAny.length - 16; n5 < this.filter_9_7_AnyAny.length; ++n5) {
            if (n2 == this.maxRLevel) {
                this.shift(n, n2, n3 + this.filter_9_7_AnyAny[n5][1], n4 + this.filter_9_7_AnyAny[n5][0], this.filter_9_7_AnyAny[n5][2], this.filter_9_7_AnyAny_dist_0_1_2[n5][3]);
                continue;
            }
            this.mark(n, n2, n3 + this.filter_9_7_AnyAny[n5][1], n4 + this.filter_9_7_AnyAny[n5][0]);
        }
    }

    protected void anyAny_y(int n, int n2, int n3, int n4) {
        int n5;
        if (n4 % 2 == 0 && n3 % 2 == 0) {
            n4 /= 2;
            n3 /= 2;
        } else if (n4 % 2 == 0 && n3 % 2 == 1) {
            n3 = n3-- / 2;
            n4 /= 2;
        } else if (n4 % 2 == 1 && n3 % 2 == 0) {
            n4 = n4-- / 2;
            n3 /= 2;
        } else if (n4 % 2 == 1 && n3 % 2 == 1) {
            n4 = n4-- / 2;
            n3 = n3-- / 2;
        }
        for (n5 = 0; n5 < this.filter_9_7_AnyAny_y.length - 4; ++n5) {
            this.shift(n, n2, n3 + this.filter_9_7_AnyAny_y[n5][1], n4 + this.filter_9_7_AnyAny_y[n5][0], this.filter_9_7_AnyAny_y[n5][2], this.filter_9_7_AnyAny_dist_0_1_2[n5][3]);
        }
        for (n5 = this.filter_9_7_AnyAny_y.length - 4; n5 < this.filter_9_7_AnyAny_y.length; ++n5) {
            if (n2 == this.maxRLevel) {
                this.shift(n, n2, n3 + this.filter_9_7_AnyAny_y[n5][1], n4 + this.filter_9_7_AnyAny_y[n5][0], this.filter_9_7_AnyAny_y[n5][2], this.filter_9_7_AnyAny_dist_0_1_2[n5][3]);
                continue;
            }
            this.mark(n, n2, n3 + this.filter_9_7_AnyAny_y[n5][1], n4 + this.filter_9_7_AnyAny_y[n5][0]);
        }
    }

    protected void anyAny_x(int n, int n2, int n3, int n4) {
        int n5;
        if (n4 % 2 == 0 && n3 % 2 == 0) {
            n4 /= 2;
            n3 /= 2;
        } else if (n4 % 2 == 0 && n3 % 2 == 1) {
            n3 = n3-- / 2;
            n4 /= 2;
        } else if (n4 % 2 == 1 && n3 % 2 == 0) {
            n4 = n4-- / 2;
            n3 /= 2;
        } else if (n4 % 2 == 1 && n3 % 2 == 1) {
            n4 = n4-- / 2;
            n3 = n3-- / 2;
        }
        for (n5 = 0; n5 < this.filter_9_7_AnyAny_x.length - 4; ++n5) {
            this.shift(n, n2, n3 + this.filter_9_7_AnyAny_x[n5][1], n4 + this.filter_9_7_AnyAny_x[n5][0], this.filter_9_7_AnyAny_x[n5][2], this.filter_9_7_AnyAny_dist_0_1_2[n5][3]);
        }
        for (n5 = this.filter_9_7_AnyAny_x.length - 4; n5 < this.filter_9_7_AnyAny_x.length; ++n5) {
            if (n2 == this.maxRLevel) {
                this.shift(n, n2, n3 + this.filter_9_7_AnyAny_x[n5][1], n4 + this.filter_9_7_AnyAny_x[n5][0], this.filter_9_7_AnyAny_x[n5][2], this.filter_9_7_AnyAny_dist_0_1_2[n5][3]);
                continue;
            }
            this.mark(n, n2, n3 + this.filter_9_7_AnyAny_x[n5][1], n4 + this.filter_9_7_AnyAny_x[n5][0]);
        }
    }

    protected void evenEven(int n, int n2, int n3, int n4) {
        int n5;
        n4 /= 2;
        n3 /= 2;
        for (n5 = 0; n5 < this.filter_5_3_EvenEven.length - 1; ++n5) {
            this.shift(n, n2, n3 + this.filter_5_3_EvenEven[n5][1], n4 + this.filter_5_3_EvenEven[n5][0], this.filter_5_3_EvenEven[n5][2], 1);
        }
        for (n5 = this.filter_5_3_EvenEven.length - 1; n5 < this.filter_5_3_EvenEven.length; ++n5) {
            if (n2 == this.maxRLevel) {
                this.shift(n, n2, n3 + this.filter_5_3_EvenEven[n5][1], n4 + this.filter_5_3_EvenEven[n5][0], this.filter_5_3_EvenEven[n5][2], 1);
                continue;
            }
            this.mark(n, n2, n3 + this.filter_5_3_EvenEven[n5][1], n4 + this.filter_5_3_EvenEven[n5][0]);
        }
    }

    protected void evenOdd(int n, int n2, int n3, int n4) {
        int n5;
        n4 /= 2;
        n3 = n3-- / 2;
        for (n5 = 0; n5 < this.filter_5_3_EvenOdd.length - 1; ++n5) {
            this.shift(n, n2, n3 + this.filter_5_3_EvenOdd[n5][1], n4 + this.filter_5_3_EvenOdd[n5][0], this.filter_5_3_EvenOdd[n5][2], 1);
        }
        for (n5 = this.filter_5_3_EvenOdd.length - 1; n5 < this.filter_5_3_EvenOdd.length; ++n5) {
            if (n2 == this.maxRLevel) {
                this.shift(n, n2, n3 + this.filter_5_3_EvenOdd[n5][1], n4 + this.filter_5_3_EvenOdd[n5][0], this.filter_5_3_EvenOdd[n5][2], 1);
                continue;
            }
            this.mark(n, n2, n3 + this.filter_5_3_EvenOdd[n5][1], n4 + this.filter_5_3_EvenOdd[n5][0]);
        }
    }

    protected void oddEven(int n, int n2, int n3, int n4) {
        int n5;
        n4 = n4-- / 2;
        n3 /= 2;
        for (n5 = 0; n5 < this.filter_5_3_OddEven.length - 1; ++n5) {
            this.shift(n, n2, n3 + this.filter_5_3_OddEven[n5][1], n4 + this.filter_5_3_OddEven[n5][0], this.filter_5_3_OddEven[n5][2], 1);
        }
        for (n5 = this.filter_5_3_OddEven.length - 1; n5 < this.filter_5_3_OddEven.length; ++n5) {
            if (n2 == this.maxRLevel) {
                this.shift(n, n2, n3 + this.filter_5_3_OddEven[n5][1], n4 + this.filter_5_3_OddEven[n5][0], this.filter_5_3_OddEven[n5][2], 1);
                continue;
            }
            this.mark(n, n2, n3 + this.filter_5_3_OddEven[n5][1], n4 + this.filter_5_3_OddEven[n5][0]);
        }
    }

    protected void oddOdd(int n, int n2, int n3, int n4) {
        int n5;
        n4 = n4-- / 2;
        n3 = n3-- / 2;
        for (n5 = 0; n5 < this.filter_5_3_OddOdd.length - 1; ++n5) {
            this.shift(n, n2, n3 + this.filter_5_3_OddOdd[n5][1], n4 + this.filter_5_3_OddOdd[n5][0], this.filter_5_3_OddOdd[n5][2], 1);
        }
        for (n5 = this.filter_5_3_OddOdd.length - 1; n5 < this.filter_5_3_OddOdd.length; ++n5) {
            if (n2 == this.maxRLevel) {
                this.shift(n, n2, n3 + this.filter_5_3_OddOdd[n5][1], n4 + this.filter_5_3_OddOdd[n5][0], this.filter_5_3_OddOdd[n5][2], 1);
                continue;
            }
            this.mark(n, n2, n3 + this.filter_5_3_OddOdd[n5][1], n4 + this.filter_5_3_OddOdd[n5][0]);
        }
    }

    protected boolean isRoi(int n, int n2, int n3) {
        boolean bl = false;
        if (this.maskSamples[n][n2][n3] == this.RroiValues[this.roiValue]) {
            bl = true;
        }
        return bl;
    }

    protected void SubbandSizesCalculation(int n, int[][][] nArray) {
        int n2 = this.xSize;
        int n3 = this.ySize;
        for (int i = 0; i < this.WTLevels[n]; ++i) {
            int n4 = n2 % 2;
            int n5 = n3 % 2;
            n2 = n2 / 2 + n4;
            n3 = n3 / 2 + n5;
            nArray[i][0][0] = 0;
            nArray[i][0][1] = n2;
            nArray[i][0][2] = n3;
            nArray[i][0][3] = n2 * 2 - n4;
            nArray[i][1][0] = n3;
            nArray[i][1][1] = 0;
            nArray[i][1][2] = n3 * 2 - n5;
            nArray[i][1][3] = n2;
            nArray[i][2][0] = n3;
            nArray[i][2][1] = n2;
            nArray[i][2][2] = n3 * 2 - n5;
            nArray[i][2][3] = n2 * 2 - n4;
        }
    }

    public byte[][][] getMaskWaveletDomain(int n) {
        this.z = n;
        for (int i = 0; i < this.bitMap.length; ++i) {
            this.roiValue = i;
            for (int j = 0; j < this.bitMap[i].length; ++j) {
                for (int k = 0; k < this.bitMap[i][j].length; ++k) {
                    this.bitMap[i][j][k] = -1;
                }
            }
        }
        try {
            this.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.bitMap;
    }

    public byte[][][] getMaskWaveletDomain() {
        return this.bitMap;
    }
}

