/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class MaskWaveletDomainByteMapSpectral {
    private boolean[] inputComponents = null;
    private int WTLevels;
    private int WTType;
    private int maxComponents;
    private byte[] bitMap = null;
    private byte[][] nextRlevelBitMap = null;
    private int[][][] subbandSizes = null;
    private final int[][] filter_5_3_EvenEven = new int[][]{{0, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, -1, 1}, {0, 0, 2}, {0, -1, 2}, {-1, 0, 2}, {-1, -1, 2}, {0, 0, 3}};
    private final int[][] filter_5_3_EvenOdd = new int[][]{{-1, 1, 0}, {0, 1, 0}, {0, 1, 1}, {-1, 1, 2}, {0, 1, 2}, {0, 1, 3}};
    private final int[][] filter_5_3_OddEven = new int[][]{{1, 0, 0}, {1, 0, 1}, {1, -1, 1}, {1, -1, 2}, {1, 0, 2}, {1, 0, 3}};
    private final int[][] filter_5_3_OddOdd = new int[][]{{1, 1, 0}, {1, 1, 1}, {1, 0, 2}, {0, 1, 2}, {1, 1, 2}, {1, 1, 3}};
    private final int[][] filter_9_7_AnyAny = new int[][]{{-2, -1, 0}, {-2, 0, 0}, {-2, 1, 0}, {-2, 2, 0}, {-1, -1, 0}, {-1, 0, 0}, {-1, 1, 0}, {-1, 2, 0}, {0, -1, 0}, {0, 0, 0}, {0, 1, 0}, {0, 2, 0}, {1, -1, 0}, {1, 0, 0}, {1, 1, 0}, {1, 2, 0}, {2, -1, 0}, {2, 0, 0}, {2, 1, 0}, {2, 2, 0}, {-1, -2, 1}, {-1, -1, 1}, {-1, 0, 1}, {-1, 1, 1}, {-1, 2, 1}, {0, -2, 1}, {0, -1, 1}, {0, 0, 1}, {0, 1, 1}, {0, 2, 1}, {1, -2, 1}, {1, -1, 1}, {1, 0, 1}, {1, 1, 1}, {1, 2, 1}, {2, -2, 1}, {2, -1, 1}, {2, 0, 1}, {2, 1, 1}, {2, 2, 1}, {-2, -2, 2}, {-2, -1, 2}, {-2, 0, 2}, {-2, 1, 2}, {-2, 2, 2}, {-1, -2, 2}, {-1, -1, 2}, {-1, 0, 2}, {-1, 1, 2}, {-1, 2, 2}, {0, -2, 2}, {0, -1, 2}, {0, 0, 2}, {0, 1, 2}, {0, 2, 2}, {1, -2, 2}, {1, -1, 2}, {1, 0, 2}, {1, 1, 2}, {1, 2, 2}, {2, -2, 2}, {2, -1, 2}, {2, 0, 2}, {2, 1, 2}, {2, 2, 2}, {-1, -1, 3}, {-1, 0, 3}, {-1, 1, 3}, {-1, 2, 3}, {0, -1, 3}, {0, 0, 3}, {0, 1, 3}, {0, 2, 3}, {1, -1, 3}, {1, 0, 3}, {1, 1, 3}, {1, 2, 3}, {2, -1, 3}, {2, 0, 3}, {2, 1, 3}, {2, 2, 3}};
    private final int[][] filter_9_7_AnyAny_x = new int[][]{{2, -1, 0}, {2, 0, 0}, {2, 1, 0}, {2, 2, 0}, {2, -2, 1}, {2, -1, 1}, {2, 0, 1}, {2, 1, 1}, {2, 2, 1}, {2, -2, 2}, {2, -1, 2}, {2, 0, 2}, {2, 1, 2}, {2, 2, 2}, {2, -1, 3}, {2, 0, 3}, {2, 1, 3}, {2, 2, 3}};
    private final int[][] filter_9_7_AnyAny_y = new int[][]{{-2, 2, 0}, {-1, 2, 0}, {0, 2, 0}, {1, 2, 0}, {2, 2, 0}, {-1, 2, 1}, {0, 2, 1}, {1, 2, 1}, {2, 2, 1}, {-2, 2, 2}, {-1, 2, 2}, {0, 2, 2}, {1, 2, 2}, {2, 2, 2}, {-1, 2, 3}, {0, 2, 3}, {1, 2, 3}, {2, 2, 3}};
    private int ySize = 1;
    private int maxRLevel;

    public MaskWaveletDomainByteMapSpectral(boolean[] blArray, int n, int n2) {
        this.inputComponents = blArray;
        this.WTLevels = n;
        this.WTType = n2;
        this.maxComponents = blArray.length;
    }

    public void run() throws ErrorException {
        int n;
        this.bitMap = new byte[(int)Math.ceil((double)this.maxComponents / 8.0)];
        this.subbandSizes = this.subbandSizesCalculation();
        this.nextRlevelBitMap = new byte[this.WTLevels][];
        for (n = 0; n < this.WTLevels; ++n) {
            this.nextRlevelBitMap[n] = new byte[(int)Math.ceil((double)(this.subbandSizes[n][1][0] * this.subbandSizes[n][0][1]) / 8.0)];
        }
        if (this.WTLevels == 0) {
            for (n = 0; n < this.maxComponents; ++n) {
                if (!this.isSelected(n)) continue;
                int n2 = n / 8;
                this.bitMap[n2] = (byte)(this.bitMap[n2] | (byte)(1 << 7 - n % 8));
            }
        } else {
            this.maxRLevel = this.WTLevels - 1;
            switch (this.WTType) {
                case 1: {
                    this.rasterWavelet5_3();
                    break;
                }
                case 2: {
                    this.rasterWavelet9_7();
                    break;
                }
                case 3: {
                    this.rasterWavelet9_7();
                    break;
                }
                case 7: {
                    this.rasterHaar();
                    break;
                }
                case 8: {
                    this.rasterHaar();
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException("unsupported wavelet for component tracking.");
                }
            }
        }
    }

    public boolean[] getRelevantHaarComponents() {
        return this.inputComponents;
    }

    public boolean[] getRelevantComponents() {
        boolean[] blArray = new boolean[this.maxComponents];
        for (int i = 0; i < this.maxComponents; ++i) {
            byte by = this.bitMap[i / 8];
            byte by2 = (byte)(by & 1 << 7 - i % 8);
            blArray[i] = by2 != 0;
        }
        return blArray;
    }

    private void rasterHaar() {
        int n = this.inputComponents.length;
        boolean[] blArray = null;
        int n2 = 0;
        for (int i = 0; i < this.WTLevels; ++i) {
            int n3;
            n = i == 0 ? this.inputComponents.length : n / 2 + n % 2;
            blArray = new boolean[n];
            for (n3 = 0; n3 < n; ++n3) {
                blArray[n3] = false;
            }
            n2 = n / 2 + n % 2;
            for (n3 = 0; n3 < n; ++n3) {
                if (!this.inputComponents[n3]) continue;
                if (n % 2 == 1 && n3 == n - 1) {
                    blArray[n3 / 2] = true;
                    continue;
                }
                blArray[n3 / 2] = true;
                blArray[n3 / 2 + n2] = true;
            }
            System.arraycopy(blArray, 0, this.inputComponents, 0, blArray.length);
        }
    }

    private void rasterWavelet5_3() {
        for (int i = 0; i < this.WTLevels; ++i) {
            for (int j = 0; j < this.subbandSizes[i][1][2]; ++j) {
                for (int k = 0; k < this.subbandSizes[i][0][3]; ++k) {
                    if (i == 0) {
                        if (!this.isSelected(k)) continue;
                        if (k % 2 == 0 && j % 2 == 0) {
                            this.evenEven(i, j, k);
                            continue;
                        }
                        if (k % 2 == 0 && j % 2 == 1) {
                            if (j > 1 && k < this.maxComponents - 1) {
                                if (this.isSelected(k) || this.isSelected(k + 1)) {
                                    this.evenOdd(i, j, k);
                                    continue;
                                }
                                this.evenEven(i, j, k);
                                this.evenOdd(i, j, k);
                                continue;
                            }
                            this.evenEven(i, j, k);
                            this.evenOdd(i, j, k);
                            continue;
                        }
                        if (k % 2 == 1 && j % 2 == 0) {
                            if (j > 1 && k < this.maxComponents - 1) {
                                if (this.isSelected(k - 1)) {
                                    this.oddEven(i, j, k);
                                    continue;
                                }
                                this.evenEven(i, j, k);
                                this.oddEven(i, j, k);
                                continue;
                            }
                            this.evenEven(i, j, k);
                            this.oddEven(i, j, k);
                            continue;
                        }
                        if (k % 2 != 1 || j % 2 != 1) continue;
                        if (j > 1 && k < this.maxComponents - 1) {
                            if (this.isSelected(k - 1) && this.isSelected(k)) {
                                this.oddOdd(i, j, k);
                                continue;
                            }
                            this.evenEven(i, j, k);
                            this.oddEven(i, j, k);
                            this.evenOdd(i, j, k);
                            this.oddOdd(i, j, k);
                            continue;
                        }
                        this.evenEven(i, j, k);
                        this.oddEven(i, j, k);
                        this.evenOdd(i, j, k);
                        this.oddOdd(i, j, k);
                        continue;
                    }
                    if (!this.isMarked(i, j, k)) continue;
                    if (k % 2 == 0 && j % 2 == 0) {
                        this.evenEven(i, j, k);
                        continue;
                    }
                    if (k % 2 == 0 && j % 2 == 1) {
                        if (j > 1 && k < this.maxComponents - 1) {
                            if (this.isMarked(i, j - 1, k) || this.isMarked(i, j - 1, k + 1)) {
                                this.evenOdd(i, j, k);
                                continue;
                            }
                            this.evenEven(i, j, k);
                            this.evenOdd(i, j, k);
                            continue;
                        }
                        this.evenEven(i, j, k);
                        this.evenOdd(i, j, k);
                        continue;
                    }
                    if (k % 2 == 1 && j % 2 == 0) {
                        if (j > 1 && k < this.maxComponents - 1) {
                            if (this.isMarked(i, j, k - 1)) {
                                this.oddEven(i, j, k);
                                continue;
                            }
                            this.evenEven(i, j, k);
                            this.oddEven(i, j, k);
                            continue;
                        }
                        this.evenEven(i, j, k);
                        this.oddEven(i, j, k);
                        continue;
                    }
                    if (k % 2 != 1 || j % 2 != 1) continue;
                    if (j > 1 && k < this.maxComponents - 1) {
                        if (this.isMarked(i, j, k - 1) && this.isMarked(i, j - 1, k)) {
                            this.oddOdd(i, j, k);
                            continue;
                        }
                        this.evenEven(i, j, k);
                        this.oddEven(i, j, k);
                        this.evenOdd(i, j, k);
                        this.oddOdd(i, j, k);
                        continue;
                    }
                    this.evenEven(i, j, k);
                    this.oddEven(i, j, k);
                    this.evenOdd(i, j, k);
                    this.oddOdd(i, j, k);
                }
            }
        }
    }

    private void rasterWavelet9_7() {
        for (int i = 0; i < this.WTLevels; ++i) {
            for (int j = 0; j < this.subbandSizes[i][1][2]; ++j) {
                for (int k = 0; k < this.subbandSizes[i][0][3]; ++k) {
                    if (i == 0) {
                        if (!this.isSelected(k)) continue;
                        if (k % 2 == 0 && j % 2 == 0) {
                            if (j > 1 && k > 0 && k < this.maxComponents - 1) {
                                if (this.isSelected(k) || this.isSelected(k) || this.isSelected(k + 1) || this.isSelected(k + 1)) {
                                    this.anyAny_y(i, j, k);
                                    continue;
                                }
                                if (this.isSelected(k - 2) || this.isSelected(k - 1)) {
                                    this.anyAny_x(i, j, k);
                                    continue;
                                }
                                this.anyAny(i, j, k);
                                continue;
                            }
                            this.anyAny(i, j, k);
                            continue;
                        }
                        if (k % 2 == 0 && j % 2 == 1) {
                            if (j > 2 && k > 2 && k < this.maxComponents - 1) {
                                if (this.isSelected(k) || this.isSelected(k) || this.isSelected(k + 1) || this.isSelected(k + 1)) {
                                    if (this.isSelected(k) && this.isSelected(k + 1)) continue;
                                    this.anyAny_y(i, j, k);
                                    continue;
                                }
                                if (this.isSelected(k - 2) || this.isSelected(k - 1) || this.isSelected(k - 2) || this.isSelected(k - 1)) {
                                    this.anyAny_x(i, j, k);
                                    continue;
                                }
                                this.anyAny(i, j, k);
                                continue;
                            }
                            this.anyAny(i, j, k);
                            continue;
                        }
                        if (k % 2 == 1 && j % 2 == 0) {
                            if (j > 2 && k > 1 && k < this.maxComponents - 1) {
                                if (this.isSelected(k) || this.isSelected(k) || this.isSelected(k - 1) || this.isSelected(k - 1)) {
                                    if (this.isSelected(k - 1)) continue;
                                    this.anyAny_y(i, j, k);
                                    continue;
                                }
                                if (this.isSelected(k - 2) || this.isSelected(k - 1)) {
                                    this.anyAny_x(i, j, k);
                                    continue;
                                }
                                this.anyAny(i, j, k);
                                continue;
                            }
                            this.anyAny(i, j, k);
                            continue;
                        }
                        if (k % 2 != 1 || j % 2 != 1) continue;
                        if (j > 1 && k > 1) {
                            if (this.isSelected(k) || this.isSelected(k) || this.isSelected(k - 1) || this.isSelected(k - 1)) {
                                if (this.isSelected(k) && this.isSelected(k - 1) && this.isSelected(k - 1)) continue;
                                this.anyAny_y(i, j, k);
                                continue;
                            }
                            if (this.isSelected(k - 2) || this.isSelected(k - 1) || this.isSelected(k - 2) || this.isSelected(k - 1)) {
                                this.anyAny_x(i, j, k);
                                continue;
                            }
                            this.anyAny(i, j, k);
                            continue;
                        }
                        if (this.isSelected(k) && this.isSelected(k - 1) && this.isSelected(k - 1)) continue;
                        this.anyAny(i, j, k);
                        continue;
                    }
                    if (!this.isMarked(i, j, k)) continue;
                    if (k % 2 == 0 && j % 2 == 0) {
                        if (j > 1 && k > 0 && k < this.maxComponents - 1) {
                            if (this.isMarked(i, j - 2, k) || this.isMarked(i, j - 1, k) || this.isMarked(i, j - 2, k + 1) || this.isMarked(i, j - 1, k + 1)) {
                                this.anyAny_y(i, j, k);
                                continue;
                            }
                            if (this.isMarked(i, j, k - 2) || this.isMarked(i, j, k - 1)) {
                                this.anyAny_x(i, j, k);
                                continue;
                            }
                            this.anyAny(i, j, k);
                            continue;
                        }
                        this.anyAny(i, j, k);
                        continue;
                    }
                    if (k % 2 == 0 && j % 2 == 1) {
                        if (j > 2 && k > 2 && k < this.maxComponents - 1) {
                            if (this.isMarked(i, j - 3, k) || this.isMarked(i, j - 2, k) || this.isMarked(i, j - 3, k + 1) || this.isMarked(i, j - 2, k + 1)) {
                                if (this.isMarked(i, j - 1, k) && this.isMarked(i, j - 1, k + 1)) continue;
                                this.anyAny_y(i, j, k);
                                continue;
                            }
                            if (this.isMarked(i, j, k - 2) || this.isMarked(i, j, k - 1) || this.isMarked(i, j - 1, k - 2) || this.isMarked(i, j - 1, k - 1)) {
                                this.anyAny_x(i, j, k);
                                continue;
                            }
                            this.anyAny(i, j, k);
                            continue;
                        }
                        this.anyAny(i, j, k);
                        continue;
                    }
                    if (k % 2 == 1 && j % 2 == 0) {
                        if (j > 2 && k > 1 && k < this.maxComponents - 1) {
                            if (this.isMarked(i, j - 2, k) || this.isMarked(i, j - 1, k) || this.isMarked(i, j - 2, k - 1) || this.isMarked(i, j - 1, k - 1)) {
                                if (this.isMarked(i, j, k - 1)) continue;
                                this.anyAny_y(i, j, k);
                                continue;
                            }
                            if (this.isMarked(i, j, k - 2) || this.isMarked(i, j, k - 1)) {
                                this.anyAny_x(i, j, k);
                                continue;
                            }
                            this.anyAny(i, j, k);
                            continue;
                        }
                        this.anyAny(i, j, k);
                        continue;
                    }
                    if (k % 2 != 1 || j % 2 != 1) continue;
                    if (j > 1 && k > 1) {
                        if (this.isMarked(i, j - 2, k) || this.isMarked(i, j - 1, k) || this.isMarked(i, j - 2, k - 1) || this.isMarked(i, j - 1, k - 1)) {
                            if (this.isMarked(i, j - 1, k) && this.isMarked(i, j - 1, k - 1) && this.isMarked(i, j, k - 1)) continue;
                            this.anyAny_y(i, j, k);
                            continue;
                        }
                        if (this.isMarked(i, j - 1, k - 2) || this.isMarked(i, j - 1, k - 1) || this.isMarked(i, j, k - 2) || this.isMarked(i, j, k - 1)) {
                            this.anyAny_x(i, j, k);
                            continue;
                        }
                        this.anyAny(i, j, k);
                        continue;
                    }
                    if (this.isMarked(i, j - 1, k) && this.isMarked(i, j - 1, k - 1) && this.isMarked(i, j, k - 1)) continue;
                    this.anyAny(i, j, k);
                }
            }
        }
    }

    private void shift(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n != this.maxRLevel) {
            if (n2 < this.ySize && n2 + this.subbandSizes[n][n4][0] < this.subbandSizes[n][n4][2] && n3 < this.maxComponents && n3 + this.subbandSizes[n][n4][1] < this.subbandSizes[n][n4][3]) {
                bl = true;
            }
        } else if (n2 < this.ySize && n2 < this.subbandSizes[n][1][0] && n3 < this.maxComponents && n3 < this.subbandSizes[n][0][1]) {
            bl = true;
        }
        if (bl) {
            if (n4 != 3 && n < this.WTLevels) {
                n2 += this.subbandSizes[n][n4][0];
                n3 += this.subbandSizes[n][n4][1];
            }
            if (n2 > this.ySize) {
                n2 -= n2 - this.ySize;
            }
            if (n2 == this.ySize) {
                --n2;
            }
            if (n3 > this.maxComponents) {
                n3 -= n3 - this.maxComponents;
            }
            if (n3 == this.maxComponents) {
                --n3;
            }
            if (n2 >= 0 && n2 <= this.ySize && n3 >= 0 && n3 <= this.maxComponents) {
                int n5 = (n2 * this.maxComponents + n3) / 8;
                this.bitMap[n5] = (byte)(this.bitMap[n5] | (byte)(1 << 7 - (n2 * this.maxComponents + n3) % 8));
            }
        }
    }

    private void anyAny(int n, int n2, int n3) {
        int n4;
        if (n3 % 2 == 0 && n2 % 2 == 0) {
            n3 /= 2;
            n2 /= 2;
        } else if (n3 % 2 == 0 && n2 % 2 == 1) {
            n2 = n2-- / 2;
            n3 /= 2;
        } else if (n3 % 2 == 1 && n2 % 2 == 0) {
            n3 = n3-- / 2;
            n2 /= 2;
        } else if (n3 % 2 == 1 && n2 % 2 == 1) {
            n3 = n3-- / 2;
            n2 = n2-- / 2;
        }
        for (n4 = 0; n4 < this.filter_9_7_AnyAny.length - 16; ++n4) {
            this.shift(n, n2 + this.filter_9_7_AnyAny[n4][1], n3 + this.filter_9_7_AnyAny[n4][0], this.filter_9_7_AnyAny[n4][2]);
        }
        for (n4 = this.filter_9_7_AnyAny.length - 16; n4 < this.filter_9_7_AnyAny.length; ++n4) {
            if (n == this.maxRLevel) {
                this.shift(n, n2 + this.filter_9_7_AnyAny[n4][1], n3 + this.filter_9_7_AnyAny[n4][0], this.filter_9_7_AnyAny[n4][2]);
                continue;
            }
            this.mark(n, n2 + this.filter_9_7_AnyAny[n4][1], n3 + this.filter_9_7_AnyAny[n4][0]);
        }
    }

    private void anyAny_y(int n, int n2, int n3) {
        int n4;
        if (n3 % 2 == 0 && n2 % 2 == 0) {
            n3 /= 2;
            n2 /= 2;
        } else if (n3 % 2 == 0 && n2 % 2 == 1) {
            n2 = n2-- / 2;
            n3 /= 2;
        } else if (n3 % 2 == 1 && n2 % 2 == 0) {
            n3 = n3-- / 2;
            n2 /= 2;
        } else if (n3 % 2 == 1 && n2 % 2 == 1) {
            n3 = n3-- / 2;
            n2 = n2-- / 2;
        }
        for (n4 = 0; n4 < this.filter_9_7_AnyAny_y.length - 4; ++n4) {
            this.shift(n, n2 + this.filter_9_7_AnyAny_y[n4][1], n3 + this.filter_9_7_AnyAny_y[n4][0], this.filter_9_7_AnyAny_y[n4][2]);
        }
        for (n4 = this.filter_9_7_AnyAny_y.length - 4; n4 < this.filter_9_7_AnyAny_y.length; ++n4) {
            if (n == this.maxRLevel) {
                this.shift(n, n2 + this.filter_9_7_AnyAny_y[n4][1], n3 + this.filter_9_7_AnyAny_y[n4][0], this.filter_9_7_AnyAny_y[n4][2]);
                continue;
            }
            this.mark(n, n2 + this.filter_9_7_AnyAny_y[n4][1], n3 + this.filter_9_7_AnyAny_y[n4][0]);
        }
    }

    private void anyAny_x(int n, int n2, int n3) {
        int n4;
        if (n3 % 2 == 0 && n2 % 2 == 0) {
            n3 /= 2;
            n2 /= 2;
        } else if (n3 % 2 == 0 && n2 % 2 == 1) {
            n2 = n2-- / 2;
            n3 /= 2;
        } else if (n3 % 2 == 1 && n2 % 2 == 0) {
            n3 = n3-- / 2;
            n2 /= 2;
        } else if (n3 % 2 == 1 && n2 % 2 == 1) {
            n3 = n3-- / 2;
            n2 = n2-- / 2;
        }
        for (n4 = 0; n4 < this.filter_9_7_AnyAny_x.length - 4; ++n4) {
            this.shift(n, n2 + this.filter_9_7_AnyAny_x[n4][1], n3 + this.filter_9_7_AnyAny_x[n4][0], this.filter_9_7_AnyAny_x[n4][2]);
        }
        for (n4 = this.filter_9_7_AnyAny_x.length - 4; n4 < this.filter_9_7_AnyAny_x.length; ++n4) {
            if (n == this.maxRLevel) {
                this.shift(n, n2 + this.filter_9_7_AnyAny_x[n4][1], n3 + this.filter_9_7_AnyAny_x[n4][0], this.filter_9_7_AnyAny_x[n4][2]);
                continue;
            }
            this.mark(n, n2 + this.filter_9_7_AnyAny_x[n4][1], n3 + this.filter_9_7_AnyAny_x[n4][0]);
        }
    }

    private void evenEven(int n, int n2, int n3) {
        int n4;
        n3 /= 2;
        n2 /= 2;
        for (n4 = 0; n4 < this.filter_5_3_EvenEven.length - 1; ++n4) {
            this.shift(n, n2 + this.filter_5_3_EvenEven[n4][1], n3 + this.filter_5_3_EvenEven[n4][0], this.filter_5_3_EvenEven[n4][2]);
        }
        for (n4 = this.filter_5_3_EvenEven.length - 1; n4 < this.filter_5_3_EvenEven.length; ++n4) {
            if (n == this.maxRLevel) {
                this.shift(n, n2 + this.filter_5_3_EvenEven[n4][1], n3 + this.filter_5_3_EvenEven[n4][0], this.filter_5_3_EvenEven[n4][2]);
                continue;
            }
            this.mark(n, n2 + this.filter_5_3_EvenEven[n4][1], n3 + this.filter_5_3_EvenEven[n4][0]);
        }
    }

    private void evenOdd(int n, int n2, int n3) {
        int n4;
        n3 /= 2;
        n2 = n2-- / 2;
        for (n4 = 0; n4 < this.filter_5_3_EvenOdd.length - 1; ++n4) {
            this.shift(n, n2 + this.filter_5_3_EvenOdd[n4][1], n3 + this.filter_5_3_EvenOdd[n4][0], this.filter_5_3_EvenOdd[n4][2]);
        }
        for (n4 = this.filter_5_3_EvenOdd.length - 1; n4 < this.filter_5_3_EvenOdd.length; ++n4) {
            if (n == this.maxRLevel) {
                this.shift(n, n2 + this.filter_5_3_EvenOdd[n4][1], n3 + this.filter_5_3_EvenOdd[n4][0], this.filter_5_3_EvenOdd[n4][2]);
                continue;
            }
            this.mark(n, n2 + this.filter_5_3_EvenOdd[n4][1], n3 + this.filter_5_3_EvenOdd[n4][0]);
        }
    }

    private void oddEven(int n, int n2, int n3) {
        int n4;
        n3 = n3-- / 2;
        n2 /= 2;
        for (n4 = 0; n4 < this.filter_5_3_OddEven.length - 1; ++n4) {
            this.shift(n, n2 + this.filter_5_3_OddEven[n4][1], n3 + this.filter_5_3_OddEven[n4][0], this.filter_5_3_OddEven[n4][2]);
        }
        for (n4 = this.filter_5_3_OddEven.length - 1; n4 < this.filter_5_3_OddEven.length; ++n4) {
            if (n == this.maxRLevel) {
                this.shift(n, n2 + this.filter_5_3_OddEven[n4][1], n3 + this.filter_5_3_OddEven[n4][0], this.filter_5_3_OddEven[n4][2]);
                continue;
            }
            this.mark(n, n2 + this.filter_5_3_OddEven[n4][1], n3 + this.filter_5_3_OddEven[n4][0]);
        }
    }

    private void oddOdd(int n, int n2, int n3) {
        int n4;
        n3 = n3-- / 2;
        n2 = n2-- / 2;
        for (n4 = 0; n4 < this.filter_5_3_OddOdd.length - 1; ++n4) {
            this.shift(n, n2 + this.filter_5_3_OddOdd[n4][1], n3 + this.filter_5_3_OddOdd[n4][0], this.filter_5_3_OddOdd[n4][2]);
        }
        for (n4 = this.filter_5_3_OddOdd.length - 1; n4 < this.filter_5_3_OddOdd.length; ++n4) {
            if (n == this.maxRLevel) {
                this.shift(n, n2 + this.filter_5_3_OddOdd[n4][1], n3 + this.filter_5_3_OddOdd[n4][0], this.filter_5_3_OddOdd[n4][2]);
                continue;
            }
            this.mark(n, n2 + this.filter_5_3_OddOdd[n4][1], n3 + this.filter_5_3_OddOdd[n4][0]);
        }
    }

    private void mark(int n, int n2, int n3) {
        byte by = 0;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 < this.subbandSizes[n][1][0] && n3 < this.subbandSizes[n][0][1] && (this.nextRlevelBitMap[n][(n2 * this.subbandSizes[n][0][1] + n3) / 8] & (by = (byte)(1 << 7 - (n2 * this.subbandSizes[n][0][1] + n3) % 8))) == 0) {
            byte[] byArray = this.nextRlevelBitMap[n];
            int n4 = (n2 * this.subbandSizes[n][0][1] + n3) / 8;
            byArray[n4] = (byte)(byArray[n4] | by);
        }
    }

    private boolean isMarked(int n, int n2, int n3) {
        --n;
        boolean bl = false;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 >= 0 && n2 < this.subbandSizes[n][1][0] && n3 >= 0 && n3 < this.subbandSizes[n][0][1] && (this.nextRlevelBitMap[n][(n2 * this.subbandSizes[n][0][1] + n3) / 8] & (byte)(1 << 7 - (n2 * this.subbandSizes[n][0][1] + n3) % 8)) != 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isSelected(int n) {
        boolean bl = false;
        if (this.inputComponents[n]) {
            bl = true;
        }
        return bl;
    }

    private int[][][] subbandSizesCalculation() {
        int[][][] nArray = new int[this.WTLevels][3][4];
        int n = this.maxComponents;
        int n2 = 1;
        for (int i = 0; i < this.WTLevels; ++i) {
            int n3 = n % 2;
            int n4 = n2 % 2;
            n = n / 2 + n3;
            n2 = n2 / 2 + n4;
            nArray[i][0][0] = 0;
            nArray[i][0][1] = n;
            nArray[i][0][2] = n2;
            nArray[i][0][3] = n * 2 - n3;
            nArray[i][1][0] = n2;
            nArray[i][1][1] = 0;
            nArray[i][1][2] = n2 * 2 - n4;
            nArray[i][1][3] = n;
            nArray[i][2][0] = n2;
            nArray[i][2][1] = n;
            nArray[i][2][2] = n2 * 2 - n4;
            nArray[i][2][3] = n * 2 - n3;
        }
        return nArray;
    }
}

