/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciMatrix.MatrixAlgebra;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class Permutation {
    int[] permutation;

    public Permutation(int n) {
        this.permutation = new int[n];
        this.setToIdentity();
    }

    public Permutation(int[] nArray) {
        this.permutation = new int[nArray.length];
        this.setPermutation(nArray);
    }

    public Permutation(Permutation permutation) {
        this(permutation.getPermutation());
    }

    public void setToIdentity() {
        for (int i = 0; i < this.permutation.length; ++i) {
            this.permutation[i] = i;
        }
    }

    public boolean isIdentity() {
        for (int i = 0; i < this.permutation.length; ++i) {
            if (this.permutation[i] == i) continue;
            return false;
        }
        return true;
    }

    public void permutationInterleaveRange(int n, int n2, boolean bl) {
        int n3;
        int n4;
        boolean bl2;
        int[] nArray = new int[n2];
        if (bl) {
            bl2 = false;
            n4 = n;
            n3 = n + n2 / 2;
        } else {
            bl2 = true;
            n4 = n;
            n3 = n + n2 / 2 + n2 % 2;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = bl2 ? this.permutation[n4++] : this.permutation[n3++];
            bl2 = !bl2;
        }
        System.arraycopy(nArray, 0, this.permutation, n, n2);
        this.verify();
    }

    public void permutationBringListTo(List<Integer> list, int n) {
        int n2;
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int[] nArray = new int[list.size()];
        for (n3 = 0; n3 < list.size(); ++n3) {
            n2 = list.get(n3);
            nArray[n3] = this.permutation[n2];
        }
        for (n3 = 0; n3 < list.size(); ++n3) {
            n2 = list.get(n3);
            if (n2 < n || n2 >= n + list.size()) {
                arrayList.add(n2);
                continue;
            }
            treeSet.add(n2);
        }
        assert (arrayList.size() + treeSet.size() == list.size());
        n3 = 0;
        for (n2 = 0; n2 < list.size(); ++n2) {
            int n4 = n + n2;
            if (treeSet.contains(n4)) continue;
            int n5 = (Integer)arrayList.get(n3++);
            this.permutation[n5] = this.permutation[n4];
        }
        System.arraycopy(nArray, 0, this.permutation, n, list.size());
        this.verify();
    }

    public void permutationBringTo(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        assert (this.permutation.length >= n2 + n3);
        assert (this.permutation.length >= n + n3);
        assert (n >= 0 && n2 >= 0 && n3 >= 0);
        if (n2 == n) {
            return;
        }
        if (n2 + n3 <= n || n + n3 <= n2) {
            n6 = n2;
            n5 = n;
            n4 = n3;
        } else if (n2 < n) {
            n6 = n2;
            n5 = n2 + n3;
            n4 = n - n2;
        } else {
            n6 = n + n3;
            n5 = n;
            n4 = n2 - n;
        }
        assert (n6 + n4 <= this.permutation.length);
        assert (n4 >= 0);
        int[] nArray = Arrays.copyOfRange(this.permutation, n6, n6 + n4);
        System.arraycopy(this.permutation, n, this.permutation, n2, n3);
        System.arraycopy(nArray, 0, this.permutation, n5, n4);
        this.verify();
    }

    public void appendPermutation(Permutation permutation) {
        Permutation permutation2 = new Permutation(permutation.getPermutation());
        this.permutation = permutation2.applyToVector(this.permutation);
    }

    private void verify() {
        int[] nArray = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, nArray, 0, this.permutation.length);
        Arrays.sort(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            assert (nArray[i] == i);
        }
    }

    public void setPermutation(int[] nArray) {
        assert (this.permutation.length == nArray.length);
        System.arraycopy(nArray, 0, this.permutation, 0, nArray.length);
        this.verify();
    }

    public int[] getPermutation() {
        return this.permutation;
    }

    public float[][] getPermutationAsMatrix() {
        return this.applyToMatrixRows(MatrixAlgebra.identityC(this.permutation.length));
    }

    public void reversePermutation() {
        int[] nArray = new int[this.permutation.length];
        for (int i = 0; i < this.permutation.length; ++i) {
            nArray[this.permutation[i]] = i;
        }
        Permutation permutation = new Permutation(nArray);
        permutation.appendPermutation(this);
        assert (permutation.isIdentity());
        this.permutation = nArray;
    }

    public void permuteInPlace(float[][][] fArray, int n) {
        Object object;
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        assert (n >= 0 && n <= 2);
        assert (n == 0 && fArray.length == this.permutation.length || n == 1 && fArray[0].length == this.permutation.length || n == 2 && fArray[0][0].length == this.permutation.length);
        switch (n) {
            case 0: {
                assert (this.permutation.length == n2);
                object = new float[n2][][];
                for (int i = 0; i < n2; ++i) {
                    object[i] = fArray[this.permutation[i]];
                }
                break;
            }
            case 1: {
                assert (this.permutation.length == n3);
                object = new float[n2][n3][];
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        object[i][j] = fArray[i][this.permutation[j]];
                    }
                }
                break;
            }
            case 2: {
                assert (this.permutation.length == n4);
                object = new float[n2][n3][n4];
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n5 = 0;
                        while (j < n3) {
                            object[i][j][n5] = fArray[i][j][this.permutation[n5]];
                            ++j;
                        }
                    }
                }
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        System.arraycopy(object, 0, fArray, 0, ((float[][][])object).length);
    }

    public float[][] applyToMatrixRows(float[][] fArray) {
        float[][][] fArrayArray = new float[][][]{MatrixAlgebra.copy(fArray)};
        assert (this.permutation.length == fArray.length);
        Permutation permutation = new Permutation(this.permutation);
        permutation.permuteInPlace(fArrayArray, 1);
        return fArrayArray[0];
    }

    public void applyToMatrixRowsInPlace(float[][] fArray) {
        assert (this.permutation.length == fArray.length);
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArrayArray.length; ++i) {
            fArrayArray[i] = fArray[this.permutation[i]];
        }
        System.arraycopy(fArrayArray, 0, fArray, 0, fArray.length);
    }

    public void applyToMatrixRowsInPlace(double[][] dArray) {
        assert (this.permutation.length == dArray.length);
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = dArray[this.permutation[i]];
        }
        System.arraycopy(dArrayArray, 0, dArray, 0, dArray.length);
    }

    public float[][] applyToMatrixCols(float[][] fArray) {
        float[][][] fArrayArray = new float[][][]{MatrixAlgebra.copy(fArray)};
        assert (this.permutation.length == fArray[0].length);
        Permutation permutation = new Permutation(this.permutation);
        permutation.permuteInPlace(fArrayArray, 2);
        return fArrayArray[0];
    }

    public int[] applyToVector(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[this.permutation[i]];
        }
        return nArray2;
    }

    public float[] applyToVector(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = fArray[this.permutation[i]];
        }
        return fArray2;
    }

    public double[] applyToVector(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[this.permutation[i]];
        }
        return dArray2;
    }

    public String toString() {
        Object object = "";
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this.permutation.length; ++i) {
            if (i == 0) {
                object = (String)object + this.permutation[0];
            } else if (n + 1 == this.permutation[i]) {
                bl = true;
            } else {
                if (bl) {
                    object = (String)object + ".." + n;
                    bl = false;
                }
                object = (String)object + ", " + this.permutation[i];
            }
            n = this.permutation[i];
        }
        if (bl) {
            object = (String)object + ".." + n;
        }
        return object;
    }

    public void scream() {
        System.out.print("Permutation " + this + " ");
        MatrixAlgebra.printVector(this.permutation);
        new Exception().printStackTrace(System.out);
    }
}

