/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class RangeCheck {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int RCType;
    boolean[] LSSignedComponents = null;
    int[] QComponentsBits = null;
    boolean parametersSet = false;

    public RangeCheck(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int n, boolean[] blArray, int[] nArray) {
        this.parametersSet = true;
        this.RCType = n;
        this.LSSignedComponents = blArray;
        this.QComponentsBits = nArray;
    }

    public float[][][] run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Parameters not set.");
        }
        if (this.RCType != 0) {
            for (int i = 0; i < this.zSize; ++i) {
                int n;
                int n2;
                if (this.LSSignedComponents[i]) {
                    n2 = (int)Math.pow(2.0, this.QComponentsBits[i] - 1) * -1;
                    n = (int)Math.pow(2.0, this.QComponentsBits[i] - 1) - 1;
                } else {
                    n2 = 0;
                    n = (int)Math.pow(2.0, this.QComponentsBits[i]) - 1;
                }
                for (int j = 0; j < this.ySize; ++j) {
                    block10: for (int k = 0; k < this.xSize; ++k) {
                        if (this.imageSamples[i][j][k] < (float)n2) {
                            switch (this.RCType) {
                                case 1: {
                                    this.imageSamples[i][j][k] = n2;
                                    break;
                                }
                                case 2: {
                                    throw new ErrorException("Minimum out of range sample.");
                                }
                            }
                        }
                        if (!(this.imageSamples[i][j][k] > (float)n)) continue;
                        switch (this.RCType) {
                            case 1: {
                                this.imageSamples[i][j][k] = n;
                                continue block10;
                            }
                            case 2: {
                                throw new ErrorException("Out of range sample.");
                            }
                        }
                    }
                }
            }
        }
        return this.imageSamples;
    }
}

