/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class SAInverseWaveletTransform {
    float[][][] imageSamples = null;
    byte[][][] maskSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] WTTypes = null;
    int[] WTLevels = null;
    int[] WTOrder;
    boolean parametersSet = false;

    public SAInverseWaveletTransform(float[][][] fArray, byte[][][] byArray) throws ErrorException {
        if (byArray == null) {
            throw new ErrorException("You must specify a mask.");
        }
        if (fArray == null) {
            throw new ErrorException("You must specify a input image.");
        }
        if (fArray[0].length != byArray[0].length || fArray[0][0].length != byArray[0][0].length) {
            throw new ErrorException("The dimensions of the mask and the input image must be the same.");
        }
        this.imageSamples = fArray;
        this.maskSamples = byArray;
        this.zSize = fArray.length;
    }

    public void setParameters(int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = new int[this.zSize];
        for (int i = 0; i < this.zSize; ++i) {
            this.WTOrder[i] = 1;
        }
    }

    public void setParameters(int[] nArray, int[] nArray2, int[] nArray3) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = nArray3;
    }

    public static boolean verifyParameters(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0 || nArray[i] > 4) {
                return false;
            }
            if (nArray2[i] < 0) {
                return false;
            }
            if (nArray3[i] >= 0 && nArray3[i] <= 2) continue;
            return false;
        }
        return true;
    }

    public void run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Discrete wavelet transform cannot run if parameters are not set.");
        }
        for (int i = 0; i < this.zSize; ++i) {
            int n;
            this.ySize = this.imageSamples[i].length;
            this.xSize = this.imageSamples[i][0].length;
            if (this.WTTypes[i] == 0 || this.WTLevels[i] <= 0) continue;
            int[] nArray = new int[this.WTLevels[i]];
            int[] nArray2 = new int[this.WTLevels[i]];
            nArray[this.WTLevels[i] - 1] = this.xSize;
            nArray2[this.WTLevels[i] - 1] = this.ySize;
            for (n = this.WTLevels[i] - 2; n >= 0; --n) {
                nArray[n] = nArray[n + 1] / 2 + nArray[n + 1] % 2;
                nArray2[n] = nArray2[n + 1] / 2 + nArray2[n + 1] % 2;
            }
            for (n = 0; n < this.WTLevels[i]; ++n) {
                int n2;
                byte[] byArray;
                float[] fArray;
                int n3;
                int n4 = nArray[n];
                int n5 = nArray2[n];
                if (this.WTOrder[i] == 2) {
                    n5 = this.ySize;
                }
                if (this.WTOrder[i] == 0) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        fArray = new float[n5];
                        byArray = new byte[n5];
                        for (n2 = 0; n2 < n5; ++n2) {
                            fArray[n2] = this.imageSamples[i][n2][n3];
                            byArray[n2] = this.maskSamples[i][n2][n3];
                        }
                        byArray = this.filtering(fArray, byArray, i);
                        for (n2 = 0; n2 < n5; ++n2) {
                            this.imageSamples[i][n2][n3] = fArray[n2];
                            this.maskSamples[i][n2][n3] = byArray[n2];
                        }
                    }
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    fArray = new float[n4];
                    byArray = new byte[n4];
                    for (n2 = 0; n2 < n4; ++n2) {
                        fArray[n2] = this.imageSamples[i][n3][n2];
                        byArray[n2] = this.maskSamples[i][n3][n2];
                    }
                    byArray = this.filtering(fArray, byArray, i);
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.imageSamples[i][n3][n2] = fArray[n2];
                        this.maskSamples[i][n3][n2] = byArray[n2];
                    }
                }
                if (this.WTOrder[i] != 1 || this.WTOrder[i] == 2) continue;
                for (n3 = 0; n3 < n4; ++n3) {
                    fArray = new float[n5];
                    byArray = new byte[n5];
                    for (n2 = 0; n2 < n5; ++n2) {
                        fArray[n2] = this.imageSamples[i][n2][n3];
                        byArray[n2] = this.maskSamples[i][n2][n3];
                    }
                    byArray = this.filtering(fArray, byArray, i);
                    for (n2 = 0; n2 < n5; ++n2) {
                        this.imageSamples[i][n2][n3] = fArray[n2];
                        this.maskSamples[i][n2][n3] = byArray[n2];
                    }
                }
            }
        }
    }

    private int jumpFalse(byte[] byArray, int n) {
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        return n;
    }

    private int jumpTrue(byte[] byArray, int n) {
        while (n < byArray.length && byArray[n] != 0) {
            ++n;
        }
        return n;
    }

    private byte[] filtering(float[] fArray, byte[] byArray, int n) throws ErrorException {
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        if (fArray.length != 1) {
            switch (fArray.length % 2) {
                case 0: {
                    this.replaceSegment(this.evenInterleavingSrc(fArray), 0, fArray);
                    byArray2 = this.evenInterleavingMask(byArray);
                    break;
                }
                case 1: {
                    this.replaceSegment(this.oddInterleavingSrc(fArray), 0, fArray);
                    byArray2 = this.oddInterleavingMask(byArray);
                }
            }
            while (n2 < byArray2.length) {
                float[] fArray2;
                int n3 = n2 = this.jumpFalse(byArray2, n2);
                if (n3 >= byArray2.length) continue;
                if (n2 % 2 == 0) {
                    n3 = this.jumpTrue(byArray2, n3);
                    fArray2 = new float[n3 - n2];
                    fArray2 = this.selectSegment(n2, n3, fArray);
                    switch (fArray2.length % 2) {
                        case 0: {
                            fArray2 = this.evenEvenFiltering(fArray2, n);
                            this.replaceSegment(fArray2, n2, fArray);
                            break;
                        }
                        case 1: {
                            fArray2 = this.oddEvenFiltering(fArray2, n);
                            this.replaceSegment(fArray2, n2, fArray);
                        }
                    }
                } else {
                    n3 = this.jumpTrue(byArray2, n3);
                    fArray2 = new float[n3 - n2];
                    fArray2 = this.selectSegment(n2, n3, fArray);
                    switch (fArray2.length % 2) {
                        case 0: {
                            fArray2 = this.evenOddFiltering(fArray2, n);
                            this.replaceSegment(fArray2, n2, fArray);
                            break;
                        }
                        case 1: {
                            fArray2 = this.oddOddFiltering(fArray2, n);
                            this.replaceSegment(fArray2, n2, fArray);
                        }
                    }
                }
                n2 = n3;
            }
            return byArray2;
        }
        return byArray;
    }

    private float[] selectSegment(int n, int n2, float[] fArray) throws ErrorException {
        float[] fArray2 = new float[n2 - n];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            fArray2[n3] = fArray[i];
            ++n3;
        }
        return fArray2;
    }

    private void replaceSegment(float[] fArray, int n, float[] fArray2) throws ErrorException {
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray2[n] = fArray[n2];
            ++n2;
            ++n;
        }
    }

    private float[] oddInterleavingSrc(float[] fArray) throws ErrorException {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n / 2; ++i) {
            fArray2[2 * i] = fArray[i];
            fArray2[2 * i + 1] = fArray[i + n / 2 + 1];
        }
        fArray2[n - 1] = fArray[n / 2];
        return fArray2;
    }

    private byte[] oddInterleavingMask(byte[] byArray) throws ErrorException {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n / 2; ++i) {
            byArray2[2 * i] = byArray[i];
            byArray2[2 * i + 1] = byArray[i + n / 2 + 1];
        }
        byArray2[n - 1] = byArray[n / 2];
        return byArray2;
    }

    private byte[] evenInterleavingMask(byte[] byArray) throws ErrorException {
        int n = byArray.length;
        int n2 = n / 2;
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n2; ++i) {
            byArray2[2 * i] = byArray[i];
            byArray2[2 * i + 1] = byArray[i + n2];
        }
        return byArray2;
    }

    private float[] evenInterleavingSrc(float[] fArray) throws ErrorException {
        int n = fArray.length;
        int n2 = n / 2;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n2; ++i) {
            fArray2[2 * i] = fArray[i];
            fArray2[2 * i + 1] = fArray[i + n2];
        }
        return fArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float[] evenEvenFiltering(float[] fArray, int n) throws ErrorException {
        int n2 = fArray.length;
        if (n2 == 1) {
            return fArray;
        }
        if (this.WTTypes[n] == 1) {
            int n3;
            fArray[0] = fArray[0] - (float)Math.floor((fArray[1] + fArray[1] + 2.0f) / 4.0f);
            for (n3 = 2; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] - (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1] + 2.0f) / 4.0f);
            }
            for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] + (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1]) / 2.0f);
            }
            fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((fArray[n2 - 2] + fArray[n2 - 2]) / 2.0f);
            return fArray;
        } else if (this.WTTypes[n] == 2 || this.WTTypes[n] == 3) {
            int n4;
            float f;
            float f2;
            if (this.WTTypes[n] == 2) {
                f2 = 1.2301741f;
                f = 1.0f / f2;
            } else {
                f = 1.1496043f;
                f2 = 1.0f / f;
            }
            for (n4 = 0; n4 < n2; n4 += 2) {
                fArray[n4] = fArray[n4] / f;
                fArray[n4 + 1] = fArray[n4 + 1] / f2;
            }
            fArray[0] = fArray[0] - 0.44350687f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2; n4 += 2) {
                fArray[n4] = fArray[n4] - 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            for (n4 = 1; n4 < n2 - 2; n4 += 2) {
                fArray[n4] = fArray[n4] - 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - 0.8829111f * (fArray[n2 - 2] + fArray[n2 - 2]);
            fArray[0] = fArray[0] - -0.052980117f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2; n4 += 2) {
                fArray[n4] = fArray[n4] - -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            for (n4 = 1; n4 < n2 - 2; n4 += 2) {
                fArray[n4] = fArray[n4] - -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - -1.5861343f * (fArray[n2 - 2] + fArray[n2 - 2]);
            return fArray;
        } else if (this.WTTypes[n] == 4) {
            int n5;
            if (n2 < 6) throw new ErrorException("Size should be greater or equal than 6 in order to perform 9/7M");
            fArray[0] = fArray[0] + (float)Math.floor((double)(-0.25f * (fArray[1] + fArray[1])) + 0.5);
            for (n5 = 2; n5 < n2; n5 += 2) {
                fArray[n5] = fArray[n5] + (float)Math.floor((double)(-0.25f * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
            }
            fArray[1] = fArray[1] + (float)Math.floor((double)(0.5625f * (fArray[0] + fArray[2]) - 0.0625f * (fArray[2] + fArray[4])) + 0.5);
            for (n5 = 3; n5 < n2 - 3; n5 += 2) {
                fArray[n5] = fArray[n5] + (float)Math.floor((double)(0.5625f * (fArray[n5 - 1] + fArray[n5 + 1]) - 0.0625f * (fArray[n5 - 3] + fArray[n5 + 3])) + 0.5);
            }
            fArray[n2 - 3] = fArray[n2 - 3] + (float)Math.floor((double)(0.5625f * (fArray[n2 - 4] + fArray[n2 - 2]) - 0.0625f * (fArray[n2 - 6] + fArray[n2 - 2])) + 0.5);
            fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((double)(0.5625f * (fArray[n2 - 2] + fArray[n2 - 2]) - 0.0625f * (fArray[n2 - 4] + fArray[n2 - 4])) + 0.5);
            return fArray;
        } else {
            int n6;
            float f;
            float f3;
            float f4;
            float f5;
            if (this.WTTypes[n] != 5 && this.WTTypes[n] != 6) throw new ErrorException("Unrecognized wavelet transform type.");
            if (this.WTTypes[n] == 6) {
                f5 = -1.5861598f;
                f4 = -0.05297864f;
                f3 = 0.8829336f;
                f = 0.4435048f;
            } else {
                f5 = -0.5f;
                f4 = 0.25f;
                f3 = 0.0f;
                f = 0.0f;
            }
            if (this.WTTypes[n] == 6) {
                fArray[0] = fArray[0] - (float)Math.floor((double)(f * (fArray[1] + fArray[1])) + 0.5);
                for (n6 = 2; n6 < n2; n6 += 2) {
                    fArray[n6] = fArray[n6] - (float)Math.floor((double)(f * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
                }
                for (n6 = 1; n6 < n2 - 2; n6 += 2) {
                    fArray[n6] = fArray[n6] - (float)Math.floor((double)(f3 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
                }
                fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(f3 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
            }
            fArray[0] = fArray[0] - (float)Math.floor((double)(f4 * (fArray[1] + fArray[1])) + 0.5);
            for (n6 = 2; n6 < n2; n6 += 2) {
                fArray[n6] = fArray[n6] - (float)Math.floor((double)(f4 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
            }
            for (n6 = 1; n6 < n2 - 2; n6 += 2) {
                fArray[n6] = fArray[n6] - (float)Math.floor((double)(f5 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(f5 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
        }
        return fArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float[] evenOddFiltering(float[] fArray, int n) throws ErrorException {
        int n2 = fArray.length;
        if (n2 == 1) {
            return fArray;
        }
        if (this.WTTypes[n] == 1) {
            int n3;
            fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((fArray[n2 - 2] + fArray[n2 - 2] + 2.0f) / 4.0f);
            for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] - (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1] + 2.0f) / 4.0f);
            }
            fArray[0] = fArray[0] + (float)Math.floor((fArray[1] + fArray[1]) / 2.0f);
            for (n3 = 2; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] + (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1]) / 2.0f);
            }
            return fArray;
        } else if (this.WTTypes[n] == 2 || this.WTTypes[n] == 3) {
            int n4;
            float f;
            float f2;
            if (this.WTTypes[n] == 2) {
                f2 = 1.2301741f;
                f = 1.0f / f2;
            } else {
                f = 1.1496043f;
                f2 = 1.0f / f;
            }
            for (n4 = 0; n4 < n2; n4 += 2) {
                fArray[n4] = fArray[n4] / f2;
                fArray[n4 + 1] = fArray[n4 + 1] / f;
            }
            fArray[n2 - 1] = fArray[n2 - 1] - 0.44350687f * (fArray[n2 - 2] + fArray[n2 - 2]);
            for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[0] = fArray[0] - 0.8829111f * (fArray[1] + fArray[1]);
            fArray[n2 - 1] = fArray[n2 - 1] - -0.052980117f * (fArray[n2 - 2] + fArray[n2 - 2]);
            for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[0] = fArray[0] - -1.5861343f * (fArray[1] + fArray[1]);
            return fArray;
        } else if (this.WTTypes[n] == 4) {
            int n5;
            if (n2 < 6) throw new ErrorException("Size should be greater or equal than 6 in order to perform 9/7M");
            fArray[0] = fArray[0] + (float)Math.floor((double)(-0.25f * (fArray[1] + fArray[1])) + 0.5);
            for (n5 = 2; n5 < n2; n5 += 2) {
                fArray[n5] = fArray[n5] + (float)Math.floor((double)(-0.25f * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
            }
            fArray[1] = fArray[1] + (float)Math.floor((double)(0.5625f * (fArray[0] + fArray[2]) - 0.0625f * (fArray[2] + fArray[4])) + 0.5);
            for (n5 = 3; n5 < n2 - 3; n5 += 2) {
                fArray[n5] = fArray[n5] + (float)Math.floor((double)(0.5625f * (fArray[n5 - 1] + fArray[n5 + 1]) - 0.0625f * (fArray[n5 - 3] + fArray[n5 + 3])) + 0.5);
            }
            fArray[n2 - 3] = fArray[n2 - 3] + (float)Math.floor((double)(0.5625f * (fArray[n2 - 4] + fArray[n2 - 2]) - 0.0625f * (fArray[n2 - 6] + fArray[n2 - 2])) + 0.5);
            fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((double)(0.5625f * (fArray[n2 - 2] + fArray[n2 - 2]) - 0.0625f * (fArray[n2 - 4] + fArray[n2 - 4])) + 0.5);
            return fArray;
        } else {
            int n6;
            float f;
            float f3;
            float f4;
            float f5;
            if (this.WTTypes[n] != 5 && this.WTTypes[n] != 6) throw new ErrorException("Unrecognized wavelet transform type.");
            if (this.WTTypes[n] == 6) {
                f5 = -1.5861598f;
                f4 = -0.05297864f;
                f3 = 0.8829336f;
                f = 0.4435048f;
            } else {
                f5 = -0.5f;
                f4 = 0.25f;
                f3 = 0.0f;
                f = 0.0f;
            }
            if (this.WTTypes[n] == 6) {
                fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(f * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
                for (n6 = 1; n6 < n2 - 2; n6 += 2) {
                    fArray[n6] = fArray[n6] - (float)Math.floor((double)(f * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
                }
                fArray[0] = fArray[0] - (float)Math.floor((double)(f3 * (fArray[1] + fArray[1])) + 0.5);
                for (n6 = 2; n6 < n2 - 1; n6 += 2) {
                    fArray[n6] = fArray[n6] - (float)Math.floor((double)(f3 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
                }
            }
            for (n6 = 1; n6 < n2 - 2; n6 += 2) {
                fArray[n6] = fArray[n6] - (float)Math.floor((double)(f4 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(f4 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
            fArray[0] = fArray[0] - (float)Math.floor((double)(f5 * (fArray[1] + fArray[1])) + 0.5);
            for (n6 = 2; n6 < n2 - 1; n6 += 2) {
                fArray[n6] = fArray[n6] - (float)Math.floor((double)(f5 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
            }
        }
        return fArray;
    }

    private float[] oddEvenFiltering(float[] fArray, int n) throws ErrorException {
        int n2 = fArray.length;
        if (n2 == 1) {
            return fArray;
        }
        if (this.WTTypes[n] == 1) {
            int n3;
            fArray[0] = fArray[0] - (float)Math.floor((fArray[1] + fArray[1] + 2.0f) / 4.0f);
            fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((fArray[n2 - 2] + fArray[n2 - 2] + 2.0f) / 4.0f);
            for (n3 = 2; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] - (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1] + 2.0f) / 4.0f);
            }
            for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] + (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1]) / 2.0f);
            }
        } else if (this.WTTypes[n] == 2 || this.WTTypes[n] == 3) {
            int n4;
            float f;
            float f2;
            if (this.WTTypes[n] == 2) {
                f2 = 1.2301741f;
                f = 1.0f / f2;
            } else {
                f2 = 1.1496043f;
                f = 1.0f / f2;
            }
            for (n4 = 0; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] / f;
                fArray[n4 + 1] = fArray[n4 + 1] / f2;
            }
            fArray[n2 - 1] = fArray[n2 - 1] / f;
            fArray[0] = fArray[0] - 0.44350687f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - 0.44350687f * (fArray[n2 - 2] + fArray[n2 - 2]);
            for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[0] = fArray[0] - -0.052980117f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - -0.052980117f * (fArray[n2 - 2] + fArray[n2 - 2]);
            for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
        } else {
            if (this.WTTypes[n] == 4) {
                throw new ErrorException("Integer 9/7M CCSDS Recommended is not implemented for odd signals.!!!");
            }
            if (this.WTTypes[n] == 5 || this.WTTypes[n] == 6) {
                int n5;
                float f;
                float f3;
                float f4;
                float f5;
                if (this.WTTypes[n] == 6) {
                    f5 = -1.5861598f;
                    f4 = -0.05297864f;
                    f3 = 0.8829336f;
                    f = 0.4435048f;
                } else {
                    f5 = -0.5f;
                    f4 = 0.25f;
                    f3 = 0.0f;
                    f = 0.0f;
                }
                if (this.WTTypes[n] == 6) {
                    fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(f * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
                    fArray[0] = fArray[0] - (float)Math.floor((double)(f * (fArray[1] + fArray[1])) + 0.5);
                    for (n5 = 2; n5 < n2 - 1; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor((double)(f * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                    }
                    for (n5 = 1; n5 < n2 - 1; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor((double)(f3 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                    }
                }
                fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(f4 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
                fArray[0] = fArray[0] - (float)Math.floor((double)(f4 * (fArray[1] + fArray[1])) + 0.5);
                for (n5 = 2; n5 < n2 - 1; n5 += 2) {
                    fArray[n5] = fArray[n5] - (float)Math.floor((double)(f4 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                }
                for (n5 = 1; n5 < n2 - 1; n5 += 2) {
                    fArray[n5] = fArray[n5] - (float)Math.floor((double)(f5 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                }
            } else {
                throw new ErrorException("Unrecognized wavelet transform type.");
            }
        }
        return fArray;
    }

    private float[] oddOddFiltering(float[] fArray, int n) throws ErrorException {
        int n2 = fArray.length;
        if (n2 == 1) {
            return fArray;
        }
        if (this.WTTypes[n] == 1) {
            int n3;
            for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] - (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1] + 2.0f) / 4.0f);
            }
            for (n3 = 2; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] + (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1]) / 2.0f);
            }
            fArray[0] = fArray[0] + (float)Math.floor((fArray[1] + fArray[1]) / 2.0f);
            fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((fArray[n2 - 2] + fArray[n2 - 2]) / 2.0f);
        } else if (this.WTTypes[n] == 2 || this.WTTypes[n] == 3) {
            int n4;
            float f;
            float f2;
            if (this.WTTypes[n] == 2) {
                f2 = 1.2301741f;
                f = 1.0f / f2;
            } else {
                f2 = 1.1496043f;
                f = 1.0f / f2;
            }
            for (n4 = 0; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] / f2;
                fArray[n4 + 1] = fArray[n4 + 1] / f;
            }
            fArray[n2 - 1] = fArray[n2 - 1] / f2;
            for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - 0.8829111f * (fArray[n2 - 2] + fArray[n2 - 2]);
            fArray[0] = fArray[0] - 0.8829111f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - -1.5861343f * (fArray[n2 - 2] + fArray[n2 - 2]);
            fArray[0] = fArray[0] - -1.5861343f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] - -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
        } else {
            if (this.WTTypes[n] == 4) {
                throw new ErrorException("Integer 9/7M CCSDS Recommended is not implemented for odd signals.!!!");
            }
            if (this.WTTypes[n] == 5 || this.WTTypes[n] == 6) {
                int n5;
                float f;
                float f3;
                float f4;
                float f5;
                if (this.WTTypes[n] == 6) {
                    f5 = -1.5861598f;
                    f4 = -0.05297864f;
                    f3 = 0.8829336f;
                    f = 0.4435048f;
                } else {
                    f5 = -0.5f;
                    f4 = 0.25f;
                    f3 = 0.0f;
                    f = 0.0f;
                }
                if (this.WTTypes[n] == 6) {
                    for (n5 = 1; n5 < n2 - 1; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor((double)(f * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                    }
                    fArray[0] = fArray[0] - (float)Math.floor((double)(f3 * (fArray[1] + fArray[1])) + 0.5);
                    for (n5 = 2; n5 < n2 - 1; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor((double)(f3 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                    }
                    fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(f3 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
                }
                for (n5 = 1; n5 < n2 - 1; n5 += 2) {
                    fArray[n5] = fArray[n5] - (float)Math.floor((double)(f4 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                }
                fArray[0] = fArray[0] - (float)Math.floor((double)(f5 * (fArray[1] + fArray[1])) + 0.5);
                for (n5 = 2; n5 < n2 - 1; n5 += 2) {
                    fArray[n5] = fArray[n5] - (float)Math.floor((double)(f5 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                }
                fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(f5 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
            } else {
                throw new ErrorException("Unrecognized wavelet transform type.");
            }
        }
        return fArray;
    }

    public static void deinterleaveMask(byte[][][] byArray, int[] nArray) throws ErrorException {
        if (byArray == null) {
            throw new ErrorException("There is no mask defined for the deinterleaved process.");
        }
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = byArray[i].length;
            n3 = byArray[i][0].length;
            if (nArray[i] == 0) continue;
            int n4 = n3;
            int n5 = n2;
            for (int j = 0; j < nArray[i]; ++j) {
                int n6;
                int n7;
                byte[] byArray2 = new byte[n4];
                for (int k = 0; k < n5; ++k) {
                    n7 = n4 / 2;
                    if (n4 % 2 == 0) {
                        for (n6 = 0; n6 < n7; ++n6) {
                            byArray2[n6] = byArray[i][k][2 * n6];
                            byArray2[n6 + n7] = byArray[i][k][2 * n6 + 1];
                        }
                    } else {
                        for (n6 = 0; n6 < n7; ++n6) {
                            byArray2[n6] = byArray[i][k][2 * n6];
                            byArray2[n6 + n7 + 1] = byArray[i][k][2 * n6 + 1];
                        }
                        byArray2[n7] = byArray[i][k][n4 - 1];
                    }
                    for (n6 = 0; n6 < n4; ++n6) {
                        byArray[i][k][n6] = byArray2[n6];
                    }
                }
                byte[] byArray3 = new byte[n5];
                for (n7 = 0; n7 < n4; ++n7) {
                    int n8;
                    n6 = n5 / 2;
                    if (n5 % 2 == 0) {
                        for (n8 = 0; n8 < n6; ++n8) {
                            byArray3[n8] = byArray[i][2 * n8][n7];
                            byArray3[n8 + n6] = byArray[i][2 * n8 + 1][n7];
                        }
                    } else {
                        for (n8 = 0; n8 < n6; ++n8) {
                            byArray3[n8] = byArray[i][2 * n8][n7];
                            byArray3[n8 + n6 + 1] = byArray[i][2 * n8 + 1][n7];
                        }
                        byArray3[n6] = byArray[i][n5 - 1][n7];
                    }
                    for (n8 = 0; n8 < n5; ++n8) {
                        byArray[i][n8][n7] = byArray3[n8];
                    }
                }
                n4 = n4 / 2 + n4 % 2;
                n5 = n5 / 2 + n5 % 2;
            }
        }
    }
}

