/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ParameterException;

public class TransposeImage {
    float[][][] imageSamples = null;
    int[] transposeImg = null;
    boolean parametersSet;

    public TransposeImage(float[][][] fArray) {
        this.imageSamples = fArray;
    }

    public void setParameters(int[] nArray) throws ParameterException {
        this.transposeImg = nArray;
        if (nArray != null) {
            if (nArray.length != this.imageSamples.length) {
                throw new ParameterException("parameters are not set properly.");
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= 0 && nArray[i] <= 1) continue;
                throw new ParameterException("parameters are not set properly.");
            }
        } else {
            this.transposeImg = new int[this.imageSamples.length];
            for (int i = 0; i < this.transposeImg.length; ++i) {
                this.transposeImg[i] = 0;
            }
        }
        this.parametersSet = true;
    }

    public float[][][] run() throws ParameterException {
        if (!this.parametersSet) {
            throw new ParameterException("the image cannot be transposed if parameters are not set.");
        }
        int n = this.imageSamples.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            if (this.transposeImg[i] == 0) continue;
            int n4 = this.imageSamples[i].length;
            int n5 = this.imageSamples[i][0].length;
            if (n4 != n5) {
                float[][] fArray = new float[n5][n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        fArray[n2][n3] = this.imageSamples[i][n3][n2];
                    }
                }
                this.imageSamples[i] = null;
                this.imageSamples[i] = fArray;
                continue;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n3; ++n2) {
                    float f = this.imageSamples[i][n3][n2];
                    this.imageSamples[i][n3][n2] = this.imageSamples[i][n2][n3];
                    this.imageSamples[i][n2][n3] = f;
                }
            }
        }
        return this.imageSamples;
    }

    public static boolean needTranspose(int[] nArray) {
        boolean bl = false;
        if (nArray != null) {
            int n = nArray.length;
            for (int i = 0; i < n && !bl; ++i) {
                if (nArray[i] != 1) continue;
                bl = true;
            }
        }
        return bl;
    }
}

