/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.WarningException;
import GiciMatrix.MatrixAlgebra;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;

public class TriangularElementaryReversibleMatrix
implements Callable<TriangularElementaryReversibleMatrix> {
    int called = 0;
    final int N;
    float[][] A;
    float[][] S;
    float[][] P;
    float[][] L;

    private State nextState(float[][] fArray, int n, int n2) throws WarningException {
        int n3;
        float f;
        Object object;
        int n4;
        State state = new State();
        float[][] fArray2 = MatrixAlgebra.copy(fArray);
        float[][] fArray3 = MatrixAlgebra.identityC(this.N);
        float[][] fArray4 = MatrixAlgebra.identityC(this.N);
        float[][] fArray5 = MatrixAlgebra.identityC(this.N);
        int n5 = -1;
        int n6 = -1;
        float f2 = Float.POSITIVE_INFINITY;
        PriorityQueue<BestMove> priorityQueue = new PriorityQueue<BestMove>(1, new BestMove());
        for (n4 = n; n4 < this.N; ++n4) {
            for (int i = n + 1; i < this.N; ++i) {
                if (Math.abs(fArray2[n4][i]) < Float.MIN_VALUE) continue;
                float f3 = Math.abs((fArray2[n4][n] - 1.0f) / fArray2[n4][i]);
                if (f3 < f2) {
                    f2 = f3;
                    n5 = n4;
                    n6 = i;
                }
                priorityQueue.add(new BestMove(n4, i, f3));
            }
        }
        if (priorityQueue.size() == 0) {
            MatrixAlgebra.printMatrix(fArray2);
            throw new WarningException("Singular matrix (" + n + ")");
        }
        n4 = n2 % priorityQueue.size();
        do {
            object = priorityQueue.poll();
            assert (n2 != 0 || ((BestMove)object).min == f2);
            f2 = ((BestMove)object).min;
            n5 = ((BestMove)object).permuted_row;
            n6 = ((BestMove)object).permuted_col;
        } while (n4-- > 0);
        state.result = f2;
        object = fArray2[n];
        fArray2[n] = fArray2[n5];
        fArray2[n5] = (float[])object;
        object = fArray3[n];
        fArray3[n] = fArray3[n5];
        fArray3[n5] = (float[])object;
        fArray5[n6][n] = f = (fArray2[n][n] - 1.0f) / fArray2[n][n6];
        for (n3 = 0; n3 < this.N; ++n3) {
            fArray2[n3][n] = fArray2[n3][n] - f * fArray2[n3][n6];
        }
        for (n3 = n + 1; n3 < this.N; ++n3) {
            fArray4[n3][n] = -fArray2[n3][n];
            fArray2[n3][n] = 0.0f;
            for (int i = n + 1; i < this.N; ++i) {
                fArray2[n3][i] = fArray2[n3][i] + fArray4[n3][n] * fArray2[n][i];
            }
        }
        state.A = fArray2;
        state.Ls = fArray4;
        state.Ss = fArray5;
        state.Ps = fArray3;
        return state;
    }

    private void triangularElementaryReversibleMatrix() throws WarningException {
        int n;
        int n2;
        float[][] fArray = new float[this.N][this.N];
        float[][] fArray2 = new float[this.N][this.N];
        float[][] fArray3 = new float[this.N][this.N];
        this.P = MatrixAlgebra.identityC(this.N);
        this.S = MatrixAlgebra.identityC(this.N);
        float[][] fArray4 = MatrixAlgebra.identityC(this.N);
        for (n2 = 0; n2 < this.N - 1; ++n2) {
            n = 1;
            float f = Float.POSITIVE_INFINITY;
            State state = null;
            int[] nArray = new int[n];
            State[] stateArray = new State[n + 1];
            for (int i = 0; i < n + 1; ++i) {
                stateArray[i] = new State();
            }
            stateArray[0].A = this.A;
            stateArray[0].result = 1.0f;
            n = Math.min(n, this.N - 1 - n2);
            for (int i = 0; i < n; ++i) {
                stateArray[i + 1] = this.nextState(stateArray[i].A, n2 + i, nArray[i]);
                if (i != n - 1) continue;
                float f2 = 1.0f;
                for (int j = 0; j < n + 1; ++j) {
                    f2 *= stateArray[j].result;
                }
                if (f > f2) {
                    f = stateArray[i + 1].result;
                    state = new State(stateArray[1]);
                }
                while (i >= 0) {
                    nArray[i] = (nArray[i] + 1) % 1;
                    if (nArray[i--] == 0) continue;
                }
                if (i < 0) break;
            }
            state = this.nextState(stateArray[0].A, n2, 0);
            fArray = state.Ps;
            fArray2 = state.Ls;
            fArray3 = state.Ss;
            this.A = state.A;
            this.S = MatrixAlgebra.multiplicationCC(fArray3, this.S);
            this.P = MatrixAlgebra.multiplicationCC(fArray, this.P);
            fArray4 = MatrixAlgebra.multiplicationCC(MatrixAlgebra.multiplicationCC(fArray2, fArray), fArray4);
        }
        this.P = MatrixAlgebra.transposeC(this.P);
        fArray4 = MatrixAlgebra.multiplicationCC(fArray4, this.P);
        this.L = fArray4;
        for (n2 = 0; n2 < this.N - 1; ++n2) {
            for (n = n2 + 1; n < this.N; ++n) {
                this.L[n][n2] = -this.L[n][n2];
                for (int i = 0; i < n2; ++i) {
                    float[] fArray5 = this.L[n];
                    int n3 = i;
                    fArray5[n3] = fArray5[n3] + this.L[n2][i] * this.L[n][n2];
                }
            }
        }
    }

    public TriangularElementaryReversibleMatrix(float[][] fArray) {
        assert (fArray.length == fArray[0].length);
        this.A = MatrixAlgebra.copy(fArray);
        this.N = this.A.length;
    }

    public float[][] getElementaryMatrixL() {
        assert (this.called > 0);
        return this.L;
    }

    public float[][] getElementaryMatrixU() {
        assert (this.called > 0);
        return this.A;
    }

    public float[][] getElementaryMatrixS() {
        assert (this.called > 0);
        return this.S;
    }

    public int[] getPermutation() {
        assert (this.called > 0);
        int[] nArray = new int[this.N];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                if (this.P[i][j] != 1.0f) continue;
                nArray[i] = j;
            }
        }
        return nArray;
    }

    public float[][] getPermutationMatrix() {
        assert (this.called > 0);
        return this.P;
    }

    void triangularElementaryReversibleMatrix2by2() {
        float f;
        float f2;
        float f3;
        float f4;
        float[][] fArrayArray;
        float f5 = this.A[0][0];
        float f6 = this.A[0][1];
        float f7 = this.A[1][0];
        float f8 = this.A[1][1];
        float[][] fArrayArray2 = new float[][]{{1.0f, 0.0f}, {0.0f, 1.0f}};
        float[][] fArrayArray3 = new float[][]{{0.0f, 1.0f}, {1.0f, 0.0f}};
        if (f5 * f8 - f6 * f7 < 0.0f) {
            assert (false);
            f7 = -f7;
            f8 = -f8;
        }
        if (Math.abs(f6) > Math.abs(f8)) {
            fArrayArray = fArrayArray2;
            f3 = f4 = (f5 - 1.0f) / f6;
            f2 = f6;
            f = 1.0f;
        } else {
            fArrayArray = fArrayArray3;
            f4 = (f6 + 1.0f) / f5;
            f2 = f8;
            f3 = -f4;
            f = -1.0f;
        }
        float[][] fArrayArray4 = new float[][]{{1.0f, 0.0f}, {f4, f}};
        float[][] fArrayArray5 = new float[][]{{1.0f, f2}, {0.0f, 1.0f}};
        float[][] fArrayArray6 = new float[][]{{1.0f, 0.0f}, {f3, 1.0f}};
        this.P = fArrayArray;
        this.L = fArrayArray4;
        this.A = fArrayArray5;
        this.S = fArrayArray6;
    }

    @Override
    public TriangularElementaryReversibleMatrix call() {
        assert (this.called == 0);
        ++this.called;
        assert (this.N > 0);
        if (this.N > 2) {
            try {
                this.triangularElementaryReversibleMatrix();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                assert (false);
            }
        } else if (this.N == 2) {
            this.triangularElementaryReversibleMatrix2by2();
        } else {
            this.A = MatrixAlgebra.identityC(1);
            this.S = MatrixAlgebra.identityC(1);
            this.P = MatrixAlgebra.identityC(1);
            this.L = MatrixAlgebra.identityC(1);
        }
        return this;
    }

    class BestMove
    implements Comparator<BestMove> {
        public int permuted_row = -1;
        public int permuted_col = -1;
        public float min = Float.POSITIVE_INFINITY;

        public BestMove() {
        }

        public BestMove(int n, int n2, float f) {
            this.permuted_row = n;
            this.permuted_col = n2;
            this.min = f;
        }

        @Override
        public int compare(BestMove bestMove, BestMove bestMove2) {
            if (bestMove.min < bestMove2.min) {
                return -1;
            }
            if (bestMove.min > bestMove2.min) {
                return 1;
            }
            return 0;
        }
    }

    private class State {
        public float[][] Ps;
        public float[][] Ls;
        public float[][] Ss;
        public float[][] A;
        public float result;

        public State() {
        }

        public State(State state) {
            this.Ps = MatrixAlgebra.copy(state.Ps);
            this.Ls = MatrixAlgebra.copy(state.Ls);
            this.Ss = MatrixAlgebra.copy(state.Ss);
            this.A = MatrixAlgebra.copy(state.A);
            this.result = state.result;
        }
    }
}

