/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciParallel.ParallelMap;
import GiciTransform.TriangularElementaryReversibleMatrix;
import java.util.concurrent.Callable;

public strictfp class TriangularElementaryReversibleTransform
implements Callable<float[][][]> {
    private final int[] memberPermutation;
    private final float[][] memberTermL;
    private final float[][] memberTermU;
    private final float[][] memberTermS;
    private float[][][] image;
    private boolean forward;

    public TriangularElementaryReversibleTransform(int[] nArray, float[][] fArray, float[][] fArray2, float[][] fArray3, float[][][] fArray4, boolean bl) {
        this.memberPermutation = nArray;
        this.memberTermL = fArray;
        this.memberTermU = fArray2;
        this.memberTermS = fArray3;
        this.forward = bl;
        assert (fArray.length == fArray4.length && fArray2.length == fArray4.length && fArray3.length == fArray4.length && fArray.length == fArray[0].length && fArray2.length == fArray2[0].length && fArray3.length == fArray3[0].length);
        assert (nArray.length == fArray4.length);
        this.image = fArray4;
    }

    public TriangularElementaryReversibleTransform(TriangularElementaryReversibleMatrix triangularElementaryReversibleMatrix, float[][][] fArray, boolean bl) {
        this.memberPermutation = triangularElementaryReversibleMatrix.getPermutation();
        this.memberTermL = triangularElementaryReversibleMatrix.getElementaryMatrixL();
        this.memberTermU = triangularElementaryReversibleMatrix.getElementaryMatrixU();
        this.memberTermS = triangularElementaryReversibleMatrix.getElementaryMatrixS();
        this.forward = bl;
        assert (this.memberTermL.length == fArray.length && this.memberTermU.length == fArray.length && this.memberTermS.length == fArray.length && this.memberTermL.length == this.memberTermL[0].length && this.memberTermU.length == this.memberTermU[0].length && this.memberTermS.length == this.memberTermS[0].length);
        assert (this.memberPermutation.length == fArray.length);
        this.image = fArray;
    }

    private long[] applyLowerTerm(float[][] fArray, long[] lArray) {
        int n = lArray.length;
        assert (fArray.length == n && fArray[0].length == n);
        if (fArray[n - 1][n - 1] < 0.0f) {
            lArray[n - 1] = -lArray[n - 1];
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                d += (double)fArray[n2][i] * (double)lArray[i];
            }
            int n3 = n2--;
            lArray[n3] = (long)((double)lArray[n3] + Math.rint(d));
        }
        return lArray;
    }

    private long[] applyUpperTerm(float[][] fArray, long[] lArray) {
        int n = lArray.length;
        assert (fArray.length == n && fArray[0].length == n);
        int n2 = 0;
        while (n2 < n) {
            double d = 0.0;
            for (int i = n2 + 1; i < n; ++i) {
                d += (double)fArray[n2][i] * (double)lArray[i];
            }
            int n3 = n2++;
            lArray[n3] = (long)((double)lArray[n3] + Math.rint(d));
        }
        if (fArray[n - 1][n - 1] < 0.0f) {
            lArray[n - 1] = -lArray[n - 1];
        }
        return lArray;
    }

    private long[] applyPermutation(int[] nArray, long[] lArray) {
        long[] lArray2 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray2[i] = lArray[nArray[i]];
        }
        return lArray2;
    }

    private long[] removeLowerTerm(float[][] fArray, long[] lArray) {
        int n = lArray.length;
        assert (fArray.length == n && fArray[0].length == n);
        int n2 = 0;
        while (n2 < n) {
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                d += (double)fArray[n2][i] * (double)lArray[i];
            }
            int n3 = n2++;
            lArray[n3] = (long)((double)lArray[n3] - Math.rint(d));
        }
        if (fArray[n - 1][n - 1] < 0.0f) {
            lArray[n - 1] = -lArray[n - 1];
        }
        return lArray;
    }

    private long[] removeUpperTerm(float[][] fArray, long[] lArray) {
        int n = lArray.length;
        assert (fArray.length == n && fArray[0].length == n);
        if (fArray[n - 1][n - 1] < 0.0f) {
            lArray[n - 1] = -lArray[n - 1];
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            double d = 0.0;
            for (int i = n2 + 1; i < n; ++i) {
                d += (double)fArray[n2][i] * (double)lArray[i];
            }
            int n3 = n2--;
            lArray[n3] = (long)((double)lArray[n3] - Math.rint(d));
        }
        return lArray;
    }

    private int[] inversePermutation(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
        return nArray2;
    }

    @Override
    public final float[][][] call() {
        final float[][][] fArray = new float[this.image.length][this.image[0].length][this.image[0][0].length];
        final int n = this.image.length;
        int n2 = this.image[0].length;
        int n3 = this.image[0][0].length;
        if (this.forward) {
            ParallelMap.map(new ParallelMap.MultidimensionalIterator(n2, n3), new ParallelMap.MapInterface<int[]>(){

                @Override
                public void apply(int[] nArray) {
                    int n2;
                    long[] lArray = new long[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        lArray[n2] = (int)TriangularElementaryReversibleTransform.this.image[n2][nArray[0]][nArray[1]];
                    }
                    lArray = TriangularElementaryReversibleTransform.this.applyLowerTerm(TriangularElementaryReversibleTransform.this.memberTermS, lArray);
                    lArray = TriangularElementaryReversibleTransform.this.applyUpperTerm(TriangularElementaryReversibleTransform.this.memberTermU, lArray);
                    lArray = TriangularElementaryReversibleTransform.this.applyLowerTerm(TriangularElementaryReversibleTransform.this.memberTermL, lArray);
                    lArray = TriangularElementaryReversibleTransform.this.applyPermutation(TriangularElementaryReversibleTransform.this.memberPermutation, lArray);
                    for (n2 = 0; n2 < n; ++n2) {
                        assert (lArray[n2] < 0x800000L && lArray[n2] > -8388608L);
                        fArray[n2][nArray[0]][nArray[1]] = lArray[n2];
                    }
                }
            });
        } else {
            final int[] nArray = this.inversePermutation(this.memberPermutation);
            ParallelMap.map(new ParallelMap.MultidimensionalIterator(n2, n3), new ParallelMap.MapInterface<int[]>(){

                @Override
                public void apply(int[] nArray2) {
                    int n2;
                    long[] lArray = new long[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        lArray[n2] = (int)TriangularElementaryReversibleTransform.this.image[n2][nArray2[0]][nArray2[1]];
                    }
                    lArray = TriangularElementaryReversibleTransform.this.applyPermutation(nArray, lArray);
                    lArray = TriangularElementaryReversibleTransform.this.removeLowerTerm(TriangularElementaryReversibleTransform.this.memberTermL, lArray);
                    lArray = TriangularElementaryReversibleTransform.this.removeUpperTerm(TriangularElementaryReversibleTransform.this.memberTermU, lArray);
                    lArray = TriangularElementaryReversibleTransform.this.removeLowerTerm(TriangularElementaryReversibleTransform.this.memberTermS, lArray);
                    for (n2 = 0; n2 < n; ++n2) {
                        assert (lArray[n2] < 0x800000L && lArray[n2] > -8388608L);
                        fArray[n2][nArray2[0]][nArray2[1]] = lArray[n2];
                    }
                }
            });
        }
        return fArray;
    }
}

