/*
 * Decompiled with CFR 0.152.
 */
package List;

public class SpihtLinkedList2D {
    private transient Entry head;
    public transient Entry lastEntry;
    private transient Entry currentPosition;
    private transient int size;

    public SpihtLinkedList2D() {
        this.head.next = this.head = new Entry(0, 0, null);
        this.lastEntry = this.head;
        this.currentPosition = this.head;
        this.size = 0;
    }

    public void cloneList(SpihtLinkedList2D spihtLinkedList2D) {
        this.clearList();
        if (!spihtLinkedList2D.isEmpty()) {
            int n = spihtLinkedList2D.size();
            spihtLinkedList2D.initialNode();
            for (int i = 0; i < n; ++i) {
                this.addElement(spihtLinkedList2D.getX(), spihtLinkedList2D.getY());
                spihtLinkedList2D.nextValue();
            }
        }
    }

    public void cloneListTyped(SpihtLinkedList2D spihtLinkedList2D) {
        this.clearList();
        if (!spihtLinkedList2D.isEmpty()) {
            int n = spihtLinkedList2D.size();
            spihtLinkedList2D.initialNode();
            for (int i = 0; i < n; ++i) {
                this.addElement(spihtLinkedList2D.getX(), spihtLinkedList2D.getY(), spihtLinkedList2D.getType());
                spihtLinkedList2D.nextValue();
            }
        }
    }

    public void addElement(int n, boolean bl) {
        Entry entry;
        this.lastEntry.next = entry = new Entry(n, 0, bl, this.head.next);
        this.lastEntry = entry;
        ++this.size;
    }

    public void addElement(int n) {
        Entry entry;
        this.lastEntry.next = entry = new Entry(n, 0, this.head.next);
        this.lastEntry = entry;
        ++this.size;
    }

    public void addElement(int n, int n2, boolean bl) {
        Entry entry;
        this.lastEntry.next = entry = new Entry(n, n2, bl, this.head.next);
        this.lastEntry = entry;
        ++this.size;
    }

    public void addElement(int n, int n2) {
        Entry entry;
        this.lastEntry.next = entry = new Entry(n, n2, this.head.next);
        this.lastEntry = entry;
        ++this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isLast() {
        return this.currentPosition.next == this.lastEntry;
    }

    public void remove() {
        if (this.size == 1) {
            this.head.next = this.head;
            this.lastEntry = this.head;
            this.currentPosition = this.head;
            this.size = 0;
        } else {
            if (this.currentPosition.next == this.lastEntry) {
                this.lastEntry = this.currentPosition;
            }
            this.currentPosition.next = this.currentPosition.next.next;
            --this.size;
        }
    }

    public void nextValue() {
        this.currentPosition = this.currentPosition.next;
    }

    public int size() {
        return this.size;
    }

    public void initialNode() {
        this.currentPosition = this.head;
    }

    public void clearList() {
        this.head.next = this.head;
        this.lastEntry = this.head;
        this.currentPosition = this.head;
        this.size = 0;
        System.gc();
    }

    public void moveElementAtLast(SpihtLinkedList2D spihtLinkedList2D) {
        spihtLinkedList2D.addElement(this.currentPosition.next.x, this.currentPosition.next.y, this.currentPosition.next.type);
        this.remove();
    }

    public int getX() {
        return this.currentPosition.next.x;
    }

    public int getY() {
        return this.currentPosition.next.y;
    }

    public boolean getType() {
        return this.currentPosition.next.type;
    }

    public void setType(boolean bl) {
        this.currentPosition.next.type = bl;
    }

    public void showList(boolean bl) {
        System.out.println("Longitut: " + this.size);
        System.out.print("{");
        Entry entry = this.head.next;
        for (int i = 0; i < this.size; ++i) {
            if (bl) {
                System.out.print("[" + entry.x + "," + entry.y + "]" + entry.type + " ,");
            } else {
                System.out.print("[" + entry.x + "," + entry.y + "]");
            }
            entry = entry.next;
        }
        System.out.println("}");
    }

    private static class Entry {
        int x;
        int y;
        boolean type;
        Entry next;

        Entry(int n, int n2, boolean bl, Entry entry) {
            this.x = n;
            this.y = n2;
            this.type = bl;
            this.next = entry;
        }

        Entry(int n, int n2, Entry entry) {
            this.x = n;
            this.y = n2;
            this.next = entry;
        }
    }
}

