/*
 * Decompiled with CFR 0.152.
 */
package List;

public class SpihtVector {
    protected int[] elementDataX;
    protected int[] elementDataY;
    protected int[] elementDataZ;
    protected boolean[] type;
    protected boolean typed;
    protected int dimension;
    protected int elementCount;
    protected int initialCapacity;
    protected int capacityIncrement;

    public SpihtVector(int n, int n2, int n3, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal Capacity Increment: " + n2);
        }
        if (n3 < 1 || n3 > 3) {
            throw new IllegalArgumentException("Dimension Illegal: " + n3);
        }
        this.elementDataY = null;
        this.elementDataZ = null;
        this.type = null;
        this.elementCount = 0;
        this.elementDataX = new int[n];
        if (n3 > 1) {
            this.elementDataY = new int[n];
        }
        if (n3 > 2) {
            this.elementDataZ = new int[n];
        }
        if (bl) {
            this.type = new boolean[n];
        }
        this.typed = bl;
        this.initialCapacity = n;
        this.capacityIncrement = n2;
        this.dimension = n3;
    }

    public int capacity() {
        return this.elementDataX.length;
    }

    public int size() {
        return this.elementCount;
    }

    public void ensureCapacity() {
        int[] nArray = new int[this.initialCapacity + this.capacityIncrement];
        System.arraycopy(this.elementDataX, 0, nArray, 0, this.elementCount);
        this.elementDataX = nArray;
        nArray = null;
        if (this.dimension > 1) {
            nArray = new int[this.initialCapacity + this.capacityIncrement];
            System.arraycopy(this.elementDataY, 0, nArray, 0, this.elementCount);
            this.elementDataY = nArray;
            nArray = null;
        }
        if (this.dimension > 2) {
            nArray = new int[this.initialCapacity + this.capacityIncrement];
            System.arraycopy(this.elementDataZ, 0, nArray, 0, this.elementCount);
            this.elementDataZ = nArray;
            nArray = null;
        }
        if (this.typed) {
            boolean[] blArray = new boolean[this.initialCapacity + this.capacityIncrement];
            System.arraycopy(this.type, 0, blArray, 0, this.elementCount);
            this.type = blArray;
            blArray = null;
        }
        this.initialCapacity += this.capacityIncrement;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int getX(int n) {
        if (n >= this.elementDataX.length) {
            throw new ArrayIndexOutOfBoundsException("getX: " + n + " > " + this.elementCount);
        }
        return this.elementDataX[n];
    }

    public int getY(int n) throws Exception {
        if (n >= this.elementDataX.length) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (this.dimension < 2) {
            throw new Exception("Second Dimension not defined");
        }
        return this.elementDataY[n];
    }

    public int getZ(int n) throws Exception {
        if (n >= this.elementDataX.length) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (this.dimension < 3) {
            throw new Exception("Third Dimension not defined");
        }
        return this.elementDataZ[n];
    }

    public boolean getType(int n) throws Exception {
        if (n >= this.type.length) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (!this.typed) {
            throw new Exception("Type Not Defined");
        }
        return this.type[n];
    }

    public void setType(int n, boolean bl) throws Exception {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (!this.typed) {
            throw new Exception("The list has no type");
        }
        this.type[n] = bl;
    }

    public void removeCollectionOfElements(int[] nArray, int n) throws Exception {
        if (nArray == null) {
            throw new Exception("Index Vector is null");
        }
        if (n == 0) {
            return;
        }
        for (int i = --n; i >= 0; --i) {
            int n2 = this.elementCount - nArray[i] - 1;
            if (n2 > 0) {
                System.arraycopy(this.elementDataX, nArray[i] + 1, this.elementDataX, nArray[i], n2);
                this.elementDataX[this.elementCount] = 0;
                if (this.typed) {
                    System.arraycopy(this.type, nArray[i] + 1, this.type, nArray[i], n2);
                    this.type[this.elementCount] = false;
                }
                if (this.dimension > 1) {
                    System.arraycopy(this.elementDataY, nArray[i] + 1, this.elementDataY, nArray[i], n2);
                    this.elementDataY[this.elementCount] = 0;
                }
                if (this.dimension > 2) {
                    System.arraycopy(this.elementDataZ, nArray[i] + 1, this.elementDataZ, nArray[i], n2);
                    this.elementDataZ[this.elementCount] = 0;
                }
            }
            this.elementDataX[this.elementCount] = 0;
            if (this.typed) {
                this.type[this.elementCount] = false;
            }
            if (this.dimension > 1) {
                this.elementDataY[this.elementCount] = 0;
            }
            if (this.dimension > 2) {
                this.elementDataZ[this.elementCount] = 0;
            }
            --this.elementCount;
        }
    }

    public void removeElement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Index: " + n);
        }
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementDataX, n + 1, this.elementDataX, n, n2);
            if (this.typed) {
                System.arraycopy(this.type, n + 1, this.type, n, n2);
            }
            if (this.dimension > 1) {
                System.arraycopy(this.elementDataY, n + 1, this.elementDataY, n, n2);
            }
            if (this.dimension > 2) {
                System.arraycopy(this.elementDataZ, n + 1, this.elementDataZ, n, n2);
            }
        }
        this.elementDataX[this.elementCount] = 0;
        if (this.typed) {
            this.type[this.elementCount] = false;
        }
        if (this.dimension > 1) {
            this.elementDataY[this.elementCount] = 0;
        }
        if (this.dimension > 2) {
            this.elementDataZ[this.elementCount] = 0;
        }
        --this.elementCount;
    }

    public void addElement(int n) {
        if (this.elementCount + 1 >= this.elementDataX.length) {
            this.ensureCapacity();
        }
        if (this.typed) {
            throw new IllegalArgumentException("The list is typed. Each component of the list has an associated type.");
        }
        this.elementDataX[this.elementCount] = n;
        ++this.elementCount;
    }

    public void addElement(int n, boolean bl) {
        if (this.elementCount + 1 >= this.elementDataX.length) {
            this.ensureCapacity();
        }
        this.elementDataX[this.elementCount] = n;
        if (!this.typed) {
            throw new IllegalArgumentException("The list is not typed");
        }
        this.type[this.elementCount] = bl;
        ++this.elementCount;
    }

    public void addElement(int n, int n2) {
        if (this.elementCount + 1 >= this.elementDataX.length) {
            this.ensureCapacity();
        }
        if (this.typed) {
            throw new IllegalArgumentException("The list is typed. Each component of the list has an associated type.");
        }
        this.elementDataX[this.elementCount] = n;
        this.elementDataY[this.elementCount] = n2;
        ++this.elementCount;
    }

    public void addElement(int n, int n2, boolean bl) {
        if (this.elementCount + 1 >= this.elementDataX.length) {
            this.ensureCapacity();
        }
        this.elementDataX[this.elementCount] = n;
        this.elementDataY[this.elementCount] = n2;
        if (!this.typed) {
            throw new IllegalArgumentException("The list is not typed");
        }
        this.type[this.elementCount] = bl;
        ++this.elementCount;
    }

    public void addElement(int n, int n2, int n3) {
        if (this.elementCount + 1 >= this.elementDataX.length) {
            this.ensureCapacity();
        }
        if (this.typed) {
            throw new IllegalArgumentException("The list is typed. Each component of the list has an associated type.");
        }
        this.elementDataX[this.elementCount] = n;
        this.elementDataY[this.elementCount] = n2;
        this.elementDataZ[this.elementCount] = n3;
        ++this.elementCount;
    }

    public void addElement(int n, int n2, int n3, boolean bl) {
        if (this.elementCount + 1 >= this.elementDataX.length) {
            this.ensureCapacity();
        }
        this.elementDataX[this.elementCount] = n;
        this.elementDataY[this.elementCount] = n2;
        this.elementDataZ[this.elementCount] = n3;
        if (!this.typed) {
            throw new IllegalArgumentException("The list is not typed");
        }
        this.type[this.elementCount] = bl;
        ++this.elementCount;
    }

    public void copyInto(int[] nArray, int n) {
        if (nArray.length < n) {
            throw new IllegalArgumentException("The length " + n + " >= array length.");
        }
        while (this.elementCount + n >= this.elementDataX.length) {
            this.ensureCapacity();
        }
        System.arraycopy(nArray, 0, this.elementDataX, this.elementCount, n);
        this.elementCount += n;
    }

    public void copyInto(int[] nArray, int[] nArray2, int n) {
        if (nArray.length < n) {
            throw new IllegalArgumentException("The length of X array " + n + " >= array length.");
        }
        if (nArray2.length < n) {
            throw new IllegalArgumentException("The length of Y array " + n + " >= array length.");
        }
        if (this.initialCapacity <= this.elementCount + n) {
            throw new IllegalArgumentException("The length " + n + " >= elementData length.");
        }
        System.arraycopy(nArray, 0, this.elementDataX, this.elementCount, n);
        System.arraycopy(nArray2, 0, this.elementDataY, this.elementCount, n);
        this.elementCount += n;
    }

    public void copyInto(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        if (nArray.length < n) {
            throw new IllegalArgumentException("The length of X array " + n + " >= array length.");
        }
        if (nArray2.length < n) {
            throw new IllegalArgumentException("The length of Y array " + n + " >= array length.");
        }
        if (nArray3.length < n) {
            throw new IllegalArgumentException("The length of Z array " + n + " >= array length.");
        }
        if (this.initialCapacity <= this.elementCount + n) {
            throw new IllegalArgumentException("The length " + n + " >= elementData length.");
        }
        System.arraycopy(nArray, 0, this.elementDataX, this.elementCount, n);
        System.arraycopy(nArray2, 0, this.elementDataY, this.elementCount, n);
        System.arraycopy(nArray3, 0, this.elementDataZ, this.elementCount, n);
        this.elementCount += n;
    }

    public int[] getElementDataX() {
        int[] nArray = new int[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            nArray[i] = this.elementDataX[i];
        }
        return nArray;
    }

    public int[] getElementDataY() {
        if (this.dimension < 2) {
            throw new IllegalArgumentException("The second dimension is not defined");
        }
        int[] nArray = new int[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            nArray[i] = this.elementDataY[i];
        }
        return nArray;
    }

    public int[] getElementDataZ() {
        if (this.dimension < 3) {
            throw new IllegalArgumentException("The third dimension is not defined");
        }
        int[] nArray = new int[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            nArray[i] = this.elementDataY[i];
        }
        return nArray;
    }

    public boolean[] getElementType() {
        if (!this.typed) {
            throw new IllegalArgumentException("The types are not defined");
        }
        return this.type;
    }

    public SpihtVector cloneObject() {
        SpihtVector spihtVector = new SpihtVector(this.initialCapacity, this.capacityIncrement, this.dimension, this.typed);
        if (this.dimension == 1) {
            spihtVector.copyInto(this.elementDataX, this.elementCount);
        } else if (this.dimension == 2) {
            spihtVector.copyInto(this.elementDataX, this.elementDataY, this.elementCount);
        } else if (this.dimension == 3) {
            spihtVector.copyInto(this.elementDataX, this.elementDataY, this.elementDataZ, this.elementCount);
        }
        return spihtVector;
    }
}

