/*
 * Decompiled with CFR 0.152.
 */
package Speck.SpeckCoding;

import GiciBitStream.BitOutputStream;
import Speck.Speck;
import Speck.SpeckVector;
import java.io.FileOutputStream;
import java.io.IOException;

public class SpeckCoding2D
extends Speck {
    protected BitOutputStream output = null;
    protected int minThreshold = 0;
    protected int SetIlevels = 0;

    public SpeckCoding2D() {
        this.image = null;
    }

    public SpeckCoding2D(int[][][] nArray) throws IOException {
        this.image = nArray;
        this.ySize = nArray[0].length;
        this.xSize = nArray[0][0].length;
        this.zSize = nArray.length;
    }

    public void setParameters(int n, String string, int n2, int n3) throws IOException {
        this.WTlevels = n;
        this.method = n2;
        this.SetIlevels = n;
        this.minThreshold = n3;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.output = new BitOutputStream(fileOutputStream);
        this.output.writeUBits(this.xSize, 16);
        this.output.writeUBits(this.ySize, 16);
        this.output.writeUBits(this.zSize, 16);
        this.output.writeUBits(n, 4);
        this.output.writeUBits(n2, 2);
    }

    public void run() throws IOException {
        int n;
        int n2 = 0;
        SpeckVector.SpeckSet speckSet = new SpeckVector.SpeckSet(0, 0);
        SpeckVector speckVector = new SpeckVector();
        this.maxThreshold = this.initialTh();
        this.SetSizes = (int)(Math.log(this.ySize) / Math.log(2.0));
        this.LIS = new SpeckVector.SpeckDynamV();
        this.LSP = new SpeckVector();
        this.SetI = new SpeckVector[this.WTlevels];
        for (n = 0; n < this.WTlevels; ++n) {
            this.SetI[n] = new SpeckVector();
        }
        speckSet.SetSize(this.xSize, this.ySize);
        for (n = 0; n < this.WTlevels; ++n) {
            speckVector = this.QuadriSect(speckSet);
            speckSet = speckVector.PopSet();
            for (int i = 0; i < 3; ++i) {
                this.SetI[this.WTlevels - n - 1].AddSet(speckVector.PopSet());
            }
        }
        this.LIS.AddDynSet(speckSet);
        try {
            n = (int)(Math.log(this.maxThreshold) / Math.log(2.0));
            this.output.writeUBits(n, 5);
            while (this.maxThreshold > this.minThreshold) {
                n2 = this.LSP.getLength();
                this.Sorting();
                this.Refinement(n2);
                this.maxThreshold >>= 1;
            }
            this.output.close();
        }
        catch (IOException iOException) {
            this.output.close();
            System.out.println(iOException.getMessage());
            System.exit(1);
        }
    }

    public void Sorting() throws IOException {
        SpeckVector speckVector = this.LIS.top;
        int n = this.LIS.GetDynLength();
        for (int i = 0; i < n; ++i) {
            int n2 = speckVector.getLength();
            for (int j = 0; j < n2; ++j) {
                SpeckVector.SpeckSet speckSet = speckVector.PopSet();
                this.ProcessS(speckSet);
            }
            speckVector = speckVector.next;
        }
        if (this.SetIlevels > 0) {
            this.ProcessI();
        }
    }

    public void ProcessS(SpeckVector.SpeckSet speckSet) throws IOException {
        if (this.Significance(speckSet) == 1) {
            if (speckSet.GetSizeX() == 1 && speckSet.GetSizeY() == 1) {
                this.output.writeMulti(1);
                if (this.image[0][speckSet.GetSetY()][speckSet.GetSetX()] < 0) {
                    this.output.writeMulti(0);
                } else {
                    this.output.writeMulti(1);
                }
                this.LSP.AddSet(speckSet);
            } else {
                this.output.writeMulti(1);
                this.CodeS(speckSet);
            }
        } else {
            this.LIS.AddDynSet(speckSet);
            this.output.writeMulti(0);
        }
    }

    public void CodeS(SpeckVector.SpeckSet speckSet) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        SpeckVector speckVector = null;
        SpeckVector speckVector2 = null;
        SpeckVector.SpeckSet speckSet2 = null;
        speckVector = new SpeckVector();
        speckVector2 = new SpeckVector();
        speckSet2 = new SpeckVector.SpeckSet();
        speckVector = this.QuadriSect(speckSet);
        int n4 = speckVector.getLength();
        for (n = 0; n < n4; ++n) {
            speckSet2 = speckVector.PopSet();
            if (this.Significance(speckSet2) == 1) {
                if (speckSet2.GetSizeX() == 1 && speckSet2.GetSizeY() == 1) {
                    if (this.method != 2 || n != 3 || n3 != 3) {
                        this.output.writeMulti(1);
                    }
                    if (this.image[0][speckSet2.GetSetY()][speckSet2.GetSetX()] < 0) {
                        this.output.writeMulti(0);
                    } else {
                        this.output.writeMulti(1);
                    }
                    this.LSP.AddSet(speckSet2);
                    continue;
                }
                if (this.method != 1) {
                    if (this.method == 0 || n != 3 || n3 != 3) {
                        this.output.writeMulti(1);
                    }
                    this.CodeS(speckSet2);
                    continue;
                }
                this.output.writeMulti(1);
                speckVector2.AddSet(speckSet2);
                continue;
            }
            this.output.writeMulti(0);
            ++n3;
            this.LIS.AddDynSet(speckSet2);
        }
        n2 = speckVector2.getLength();
        if (this.method == 1 && n2 > 0) {
            for (n = 0; n < n2; ++n) {
                speckSet2 = speckVector2.PopSet();
                this.CodeS(speckSet2);
            }
        }
    }

    public void ProcessI() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < this.WTlevels; ++i) {
            int n = this.SetI[i].getLength();
            SpeckVector.SpeckSet speckSet = this.SetI[i].top;
            for (int j = 0; j < n; ++j) {
                if (this.Significance(speckSet) == 1) {
                    bl = true;
                    break;
                }
                speckSet = speckSet.NextSet();
            }
            if (bl) break;
        }
        if (bl) {
            this.output.writeMulti(1);
            this.CodeI();
        } else {
            this.output.writeMulti(0);
        }
    }

    public void CodeI() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        --this.SetIlevels;
        while (this.SetI[n].getLength() != 3) {
            ++n;
        }
        for (int i = 0; i < 3; ++i) {
            SpeckVector.SpeckSet speckSet = this.SetI[n].PopSet();
            this.ProcessS(speckSet);
        }
        this.ProcessI();
    }

    public void Refinement(int n) throws IOException {
        SpeckVector.SpeckSet speckSet = null;
        speckSet = new SpeckVector.SpeckSet();
        speckSet = this.LSP.top;
        for (int i = 0; i < n; ++i) {
            int n2 = Math.abs(this.image[0][speckSet.GetSetY()][speckSet.GetSetX()]);
            int n3 = (this.maxThreshold & n2) != 0 ? 1 : 0;
            this.output.writeMulti(n3);
            speckSet = speckSet.NextSet();
        }
    }

    public int Significance(SpeckVector.SpeckSet speckSet) {
        int n = speckSet.GetSizeX();
        int n2 = speckSet.GetSizeY();
        int n3 = speckSet.GetSetX();
        int n4 = speckSet.GetSetY();
        for (int i = n3; i < n3 + n; ++i) {
            for (int j = n4; j < n4 + n2; ++j) {
                int n5 = Math.abs(this.image[0][j][i]);
                if (n5 < this.maxThreshold) continue;
                return 1;
            }
        }
        return 0;
    }

    protected SpeckVector QuadriSect(SpeckVector.SpeckSet speckSet) {
        SpeckVector speckVector = null;
        speckVector = new SpeckVector();
        int n = speckSet.GetSizeX();
        int n2 = speckSet.GetSizeY();
        int n3 = speckSet.GetSetX();
        int n4 = speckSet.GetSetY();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n > 1 && n2 > 1) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    n5 = n / 2;
                    n6 = n2 / 2;
                    SpeckVector.SpeckSet speckSet2 = new SpeckVector.SpeckSet();
                    speckSet2.SetX(n3 + n5 * i);
                    speckSet2.SetY(n4 + n6 * j);
                    if (n % 2 == 1 && n7 > 1) {
                        ++n5;
                    }
                    if (n2 % 2 == 1 && (n7 == 1 || n7 == 3)) {
                        ++n6;
                    }
                    speckSet2.SetSize(n5, n6);
                    speckVector.AddSet(speckSet2);
                    ++n7;
                }
            }
        } else {
            if (n == 1) {
                n5 = 0;
                n6 = 1;
            } else {
                n5 = 1;
                n6 = 0;
            }
            for (int i = 0; i < n * n2; ++i) {
                SpeckVector.SpeckSet speckSet3 = new SpeckVector.SpeckSet();
                speckSet3.SetX(n3 + n5 * i);
                speckSet3.SetY(n4 + n6 * i);
                speckSet3.SetSize(1, 1);
                speckVector.AddSet(speckSet3);
            }
        }
        return speckVector;
    }

    protected int initialTh() {
        int n = Math.abs(this.image[0][0][0]);
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                int n2 = Math.abs(this.image[0][j][i]);
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return (int)Math.pow(2.0, (int)(Math.log(n) / Math.log(2.0)));
    }
}

