/*
 * Decompiled with CFR 0.152.
 */
package Spiht.SpihtCoding;

import Building.PlaneBuilding;
import GiciBitStream.BitOutputStream;
import List.SpihtLinkedList2D;
import Spiht.Spiht;
import java.io.FileOutputStream;
import java.io.IOException;

public class SpihtCoding2D
extends Spiht {
    protected SpihtLinkedList2D LIC = null;
    protected SpihtLinkedList2D LSC = null;
    protected SpihtLinkedList2D LIS = null;
    protected int z = 0;
    protected BitOutputStream bos = null;
    protected long[][] table = null;
    protected long[][] errors = null;
    protected long[][] accessPoints = null;
    protected int[][] imageRecovered = null;
    protected boolean rate = false;

    public SpihtCoding2D() {
        this.image = null;
        this.z = 0;
        this.size = 0;
    }

    public SpihtCoding2D(int[][][] nArray, int n, String string, boolean bl, long l) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.bos = new BitOutputStream(fileOutputStream, l);
        this.zSize = nArray.length;
        this.ySize = nArray[0].length;
        this.xSize = nArray[0][0].length;
        this.levels = n;
        this.z = 0;
        this.size = 0;
        this.bos.writeUBits(this.xSize, 16);
        this.bos.writeUBits(this.ySize, 16);
        this.bos.writeUBits(this.zSize, 16);
        this.bos.writeUBits(n, 4);
        this.bos.writeUBits(this.method, 1);
        this.image = nArray;
        nArray = null;
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, n);
        this.limitResidualBandY = this.ySize / (int)Math.pow(2.0, n);
        this.limitParentX = this.xSize / 2;
        this.limitParentY = this.ySize / 2;
        this.limitGrandParentX = this.xSize / 4;
        this.limitGrandParentY = this.ySize / 4;
    }

    @Override
    public void openOutputBitstream(String string, long l) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.bos = new BitOutputStream(fileOutputStream, l);
    }

    @Override
    public void writeInitialHeader() throws IOException {
        if (this.bos == null) {
            throw new IOException("The output bitstream is closed. Initial header is not written.");
        }
        this.bos.writeUBits(this.xSize, 16);
        this.bos.writeUBits(this.ySize, 16);
        this.bos.writeUBits(this.zSize, 16);
        this.bos.writeUBits(this.levels, 4);
        this.bos.writeUBits(this.method, 1);
    }

    @Override
    public void calculateSubbandLimits() throws Exception {
        if (this.xSize == 0) {
            throw new Exception("The size of the image is not correct");
        }
        if (this.levels == 0) {
            throw new Exception("The number of levels of the image is not correct");
        }
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels);
        this.limitResidualBandY = this.ySize / (int)Math.pow(2.0, this.levels);
        this.limitParentX = this.xSize / 2;
        this.limitParentY = this.ySize / 2;
        this.limitGrandParentX = this.xSize / 4;
        this.limitGrandParentY = this.ySize / 4;
    }

    @Override
    public void code(int n) throws IOException {
        this.rate = false;
        this.z = 0;
        while (this.z < this.zSize) {
            this.LIC = new SpihtLinkedList2D();
            this.LSC = new SpihtLinkedList2D();
            this.LIS = new SpihtLinkedList2D();
            this.maxThreshold = this.initialTh();
            System.out.println("Max BitPlane: " + this.maxThreshold);
            int n2 = (int)(Math.log(this.maxThreshold) / Math.log(2.0));
            this.bos.writeUBits(n2, 5);
            this.listInitialize();
            while (this.maxThreshold > n) {
                int n3 = this.LSC.size();
                try {
                    this.sort(this.maxThreshold);
                    if (n3 != 0) {
                        this.refinement(this.maxThreshold, n3);
                    }
                    this.maxThreshold >>= 1;
                }
                catch (IOException iOException) {
                    this.bos.close();
                    System.out.println(iOException.getMessage());
                    System.exit(1);
                }
            }
            ++this.z;
        }
        this.bos.close();
    }

    @Override
    public void codeRated(int n) throws IOException {
        int[][] nArray = null;
        this.rate = true;
        this.table = new long[this.zSize][];
        this.accessPoints = new long[this.zSize][];
        this.errors = new long[this.zSize][];
        this.z = 0;
        while (this.z < this.zSize) {
            this.LIC = new SpihtLinkedList2D();
            this.LSC = new SpihtLinkedList2D();
            this.LIS = new SpihtLinkedList2D();
            int n2 = 0;
            this.maxThreshold = this.initialTh();
            int n3 = (int)(Math.log(this.maxThreshold) / Math.log(2.0));
            this.bos.writeUBits(n3, 5);
            nArray = new int[this.ySize][this.xSize];
            this.imageRecovered = new int[this.ySize][this.xSize];
            for (int i = 0; i < this.ySize; ++i) {
                for (int j = 0; j < this.xSize; ++j) {
                    nArray[i][j] = this.image[this.z][i][j];
                    this.imageRecovered[i][j] = 0;
                }
            }
            this.table[this.z] = new long[n3 * 2 + 1];
            this.accessPoints[this.z] = new long[n3 * 2 + 2];
            this.errors[this.z] = new long[n3 * 2 + 2];
            this.accessPoints[this.z][n2] = this.size;
            this.listInitialize();
            this.errors[this.z][0] = this.computeSquareError(nArray, this.imageRecovered);
            while (this.maxThreshold > n) {
                int n4 = this.LSC.size();
                try {
                    this.sort(this.maxThreshold);
                }
                catch (IOException iOException) {
                    this.bos.close();
                    throw new IOException(iOException.getMessage());
                }
                this.errors[this.z][n2 + 1] = this.computeSquareError(nArray, this.imageRecovered);
                this.table[this.z][n2] = this.errors[this.z][n2] - this.errors[this.z][n2 + 1];
                this.accessPoints[this.z][++n2] = this.size;
                if (n4 != 0) {
                    try {
                        this.refinement(this.maxThreshold, n4);
                    }
                    catch (IOException iOException) {
                        this.bos.close();
                        throw new IOException(iOException.getMessage());
                    }
                    this.errors[this.z][n2 + 1] = this.computeSquareError(nArray, this.imageRecovered);
                    this.table[this.z][n2] = this.errors[this.z][n2] - this.errors[this.z][n2 + 1];
                    this.accessPoints[this.z][++n2] = this.size;
                }
                this.maxThreshold >>= 1;
            }
            if (this.errors[this.z][this.errors[this.z].length - 1] != 0L) {
                System.out.println("The distortion operation fails.");
                System.exit(0);
            }
            long l = 0L;
            for (int i = 0; i < this.table[this.z].length; ++i) {
                l += this.table[this.z][i];
            }
            if (l != this.errors[this.z][0]) {
                System.out.println("The distortion operation fails in the total distortion in the " + this.z + " component.");
                System.out.println("Acum: " + l + " Errors: " + this.errors[this.z][0]);
                System.exit(0);
            }
            ++this.z;
        }
        this.bos.close();
    }

    @Override
    public void codeBuilding(int n) throws IOException {
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels) * this.zSize;
        this.limitParentX = this.xSize / 2 * this.zSize;
        this.limitGrandParentX = this.xSize / 4 * this.zSize;
        try {
            PlaneBuilding planeBuilding = new PlaneBuilding(this.levels);
            this.image = planeBuilding.obtainReorganizedImage(this.image);
        }
        catch (Exception exception) {
            System.out.println("Image reorganization failed");
            System.exit(2);
        }
        this.xSize *= this.zSize;
        this.zSize = 1;
        this.code(n);
        this.image = null;
    }

    @Override
    public void codeInterleaved(int n) throws Exception {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        boolean bl = false;
        int[] nArray = null;
        int[] nArray2 = null;
        nArray = new int[this.zSize];
        nArray2 = new int[this.zSize];
        this.z = 0;
        while (this.z < this.zSize) {
            nArray[this.z] = this.initialTh();
            nArray2[this.z] = (int)(Math.log(nArray[this.z]) / Math.log(2.0));
            if (n3 < nArray2[this.z]) {
                n3 = nArray2[this.z];
            }
            if (n2 > nArray2[this.z]) {
                n2 = nArray2[this.z];
            }
            ++this.z;
        }
        this.z = 0;
        SpihtLinkedList2D[] spihtLinkedList2DArray = new SpihtLinkedList2D[this.zSize];
        SpihtLinkedList2D[] spihtLinkedList2DArray2 = new SpihtLinkedList2D[this.zSize];
        SpihtLinkedList2D[] spihtLinkedList2DArray3 = new SpihtLinkedList2D[this.zSize];
        this.LIC = new SpihtLinkedList2D();
        this.LIS = new SpihtLinkedList2D();
        this.LSC = new SpihtLinkedList2D();
        this.listInitialize();
        System.out.println("maxBPE: " + n3);
        System.out.println("minBPE: " + n2);
        this.bos.writeUBits(n3, 5);
        this.bos.writeUBits(n2, 5);
        for (int i = 0; i < this.zSize; ++i) {
            if (n3 != n2) {
                this.bos.writeUBits(nArray2[i] - n2, BitOutputStream.minBits(n3 - n2));
            }
            spihtLinkedList2DArray[i] = new SpihtLinkedList2D();
            spihtLinkedList2DArray[i].cloneListTyped(this.LIS);
            spihtLinkedList2DArray2[i] = new SpihtLinkedList2D();
            spihtLinkedList2DArray2[i].cloneList(this.LIC);
            spihtLinkedList2DArray3[i] = new SpihtLinkedList2D();
        }
        this.LIS = null;
        this.LIC = null;
        while (n3 != n2) {
            this.z = 0;
            while (this.z < this.zSize) {
                if (nArray2[this.z] > n2) {
                    this.LIS = spihtLinkedList2DArray[this.z];
                    this.LIC = spihtLinkedList2DArray2[this.z];
                    this.LSC = spihtLinkedList2DArray3[this.z];
                    this.maxThreshold = nArray[this.z];
                    n4 = this.LSC.size();
                    this.sort(this.maxThreshold);
                    if (n4 != 0) {
                        this.refinement(this.maxThreshold, n4);
                    }
                    nArray[this.z] = this.maxThreshold >> 1;
                    int n5 = this.z;
                    nArray2[n5] = nArray2[n5] - 1;
                    spihtLinkedList2DArray[this.z] = this.LIS;
                    spihtLinkedList2DArray2[this.z] = this.LIC;
                    spihtLinkedList2DArray3[this.z] = this.LSC;
                    this.LIS = null;
                    this.LSC = null;
                    this.LIC = null;
                }
                ++this.z;
            }
            --n3;
        }
        nArray2 = null;
        this.maxThreshold = 1;
        while (this.maxThreshold != 0) {
            this.z = 0;
            while (this.z < this.zSize) {
                this.LIS = spihtLinkedList2DArray[this.z];
                this.LIC = spihtLinkedList2DArray2[this.z];
                this.LSC = spihtLinkedList2DArray3[this.z];
                this.maxThreshold = nArray[this.z];
                n4 = this.LSC.size();
                this.sort(this.maxThreshold);
                if (n4 != 0) {
                    this.refinement(this.maxThreshold, n4);
                }
                this.maxThreshold >>= 1;
                nArray[this.z] = this.maxThreshold;
                spihtLinkedList2DArray[this.z] = this.LIS;
                spihtLinkedList2DArray2[this.z] = this.LIC;
                spihtLinkedList2DArray3[this.z] = this.LSC;
                this.LIS = null;
                this.LSC = null;
                this.LIC = null;
                ++this.z;
            }
        }
        this.bos.close();
    }

    protected void sort(int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        this.LIC.initialNode();
        int n6 = this.LIC.size();
        for (int i = 0; i < n6; ++i) {
            n4 = this.getSample(this.LIC.getX(), this.LIC.getY(), this.z);
            ++n5;
            if (Math.abs(n4) >= n) {
                this.bos.writeMulti(1);
                ++n5;
                n3 = this.LIC.getX();
                n2 = this.LIC.getY();
                this.LIC.moveElementAtLast(this.LSC);
                if (n4 < 0) {
                    this.bos.writeMulti(0);
                    if (!this.rate) continue;
                    this.imageRecovered[n2][n3] = -(n + (n >> 1));
                    continue;
                }
                this.bos.writeMulti(1);
                if (!this.rate) continue;
                this.imageRecovered[n2][n3] = n + (n >> 1);
                continue;
            }
            this.LIC.nextValue();
            this.bos.writeMulti(0);
        }
        this.LIS.initialNode();
        boolean bl = this.LIS.isEmpty();
        while (!bl && this.LIS.size() != 0) {
            int n7;
            bl = this.LIS.isLast();
            if (!this.LIS.getType()) {
                if (this.significativeDescendent(this.LIS.getX(), this.LIS.getY(), true)) {
                    this.bos.writeMulti(1);
                    ++n5;
                    int[] nArray = new int[2];
                    n3 = this.LIS.getX();
                    n2 = this.LIS.getY();
                    for (n7 = 1; n7 <= 4; ++n7) {
                        nArray = this.children(n3, n2, n7);
                        n4 = this.getSample(nArray[0], nArray[1], this.z);
                        if (Math.abs(n4) >= n) {
                            this.bos.writeMulti(1);
                            ++n5;
                            this.LSC.addElement(nArray[0], nArray[1]);
                            if (n4 < 0) {
                                this.bos.writeMulti(0);
                                if (this.rate) {
                                    this.imageRecovered[nArray[1]][nArray[0]] = -(n + (n >> 1));
                                }
                            } else {
                                this.bos.writeMulti(1);
                                if (this.rate) {
                                    this.imageRecovered[nArray[1]][nArray[0]] = n + (n >> 1);
                                }
                            }
                            ++n5;
                            continue;
                        }
                        this.LIC.addElement(nArray[0], nArray[1]);
                        this.bos.writeMulti(0);
                        ++n5;
                    }
                    if (this.isGrandParent(this.LIS.getX(), this.LIS.getY())) {
                        if (this.method == 1) {
                            this.LIS.setType(true);
                            this.LIS.moveElementAtLast(this.LIS);
                            bl = false;
                            continue;
                        }
                        if (this.method != 0) continue;
                        this.LIS.setType(true);
                        bl = false;
                        continue;
                    }
                    this.LIS.remove();
                    continue;
                }
                this.bos.writeMulti(0);
                ++n5;
                this.LIS.nextValue();
                continue;
            }
            if (this.significativeDescendent(this.LIS.getX(), this.LIS.getY(), false)) {
                this.bos.writeMulti(1);
                ++n5;
                int[] nArray = new int[2];
                n3 = this.LIS.getX();
                n2 = this.LIS.getY();
                for (n7 = 1; n7 <= 4; ++n7) {
                    nArray = this.children(n3, n2, n7);
                    this.LIS.addElement(nArray[0], nArray[1], false);
                    bl = false;
                }
                this.LIS.remove();
                continue;
            }
            this.bos.writeMulti(0);
            ++n5;
            this.LIS.nextValue();
        }
        this.size += n5;
    }

    protected void refinement(int n, int n2) throws IOException {
        int n3 = 0;
        this.LSC.initialNode();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            int n4;
            int n5;
            int n6 = Math.abs(this.getSample(this.LSC.getX(), this.LSC.getY(), this.z));
            if ((n & n6) != 0) {
                n5 = 1;
                if (this.rate) {
                    n4 = this.imageRecovered[this.LSC.getY()][this.LSC.getX()];
                    bl = false;
                    if (n4 < 0) {
                        bl = true;
                        n4 = -n4;
                    }
                    n4 += n >> 1;
                    if (bl) {
                        n4 = -n4;
                    }
                    this.imageRecovered[this.LSC.getY()][this.LSC.getX()] = n4;
                }
            } else {
                n5 = 0;
                if (this.rate) {
                    n4 = this.imageRecovered[this.LSC.getY()][this.LSC.getX()];
                    bl = false;
                    if (n4 < 0) {
                        bl = true;
                        n4 = -n4;
                    }
                    n4 = n == 1 ? --n4 : (n4 -= n >> 1);
                    if (bl) {
                        n4 = -n4;
                    }
                    this.imageRecovered[this.LSC.getY()][this.LSC.getX()] = n4;
                }
            }
            ++n3;
            this.bos.writeMulti(n5);
            this.LSC.nextValue();
        }
        this.size += n3;
    }

    protected boolean significativeDescendent(int n, int n2, boolean bl) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        int[] nArray4 = new int[2];
        if (this.isParent(n, n2)) {
            nArray = this.children(n, n2, 1);
            nArray2 = this.children(n, n2, 2);
            nArray3 = this.children(n, n2, 3);
            nArray4 = this.children(n, n2, 4);
            if (bl) {
                if (Math.abs(this.getSample(nArray[0], nArray[1], this.z)) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray2[0], nArray2[1], this.z)) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray3[0], nArray3[1], this.z)) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray4[0], nArray4[1], this.z)) >= this.maxThreshold) {
                    return true;
                }
            }
            if (this.significativeDescendent(nArray[0], nArray[1], true)) {
                return true;
            }
            if (this.significativeDescendent(nArray2[0], nArray2[1], true)) {
                return true;
            }
            if (this.significativeDescendent(nArray3[0], nArray3[1], true)) {
                return true;
            }
            if (this.significativeDescendent(nArray4[0], nArray4[1], true)) {
                return true;
            }
        }
        return false;
    }

    protected int initialTh() {
        int n = Math.abs(this.image[this.z][0][0]);
        int n2 = 0;
        for (int i = 0; i < this.ySize; ++i) {
            for (int j = 0; j < this.xSize; ++j) {
                n2 = Math.abs(this.image[this.z][i][j]);
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return (int)Math.pow(2.0, (int)(Math.log(n) / Math.log(2.0)));
    }

    protected void listInitialize() {
        for (int i = 0; i < this.limitResidualBandX; ++i) {
            for (int j = 0; j < this.limitResidualBandY; ++j) {
                this.LIC.addElement(i, j);
                if (!this.isParent(i, j)) continue;
                this.LIS.addElement(i, j, false);
            }
        }
    }

    public long computeSquareError(int[][] nArray, int[][] nArray2) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                long l2 = nArray[i][j] - nArray2[i][j];
                l += l2 * l2;
            }
        }
        return l;
    }

    @Override
    public long[][] getTable() {
        return this.table;
    }

    @Override
    public long[][] getAccessPoints() {
        return this.accessPoints;
    }
}

