/*
 * Decompiled with CFR 0.152.
 */
package Spiht.SpihtCoding;

import GiciBitStream.BitOutputStream;
import List.SpihtLinkedList;
import Spiht.Spiht;
import java.io.FileOutputStream;
import java.io.IOException;

public class SpihtCoding3D
extends Spiht {
    protected BitOutputStream bos = null;

    public SpihtCoding3D() {
    }

    public SpihtCoding3D(int[][][] nArray, int n, String string, boolean bl, long l) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.bos = new BitOutputStream(fileOutputStream);
        this.method = 0;
        this.zSize = nArray.length;
        this.ySize = nArray[0].length;
        this.xSize = nArray[0][0].length;
        this.levels = n;
        this.bos.writeUBits(this.xSize, 16);
        this.bos.writeUBits(this.ySize, 16);
        this.bos.writeUBits(this.zSize, 16);
        this.bos.writeUBits(n, 4);
        this.bos.writeUBits(this.method, 1);
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, n);
        this.limitResidualBandY = this.ySize / (int)Math.pow(2.0, n);
        this.limitResidualBandZ = this.zSize / (int)Math.pow(2.0, n);
        this.limitParentX = this.xSize / 2;
        this.limitParentY = this.ySize / 2;
        this.limitParentZ = this.zSize / 2;
        this.limitGrandParentX = this.xSize / 4;
        this.limitGrandParentY = this.ySize / 4;
        this.limitGrandParentZ = this.zSize / 4;
        this.image = nArray;
    }

    @Override
    public void openOutputBitstream(String string, long l) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.bos = new BitOutputStream(fileOutputStream, l);
    }

    @Override
    public void writeInitialHeader() throws IOException {
        if (this.bos == null) {
            throw new IOException("The output bitstream is closed. Initial header is not written.");
        }
        this.bos.writeUBits(this.xSize, 16);
        this.bos.writeUBits(this.ySize, 16);
        this.bos.writeUBits(this.zSize, 16);
        this.bos.writeUBits(this.levels, 4);
        this.bos.writeUBits(this.method, 1);
    }

    @Override
    public void calculateSubbandLimits() throws Exception {
        if (this.xSize == 0 || this.ySize == 0 || this.zSize == 0) {
            throw new Exception("The sizes of the image is not correct");
        }
        if (this.levels == 0) {
            throw new Exception("The number of levels of the image is not correct");
        }
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels);
        this.limitResidualBandY = this.ySize / (int)Math.pow(2.0, this.levels);
        this.limitResidualBandZ = this.zSize / (int)Math.pow(2.0, this.levels);
        this.limitParentX = this.xSize / 2;
        this.limitParentY = this.ySize / 2;
        this.limitParentZ = this.zSize / 2;
        this.limitGrandParentX = this.xSize / 4;
        this.limitGrandParentY = this.ySize / 4;
        this.limitGrandParentZ = this.zSize / 4;
    }

    @Override
    public void codeRated(int n) throws IOException {
        int n2 = 0;
        this.LIC = new SpihtLinkedList();
        this.LSC = new SpihtLinkedList();
        this.LIS = new SpihtLinkedList();
        this.listInitialize();
        this.maxThreshold = this.initialTh(this.image);
        this.bos.writeUBits((int)(Math.log(this.maxThreshold) / Math.log(2.0)), 4);
        while (this.maxThreshold > n) {
            n2 = this.LSC.size();
            try {
                this.sort(this.maxThreshold);
                if (n2 != 0) {
                    this.refinement(this.maxThreshold, n2);
                }
                this.maxThreshold >>= 1;
            }
            catch (IOException iOException) {
                this.bos.close();
                System.out.println(iOException.getMessage());
                System.exit(1);
            }
        }
        this.bos.close();
    }

    protected void sort(int n) throws IOException {
        int n2;
        int n3 = 0;
        System.out.println("Sorting Stage: " + n);
        this.LIC.initialNode();
        int n4 = this.LIC.size();
        for (int i = 0; i < n4; ++i) {
            n2 = this.getSample(this.LIC.getX(), this.LIC.getY(), this.LIC.getZ());
            ++n3;
            if (Math.abs(n2) >= n) {
                this.bos.writeMulti(1);
                ++n3;
                this.LIC.moveElementAtLast(this.LSC);
                if (n2 < 0) {
                    this.bos.writeMulti(0);
                    continue;
                }
                this.bos.writeMulti(1);
                continue;
            }
            this.LIC.nextValue();
            this.bos.writeMulti(0);
        }
        this.LIS.initialNode();
        boolean bl = this.LIS.isEmpty();
        while (!bl && this.LIS.size() != 0) {
            int n5;
            int n6;
            int n7;
            int n8;
            bl = this.LIS.isLast();
            if (!this.LIS.getType()) {
                if (this.significativeDescendentXYZ(this.LIS.getX(), this.LIS.getY(), this.LIS.getZ(), true)) {
                    this.bos.writeMulti(1);
                    ++n3;
                    int[] nArray = new int[3];
                    n8 = this.LIS.getX();
                    n7 = this.LIS.getY();
                    n6 = this.LIS.getZ();
                    for (n5 = 1; n5 <= 8; ++n5) {
                        nArray = this.children(n8, n7, n6, n5);
                        n2 = this.getSample(nArray[0], nArray[1], nArray[2]);
                        if (Math.abs(n2) >= n) {
                            this.bos.writeMulti(1);
                            ++n3;
                            this.LSC.addElement(nArray[0], nArray[1], nArray[2]);
                            if (n2 < 0) {
                                this.bos.writeMulti(0);
                            } else {
                                this.bos.writeMulti(1);
                            }
                            ++n3;
                            continue;
                        }
                        this.LIC.addElement(nArray[0], nArray[1], nArray[2]);
                        this.bos.writeMulti(0);
                        ++n3;
                    }
                    if (this.isGrandParent(this.LIS.getX(), this.LIS.getY(), this.LIS.getZ())) {
                        if (this.method == 1) {
                            this.LIS.setType(true);
                            this.LIS.moveElementAtLast(this.LIS);
                            bl = false;
                            continue;
                        }
                        if (this.method != 0) continue;
                        if (this.significativeDescendentXYZ(this.LIS.getX(), this.LIS.getY(), this.LIS.getZ(), false)) {
                            this.bos.writeMulti(1);
                            ++n3;
                            n8 = this.LIS.getX();
                            n7 = this.LIS.getY();
                            n6 = this.LIS.getZ();
                            for (n5 = 1; n5 <= 8; ++n5) {
                                nArray = this.children(n8, n7, n6, n5);
                                this.LIS.addElement(nArray[0], nArray[1], nArray[2], false);
                                bl = false;
                            }
                            this.LIS.remove();
                            continue;
                        }
                        this.bos.writeMulti(0);
                        ++n3;
                        this.LIS.setType(true);
                        this.LIS.moveElementAtLast(this.LIS);
                        bl = false;
                        continue;
                    }
                    this.LIS.remove();
                    continue;
                }
                this.bos.writeMulti(0);
                ++n3;
                this.LIS.nextValue();
                continue;
            }
            if (this.significativeDescendentXYZ(this.LIS.getX(), this.LIS.getY(), this.LIS.getZ(), false)) {
                this.bos.writeMulti(1);
                ++n3;
                int[] nArray = new int[3];
                n8 = this.LIS.getX();
                n7 = this.LIS.getY();
                n6 = this.LIS.getZ();
                for (n5 = 1; n5 <= 8; ++n5) {
                    nArray = this.children(n8, n7, n6, n5);
                    this.LIS.addElement(nArray[0], nArray[1], nArray[2], false);
                    bl = false;
                }
                this.LIS.remove();
                continue;
            }
            this.bos.writeMulti(0);
            ++n3;
            this.LIS.nextValue();
        }
        System.out.println("Simbolos escritos: " + n3);
    }

    protected void refinement(int n, int n2) throws IOException {
        int n3 = 0;
        this.LSC.initialNode();
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (i == 0) {
                System.out.println("Refinement Stage: " + n);
            }
            int n5 = (n & (n4 = Math.abs(this.getSample(this.LSC.getX(), this.LSC.getY(), this.LSC.getZ())))) != 0 ? 1 : 0;
            ++n3;
            this.bos.writeMulti(n5);
            this.LSC.nextValue();
        }
        System.out.println("Simbolos escritos de refinamiento: " + n3);
    }

    protected boolean significativeDescendentXYZ(int n, int n2, int n3, boolean bl) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        int[] nArray4 = new int[3];
        int[] nArray5 = new int[3];
        int[] nArray6 = new int[3];
        int[] nArray7 = new int[3];
        int[] nArray8 = new int[3];
        if (this.isParent(n, n2, n3)) {
            nArray = this.children(n, n2, n3, 1);
            nArray2 = this.children(n, n2, n3, 2);
            nArray3 = this.children(n, n2, n3, 3);
            nArray4 = this.children(n, n2, n3, 4);
            nArray5 = this.children(n, n2, n3, 5);
            nArray6 = this.children(n, n2, n3, 6);
            nArray7 = this.children(n, n2, n3, 7);
            nArray8 = this.children(n, n2, n3, 8);
            if (bl) {
                if (Math.abs(this.getSample(nArray[0], nArray[1], nArray[2])) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray2[0], nArray2[1], nArray2[2])) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray3[0], nArray3[1], nArray3[2])) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray4[0], nArray4[1], nArray4[2])) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray5[0], nArray5[1], nArray5[2])) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray6[0], nArray6[1], nArray6[2])) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray7[0], nArray7[1], nArray7[2])) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(nArray8[0], nArray8[1], nArray8[2])) >= this.maxThreshold) {
                    return true;
                }
            }
            if (this.significativeDescendentXYZ(nArray[0], nArray[1], nArray[2], true)) {
                return true;
            }
            if (this.significativeDescendentXYZ(nArray2[0], nArray2[1], nArray2[2], true)) {
                return true;
            }
            if (this.significativeDescendentXYZ(nArray3[0], nArray3[1], nArray3[2], true)) {
                return true;
            }
            if (this.significativeDescendentXYZ(nArray4[0], nArray4[1], nArray4[2], true)) {
                return true;
            }
            if (this.significativeDescendentXYZ(nArray5[0], nArray5[1], nArray5[2], true)) {
                return true;
            }
            if (this.significativeDescendentXYZ(nArray6[0], nArray6[1], nArray6[2], true)) {
                return true;
            }
            if (this.significativeDescendentXYZ(nArray7[0], nArray7[1], nArray7[2], true)) {
                return true;
            }
            if (this.significativeDescendentXYZ(nArray8[0], nArray8[1], nArray8[2], true)) {
                return true;
            }
        }
        return false;
    }

    protected int initialTh(int[][][] nArray) {
        int n = Math.abs(nArray[0][0][0]);
        int n2 = 0;
        for (int i = 0; i < this.zSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                for (int k = 0; k < this.xSize; ++k) {
                    n2 = Math.abs(nArray[i][j][k]);
                    if (n2 <= n) continue;
                    n = n2;
                }
            }
        }
        return (int)Math.pow(2.0, (int)(Math.log(n) / Math.log(2.0)));
    }

    protected void listInitialize() {
        for (int i = 0; i < this.limitResidualBandX; ++i) {
            for (int j = 0; j < this.limitResidualBandY; ++j) {
                for (int k = 0; k < this.limitResidualBandZ; ++k) {
                    this.LIC.addElement(i, 0, 0);
                    if (!this.isParent(i, j, k)) continue;
                    this.LIS.addElement(i, j, k, false);
                }
            }
        }
    }
}

