/*
 * Decompiled with CFR 0.152.
 */
package Spiht.SpihtDecoding;

public class ArgsParser {
    String[][] argsSpecification = new String[][]{{"-h", "--help", "", "", "0", "Displays this help and exits program."}, {"-c", "--compareImage", "{string}", "", "0", "Input image. Valid formats are: pgm, ppm, pbm, jpg, tiff, png, bmp, gif, fpx. If image is raw data file extension must be \".raw\" and \"-g\" parameter is mandatory."}, {"-g", "--imageGeometry", "{int int int int boolean}", "", "0", "Geometry of raw image data. Parameters are:\n    1 - zSize (number of image components)\n    2 - ySize (image height)\n    3 - xSize (image width)\n    4 - data type. Possible values are:\n      0- boolean (1 byte)\n      1- byte (1 byte)\n      2- char (2 bytes)\n      3- short (2 bytes)\n      4- int (4 bytes)\n      5- long (8 bytes)\n      6- float (4 bytes)\n      7- double (8 bytes)\n    5- 0 Big-Endian\n 1 Little-Endian\n    6 - 1 if 3 first components are RGB, 0 otherwise"}, {"-o", "--outFile", "{string}", "same as input with new extensions", "0", "Output image file name."}, {"-w", "--waveletTransformType", "{int[ int[ int[ ...]]]}", "", "1", "Discrete wavelet transform type for each image component. First value is for the first component, second value for the second component and so on. If only one value is specified, wavelete transform type will be the same for all components. Valid values are:\n    0 - No wavelet transform\n    1 - Reversible 5/3 DWT\n    2 - Irreversible 9/7 DWT"}, {"-wl", "--waveletTransformLevels", "{int[ int[ int[ ...]]]}", "", "1", "Discrete wavelet transform levels for each image component. First value is for the first component, second value for the second component and so on. If only one value is specified, wavelete transform levels will be the same for all components."}, {"-dim", "--dimension", "{int}", "", "1", "Number of dimensions for the SPIHT algorithm. "}, {"-r", "--rateDistortion", "{string}", "", "0", "Rate Distortion algorithm. Valid names are: rd1tp, rd2tp, rdch."}, {"-t", "--target", "{long}", "0", "0", "The rate target for the output SPIHT bitstream file. If the value is 0 the argument is omited."}, {"-b", "--building", "", "false", "0", "Flag for the building rate strategy."}, {"-inter", "--interleaved", "", "false", "0", "Flag for the interleaved rate strategy."}, {"-f", "--file", "{string}", "./workDir/default.coded", "0", "The input/output file to read/write the SPIHT algorithm bitstream."}};
    String imageFile;
    String outFile;
    String rateDistortion;
    String fileName = "./workDir/default.coded";
    int dimension = 0;
    long target = 0L;
    boolean finalDistortion = false;
    boolean building = false;
    boolean interleaved = false;
    int[] imageGeometry = null;
    int[] WTTypes = null;
    int[] WTLevels = null;

    public ArgsParser(String[] stringArray) throws Exception {
        int n;
        int n2 = 0;
        boolean[] blArray = new boolean[this.argsSpecification.length];
        for (n = 0; n < this.argsSpecification.length; ++n) {
            blArray[n] = false;
        }
        block15: while (n2 < stringArray.length) {
            n = this.argFind(stringArray[n2]);
            if (n != -1) {
                if (!blArray[n]) {
                    int n3;
                    blArray[n] = true;
                    for (n3 = n2 + 1; n3 < stringArray.length && this.argFind(stringArray[n3]) == -1; ++n3) {
                    }
                    int n4 = n3 - n2;
                    String[] stringArray2 = new String[n4];
                    System.arraycopy(stringArray, n2, stringArray2, 0, n4);
                    n2 = n3;
                    switch (n) {
                        case 0: {
                            this.showArgsInfo();
                            System.exit(1);
                            break;
                        }
                        case 1: {
                            this.imageFile = this.parseString(stringArray2);
                            if (!this.imageFile.endsWith(".raw")) continue block15;
                            this.argsSpecification[2][4] = "1";
                            break;
                        }
                        case 2: {
                            this.imageGeometry = this.parseIntegerArray(stringArray2, 6);
                            break;
                        }
                        case 3: {
                            this.outFile = this.parseString(stringArray2);
                            break;
                        }
                        case 4: {
                            this.WTTypes = this.parseIntegerArray(stringArray2);
                            break;
                        }
                        case 5: {
                            this.WTLevels = this.parseIntegerArray(stringArray2);
                            break;
                        }
                        case 6: {
                            this.dimension = this.parseIntegerPositive(stringArray2);
                            break;
                        }
                        case 7: {
                            this.rateDistortion = this.parseString(stringArray2);
                            break;
                        }
                        case 8: {
                            this.target = this.parseIntegerPositive(stringArray2);
                            break;
                        }
                        case 9: {
                            this.building = true;
                            break;
                        }
                        case 10: {
                            this.interleaved = true;
                            break;
                        }
                        case 11: {
                            this.fileName = this.parseString(stringArray2);
                            break;
                        }
                        default: {
                            throw new Exception("OPTION NOT AVAIBLE");
                        }
                    }
                    continue;
                }
                throw new Exception("Argument \"" + stringArray[n2] + "\" repeated.");
            }
            throw new Exception("Argument \"" + stringArray[n2] + "\" unrecognized.");
        }
        for (n = 0; n < this.argsSpecification.length; ++n) {
            if (this.argsSpecification[n][4].compareTo("1") != 0 || blArray[n]) continue;
            throw new Exception("Argument \"" + this.argsSpecification[n][0] + "\" is mandatory (\"-h\" displays help).");
        }
    }

    int argFind(String string) {
        int n = 0;
        boolean bl = false;
        while (n < this.argsSpecification.length && !bl) {
            if (string.compareTo(this.argsSpecification[n][0]) == 0 || string.compareTo(this.argsSpecification[n][1]) == 0) {
                bl = true;
                continue;
            }
            ++n;
        }
        return bl ? n : -1;
    }

    public void showArgsInfo() {
        System.out.println("Arguments specification: ");
        for (int i = 0; i < this.argsSpecification.length; ++i) {
            char c = '{';
            char c2 = '}';
            if (this.argsSpecification[i][4].compareTo("0") == 0) {
                c = '[';
                c2 = ']';
            }
            System.out.print("\n" + c + " ");
            System.out.print("{" + this.argsSpecification[i][0] + "|" + this.argsSpecification[i][1] + "} " + this.argsSpecification[i][2]);
            System.out.println(" " + c2);
            System.out.println("  Explanation:\n    " + this.argsSpecification[i][5]);
            System.out.println("  Default value: " + this.argsSpecification[i][3]);
        }
    }

    int parseIntegerPositive(String[] stringArray) throws Exception {
        int n;
        block4: {
            n = 0;
            if (stringArray.length == 2) {
                try {
                    n = Integer.parseInt(stringArray[1]);
                    if (n < 0) {
                        throw new Exception("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is must be a positive integer.");
                    }
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
                }
            }
            throw new Exception("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        return n;
    }

    float parseFloatPositive(String[] stringArray) throws Exception {
        float f;
        block4: {
            f = 0.0f;
            if (stringArray.length == 2) {
                try {
                    f = Float.parseFloat(stringArray[1]);
                    if (f < 0.0f) {
                        throw new Exception("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is must be a positive float.");
                    }
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("\"" + stringArray[1] + "\" of argument \"" + stringArray[0] + "\" is not a parsable float.");
                }
            }
            throw new Exception("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        return f;
    }

    String parseString(String[] stringArray) throws Exception {
        String string = "";
        if (stringArray.length != 2) {
            throw new Exception("Argument \"" + stringArray[0] + "\" takes one option. Try \"-h\" to display help.");
        }
        string = stringArray[1];
        return string;
    }

    int[] parseIntegerArray(String[] stringArray) throws Exception {
        int[] nArray = null;
        if (stringArray.length >= 2) {
            nArray = new int[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    nArray[i - 1] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
                }
            }
        } else {
            throw new Exception("Argument \"" + stringArray[0] + "\" takes one or more options. Try \"-h\" to display help.");
        }
        return nArray;
    }

    int[] parseIntegerArray(String[] stringArray, int n) throws Exception {
        int[] nArray = null;
        if (stringArray.length == n + 1) {
            nArray = new int[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    nArray[i - 1] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable integer.");
                }
            }
        } else {
            throw new Exception("Argument \"" + stringArray[0] + "\" takes " + n + " options. Try \"-h\" to display help.");
        }
        return nArray;
    }

    float[] parseFloatArray(String[] stringArray) throws Exception {
        float[] fArray = null;
        if (stringArray.length >= 2) {
            fArray = new float[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    fArray[i - 1] = Float.parseFloat(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable float.");
                }
            }
        } else {
            throw new Exception("Argument \"" + stringArray[0] + "\" takes one or more options. Try \"-h\" to display help.");
        }
        return fArray;
    }

    float[] parseFloatArray(String[] stringArray, int n) throws Exception {
        float[] fArray = null;
        if (stringArray.length == n + 1) {
            fArray = new float[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    fArray[i - 1] = Float.parseFloat(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("\"" + stringArray[i] + "\" of argument \"" + stringArray[0] + "\" is not a parsable float.");
                }
            }
        } else {
            throw new Exception("Argument \"" + stringArray[0] + "\" takes " + n + " options. Try \"-h\" to display help.");
        }
        return fArray;
    }

    public String getCompareImage() {
        return this.imageFile;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public int[] getImageGeometry() {
        return this.imageGeometry;
    }

    public int[] getWTTypes() {
        return this.WTTypes;
    }

    public int[] getWTLevels() {
        return this.WTLevels;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getRateDistortion() {
        return this.rateDistortion;
    }

    public boolean getFinalDistortion() {
        return this.finalDistortion;
    }

    public long getTarget() {
        return this.target;
    }

    public boolean getBuilding() {
        return this.building;
    }

    public boolean getInterleaved() {
        return this.interleaved;
    }

    public String getFileName() {
        return this.fileName;
    }
}

