/*
 * Decompiled with CFR 0.152.
 */
package Spiht.SpihtDecoding;

import Building.PlaneBuilding;
import GiciBitStream.BitInputStream;
import GiciBitStream.BitOutputStream;
import List.SpihtLinkedList2D;
import Spiht.Spiht;
import java.io.FileInputStream;
import java.io.IOException;

public class SpihtDecoding2D
extends Spiht {
    protected SpihtLinkedList2D LIC = null;
    protected SpihtLinkedList2D LSC = null;
    protected SpihtLinkedList2D LIS = null;
    protected int z;
    protected BitInputStream bis;
    protected String[] ratedList = new String[]{"rd1tp", "rd2tp", "rdch"};
    protected int positionInLSC;

    public SpihtDecoding2D(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.bis = new BitInputStream(fileInputStream);
        this.xSize = (int)this.bis.readUBits(16);
        this.ySize = (int)this.bis.readUBits(16);
        this.zSize = (int)this.bis.readUBits(16);
        this.levels = (int)this.bis.readUBits(4);
        this.method = (int)this.bis.readUBits(1);
        this.z = 0;
        this.size = 0;
        this.positionInLSC = 0;
        this.image = new int[this.zSize][this.ySize][this.xSize];
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels);
        this.limitResidualBandY = this.ySize / (int)Math.pow(2.0, this.levels);
        this.limitParentX = this.xSize / 2;
        this.limitParentY = this.ySize / 2;
        this.limitGrandParentX = this.xSize / 4;
        this.limitGrandParentY = this.ySize / 4;
    }

    @Override
    public void decode() throws IOException {
        int n = 0;
        int n2 = 0;
        this.z = 0;
        while (this.z < this.zSize) {
            this.readThreshold();
            this.LIC = new SpihtLinkedList2D();
            this.LSC = new SpihtLinkedList2D();
            this.LIS = new SpihtLinkedList2D();
            n2 = 0;
            this.listInitialize();
            try {
                while (this.maxThreshold > n) {
                    n2 = this.LSC.size();
                    this.sort(this.maxThreshold);
                    this.refinement(this.maxThreshold, n2);
                    this.maxThreshold >>= 1;
                }
            }
            catch (IOException iOException) {
                this.bis.close();
            }
            ++this.z;
        }
        this.bis.close();
    }

    @Override
    public void decodeRated(String string) throws Exception {
        int n;
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        for (n = 0; n < this.ratedList.length; ++n) {
            if (!this.ratedList[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new Exception("The rate mode " + string + " is not avaible.");
        }
        int n4 = (int)Math.ceil(Math.log(this.zSize) / Math.log(2.0));
        SpihtLinkedList2D[] spihtLinkedList2DArray = new SpihtLinkedList2D[this.zSize];
        SpihtLinkedList2D[] spihtLinkedList2DArray2 = new SpihtLinkedList2D[this.zSize];
        SpihtLinkedList2D[] spihtLinkedList2DArray3 = new SpihtLinkedList2D[this.zSize];
        this.LIC = new SpihtLinkedList2D();
        this.LSC = new SpihtLinkedList2D();
        this.LIS = new SpihtLinkedList2D();
        int[] nArray = new int[this.zSize];
        this.listInitialize();
        for (n = 0; n < this.zSize; ++n) {
            spihtLinkedList2DArray[n] = new SpihtLinkedList2D();
            spihtLinkedList2DArray[n].cloneListTyped(this.LIS);
            spihtLinkedList2DArray2[n] = new SpihtLinkedList2D();
            spihtLinkedList2DArray2[n].cloneList(this.LIC);
            spihtLinkedList2DArray3[n] = new SpihtLinkedList2D();
            spihtLinkedList2DArray3[n].cloneList(this.LSC);
        }
        int[] nArray2 = new int[this.zSize];
        boolean[] blArray = new boolean[this.zSize];
        int[] nArray3 = new int[this.zSize];
        for (n = 0; n < this.zSize; ++n) {
            nArray2[n] = 0;
            blArray[n] = true;
            nArray3[n] = 0;
        }
        this.positionInLSC = 0;
        try {
            while (true) {
                this.z = (int)this.bis.readUBits(n4);
                if (n2 == 2) {
                    n3 = 1;
                    while ((int)this.bis.readUBits(1) != 1) {
                        ++n3;
                    }
                }
                this.LIS = spihtLinkedList2DArray[this.z];
                this.LIC = spihtLinkedList2DArray2[this.z];
                this.LSC = spihtLinkedList2DArray3[this.z];
                this.positionInLSC = nArray2[this.z];
                if (blArray[this.z]) {
                    this.readThreshold();
                    blArray[this.z] = false;
                } else {
                    this.maxThreshold = nArray3[this.z];
                }
                if (n2 == 0) {
                    this.positionInLSC = this.LSC.size();
                    this.sort(this.maxThreshold);
                    if (this.positionInLSC != 0) {
                        this.refinement(this.maxThreshold, this.positionInLSC);
                    }
                    int n5 = this.z;
                    nArray[n5] = nArray[n5] + 1;
                    this.maxThreshold >>= 1;
                } else if (n2 == 1) {
                    if (nArray[this.z] == 0 || nArray[this.z] % 2 != 0) {
                        this.positionInLSC = this.LSC.size();
                        this.sort(this.maxThreshold);
                        if (nArray[this.z] == 0) {
                            this.maxThreshold >>= 1;
                        }
                    } else {
                        if (this.positionInLSC != 0) {
                            this.refinement(this.maxThreshold, this.positionInLSC);
                        }
                        this.maxThreshold >>= 1;
                    }
                    int n6 = this.z;
                    nArray[n6] = nArray[n6] + 1;
                } else if (n2 == 2) {
                    for (n = 0; n < n3; ++n) {
                        if (nArray[this.z] == 0 || nArray[this.z] % 2 != 0) {
                            this.positionInLSC = this.LSC.size();
                            this.sort(this.maxThreshold);
                            if (nArray[this.z] == 0) {
                                this.maxThreshold >>= 1;
                            }
                        } else {
                            if (this.positionInLSC != 0) {
                                this.refinement(this.maxThreshold, this.positionInLSC);
                            }
                            this.maxThreshold >>= 1;
                        }
                        int n7 = this.z;
                        nArray[n7] = nArray[n7] + 1;
                    }
                }
                nArray3[this.z] = this.maxThreshold;
                spihtLinkedList2DArray[this.z] = this.LIS;
                spihtLinkedList2DArray2[this.z] = this.LIC;
                spihtLinkedList2DArray3[this.z] = this.LSC;
                this.LIS = null;
                this.LIC = null;
                this.LSC = null;
                nArray2[this.z] = this.positionInLSC;
            }
        }
        catch (IOException iOException) {
            this.bis.close();
            return;
        }
    }

    @Override
    public void decodeBuilding() throws IOException {
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels) * this.zSize;
        this.limitParentX = this.xSize / 2 * this.zSize;
        this.limitGrandParentX = this.xSize / 4 * this.zSize;
        int n = this.xSize;
        int n2 = this.zSize;
        this.xSize *= this.zSize;
        this.zSize = 1;
        this.image = new int[this.zSize][this.ySize][this.xSize];
        this.decode();
        PlaneBuilding planeBuilding = new PlaneBuilding(this.levels);
        this.image = planeBuilding.obtainOriginalImage(this.image, n, this.ySize, n2);
        planeBuilding = null;
    }

    @Override
    public void decodeInterleaved() throws IOException {
        this.positionInLSC = 0;
        boolean bl = false;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        nArray = new int[this.zSize];
        nArray2 = new int[this.zSize];
        nArray3 = new int[this.zSize];
        SpihtLinkedList2D[] spihtLinkedList2DArray = new SpihtLinkedList2D[this.zSize];
        SpihtLinkedList2D[] spihtLinkedList2DArray2 = new SpihtLinkedList2D[this.zSize];
        SpihtLinkedList2D[] spihtLinkedList2DArray3 = new SpihtLinkedList2D[this.zSize];
        this.LIC = new SpihtLinkedList2D();
        this.LIS = new SpihtLinkedList2D();
        this.listInitialize();
        try {
            int n = (int)this.bis.readUBits(5);
            int n2 = (int)this.bis.readUBits(5);
            for (int i = 0; i < this.zSize; ++i) {
                nArray2[i] = n != n2 ? n2 + (int)this.bis.readUBits(BitOutputStream.minBits(n - n2)) : n;
                nArray[i] = (int)Math.pow(2.0, nArray2[i]);
                spihtLinkedList2DArray[i] = new SpihtLinkedList2D();
                spihtLinkedList2DArray[i].cloneListTyped(this.LIS);
                spihtLinkedList2DArray2[i] = new SpihtLinkedList2D();
                spihtLinkedList2DArray2[i].cloneList(this.LIC);
                spihtLinkedList2DArray3[i] = new SpihtLinkedList2D();
            }
            this.LIS = null;
            this.LIC = null;
            while (n != n2) {
                this.z = 0;
                while (this.z < this.zSize) {
                    if (nArray2[this.z] > n2) {
                        this.LIS = spihtLinkedList2DArray[this.z];
                        this.LIC = spihtLinkedList2DArray2[this.z];
                        this.LSC = spihtLinkedList2DArray3[this.z];
                        this.maxThreshold = nArray[this.z];
                        this.positionInLSC = nArray3[this.z];
                        this.positionInLSC = this.LSC.size();
                        this.sort(this.maxThreshold);
                        if (this.positionInLSC != 0) {
                            this.refinement(this.maxThreshold, this.positionInLSC);
                        }
                        nArray[this.z] = this.maxThreshold >> 1;
                        nArray3[this.z] = this.positionInLSC;
                        int n3 = this.z;
                        nArray2[n3] = nArray2[n3] - 1;
                        spihtLinkedList2DArray[this.z] = this.LIS;
                        spihtLinkedList2DArray2[this.z] = this.LIC;
                        spihtLinkedList2DArray3[this.z] = this.LSC;
                        this.LIS = null;
                        this.LSC = null;
                        this.LIC = null;
                    }
                    ++this.z;
                }
                --n;
            }
            nArray2 = null;
            this.maxThreshold = 1;
            while (this.maxThreshold != 0) {
                this.z = 0;
                while (this.z < this.zSize) {
                    this.LIS = spihtLinkedList2DArray[this.z];
                    this.LIC = spihtLinkedList2DArray2[this.z];
                    this.LSC = spihtLinkedList2DArray3[this.z];
                    this.maxThreshold = nArray[this.z];
                    this.positionInLSC = nArray3[this.z];
                    this.positionInLSC = this.LSC.size();
                    this.sort(this.maxThreshold);
                    if (this.positionInLSC != 0) {
                        this.refinement(this.maxThreshold, this.positionInLSC);
                    }
                    this.maxThreshold >>= 1;
                    nArray[this.z] = this.maxThreshold;
                    nArray3[this.z] = this.positionInLSC;
                    spihtLinkedList2DArray[this.z] = this.LIS;
                    spihtLinkedList2DArray2[this.z] = this.LIC;
                    spihtLinkedList2DArray3[this.z] = this.LSC;
                    this.LIS = null;
                    this.LSC = null;
                    this.LIC = null;
                    ++this.z;
                }
            }
        }
        catch (IOException iOException) {
            this.bis.close();
        }
        this.bis.close();
    }

    protected void sort(int n) throws IOException {
        int n2;
        int n3 = 0;
        this.LIC.initialNode();
        int n4 = this.LIC.size();
        for (int i = 0; i < n4; ++i) {
            n2 = (int)this.bis.readUBits(1);
            ++n3;
            if (n2 == 1) {
                n2 = (int)this.bis.readUBits(1);
                ++n3;
                if (n2 == 1) {
                    this.setSample(this.LIC.getX(), this.LIC.getY(), this.z, n + n / 2);
                } else {
                    this.setSample(this.LIC.getX(), this.LIC.getY(), this.z, -n - n / 2);
                }
                this.LIC.moveElementAtLast(this.LSC);
                continue;
            }
            this.LIC.nextValue();
        }
        this.LIS.initialNode();
        boolean bl = this.LIS.isEmpty();
        while (!bl) {
            int n5;
            int n6;
            bl = this.LIS.isLast();
            if (!this.LIS.getType()) {
                n2 = (int)this.bis.readUBits(1);
                ++n3;
                if (n2 == 1) {
                    int[] nArray = new int[2];
                    n6 = this.LIS.getX();
                    n5 = this.LIS.getY();
                    for (int i = 1; i <= 4; ++i) {
                        nArray = this.children(n6, n5, i);
                        n2 = (int)this.bis.readUBits(1);
                        ++n3;
                        if (n2 == 1) {
                            this.LSC.addElement(nArray[0], nArray[1]);
                            n2 = (int)this.bis.readUBits(1);
                            ++n3;
                            if (n2 == 1) {
                                this.setSample(nArray[0], nArray[1], this.z, n + n / 2);
                                continue;
                            }
                            this.setSample(nArray[0], nArray[1], this.z, -n - n / 2);
                            continue;
                        }
                        this.LIC.addElement(nArray[0], nArray[1]);
                    }
                    if (this.isGrandParent(this.LIS.getX(), this.LIS.getY())) {
                        if (this.method == 1) {
                            this.LIS.setType(true);
                            this.LIS.moveElementAtLast(this.LIS);
                            bl = false;
                            continue;
                        }
                        if (this.method != 0) continue;
                        this.LIS.setType(true);
                        bl = false;
                        continue;
                    }
                    this.LIS.remove();
                    continue;
                }
                this.LIS.nextValue();
                continue;
            }
            n2 = (int)this.bis.readUBits(1);
            ++n3;
            if (n2 == 1) {
                int[] nArray = new int[2];
                n6 = this.LIS.getX();
                n5 = this.LIS.getY();
                for (int i = 1; i <= 4; ++i) {
                    nArray = this.children(n6, n5, i);
                    this.LIS.addElement(nArray[0], nArray[1], false);
                    bl = false;
                }
                this.LIS.remove();
                continue;
            }
            this.LIS.nextValue();
        }
        n4 += n3;
    }

    protected void refinement(int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        this.LSC.initialNode();
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5 = this.getSample(this.LSC.getX(), this.LSC.getY(), this.z);
            if (n5 < 0) {
                bl = false;
                n5 = Math.abs(n5);
            }
            if ((n4 = (int)this.bis.readUBits(1)) == 1) {
                n5 += n / 2;
                if (!bl) {
                    n5 = -n5;
                }
                this.setSample(this.LSC.getX(), this.LSC.getY(), this.z, n5);
            } else {
                n5 = n == 1 ? --n5 : (n5 -= n / 2);
                if (!bl) {
                    n5 = -n5;
                }
                this.setSample(this.LSC.getX(), this.LSC.getY(), this.z, n5);
            }
            bl = true;
            this.LSC.nextValue();
            ++n3;
        }
        this.size += n3;
    }

    public void readThreshold() throws IOException {
        this.maxThreshold = (int)Math.pow(2.0, (int)this.bis.readUBits(5));
    }

    protected void listInitialize() {
        for (int i = 0; i < this.limitResidualBandX; ++i) {
            for (int j = 0; j < this.limitResidualBandY; ++j) {
                this.LIC.addElement(i, j);
                if (!this.isParent(i, j)) continue;
                this.LIS.addElement(i, j, false);
            }
        }
    }

    public BitInputStream getInputStream() {
        return this.bis;
    }
}

