/*
 * Decompiled with CFR 0.152.
 */
package Spiht.SpihtDecoding;

import GiciBitStream.BitInputStream;
import List.SpihtLinkedList;
import Spiht.Spiht;
import java.io.FileInputStream;
import java.io.IOException;

public class SpihtDecoding3D
extends Spiht {
    protected BitInputStream bis;

    public SpihtDecoding3D() {
    }

    public SpihtDecoding3D(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.bis = new BitInputStream(fileInputStream);
        this.xSize = (int)this.bis.readUBits(16);
        this.ySize = (int)this.bis.readUBits(16);
        this.zSize = (int)this.bis.readUBits(16);
        this.levels = (int)this.bis.readUBits(4);
        this.method = (int)this.bis.readUBits(1);
        this.image = new int[this.zSize][this.ySize][this.xSize];
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels);
        this.limitResidualBandY = this.ySize / (int)Math.pow(2.0, this.levels);
        this.limitResidualBandZ = this.zSize / (int)Math.pow(2.0, this.levels);
        this.limitParentX = this.xSize / 2;
        this.limitParentY = this.ySize / 2;
        this.limitParentZ = this.zSize / 2;
        this.limitGrandParentX = this.xSize / 4;
        this.limitGrandParentY = this.ySize / 4;
        this.limitGrandParentZ = this.zSize / 4;
    }

    @Override
    public void decode() throws IOException {
        int n = 0;
        int n2 = 0;
        this.maxThreshold = (int)Math.pow(2.0, (int)this.bis.readUBits(4));
        int n3 = this.maxThreshold >> 1;
        this.LIC = new SpihtLinkedList();
        this.LSC = new SpihtLinkedList();
        this.LIS = new SpihtLinkedList();
        this.listInitialize();
        while (this.maxThreshold > n2) {
            n = this.LSC.size();
            try {
                this.sort(this.maxThreshold);
                if (n != 0) {
                    this.refinement(this.maxThreshold, n);
                }
                this.maxThreshold >>= 1;
            }
            catch (IOException iOException) {
                this.bis.close();
            }
        }
    }

    protected void sort(int n) throws IOException {
        int n2;
        int n3 = 0;
        this.LIC.initialNode();
        int n4 = this.LIC.size();
        for (int i = 0; i < n4; ++i) {
            n2 = this.bis.readMulti();
            ++n3;
            if (n2 == 1) {
                n2 = this.bis.readMulti();
                ++n3;
                if (n2 == 1) {
                    this.setSample(this.LIC.getX(), this.LIC.getY(), this.LIC.getZ(), n + n / 2);
                } else {
                    this.setSample(this.LIC.getX(), this.LIC.getY(), this.LIC.getZ(), -n - n / 2);
                }
                this.LIC.moveElementAtLast(this.LSC);
                continue;
            }
            this.LIC.nextValue();
        }
        this.LIS.initialNode();
        boolean bl = this.LIS.isEmpty();
        while (!bl) {
            int n5;
            int n6;
            int n7;
            int n8;
            bl = this.LIS.isLast();
            if (!this.LIS.getType()) {
                n2 = this.bis.readMulti();
                ++n3;
                if (n2 == 1) {
                    int[] nArray = new int[3];
                    n8 = this.LIS.getX();
                    n7 = this.LIS.getY();
                    n6 = this.LIS.getZ();
                    for (n5 = 1; n5 <= 8; ++n5) {
                        nArray = this.children(n8, n7, n6, n5);
                        n2 = this.bis.readMulti();
                        ++n3;
                        if (n2 == 1) {
                            this.LSC.addElement(nArray[0], nArray[1], nArray[2]);
                            n2 = this.bis.readMulti();
                            ++n3;
                            if (n2 == 1) {
                                this.setSample(nArray[0], nArray[1], nArray[2], n + n / 2);
                                continue;
                            }
                            this.setSample(nArray[0], nArray[1], nArray[2], -n - n / 2);
                            continue;
                        }
                        this.LIC.addElement(nArray[0], nArray[1], nArray[2]);
                    }
                    if (this.isGrandParent(this.LIS.getX(), this.LIS.getY(), this.LIS.getZ())) {
                        if (this.method == 1) {
                            this.LIS.setType(true);
                            this.LIS.moveElementAtLast(this.LIS);
                            bl = false;
                            continue;
                        }
                        if (this.method != 0) continue;
                        n2 = this.bis.readMulti();
                        ++n3;
                        if (n2 == 1) {
                            n8 = this.LIS.getX();
                            n7 = this.LIS.getY();
                            n6 = this.LIS.getZ();
                            for (n5 = 1; n5 <= 8; ++n5) {
                                nArray = this.children(n8, n7, n6, n5);
                                this.LIS.addElement(nArray[0], nArray[1], nArray[2], false);
                                bl = false;
                            }
                            this.LIS.remove();
                            continue;
                        }
                        this.LIS.setType(true);
                        this.LIS.moveElementAtLast(this.LIS);
                        bl = false;
                        continue;
                    }
                    this.LIS.remove();
                    continue;
                }
                this.LIS.nextValue();
                continue;
            }
            n2 = this.bis.readMulti();
            ++n3;
            if (n2 == 1) {
                int[] nArray = new int[3];
                n8 = this.LIS.getX();
                n7 = this.LIS.getY();
                n6 = this.LIS.getZ();
                for (n5 = 1; n5 <= 8; ++n5) {
                    nArray = this.children(n8, n7, n6, n5);
                    this.LIS.addElement(nArray[0], nArray[1], nArray[2], false);
                    bl = false;
                }
                this.LIS.remove();
                continue;
            }
            this.LIS.nextValue();
        }
    }

    protected void refinement(int n, int n2) throws IOException {
        int n3 = 0;
        this.LSC.initialNode();
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5 = this.getSample(this.LSC.getX(), this.LSC.getY(), this.LSC.getZ());
            if (n5 < 0) {
                bl = false;
                n5 = Math.abs(n5);
            }
            if ((n4 = this.bis.readMulti()) == 1) {
                n5 += n / 2;
                if (!bl) {
                    n5 = -n5;
                }
                this.setSample(this.LSC.getX(), this.LSC.getY(), this.LSC.getZ(), n5);
            } else {
                n5 = n == 1 ? --n5 : (n5 -= n / 2);
                if (!bl) {
                    n5 = -n5;
                }
                this.setSample(this.LSC.getX(), this.LSC.getY(), this.LSC.getZ(), n5);
            }
            bl = true;
            this.LSC.nextValue();
            ++n3;
        }
    }

    protected void listInitialize() {
        for (int i = 0; i < this.limitResidualBandX; ++i) {
            for (int j = 0; j < this.limitResidualBandY; ++j) {
                for (int k = 0; k < this.limitResidualBandZ; ++k) {
                    this.LIC.addElement(i, 0, 0);
                    if (!this.isParent(i, j, k)) continue;
                    this.LIS.addElement(i, j, k, false);
                }
            }
        }
    }
}

