# A list of secondary magics we allow to be invoked under %%connect
SUPPORTED_MAGICS = ["disconnect", "send_to_remote", "help", "info",
                    "status", "session_id", "list_sessions",
                    "display", "spark_conf",
                    "idle_timeout", "session_id_prefix", "session_type",
                    "glue_version", "streaming", "etl", "worker_type",
                    "number_of_workers", "logs", "matplot", "push", "pop"]
LANGUAGE_SUPPORTED_MAGICS = ["send_to_remote", "display", "push", "pop"]

HELP_TEXT = f"""
| Magic              | Example                                                                                                              | Supported Compute Types                         | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| ------------------ | -------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| %help              | %help                                                                                                                | JupyterLab, AWS Glue, AWS EMR, ATHENA, REDSHIFT | Returns a list of descriptions and example usages for all magic commands.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| %%spark            | %%spark<br>%%spark (compute)<br>%%spark --name (compute)<br>%%spark -n (compute)                                     | AWS Glue, AWS EMR                               | Allows pyspark code written in python in the cell and submits code to Spark Compute<br><br>Supports an optional argument to specify the Compute name. The argument can be expressed explicitly by using "-n or --name". When the Compute name is not specified, an ordered search for "project.spark.compatibility", "project.spark", "project.spark.fineGrained" will be performed, and the first one found will be used.                                                                                                                                                                   |
| %%pyspark          | %%pyspark<br>%%pyspark (compute)<br>%%pyspark --name (compute)<br>%%pyspark -n (compute)                             | AWS Glue, AWS EMR                               | Allows pyspark code written in python in the cell and submits code to Spark Compute<br><br>Supports an optional argument to specify the Compute name. The argument can be expressed explicitly by using "-n or --name". When the Compute name is not specified, an ordered search for "project.spark.compatibility", "project.spark", "project.spark.fineGrained" will be performed, and the first one found will be used.                                                                                                                                                                   |
| %%scalaspark       | %%scalaspark<br>%%scalaspark (compute)<br>%%scalaspark --name (compute)<br>%%scalaspark -n (compute)                 | AWS Glue, AWS EMR                               | Allows spark code written in scala in the cell and submits code to Spark Compute<br><br>Supports an optional argument to specify the Compute name. The argument can be expressed explicitly by using "-n or --name". When the Compute name is not specified, an ordered search for "project.spark.compatibility", "project.spark", "project.spark.fineGrained" will be performed, and the first one found will be used.                                                                                                                                                                      |
| %%local            | %%local<br>%%local (compute)<br>%%local --name (compute)<br>%%local -n (compute)                                     | JupyterLab                                      | Allows code written in python in the cell runs the code in JupyterLab Compute. When no prarmeters are specified, it is the equivallent of not using this cell magic.<br><br>Supports an optional argument to specify the JupyterLab Compute name. The argument can be expressed explicitly by using "-n or --name". When the Compute name is not specified, "project.python" will be used. Commonly used to change AWS profile used to run code on JupyterLab.                                                                                                                               |
| %%sql              | %%sql<br><br>select current_user                                                                                     | AWS Glue, AWS EMR, ATHENA, REDSHIFT             | Executes a SQL query against Redshift, Athena and Spark Compute.<br><br>Supports an optional argument to specify the Compute name. The argument can be expressed explicitly by using "-n or --name". When the Compute name is not specified, an ordered search for "project.spark.compatibility", "project.spark", "project.spark.fineGrained" will be performed, and the first one found will be used.                                                                                                                                                                                      |
| %disconnect        | %disconnect --name (compute)                                                                                         | AWS Glue, AWS EMR, ATHENA, REDSHIFT             | Stops a session connecting to a remote compute.<br><br>Supports an optional argument -n or --name for the connection to be stopped. The default value is set to be the chosen connection in the dropdown for the current cell.                                                                                                                                                                                                                                                                                                                                                               |
| %send_to_remote    | %send_to_remote --name (compute) --language (language) --local (local variable name) --remote (remote variable name) | AWS Glue, AWS EMR                               | Sends a variable from the local kernel to remote compute. Remote compute supports both python and scala. When the remote is running in Python, it supports data type in dict, df, and str. When running in scala, df and str data types are supported.<br><br>Supports the following arguments: -l or --language for the connection language to be used, an argument -n or --name for the connection to be used, --local for the local variable name, and --remote or -r for the remote variable name.                                                                                       |
| %info              | %info --name (compute)                                                                                               | AWS Glue, AWS EMR                               | Outputs session information for the current chosen compute.<br><br>Supports optional argument -n or --name for the connection to be displayed its session information. The default value is set to be the chosen connection in the dropdown for the current cell.                                                                                                                                                                                                                                                                                                                            |
| %status            | %status --name (compute)                                                                                             | AWS Glue                                        | Returns current session status. Status includes when the session was created, configuration, executing user role, etc.<br><br>Supports an optional argument -n or --name for the connection to be displayed its session status. The default value is set to be the chosen connection in the dropdown for the current cell.                                                                                                                                                                                                                                                                   |
| %session_id        | %session_id —name (compute)                                                                                          | AWS Glue                                        | Returns the session ID for the running session.<br><br>Supports an optional argument -n or --name for the connection to be displayed its session ID. The default value is set to be the chosen connection in the dropdown for the current cell.                                                                                                                                                                                                                                                                                                                                              |
| %list_sessions     | %list_sessions                                                                                                       | JupyterLab                                      | Displays all maintained sessions in the current kernel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| %display           | %display --dataframe (df name)                                                                                       | JupyterLab, AWS Glue, AWS EMR                   | Displays summary from data from dataframe and enable plotting of dataframe.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| %matplot           | %matplot --name (compute) <plot name>                                                                                | AWS EMR                                         | Creates a visualization of plotting                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| %%configure        | %%configure --name (compute) (-f)<br>{{<br>"key": "value"<br>"key2": ${{var_name}}<br>}}                             | AWS Glue, AWS EMR                               | Configures the session by providing a JSON-formatted dictionary consisting of configuration parameters for a session.<br><br>Supports optional arguments: -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied. The magic also supports variable defined in notebook user namespace, so users don't need to type again.|
| %%tags             | %%tags --name (compute)<br>{{<br>"key": "value"<br>}}                                                                | AWS Glue                                        | Adds tags to a session. Tags should be specified within a curly bracket {{}}. Each tag name pair is enclosed in parentheses (" ") and separated by a comma (,).<br><br>Supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell.                                                                                                                                                                                                                                            |
| %spark_conf        | %spark_conf --name (compute) (-f) configuration                                                                      | AWS Glue                                        | Sets the spark configuration value of the session to be created.<br><br>Supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied.                                                                                                                                             |
| %idle_timeout      | %idle_timeout --name (compute) timeout (-f)                                                                          | AWS Glue                                        | Sets the idle timeout value of the session to be created. Default: 2880 minutes (48 hours).<br><br>Supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied.                                                                                                                  |
| %session_id_prefix | %session_id_prefix --name (compute) prefix_value (-f)                                                                | AWS Glue                                        | Sets the session Id prefix as the prefix_value preceding all session IDs in the format: **[session_id_prefix]-[project_id]-[session_id].** If a session ID is not provided, a random UUID will be generated.<br><br>Supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied. |
| %session_type      | %session_type --name (compute) etl (-f)                                                                              | AWS Glue                                        | Sets the session type to the value specified. The acceptable values are: etl and streaming.<br><br>Supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied.                                                                                                                  |
| %streaming         | %streaming --name (compute) (-f)                                                                                     | AWS Glue                                        | Sets the session to streaming type.<br><br>It supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied.                                                                                                                                                                       |
| %etl               | %etl --name (compute) (-f)                                                                                           | AWS Glue                                        | Sets the session to be etl type.<br><br>It supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied.                                                                                                                                                                          |
| %glue_version      | %glue_version --name (compute) 3.0 (-f)                                                                              | AWS Glue                                        | Sets the version of a session to be created.<br><br>It supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied.                                                                                                                                                              |
| %worker_type       | %worker_type --name (compute) G.2X (-f)                                                                              | AWS Glue                                        | Sets the worker type of a session to be created.<br><br>Supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied.                                                                                                                                                             |
| %number_of_workers | % number_of_workers --name (compute) 15 (-f)                                                                         | AWS Glue                                        | Sets the number of workers of a Glue session to be created.<br><br>Supports an optional argument -n or --name for the connection to be configured. The default value is set to be the chosen connection in the dropdown for the current cell. If a session has been created already, and a user wants to apply the configuration, -f or --force is required to kill the current one and to create a new one with the configuration applied.                                                                                                                                                  |
| %logs              | %logs --name (compute)                                                                                               | AWS EMR                                         | Outputs the session's session logs.<br><br>Supports an optional argument -n or --name for the connection to show its session logs. The default value is set to be the chosen connection in the dropdown for the current cell.                                                                                                                                                                                                                                                                                                                                                                |
| %push              | %push (var_name)<br>%push (var_name1),(var_name2)<br>%push -v (var_name)<br>%push -v (var_name) --namespace (namespace_name) | JupyterLab, AWS Glue, AWS EMR           | Upload specified variables to your project's shared S3 storage. <br><br>Supports an optional argument --namespace (defaults to kernel ID) <br><br>Note that uploaded variables are accessible to all project members.                                                                                                                                                                                                                                                                                                                                                                        |
| %pop               | %pop (var_name)<br>%pop (var_name1),(var_name2)<br>%pop -v (var_name)<br>%pop -v (var_name) --namespace (namespace_name) | JupyterLab, AWS Glue, AWS EMR               | Download specified variables from shared project S3 storage to your current compute environment. <br><br>Supports an optional argument --namespace (defaults to kernel ID)                                                                                                                                                                                                                                                                                                                                                                                                                   |
"""
