<img align="centre" src="https://github.com/digitalearthafrica/deafrica-sandbox-notebooks/blob/main/Supplementary_data/Github_banner.jpg?raw=true" width="100%">

# Digital Earth Africa Tools Package

Python functions and algorithms developed to assist in analysing Digital Earth Africa data (e.g. loading data, plotting, spatial analysis, machine learning).

## Installation

This module is automatically installed on the Digital Earth Africa Sandbox. If for some reason the module isn't available on the Digital Earth Africa Sandbox, or to upgrade the tools, you can `pip install` the module from the terminal.

You can install the latest version of `deafrica-tools` from PyPI using:

```
python -m pip install deafrica-tools 
```

or install the package directly from the `Tools` directory to incorperate local changes:

```
python -m pip install Tools/
```
       
To install this module from the source on any other system with `pip`:

```
python -m pip install  git+https://github.com/digitalearthafrica/deafrica-sandbox-notebooks.git#subdirectory=Tools
```



## Citing Digital Earth Africa Tools

The code in this module is an adaptation of code from the [Digital Earth Australia](https://github.com/GeoscienceAustralia/dea-notebooks) `dea-tools` package. If you use any of the code in this repository in your work, please reference them using the following citation:

    Krause, C., Dunn, B., Bishop-Taylor, R., Adams, C., Burton, C., Alger, M., Chua, S., Phillips, C., Newey, V., Kouzoubov, K., Leith, A., Ayers, D., Hicks, A., DEA Notebooks contributors 2021. Digital Earth Australia notebooks and tools repository. Geoscience Australia, Canberra. https://doi.org/10.26186/145234
    
    
## Translation

Translation of the module into other languages is done using `gettext` and `pot/po/mo` files.

We welcome contributors to help in translating the project by joining this project https://poeditor.com/join/project?hash=0Q33A7sRM6.

The template `.pot` file can be generated by running `pybabel extract -o deafrica_tools.pot *` from the `Tools/` directory.

This file can then be uploaded to the [deafrica_tools project](https://poeditor.com/join/project?hash=0Q33A7sRM6) on POEditor.com

To get the most recent terms and translations, download the files from the [deafrica_tools project](https://poeditor.com/join/project?hash=0Q33A7sRM6) and export the the `deafrica_tools.po` and `deafrica_tools.mo` files to the `deafrica_tools/locales/fr/LC_MESSAGES/` directory.

Currently, uploading and downloading terms and translations is accomplished using Github Actions. 

In python code, strings surrounded by an underscore function `_('')` will be translated.

This `_()` function is declared as a global after [`deafrica_tools.set_lang('fr')`](deafrica_tools/__init__.py) is called. 

Calling `deafrica_tools.set_lang()` with no argument will use the language set by JupyterLab under **Settings -> Language**.

See [wetlandsinsighttool.py](deafrica_tools/app/wetlandsinsighttool.py) as an example.
