# License: BSD 3 clause

import tick.base

from .base import features_normal_cov_uniform, \
    features_normal_cov_toeplitz, \
    weights_sparse_exp, weights_sparse_gauss

from .linreg import SimuLinReg
from .logreg import SimuLogReg
from .poisreg import SimuPoisReg
from .coxreg import SimuCoxReg

from .poisson_process import SimuPoissonProcess
from .inhomogeneous_poisson import SimuInhomogeneousPoisson
from .hawkes_kernels import *
from .hawkes import SimuHawkes
from .hawkes_exp_kernels import SimuHawkesExpKernels
from .hawkes_sumexp_kernels import SimuHawkesSumExpKernels
from .hawkes_multi import SimuHawkesMulti
from .sccs import SimuSCCS

__all__ = ["SimuLinReg",
           "SimuLogReg",
           "SimuPoisReg",
           "SimuCoxReg",
           "features_normal_cov_uniform",
           "features_normal_cov_toeplitz",
           "weights_sparse_exp",
           "weights_sparse_gauss",
           "SimuPoissonProcess",
           "SimuInhomogeneousPoisson",
           "SimuHawkes",
           "SimuHawkesExpKernels",
           "SimuHawkesSumExpKernels",
           "SimuHawkesMulti",
           "HawkesKernelExp",
           "HawkesKernelSumExp",
           "HawkesKernelPowerLaw",
           "HawkesKernelTimeFunc",
           "HawkesKernel0",
           "SimuSCCS"
           ]
