# Format Specification Elections

As file formats, CSV, XLS or XLSX files are accepted, which are generated by "Wabsti elections and votes (VRSG)" or by the web application itself. If a table is to be created by hand, then the format of the web application (OneGov) is the easiest.

## Content

<!-- TOC START min:1 max:4 link:true update:true -->
- [Format Specification Elections](#format-specification-elections)
  - [Content](#content)
  - [Preface](#preface)
    - [Entities](#entities)
    - [Tacit Elections](#tacit-elections)
    - [Regional Elections](#regional-elections)
  - [Formats](#formats)
    - [Onegov](#onegov)
      - [Columns](#columns)
      - [Panachage results](#panachage-results)
      - [Temporary results](#temporary-results)
      - [Template](#template)
    - [Wabsti Majorz](#wabsti-majorz)
      - [Columns data export](#columns-data-export)
      - [Columns candidate results](#columns-candidate-results)
      - [Temporary results](#temporary-results-1)
      - [Templates](#templates)
    - [Wabsti Proporz](#wabsti-proporz)
      - [Columns data export of the results](#columns-data-export-of-the-results)
      - [Panachage results](#panachage-results-1)
      - [Columns data export of the statistic](#columns-data-export-of-the-statistic)
      - [Columns list connections](#columns-list-connections)
      - [Columns candidate results](#columns-candidate-results-1)
      - [Temporary results](#temporary-results-2)
      - [Templates](#templates-1)
    - [WabstiCExport Majorz](#wabsticexport-majorz)
    - [WabstiCExport Proporz](#wabsticexport-proporz)
    - [Party results](#party-results)
      - [Template](#template-1)

<!-- TOC END -->



## Preface

### Entities

An entity is either a municipality (cantonal instances, communal instances without quarters) or a quarter (communal instances with quarters).

### Tacit Elections

Tacit elections can be uploaded by using the OneGov format with every vote set to `0`.

### Regional Elections

When uploading results of a regional election, only entities of one district are excepted to be present.

## Formats

### Onegov

The format, which will be used by the web application for the export, consists of a single file per election. There is a row for each municipality and candidate.

#### Columns

The following columns will be evaluated and should exist:

Name|Description
---|---
`election_absolute_majority`|Absolute majority of the election, only if Majorz election.
`election_status`|`unknown`, `interim` or `final`.
`entity_id`|BFS number of the municipality. A value of `0` can be used for expats.
`entity_counted`|`True` if the result was counted.
`entity_eligible_voters`|Number of persons entitled to vote in municipality.
`entity_received_ballots`|Number of submitted ballots in municipality.
`entity_blank_ballots`|Number empty ballots in municipality.
`entity_invalid_ballots`|Number invalid ballots in municipality.
`entity_blank_votes`|Number empty votes in municipality.
`entity_invalid_votes`|Number invalid votes in municipality. Zero if Proporz election.
`list_name`|Name of list of candidate. Only with Proporz elections.
`list_id`|ID of the list of the candidate. Only with Proporz elections.
`list_number_of_mandates`|Total number of mandates of the list. Only with Proporz elections.
`list_votes`|Total number if list votes. Only with Proporz elections.
`list_connection`|ID of the list connection. Only with Proporz elections.
`list_connection_parent`|ID of the superordinate list connection. Only with Proporz elections and if it is a sub-list connection.
`candidate_id`|ID of the candidate.
`candidate_family_name`|Surname of the candidate.
`candidate_first_name`|First name of the candidate.
`candidate_elected`|True, if the candidate was elected.
`candidate_party`|The name of the party.
`candidate_votes`|Number of candidate votes in municipality.

#### Panachage results

The results may contain panachage results by adding one column per list:

Name|Description
---|---
`panachage_votes_from_list_{XX}`|The number of votes the list got from the list with `list_id = XX`. A `list_id` with the value `999` marks the votes from the blank list.

#### Temporary results

Municipalities are deemed not to have been counted yet if one of the following two conditions apply:
- `counted = false`
- the municipality is not included in the results

If the status is
- `interim`, the whole election is considered not yet completed
- `final`, the whole election is considered completed
- `unknown`, the whole election is considered completed, if all (expected) municipalities are counted


#### Template

- [election_onegov_majorz.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_onegov_majorz.csv)
- [election_onegov_proporz.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_onegov_proporz.csv)

### Wabsti Majorz

The file format needs two individual charts: the data export and the list of elected candidates.

#### Columns data export

In the data export, there is a row for each municipality, candidates are arranged in columns. The following columns will be evaluated and should exist:
- `AnzMandate`
- `BFS`
- `StimmBer`
- `StimmAbgegeben`
- `StimmLeer`
- `StimmUngueltig`
- `StimmGueltig`

As well as for each candidate:
- `KandID_{XX}`
- `KandName_{XX}`
- `KandVorname_{XX}`
- `Stimmen_{XX}`

Additionally the empty and invalid votes as well as candidates will be captured by the following candidate names:
- `KandName_{XX} = 'Leere Zeilen'**` (Empty votes)
- `KandName_{XX} = 'Ungültige Stimmen'**` (Invalid votes)

#### Columns candidate results

Because the file format might not supply any information on the elected candidates, these informations can be provided in a second table. Each row consists of one elected candidate with the following columns:

Name|Description
---|---
`KandID`|ID of the candidate (`KandID_{XX}`).

#### Temporary results

The file format does not contain any clear information on whether the overall election is completely counted. This information must be given directly on the form for the data upload.

The file format also does not contain any information on whether an individual municipality is completely counted. If municipalities are missing entirely in the results, they are considered not yet counted.

#### Templates

- [election_wabsti_majorz_results.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_wabsti_majorz_results.csv)
- [election_wabsti_majorz_candidates.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_wabsti_majorz_candidates.csv)

### Wabsti Proporz

The file format needs four individual charts: the data export of the results, the data export of the statistics, the list connections and the list elected candidates.

#### Columns data export of the results

There is a line per candidate and municipality in the data export. The following columns will be evaluated and should exist:
- `Einheit_BFS`
- `Kand_Nachname`
- `Kand_Vorname`
- `Liste_KandID`
- `Liste_ID`
- `Liste_Code`
- `Kand_StimmenTotal`
- `Liste_ParteistimmenTotal`

#### Panachage results

The results may contain panachage results by adding one column per list (`{List ID}.{List code}`: the number of votes the list got from the list with the given `Liste_ID`). A `Liste_ID` with the value `99` (`99.WoP`) marks the votes from the blank list.

#### Columns data export of the statistic

The file with the statistics of the individual municipalities should contain the following columns:
- `Einheit_BFS`
- `Einheit_Name`
- `StimBerTotal`
- `WZEingegangen`
- `WZLeer`
- `WZUngueltig`
- `StmWZVeraendertLeerAmtlLeer`

#### Columns list connections

The file with list connections should contain the following columns:
- `Liste`
- `LV`
- `LUV`

#### Columns candidate results

Because the file format does not supply any information on the elected candidate, those must be included in a second column. Each row consists of one elected candidate with the following columns:

Name|Description
---|---
`Liste_KandID`|ID of the candidate.

#### Temporary results

The file format does not contain any clear information on whether the overall election is completely counted. This information must be given directly on the form for the data upload.

The file format also does not contain any information on whether an individual municipality is completely counted. If municipalities are missing entirely in the results, they are considered not yet counted.

#### Templates

- [election_wabsti_proporz_results.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_wabsti_proporz_results.csv)
- [election_wabsti_proporz_statistics.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_wabsti_proporz_statistics.csv)
- [election_wabsti_proporz_list_connections.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_wabsti_proporz_list_connections.csv)
- [election_wabsti_proporz_candidates.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_wabsti_proporz_candidates.csv)


### WabstiCExport Majorz

Version `>= 2.2` is supported, please refer to the documentation provided by the exporter program for more information about the columns of the different files.


### WabstiCExport Proporz

Version `>= 2.2` is supported, please refer to the documentation provided by the exporter program for more information about the columns of the different files.


### Party results

Each (proporz) election may contain party results. These results are independent of the other results and typically contain the already aggregated results of the different lists of a party.

The following columns will be evaluated and should exist:

Name|Description
---|---
`year`|The year of the election.
`total_votes`|The total votes of the election.
`name`|The name of the party.
`id`|ID of the party (any number).
`color`|The color of the party.
`mandates`|The number of mandates.
`votes`|The number of votes.

The results may contain panachage results by adding one column per party:

Name|Description
---|---
`panachage_votes_from_{XX}`|The number of votes the party got from the party with `id = XX`. An `id` with the value `999` marks the votes from the blank list.

Panachage results are only added if:
- `year` matches the year of the election
- `id (XX)` does not match the `id` of the row

#### Template

- [election_party_results.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/election_party_results.csv)
