"""Add sarbacane service

Revision ID: bb8a227f53be
Revises: f2802e96b9d9
Create Date: 2025-03-11 14:40:32.064647

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from alembic_postgresql_enum import TableReference

# revision identifiers, used by Alembic.
revision: str = "bb8a227f53be"
down_revision: Union[str, None] = "f2802e96b9d9"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.sync_enum_values(
        enum_schema="public",
        enum_name="service_name",
        new_values=["ASHLEY", "EDX", "BREVO", "JOANIE", "SARBACANE"],
        affected_columns=[
            TableReference(
                table_schema="public",
                table_name="user_service_statuses",
                column_name="service_name",
            )
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.sync_enum_values(
        enum_schema="public",
        enum_name="service_name",
        new_values=["ASHLEY", "EDX", "BREVO", "JOANIE"],
        affected_columns=[
            TableReference(
                table_schema="public",
                table_name="user_service_statuses",
                column_name="service_name",
            )
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###
