"""Add protected to enum type

Revision ID: f2802e96b9d9
Revises: b61049edae38
Create Date: 2024-11-27 17:40:32.627819

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from alembic_postgresql_enum import TableReference

# revision identifiers, used by Alembic.
revision: str = "f2802e96b9d9"
down_revision: Union[str, None] = "b61049edae38"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.sync_enum_values(
        enum_schema="public",
        enum_name="deletion_status",
        new_values=["TO_DELETE", "DELETING", "DELETED", "PROTECTED"],
        affected_columns=[
            TableReference(
                table_schema="public",
                table_name="user_service_statuses",
                column_name="status",
            )
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.sync_enum_values(
        enum_schema="public",
        enum_name="deletion_status",
        new_values=["TO_DELETE", "DELETING", "DELETED"],
        affected_columns=[
            TableReference(
                table_schema="public",
                table_name="user_service_statuses",
                column_name="status",
            )
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###
