# Pull Request Checklist

Thank you for contributing to the SuperCowPowers SageWorks project. Please make sure you've completed the following tasks before submitting your pull request:

#### GENERAL
- [  ] I've read the [CONTRIBUTING](https://github.com/SuperCowPowers/sageworks/blob/main/CONTRIBUTING.md) document.
- [  ] I've merged 'main' into my PR branch (like today's main)

#### TESTING (run 'tox' for local testing)
- [  ] I've added tests to cover my changes
- [  ] black/flake8 linter tests passed
- [  ] 100% of the tests passed

#### UI (Web Interface/Components)
- [  ] I've run sageworks/applications/aws_dashboard/dashboard
- [  ] I've tested the UI and scanned the log output for any issues

#### DOCUMENTATION
- [  ] I've updated the documentation accordingly

#### REVIEW 
- [  ] I've added (or will add) a reviewer to the PR
- [  ] I'll address any comments/request from reviewer
- [  ] I will delete the branch after the PR is merged 

#### Notes
An SCP Developer/reviewer may make direct changes to your branch. A follow up issue might be created or asked for. Branches are empheral, they should/will be deleted after the PR is merged. Do not reuse an old branch, if a change needs to be made pull a new branch off of main.


## Description of Changes

<!-- Provide a brief description of the changes you've made -->
