
# Python
import unittest
from unittest.mock import Mock

# ATS
from ats.topology import Device
from ats.topology import loader

# Metaparser
from genie.metaparser.util.exceptions import SchemaEmptyParserError, \
                                             SchemaMissingKeyError

# iosxe show_bgp
from genie.libs.parser.iosxe.show_bgp import ShowBgpAll,\
                                             ShowIpBgpAll,\
                                             ShowBgp,\
                                             ShowIpBgp,\
                                             ShowBgpAllDetail,\
                                             ShowIpBgpAllDetail,\
                                             ShowBgpDetail,\
                                             ShowIpBgpDetail,\
                                             ShowBgpSummary,\
                                             ShowBgpAllSummary,\
                                             ShowIpBgpSummary,\
                                             ShowIpBgpAllSummary,\
                                             ShowBgpAllNeighbors,\
                                             ShowBgpNeighbors,\
                                             ShowIpBgpAllNeighbors,\
                                             ShowIpBgpNeighbors,\
                                             ShowBgpAllNeighborsAdvertisedRoutes,\
                                             ShowBgpNeighborsAdvertisedRoutes,\
                                             ShowIpBgpAllNeighborsAdvertisedRoutes,\
                                             ShowIpBgpNeighborsAdvertisedRoutes,\
                                             ShowBgpAllNeighborsReceivedRoutes,\
                                             ShowBgpNeighborsReceivedRoutes,\
                                             ShowIpBgpAllNeighborsReceivedRoutes,\
                                             ShowIpBgpNeighborsReceivedRoutes,\
                                             ShowBgpAllNeighborsRoutes,\
                                             ShowBgpNeighborsRoutes,\
                                             ShowIpBgpAllNeighborsRoutes,\
                                             ShowIpBgpNeighborsRoutes,\
                                             ShowBgpAllClusterIds,\
                                             ShowBgpAllNeighborsPolicy,\
                                             ShowIpBgpTemplatePeerSession,\
                                             ShowIpBgpTemplatePeerPolicy,\
                                             ShowIpBgpAllDampeningParameters


# ===================================
# Unit test for:
#   * 'show bgp all'
#   * 'show bgp {address_family} all'
# ===================================
class test_show_bgp_all(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'vrf':
            {'evpn1':
                {'address_family':
                    {'vpnv4 unicast RD 65535:1':
                        {'bgp_table_version': 5,
                        'default_vrf': 'evpn1',
                        'route_distinguisher': '65535:1',
                        'route_identifier': '10.21.33.33',
                         'af_private_import_to_address_family': 'L2VPN E-VPN',
                         'pfx_count': 2,
                         'pfx_limit': 1000,
                         'routes':
                            {'10.36.3.0/24':
                                {'index':
                                    {1:
                                        {'metric': 0,
                                        'next_hop': '10.36.3.254',
                                        'origin_codes': '?',
                                        'path': '65530',
                                        'status_codes': '*',
                                        'weight': 0,
                                        },
                                    2:
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'weight': 32768,
                                        'status_codes': '*>',
                                        'metric':0,
                                        },
                                    },
                                },
                            '10.1.1.0/24':
                                {'index':
                                    {1:
                                        {'metric': 0,
                                        'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'weight': 32768,
                                        'status_codes': '*>',
                                        },
                                    },
                                },
                            },
                        },
                    'l2vpn e-vpn RD 65535:1':
                            {'bgp_table_version': 4,
                            'default_vrf': 'evpn1',
                            'route_distinguisher': '65535:1',
                            'route_identifier': '10.21.33.33',
                            'routes':
                                {'[5][65535:1][0][24][10.36.3.0]/17':
                                    {'index':
                                        {1:
                                            {'metric': 0,
                                            'next_hop': '0.0.0.0',
                                            'origin_codes': '?',
                                            'weight': 32768,
                                            'status_codes': '*>',
                                            },
                                        2:
                                            {'metric': 0,
                                            'next_hop': '10.36.3.254',
                                            'origin_codes': '?',
                                            'path': '65530',
                                            'status_codes': '*',
                                            'weight': 0,
                                            },
                                        },
                                    },
                                '[5][65535:1][0][24][10.1.1.0]/17':
                                    {'index':
                                        {1:
                                            {'metric': 0,
                                            'next_hop': '0.0.0.0',
                                            'origin_codes': '?',
                                            'weight': 32768,
                                            'status_codes': '*>',
                                            },
                                        },
                                    },
                                },
                            },
                       },
                    },
                },
            }

    golden_output1 = {'execute.return_value': '''
        R1_CE#show bgp all
        For address family: IPv4 Unicast


        For address family: IPv6 Unicast


        For address family: VPNv4 Unicast

        BGP table version is 5, local router ID is 10.21.33.33
        Status codes: s suppressed, d damped, h history, * valid, > best, i - internal,
                      r RIB-failure, S Stale, m multipath, b backup-path, f RT-Filter,
                      x best-external, a additional-path, c RIB-compressed,
                      t secondary path,
        Origin codes: i - IGP, e - EGP, ? - incomplete
        RPKI validation codes: V valid, I invalid, N Not found

             Network          Next Hop            Metric LocPrf Weight Path
        Route Distinguisher: 65535:1 (default for vrf evpn1)
        AF-Private Import to Address-Family: L2VPN E-VPN, Pfx Count/Limit: 2/1000
         *    10.36.3.0/24       10.36.3.254                0             0 65530 ?
         *>                    0.0.0.0                  0         32768 ?
         *>   10.1.1.0/24     0.0.0.0                  0         32768 ?

        For address family: IPv4 Multicast

        For address family: L2VPN E-VPN

        BGP table version is 4, local router ID is 10.21.33.33
        Status codes: s suppressed, d damped, h history, * valid, > best, i - internal,
                      r RIB-failure, S Stale, m multipath, b backup-path, f RT-Filter,
                      x best-external, a additional-path, c RIB-compressed,
                      t secondary path,
        Origin codes: i - IGP, e - EGP, ? - incomplete
        RPKI validation codes: V valid, I invalid, N Not found

             Network          Next Hop            Metric LocPrf Weight Path
        Route Distinguisher: 65535:1 (default for vrf evpn1)
         *>   [5][65535:1][0][24][10.36.3.0]/17
                              0.0.0.0                  0         32768 ?
         *                     10.36.3.254                0             0 65530 ?
         *>   [5][65535:1][0][24][10.1.1.0]/17
                              0.0.0.0                  0         32768 ?


        For address family: VPNv4 Multicast


        For address family: MVPNv4 Unicast


        For address family: MVPNv6 Unicast


        For address family: VPNv4 Flowspec
        '''}

    golden_parsed_output2 = {
        'vrf':
            {'default':
                {'address_family':
                    {'vpnv4 unicast RD 200:1':
                        {'bgp_table_version': 56,
                        'default_vrf': 'default',
                        'route_distinguisher': '200:1',
                        'route_identifier': '10.64.4.4',
                        'routes':
                            {'10.1.1.0/24':
                                {'index':
                                    {1:
                                        {'metric': 2219,
                                        'next_hop': '10.4.1.1',
                                        'localpref': 100,
                                        'origin_codes': 'e',
                                        'path': '200 33299 51178 47751 {27016}',
                                        'status_codes': '* i',
                                        'weight': 0,
                                        },
                                    2:
                                        {'metric': 2219,
                                        'next_hop': '10.4.1.1',
                                        'localpref': 100,
                                        'origin_codes': 'e',
                                        'path': '200 33299 51178 47751 {27016}',
                                        'status_codes': '*>i',
                                        'weight': 0,
                                        },
                                    },
                                },
                            '10.1.2.0/24':
                                {'index':
                                    {1:
                                        {'metric': 2219,
                                        'next_hop': '10.4.1.1',
                                        'localpref': 100,
                                        'origin_codes': 'e',
                                        'path': '200 33299 51178 47751 {27016}',
                                        'status_codes': '* i',
                                        'weight': 0,
                                        },
                                    2:
                                        {'metric': 2219,
                                        'next_hop': '10.4.1.1',
                                        'localpref': 100,
                                        'origin_codes': 'e',
                                        'path': '200 33299 51178 47751 {27016}',
                                        'status_codes': '*>i',
                                        'weight': 0,
                                        },

                                          },
                                      },
                                },
                            },
                       'vpnv4 unicast RD 200:2':
                           {'bgp_table_version': 56,
                            'default_vrf': 'default',
                            'route_distinguisher': '200:2',
                            'route_identifier': '10.64.4.4',
                            'routes':
                                {'10.1.1.0/24':
                                     {'index':
                                          {1:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '*>i',
                                                'weight': 0,
                                                },
                                           2:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '* i',
                                                'weight': 0,
                                                },

                                           },
                                      },
                                 '10.1.2.0/24':
                                     {'index':
                                          {1:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '*>i',
                                                'weight': 0,
                                                },
                                          2:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '* i',
                                                'weight': 0,
                                                },


                                          },
                                      },
                                 '10.1.3.0/24':
                                     {'index':
                                          {1:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '*>i',
                                                'weight': 0,
                                                },
                                           2:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '* i',
                                                'weight': 0,
                                                },

                                           },
                                      },
                                 },
                            },
                       },
                  },
             },
    }

    golden_output2 = {'execute.return_value': '''
        R4_iosv#show bgp all
        For address family: IPv4 Unicast


        For address family: IPv6 Unicast


        For address family: VPNv4 Unicast

        BGP table version is 56, local router ID is 10.64.4.4
        Status codes: s suppressed, d damped, h history, * valid, > best, i - internal,
                      r RIB-failure, S Stale, m multipath, b backup-path, f RT-Filter,
                      x best-external, a additional-path, c RIB-compressed,
        Origin codes: i - IGP, e - EGP, ? - incomplete
        RPKI validation codes: V valid, I invalid, N Not found

             Network          Next Hop            Metric LocPrf Weight Path
        Route Distinguisher: 200:1
         * i 10.1.1.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
         *>i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
         * i 10.1.2.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
         *>i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        Route Distinguisher: 200:2
         *>i 10.1.1.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
         * i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
         *>i 10.1.2.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
         * i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
         *>i 10.1.3.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
         * i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e



        For address family: L2VPN E-VPN


        For address family: VPNv4 Multicast


        For address family: MVPNv4 Unicast


        For address family: MVPNv6 Unicast


        For address family: VPNv6 Multicast
        '''}

    golden_parsed_output3 = {
        'vrf':
            {'default':
                 {'address_family':
                      {'vpnv4 unicast RD 200:1':
                           {'bgp_table_version': 56,
                            'default_vrf': 'default',
                            'route_distinguisher': '200:1',
                            'route_identifier': '10.64.4.4',
                            'routes':
                                {'10.1.1.0/24':
                                     {'index':
                                          {1:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '* i',
                                                'weight': 0,
                                                },
                                           2:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '*>i',
                                                'weight': 0,
                                                },

                                           },
                                      },
                                 '10.1.2.0/24':
                                     {'index':
                                          {1:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '* i',
                                                'weight': 0,
                                                },
                                           2:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '*>i',
                                                'weight': 0,
                                                },

                                           },
                                      },
                                 },
                            },
                       'vpnv4 unicast RD 200:2':
                           {'bgp_table_version': 56,
                            'default_vrf': 'default',
                            'route_distinguisher': '200:2',
                            'route_identifier': '10.64.4.4',
                            'routes':
                                {'10.1.1.0/24':
                                     {'index':
                                          {1:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '*>i',
                                                'weight': 0,
                                                },
                                           2:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '* i',
                                                'weight': 0,
                                                },

                                           },
                                      },
                                 '10.1.2.0/24':
                                     {'index':
                                          {1:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '*>i',
                                                'weight': 0,
                                                },
                                           2:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '* i',
                                                'weight': 0,
                                                },

                                           },
                                      },
                                 '10.1.3.0/24':
                                     {'index':
                                          {1:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '*>i',
                                                'weight': 0,
                                                },
                                           2:
                                               {'metric': 2219,
                                                'next_hop': '10.4.1.1',
                                                'localpref': 100,
                                                'origin_codes': 'e',
                                                'path': '200 33299 51178 47751 {27016}',
                                                'status_codes': '* i',
                                                'weight': 0,
                                                },

                                           },
                                      },
                                 },
                            },
                       },
                  },
             'VRF1':
                 {'address_family':
                     {
                         'vpnv4 unicast RD 300:1':
                             {'bgp_table_version': 56,
                              'default_vrf': 'VRF1',
                              'route_distinguisher': '300:1',
                              'route_identifier': '10.64.4.4',
                              'vrf_route_identifier': '10.94.44.44',
                              'routes':
                                  {'10.1.1.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.1.1',
                                                  'localpref': 100,
                                                  'origin_codes': 'e',
                                                  'path': '200 33299 51178 47751 {27016}',
                                                  'status_codes': '* i',
                                                  'weight': 0,
                                                  },
                                             2:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.1.1',
                                                  'localpref': 100,
                                                  'origin_codes': 'e',
                                                  'path': '200 33299 51178 47751 {27016}',
                                                  'status_codes': '*>i',
                                                  'weight': 0,
                                                  },

                                             },
                                        },
                                   '10.1.2.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.1.1',
                                                  'localpref': 100,
                                                  'origin_codes': 'e',
                                                  'path': '200 33299 51178 47751 {27016}',
                                                  'status_codes': '* i',
                                                  'weight': 0,
                                                  },
                                             2:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.1.1',
                                                  'localpref': 100,
                                                  'origin_codes': 'e',
                                                  'path': '200 33299 51178 47751 {27016}',
                                                  'status_codes': '*>i',
                                                  'weight': 0,
                                                  },

                                             },
                                        },
                                   '10.169.1.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '300 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },

                                             },
                                        },
                                   '10.169.2.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '300 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },

                                             },
                                        },
                                   '10.169.3.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '300 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },

                                             },
                                        },
                                   '10.169.4.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '300 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },

                                             },
                                        },
                                   '10.169.5.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.4.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '300 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },

                                             },
                                        },
                                   '10.9.2.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.66.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },

                                             },
                                        },
                                   },
                              },
                     },
                 },
             'VRF2':
                 {'address_family':
                     {
                         'vpnv4 unicast RD 400:1':
                             {'bgp_table_version': 56,
                              'default_vrf': 'VRF2',
                              'route_distinguisher': '400:1',
                              'route_identifier': '10.64.4.4',
                              'vrf_route_identifier': '10.94.44.44',
                              'routes':
                                  {'10.9.2.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.66.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },
                                             },
                                        },
                                   '10.9.3.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.66.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },
                                             },
                                        },
                                   '10.9.4.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.66.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },
                                             },
                                        },
                                   '10.9.5.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.66.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },
                                             },
                                        },
                                   '10.9.6.0/24':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'next_hop': '10.66.6.6',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '*>',
                                                  'weight': 0,
                                                  },
                                             },
                                        },
                                   '2001:db8:cdc9:121::/64':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'localpref': 100,
                                                  'next_hop': '::FFFF:10.4.1.1',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '* i',
                                                  'weight': 0,
                                                  },
                                             2:
                                                 {'metric': 2219,
                                                  'localpref': 100,
                                                  'next_hop': '::FFFF:10.4.1.1',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '*>i',
                                                  'weight': 0,
                                                  },
                                             },
                                        },
                                   '2001:db8:cdc9:144::/64':
                                       {'index':
                                            {1:
                                                 {'metric': 2219,
                                                  'localpref': 100,
                                                  'next_hop': '::FFFF:10.4.1.1',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '* i',
                                                  'weight': 0,
                                                  },
                                             2:
                                                 {'metric': 2219,
                                                  'localpref': 100,
                                                  'next_hop': '::FFFF:10.4.1.1',
                                                  'origin_codes': 'e',
                                                  'path': '400 33299 51178 47751 {27016}',
                                                  'status_codes': '*>i',
                                                  'weight': 0,
                                                  },
                                             },
                                        },

                                   },
                              },
                     },
                 },
             },
    }

    golden_output3 = {'execute.return_value': '''
        R4_iosv#show bgp all
        For address family: IPv4 Unicast


        For address family: IPv6 Unicast


        For address family: VPNv4 Unicast

        BGP table version is 56, local router ID is 10.64.4.4
        Status codes: s suppressed, d damped, h history, * valid, > best, i - internal,
                     r RIB-failure, S Stale, m multipath, b backup-path, f RT-Filter,
                     x best-external, a additional-path, c RIB-compressed,
        Origin codes: i - IGP, e - EGP, ? - incomplete
        RPKI validation codes: V valid, I invalid, N Not found

            Network          Next Hop            Metric LocPrf Weight Path
        Route Distinguisher: 200:1
        * i 10.1.1.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        *>i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        * i 10.1.2.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        *>i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        Route Distinguisher: 200:2
        *>i 10.1.1.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        * i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        *>i 10.1.2.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        * i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        *>i 10.1.3.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        * i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        Route Distinguisher: 300:1 (default for vrf VRF1) VRF Router ID 10.94.44.44
        * i 10.1.1.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        *>i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        * i 10.1.2.0/24      10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        *>i                  10.4.1.1               2219    100      0 200 33299 51178 47751 {27016} e
        *>  10.169.1.0/24      10.4.6.6              2219             0 300 33299 51178 47751 {27016} e
        *>  10.169.2.0/24      10.4.6.6              2219             0 300 33299 51178 47751 {27016} e
        *>  10.169.3.0/24      10.4.6.6              2219             0 300 33299 51178 47751 {27016} e
        *>  10.169.4.0/24      10.4.6.6              2219             0 300 33299 51178 47751 {27016} e
        *>  10.169.5.0/24      10.4.6.6              2219             0 300 33299 51178 47751 {27016} e
        *>  10.9.2.0/24      10.66.6.6              2219             0 400 33299 51178 47751 {27016} e
        Route Distinguisher: 400:1 (default for vrf VRF2) VRF Router ID 10.94.44.44
        *>  10.9.2.0/24      10.66.6.6              2219             0 400 33299 51178 47751 {27016} e
        *>  10.9.3.0/24      10.66.6.6              2219             0 400 33299 51178 47751 {27016} e
        *>  10.9.4.0/24      10.66.6.6              2219             0 400 33299 51178 47751 {27016} e
        *>  10.9.5.0/24      10.66.6.6              2219             0 400 33299 51178 47751 {27016} e
        *>  10.9.6.0/24      10.66.6.6              2219             0 400 33299 51178 47751 {27016} e
        * i 2001:db8:cdc9:121::/64   ::FFFF:10.4.1.1        2219    100      0 400 33299 51178 47751 {27016} e
        *>i                  ::FFFF:10.4.1.1        2219    100      0 400 33299 51178 47751 {27016} e
        * i 2001:db8:cdc9:144::/64 ::FFFF:10.4.1.1        2219    100      0 400 33299 51178 47751 {27016} e
        *>i                  ::FFFF:10.4.1.1        2219    100      0 400 33299 51178 47751 {27016} e



        For address family: L2VPN E-VPN


        For address family: VPNv4 Multicast


        For address family: MVPNv4 Unicast


        For address family: MVPNv6 Unicast


        For address family: VPNv6 Multicast
        '''}


    def test_show_bgp_all_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowBgpAll(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_bgp_all_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowBgpAll(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_bgp_all_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowBgpAll(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output2)

    def test_show_bgp_all_golden3(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output3)
        obj = ShowBgpAll(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output3)


# =======================================
# Unit test for:
#   * 'show ip bgp all'
#   * 'show ip bgp {address_family} all'
# =======================================
class test_show_ip_bgp_all(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'vrf': 
            {'default': 
                {'address_family': 
                    {'l2vpn vpls RD 100:1051': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1051',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1051:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1052': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1052',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1052:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1053': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1053',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1053:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1054': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1054',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1054:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1055': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1055',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1055:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1056': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1056',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1056:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1057': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1057',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1057:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1058': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1058',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1058:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1059': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1059',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1059:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1060': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1060',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1060:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1061': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1061',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1061:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1062': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1062',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1062:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1063': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1063',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1063:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1064': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1064',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1064:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1065': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1065',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1065:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1066': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1066',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1066:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1067': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1067',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1067:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1068': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1068',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1068:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1069': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1069',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1069:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}},
                    'l2vpn vpls RD 100:1070': 
                        {'bgp_table_version': 1841,
                        'default_vrf': 'default',
                        'route_distinguisher': '100:1070',
                        'route_identifier': '10.169.197.254',
                        'routes': 
                            {'100:1070:VEID-2:Blk-1/136': 
                                {'index': 
                                    {1: 
                                        {'next_hop': '0.0.0.0',
                                        'origin_codes': '?',
                                        'status_codes': '*>',
                                        'weight': 32768}}}}}}}}}

    golden_output1 = {'execute.return_value': '''
        Router#show ip bgp l2vpn vpls all
        Load for five secs: 2%/0%; one minute: 12%; five minutes: 8%
        Time source is NTP, 15:53:21.642 EST Sun Jun 6 2016

        BGP table version is 1841, local router ID is 10.169.197.254
        Status codes: s suppressed, d damped, h history, * valid, > best, i - internal, 
                      r RIB-failure, S Stale, m multipath, b backup-path, f RT-Filter, 
                      x best-external, a additional-path, c RIB-compressed, 
        Origin codes: i - IGP, e - EGP, ? - incomplete
        RPKI validation codes: V valid, I invalid, N Not found

             Network          Next Hop            Metric LocPrf Weight Path
        Route Distinguisher: 100:1051
         *>  100:1051:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1052
         *>  100:1052:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1053
         *>  100:1053:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1054
         *>  100:1054:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1055
         *>  100:1055:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1056
         *>  100:1056:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1057
         *>  100:1057:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1058
         *>  100:1058:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1059
         *>  100:1059:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1060
         *>  100:1060:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1061
         *>  100:1061:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1062
         *>  100:1062:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1063
         *>  100:1063:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1064
         *>  100:1064:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1065
         *>  100:1065:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1066
         *>  100:1066:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1067
         *>  100:1067:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1068
         *>  100:1068:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1069
         *>  100:1069:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        Route Distinguisher: 100:1070
         *>  100:1070:VEID-2:Blk-1/136
                               0.0.0.0                            32768 ?
        '''}

    golden_parsed_output2 = {
        'vrf': 
            {'L3VPN-0050': 
                {'address_family': 
                    {'vpnv4 unicast RD 5918:50': 
                        {'bgp_table_version': 27013588,
                        'default_vrf': 'L3VPN-0050',
                        'route_distinguisher': '5918:50',
                        'route_identifier': '10.169.197.254',
                        'routes': {'172.16.200.1/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   '172.16.200.10/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.11/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.12/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.13/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.14/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.15/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.16/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.17/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.18/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.19/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.2/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   '172.16.200.20/32': {'index': {1: {'localpref': 100,
                                                                      'next_hop': '10.13.202.64',
                                                                      'origin_codes': 'i',
                                                                      'path': '60000',
                                                                      'status_codes': '*>i',
                                                                      'weight': 0}}},
                                   '172.16.200.3/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   '172.16.200.4/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   '172.16.200.5/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   '172.16.200.6/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   '172.16.200.7/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   '172.16.200.8/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   '172.16.200.9/32': {'index': {1: {'localpref': 100,
                                                                     'next_hop': '10.13.202.64',
                                                                     'origin_codes': 'i',
                                                                     'path': '60000',
                                                                     'status_codes': '*>i',
                                                                     'weight': 0}}},
                                   'i': {'index': {1: {'localpref': 100,
                                                       'next_hop': '10.13.202.64',
                                                       'origin_codes': 'i',
                                                       'path': '60000',
                                                       'status_codes': '*>',
                                                       'weight': 0}}}},
                'vrf_route_identifier': '192.168.10.254'}}}}}

    golden_output2 = {'execute.return_value': '''
        Router#show ip bgp all
        Load for five secs: 4%/0%; one minute: 5%; five minutes: 4%
        Time source is NTP, 09:44:45.434 EST Tue Jun 8 2016
        For address family: IPv4 Unicast


        For address family: VPNv4 Unicast

        BGP table version is 27013588, local router ID is 10.169.197.254
        Status codes: s suppressed, d damped, h history, * valid, > best, i - internal, 
                      r RIB-failure, S Stale, m multipath, b backup-path, f RT-Filter, 
                      x best-external, a additional-path, c RIB-compressed, 
        Origin codes: i - IGP, e - EGP, ? - incomplete
        RPKI validation codes: V valid, I invalid, N Not found

             Network          Next Hop            Metric LocPrf Weight Path
        Route Distinguisher: 5918:50 (default for vrf L3VPN-0050) VRF Router ID 192.168.10.254
         *>i 172.16.200.1/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.2/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.3/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.4/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.5/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.6/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.7/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.8/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.9/32  10.13.202.64                  100      0 60000 i
         *>i 172.16.200.10/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.11/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.12/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.13/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.14/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.15/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.16/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.17/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.18/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.19/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.20/32 10.13.202.64                  100      0 60000 i
         *>i 172.16.200.99/32
                       10.13.202.64                  100      0 60000 i
        '''}

    def test_show_ip_bgp_all_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowIpBgpAll(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_ip_bgp_all_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowIpBgpAll(device=self.device)
        parsed_output = obj.parse(address_family='l2vpn vpls')
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_ip_bgp_all_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowIpBgpAll(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output2)

#-------------------------------------------------------------------------------


# =========================
# Unit test for:
#   * 'show bgp all detail'
# =========================
class test_show_bgp_all_detail(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'instance':
            {'default':
                {'vrf':
                    {'VRF1':
                        {'address_family':
                            {'vpnv4 unicast RD 100:100':
                                {'default_vrf': 'VRF1',
                                'prefixes':
                                    {'10.229.11.11/32':
                                        {'available_path': '1',
                                        'best_path': '1',
                                        'index':
                                            {1:
                                                {'gateway': '0.0.0.0',
                                                'inaccessible': False,
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '0.0.0.0',
                                                'next_hop_via': 'vrf '
                                                                'VRF1',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.1',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0',
                                                'weight': '32768'}},
                                        'paths': '1 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'VRF1',
                                        'table_version': '2'}},
                                'route_distinguisher': '100:100'},
                            'vpnv6 unicast RD 100:100':
                                {'default_vrf': 'VRF1',
                                'prefixes':
                                    {'2001:11:11::11/128':
                                        {'available_path': '1',
                                        'best_path': '1',
                                        'index':
                                            {1:
                                                {'gateway': '0.0.0.0',
                                                'inaccessible': False,
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '::',
                                                'next_hop_via': 'vrf '
                                                                'VRF1',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.1',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0',
                                                'weight': '32768'}},
                                        'paths': '1 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'VRF1',
                                        'table_version': '2'}},
                                'route_distinguisher': '100:100'}}},
                    'default':
                        {'address_family':
                            {'ipv4 unicast':
                                {'prefixes':
                                    {'10.4.1.1/32':
                                        {'available_path': '1',
                                        'best_path': '1',
                                        'index':
                                            {1:
                                                {'gateway': '0.0.0.0',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '0.0.0.0',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.1',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0',
                                                'update_group': 3,
                                                'weight': '32768'}},
                                        'paths': '1 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'default, RIB-failure(17)',
                                        'table_version': '4'},
                                    '10.1.1.0/24':
                                        {'available_path': '2',
                                        'best_path': '1',
                                        'index':
                                            {1:
                                                {'gateway': '0.0.0.0',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '0.0.0.0',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.1',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0',
                                                'update_group': 3,
                                                'weight': '32768'},
                                            2:
                                                {'gateway': '10.1.1.2',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '10.1.1.2',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.2',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '* '
                                                                'i',
                                                'update_group': 3}},
                                        'paths': '2 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'default',
                                        'table_version': '5'},
                                    '10.16.2.2/32':
                                        {'available_path': '1',
                                        'best_path': '1',
                                        'index':
                                            {1:
                                                {'gateway': '10.1.1.2',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '10.1.1.2',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.2',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0'}},
                                        'paths': '1 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'default',
                                        'table_version': '2'}}},
                            'ipv6 unicast':
                                {'prefixes':
                                    {'2001:1:1:1::1/128':
                                        {'available_path': '1',
                                        'best_path': '1',
                                        'index':
                                            {1:
                                                {'gateway': '0.0.0.0',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '::',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.1',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0',
                                                'update_group': 1,
                                                'weight': '32768'}},
                                        'paths': '1 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'default',
                                        'table_version': '4'},
                                    '2001:2:2:2::2/128':
                                        {'available_path': '2',
                                        'best_path': '1',
                                        'index':
                                            {1:
                                                {'gateway': '2001:DB8:1:1::2',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '2001:DB8:1:1::2',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.2',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0'},
                                            2:
                                                {'gateway': '10.1.1.2',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '::FFFF:10.1.1.2',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.2',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '* '
                                                'i',
                                                'transfer_pathid': '0'}},
                                        'paths': '2 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'default',
                                        'table_version': '2'},
                                    '2001:DB8:1:1::/64':
                                        {'available_path': '3',
                                        'best_path': '1',
                                        'index':
                                            {1:
                                                {'gateway': '0.0.0.0',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '::',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.1',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0',
                                                'update_group': 1,
                                                'weight': '32768'},
                                            2: 
                                                {'gateway': '2001:DB8:1:1::2',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '2001:DB8:1:1::2',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.2',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '* '
                                                                'i',
                                                'update_group': 1},
                                            3: 
                                                {'gateway': '10.1.1.2',
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '::FFFF:10.1.1.2',
                                                'origin_codes': '?',
                                                'originator': '10.1.1.2',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '* '
                                                                'i',
                                                'update_group': 1}},
                                        'paths': '3 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'default',
                                        'table_version': '5'}}}}}}}}}

    golden_output1 = {'execute.return_value': '''
        R1#show bgp all detail 
        For address family: IPv4 Unicast

        BGP routing table entry for 10.4.1.1/32, version 4
        Paths: (1 available, best #1, table default, RIB-failure(17))
        Advertised to update-groups:
           3         
        Refresh Epoch 1
        Local
          0.0.0.0 from 0.0.0.0 (10.1.1.1)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
            rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 10.16.2.2/32, version 2
        Paths: (1 available, best #1, table default)
        Not advertised to any peer
        Refresh Epoch 1
        Local
          10.1.1.2 from 10.1.1.2 (10.1.1.2)
            Origin incomplete, metric 0, localpref 100, valid, internal, best
            rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 10.1.1.0/24, version 5
        Paths: (2 available, best #1, table default)
        Advertised to update-groups:
           3         
        Refresh Epoch 1
        Local
          0.0.0.0 from 0.0.0.0 (10.1.1.1)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
            rx pathid: 0, tx pathid: 0x0
        Refresh Epoch 1
        Local
          10.1.1.2 from 10.1.1.2 (10.1.1.2)
            Origin incomplete, metric 0, localpref 100, valid, internal
            rx pathid: 0, tx pathid: 0

        For address family: IPv6 Unicast

        BGP routing table entry for 2001:1:1:1::1/128, version 4
        Paths: (1 available, best #1, table default)
        Advertised to update-groups:
           1         
        Refresh Epoch 1
        Local
          :: from 0.0.0.0 (10.1.1.1)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
            rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 2001:2:2:2::2/128, version 2
        Paths: (2 available, best #1, table default)
        Not advertised to any peer
        Refresh Epoch 1
        Local
          2001:DB8:1:1::2 from 2001:DB8:1:1::2 (10.1.1.2)
            Origin incomplete, metric 0, localpref 100, valid, internal, best
            rx pathid: 0, tx pathid: 0x0
        Refresh Epoch 1
        Local
          ::FFFF:10.1.1.2 (inaccessible) from 10.1.1.2 (10.1.1.2)
            Origin incomplete, metric 0, localpref 100, valid, internal
            rx pathid: 0, tx pathid: 0
        BGP routing table entry for 2001:DB8:1:1::/64, version 5
        Paths: (3 available, best #1, table default)
        Advertised to update-groups:
           1         
        Refresh Epoch 1
        Local
          :: from 0.0.0.0 (10.1.1.1)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
            rx pathid: 0, tx pathid: 0x0
        Refresh Epoch 1
        Local
          2001:DB8:1:1::2 from 2001:DB8:1:1::2 (10.1.1.2)
            Origin incomplete, metric 0, localpref 100, valid, internal
            rx pathid: 0, tx pathid: 0
        Refresh Epoch 1
        Local
          ::FFFF:10.1.1.2 (inaccessible) from 10.1.1.2 (10.1.1.2)
            Origin incomplete, metric 0, localpref 100, valid, internal
            rx pathid: 0, tx pathid: 0

        For address family: VPNv4 Unicast


        Route Distinguisher: 100:100 (default for vrf VRF1)
        BGP routing table entry for 100:100:10.229.11.11/32, version 2
        Paths: (1 available, best #1, table VRF1)
        Not advertised to any peer
        Refresh Epoch 1
        Local
          0.0.0.0 (via vrf VRF1) from 0.0.0.0 (10.1.1.1)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
            rx pathid: 0, tx pathid: 0x0

        For address family: VPNv6 Unicast


        Route Distinguisher: 100:100 (default for vrf VRF1)
        BGP routing table entry for [100:100]2001:11:11::11/128, version 2
        Paths: (1 available, best #1, table VRF1)
        Not advertised to any peer
        Refresh Epoch 1
        Local
          :: (via vrf VRF1) from 0.0.0.0 (10.1.1.1)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
            rx pathid: 0, tx pathid: 0x0

        For address family: IPv4 Multicast


        For address family: L2VPN E-VPN


        For address family: VPNv4 Multicast
                

        For address family: MVPNv4 Unicast


        For address family: MVPNv6 Unicast


        For address family: VPNv6 Multicast


        For address family: VPNv4 Flowspec


        For address family: VPNv6 Flowspec
        '''}



    golden_parsed_output2 = {
      'instance':
        {'default':
          {'vrf':
            {'EVPN-BGP-Table':
              {'address_family':
                {'vpnv4 unicast RD 65535:1':
                  {'default_vrf': 'evpn1',
                   'prefixes':
                    {'10.1.1.0/17':
                      {'available_path': '1',
                       'best_path': '1',
                       'index':
                        {1:
                          {'evpn':
                            {'encap': '8',
                             'evpn_esi': '00000000000000000000',
                             'ext_community': 'RT:65535:1',
                             'gateway_address': '0.0.0.0',
                             'label': 30000,
                             'local_vtep': '10.21.33.33',
                             'router_mac': 'MAC:001E.7A13.E9BF'},
                          'gateway': '0.0.0.0',
                          'inaccessible': False,
                          'localpref': 100,
                          'metric': 0,
                          'next_hop': '0.0.0.0',
                          'next_hop_via': 'vrf '
                                          'evpn1',
                          'origin_codes': '?',
                          'originator': '10.21.33.33',
                          'recipient_pathid': '0',
                          'refresh_epoch': 1,
                          'route_info': 'Local',
                          'imported_path_from': 'base',
                          'status_codes': '*>',
                          'transfer_pathid': '0x0',
                          'weight': '32768'}},
                       'paths': '1 '
                                'available, '
                                'best '
                                '#1, '
                                'table '
                                'EVPN-BGP-Table',
                       'table_version': '4'},
                    '10.36.3.0/17':
                      {'available_path': '2',
                       'best_path': '1',
                       'index':
                        {1:
                          {'evpn':
                            {'encap': '8',
                             'evpn_esi': '00000000000000000000',
                             'ext_community': 'RT:65535:1',
                             'gateway_address': '0.0.0.0',
                             'label': 30000,
                             'local_vtep': '10.21.33.33',
                             'router_mac': 'MAC:001E.7A13.E9BF'},
                          'gateway': '0.0.0.0',
                          'inaccessible': False,
                          'localpref': 100,
                          'metric': 0,
                          'next_hop': '0.0.0.0',
                          'next_hop_via': 'vrf '
                                          'evpn1',
                          'origin_codes': '?',
                          'originator': '10.21.33.33',
                          'recipient_pathid': '0',
                          'refresh_epoch': 1,
                          'route_info': 'Local',
                          'imported_path_from': 'base',
                          'status_codes': '*>',
                          'transfer_pathid': '0x0',
                          'weight': '32768'},
                        2:
                          {'evpn':
                            {'encap': '8',
                             'evpn_esi': '00000000000000000000',
                             'ext_community': 'RT:65535:1',
                             'gateway_address': '0.0.0.0',
                             'label': 30000,
                             'local_vtep': '10.21.33.33',
                             'router_mac': 'MAC:001E.7A13.E9BF'},
                          'gateway': '10.36.3.254',
                          'inaccessible': False,
                          'localpref': 100,
                          'metric': 0,
                          'next_hop': '10.36.3.254',
                          'next_hop_via': 'vrf '
                                          'evpn1',
                          'origin_codes': '?',
                          'originator': '10.21.33.22',
                          'recipient_pathid': '0',
                          'transfer_pathid': '0',
                          'refresh_epoch': 1,
                          'route_info': '65530',
                          'imported_path_from': 'base',
                          'status_codes': '* '}},
                       'paths': '2 '
                                'available, '
                                'best '
                                '#1, '
                                'table '
                                'EVPN-BGP-Table',
                       'table_version': '3'}},
                    'route_distinguisher': '65535:1'}}},
                'evpn1':
                  {'address_family':
                    {'vpnv4 unicast RD 65535:1':
                      {'default_vrf': 'evpn1',
                       'prefixes':
                        {'10.1.1.0/24':
                          {'available_path': '1',
                           'best_path': '1',
                           'index':
                            {1:
                              {'gateway': '0.0.0.0',
                               'inaccessible': False,
                               'local_vxlan_vtep':
                                {'bdi': 'BDI200',
                                 'encap': '8',
                                 'local_router_mac': '001E.7A13.E9BF',
                                 'vni': '30000',
                                 'vrf': 'evpn1',
                                 'vtep_ip': '10.21.33.33'},
                               'localpref': 100,
                               'metric': 0,
                               'next_hop': '0.0.0.0',
                               'next_hop_via': 'vrf '
                                               'evpn1',
                               'origin_codes': '?',
                               'originator': '10.21.33.33',
                               'recipient_pathid': '0',
                               'refresh_epoch': 1,
                               'route_info': 'Local',
                               'status_codes': '*>',
                               'transfer_pathid': '0x0',
                               'update_group': 1,
                               'weight': '32768'}},
                       'paths': '1 '
                                'available, '
                                'best '
                                '#1, '
                                'table '
                                'evpn1',
                       'table_version': '5'},
                        '10.36.3.0/24':
                          {'available_path': '2',
                           'best_path': '2',
                           'index':
                            {1:
                              {'gateway': '10.36.3.254',
                               'inaccessible': False,
                               'local_vxlan_vtep':
                                {'bdi': 'BDI200',
                                 'encap': '8',
                                 'local_router_mac': '001E.7A13.E9BF',
                                 'vni': '30000',
                                 'vrf': 'evpn1',
                                 'vtep_ip': '10.21.33.33'},
                               'localpref': 100,
                               'metric': 0,
                               'next_hop': '10.36.3.254',
                               'next_hop_via': 'vrf '
                                               'evpn1',
                               'origin_codes': '?',
                               'originator': '10.21.33.22',
                               'recipient_pathid': '0',
                               'transfer_pathid': '0',
                               'refresh_epoch': 1,
                               'route_info': '65530',
                               'status_codes': '* ',
                               'update_group': 1},
                            2:
                              {'gateway': '0.0.0.0',
                               'inaccessible': False,
                               'local_vxlan_vtep':
                                {'bdi': 'BDI200',
                                 'encap': '8',
                                 'local_router_mac': '001E.7A13.E9BF',
                                 'vni': '30000',
                                 'vrf': 'evpn1',
                                 'vtep_ip': '10.21.33.33'},
                               'localpref': 100,
                               'metric': 0,
                               'next_hop': '0.0.0.0',
                               'next_hop_via': 'vrf '
                                               'evpn1',
                               'origin_codes': '?',
                               'originator': '10.21.33.33',
                               'recipient_pathid': '0',
                               'refresh_epoch': 1,
                               'route_info': 'Local',
                               'status_codes': '*>',
                               'transfer_pathid': '0x0',
                               'update_group': 1,
                               'weight': '32768'}},
                       'paths': '2 '
                                'available, '
                                'best '
                                '#2, '
                                'table '
                                'evpn1',
                       'table_version': '4'}},
                    'route_distinguisher': '65535:1'}}}}}}}

    golden_output2 = {'execute.return_value': '''
        R1_CE#show bgp all detail 
        For address family: IPv4 Unicast


        For address family: IPv6 Unicast


        For address family: VPNv4 Unicast


        Route Distinguisher: 65535:1 (default for vrf evpn1)
        BGP routing table entry for 65535:1:10.36.3.0/24, version 4
        Paths: (2 available, best #2, table evpn1)
        Advertised to update-groups:
           1         
        Refresh Epoch 1
        65530
          10.36.3.254 (via vrf evpn1) from 10.36.3.254 (10.21.33.22)
            Origin incomplete, metric 0, localpref 100, valid, external
            Local vxlan vtep:
              vrf:evpn1, vni:30000
              local router mac:001E.7A13.E9BF
              encap:8
              vtep-ip:10.21.33.33
              bdi:BDI200
            rx pathid: 0, tx pathid: 0
        Refresh Epoch 1
        Local
          0.0.0.0 (via vrf evpn1) from 0.0.0.0 (10.21.33.33)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
            Local vxlan vtep:
              vrf:evpn1, vni:30000
              local router mac:001E.7A13.E9BF
              encap:8
              vtep-ip:10.21.33.33
              bdi:BDI200
            rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 65535:1:10.1.1.0/24, version 5
        Paths: (1 available, best #1, table evpn1)
        Advertised to update-groups:
           1         
        Refresh Epoch 1
        Local
          0.0.0.0 (via vrf evpn1) from 0.0.0.0 (10.21.33.33)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
            Local vxlan vtep:
              vrf:evpn1, vni:30000
              local router mac:001E.7A13.E9BF
              encap:8
              vtep-ip:10.21.33.33
              bdi:BDI200
            rx pathid: 0, tx pathid: 0x0

        For address family: IPv4 Multicast


        For address family: L2VPN E-VPN


        Route Distinguisher: 65535:1 (default for vrf evpn1)
        BGP routing table entry for [5][65535:1][0][24][10.36.3.0]/17, version 3
        Paths: (2 available, best #1, table EVPN-BGP-Table)
        Not advertised to any peer
        Refresh Epoch 1
        Local, imported path from base
          0.0.0.0 (via vrf evpn1) from 0.0.0.0 (10.21.33.33)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, external, best
            EVPN ESI: 00000000000000000000, Gateway Address: 0.0.0.0, local vtep: 10.21.33.33, Label 30000
            Extended Community: RT:65535:1 ENCAP:8 Router MAC:001E.7A13.E9BF
            rx pathid: 0, tx pathid: 0x0
        Refresh Epoch 1
        65530, imported path from base
          10.36.3.254 (via vrf evpn1) from 10.36.3.254 (10.21.33.22)
            Origin incomplete, metric 0, localpref 100, valid, external
            EVPN ESI: 00000000000000000000, Gateway Address: 0.0.0.0, local vtep: 10.21.33.33, Label 30000
            Extended Community: RT:65535:1 ENCAP:8 Router MAC:001E.7A13.E9BF
            rx pathid: 0, tx pathid: 0
        BGP routing table entry for [5][65535:1][0][24][10.1.1.0]/17, version 4
        Paths: (1 available, best #1, table EVPN-BGP-Table)
        Not advertised to any peer
        Refresh Epoch 1
        Local, imported path from base
          0.0.0.0 (via vrf evpn1) from 0.0.0.0 (10.21.33.33)
            Origin incomplete, metric 0, localpref 100, weight 32768, valid, external, best
            EVPN ESI: 00000000000000000000, Gateway Address: 0.0.0.0, local vtep: 10.21.33.33, Label 30000
            Extended Community: RT:65535:1 ENCAP:8 Router MAC:001E.7A13.E9BF
            rx pathid: 0, tx pathid: 0x0

        For address family: VPNv4 Multicast


        For address family: MVPNv4 Unicast


        For address family: MVPNv6 Unicast


        For address family: VPNv4 Flowspec
        '''}

    golden_output3 = {'execute.return_value': '''
    BGP routing table entry for 65000:1:10.4.1.1/32, version 2
Paths: (1 available, best #1, table VRF1)
  Advertised to update-groups:
     1
  Refresh Epoch 1
  Local
    0.0.0.0 (via vrf VRF1) from 0.0.0.0 (10.4.1.1)
      Origin IGP, metric 0, localpref 100, weight 32768, valid, sourced, local, best
      Extended Community: Cost:pre-bestpath:128:1280 0x8800:32768:0
        0x8801:100:32 0x8802:65280:256 0x8803:65281:1514 0x8806:0:16843009
      rx pathid: 0, tx pathid: 0x0
    '''}
    golden_parsed_output3 = {
    'instance': {
        'default': {
            'vrf': {
                'VRF1': {
                    'address_family': {
                        'vpnv4 unicast': {
                        
                            'prefixes': {
                                '10.4.1.1/32': {
                                    'table_version': '2',
                                    'available_path': '1',
                                    'best_path': '1',
                                    'paths': '1 available, best #1, table VRF1',
                                    'index': {
                                        1: {
                                            'next_hop': '0.0.0.0',
                                            'gateway': '0.0.0.0',
                                            'originator': '10.4.1.1',
                                            'next_hop_via': 'vrf VRF1',
                                            'localpref': 100,
                                            'metric': 0,
                                            'weight': '32768',
                                            'origin_codes': 'i',
                                            'status_codes': '*>',
                                            'refresh_epoch': 1,
                                            'ext_community': 'Cost:pre-bestpath:128:1280 0x8800:32768:0',
                                            'route_info': 'Local',
                                            'recipient_pathid': '0',
                                            'transfer_pathid': '0x0',
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
    }
    def test_show_bgp_all_detail_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowBgpAllDetail(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_bgp_all_detail_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowBgpAllDetail(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output,self.golden_parsed_output1)

    def test_show_bgp_all_detail_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowBgpAllDetail(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output,self.golden_parsed_output2)

    def test_show_bgp_vrf_route_golden(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output3)
        obj = ShowBgpAllDetail(device=self.device)
        parsed_output = obj.parse(vrf='VRF1', route='10.4.1.1')
        self.assertEqual(parsed_output,self.golden_parsed_output3)

# ============================
# Unit test for:
#   * 'show ip bgp all detail'
# ============================
class test_show_ip_bgp_all_detail(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'instance': 
            {'default': 
                {'vrf': 
                    {'VRF100': 
                        {'address_family': 
                            {'vpnv4 unicast RD 65000:100': 
                                {'default_vrf': 'VRF100',
                                'prefixes': {'192.168.111.0/24': {'available_path': '1',
                                                                 'best_path': '1',
                                                                 'index': {1: {'ext_community': 'RT:65000:100',
                                                                               'gateway': '0.0.0.0',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '172.16.111.2',
                                                                               'next_hop_via': 'vrf '
                                                                                               'VRF100',
                                                                               'origin_codes': '?',
                                                                               'originator': '10.5.5.5',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': 'Local',
                                                                               'status_codes': '*>',
                                                                               'transfer_pathid': '0x0',
                                                                               'weight': '32768'}},
                                                                 'paths': '1 '
                                                                          'available, '
                                                                          'best '
                                                                          '#1, '
                                                                          'table '
                                                                          'VRF100',
                                                                 'table_version': '2'},
                                            '192.168.112.0/24': {'available_path': '1',
                                                                 'best_path': '1',
                                                                 'index': {1: {'ext_community': 'RT:65000:100',
                                                                               'gateway': '172.17.111.2',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '172.17.111.2',
                                                                               'next_hop_via': 'vrf '
                                                                                               'VRF100',
                                                                               'origin_codes': 'i',
                                                                               'originator': '172.16.1.209',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': '65001',
                                                                               'status_codes': '*>',
                                                                               'transfer_pathid': '0x0',
                                                                               'update_group': 3}},
                                                                 'paths': '1 '
                                                                          'available, '
                                                                          'best '
                                                                          '#1, '
                                                                          'table '
                                                                          'VRF100',
                                                                 'table_version': '3'},
                                            '192.168.121.0/24': {'available_path': '2',
                                                                 'best_path': '2',
                                                                 'index': {1: {'cluster_list': '10.2.2.2',
                                                                               'ext_community': 'RT:65000:100',
                                                                               'gateway': '10.2.2.2',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '10.6.6.6',
                                                                               'next_hop_igp_metric': '4',
                                                                               'next_hop_via': 'default',
                                                                               'origin_codes': '?',
                                                                               'originator': '10.2.2.2',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': 'Local',
                                                                               'status_codes': '* '
                                                                                               'i',
                                                                               'transfer_pathid': '0',
                                                                               'update_group': 1},
                                                                           2: {'cluster_list': '10.1.1.1',
                                                                               'ext_community': 'RT:65000:100',
                                                                               'gateway': '10.1.1.1',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '10.6.6.6',
                                                                               'next_hop_igp_metric': '4',
                                                                               'next_hop_via': 'default',
                                                                               'origin_codes': '?',
                                                                               'originator': '10.1.1.1',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': 'Local',
                                                                               'status_codes': '*>',
                                                                               'transfer_pathid': '0x0',
                                                                               'update_group': 1}},
                                                                 'paths': '2 '
                                                                          'available, '
                                                                          'best '
                                                                          '#2, '
                                                                          'table '
                                                                          'VRF100',
                                                                 'table_version': '10'},
                                            '192.168.122.0/24': {'available_path': '2',
                                                                 'best_path': '2',
                                                                 'index': {1: {'cluster_list': '10.2.2.2',
                                                                               'ext_community': 'RT:65000:100',
                                                                               'gateway': '10.2.2.2',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '10.6.6.6',
                                                                               'next_hop_igp_metric': '4',
                                                                               'next_hop_via': 'default',
                                                                               'origin_codes': 'i',
                                                                               'originator': '10.2.2.2',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': '65001',
                                                                               'status_codes': '* '
                                                                                               'i',
                                                                               'transfer_pathid': '0',
                                                                               'update_group': 1},
                                                                           2: {'cluster_list': '10.1.1.1',
                                                                               'ext_community': 'RT:65000:100',
                                                                               'gateway': '10.1.1.1',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '10.6.6.6',
                                                                               'next_hop_igp_metric': '4',
                                                                               'next_hop_via': 'default',
                                                                               'origin_codes': 'i',
                                                                               'originator': '10.1.1.1',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': '65001',
                                                                               'status_codes': '*>',
                                                                               'transfer_pathid': '0x0',
                                                                               'update_group': 1}},
                                                                 'paths': '2 '
                                                                          'available, '
                                                                          'best '
                                                                          '#2, '
                                                                          'table '
                                                                          'VRF100',
                                                                 'table_version': '11'}},
                            'route_distinguisher': '65000:100'}}},
                    'VRF200': 
                        {'address_family': 
                            {'vpnv4 unicast RD 65000:200': 
                                {'default_vrf': 'VRF200',
                                'prefixes': {'192.168.211.0/24': {'available_path': '1',
                                                                 'best_path': '1',
                                                                 'index': {1: {'ext_community': 'RT:65000:200',
                                                                               'gateway': '0.0.0.0',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '172.16.211.2',
                                                                               'next_hop_via': 'vrf '
                                                                                               'VRF200',
                                                                               'origin_codes': '?',
                                                                               'originator': '10.5.5.5',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': 'Local',
                                                                               'status_codes': '*>',
                                                                               'transfer_pathid': '0x0',
                                                                               'weight': '32768'}},
                                                                 'paths': '1 '
                                                                          'available, '
                                                                          'best '
                                                                          '#1, '
                                                                          'table '
                                                                          'VRF200',
                                                                 'table_version': '4'},
                                            '192.168.212.0/24': {'available_path': '1',
                                                                 'best_path': '1',
                                                                 'index': {1: {'ext_community': 'RT:65000:200',
                                                                               'gateway': '172.17.211.2',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '172.17.211.2',
                                                                               'next_hop_via': 'vrf '
                                                                                               'VRF200',
                                                                               'origin_codes': 'i',
                                                                               'originator': '172.16.1.209',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': '65001',
                                                                               'status_codes': '*>',
                                                                               'transfer_pathid': '0x0',
                                                                               'update_group': 3}},
                                                                 'paths': '1 '
                                                                          'available, '
                                                                          'best '
                                                                          '#1, '
                                                                          'table '
                                                                          'VRF200',
                                                                 'table_version': '5'},
                                            '192.168.221.0/24': {'available_path': '2',
                                                                 'best_path': '2',
                                                                 'index': {1: {'cluster_list': '10.2.2.2',
                                                                               'ext_community': 'RT:65000:200',
                                                                               'gateway': '10.2.2.2',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '10.6.6.6',
                                                                               'next_hop_igp_metric': '4',
                                                                               'next_hop_via': 'default',
                                                                               'origin_codes': '?',
                                                                               'originator': '10.2.2.2',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': 'Local',
                                                                               'status_codes': '* '
                                                                                               'i',
                                                                               'transfer_pathid': '0',
                                                                               'update_group': 2},
                                                                           2: {'cluster_list': '10.1.1.1',
                                                                               'ext_community': 'RT:65000:200',
                                                                               'gateway': '10.1.1.1',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '10.6.6.6',
                                                                               'next_hop_igp_metric': '4',
                                                                               'next_hop_via': 'default',
                                                                               'origin_codes': '?',
                                                                               'originator': '10.1.1.1',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': 'Local',
                                                                               'status_codes': '*>',
                                                                               'transfer_pathid': '0x0',
                                                                               'update_group': 2}},
                                                                 'paths': '2 '
                                                                          'available, '
                                                                          'best '
                                                                          '#2, '
                                                                          'table '
                                                                          'VRF200',
                                                                 'table_version': '12'},
                                            '192.168.222.0/24': {'available_path': '2',
                                                                 'best_path': '2',
                                                                 'index': {1: {'cluster_list': '10.2.2.2',
                                                                               'ext_community': 'RT:65000:200',
                                                                               'gateway': '10.2.2.2',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '10.6.6.6',
                                                                               'next_hop_igp_metric': '4',
                                                                               'next_hop_via': 'default',
                                                                               'origin_codes': 'i',
                                                                               'originator': '10.2.2.2',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': '65001',
                                                                               'status_codes': '* '
                                                                                               'i',
                                                                               'transfer_pathid': '0',
                                                                               'update_group': 2},
                                                                           2: {'cluster_list': '10.1.1.1',
                                                                               'ext_community': 'RT:65000:200',
                                                                               'gateway': '10.1.1.1',
                                                                               'inaccessible': False,
                                                                               'localpref': 100,
                                                                               'metric': 0,
                                                                               'next_hop': '10.6.6.6',
                                                                               'next_hop_igp_metric': '4',
                                                                               'next_hop_via': 'default',
                                                                               'origin_codes': 'i',
                                                                               'originator': '10.1.1.1',
                                                                               'recipient_pathid': '0',
                                                                               'refresh_epoch': 1,
                                                                               'route_info': '65001',
                                                                               'status_codes': '*>',
                                                                               'transfer_pathid': '0x0',
                                                                               'update_group': 2}},
                                                                 'paths': '2 '
                                                                          'available, '
                                                                          'best '
                                                                          '#2, '
                                                                          'table '
                                                                          'VRF200',
                                                                 'table_version': '13'}},
                            'route_distinguisher': '65000:200'}}}}}}}

    golden_output1 = {'execute.return_value': '''
        [2019-03-28 14:35:41,189] +++ PE1: executing command 'show ip bgp all detail' +++
        show ip bgp all detail
        For address family: IPv4 Unicast


        For address family: IPv6 Unicast


        For address family: VPNv4 Unicast


        Route Distinguisher: 65000:100 (default for vrf VRF100)
        BGP routing table entry for 65000:100:192.168.111.0/24, version 2
          Paths: (1 available, best #1, table VRF100)
          Advertised to update-groups:
             1          3
          Refresh Epoch 1
          Local
            172.16.111.2 (via vrf VRF100) from 0.0.0.0 (10.5.5.5)
              Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
              Extended Community: RT:65000:100
              mpls labels in/out 28/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 65000:100:192.168.112.0/24, version 3
          Paths: (1 available, best #1, table VRF100)
          Advertised to update-groups:
             3
          Refresh Epoch 1
          65001
            172.17.111.2 (via vrf VRF100) from 172.17.111.2 (172.16.1.209)
              Origin IGP, metric 0, localpref 100, valid, external, best
              Extended Community: RT:65000:100
              mpls labels in/out 29/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 65000:100:192.168.121.0/24, version 10
          Paths: (2 available, best #2, table VRF100)
          Flag: 0x100
          Advertised to update-groups:
             1
          Refresh Epoch 1
          Local
            10.6.6.6 (metric 4) (via default) from 10.2.2.2 (10.2.2.2)
              Origin incomplete, metric 0, localpref 100, valid, internal
              Extended Community: RT:65000:100
              Originator: 10.6.6.6, Cluster list: 10.2.2.2
              mpls labels in/out nolabel/28
              rx pathid: 0, tx pathid: 0
          Refresh Epoch 1
          Local
            10.6.6.6 (metric 4) (via default) from 10.1.1.1 (10.1.1.1)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: RT:65000:100
              Originator: 10.6.6.6, Cluster list: 10.1.1.1
              mpls labels in/out nolabel/28
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 65000:100:192.168.122.0/24, version 11
          Paths: (2 available, best #2, table VRF100)
          Flag: 0x100
          Advertised to update-groups:
             1
          Refresh Epoch 1
          65001
            10.6.6.6 (metric 4) (via default) from 10.2.2.2 (10.2.2.2)
              Origin IGP, metric 0, localpref 100, valid, internal
              Extended Community: RT:65000:100
              Originator: 10.6.6.6, Cluster list: 10.2.2.2
              mpls labels in/out nolabel/30
              rx pathid: 0, tx pathid: 0
          Refresh Epoch 1
          65001
            10.6.6.6 (metric 4) (via default) from 10.1.1.1 (10.1.1.1)
              Origin IGP, metric 0, localpref 100, valid, internal, best
              Extended Community: RT:65000:100
              Originator: 10.6.6.6, Cluster list: 10.1.1.1
              mpls labels in/out nolabel/30
              rx pathid: 0, tx pathid: 0x0

        Route Distinguisher: 65000:200 (default for vrf VRF200)
        BGP routing table entry for 65000:200:192.168.211.0/24, version 4
          Paths: (1 available, best #1, table VRF200)
          Advertised to update-groups:
             2          3
          Refresh Epoch 1
          Local
            172.16.211.2 (via vrf VRF200) from 0.0.0.0 (10.5.5.5)
              Origin incomplete, metric 0, localpref 100, weight 32768, valid, sourced, best
              Extended Community: RT:65000:200
              mpls labels in/out 30/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 65000:200:192.168.212.0/24, version 5
          Paths: (1 available, best #1, table VRF200)
          Advertised to update-groups:
             3
          Refresh Epoch 1
          65001
            172.17.211.2 (via vrf VRF200) from 172.17.211.2 (172.16.1.209)
              Origin IGP, metric 0, localpref 100, valid, external, best
              Extended Community: RT:65000:200
              mpls labels in/out 31/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 65000:200:192.168.221.0/24, version 12
          Paths: (2 available, best #2, table VRF200)
          Flag: 0x100
          Advertised to update-groups:
             2
          Refresh Epoch 1
          Local
            10.6.6.6 (metric 4) (via default) from 10.2.2.2 (10.2.2.2)
              Origin incomplete, metric 0, localpref 100, valid, internal
              Extended Community: RT:65000:200
              Originator: 10.6.6.6, Cluster list: 10.2.2.2
              mpls labels in/out nolabel/29
              rx pathid: 0, tx pathid: 0
          Refresh Epoch 1
          Local
            10.6.6.6 (metric 4) (via default) from 10.1.1.1 (10.1.1.1)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: RT:65000:200
              Originator: 10.6.6.6, Cluster list: 10.1.1.1
              mpls labels in/out nolabel/29
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 65000:200:192.168.222.0/24, version 13
          Paths: (2 available, best #2, table VRF200)
          Flag: 0x100
          Advertised to update-groups:
             2
          Refresh Epoch 1
          65001
            10.6.6.6 (metric 4) (via default) from 10.2.2.2 (10.2.2.2)
              Origin IGP, metric 0, localpref 100, valid, internal
              Extended Community: RT:65000:200
              Originator: 10.6.6.6, Cluster list: 10.2.2.2
              mpls labels in/out nolabel/31
              rx pathid: 0, tx pathid: 0
          Refresh Epoch 1
          65001
            10.6.6.6 (metric 4) (via default) from 10.1.1.1 (10.1.1.1)
              Origin IGP, metric 0, localpref 100, valid, internal, best
              Extended Community: RT:65000:200
              Originator: 10.6.6.6, Cluster list: 10.1.1.1
              mpls labels in/out nolabel/31
              rx pathid: 0, tx pathid: 0x0

        For address family: IPv4 Multicast


        For address family: L2VPN E-VPN


        For address family: VPNv4 Multicast


        For address family: MVPNv4 Unicast


        For address family: MVPNv6 Unicast


        For address family: VPNv4 Flowspec

        PE1#
        '''}

    golden_parsed_output2 = {
    'instance': {
        'default': {
            'vrf': {
                'blue': {
                    'address_family': {
                        'vpnv4': {
                            'prefixes': {
                                '10.144.0.0/24': {
                                    'table_version': '88',
                                    'available_path': '4',
                                    'best_path': '1',
                                    'paths': '4 available, best #1, table blue',
                                    'index': {
                                        1: {
                                            'next_hop': '10.3.3.3',
                                            'gateway': '10.6.6.6',
                                            'originator': '10.6.6.6',
                                            'next_hop_igp_metric': '21',
                                            'localpref': 200,
                                            'metric': 0,
                                            'origin_codes': '?',
                                            'status_codes': '*>',
                                            'ext_community': 'RT:12:23',
                                            },
                                        2: {
                                            'next_hop': '10.13.13.13',
                                            'gateway': '10.13.13.13',
                                            'originator': '10.0.0.2',
                                            'next_hop_via': 'green',
                                            'localpref': 100,
                                            'metric': 0,
                                            'origin_codes': '?',
                                            'status_codes': '* ',
                                            'ext_community': 'RT:12:23 ',
                                            'recursive_via_connected': True,
                                            },
                                        3: {
                                            'next_hop': '10.3.3.3',
                                            'gateway': '10.7.7.7',
                                            'originator': '10.7.7.7',
                                            'next_hop_igp_metric': '21',
                                            'localpref': 200,
                                            'metric': 0,
                                            'origin_codes': '?',
                                            'status_codes': '* i',
                                            'ext_community': 'RT:12:23',
                                            },
                                        4: {
                                            'next_hop': '10.11.11.11',
                                            'gateway': '10.11.11.11',
                                            'originator': '10.1.0.1',
                                            'ext_community': 'RT:11:12 ',
                                            'recursive_via_connected': True,
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
    }
    golden_output2 = {'execute.return_value': '''
       BGP routing table entry for 10:12:10.144.0.0/24, version 88
    Paths: (4 available, best #1, table blue)
      Additional-path
      Advertised to update-groups:
         6
      1, imported path from 12:23:10.144.0.0/24
        10.3.3.3 (metric 21) from 10.6.6.6 (10.6.6.6)
          Origin incomplete, metric 0, localpref 200, valid, internal, best
          Extended Community: RT:12:23
          Originator: 10.3.3.3, Cluster list: 10.0.0.1 , recursive-via-host
          mpls labels in/out nolabel/37
      1, imported path from 12:23:10.144.0.0/24
        10.13.13.13 (via green) from 10.13.13.13 (10.0.0.2)
          Origin incomplete, metric 0, localpref 100, valid, external
          Extended Community: RT:12:23 , recursive-via-connected
      1, imported path from 12:23:10.144.0.0/24
        10.3.3.3 (metric 21) from 10.7.7.7 (10.7.7.7)
          Origin incomplete, metric 0, localpref 200, valid, internal
          Extended Community: RT:12:23
          Originator: 10.3.3.3, Cluster list: 10.0.0.1 , recursive-via-host
          mpls labels in/out nolabel/37
      1
        10.11.11.11 from 10.11.11.11 (10.1.0.1)
          Origin incomplete, metric 0, localpref 100, valid, external, backup/repair
          Extended Community: RT:11:12 , recursive-via-connected
    '''}

    def test_show_ip_bgp_all_detail_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowIpBgpAllDetail(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_ip_bgp_all_detail_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowIpBgpAllDetail(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output,self.golden_parsed_output1)

    def test_show_ip_bgp_vrf_route_golden(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowIpBgpAllDetail(device=self.device)
        parsed_output = obj.parse(vrf='blue', 
                route='10.0.0.0', address_family='vpnv4')
        self.assertEqual(parsed_output,self.golden_parsed_output2)


# ===============================================
# Unit test for:
#   * 'show bgp {address_family} rd {rd} detail'
# ===============================================
class test_show_bgp_detail(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'instance': 
            {'default': 
                {'vrf': 
                    {'L2VPN-VPLS-BGP-Table': 
                        {'address_family': 
                            {'l2vpn vpls': 
                                {'default_vrf': 'None',
                                'prefixes': 
                                    {'VEID-1:Blk-1/136,': 
                                        {'available_path': '2',
                                        'best_path': '1',
                                        'index': 
                                            {1: 
                                                {'agi_version': 0,
                                                'cluster_list': '0.0.0.61',
                                                'ext_community': 'RT:0:3051 RT:5918:3051 L2VPN L2:0x0:MTU-1500',
                                                'gateway': '192.168.165.119',
                                                'label_base': 16,
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '192.168.165.220',
                                                'next_hop_igp_metric': '66536',
                                                'origin_codes': '?',
                                                'originator': '192.168.165.119',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 7,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0',
                                                've_block_size': 10},
                                            2: 
                                                {'agi_version': 0,
                                                'cluster_list': '0.0.0.61',
                                                'ext_community': 'RT:0:3051 RT:5918:3051 L2VPN L2:0x0:MTU-1500',
                                                'gateway': '192.168.165.120',
                                                'label_base': 16,
                                                'localpref': 100,
                                                'metric': 0,
                                                'next_hop': '192.168.165.220',
                                                'next_hop_igp_metric': '66536',
                                                'origin_codes': '?',
                                                'originator': '192.168.165.120',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 9,
                                                'route_info': 'Local',
                                                'status_codes': '* '
                                                                'i',
                                                'transfer_pathid': '0',
                                                've_block_size': 10}},
                                        'paths': '2 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'L2VPN-VPLS-BGP-Table',
                                        'table_version': '2'},
                                    'VEID-2:Blk-1/136,': 
                                        {'available_path': '1',
                                        'best_path': '1',
                                        'index': 
                                            {1: 
                                                {'agi_version': 0,
                                                'ext_community': 'RT:0:3051 RT:5918:3051 L2VPN L2:0x0:MTU-1500',
                                                'gateway': '0.0.0.0',
                                                'label_base': 1026,
                                                'localpref': 100,
                                                'next_hop': '0.0.0.0',
                                                'origin_codes': '?',
                                                'originator': '10.169.197.254',
                                                'recipient_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'status_codes': '*>',
                                                'transfer_pathid': '0x0',
                                                'update_group': 4,
                                                'weight': '32768',
                                                've_block_size': 10}},
                                        'paths': '1 '
                                                 'available, '
                                                 'best '
                                                 '#1, '
                                                 'table '
                                                 'L2VPN-VPLS-BGP-Table',
                                        'table_version': '304'}},
                                'route_distinguisher': '5918:3051'}}}}}}}

    golden_output1 = {'execute.return_value': '''
        Router#show bgp l2vpn vpls rd 5918:3051 detail
        Load for five secs: 29%/0%; one minute: 7%; five minutes: 5%
        Time source is NTP, 16:31:16.271 EST Tue Jun 8 2016

        Route Distinguisher: 5918:3051
        BGP routing table entry for 5918:3051:VEID-1:Blk-1/136, version 2
          Paths: (2 available, best #1, table L2VPN-VPLS-BGP-Table)
          Not advertised to any peer
          Refresh Epoch 7
          Local
            192.168.165.220 (metric 66536) from 192.168.165.119 (192.168.165.119)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              AGI version(0), VE Block Size(10) Label Base(16)
              Extended Community: RT:0:3051 RT:5918:3051 L2VPN L2:0x0:MTU-1500
              Originator: 192.168.165.220, Cluster list: 0.0.0.61
              mpls labels in/out exp-null/16
              rx pathid: 0, tx pathid: 0x0
          Refresh Epoch 9
          Local
            192.168.165.220 (metric 66536) from 192.168.165.120 (192.168.165.120)
              Origin incomplete, metric 0, localpref 100, valid, internal
              AGI version(0), VE Block Size(10) Label Base(16)
              Extended Community: RT:0:3051 RT:5918:3051 L2VPN L2:0x0:MTU-1500
              Originator: 192.168.165.220, Cluster list: 0.0.0.61
              mpls labels in/out exp-null/16
              rx pathid: 0, tx pathid: 0
        BGP routing table entry for 5918:3051:VEID-2:Blk-1/136, version 304
          Paths: (1 available, best #1, table L2VPN-VPLS-BGP-Table)
          Advertised to update-groups:
             4
          Refresh Epoch 1
          Local
            0.0.0.0 from 0.0.0.0 (10.169.197.254)
              Origin incomplete, localpref 100, weight 32768, valid, sourced, local, best
              AGI version(0), VE Block Size(10) Label Base(1026)
              Extended Community: RT:0:3051 RT:5918:3051 L2VPN L2:0x0:MTU-1500
              mpls labels in/out exp-null/1026
              rx pathid: 0, tx pathid: 0x0
        '''}

    def test_show_bgp_detail_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowBgpDetail(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_bgp_detail_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowBgpDetail(device=self.device)
        parsed_output = obj.parse(address_family='l2vpn vpls', rd='5918:3051')
        self.assertEqual(parsed_output,self.golden_parsed_output1)


# ====================================================
# Unit test for:
#   * 'show ip bgp {address_family} rd {rd} detail'
#   * 'show ip bgp {address_family} vrf {vrf} detail'
#   * 'show ip bgp {address_family} rd {rd} {route}'
# ====================================================
class test_show_ip_bgp_detail(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'instance': 
            {'default': 
                {'vrf': 
                    {'default': 
                        {'address_family': 
                            {'vpnv4': 
                                {'default_vrf': 'None',
                                'prefixes': 
                                    {'10.4.1.0/24': {'available_path': '1',
                                                   'best_path': '1',
                                                   'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                 'gateway': '10.169.197.254',
                                                                 'localpref': 100,
                                                                 'metric': 0,
                                                                 'next_hop': '10.169.197.254',
                                                                 'next_hop_igp_metric': '1002',
                                                                 'next_hop_via': 'default',
                                                                 'origin_codes': '?',
                                                                 'originator': '10.169.197.254',
                                                                 'recipient_pathid': '0',
                                                                 'refresh_epoch': 2,
                                                                 'route_info': '62000',
                                                                 'route_status': 'Received from a RR-client',
                                                                 'status_codes': '*>',
                                                                 'transfer_pathid': '0x0',
                                                                 'update_group': [38, 44, 45]}},
                                                   'paths': '1 '
                                                            'available, '
                                                            'best '
                                                            '#1, '
                                                            'no '
                                                            'table',
                                                   'table_version': '29454065'},
                                    '10.44.105.0/24': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                     'gateway': '10.169.197.254',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '10.169.197.254',
                                                                     'next_hop_igp_metric': '1002',
                                                                     'next_hop_via': 'default',
                                                                     'origin_codes': '?',
                                                                     'originator': '10.169.197.254',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 2,
                                                                     'route_info': '62000',
                                                                     'route_status': 'Received from a RR-client',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0',
                                                                     'update_group': [38, 44, 45]}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'no '
                                                                'table',
                                                       'table_version': '29454066'},
                                    '172.16.100.1/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'community': '62000:1',
                                                                      'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454165'},
                                    '172.16.100.10/32': {'available_path': '1',
                                                         'best_path': '1',
                                                         'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                       'gateway': '10.169.197.254',
                                                                       'localpref': 100,
                                                                       'metric': 0,
                                                                       'next_hop': '10.169.197.254',
                                                                       'next_hop_igp_metric': '1002',
                                                                       'next_hop_via': 'default',
                                                                       'origin_codes': '?',
                                                                       'originator': '10.169.197.254',
                                                                       'recipient_pathid': '0',
                                                                       'refresh_epoch': 2,
                                                                       'route_info': '62000',
                                                                       'route_status': 'Received from a RR-client',
                                                                       'status_codes': '*>',
                                                                       'transfer_pathid': '0x0',
                                                                       'update_group': [38, 44, 45]}},
                                                         'paths': '1 '
                                                                  'available, '
                                                                  'best '
                                                                  '#1, '
                                                                  'no '
                                                                  'table',
                                                         'table_version': '29454074'},
                                    '172.16.100.11/32': {'available_path': '1',
                                                         'best_path': '1',
                                                         'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                       'gateway': '10.169.197.254',
                                                                       'localpref': 100,
                                                                       'metric': 0,
                                                                       'next_hop': '10.169.197.254',
                                                                       'next_hop_igp_metric': '1002',
                                                                       'next_hop_via': 'default',
                                                                       'origin_codes': '?',
                                                                       'originator': '10.169.197.254',
                                                                       'recipient_pathid': '0',
                                                                       'refresh_epoch': 2,
                                                                       'route_info': '62000',
                                                                       'route_status': 'Received from a RR-client',
                                                                       'status_codes': '*>',
                                                                       'transfer_pathid': '0x0',
                                                                       'update_group': [38, 44, 45]}},
                                                         'paths': '1 '
                                                                  'available, '
                                                                  'best '
                                                                  '#1, '
                                                                  'no '
                                                                  'table',
                                                         'table_version': '29454075'},
                                    '172.16.100.12/32': {'available_path': '1',
                                                         'best_path': '1',
                                                         'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                       'gateway': '10.169.197.254',
                                                                       'localpref': 100,
                                                                       'metric': 0,
                                                                       'next_hop': '10.169.197.254',
                                                                       'next_hop_igp_metric': '1002',
                                                                       'next_hop_via': 'default',
                                                                       'origin_codes': '?',
                                                                       'originator': '10.169.197.254',
                                                                       'recipient_pathid': '0',
                                                                       'refresh_epoch': 2,
                                                                       'route_info': '62000',
                                                                       'route_status': 'Received from a RR-client',
                                                                       'status_codes': '*>',
                                                                       'transfer_pathid': '0x0',
                                                                       'update_group': [38, 44, 45]}},
                                                         'paths': '1 '
                                                                  'available, '
                                                                  'best '
                                                                  '#1, '
                                                                  'no '
                                                                  'table',
                                                         'table_version': '29454076'},
                                    '172.16.100.13/32': {'available_path': '1',
                                                         'best_path': '1',
                                                         'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                       'gateway': '10.169.197.254',
                                                                       'localpref': 100,
                                                                       'metric': 0,
                                                                       'next_hop': '10.169.197.254',
                                                                       'next_hop_igp_metric': '1002',
                                                                       'next_hop_via': 'default',
                                                                       'origin_codes': '?',
                                                                       'originator': '10.169.197.254',
                                                                       'recipient_pathid': '0',
                                                                       'refresh_epoch': 2,
                                                                       'route_info': '62000',
                                                                       'route_status': 'Received from a RR-client',
                                                                       'status_codes': '*>',
                                                                       'transfer_pathid': '0x0',
                                                                       'update_group': [38, 44, 45]}},
                                                         'paths': '1 '
                                                                  'available, '
                                                                  'best '
                                                                  '#1, '
                                                                  'no '
                                                                  'table',
                                                         'table_version': '29454077'},
                                    '172.16.100.2/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'community': '62000:2',
                                                                      'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454166'},
                                    '172.16.100.3/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454067'},
                                    '172.16.100.4/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454068'},
                                    '172.16.100.5/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454069'},
                                    '172.16.100.6/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454070'},
                                    '172.16.100.7/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454071'},
                                    '172.16.100.8/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454072'},
                                    '172.16.100.9/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'SoO:5918:999 RT:5918:50',
                                                                      'gateway': '10.169.197.254',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '10.169.197.254',
                                                                      'next_hop_igp_metric': '1002',
                                                                      'next_hop_via': 'default',
                                                                      'origin_codes': '?',
                                                                      'originator': '10.169.197.254',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 2,
                                                                      'route_info': '62000',
                                                                      'route_status': 'Received from a RR-client',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': [38, 44, 45]}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'no '
                                                                 'table',
                                                        'table_version': '29454073'}},
                               'route_distinguisher': '5918:50'}}}}}}}

    golden_output1 = {'execute.return_value': '''
        RR-1_ASR-1001X#show ip bgp vpnv4 rd 5918:50 detail

        Route Distinguisher: 5918:50
        BGP routing table entry for 5918:50:10.4.1.0/24, version 29454065
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/11438
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:10.44.105.0/24, version 29454066
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/2903
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.1/32, version 29454165
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Community: 62000:1
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/6197
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.2/32, version 29454166
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Community: 62000:2
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/6195
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.3/32, version 29454067
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/14750
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.4/32, version 29454068
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/21290
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.5/32, version 29454069
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/22401
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.6/32, version 29454070
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/22381
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.7/32, version 29454071
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/22358
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.8/32, version 29454072
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/19297
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.9/32, version 29454073
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/19294
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.10/32, version 29454074
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/19273
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.11/32, version 29454075
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/19255
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.12/32, version 29454076
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/17920
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.13/32, version 29454077
          Paths: (1 available, best #1, no table)
          Advertised to update-groups:
             38         44         45        
          Refresh Epoch 2
          62000, (Received from a RR-client)
            10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
              Origin incomplete, metric 0, localpref 100, valid, internal, best
              Extended Community: SoO:5918:999 RT:5918:50
              mpls labels in/out nolabel/15114
              rx pathid: 0, tx pathid: 0x0
        RR-1_ASR-1001X#
        '''}

    golden_parsed_output2 = {
        'instance': 
            {'default': 
                {'vrf': 
                    {'L3VPN-0050': 
                        {'address_family': 
                            {'vpnv4': 
                                {'default_vrf': 'L3VPN-0050',
                                'prefixes': 
                                    {'10.4.1.0/24': {'available_path': '1',
                                                    'best_path': '1',
                                                    'index': {1: {'ext_community': 'RT:5918:50',
                                                                'gateway': '192.168.10.253',
                                                                'localpref': 100,
                                                                'metric': 0,
                                                                'next_hop': '192.168.10.253',
                                                                'next_hop_via': 'vrf '
                                                                                'L3VPN-0050',
                                                                'origin_codes': '?',
                                                                'originator': '192.168.10.253',
                                                                'recipient_pathid': '0',
                                                                'refresh_epoch': 1,
                                                                'route_info': '62000',
                                                                'status_codes': '*>',
                                                                'transfer_pathid': '0x0',
                                                                'update_group': 724}},
                                                    'paths': '1 '
                                                           'available, '
                                                           'best '
                                                           '#1, '
                                                           'table '
                                                           'L3VPN-0050',
                                                    'table_version': '16933597'},
                                    '10.44.105.0/24': {'available_path': '1',
                                                      'best_path': '1',
                                                      'index': {1: {'ext_community': 'RT:5918:50',
                                                                    'gateway': '192.168.10.253',
                                                                    'localpref': 100,
                                                                    'metric': 0,
                                                                    'next_hop': '192.168.10.253',
                                                                    'next_hop_via': 'vrf '
                                                                                    'L3VPN-0050',
                                                                    'origin_codes': '?',
                                                                    'originator': '192.168.10.253',
                                                                    'recipient_pathid': '0',
                                                                    'refresh_epoch': 1,
                                                                    'route_info': '62000',
                                                                    'status_codes': '*>',
                                                                    'transfer_pathid': '0x0',
                                                                    'update_group': 724}},
                                                      'paths': '1 '
                                                               'available, '
                                                               'best '
                                                               '#1, '
                                                               'table '
                                                               'L3VPN-0050',
                                                      'table_version': '16933498'},
                                    '172.16.100.10/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933541'},
                                    '172.16.100.11/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933540'},
                                    '172.16.100.12/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933539'},
                                    '172.16.100.13/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933538'},
                                    '172.16.100.14/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933537'},
                                    '172.16.100.15/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933536'},
                                    '172.16.100.16/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933551'},
                                    '172.16.100.17/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933550'},
                                    '172.16.100.18/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933549'},
                                    '172.16.100.19/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933548'},
                                    '172.16.100.2/32': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'community': '62000:2',
                                                                     'ext_community': 'RT:5918:50',
                                                                     'gateway': '192.168.10.253',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '192.168.10.253',
                                                                     'next_hop_via': 'vrf '
                                                                                     'L3VPN-0050',
                                                                     'origin_codes': '?',
                                                                     'originator': '192.168.10.253',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 1,
                                                                     'route_info': '62000',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0'}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'table '
                                                                'L3VPN-0050',
                                                       'table_version': '16933598'},
                                    '172.16.100.20/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933547'},
                                    '172.16.100.21/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933546'},
                                    '172.16.100.22/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933545'},
                                    '172.16.100.23/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933544'},
                                    '172.16.100.24/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933559'},
                                    '172.16.100.25/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933558'},
                                    '172.16.100.26/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933557'},
                                    '172.16.100.27/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933556'},
                                    '172.16.100.28/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933555'},
                                    '172.16.100.29/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933554'},
                                    '172.16.100.3/32': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'ext_community': 'RT:5918:50',
                                                                     'gateway': '192.168.10.253',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '192.168.10.253',
                                                                     'next_hop_via': 'vrf '
                                                                                     'L3VPN-0050',
                                                                     'origin_codes': '?',
                                                                     'originator': '192.168.10.253',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 1,
                                                                     'route_info': '62000',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0',
                                                                     'update_group': 724}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'table '
                                                                'L3VPN-0050',
                                                       'table_version': '16933535'},
                                    '172.16.100.30/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933553'},
                                    '172.16.100.31/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933552'},
                                    '172.16.100.32/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933506'},
                                    '172.16.100.33/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933505'},
                                    '172.16.100.34/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933504'},
                                    '172.16.100.35/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933503'},
                                    '172.16.100.36/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933502'},
                                    '172.16.100.37/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933501'},
                                    '172.16.100.38/32': {'available_path': '1',
                                                        'best_path': '1',
                                                        'index': {1: {'ext_community': 'RT:5918:50',
                                                                      'gateway': '192.168.10.253',
                                                                      'localpref': 100,
                                                                      'metric': 0,
                                                                      'next_hop': '192.168.10.253',
                                                                      'next_hop_via': 'vrf '
                                                                                      'L3VPN-0050',
                                                                      'origin_codes': '?',
                                                                      'originator': '192.168.10.253',
                                                                      'recipient_pathid': '0',
                                                                      'refresh_epoch': 1,
                                                                      'route_info': '62000',
                                                                      'status_codes': '*>',
                                                                      'transfer_pathid': '0x0',
                                                                      'update_group': 724}},
                                                        'paths': '1 '
                                                                 'available, '
                                                                 'best '
                                                                 '#1, '
                                                                 'table '
                                                                 'L3VPN-0050',
                                                        'table_version': '16933500'},
                                    '172.16.100.4/32': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'ext_community': 'RT:5918:50',
                                                                     'gateway': '192.168.10.253',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '192.168.10.253',
                                                                     'next_hop_via': 'vrf '
                                                                                     'L3VPN-0050',
                                                                     'origin_codes': '?',
                                                                     'originator': '192.168.10.253',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 1,
                                                                     'route_info': '62000',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0',
                                                                     'update_group': 724}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'table '
                                                                'L3VPN-0050',
                                                       'table_version': '16933534'},
                                    '172.16.100.5/32': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'ext_community': 'RT:5918:50',
                                                                     'gateway': '192.168.10.253',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '192.168.10.253',
                                                                     'next_hop_via': 'vrf '
                                                                                     'L3VPN-0050',
                                                                     'origin_codes': '?',
                                                                     'originator': '192.168.10.253',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 1,
                                                                     'route_info': '62000',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0',
                                                                     'update_group': 724}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'table '
                                                                'L3VPN-0050',
                                                       'table_version': '16933533'},
                                    '172.16.100.6/32': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'ext_community': 'RT:5918:50',
                                                                     'gateway': '192.168.10.253',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '192.168.10.253',
                                                                     'next_hop_via': 'vrf '
                                                                                     'L3VPN-0050',
                                                                     'origin_codes': '?',
                                                                     'originator': '192.168.10.253',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 1,
                                                                     'route_info': '62000',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0',
                                                                     'update_group': 724}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'table '
                                                                'L3VPN-0050',
                                                       'table_version': '16933532'},
                                    '172.16.100.7/32': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'ext_community': 'RT:5918:50',
                                                                     'gateway': '192.168.10.253',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '192.168.10.253',
                                                                     'next_hop_via': 'vrf '
                                                                                     'L3VPN-0050',
                                                                     'origin_codes': '?',
                                                                     'originator': '192.168.10.253',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 1,
                                                                     'route_info': '62000',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0',
                                                                     'update_group': 724}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'table '
                                                                'L3VPN-0050',
                                                       'table_version': '16933531'},
                                    '172.16.100.8/32': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'ext_community': 'RT:5918:50',
                                                                     'gateway': '192.168.10.253',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '192.168.10.253',
                                                                     'next_hop_via': 'vrf '
                                                                                     'L3VPN-0050',
                                                                     'origin_codes': '?',
                                                                     'originator': '192.168.10.253',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 1,
                                                                     'route_info': '62000',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0',
                                                                     'update_group': 724}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'table '
                                                                'L3VPN-0050',
                                                       'table_version': '16933543'},
                                    '172.16.100.9/32': {'available_path': '1',
                                                       'best_path': '1',
                                                       'index': {1: {'ext_community': 'RT:5918:50',
                                                                     'gateway': '192.168.10.253',
                                                                     'localpref': 100,
                                                                     'metric': 0,
                                                                     'next_hop': '192.168.10.253',
                                                                     'next_hop_via': 'vrf '
                                                                                     'L3VPN-0050',
                                                                     'origin_codes': '?',
                                                                     'originator': '192.168.10.253',
                                                                     'recipient_pathid': '0',
                                                                     'refresh_epoch': 1,
                                                                     'route_info': '62000',
                                                                     'status_codes': '*>',
                                                                     'transfer_pathid': '0x0',
                                                                     'update_group': 724}},
                                                       'paths': '1 '
                                                                'available, '
                                                                'best '
                                                                '#1, '
                                                                'table '
                                                                'L3VPN-0050',
                                                       'table_version': '16933542'}},
                                'route_distinguisher': '5918:50'}}}}}}}

    golden_output2 = {'execute.return_value': '''
        Router#show ip bgp vpnv4 vrf L3VPN-0050 detail
        Load for five secs: 23%/0%; one minute: 25%; five minutes: 17%
        Time source is NTP, 18:03:04.054 EST Sun Jun 6 2016


        Route Distinguisher: 5918:50 (default for vrf L3VPN-0050)
        BGP routing table entry for 5918:50:10.4.1.0/24, version 16933597
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2467/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:10.44.105.0/24, version 16933498
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 6620/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.2/32, version 16933598
          Paths: (1 available, best #1, table L3VPN-0050)
          Not advertised to any peer
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Community: 62000:2
              Extended Community: RT:5918:50
              mpls labels in/out 2468/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.3/32, version 16933535
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 5463/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.4/32, version 16933534
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 5462/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.5/32, version 16933533
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 5461/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.6/32, version 16933532
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 5460/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.7/32, version 16933531
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 5459/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.8/32, version 16933543
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2906/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.9/32, version 16933542
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2905/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.10/32, version 16933541
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2904/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.11/32, version 16933540
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2903/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.12/32, version 16933539
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2901/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.13/32, version 16933538
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 5466/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.14/32, version 16933537
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 5465/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.15/32, version 16933536
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 5464/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.16/32, version 16933551
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2914/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.17/32, version 16933550
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2913/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.18/32, version 16933549
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2912/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.19/32, version 16933548
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2911/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.20/32, version 16933547
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2910/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.21/32, version 16933546
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2909/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.22/32, version 16933545
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2908/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.23/32, version 16933544
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2907/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.24/32, version 16933559
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2923/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.25/32, version 16933558
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2922/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.26/32, version 16933557
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2920/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.27/32, version 16933556
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2919/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.28/32, version 16933555
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2918/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.29/32, version 16933554
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2917/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.30/32, version 16933553
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2916/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.31/32, version 16933552
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 2915/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.32/32, version 16933506
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 6630/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.33/32, version 16933505
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 6629/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.34/32, version 16933504
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 6627/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.35/32, version 16933503
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 6626/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.36/32, version 16933502
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 6625/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.37/32, version 16933501
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 6624/nolabel
              rx pathid: 0, tx pathid: 0x0
        BGP routing table entry for 5918:50:172.16.100.38/32, version 16933500
          Paths: (1 available, best #1, table L3VPN-0050)
          Advertised to update-groups:
             724       
          Refresh Epoch 1
          62000
            192.168.10.253 (via vrf L3VPN-0050) from 192.168.10.253 (192.168.10.253)
              Origin incomplete, metric 0, localpref 100, valid, external, best
              Extended Community: RT:5918:50
              mpls labels in/out 6623/nolabel
              rx pathid: 0, tx pathid: 0x0
        '''}

    golden_output3 = {'execute.return_value':'''
    BGP routing table entry for 65109:4093:10.229.11.11/32, version 6195
Paths: (1 available, best #1, no table)
  Advertised to update-groups:
     17         18
  Refresh Epoch 9
  65555, (Received from a RR-client)
    10.169.197.254 (metric 1002) (via default) from 10.169.197.254 (10.169.197.254)
      Origin incomplete, metric 0, localpref 100, valid, internal, best
      Community: 62000:1
      Extended Community: RT:65109:4093
      mpls labels in/out nolabel/584
      rx pathid: 0, tx pathid: 0x0
    '''}
    golden_parsed_output3 = {
        'instance': {
            'default': {
                'vrf': {
                    'default': {
                        'address_family': {
                            'vpnv4': {
                                'prefixes': {
                                    '10.229.11.11/32': {
                                        'table_version': '6195',
                                        'available_path': '1',
                                        'best_path': '1',
                                        'paths': '1 available, best #1, no table',
                                        'index': {
                                            1: {
                                                'next_hop': '10.169.197.254',
                                                'gateway': '10.169.197.254',
                                                'originator': '10.169.197.254',
                                                'next_hop_igp_metric': '1002',
                                                'next_hop_via': 'default',
                                                'localpref': 100,
                                                'metric': 0,
                                                'origin_codes': '?',
                                                'status_codes': '*>',
                                                'refresh_epoch': 9,
                                                'route_info': '65555',
                                                'route_status': 'Received from a RR-client',
                                                'community': '62000:1',
                                                'ext_community': 'RT:65109:4093',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0x0',
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
            },
        }
   
    golden_output4 = {'execute.return_value':'''
        Route Distinguisher: 65000:1 (default for vrf VRF1)
        BGP routing table entry for 65000:1:1.1.1.1/32, version 2
          Paths: (1 available, best #1, table VRF1)
          Not advertised to any peer
          Refresh Epoch 1
          Local
            0.0.0.0 (via vrf VRF1) from 0.0.0.0 (1.1.1.1)
              Origin IGP, metric 0, localpref 100, weight 32768, valid, sourced, local, best
              Extended Community: Cost:pre-bestpath:128:1280 0x8800:32768:0
                0x8801:100:32 0x8802:65280:256 0x8803:65281:1514 0x8806:0:16843009
              rx pathid: 0, tx pathid: 0x0
        '''} 

    golden_parsed_output4 = {
        'instance': {
            'default': {
                'vrf': {
                    'VRF1': {
                        'address_family': {
                            'vpnv4': {
                                'prefixes': {
                                    '1.1.1.1/32': {
                                        'table_version': '2',
                                        'available_path': '1',
                                        'best_path': '1',
                                        'paths': '1 available, best #1, table VRF1',
                                        'index': {
                                            1: {
                                                'next_hop': '0.0.0.0',
                                                'gateway': '0.0.0.0',
                                                'originator': '1.1.1.1',
                                                'next_hop_via': 'vrf VRF1',
                                                'localpref': 100,
                                                'metric': 0,
                                                'weight': '32768',
                                                'origin_codes': 'i',
                                                'status_codes': '*>',
                                                'refresh_epoch': 1,
                                                'route_info': 'Local',
                                                'ext_community': 'Cost:pre-bestpath:128:1280 0x8800:32768:0',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0x0',
                                                }
                                            }
                                        }
                                    },
                                    'route_distinguisher': '65000:1',
                                    'default_vrf': 'VRF1'
                                }
                            }
                        }
                    }
                }
            }
        }

    golden_output5 = {'execute.return_value':'''
        Route Distinguisher: 102:102 (default for vrf sample_vrf)
        BGP routing table entry for 102:102:0.0.0.0/0, version 1559863
          Paths: (4 available, best #1, table sample_vrf)
          Advertised to update-groups:
             1          29         35
          Refresh Epoch 1
          1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888, (received & used)
            100.100.100.80 (via vrf sample_vrf) from 100.100.100.80 (100.10.10.40)
              Origin IGP, localpref 100, valid, external, best
              Community: 65300:106 65300:500 65300:601 65351:1
              rx pathid: 0, tx pathid: 0x0
          Refresh Epoch 3
          1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888, (received & used)
            100.10.10.1 (metric 2) (via vrf sample_vrf) from 100.10.10.1 (100.10.10.1)
              Origin IGP, metric 0, localpref 100, valid, internal
              Community: 65300:106 65300:500 65300:601 65351:1
              rx pathid: 0, tx pathid: 0
          Refresh Epoch 1
          1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888, (received & used)
            100.10.10.84 (via vrf sample_vrf) from 100.10.10.84 (100.10.10.17)
              Origin IGP, localpref 100, valid, external
              Community: 65300:106 65300:500 65300:601 65351:1
              rx pathid: 0, tx pathid: 0
          Refresh Epoch 1
          65000 65181 65181 65181 65106 65102, (received-only)
            1.2.3.5 (via vrf sample_vrf) from 1.2.3.5 (2.4.229.220)
              Origin IGP, localpref 100, valid, external
              Community: 1:1 65102:100
              rx pathid: 0, tx pathid: 0
        BGP routing table entry for 102:102:5.6.20.128/25, version 1559898
          Paths: (3 available, best #1, table sample_vrf)
          Advertised to update-groups:
             1          29         35
          Refresh Epoch 1
          1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888, (received & used)
            100.10.10.84 (via vrf sample_vrf) from 100.10.10.84 (100.10.10.17)
              Origin IGP, localpref 100, valid, external, best
              Community: 65300:106 65300:508 65300:704 65351:1
              rx pathid: 0, tx pathid: 0x0
          Refresh Epoch 3
          1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888, (received & used)
            100.10.10.1 (metric 2) (via vrf sample_vrf) from 100.10.10.1 (100.10.10.1)
              Origin IGP, metric 0, localpref 100, valid, internal
              Community: 65300:106 65300:508 65300:704 65351:1
              rx pathid: 0, tx pathid: 0
          Refresh Epoch 1
          1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888, (received & used)
            100.100.100.80 (via vrf sample_vrf) from 100.100.100.80 (100.10.10.40)
              Origin IGP, localpref 100, valid, external
              Community: 65300:106 65300:508 65300:704 65351:1
              rx pathid: 0, tx pathid: 0
        '''}    
 
    golden_parsed_output5 = {
        'instance': {
            'default': {
                'vrf': {
                    'sample_vrf': {
                        'address_family': {
                            'vpnv4': {
                                'prefixes': {
                                    '0.0.0.0/0': {
                                        'table_version': '1559863',
                                        'available_path': '4',
                                        'best_path': '1',
                                        'paths': '4 available, best #1, table sample_vrf',
                                        'index': {
                                            1: {
                                                'next_hop': '100.100.100.80',
                                                'gateway': '100.100.100.80',
                                                'originator': '100.10.10.40',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'origin_codes': 'i',
                                                'status_codes': '*>',
                                                'refresh_epoch': 1,
                                                'route_info': '1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888',
                                                'route_status': 'received & used',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0x0'
                                                },
                                            2: {
                                                'next_hop': '100.10.10.1',
                                                'gateway': '100.10.10.1',
                                                'originator': '100.10.10.1',
                                                'next_hop_igp_metric': '2',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'metric': 0,
                                                'origin_codes': 'i',
                                                'status_codes': '* i',
                                                'refresh_epoch': 3,
                                                'route_info': '1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888',
                                                'route_status': 'received & used',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0'
                                            },
                                            3: {
                                                'next_hop': '100.10.10.84',
                                                'gateway': '100.10.10.84',
                                                'originator': '100.10.10.17',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'origin_codes': 'i',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'status_codes': '* ',
                                                'transfer_pathid': '0',
                                                'refresh_epoch': 1,
                                                'route_info': '1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888',
                                                'route_status': 'received & used',
                                                'recipient_pathid': '0',
                                                'recipient_pathid': '0'
                                            },
                                            4: {
                                                'next_hop': '1.2.3.5',
                                                'gateway': '1.2.3.5',
                                                'originator': '2.4.229.220',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'origin_codes': 'i',
                                                'status_codes': '* ',
                                                'refresh_epoch': 1,
                                                'route_info': '65000 65181 65181 65181 65106 65102',
                                                'route_status': 'received-only',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0'
                                            }
                                        }
                                    },
                                    '5.6.20.128/25':{
                                            'table_version': '1559898',
                                            'available_path': '3',
                                            'best_path': '1',
                                            'paths': '3 available, best #1, table sample_vrf',
                                            'index': {
                                            1: {
                                                'next_hop': '100.10.10.84',
                                                'gateway': '100.10.10.84',
                                                'originator': '100.10.10.17',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'origin_codes': 'i',
                                                'status_codes': '*>',
                                                'refresh_epoch': 1,
                                                'route_info': '1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888',
                                                'route_status': 'received & used',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0x0'
                                            },
                                            2: {
                                                'next_hop': '100.10.10.1',
                                                'gateway': '100.10.10.1',
                                                'originator': '100.10.10.1',
                                                'next_hop_igp_metric': '2',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'metric': 0,
                                                'origin_codes': 'i',
                                                'status_codes': '* i',
                                                'refresh_epoch': 3,
                                                'route_info': '1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888',
                                                'route_status': 'received & used',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0'
                                            },
                                            3: {
                                                'next_hop': '100.100.100.80',
                                                'gateway': '100.100.100.80',
                                                'originator': '100.10.10.40',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'origin_codes': 'i',
                                                'status_codes': '* ',
                                                'refresh_epoch': 1,
                                                'route_info': '1000001002 1000001502 1000001001 1000001505 1000001005 1000001504 000002 888',
                                                'route_status': 'received & used',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0'
                                            }
                                        }
                                    }
                                },
                                'route_distinguisher': '102:102',
                                'default_vrf': 'sample_vrf'
                            }
                        }
                    }
                }
            }
        }
    }
                                              
    golden_output6 = {'execute.return_value':'''
        Route Distinguisher: 102:102 (default for vrf sample_vrf)
        BGP routing table entry for 102:102:0.0.0.0/0, version 1559863
          Paths: (4 available, best #1, table sample_vrf)
          Advertised to update-groups:
             1          29         35
          Refresh Epoch 1
          2, imported safety path from 50000:2:172.17.0.0/16
            100.100.100.80 (via vrf sample_vrf) from 100.100.100.80 (100.10.10.40)
              Origin IGP, localpref 100, valid, external, best
              Community: 65300:106 65300:500 65300:601 65351:1
              rx pathid: 0, tx pathid: 0x0
          Refresh Epoch 3
          Local, imported path from base
            100.10.10.1 (metric 2) (via vrf sample_vrf) from 100.10.10.1 (100.10.10.1)
              Origin IGP, metric 0, localpref 100, valid, internal
              Community: 65300:106 65300:500 65300:601 65351:1
              rx pathid: 0, tx pathid: 0
        '''}    

    golden_parsed_output6 = {
        'instance': {
            'default': {
                'vrf': {
                    'sample_vrf': {
                        'address_family': {
                            'vpnv4': {
                                'prefixes': {
                                    '0.0.0.0/0': {
                                        'table_version': '1559863',
                                        'available_path': '4',
                                        'best_path': '1',
                                        'paths': '4 available, best #1, table sample_vrf',
                                        'index': {
                                            1: {
                                                'next_hop': '100.100.100.80',
                                                'gateway': '100.100.100.80',
                                                'originator': '100.10.10.40',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'origin_codes': 'i',
                                                'status_codes': '*>',
                                                'refresh_epoch': 1,
                                                'route_info': '2',
                                                'imported_path_from': '50000:2:172.17.0.0/16',
                                                'imported_safety_path': True,
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0x0'
                                                },
                                            2: {
                                                'next_hop': '100.10.10.1',
                                                'gateway': '100.10.10.1',
                                                'originator': '100.10.10.1',
                                                'next_hop_igp_metric': '2',
                                                'next_hop_via': 'vrf sample_vrf',
                                                'update_group': [1, 29, 35],
                                                'localpref': 100,
                                                'metric': 0,
                                                'origin_codes': 'i',
                                                'status_codes': '* i',
                                                'refresh_epoch': 3,
                                                'route_info': 'Local',
                                                'imported_path_from': 'base',
                                                'recipient_pathid': '0',
                                                'transfer_pathid': '0'
                                            }
                                        }
                                    }
                                },
                                'route_distinguisher': '102:102',
                                'default_vrf': 'sample_vrf'
                            }
                        }
                    }
                }
            }
        }
    }
    
    def test_show_bgp_detail_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowIpBgpDetail(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_bgp_detail_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowIpBgpDetail(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4', rd='5918:51')
        self.assertEqual(parsed_output,self.golden_parsed_output1)

    def test_show_bgp_all_detail_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowIpBgpDetail(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4', vrf='L3VPN-0050')
        self.assertEqual(parsed_output,self.golden_parsed_output2)

    def test_show_bgp_all_detail_golden3(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output3)
        obj = ShowIpBgpDetail(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4', rd='65109:4093',
            route='10.229.11.11/32')
        self.assertEqual(parsed_output,self.golden_parsed_output3)
        
    def test_show_bgp_all_detail_golden4(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output4)
        obj = ShowIpBgpDetail(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4')
        self.assertEqual(parsed_output,self.golden_parsed_output4)
        
    def test_show_bgp_all_detail_golden5(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output5)
        obj = ShowIpBgpDetail(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4')
        self.assertEqual(parsed_output,self.golden_parsed_output5)
        
    def test_show_bgp_all_detail_golden6(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output6)
        obj = ShowIpBgpDetail(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4')
        self.assertEqual(parsed_output,self.golden_parsed_output6)
        
#-------------------------------------------------------------------------------


# =========================================
# Unit test for
#   * 'show bgp all summary'
#   * 'show bgp vrf {vrf} all summary'
# =========================================
class test_show_bgp_all_summary(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'bgp_id': 100,
        'vrf':
            {'default':
                {'neighbor':
                    {'192.168.111.1':
                        {'address_family':
                            {'ipv4 unicast':
                                {'as': 100,
                                'attribute_entries': '1/1',
                                'bgp_table_version': 28,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 3672,
                                    'total_entries': 27},
                                'prefixes':
                                    {'memory_usage': 6696,
                                    'total_entries': 27},
                                'cache_entries':
                                    {'route-map':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    'filter-list':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    },
                                'total_memory': 10648,
                                'activity_prefixes': '47/20',
                                'activity_paths': '66/39',
                                'scan_interval': 60,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 28,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': '01:07:38',
                                'version': 4}}},
                    '192.168.4.1':
                        {'address_family':
                            {'ipv4 unicast':
                                {'as': 100,
                                'attribute_entries': '1/1',
                                'bgp_table_version': 28,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 3672,
                                    'total_entries': 27},
                                'prefixes':
                                    {'memory_usage': 6696,
                                    'total_entries': 27},
                                'cache_entries':
                                    {'route-map':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    'filter-list':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    },
                                'total_memory': 10648,
                                'activity_prefixes': '47/20',
                                'activity_paths': '66/39',
                                'scan_interval': 60,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 28,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': 'never',
                                'version': 4}}},
                    '192.168.51.1':
                        {'address_family':
                            {'ipv4 unicast':
                                {'as': 100,
                                'attribute_entries': '1/1',
                                'bgp_table_version': 28,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 3672,
                                    'total_entries': 27},
                                'prefixes':
                                    {'memory_usage': 6696,
                                    'total_entries': 27},
                                'cache_entries':
                                    {'route-map':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    'filter-list':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    },
                                'total_memory': 10648,
                                'activity_prefixes': '47/20',
                                'activity_paths': '66/39',
                                'scan_interval': 60,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 28,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': '01:07:38',
                                'version': 4}}},
                    '192.168.70.4':
                        {'address_family':
                            {'ipv4 unicast':
                                {'as': 200,
                                'attribute_entries': '1/1',
                                'bgp_table_version': 28,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 3672,
                                    'total_entries': 27},
                                'prefixes':
                                    {'memory_usage': 6696,
                                    'total_entries': 27},
                                'cache_entries':
                                    {'route-map':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    'filter-list':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    },
                                'total_memory': 10648,
                                'activity_prefixes': '47/20',
                                'activity_paths': '66/39',
                                'scan_interval': 60,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 28,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': 'never',
                                'version': 4}}},
                    '192.168.19.2':
                        {'address_family':
                            {'ipv4 unicast':
                                {'as': 300,
                                'attribute_entries': '1/1',
                                'bgp_table_version': 28,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 3672,
                                       'total_entries': 27},
                                'prefixes':
                                    {'memory_usage': 6696,
                                    'total_entries': 27},
                                'cache_entries':
                                    {'route-map':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    'filter-list':
                                        {'total_entries': 0,
                                        'memory_usage': 0
                                        },
                                    },
                                'total_memory': 10648,
                                'activity_prefixes': '47/20',
                                'activity_paths': '66/39',
                                'scan_interval': 60,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 28,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': '01:07:38',
                                'version': 4}}},
                    '2001:db8:400::1:1': 
                        {'address_family': 
                            {'ipv6 unicast': 
                                {'as': 100,
                                'bgp_table_version': 1,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 1,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': '01:07:38',
                                'version': 4}}},
                    '2001:db8:400::4:1': 
                        {'address_family': 
                            {'ipv6 unicast': 
                                {'as': 100,
                                'bgp_table_version': 1,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 1,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': '01:07:38',
                                'version': 4}}},
                    '2001::14:4': 
                        {'address_family': 
                            {'ipv6 unicast': 
                                {'as': 200,
                                'bgp_table_version': 1,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 1,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': 'never',
                                'version': 4}}},
                    '2001::26:2': 
                        {'address_family': 
                            {'ipv6 unicast': 
                                {'as': 300,
                                'bgp_table_version': 1,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 1,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': '01:07:38',
                                'version': 4}}},
                    '10.36.3.3': 
                        {'address_family':
                            {'vpnv4 unicast':
                                {'as': 100,
                                'bgp_table_version': 1,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 1,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': 'never',
                                'version': 4},
                            'vpnv6 unicast':
                                {'as': 100,
                                'bgp_table_version': 1,
                                'input_queue': 0,
                                'local_as': 100,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'route_identifier': '192.168.111.1',
                                'routing_table_version': 1,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'up_down': 'never',
                                'version': 4},
                            },
                        },
                    },
                },
            },
        }

    golden_output1 = {'execute.return_value': '''
        Router#show bgp all summary
        For address family: IPv4 Unicast
        BGP router identifier 192.168.111.1, local AS number 100
        BGP table version is 28, main routing table version 28
        27 network entries using 6696 bytes of memory
        27 path entries using 3672 bytes of memory
        1/1 BGP path/bestpath attribute entries using 280 bytes of memory
        0 BGP route-map cache entries using 0 bytes of memory
        0 BGP filter-list cache entries using 0 bytes of memory
        BGP using 10648 total bytes of memory
        BGP activity 47/20 prefixes, 66/39 paths, scan interval 60 secs

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        192.168.111.1       4          100       0       0        1    0    0 01:07:38 Idle
        192.168.4.1       4          100       0       0        1    0    0 never    Idle
        192.168.51.1       4          100       0       0        1    0    0 01:07:38 Idle
        192.168.70.4      4          200       0       0        1    0    0 never    Idle
        192.168.19.2      4          300       0       0        1    0    0 01:07:38 Idle

        For address family: IPv6 Unicast
        BGP router identifier 192.168.111.1, local AS number 100
        BGP table version is 1, main routing table version 1

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        2001:db8:400::1:1       4          100       0       0        1    0    0 01:07:38 Idle
        2001:db8:400::4:1       4          100       0       0        1    0    0 01:07:38 Idle
        2001::14:4      4          200       0       0        1    0    0 never    Idle
        2001::26:2      4          300       0       0        1    0    0 01:07:38 Idle

        For address family: VPNv4 Unicast
        BGP router identifier 192.168.111.1, local AS number 100
        BGP table version is 1, main routing table version 1

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        10.36.3.3         4          100       0       0        1    0    0 never    Idle

        For address family: VPNv6 Unicast
        BGP router identifier 192.168.111.1, local AS number 100
        BGP table version is 1, main routing table version 1

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        10.36.3.3         4          100       0       0        1    0    0 never    Idle
        '''}

    golden_parsed_output2 = {
        'bgp_id': 100,
        'vrf':
            {'default':
                 {'neighbor':
                      {'10.16.2.2':
                           {'address_family':
                                {'vpnv4 unicast':
                                     {'as': 100,
                                      'attribute_entries': '6/4',
                                      'bgp_table_version': 56,
                                      'input_queue': 0,
                                      'local_as': 100,
                                      'msg_rcvd': 82,
                                      'msg_sent': 88,
                                      'output_queue': 0,
                                      'path': {'memory_usage': 3600,
                                               'total_entries': 45},
                                      'prefixes':
                                          {'memory_usage': 4560,
                                           'total_entries': 30},
                                      'cache_entries':
                                          {
                                              'route-map':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  },
                                              'filter-list':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  }
                                          },
                                      'entries':
                                          {
                                              'AS-PATH':
                                                  {
                                                      'total_entries': 3,
                                                      'memory_usage': 120
                                                  },
                                              'rrinfo':
                                                  {
                                                      'total_entries': 2,
                                                      'memory_usage': 48
                                                  }
                                          },
                                      'community_entries':
                                          {'total_entries': 4,
                                           'memory_usage': 96,
                                           },
                                      'total_memory': 9384,
                                      'activity_prefixes': '85/25',
                                      'activity_paths': '120/30',
                                      'scan_interval': 60,
                                      'route_identifier': '10.64.4.4',
                                      'routing_table_version': 56,
                                      'state_pfxrcd': '10',
                                      'tbl_ver': 56,
                                      'up_down': '01:12:00',
                                      'version': 4},
                                'vpnv6 unicast':
                                    {'as': 100,
                                      'attribute_entries': '6/4',
                                      'bgp_table_version': 66,
                                      'input_queue': 0,
                                      'local_as': 100,
                                      'msg_rcvd': 82,
                                      'msg_sent': 88,
                                      'output_queue': 0,
                                      'path': {'memory_usage': 4860,
                                               'total_entries': 45},
                                      'prefixes':
                                          {'memory_usage': 5280,
                                           'total_entries': 30},
                                      'cache_entries':
                                          {
                                              'route-map':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  },
                                              'filter-list':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  }
                                          },
                                      'entries':
                                          {
                                              'AS-PATH':
                                                  {
                                                      'total_entries': 3,
                                                      'memory_usage': 120
                                                  },
                                              'rrinfo':
                                                  {
                                                      'total_entries': 2,
                                                      'memory_usage': 48
                                                  }
                                          },
                                      'community_entries':
                                          {'total_entries': 4,
                                           'memory_usage': 96,
                                           },
                                      'total_memory': 11364,
                                      'activity_prefixes': '85/25',
                                      'activity_paths': '120/30',
                                      'scan_interval': 60,
                                      'route_identifier': '10.64.4.4',
                                      'routing_table_version': 66,
                                      'state_pfxrcd': '10',
                                      'tbl_ver': 66,
                                      'up_down': '01:12:00',
                                      'version': 4}
                                }
                           },
                      '10.36.3.3':
                           {'address_family':
                                {'vpnv4 unicast':
                                     {'as': 100,
                                      'attribute_entries': '6/4',
                                      'bgp_table_version': 56,
                                      'input_queue': 0,
                                      'local_as': 100,
                                      'msg_rcvd': 82,
                                      'msg_sent': 89,
                                      'output_queue': 0,
                                      'path': {'memory_usage': 3600,
                                               'total_entries': 45},
                                      'prefixes':
                                          {'memory_usage': 4560,
                                           'total_entries': 30},
                                      'cache_entries':
                                          {
                                              'route-map':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  },
                                              'filter-list':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  }
                                          },
                                      'entries':
                                          {
                                              'AS-PATH':
                                                  {
                                                      'total_entries': 3,
                                                      'memory_usage': 120
                                                  },
                                              'rrinfo':
                                                  {
                                                      'total_entries': 2,
                                                      'memory_usage': 48
                                                  }
                                          },
                                      'community_entries':
                                          {'total_entries': 4,
                                           'memory_usage': 96,
                                           },
                                      'total_memory': 9384,
                                      'activity_prefixes': '85/25',
                                      'activity_paths': '120/30',
                                      'scan_interval': 60,
                                      'route_identifier': '10.64.4.4',
                                      'routing_table_version': 56,
                                      'state_pfxrcd': '10',
                                      'tbl_ver': 56,
                                      'up_down': '01:12:06',
                                      'version': 4},
                                 'vpnv6 unicast':
                                     {'as': 100,
                                      'attribute_entries': '6/4',
                                      'bgp_table_version': 66,
                                      'input_queue': 0,
                                      'local_as': 100,
                                      'msg_rcvd': 82,
                                      'msg_sent': 89,
                                      'output_queue': 0,
                                      'path': {'memory_usage': 4860,
                                               'total_entries': 45},
                                      'prefixes':
                                          {'memory_usage': 5280,
                                           'total_entries': 30},
                                      'cache_entries':
                                          {
                                              'route-map':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  },
                                              'filter-list':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  }
                                          },
                                      'entries':
                                          {
                                              'AS-PATH':
                                                  {
                                                      'total_entries': 3,
                                                      'memory_usage': 120
                                                  },
                                              'rrinfo':
                                                  {
                                                      'total_entries': 2,
                                                      'memory_usage': 48
                                                  }
                                          },
                                      'community_entries':
                                          {'total_entries': 4,
                                           'memory_usage': 96,
                                           },
                                      'total_memory': 11364,
                                      'activity_prefixes': '85/25',
                                      'activity_paths': '120/30',
                                      'scan_interval': 60,
                                      'route_identifier': '10.64.4.4',
                                      'routing_table_version': 66,
                                      'state_pfxrcd': '10',
                                      'tbl_ver': 66,
                                      'up_down': '01:12:06',
                                      'version': 4}
                                 }},
                      '10.4.6.6':
                           {'address_family':
                                {'vpnv4 unicast':
                                     {'as': 300,
                                      'attribute_entries': '6/4',
                                      'bgp_table_version': 56,
                                      'input_queue': 0,
                                      'local_as': 100,
                                      'msg_rcvd': 68,
                                      'msg_sent': 75,
                                      'output_queue': 0,
                                      'path': {'memory_usage': 3600,
                                               'total_entries': 45},
                                      'prefixes':
                                          {'memory_usage': 4560,
                                           'total_entries': 30},
                                      'cache_entries':
                                          {
                                              'route-map':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  },
                                              'filter-list':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  }
                                          },
                                      'entries':
                                          {
                                              'AS-PATH':
                                                  {
                                                      'total_entries': 3,
                                                      'memory_usage': 120
                                                  },
                                              'rrinfo':
                                                  {
                                                      'total_entries': 2,
                                                      'memory_usage': 48
                                                  }
                                          },
                                      'community_entries':
                                          {'total_entries': 4,
                                           'memory_usage': 96,
                                           },
                                      'total_memory': 9384,
                                      'activity_prefixes': '85/25',
                                      'activity_paths': '120/30',
                                      'scan_interval': 60,
                                      'route_identifier': '10.64.4.4',
                                      'routing_table_version': 56,
                                      'state_pfxrcd': '5',
                                      'tbl_ver': 56,
                                      'up_down': '01:03:23',
                                      'version': 4}}},
                      '10.66.6.6':
                           {'address_family':
                                {'vpnv4 unicast':
                                     {'as': 400,
                                      'attribute_entries': '6/4',
                                      'bgp_table_version': 56,
                                      'input_queue': 0,
                                      'local_as': 100,
                                      'msg_rcvd': 67,
                                      'msg_sent': 72,
                                      'output_queue': 0,
                                      'path': {'memory_usage': 3600,
                                               'total_entries': 45},
                                      'prefixes':
                                          {'memory_usage': 4560,
                                           'total_entries': 30},
                                      'cache_entries':
                                          {
                                              'route-map':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  },
                                              'filter-list':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  }
                                          },
                                      'entries':
                                          {
                                              'AS-PATH':
                                                  {
                                                      'total_entries': 3,
                                                      'memory_usage': 120
                                                  },
                                              'rrinfo':
                                                  {
                                                      'total_entries': 2,
                                                      'memory_usage': 48
                                                  }
                                          },
                                      'community_entries':
                                          {'total_entries': 4,
                                           'memory_usage': 96,
                                           },
                                      'total_memory': 9384,
                                      'activity_prefixes': '85/25',
                                      'activity_paths': '120/30',
                                      'scan_interval': 60,
                                      'route_identifier': '10.64.4.4',
                                      'routing_table_version': 56,
                                      'state_pfxrcd': '5',
                                      'tbl_ver': 56,
                                      'up_down': '01:03:14',
                                      'version': 4}}},
                      '2001:DB8:4:6::6':
                           {'address_family':
                                {'vpnv6 unicast':
                                     {'as': 300,
                                      'attribute_entries': '6/4',
                                      'bgp_table_version': 66,
                                      'input_queue': 0,
                                      'local_as': 100,
                                      'msg_rcvd': 67,
                                      'msg_sent': 75,
                                      'output_queue': 0,
                                      'path': {'memory_usage': 4860,
                                               'total_entries': 45},
                                      'prefixes':
                                          {'memory_usage': 5280,
                                           'total_entries': 30},
                                      'cache_entries':
                                          {
                                              'route-map':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  },
                                              'filter-list':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  }
                                          },
                                      'entries':
                                          {
                                              'AS-PATH':
                                                  {
                                                      'total_entries': 3,
                                                      'memory_usage': 120
                                                  },
                                              'rrinfo':
                                                  {
                                                      'total_entries': 2,
                                                      'memory_usage': 48
                                                  }
                                          },
                                      'community_entries':
                                          {'total_entries': 4,
                                           'memory_usage': 96,
                                           },
                                      'total_memory': 11364,
                                      'activity_prefixes': '85/25',
                                      'activity_paths': '120/30',
                                      'scan_interval': 60,
                                      'route_identifier': '10.64.4.4',
                                      'routing_table_version': 66,
                                      'state_pfxrcd': '5',
                                      'tbl_ver': 66,
                                      'up_down': '01:03:19',
                                      'version': 4}
                                 }},
                      '2001:DB8:20:4:6::6':
                           {'address_family':
                                {'vpnv6 unicast':
                                     {'as': 400,
                                      'attribute_entries': '6/4',
                                      'bgp_table_version': 66,
                                      'input_queue': 0,
                                      'local_as': 100,
                                      'msg_rcvd': 67,
                                      'msg_sent': 73,
                                      'output_queue': 0,
                                      'path': {'memory_usage': 4860,
                                               'total_entries': 45},
                                      'prefixes':
                                          {'memory_usage': 5280,
                                           'total_entries': 30},
                                      'cache_entries':
                                          {
                                              'route-map':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  },
                                              'filter-list':
                                                  {
                                                      'total_entries': 0,
                                                      'memory_usage': 0
                                                  }
                                          },
                                      'entries':
                                          {
                                              'AS-PATH':
                                                  {
                                                      'total_entries': 3,
                                                      'memory_usage': 120
                                                  },
                                              'rrinfo':
                                                  {
                                                      'total_entries': 2,
                                                      'memory_usage': 48
                                                  }
                                          },
                                      'community_entries':
                                          {'total_entries': 4,
                                           'memory_usage': 96,
                                           },
                                      'total_memory': 11364,
                                      'activity_prefixes': '85/25',
                                      'activity_paths': '120/30',
                                      'scan_interval': 60,
                                      'route_identifier': '10.64.4.4',
                                      'routing_table_version': 66,
                                      'state_pfxrcd': '5',
                                      'tbl_ver': 66,
                                      'up_down': '01:03:11',
                                      'version': 4}
                                 }
                           }

                      }
                 }
            }
        }

    golden_output2 = {'execute.return_value': '''
        Router#show bgp all summary
        For address family: VPNv4 Unicast
        BGP router identifier 10.64.4.4, local AS number 100
        BGP table version is 56, main routing table version 56
        30 network entries using 4560 bytes of memory
        45 path entries using 3600 bytes of memory
        6/4 BGP path/bestpath attribute entries using 960 bytes of memory
        2 BGP rrinfo entries using 48 bytes of memory
        3 BGP AS-PATH entries using 120 bytes of memory
        4 BGP extended community entries using 96 bytes of memory
        0 BGP route-map cache entries using 0 bytes of memory
        0 BGP filter-list cache entries using 0 bytes of memory
        BGP using 9384 total bytes of memory
        BGP activity 85/25 prefixes, 120/30 paths, scan interval 60 secs

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        10.16.2.2         4          100      82      88       56    0    0 01:12:00       10
        10.36.3.3         4          100      82      89       56    0    0 01:12:06       10
        10.4.6.6        4          300      68      75       56    0    0 01:03:23        5
        10.66.6.6        4          400      67      72       56    0    0 01:03:14        5

        For address family: VPNv6 Unicast
        BGP router identifier 10.64.4.4, local AS number 100
        BGP table version is 66, main routing table version 66
        30 network entries using 5280 bytes of memory
        45 path entries using 4860 bytes of memory
        6/4 BGP path/bestpath attribute entries using 960 bytes of memory
        2 BGP rrinfo entries using 48 bytes of memory
        3 BGP AS-PATH entries using 120 bytes of memory
        4 BGP extended community entries using 96 bytes of memory
        0 BGP route-map cache entries using 0 bytes of memory
        0 BGP filter-list cache entries using 0 bytes of memory
        BGP using 11364 total bytes of memory
        BGP activity 85/25 prefixes, 120/30 paths, scan interval 60 secs

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        10.16.2.2         4          100      82      88       66    0    0 01:12:00       10
        10.36.3.3         4          100      82      89       66    0    0 01:12:06       10
        2001:DB8:4:6::6 4          300      67      75       66    0    0 01:03:19        5
        2001:DB8:20:4:6::6
                4          400      67      73       66    0    0 01:03:11        5
            '''}
    golden_output3 = {'execute.return_value' : '''
            For address family: IPv4 Unicast





        For address family: VPNv4 Unicast

        BGP router identifier 192.168.10.254, local AS number 65109

        BGP table version is 189, main routing table version 189

        25 network entries using 6400 bytes of memory

        38 path entries using 5168 bytes of memory

        110/106 BGP path/bestpath attribute entries using 32560 bytes of memory

        1 BGP rrinfo entries using 40 bytes of memory

        1 BGP AS-PATH entries using 24 bytes of memory

        2 BGP community entries using 48 bytes of memory

        102 BGP extended community entries using 3248 bytes of memory

        0 BGP route-map cache entries using 0 bytes of memory

        0 BGP filter-list cache entries using 0 bytes of memory

        BGP using 47488 total bytes of memory

        BGP activity 226/0 prefixes, 339/0 paths, scan interval 60 secs



        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd

        192.168.10.253  4        65555      20      12      189    0    0 00:03:52       13



        For address family: IPv4 Flowspec
    '''}
    golden_parsed_output3={
    'bgp_id': 65109,
    'vrf': {
        'VRF1': {
            'neighbor': {
                '192.168.10.253': {
                    'address_family': {
                        'vpnv4 unicast': {
                            'version': 4,
                            'as': 65555,
                            'msg_rcvd': 20,
                            'msg_sent': 12,
                            'tbl_ver': 189,
                            'input_queue': 0,
                            'output_queue': 0,
                            'up_down': '00:03:52',
                            'state_pfxrcd': '13',
                            'route_identifier': '192.168.10.254',
                            'local_as': 65109,
                            'bgp_table_version': 189,
                            'routing_table_version': 189,
                            'attribute_entries': '110/106',
                            'prefixes': {
                                'total_entries': 25,
                                'memory_usage': 6400,
                                },
                            'path': {
                                'total_entries': 38,
                                'memory_usage': 5168,
                                },
                            'total_memory': 47488,
                            'activity_prefixes': '226/0',
                            'activity_paths': '339/0',
                            'scan_interval': 60,
                            'cache_entries': {
                                'route-map': {
                                    'total_entries': 0,
                                    'memory_usage': 0,
                                    },
                                'filter-list': {
                                    'total_entries': 0,
                                    'memory_usage': 0,
                                    },
                                },
                            'entries': {
                                'rrinfo': {
                                    'total_entries': 1,
                                    'memory_usage': 40,
                                    },
                                'AS-PATH': {
                                    'total_entries': 1,
                                    'memory_usage': 24,
                                    },
                                'community': {
                                    'total_entries': 2,
                                    'memory_usage': 48,
                                    },
                                },
                            'community_entries': {
                                'total_entries': 102,
                                'memory_usage': 3248,
                                },
                            },
                        },
                    },
                },
            },
        },
    }
    def test_show_bgp_all_summary_empty(self):
        self.device1 = Mock(**self.empty_output)
        bgp_summary_obj = ShowBgpAllSummary(device=self.device1)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = bgp_summary_obj.parse()

    def test_show_bgp_all_summary_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowBgpAllSummary(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_bgp_all_summary_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowBgpAllSummary(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output2)

    def test_show_bgp_vrf_all_summary_golden(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output3)
        obj = ShowBgpAllSummary(device=self.device)
        parsed_output = obj.parse(vrf='VRF1')
        self.assertEqual(parsed_output, self.golden_parsed_output3)

# =================================================
# Unit test for
#   * 'show bgp {address_family} rd {rd} summary
#   * 'show bgp {address_family} vrf {vrf} summary
# =================================================
class test_show_bgp_summary(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'bgp_id': 5918,
        'vrf': 
            {'default': 
                {'neighbor': 
                    {'192.168.10.253': 
                        {'address_family': 
                            {'vpnv4 unicast': 
                                {'activity_paths': '23637710/17596802',
                                'activity_prefixes': '11724891/9708585',
                                'as': 65555,
                                'attribute_entries': '5101/4700',
                                'bgp_table_version': 33086714,
                                'cache_entries': 
                                    {'filter-list': 
                                        {'memory_usage': 0,
                                        'total_entries': 0},
                                    'route-map': 
                                        {'memory_usage': 0,
                                        'total_entries': 0}},
                                'community_entries': 
                                    {'memory_usage': 60120,
                                    'total_entries': 2303},
                                'entries': 
                                    {'AS-PATH': 
                                        {'memory_usage': 4824,
                                        'total_entries': 201},
                                    'rrinfo': 
                                        {'memory_usage': 20080,
                                        'total_entries': 502}},
                                'input_queue': 0,
                                'local_as': 5918,
                                'msg_rcvd': 619,
                                'msg_sent': 695,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 900480,
                                    'total_entries': 7504},
                                'prefixes': 
                                    {'memory_usage': 973568,
                                    'total_entries': 3803},
                                'route_identifier': '192.168.10.254',
                                'routing_table_version': 33086714,
                                'scan_interval': 60,
                                'state_pfxrcd': '100',
                                'tbl_ver': 33086714,
                                'total_memory': 3305736,
                                'up_down': '05:07:45',
                                'version': 4}}}}}}}

    golden_output1 = {'execute.return_value': '''
        Router#show bgp vpnv4 unicast rd 5918:51 summary
        Load for five secs: 12%/0%; one minute: 8%; five minutes: 6%
        Time source is NTP, 16:14:07.495 EST Tue Jun 8 2016
        BGP router identifier 192.168.10.254, local AS number 5918
        BGP table version is 33086714, main routing table version 33086714
        3803 network entries using 973568 bytes of memory
        7504 path entries using 900480 bytes of memory
        5101/4700 BGP path/bestpath attribute entries using 1346664 bytes of memory
        502 BGP rrinfo entries using 20080 bytes of memory
        201 BGP AS-PATH entries using 4824 bytes of memory
        2303 BGP extended community entries using 60120 bytes of memory
        0 BGP route-map cache entries using 0 bytes of memory
        0 BGP filter-list cache entries using 0 bytes of memory
        BGP using 3305736 total bytes of memory
        BGP activity 11724891/9708585 prefixes, 23637710/17596802 paths, scan interval 60 secs

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        192.168.10.253  4        65555     619     695 33086714    0    0 05:07:45      100
        Router#
        '''}

    golden_parsed_output2 = {
        'bgp_id': 5918,
        'vrf': 
            {'L3VPN-0051': 
                {'neighbor': 
                    {'192.168.10.253': 
                        {'address_family': 
                            {'vpnv4 unicast': 
                                {'activity_paths': '23637710/17596802',
                                'activity_prefixes': '11724891/9708585',
                                'as': 65555,
                                'attribute_entries': '5101/4700',
                                'bgp_table_version': 33086714,
                                'cache_entries': 
                                    {'filter-list': 
                                        {'memory_usage': 0,
                                        'total_entries': 0},
                                    'route-map': 
                                        {'memory_usage': 0,
                                        'total_entries': 0}},
                                'community_entries': 
                                    {'memory_usage': 60120,
                                    'total_entries': 2303},
                                'entries': 
                                    {'AS-PATH': 
                                        {'memory_usage': 4824,
                                        'total_entries': 201},
                                    'rrinfo': 
                                        {'memory_usage': 20080,
                                        'total_entries': 502}},
                                'input_queue': 0,
                                'local_as': 5918,
                                'msg_rcvd': 619,
                                'msg_sent': 695,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 900480,
                                    'total_entries': 7504},
                                'prefixes': 
                                    {'memory_usage': 973568,
                                    'total_entries': 3803},
                                'route_identifier': '192.168.10.254',
                                'routing_table_version': 33086714,
                                'scan_interval': 60,
                                'state_pfxrcd': '100',
                                'tbl_ver': 33086714,
                                'total_memory': 3305736,
                                'up_down': '05:07:37',
                                'version': 4}}}}}}}

    golden_output2 = {'execute.return_value': '''
        Router#show bgp vpnv4 unicast vrf L3VPN-0051 summary
        Load for five secs: 47%/0%; one minute: 8%; five minutes: 6%
        Time source is NTP, 16:13:59.421 EST Tue Jun 8 2016
        BGP router identifier 192.168.10.254, local AS number 5918
        BGP table version is 33086714, main routing table version 33086714
        3803 network entries using 973568 bytes of memory
        7504 path entries using 900480 bytes of memory
        5101/4700 BGP path/bestpath attribute entries using 1346664 bytes of memory
        502 BGP rrinfo entries using 20080 bytes of memory
        201 BGP AS-PATH entries using 4824 bytes of memory
        2303 BGP extended community entries using 60120 bytes of memory
        0 BGP route-map cache entries using 0 bytes of memory
        0 BGP filter-list cache entries using 0 bytes of memory
        BGP using 3305736 total bytes of memory
        BGP activity 11724891/9708585 prefixes, 23637710/17596802 paths, scan interval 60 secs

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        192.168.10.253  4        65555     619     695 33086714    0    0 05:07:37      100
        Router#
        '''}

    def test_show_bgp_summary_empty(self):
        self.device1 = Mock(**self.empty_output)
        bgp_summary_obj = ShowBgpSummary(device=self.device1)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = bgp_summary_obj.parse()

    def test_show_bgp_summary_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowBgpSummary(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4 unicast', rd='5918:51')
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_bgp_summary_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowBgpSummary(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4 unicast', vrf='L3VPN-0051')
        self.assertEqual(parsed_output, self.golden_parsed_output2)


# ==============================
# Unit test for
#   * 'show ip bgp all summary'
# ==============================
class test_show_ip_bgp_all_summary(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'bgp_id': 5918,
        'vrf': 
            {'default': 
                {'neighbor': 
                    {'192.168.10.253': 
                        {'address_family': 
                            {'vpnv4 unicast': 
                                {'activity_paths': '5564772/1540171',
                                'activity_prefixes': '2722567/700066',
                                'as': 60103,
                                'attribute_entries': '5098/4898',
                                'bgp_table_version': 9370482,
                                'cache_entries': 
                                    {'filter-list': 
                                        {'memory_usage': 0,
                                        'total_entries': 0},
                                    'route-map': 
                                        {'memory_usage': 0,
                                        'total_entries': 0}},
                                'community_entries': 
                                    {'memory_usage': 60056,
                                    'total_entries': 2301},
                                'entries': 
                                    {'AS-PATH': 
                                        {'memory_usage': 4824,
                                        'total_entries': 201},
                                    'rrinfo': 
                                        {'memory_usage': 20080,
                                        'total_entries': 502}},
                                'input_queue': 0,
                                'local_as': 5918,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 482879760,
                                    'total_entries': 4023998},
                                'prefixes': 
                                    {'memory_usage': 517657344,
                                    'total_entries': 2022099},
                                'route_identifier': '10.169.197.254',
                                'routing_table_version': 9370482,
                                'scan_interval': 60,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'total_memory': 1001967936,
                                'up_down': 'never',
                                'version': 4}}}}}}}

    golden_output1 = {'execute.return_value': '''
        Router#show ip bgp all summary
        Load for five secs: 2%/0%; one minute: 10%; five minutes: 9%
        Time source is NTP, 20:34:39.724 EST Wed Jun 2 2016
        For address family: VPNv4 Unicast
        BGP router identifier 10.169.197.254, local AS number 5918
        BGP table version is 9370482, main routing table version 9370482
        2022099 network entries using 517657344 bytes of memory
        4023998 path entries using 482879760 bytes of memory
        5098/4898 BGP path/bestpath attribute entries using 1345872 bytes of memory
        502 BGP rrinfo entries using 20080 bytes of memory
        201 BGP AS-PATH entries using 4824 bytes of memory
        2301 BGP extended community entries using 60056 bytes of memory
        0 BGP route-map cache entries using 0 bytes of memory
        0 BGP filter-list cache entries using 0 bytes of memory
        BGP using 1001967936 total bytes of memory
        BGP activity 2722567/700066 prefixes, 5564772/1540171 paths, scan interval 60 secs

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        192.168.10.253  4        65555     299     332  9370482    0    0 02:27:39      100
        192.168.10.253  4        60001     299     333  9370482    0    0 02:27:46      100
        192.168.10.253  4        60002     299     333  9370482    0    0 02:27:45      100
        192.168.10.253  4        60003     299     331  9370482    0    0 02:27:40      100
        192.168.10.253  4        60004     299     334  9370482    0    0 02:27:39      100
        192.168.10.253  4        60005     299     334  9370482    0    0 02:27:41      100
        192.168.10.253  4        60006     299     333  9370482    0    0 02:27:43      100
        192.168.10.253  4        60007     299     332  9370482    0    0 02:27:41      100
        192.168.10.253  4        60100       0       0        1    0    0 never    Idle
        192.168.10.253  4        60101       0       0        1    0    0 never    Idle
        192.168.10.253  4        60102       0       0        1    0    0 never    Idle
        192.168.10.253  4        60103       0       0        1    0    0 never    Idle
        '''}

    golden_parsed_output2 = {
        "bgp_id": 65109,
        "vrf": {
            "VRF1": {
                "neighbor": {
                    "192.168.10.253": {
                        "address_family": {
                            "vpnv4": {
                                "version": 4,
                                "as": 65555,
                                "msg_rcvd": 10112,
                                "msg_sent": 10107,
                                "tbl_ver": 263,
                                "input_queue": 0,
                                "output_queue": 0,
                                "up_down": "3d05h",
                                "state_pfxrcd": "13",
                                "route_identifier": "10.169.197.254",
                                "local_as": 65109,
                                "bgp_table_version": 263,
                                "routing_table_version": 263,
                                "attribute_entries": "106/104",
                                "prefixes": {
                                    "total_entries": 126,
                                    "memory_usage": 32256
                                },
                                "path": {
                                    "total_entries": 189,
                                    "memory_usage": 25704
                                },
                                "total_memory": 92688,
                                "activity_prefixes": "226/0",
                                "activity_paths": "4035/3696",
                                "scan_interval": 60,
                                "cache_entries": {
                                    "route-map": {
                                        "total_entries": 0,
                                        "memory_usage": 0
                                    },
                                    "filter-list": {
                                        "total_entries": 0,
                                        "memory_usage": 0
                                    }
                                },
                                "entries": {
                                    "rrinfo": {
                                        "total_entries": 1,
                                        "memory_usage": 40
                                    },
                                    "AS-PATH": {
                                        "total_entries": 2,
                                        "memory_usage": 64
                                    }
                                },
                                "community_entries": {
                                    "total_entries": 102,
                                    "memory_usage": 3248
                                }
                            }
                        }
                    }
                }
            },
            "default": {
                "neighbor": {
                    "192.168.10.253": {
                        "address_family": {
                            "vpnv4": {
                                "version": 4,
                                "as": 65555,
                                "msg_rcvd": 0,
                                "msg_sent": 0,
                                "tbl_ver": 1,
                                "input_queue": 0,
                                "output_queue": 0,
                                "up_down": "never",
                                "state_pfxrcd": "Idle",
                                "route_identifier": "10.169.197.254",
                                "local_as": 65109,
                                "bgp_table_version": 263,
                                "routing_table_version": 263,
                                "attribute_entries": "106/104",
                                "prefixes": {
                                    "total_entries": 126,
                                    "memory_usage": 32256
                                },
                                "path": {
                                    "total_entries": 189,
                                    "memory_usage": 25704
                                },
                                "total_memory": 92688,
                                "activity_prefixes": "226/0",
                                "activity_paths": "4035/3696",
                                "scan_interval": 60,
                                "cache_entries": {
                                    "route-map": {
                                        "total_entries": 0,
                                        "memory_usage": 0
                                    },
                                    "filter-list": {
                                        "total_entries": 0,
                                        "memory_usage": 0
                                    }
                                },
                                "entries": {
                                    "rrinfo": {
                                        "total_entries": 1,
                                        "memory_usage": 40
                                    },
                                    "AS-PATH": {
                                        "total_entries": 2,
                                        "memory_usage": 64
                                    }
                                },
                                "community_entries": {
                                    "total_entries": 102,
                                    "memory_usage": 3248
                                }
                            }
                        }
                    },
                    "192.168.36.119": {
                        "address_family": {
                            "vpnv4": {
                                "version": 4,
                                "as": 65109,
                                "msg_rcvd": 10293,
                                "msg_sent": 10213,
                                "tbl_ver": 263,
                                "input_queue": 0,
                                "output_queue": 0,
                                "up_down": "3d05h",
                                "state_pfxrcd": "62",
                                "route_identifier": "10.169.197.254",
                                "local_as": 65109,
                                "bgp_table_version": 263,
                                "routing_table_version": 263,
                                "attribute_entries": "106/104",
                                "prefixes": {
                                    "total_entries": 126,
                                    "memory_usage": 32256
                                },
                                "path": {
                                    "total_entries": 189,
                                    "memory_usage": 25704
                                },
                                "total_memory": 92688,
                                "activity_prefixes": "226/0",
                                "activity_paths": "4035/3696",
                                "scan_interval": 60,
                                "cache_entries": {
                                    "route-map": {
                                        "total_entries": 0,
                                        "memory_usage": 0
                                    },
                                    "filter-list": {
                                        "total_entries": 0,
                                        "memory_usage": 0
                                    }
                                },
                                "entries": {
                                    "rrinfo": {
                                        "total_entries": 1,
                                        "memory_usage": 40
                                    },
                                    "AS-PATH": {
                                        "total_entries": 2,
                                        "memory_usage": 64
                                    }
                                },
                                "community_entries": {
                                    "total_entries": 102,
                                    "memory_usage": 3248
                                }
                            }
                        }
                    },
                    "192.168.36.120": {
                        "address_family": {
                            "vpnv4": {
                                "version": 4,
                                "as": 65109,
                                "msg_rcvd": 9930,
                                "msg_sent": 9826,
                                "tbl_ver": 263,
                                "input_queue": 0,
                                "output_queue": 0,
                                "up_down": "3d02h",
                                "state_pfxrcd": "62",
                                "route_identifier": "10.169.197.254",
                                "local_as": 65109,
                                "bgp_table_version": 263,
                                "routing_table_version": 263,
                                "attribute_entries": "106/104",
                                "prefixes": {
                                    "total_entries": 126,
                                    "memory_usage": 32256
                                },
                                "path": {
                                    "total_entries": 189,
                                    "memory_usage": 25704
                                },
                                "total_memory": 92688,
                                "activity_prefixes": "226/0",
                                "activity_paths": "4035/3696",
                                "scan_interval": 60,
                                "cache_entries": {
                                    "route-map": {
                                        "total_entries": 0,
                                        "memory_usage": 0
                                    },
                                    "filter-list": {
                                        "total_entries": 0,
                                        "memory_usage": 0
                                    }
                                },
                                "entries": {
                                    "rrinfo": {
                                        "total_entries": 1,
                                        "memory_usage": 40
                                    },
                                    "AS-PATH": {
                                        "total_entries": 2,
                                        "memory_usage": 64
                                    }
                                },
                                "community_entries": {
                                    "total_entries": 102,
                                    "memory_usage": 3248
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    def test_show_ip_bgp_all_summary_empty(self):
        self.device1 = Mock(**self.empty_output)
        bgp_summary_obj = ShowIpBgpAllSummary(device=self.device1)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = bgp_summary_obj.parse()

    def test_show_ip_bgp_all_summary_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowIpBgpAllSummary(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_ip_bgp_all_summary_golden2(self):

        def mapper(key):
            return self.outputs[key]

        raw1 = '''\
         address-family ipv4 vrf VRF1
          bgp router-id 192.168.10.254
          redistribute connected
          redistribute static
          neighbor 192.168.10.253 remote-as 65555
          neighbor 192.168.10.253 timers 30 90 15
          neighbor 192.168.10.253 activate
          neighbor 192.168.10.253 as-override
          neighbor 192.168.10.253 route-map prepend in         
        '''

        golden_output2 = '''\
            PE1#show ip bgp vpnv4 all summary
            Load for five secs: 1%/0%; one minute: 1%; five minutes: 1%
            Time source is NTP, 05:46:49.882 EST Tue May 28 2019
            BGP router identifier 10.169.197.254, local AS number 65109
            BGP table version is 263, main routing table version 263
            126 network entries using 32256 bytes of memory
            189 path entries using 25704 bytes of memory
            106/104 BGP path/bestpath attribute entries using 31376 bytes of memory
            1 BGP rrinfo entries using 40 bytes of memory
            2 BGP AS-PATH entries using 64 bytes of memory
            102 BGP extended community entries using 3248 bytes of memory
            0 BGP route-map cache entries using 0 bytes of memory
            0 BGP filter-list cache entries using 0 bytes of memory
            BGP using 92688 total bytes of memory
            BGP activity 226/0 prefixes, 4035/3696 paths, scan interval 60 secs

            Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
            192.168.10.253  4        65555   10112   10107      263    0    0 3d05h          13
            192.168.10.253  4        65555       0       0        1    0    0 never    Idle           
            192.168.36.119 4         65109   10293   10213      263    0    0 3d05h          62
            192.168.36.120 4         65109    9930    9826      263    0    0 3d02h          62
        '''

        self.outputs = {}
        self.maxDiff = None 
        self.outputs['show ip bgp vpnv4 all summary'] = golden_output2
        self.outputs['show run | sec address-family ipv4 vrf'] = raw1
        self.outputs['show run | sec address-family ipv6 vrf'] = ''

        self.device.execute = Mock()
        self.device.execute.side_effect = mapper

        obj = ShowIpBgpAllSummary(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4')
        self.assertEqual(parsed_output, self.golden_parsed_output2)

    def test_show_ip_bgp_all_summary_golden3(self):

        def mapper(key):
            return self.outputs[key]
        
        raw1 = '''
            [2019-06-05 09:46:16,345] +++ R1_xe: executing command 'show ip bgp all summary' +++
            show ip bgp all summary
            For address family: IPv4 Unicast
            BGP router identifier 10.4.1.1, local AS number 65000
            BGP table version is 4, main routing table version 4
            3 network entries using 744 bytes of memory
            3 path entries using 408 bytes of memory
            3/3 BGP path/bestpath attribute entries using 840 bytes of memory
            2 BGP extended community entries using 500 bytes of memory
            0 BGP route-map cache entries using 0 bytes of memory
            0 BGP filter-list cache entries using 0 bytes of memory
            BGP using 2492 total bytes of memory
            BGP activity 12/0 prefixes, 12/0 paths, scan interval 60 secs

            Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
            10.16.2.2         4        65000   30178   33211        4    0    0 2w6d            1
            10.36.3.3         4        65000   30182   33227        4    0    0 2w6d            1

            For address family: IPv6 Unicast
            BGP router identifier 10.4.1.1, local AS number 65000
            BGP table version is 5, main routing table version 5
            3 network entries using 816 bytes of memory
            3 path entries using 456 bytes of memory
            3/3 BGP path/bestpath attribute entries using 840 bytes of memory
            2 BGP extended community entries using 500 bytes of memory
            0 BGP route-map cache entries using 0 bytes of memory
            0 BGP filter-list cache entries using 0 bytes of memory
            BGP using 2612 total bytes of memory
            BGP activity 12/0 prefixes, 12/0 paths, scan interval 60 secs

            Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
            2001:2:2:2::2   4        65000   30178   33214        5    0    0 2w6d            1
            2001:3:3:3::3   4        65000   30182   33196        5    0    0 2w6d            1

            For address family: VPNv4 Unicast
            BGP router identifier 10.4.1.1, local AS number 65000
            BGP table version is 4, main routing table version 4
            3 network entries using 768 bytes of memory
            3 path entries using 408 bytes of memory
            3/3 BGP path/bestpath attribute entries using 888 bytes of memory
            2 BGP extended community entries using 500 bytes of memory
            0 BGP route-map cache entries using 0 bytes of memory
            0 BGP filter-list cache entries using 0 bytes of memory
            BGP using 2564 total bytes of memory
            BGP activity 12/0 prefixes, 12/0 paths, scan interval 60 secs

            Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
            10.16.2.2         4        65000   30178   33215        4    0    0 2w6d            1
            10.36.3.3         4        65000   30182   33221        4    0    0 2w6d            1

            For address family: VPNv6 Unicast
            BGP router identifier 10.4.1.1, local AS number 65000
            BGP table version is 5, main routing table version 5
            3 network entries using 840 bytes of memory
            3 path entries using 468 bytes of memory
            3/3 BGP path/bestpath attribute entries using 888 bytes of memory
            2 BGP extended community entries using 500 bytes of memory
            0 BGP route-map cache entries using 0 bytes of memory
            0 BGP filter-list cache entries using 0 bytes of memory
            BGP using 2696 total bytes of memory
            BGP activity 12/0 prefixes, 12/0 paths, scan interval 60 secs

            Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
            2001:2:2:2::2   4        65000   30178   33203        5    0    0 2w6d            1
            2001:3:3:3::3   4        65000   30183   33216        5    0    0 2w6d            1
        '''

        raw2 = '''
            [2019-06-05 09:46:59,306] +++ R1_xe: executing command 'show run | sec address-family ipv4 vrf' +++
            show run | sec address-family ipv4 vrf
             address-family ipv4 vrf VRF1
              network 10.1.0.0
              network 10.0.0.0
              no auto-summary
             address-family ipv4 vrf VRF1
              network 10.4.1.1 mask 255.255.255.255
              neighbor 10.16.2.2 remote-as 65000
              neighbor 10.16.2.2 update-source Loopback300
              neighbor 10.16.2.2 activate
              neighbor 10.36.3.3 remote-as 65000
              neighbor 10.36.3.3 update-source Loopback300
              neighbor 10.36.3.3 activate
        '''

        raw3='''
            [2019-06-05 09:47:19,474] +++ R1_xe: executing command 'show run | sec address-family ipv6 vrf' +++
            show run | sec address-family ipv6 vrf
             address-family ipv6 vrf VRF1
              network 2001:1:1:1::1/128
              neighbor 2001:2:2:2::2 remote-as 65000
              neighbor 2001:2:2:2::2 update-source Loopback300
              neighbor 2001:2:2:2::2 activate
              neighbor 2001:3:3:3::3 remote-as 65000
              neighbor 2001:3:3:3::3 update-source Loopback300
              neighbor 2001:3:3:3::3 activate
             address-family ipv6 vrf VRF1
        '''

        parsed_output3 = {
            "bgp_id": 65000,
            "vrf": {
                "VRF1": {
                    "neighbor": {
                        "10.16.2.2": {
                            "address_family": {
                                "vpnv4 unicast": {
                                    "activity_paths": "12/0",
                                    "activity_prefixes": "12/0",
                                    "as": 65000,
                                    "attribute_entries": "3/3",
                                    "bgp_table_version": 4,
                                    "cache_entries": {
                                        "filter-list": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        },
                                        "route-map": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        }
                                    },
                                    "community_entries": {
                                        "memory_usage": 500,
                                        "total_entries": 2
                                    },
                                    "input_queue": 0,
                                    "local_as": 65000,
                                    "msg_rcvd": 30178,
                                    "msg_sent": 33215,
                                    "output_queue": 0,
                                    "path": {
                                        "memory_usage": 408,
                                        "total_entries": 3
                                    },
                                    "prefixes": {
                                        "memory_usage": 768,
                                        "total_entries": 3
                                    },
                                    "route_identifier": "10.4.1.1",
                                    "routing_table_version": 4,
                                    "scan_interval": 60,
                                    "state_pfxrcd": "1",
                                    "tbl_ver": 4,
                                    "total_memory": 2564,
                                    "up_down": "2w6d",
                                    "version": 4
                                }
                            }
                        },
                        "2001:2:2:2::2": {
                            "address_family": {
                                "vpnv6 unicast": {
                                    "activity_paths": "12/0",
                                    "activity_prefixes": "12/0",
                                    "as": 65000,
                                    "attribute_entries": "3/3",
                                    "bgp_table_version": 5,
                                    "cache_entries": {
                                        "filter-list": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        },
                                        "route-map": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        }
                                    },
                                    "community_entries": {
                                        "memory_usage": 500,
                                        "total_entries": 2
                                    },
                                    "input_queue": 0,
                                    "local_as": 65000,
                                    "msg_rcvd": 30178,
                                    "msg_sent": 33203,
                                    "output_queue": 0,
                                    "path": {
                                        "memory_usage": 468,
                                        "total_entries": 3
                                    },
                                    "prefixes": {
                                        "memory_usage": 840,
                                        "total_entries": 3
                                    },
                                    "route_identifier": "10.4.1.1",
                                    "routing_table_version": 5,
                                    "scan_interval": 60,
                                    "state_pfxrcd": "1",
                                    "tbl_ver": 5,
                                    "total_memory": 2696,
                                    "up_down": "2w6d",
                                    "version": 4
                                }
                            }
                        },
                        "2001:3:3:3::3": {
                            "address_family": {
                                "vpnv6 unicast": {
                                    "activity_paths": "12/0",
                                    "activity_prefixes": "12/0",
                                    "as": 65000,
                                    "attribute_entries": "3/3",
                                    "bgp_table_version": 5,
                                    "cache_entries": {
                                        "filter-list": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        },
                                        "route-map": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        }
                                    },
                                    "community_entries": {
                                        "memory_usage": 500,
                                        "total_entries": 2
                                    },
                                    "input_queue": 0,
                                    "local_as": 65000,
                                    "msg_rcvd": 30183,
                                    "msg_sent": 33216,
                                    "output_queue": 0,
                                    "path": {
                                        "memory_usage": 468,
                                        "total_entries": 3
                                    },
                                    "prefixes": {
                                        "memory_usage": 840,
                                        "total_entries": 3
                                    },
                                    "route_identifier": "10.4.1.1",
                                    "routing_table_version": 5,
                                    "scan_interval": 60,
                                    "state_pfxrcd": "1",
                                    "tbl_ver": 5,
                                    "total_memory": 2696,
                                    "up_down": "2w6d",
                                    "version": 4
                                }
                            }
                        },
                        "10.36.3.3": {
                            "address_family": {
                                "vpnv4 unicast": {
                                    "activity_paths": "12/0",
                                    "activity_prefixes": "12/0",
                                    "as": 65000,
                                    "attribute_entries": "3/3",
                                    "bgp_table_version": 4,
                                    "cache_entries": {
                                        "filter-list": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        },
                                        "route-map": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        }
                                    },
                                    "community_entries": {
                                        "memory_usage": 500,
                                        "total_entries": 2
                                    },
                                    "input_queue": 0,
                                    "local_as": 65000,
                                    "msg_rcvd": 30182,
                                    "msg_sent": 33221,
                                    "output_queue": 0,
                                    "path": {
                                        "memory_usage": 408,
                                        "total_entries": 3
                                    },
                                    "prefixes": {
                                        "memory_usage": 768,
                                        "total_entries": 3
                                    },
                                    "route_identifier": "10.4.1.1",
                                    "routing_table_version": 4,
                                    "scan_interval": 60,
                                    "state_pfxrcd": "1",
                                    "tbl_ver": 4,
                                    "total_memory": 2564,
                                    "up_down": "2w6d",
                                    "version": 4
                                }
                            }
                        }
                    }
                },
                "default": {
                    "neighbor": {
                        "10.16.2.2": {
                            "address_family": {
                                "ipv4 unicast": {
                                    "activity_paths": "12/0",
                                    "activity_prefixes": "12/0",
                                    "as": 65000,
                                    "attribute_entries": "3/3",
                                    "bgp_table_version": 4,
                                    "cache_entries": {
                                        "filter-list": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        },
                                        "route-map": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        }
                                    },
                                    "community_entries": {
                                        "memory_usage": 500,
                                        "total_entries": 2
                                    },
                                    "input_queue": 0,
                                    "local_as": 65000,
                                    "msg_rcvd": 30178,
                                    "msg_sent": 33211,
                                    "output_queue": 0,
                                    "path": {
                                        "memory_usage": 408,
                                        "total_entries": 3
                                    },
                                    "prefixes": {
                                        "memory_usage": 744,
                                        "total_entries": 3
                                    },
                                    "route_identifier": "10.4.1.1",
                                    "routing_table_version": 4,
                                    "scan_interval": 60,
                                    "state_pfxrcd": "1",
                                    "tbl_ver": 4,
                                    "total_memory": 2492,
                                    "up_down": "2w6d",
                                    "version": 4
                                }
                            }
                        },
                        "2001:2:2:2::2": {
                            "address_family": {
                                "ipv6 unicast": {
                                    "activity_paths": "12/0",
                                    "activity_prefixes": "12/0",
                                    "as": 65000,
                                    "attribute_entries": "3/3",
                                    "bgp_table_version": 5,
                                    "cache_entries": {
                                        "filter-list": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        },
                                        "route-map": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        }
                                    },
                                    "community_entries": {
                                        "memory_usage": 500,
                                        "total_entries": 2
                                    },
                                    "input_queue": 0,
                                    "local_as": 65000,
                                    "msg_rcvd": 30178,
                                    "msg_sent": 33214,
                                    "output_queue": 0,
                                    "path": {
                                        "memory_usage": 456,
                                        "total_entries": 3
                                    },
                                    "prefixes": {
                                        "memory_usage": 816,
                                        "total_entries": 3
                                    },
                                    "route_identifier": "10.4.1.1",
                                    "routing_table_version": 5,
                                    "scan_interval": 60,
                                    "state_pfxrcd": "1",
                                    "tbl_ver": 5,
                                    "total_memory": 2612,
                                    "up_down": "2w6d",
                                    "version": 4
                                }
                            }
                        },
                        "2001:3:3:3::3": {
                            "address_family": {
                                "ipv6 unicast": {
                                    "activity_paths": "12/0",
                                    "activity_prefixes": "12/0",
                                    "as": 65000,
                                    "attribute_entries": "3/3",
                                    "bgp_table_version": 5,
                                    "cache_entries": {
                                        "filter-list": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        },
                                        "route-map": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        }
                                    },
                                    "community_entries": {
                                        "memory_usage": 500,
                                        "total_entries": 2
                                    },
                                    "input_queue": 0,
                                    "local_as": 65000,
                                    "msg_rcvd": 30182,
                                    "msg_sent": 33196,
                                    "output_queue": 0,
                                    "path": {
                                        "memory_usage": 456,
                                        "total_entries": 3
                                    },
                                    "prefixes": {
                                        "memory_usage": 816,
                                        "total_entries": 3
                                    },
                                    "route_identifier": "10.4.1.1",
                                    "routing_table_version": 5,
                                    "scan_interval": 60,
                                    "state_pfxrcd": "1",
                                    "tbl_ver": 5,
                                    "total_memory": 2612,
                                    "up_down": "2w6d",
                                    "version": 4
                                }
                            }
                        },
                        "10.36.3.3": {
                            "address_family": {
                                "ipv4 unicast": {
                                    "activity_paths": "12/0",
                                    "activity_prefixes": "12/0",
                                    "as": 65000,
                                    "attribute_entries": "3/3",
                                    "bgp_table_version": 4,
                                    "cache_entries": {
                                        "filter-list": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        },
                                        "route-map": {
                                            "memory_usage": 0,
                                            "total_entries": 0
                                        }
                                    },
                                    "community_entries": {
                                        "memory_usage": 500,
                                        "total_entries": 2
                                    },
                                    "input_queue": 0,
                                    "local_as": 65000,
                                    "msg_rcvd": 30182,
                                    "msg_sent": 33227,
                                    "output_queue": 0,
                                    "path": {
                                        "memory_usage": 408,
                                        "total_entries": 3
                                    },
                                    "prefixes": {
                                        "memory_usage": 744,
                                        "total_entries": 3
                                    },
                                    "route_identifier": "10.4.1.1",
                                    "routing_table_version": 4,
                                    "scan_interval": 60,
                                    "state_pfxrcd": "1",
                                    "tbl_ver": 4,
                                    "total_memory": 2492,
                                    "up_down": "2w6d",
                                    "version": 4
                                }
                            }
                        }
                    }
                }
            }
        }

        self.outputs = {}
        self.maxDiff = None 
        self.outputs['show ip bgp all summary'] = raw1
        self.outputs['show run | sec address-family ipv4 vrf'] = raw2
        self.outputs['show run | sec address-family ipv6 vrf'] = raw3

        self.device.execute = Mock()
        self.device.execute.side_effect = mapper

        obj = ShowIpBgpAllSummary(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, parsed_output3)


# ====================================================
# Unit test for
#   * 'show ip bgp {address_family} vrf {vrf} summary
# ====================================================
class test_show_ip_bgp_summary(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'bgp_id': 5918,
        'vrf': 
            {'L3VPN-1151': 
                {'neighbor': 
                    {'192.168.10.253': 
                        {'address_family': 
                            {'vpnv4': 
                                {'activity_paths': '5564978/1540171',
                                'activity_prefixes': '2722671/700066',
                                'as': 61100,
                                'attribute_entries': '5101/4901',
                                'bgp_table_version': 9370786,
                                'cache_entries': 
                                    {'filter-list': 
                                        {'memory_usage': 0,
                                        'total_entries': 0},
                                    'route-map': 
                                        {'memory_usage': 0,
                                        'total_entries': 0}},
                                'community_entries': 
                                    {'memory_usage': 60120,
                                    'total_entries': 2303},
                                'entries': 
                                    {'AS-PATH': 
                                        {'memory_usage': 4824,
                                        'total_entries': 201},
                                    'rrinfo': 
                                        {'memory_usage': 20080,
                                        'total_entries': 502}},
                                'input_queue': 0,
                                'local_as': 5918,
                                'msg_rcvd': 0,
                                'msg_sent': 0,
                                'output_queue': 0,
                                'path': 
                                    {'memory_usage': 24360,
                                    'total_entries': 203},
                                'prefixes': 
                                    {'memory_usage': 26112,
                                    'total_entries': 102},
                                'route_identifier': '192.168.10.254',
                                'routing_table_version': 9370786,
                                'scan_interval': 60,
                                'state_pfxrcd': 'Idle',
                                'tbl_ver': 1,
                                'total_memory': 1482160,
                                'up_down': 'never',
                                'version': 4}}}}}}}

    golden_output1 = {'execute.return_value': '''
        Router#show ip bgp vpnv4 vrf L3VPN-1151 summary
        Load for five secs: 1%/0%; one minute: 57%; five minutes: 26%
        Time source is NTP, 20:39:33.145 EST Wed Jun 2 2016
        BGP router identifier 192.168.10.254, local AS number 5918
        BGP table version is 9370786, main routing table version 9370786
        102 network entries using 26112 bytes of memory
        203 path entries using 24360 bytes of memory
        5101/4901 BGP path/bestpath attribute entries using 1346664 bytes of memory
        502 BGP rrinfo entries using 20080 bytes of memory
        201 BGP AS-PATH entries using 4824 bytes of memory
        2303 BGP extended community entries using 60120 bytes of memory
        0 BGP route-map cache entries using 0 bytes of memory
        0 BGP filter-list cache entries using 0 bytes of memory
        BGP using 1482160 total bytes of memory
        BGP activity 2722671/700066 prefixes, 5564978/1540171 paths, scan interval 60 secs

        Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
        192.168.10.253  4        61100       0       0        1    0    0 never    Idle
        '''}

    golden_parsed_output2 = {
        'bgp_id': 65109, 
        'vrf': {
            'VRF1': {
                'neighbor': {
                    '192.168.10.253': {
                        'address_family': {
                            'vpnv4': {
                                'version': 4, 
                                'as': 65555, 
                                'msg_rcvd': 9586, 
                                'msg_sent': 9590, 
                                'tbl_ver': 250, 
                                'input_queue': 0, 
                                'output_queue': 0, 
                                'up_down': '3d01h', 
                                'state_pfxrcd': '13', 
                                'route_identifier': '192.168.10.254', 
                                'local_as': 65109, 
                                'bgp_table_version': 250, 
                                'routing_table_version': 250, 
                                'attribute_entries': '105/104', 
                                'prefixes': {
                                    'total_entries': 25, 
                                    'memory_usage': 6400}, 
                                'path': {
                                    'total_entries': 38, 
                                    'memory_usage': 5168}, 
                                'total_memory': 45960, 
                                'activity_prefixes': '226/0', 
                                'activity_paths': '787/448', 
                                'scan_interval': 60, 
                                'cache_entries': {
                                    'route-map': {
                                        'total_entries': 0, 
                                        'memory_usage': 0}, 
                                    'filter-list': {
                                        'total_entries': 0, 
                                        'memory_usage': 0}}, 
                                'entries': {
                                    'rrinfo': {
                                        'total_entries': 1, 'memory_usage': 40}, 
                                    'AS-PATH': {
                                        'total_entries': 1, 
                                        'memory_usage': 24}}, 
                                    'community_entries': {
                                        'total_entries': 102, 
                                        'memory_usage': 3248}}}}}}}}


    golden_parsed_output3 = {
        'bgp_id': 65109,
        'vrf': {
            'VRF1': {
                'neighbor': {
                    '192.168.10.253': {
                        'address_family': {
                            'vpnv4 unicast': {
                                'activity_paths': '787/448',
                                'activity_prefixes': '226/0',
                                'as': 65555,
                                'attribute_entries': '105/104',
                                'bgp_table_version': 250,
                                'cache_entries': {
                                    'filter-list': {
                                    'memory_usage': 0,
                                    'total_entries': 0},
                                'route-map': {
                                    'memory_usage': 0,
                                    'total_entries': 0}},
                                'community_entries': {
                                    'memory_usage': 3248,
                                    'total_entries': 102},
                                'entries': {
                                    'AS-PATH': {
                                        'memory_usage': 24,
                                        'total_entries': 1},
                                    'rrinfo': {
                                        'memory_usage': 40,
                                        'total_entries': 1}},
                                'input_queue': 0,
                                'local_as': 65109,
                                'msg_rcvd': 9694,
                                'msg_sent': 9698,
                                'output_queue': 0,
                                'path': {
                                    'memory_usage': 5168,
                                    'total_entries': 38},
                                'prefixes': {
                                    'memory_usage': 6400,
                                    'total_entries': 25},
                                'route_identifier': '192.168.10.254',
                                'routing_table_version': 250,
                                'scan_interval': 60,
                                'state_pfxrcd': '13',
                                'tbl_ver': 250,
                                'total_memory': 45960,
                                'up_down': '3d02h',
                                'version': 4}}}}}}}

    def test_show_ip_bgp_summary_empty(self):
        self.device1 = Mock(**self.empty_output)
        bgp_summary_obj = ShowIpBgpSummary(device=self.device1)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = bgp_summary_obj.parse()

    def test_show_ip_bgp_summary_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowIpBgpSummary(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4', vrf='L3VPN-1151')
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_ip_bgp_summary_golden2(self):
        def mapper(key):
            return self.outputs[key]

        raw1 = '''/
            PE1#show ip bgp vpnv4 rd 65109:4093 summary 
            Load for five secs: 1%/0%; one minute: 1%; five minutes: 1%
            Time source is NTP, 23:18:11.225 EST Mon Jun 3 2019
            BGP router identifier 192.168.10.254, local AS number 65109
            BGP table version is 250, main routing table version 250
            25 network entries using 6400 bytes of memory
            38 path entries using 5168 bytes of memory
            105/104 BGP path/bestpath attribute entries using 31080 bytes of memory
            1 BGP rrinfo entries using 40 bytes of memory
            1 BGP AS-PATH entries using 24 bytes of memory
            102 BGP extended community entries using 3248 bytes of memory
            0 BGP route-map cache entries using 0 bytes of memory
            0 BGP filter-list cache entries using 0 bytes of memory
            BGP using 45960 total bytes of memory
            BGP activity 226/0 prefixes, 787/448 paths, scan interval 60 secs

            Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
            192.168.10.253  4        65555    9586    9590      250    0    0 3d01h          13
        '''

        raw2 = '''
            show vrf
            Load for five secs: 1%/0%; one minute: 1%; five minutes: 1%
            Time source is NTP, 23:19:19.766 EST Mon Jun 3 2019

              Name                             Default RD            Protocols   Interfaces
              VRF1                          65109:4093             ipv4        Gi8.4093              
        '''

        self.outputs = {}
        self.maxDiff = None
        self.outputs['show vrf'] = raw2
        self.outputs['show ip bgp vpnv4 rd 65109:4093 summary'] = raw1

        self.device.execute = Mock()
        self.device.execute.side_effect = mapper
        obj = ShowIpBgpSummary(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4', rd='65109:4093')
        self.assertEqual(parsed_output, self.golden_parsed_output2)

    def test_show_ip_bgp_summary_golden3(self):
        def mapper(key):
            return self.outputs[key]

        raw1 = '''/
            PE1#show bgp vpnv4 unicast rd 65109:4093 summary
            Load for five secs: 1%/0%; one minute: 1%; five minutes: 1%
            Time source is NTP, 00:07:47.856 EST Tue Jun 4 2019
            BGP router identifier 192.168.10.254, local AS number 65109
            BGP table version is 250, main routing table version 250
            25 network entries using 6400 bytes of memory
            38 path entries using 5168 bytes of memory
            105/104 BGP path/bestpath attribute entries using 31080 bytes of memory
            1 BGP rrinfo entries using 40 bytes of memory
            1 BGP AS-PATH entries using 24 bytes of memory
            102 BGP extended community entries using 3248 bytes of memory
            0 BGP route-map cache entries using 0 bytes of memory
            0 BGP filter-list cache entries using 0 bytes of memory
            BGP using 45960 total bytes of memory
            BGP activity 226/0 prefixes, 787/448 paths, scan interval 60 secs

            Neighbor        V           AS MsgRcvd MsgSent   TblVer  InQ OutQ Up/Down  State/PfxRcd
            192.168.10.253  4        65555    9694    9698      250    0    0 3d02h          13
        '''

        raw2 = '''
            show vrf
            Load for five secs: 1%/0%; one minute: 1%; five minutes: 1%
            Time source is NTP, 23:19:19.766 EST Mon Jun 3 2019

              Name                             Default RD            Protocols   Interfaces
              VRF1                          65109:4093             ipv4        Gi8.4093              
        '''

        self.outputs = {}
        self.maxDiff = None
        self.outputs['show vrf'] = raw2
        self.outputs['show bgp vpnv4 unicast rd 65109:4093 summary'] = raw1

        self.device.execute = Mock()
        self.device.execute.side_effect = mapper
        obj = ShowBgpSummary(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4 unicast', rd='65109:4093')
        self.assertEqual(parsed_output, self.golden_parsed_output3)



#-------------------------------------------------------------------------------


# =========================================================
# Unit test for:
#   * 'show bgp all neighbors'
#   * 'show bgp {address_family} all neighbors {neighbor}'
# =========================================================
class test_show_bgp_all_neighbors(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'list_of_neighbors': ['10.16.2.2',
                             '10.36.3.3',
                             '10.4.6.6',
                             '10.66.6.6',
                             '10.64.4.4',
                             '10.100.5.5',
                             '2001:DB8:4:6::6',
                             '2001:DB8:20:4:6::6'],
        'vrf': 
            {'VRF1': 
                {'neighbor': 
                    {'10.4.6.6': 
                        {'address_family': 
                            {'vpnv4 unicast': 
                                {'current_time': '0x530A19',
                                'last_read': '00:00:33',
                                'last_write': '00:00:30',
                                'session_state': 'Established',
                                'up_time': '01:01:59'}},
                        'bgp_event_timer': 
                            {'next': 
                                {'ackhold': '0x0',
                                'deadwait': '0x0',
                                'giveup': '0x0',
                                'keepalive': '0x0',
                                'linger': '0x0',
                                'pmtuager': '0x0',
                                'processq': '0x0',
                                'retrans': '0x0',
                                'sendwnd': '0x0',
                                'timewait': '0x0'},
                            'starts': 
                                {'ackhold': 66,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 71,
                                'sendwnd': 0,
                                'timewait': 0},
                            'wakeups': 
                                {'ackhold': 64,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 0,
                                'sendwnd': 0,
                                'timewait': 0}},
                        'bgp_neighbor_session': {
                        'sessions': 1,
                        },
                        'bgp_negotiated_capabilities': 
                            {'enhanced_refresh': 'advertised',
                            'four_octets_asn': 'advertised',
                            'ipv4_unicast': 'advertised '
                                            'and '
                                            'received',
                            'route_refresh': 'advertised',
                            'stateful_switchover': 'NO '
                                                   'for '
                                                   'session '
                                                   '1'},
                        'bgp_negotiated_keepalive_timers': 
                            {'hold_time': 180,
                            'keepalive_interval': 60},
                        'bgp_neighbor_counters': 
                            {'messages': 
                                {'in_queue_depth': 0,
                                'out_queue_depth': 0,
                                'received': 
                                    {'keepalives': 64,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 66,
                                    'updates': 1},
                                'sent': 
                                    {'keepalives': 69,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 73,
                                    'updates': 3}}},
                        'bgp_session_transport': 
                            {'ack_hold': 200,
                            'address_tracking_status': 'enabled',
                            'connection': 
                                {'dropped': 1,
                                'established': 2,
                                'last_reset': '01:02:11',
                                'reset_reason': 'Peer '
                                             'closed '
                                             'the '
                                             'session '
                                             'of '
                                             'session '
                                             '1'},
                            'connection_state': 'estab',
                            'connection_tableid': 1,
                            'datagram': 
                                {'datagram_received': 
                                    {'out_of_order': 0,
                                    'total_data': 1330,
                                    'value': 137,
                                    'with_data': 66},
                                'datagram_sent': 
                                    {'fastretransmit': 0,
                                    'partialack': 0,
                                    'retransmit': 0,
                                    'second_congestion': 0,
                                    'total_data': 1537,
                                    'value': 138,
                                    'with_data': 72}},
                            'delrcvwnd': 1330,
                            'ecn_connection': 'disabled',
                            'enqueued_packets': 
                                {'input_packet': 0,
                                'mis_ordered_packet': 0,
                                'retransmit_packet': 0},
                            'fast_lock_acquisition_failures': 0,
                            'graceful_restart': 'disabled',
                            'io_status': 1,
                            'ip_precedence_value': 6,
                            'irs': 930048172,
                            'iss': 271842,
                            'krtt': 0,
                            'lock_slow_path': 0,
                            'max_rtt': 1000,
                            'maximum_output_segment_queue_size': 50,
                            'maxrcvwnd': 16384,
                            'min_rtt': 1,
                            'min_time_between_advertisement_runs': 0,
                            'minimum_incoming_ttl': 0,
                            'option_flags': 'VRF '
                                            'id '
                                            'set, '
                                            'nagle, '
                                            'path '
                                            'mtu '
                                            'capable',
                            'outgoing_ttl': 1,
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'rcv_scale': 0,
                            'rcvnxt': 930049503,
                            'rcvwnd': 15054,
                            'receive_idletime': 30999,
                            'rib_route_ip': '10.4.6.6',
                            'rtto': 1003,
                            'rtv': 3,
                            'sent_idletime': 31107,
                            'snd_scale': 0,
                            'sndnxt': 273380,
                            'snduna': 273380,
                            'sndwnd': 32000,
                            'srtt': 1000,
                            'status_flags': 'passive '
                                            'open, '
                                            'gen '
                                            'tcbs',
                            'tcp_path_mtu_discovery': 'enabled',
                            'tcp_semaphore': '0x1286E62C',
                            'tcp_semaphore_status': 'FREE',
                            'transport': 
                                {'foreign_host': '10.4.6.6',
                                'foreign_port': '11010',
                                'local_host': '10.4.6.4',
                                'local_port': '179',
                                'mss': 1460},
                            'unread_input_bytes': 0,
                            'uptime': 3720132},
                        'bgp_version': 4,
                        'link': 'external',
                        'remote_as': 300,
                        'router_id': '10.4.6.6',
                        'session_state': 'Established',
                        'shutdown': True},
                    '2001:DB8:4:6::6': 
                        {'address_family': 
                            {'vpnv6 unicast': 
                                {'current_time': '0x5315CE',
                                'last_read': '00:00:32',
                                'last_write': '00:00:06',
                                'session_state': 'Established',
                                'up_time': '01:01:58'},
                            },
                        'bgp_event_timer': 
                            {'next': 
                                {'ackhold': '0x0',
                                'deadwait': '0x0',
                                'giveup': '0x0',
                                'keepalive': '0x0',
                                'linger': '0x0',
                                'pmtuager': '0x0',
                                'processq': '0x0',
                                'retrans': '0x0',
                                'sendwnd': '0x0',
                                'timewait': '0x0'},
                            'starts': 
                                {'ackhold': 66,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 72,
                                'sendwnd': 0,
                                'timewait': 0},
                            'wakeups': 
                                {'ackhold': 64,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 0,
                                'sendwnd': 0,
                                'timewait': 0}},
                                'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': 
                            {'enhanced_refresh': 'advertised',
                            'four_octets_asn': 'advertised',
                            'ipv6_unicast': 'advertised '
                                            'and '
                                            'received',
                            'route_refresh': 'advertised',
                            'stateful_switchover': 'NO '
                                                   'for '
                                                   'session '
                                                   '1'},
                        'bgp_negotiated_keepalive_timers': 
                            {'hold_time': 180,
                            'keepalive_interval': 60},
                        'bgp_neighbor_counters': 
                            {'messages': 
                                {'in_queue_depth': 0,
                                'out_queue_depth': 0,
                                'received': 
                                    {'keepalives': 64,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 66,
                                    'updates': 1},
                                'sent': 
                                    {'keepalives': 70,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 74,
                                    'updates': 3}}},
                        'bgp_session_transport': 
                            {'ack_hold': 200,
                            'address_tracking_status': 'enabled',
                            'connection': 
                                {'dropped': 1,
                                'established': 2,
                                'last_reset': '01:05:12',
                                'reset_reason': 'Active '
                                                'open '
                                                'failed'},
                            'connection_state': 'estab',
                            'connection_tableid': 503316481,
                            'datagram': 
                                {'datagram_received': 
                                    {'out_of_order': 0,
                                    'total_data': 1380,
                                    'value': 138,
                                    'with_data': 66},
                                'datagram_sent': 
                                    {'fastretransmit': 0,
                                    'partialack': 0,
                                    'retransmit': 0,
                                    'second_congestion': 0,
                                    'total_data': 7246,
                                    'value': 139,
                                    'with_data': 139}},
                            'delrcvwnd': 1380,
                            'ecn_connection': 'disabled',
                            'enqueued_packets': 
                                {'input_packet': 0,
                                'mis_ordered_packet': 0,
                                'retransmit_packet': 0},
                            'fast_lock_acquisition_failures': 0,
                            'graceful_restart': 'disabled',
                            'io_status': 1,
                            'ip_precedence_value': 6,
                            'irs': 1797203329,
                            'iss': 164676617,
                            'krtt': 0,
                            'lock_slow_path': 0,
                            'max_rtt': 1000,
                            'maximum_output_segment_queue_size': 50,
                            'maxrcvwnd': 16384,
                            'min_rtt': 1,
                            'min_time_between_advertisement_runs': 0,
                            'minimum_incoming_ttl': 0,
                            'option_flags': 'VRF '
                                            'id '
                                            'set, '
                                            'nagle, '
                                            'path '
                                            'mtu '
                                            'capable',
                            'outgoing_ttl': 1,
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'rcv_scale': 0,
                            'rcvnxt': 1797204710,
                            'rcvwnd': 15004,
                            'receive_idletime': 6849,
                            'rib_route_ip': '2001:DB8:4:6::6',
                            'rtto': 1003,
                            'rtv': 3,
                            'sent_idletime': 6954,
                            'snd_scale': 0,
                            'sndnxt': 164678296,
                            'snduna': 164678296,
                            'sndwnd': 32000,
                            'srtt': 1000,
                            'status_flags': 'passive '
                                            'open, '
                                            'gen '
                                            'tcbs',
                            'tcp_path_mtu_discovery': 'enabled',
                            'tcp_semaphore': '0x1286E9AC',
                            'tcp_semaphore_status': 'FREE',
                            'transport': 
                                {'foreign_host': '2001:DB8:4:6::6',
                                'foreign_port': '11003',
                                'local_host': '2001:DB8:4:6::4',
                                'local_port': '179',
                                'mss': 1440},
                            'unread_input_bytes': 0,
                            'uptime': 3718683},
                        'bgp_version': 4,
                        'link': 'external',
                        'remote_as': 300,
                        'router_id': '10.4.6.6',
                        'session_state': 'Established',
                        'shutdown': False}}},
            'VRF2': 
                {'neighbor': 
                    {'10.66.6.6': 
                        {'address_family': 
                            {'vpnv6 unicast': {},
                            'vpnv4 unicast': 
                                {'current_time': '0x530C0D',
                                'last_read': '00:00:24',
                                'last_write': '00:00:21',
                                'session_state': 'Established',
                                'up_time': '01:01:51'}},
                        'bgp_event_timer': 
                            {'next': 
                                {'ackhold': '0x0',
                                'deadwait': '0x0',
                                'giveup': '0x0',
                                'keepalive': '0x0',
                                'linger': '0x0',
                                'pmtuager': '0x0',
                                'processq': '0x0',
                                'retrans': '0x0',
                                'sendwnd': '0x0',
                                'timewait': '0x0'},
                            'starts': 
                                {'ackhold': 66,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 70,
                                'sendwnd': 0,
                                'timewait': 0},
                            'wakeups': 
                                {'ackhold': 64,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 0,
                                'sendwnd': 0,
                                'timewait': 0}},
                                'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': 
                            {'enhanced_refresh': 'advertised',
                            'four_octets_asn': 'advertised',
                            'ipv4_unicast': 'advertised '
                                            'and '
                                            'received',
                            'route_refresh': 'advertised',
                            'stateful_switchover': 'NO '
                                                   'for '
                                                   'session '
                                                   '1'},
                        'bgp_negotiated_keepalive_timers': 
                            {'hold_time': 180,
                            'keepalive_interval': 60},
                        'bgp_neighbor_counters': 
                            {'messages': 
                                {'in_queue_depth': 0,
                                'out_queue_depth': 0,
                                'received': 
                                    {'keepalives': 64,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 66,
                                    'updates': 1},
                                'sent': 
                                    {'keepalives': 69,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 71,
                                    'updates': 1}}},
                        'bgp_session_transport': 
                            {'ack_hold': 200,
                            'address_tracking_status': 'enabled',
                            'connection': 
                                {'dropped': 1,
                                'established': 2,
                                'last_reset': '01:05:09',
                                'reset_reason': 'Active '
                                                'open '
                                                'failed'},
                            'connection_state': 'estab',
                            'connection_tableid': 2,
                            'datagram': 
                                {'datagram_received': 
                                    {'out_of_order': 0,
                                    'total_data': 1330,
                                    'value': 135,
                                    'with_data': 66},
                                'datagram_sent': 
                                    {'fastretransmit': 0,
                                    'partialack': 0,
                                    'retransmit': 0,
                                    'second_congestion': 0,
                                    'total_data': 1391,
                                    'value': 137,
                                    'with_data': 71}},
                            'delrcvwnd': 1330,
                            'ecn_connection': 'disabled',
                            'enqueued_packets': 
                                {'input_packet': 0,
                                'mis_ordered_packet': 0,
                                'retransmit_packet': 0},
                            'fast_lock_acquisition_failures': 0,
                            'graceful_restart': 'disabled',
                            'io_status': 1,
                            'ip_precedence_value': 6,
                            'irs': 213294715,
                            'iss': 2048397580,
                            'krtt': 0,
                            'lock_slow_path': 0,
                            'max_rtt': 1000,
                            'maximum_output_segment_queue_size': 50,
                            'maxrcvwnd': 16384,
                            'min_rtt': 2,
                            'min_time_between_advertisement_runs': 0,
                            'minimum_incoming_ttl': 0,
                            'option_flags': 'VRF '
                                            'id '
                                            'set, '
                                            'nagle, '
                                            'path '
                                            'mtu '
                                            'capable',
                            'outgoing_ttl': 1,
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'rcv_scale': 0,
                            'rcvnxt': 213296046,
                            'rcvwnd': 15054,
                            'receive_idletime': 21765,
                            'rib_route_ip': '10.66.6.6',
                            'rtto': 1003,
                            'rtv': 3,
                            'sent_idletime': 21866,
                            'snd_scale': 0,
                            'sndnxt': 2048398972,
                            'snduna': 2048398972,
                            'sndwnd': 32000,
                            'srtt': 1000,
                            'status_flags': 'passive '
                                            'open, '
                                            'gen '
                                            'tcbs',
                            'tcp_path_mtu_discovery': 'enabled',
                            'tcp_semaphore': '0x1286E8CC',
                            'tcp_semaphore_status': 'FREE',
                            'transport': 
                                {'foreign_host': '10.66.6.6',
                                'foreign_port': '11003',
                                'local_host': '10.66.6.4',
                                'local_port': '179',
                                'mss': 1460},
                            'unread_input_bytes': 0,
                            'uptime': 3712326},
                        'bgp_version': 4,
                        'link': 'external',
                        'remote_as': 400,
                        'router_id': '10.66.6.6',
                        'session_state': 'Established',
                        'shutdown': False},
                    '2001:DB8:20:4:6::6': 
                        {'address_family': 
                            {'ipv4 multicast': {},
                            'l2vpn evpn': {},
                            'mvpnv4 unicast': {},
                            'mvpnv6 unicast': {},
                            'vpnv4 multicast': {},
                            'vpnv6 multicast': {},
                            'vpnv6 unicast': 
                                {'current_time': '0x5319B5',
                                'last_read': '00:00:22',
                                'last_write': '00:00:01',
                                'session_state': 'Established',
                                'up_time': '01:01:51'}},
                                'bgp_event_timer': 
                                    {'next': 
                                        {'ackhold': '0x0',
                                        'deadwait': '0x0',
                                        'giveup': '0x0',
                                        'keepalive': '0x0',
                                        'linger': '0x0',
                                        'pmtuager': '0x0',
                                        'processq': '0x0',
                                        'retrans': '0x0',
                                        'sendwnd': '0x0',
                                        'timewait': '0x0'},
                                    'starts': 
                                        {'ackhold': 66,
                                        'deadwait': 0,
                                        'giveup': 0,
                                        'keepalive': 0,
                                        'linger': 0,
                                        'pmtuager': 0,
                                        'processq': 0,
                                        'retrans': 71,
                                        'sendwnd': 0,
                                        'timewait': 0},
                                    'wakeups': 
                                        {'ackhold': 64,
                                        'deadwait': 0,
                                        'giveup': 0,
                                        'keepalive': 0,
                                        'linger': 0,
                                        'pmtuager': 0,
                                        'processq': 0,
                                        'retrans': 0,
                                        'sendwnd': 0,
                                        'timewait': 0}},
                                        'bgp_neighbor_session': {
                                    'sessions': 1,
                                    },
                                'bgp_negotiated_capabilities': 
                                    {'enhanced_refresh': 'advertised',
                                    'four_octets_asn': 'advertised',
                                    'ipv6_unicast': 'advertised '
                                                    'and '
                                                    'received',
                                    'route_refresh': 'advertised',
                                    'stateful_switchover': 'NO '
                                                            'for '
                                                            'session '
                                                            '1'},
                                'bgp_negotiated_keepalive_timers': 
                                    {'hold_time': 180,
                                    'keepalive_interval': 60},
                                'bgp_neighbor_counters': 
                                    {'messages': 
                                        {'in_queue_depth': 0,
                                        'out_queue_depth': 0,
                                        'received': 
                                            {'keepalives': 64,
                                            'notifications': 0,
                                            'opens': 1,
                                            'route_refresh': 0,
                                            'total': 66,
                                            'updates': 1},
                                        'sent': 
                                            {'keepalives': 70,
                                            'notifications': 0,
                                            'opens': 1,
                                            'route_refresh': 0,
                                            'total': 72,
                                            'updates': 1}}},
                                'bgp_session_transport': 
                                    {'ack_hold': 200,
                                    'address_tracking_status': 'enabled',
                                    'connection': 
                                        {'dropped': 1,
                                        'established': 2,
                                        'last_reset': '01:05:13',
                                        'reset_reason': 'Active '
                                                        'open '
                                                        'failed'},
                                    'connection_state': 'estab',
                                    'connection_tableid': 503316482,
                                    'datagram': 
                                        {'datagram_received': 
                                            {'out_of_order': 0,
                                            'total_data': 1380,
                                            'value': 137,
                                            'with_data': 66},
                                        'datagram_sent': 
                                            {'fastretransmit': 0,
                                            'partialack': 0,
                                            'retransmit': 0,
                                            'second_congestion': 0,
                                            'total_data': 6944,
                                            'value': 138,
                                            'with_data': 138}},
                                    'delrcvwnd': 1380,
                                    'ecn_connection': 'disabled',
                                    'enqueued_packets': 
                                        {'input_packet': 0,
                                        'mis_ordered_packet': 0,
                                        'retransmit_packet': 0},
                                    'fast_lock_acquisition_failures': 0,
                                    'graceful_restart': 'disabled',
                                    'io_status': 1,
                                    'ip_precedence_value': 6,
                                    'irs': 693674496,
                                    'iss': 3178074389,
                                    'krtt': 0,
                                    'lock_slow_path': 0,
                                    'max_rtt': 1000,
                                    'maximum_output_segment_queue_size': 50,
                                    'maxrcvwnd': 16384,
                                    'min_rtt': 3,
                                    'min_time_between_advertisement_runs': 0,
                                    'minimum_incoming_ttl': 0,
                                    'option_flags': 'VRF '
                                                    'id '
                                                    'set, '
                                                    'nagle, '
                                                    'path '
                                                    'mtu '
                                                    'capable',
                                    'outgoing_ttl': 1,
                                    'packet_fast_path': 0,
                                    'packet_fast_processed': 0,
                                    'packet_slow_path': 0,
                                    'rcv_scale': 0,
                                    'rcvnxt': 693675877,
                                    'rcvwnd': 15004,
                                    'receive_idletime': 2277,
                                    'rib_route_ip': '2001:DB8:20:4:6::6',
                                    'rtto': 1003,
                                    'rtv': 3,
                                    'sent_idletime': 2335,
                                    'snd_scale': 0,
                                    'sndnxt': 3178075806,
                                    'snduna': 3178075806,
                                    'sndwnd': 32000,
                                    'srtt': 1000,
                                    'status_flags': 'passive '
                                                    'open, '
                                                    'gen '
                                                    'tcbs',
                                    'tcp_path_mtu_discovery': 'enabled',
                                    'tcp_semaphore': '0x1286E93C',
                                    'tcp_semaphore_status': 'FREE',
                                    'transport': 
                                        {'foreign_host': '2001:DB8:20:4:6::6',
                                        'foreign_port': '11003',
                                        'local_host': '2001:DB8:20:4:6::4',
                                        'local_port': '179',
                                        'mss': 1440},
                                    'unread_input_bytes': 0,
                                    'uptime': 3711535},
                                'bgp_version': 4,
                                'link': 'external',
                                'remote_as': 400,
                                'router_id': '10.66.6.6',
                                'session_state': 'Established',
                                'shutdown': False}}},
         'default': 
            {'neighbor': 
                {'10.16.2.2': 
                    {'address_family': 
                        {'vpnv4 unicast': 
                            {'current_time': '0x530449',
                            'last_read': '00:00:04',
                            'last_write': '00:00:09',
                            'session_state': 'Established',
                            'up_time': '01:10:35'}},
                    'bgp_event_timer': 
                        {'next': 
                            {'ackhold': '0x0',
                            'deadwait': '0x0',
                            'giveup': '0x0',
                            'keepalive': '0x0',
                            'linger': '0x0',
                            'pmtuager': '0x0',
                            'processq': '0x0',
                            'retrans': '0x0',
                            'sendwnd': '0x0',
                            'timewait': '0x0'},
                        'starts': 
                            {'ackhold': 80,
                            'deadwait': 0,
                            'giveup': 0,
                            'keepalive': 0,
                            'linger': 0,
                            'pmtuager': 1,
                            'processq': 0,
                            'retrans': 86,
                            'sendwnd': 0,
                            'timewait': 0},
                        'wakeups': 
                            {'ackhold': 72,
                            'deadwait': 0,
                            'giveup': 0,
                            'keepalive': 0,
                            'linger': 0,
                            'pmtuager': 1,
                            'processq': 0,
                            'retrans': 0,
                            'sendwnd': 0,
                            'timewait': 0}},
                            'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                    'bgp_negotiated_capabilities': 
                        {'enhanced_refresh': 'advertised',
                        'four_octets_asn': 'advertised '
                                           'and '
                                           'received',
                        'graceful_restart': 'received',
                        'graceful_restart_af_advertised_by_peer': ['vpnv4 '
                                                                   'unicast',
                                                                   'vpnv6 '
                                                                   'unicast'],
                        'remote_restart_timer': 120,
                        'route_refresh': 'advertised '
                                         'and '
                                         'received(new)',
                        'stateful_switchover': 'NO '
                                               'for '
                                               'session '
                                               '1',
                        'vpnv4_unicast': 'advertised '
                                         'and '
                                         'received',
                        'vpnv6_unicast': 'advertised '
                                         'and '
                                         'received'},
                    'bgp_negotiated_keepalive_timers': 
                        {'hold_time': 180,
                        'keepalive_interval': 60},
                    'bgp_neighbor_counters': 
                        {'messages': 
                            {'in_queue_depth': 0,
                            'out_queue_depth': 0,
                            'received': 
                                {'keepalives': 74,
                                'notifications': 0,
                                'opens': 1,
                                'route_refresh': 0,
                                'total': 81,
                                'updates': 6},
                            'sent': 
                                {'keepalives': 75,
                                'notifications': 0,
                                'opens': 1,
                                'route_refresh': 0,
                                'total': 87,
                                'updates': 11}}},
                    'bgp_session_transport': 
                        {'ack_hold': 200,
                        'address_tracking_status': 'enabled',
                        'connection': 
                            {'dropped': 0,
                            'established': 1,
                            'last_reset': 'never'},
                        'connection_state': 'estab',
                        'connection_tableid': 0,
                        'datagram': 
                            {'datagram_received': 
                                {'out_of_order': 0,
                                'total_data': 2374,
                                'value': 164,
                                'with_data': 80},
                            'datagram_sent': 
                                {'fastretransmit': 0,
                                'partialack': 0,
                                'retransmit': 0,
                                'second_congestion': 0,
                                'total_data': 3303,
                                'value': 166,
                                'with_data': 87}},
                        'delrcvwnd': 57,
                        'ecn_connection': 'disabled',
                        'enqueued_packets': 
                            {'input_packet': 0,
                            'mis_ordered_packet': 0,
                            'retransmit_packet': 0},
                        'fast_lock_acquisition_failures': 0,
                        'graceful_restart': 'disabled',
                        'io_status': 1,
                        'ip_precedence_value': 6,
                        'irs': 109992783,
                        'iss': 55023811,
                        'krtt': 0,
                        'lock_slow_path': 0,
                        'max_rtt': 1000,
                        'maximum_output_segment_queue_size': 50,
                        'maxrcvwnd': 16384,
                        'min_rtt': 4,
                        'min_time_between_advertisement_runs': 0,
                        'minimum_incoming_ttl': 0,
                        'option_flags': 'nagle, '
                                        'path '
                                        'mtu '
                                        'capable',
                        'outgoing_ttl': 255,
                        'packet_fast_path': 0,
                        'packet_fast_processed': 0,
                        'packet_slow_path': 0,
                        'rcv_scale': 0,
                        'rcvnxt': 109995158,
                        'rcvwnd': 16327,
                        'receive_idletime': 4549,
                        'rib_route_ip': '10.16.2.2',
                        'rtto': 1003,
                        'rtv': 3,
                        'sent_idletime': 4349,
                        'snd_scale': 0,
                        'sndnxt': 55027115,
                        'snduna': 55027115,
                        'sndwnd': 16616,
                        'srtt': 1000,
                        'status_flags': 'active '
                                        'open',
                        'tcp_path_mtu_discovery': 'enabled',
                        'tcp_semaphore': '0x1286E7EC',
                        'tcp_semaphore_status': 'FREE',
                        'transport': {'foreign_host': '10.16.2.2',
                                      'foreign_port': '179',
                                      'local_host': '10.64.4.4',
                                      'local_port': '35281',
                                      'mss': 536},
                        'unread_input_bytes': 0,
                        'uptime': 4236258},
                    'bgp_version': 4,
                    'link': 'internal',
                    'remote_as': 100,
                    'router_id': '10.16.2.2',
                    'session_state': 'Established',
                    'shutdown': False},
                '10.64.4.4': 
                    {'address_family': 
                        {'vpnv6 unicast': 
                            {'current_time': '0x530FF5',
                            'last_read': '00:00:07',
                            'last_write': '00:00:12',
                            'session_state': 'Established',
                            'up_time': '01:10:38'}},
                    'bgp_event_timer': 
                        {'next': 
                            {'ackhold': '0x0',
                            'deadwait': '0x0',
                            'giveup': '0x0',
                            'keepalive': '0x0',
                            'linger': '0x0',
                            'pmtuager': '0x0',
                            'processq': '0x0',
                            'retrans': '0x0',
                            'sendwnd': '0x0',
                            'timewait': '0x0'},
                        'starts': 
                            {'ackhold': 80,
                            'deadwait': 0,
                            'giveup': 0,
                            'keepalive': 0,
                            'linger': 0,
                            'pmtuager': 1,
                            'processq': 0,
                            'retrans': 86,
                            'sendwnd': 0,
                            'timewait': 0},
                        'wakeups': 
                            {'ackhold': 72,
                            'deadwait': 0,
                            'giveup': 0,
                            'keepalive': 0,
                            'linger': 0,
                            'pmtuager': 1,
                            'processq': 0,
                            'retrans': 0,
                            'sendwnd': 0,
                            'timewait': 0}},
                            'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                    'bgp_negotiated_capabilities': 
                        {'enhanced_refresh': 'advertised',
                        'four_octets_asn': 'advertised '
                                            'and '
                                            'received',
                        'graceful_restart': 'received',
                        'graceful_restart_af_advertised_by_peer': ['vpnv4 '
                                                                  'unicast',
                                                                  'vpnv6 '
                                                                  'unicast'],
                        'remote_restart_timer': 120,
                        'route_refresh': 'advertised '
                                         'and '
                                         'received(new)',
                        'stateful_switchover': 'NO '
                                               'for '
                                               'session '
                                               '1',
                        'vpnv4_unicast': 'advertised '
                                         'and '
                                         'received',
                        'vpnv6_unicast': 'advertised '
                                         'and '
                                         'received'},
                    'bgp_negotiated_keepalive_timers': 
                        {'hold_time': 180,
                        'keepalive_interval': 60},
                    'bgp_neighbor_counters': 
                        {'messages': 
                            {'in_queue_depth': 0,
                            'out_queue_depth': 0,
                            'received': 
                                {'keepalives': 74,
                                'notifications': 0,
                                'opens': 1,
                                'route_refresh': 0,
                                'total': 81,
                                'updates': 6},
                            'sent': 
                                {'keepalives': 75,
                                'notifications': 0,
                                'opens': 1,
                                'route_refresh': 0,
                                'total': 87,
                                'updates': 11}}},
                    'bgp_session_transport': 
                        {'ack_hold': 200,
                        'address_tracking_status': 'enabled',
                        'connection': 
                            {'dropped': 0,
                            'established': 1,
                            'last_reset': 'never'},
                        'connection_state': 'estab',
                        'connection_tableid': 0,
                        'datagram': 
                            {'datagram_received': 
                                {'out_of_order': 0,
                                'total_data': 2374,
                                'value': 164,
                                'with_data': 80},
                            'datagram_sent': 
                                {'fastretransmit': 0,
                                'partialack': 0,
                                'retransmit': 0,
                                'second_congestion': 0,
                                'total_data': 3303,
                                'value': 166,
                                'with_data': 87}},
                        'delrcvwnd': 57,
                        'ecn_connection': 'disabled',
                        'enqueued_packets': 
                            {'input_packet': 0,
                            'mis_ordered_packet': 0,
                            'retransmit_packet': 0},
                        'fast_lock_acquisition_failures': 0,
                        'graceful_restart': 'disabled',
                        'io_status': 1,
                        'ip_precedence_value': 6,
                        'irs': 109992783,
                        'iss': 55023811,
                        'krtt': 0,
                        'lock_slow_path': 0,
                        'max_rtt': 1000,
                        'maximum_output_segment_queue_size': 50,
                        'maxrcvwnd': 16384,
                        'min_rtt': 4,
                        'min_time_between_advertisement_runs': 0,
                        'minimum_incoming_ttl': 0,
                        'option_flags': 'nagle, '
                                        'path '
                                        'mtu '
                                        'capable',
                        'outgoing_ttl': 255,
                        'packet_fast_path': 0,
                        'packet_fast_processed': 0,
                        'packet_slow_path': 0,
                        'rcv_scale': 0,
                        'rcvnxt': 109995158,
                        'rcvwnd': 16327,
                        'receive_idletime': 8032,
                        'rib_route_ip': '10.16.2.2',
                        'rtto': 1003,
                        'rtv': 3,
                        'sent_idletime': 7832,
                        'snd_scale': 0,
                        'sndnxt': 55027115,
                        'snduna': 55027115,
                        'sndwnd': 16616,
                        'srtt': 1000,
                        'status_flags': 'active '
                                        'open',
                        'tcp_path_mtu_discovery': 'enabled',
                        'tcp_semaphore': '0x1286E7EC',
                        'tcp_semaphore_status': 'FREE',
                        'transport': 
                            {'foreign_host': '10.16.2.2',
                            'foreign_port': '179',
                            'local_host': '10.64.4.4',
                            'local_port': '35281',
                            'mss': 536},
                        'unread_input_bytes': 0,
                        'uptime': 4239741},
                    'bgp_version': 4,
                    'description': 'router2222222',
                    'link': 'internal',
                    'remote_as': 100,
                    'router_id': '10.64.4.4',
                    'session_state': 'Established',
                    'shutdown': False},
                '10.100.5.5': 
                    {'address_family': 
                        {'vpnv6 unicast': 
                            {'current_time': '0x5313D8',
                            'last_read': '00:00:08',
                            'last_write': '00:00:47',
                            'session_state': 'Established',
                            'up_time': '01:10:44'}},
                    'bgp_event_timer': 
                        {'next': 
                            {'ackhold': '0x0',
                            'deadwait': '0x0',
                            'giveup': '0x0',
                            'keepalive': '0x0',
                            'linger': '0x0',
                            'pmtuager': '0x0',
                            'processq': '0x0',
                            'retrans': '0x0',
                            'sendwnd': '0x0',
                            'timewait': '0x0'},
                        'starts': 
                            {'ackhold': 80,
                            'deadwait': 0,
                            'giveup': 0,
                            'keepalive': 0,
                            'linger': 0,
                            'pmtuager': 1,
                            'processq': 0,
                            'retrans': 86,
                            'sendwnd': 0,
                            'timewait': 0},
                        'wakeups': 
                            {'ackhold': 73,
                            'deadwait': 0,
                            'giveup': 0,
                            'keepalive': 0,
                            'linger': 0,
                            'pmtuager': 1,
                            'processq': 0,
                            'retrans': 0,
                            'sendwnd': 0,
                            'timewait': 0}},
                            'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                    'bgp_negotiated_capabilities': 
                        {'enhanced_refresh': 'advertised',
                        'four_octets_asn': 'advertised '
                                           'and '
                                           'received',
                        'graceful_restart': 'received',
                        'graceful_restart_af_advertised_by_peer': ['vpnv4 '
                                                                  'unicast',
                                                                  'vpnv6 '
                                                                  'unicast'],
                        'remote_restart_timer': 120,
                        'route_refresh': 'advertised '
                                         'and '
                                         'received(new)',
                        'stateful_switchover': 'NO '
                                               'for '
                                               'session '
                                               '1',
                        'vpnv4_unicast': 'advertised '
                                         'and '
                                         'received',
                        'vpnv6_unicast': 'advertised '
                                         'and '
                                         'received'},
                    'bgp_negotiated_keepalive_timers': 
                        {'hold_time': 180,
                        'keepalive_interval': 60},
                    'bgp_neighbor_counters': 
                        {'messages': 
                            {'in_queue_depth': 0,
                            'out_queue_depth': 0,
                            'received': 
                                {'keepalives': 74,
                                'notifications': 0,
                                'opens': 1,
                                'route_refresh': 0,
                                'total': 81,
                                'updates': 6},
                            'sent': 
                                {'keepalives': 75,
                                'notifications': 0,
                                'opens': 1,
                                'route_refresh': 0,
                                'total': 87,
                                'updates': 11}}},
                    'bgp_session_transport': 
                        {'ack_hold': 200,
                        'address_tracking_status': 'enabled',
                        'connection': 
                            {'dropped': 0,
                            'established': 1,
                            'last_reset': 'never'},
                        'connection_state': 'estab',
                        'connection_tableid': 0,
                        'datagram': 
                            {'datagram_received': 
                                {'out_of_order': 0,
                                'total_data': 2374,
                                'value': 165,
                                'with_data': 80},
                            'datagram_sent': 
                                {'fastretransmit': 0,
                                'partialack': 0,
                                'retransmit': 0,
                                'second_congestion': 0,
                                'total_data': 3303,
                                'value': 167,
                                'with_data': 87}},
                        'delrcvwnd': 57,
                        'ecn_connection': 'disabled',
                        'enqueued_packets': 
                            {'input_packet': 0,
                            'mis_ordered_packet': 0,
                            'retransmit_packet': 0},
                        'fast_lock_acquisition_failures': 0,
                        'graceful_restart': 'disabled',
                        'io_status': 1,
                        'ip_precedence_value': 6,
                        'irs': 4033842748,
                        'iss': 2116369173,
                        'krtt': 0,
                        'lock_slow_path': 0,
                        'max_rtt': 1000,
                        'maximum_output_segment_queue_size': 50,
                        'maxrcvwnd': 16384,
                        'min_rtt': 3,
                        'min_time_between_advertisement_runs': 0,
                        'minimum_incoming_ttl': 0,
                        'option_flags': 'nagle, '
                                        'path '
                                        'mtu '
                                        'capable',
                        'outgoing_ttl': 255,
                        'packet_fast_path': 0,
                        'packet_fast_processed': 0,
                        'packet_slow_path': 0,
                        'rcv_scale': 0,
                        'rcvnxt': 4033845123,
                        'rcvwnd': 16327,
                        'receive_idletime': 8567,
                        'rib_route_ip': '10.36.3.3',
                        'rtto': 1003,
                        'rtv': 3,
                        'sent_idletime': 8367,
                        'snd_scale': 0,
                        'sndnxt': 2116372477,
                        'snduna': 2116372477,
                        'sndwnd': 16616,
                        'srtt': 1000,
                        'status_flags': 'active '
                                        'open',
                        'tcp_path_mtu_discovery': 'enabled',
                        'tcp_semaphore': '0x1286E85C',
                        'tcp_semaphore_status': 'FREE',
                        'transport': 
                            {'foreign_host': '10.36.3.3',
                            'foreign_port': '179',
                            'local_host': '10.64.4.4',
                            'local_port': '56031',
                            'mss': 536},
                        'unread_input_bytes': 0,
                        'uptime': 4246385},
                   'bgp_version': 4,
                   'link': 'internal',
                   'remote_as': 100,
                   'router_id': '10.100.5.5',
                   'session_state': 'Established',
                   'shutdown': False},
                '10.36.3.3': 
                    {'address_family': 
                        {'vpnv4 unicast': 
                            {'current_time': '0x530638',
                            'last_read': '00:00:04',
                            'last_write': '00:00:43',
                            'session_state': 'Established',
                            'up_time': '01:10:41'}},
                    'bgp_event_timer': 
                        {'next': 
                            {'ackhold': '0x0',
                            'deadwait': '0x0',
                            'giveup': '0x0',
                            'keepalive': '0x0',
                            'linger': '0x0',
                            'pmtuager': '0x0',
                            'processq': '0x0',
                            'retrans': '0x0',
                            'sendwnd': '0x0',
                            'timewait': '0x0'},
                        'starts': 
                            {'ackhold': 80,
                            'deadwait': 0,
                            'giveup': 0,
                            'keepalive': 0,
                            'linger': 0,
                            'pmtuager': 1,
                            'processq': 0,
                            'retrans': 86,
                            'sendwnd': 0,
                            'timewait': 0},
                        'wakeups': 
                            {'ackhold': 73,
                            'deadwait': 0,
                            'giveup': 0,
                            'keepalive': 0,
                            'linger': 0,
                            'pmtuager': 1,
                            'processq': 0,
                            'retrans': 0,
                            'sendwnd': 0,
                            'timewait': 0}},
                            'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                    'bgp_negotiated_capabilities': 
                        {'enhanced_refresh': 'advertised',
                        'four_octets_asn': 'advertised '
                                         'and '
                                         'received',
                        'graceful_restart': 'received',
                        'graceful_restart_af_advertised_by_peer': ['vpnv4 '
                                                                   'unicast',
                                                                   'vpnv6 '
                                                                   'unicast'],
                        'remote_restart_timer': 120,
                        'route_refresh': 'advertised '
                                         'and '
                                         'received(new)',
                        'stateful_switchover': 'NO '
                                               'for '
                                               'session '
                                               '1',
                        'vpnv4_unicast': 'advertised '
                                         'and ' 
                                         'received',
                        'vpnv6_unicast': 'advertised '
                                         'and '
                                         'received'},
                    'bgp_negotiated_keepalive_timers': 
                        {'hold_time': 180,
                        'keepalive_interval': 60},
                    'bgp_neighbor_counters': 
                        {'messages': 
                            {'in_queue_depth': 0,
                            'out_queue_depth': 0,
                            'received': 
                                {'keepalives': 74,
                                'notifications': 0,
                                'opens': 1,
                                'route_refresh': 0,
                                'total': 81,
                                'updates': 6},
                            'sent': 
                                {'keepalives': 75,
                                'notifications': 0,
                                'opens': 1,
                                'route_refresh': 0,
                                'total': 87,
                                'updates': 11}}},
                    'bgp_session_transport': 
                        {'ack_hold': 200,
                        'address_tracking_status': 'enabled',
                        'connection': 
                            {'dropped': 0,
                            'established': 1,
                            'last_reset': 'never'},
                        'connection_state': 'estab',
                        'connection_tableid': 0,
                        'datagram': 
                            {'datagram_received': 
                                {'out_of_order': 0,
                                'total_data': 2374,
                                'value': 165,
                                'with_data': 80},
                            'datagram_sent': 
                                {'fastretransmit': 0,
                                'partialack': 0,
                                'retransmit': 0,
                                'second_congestion': 0,
                                'total_data': 3303,
                                'value': 167,
                                'with_data': 87}},
                        'delrcvwnd': 57,
                        'ecn_connection': 'disabled',
                        'enqueued_packets': 
                            {'input_packet': 0,
                            'mis_ordered_packet': 0,
                            'retransmit_packet': 0},
                        'fast_lock_acquisition_failures': 0,
                        'graceful_restart': 'disabled',
                        'io_status': 1,
                        'ip_precedence_value': 6,
                        'irs': 4033842748,
                        'iss': 2116369173,
                        'krtt': 0,
                        'lock_slow_path': 0,
                        'max_rtt': 1000,
                        'maximum_output_segment_queue_size': 50,
                        'maxrcvwnd': 16384,
                        'min_rtt': 3,
                        'min_time_between_advertisement_runs': 0,
                        'minimum_incoming_ttl': 0,
                        'option_flags': 'nagle, '
                                        'path '
                                        'mtu '
                                        'capable',
                        'outgoing_ttl': 255,
                        'packet_fast_path': 0,
                        'packet_fast_processed': 0,
                        'packet_slow_path': 0,
                        'rcv_scale': 0,
                        'rcvnxt': 4033845123,
                        'rcvwnd': 16327,
                        'receive_idletime': 5575,
                        'rib_route_ip': '10.36.3.3',
                        'rtto': 1003,
                        'rtv': 3,
                        'sent_idletime': 5375,
                        'snd_scale': 0,
                        'sndnxt': 2116372477,
                        'snduna': 2116372477,
                        'sndwnd': 16616,
                        'srtt': 1000,
                        'status_flags': 'active '
                                        'open',
                        'tcp_path_mtu_discovery': 'enabled',
                        'tcp_semaphore': '0x1286E85C',
                        'tcp_semaphore_status': 'FREE',
                        'transport': 
                            {'foreign_host': '10.36.3.3',
                            'foreign_port': '179',
                            'local_host': '10.64.4.4',
                            'local_port': '56031',
                            'mss': 536},
                        'unread_input_bytes': 0,
                        'uptime': 4243393},
                    'bgp_version': 4,
                    'link': 'internal',
                    'remote_as': 100,
                    'router_id': '10.36.3.3',
                    'session_state': 'Established',
                    'shutdown': False}}}}}

    golden_output1 = {'execute.return_value': '''
        router# show bgp all neighbors

        For address family: IPv4 Unicast

        For address family: IPv6 Unicast

        For address family: VPNv4 Unicast
        BGP neighbor is 10.16.2.2,  remote AS 100, internal link
          BGP version 4, remote router ID 10.16.2.2
          BGP state = Established, up for 01:10:35
          Last read 00:00:04, last write 00:00:09, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family VPNv6 Unicast: advertised and received
            Graceful Restart Capability: received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, VPNv6 Unicast (was not preserved
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               11          6
            Keepalives:            75         74
            Route Refresh:          0          0
            Total:                 87         81
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.16.2.2
          Connections established 1; dropped 0
          Last reset never
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.64.4.4, Local port: 35281
        Foreign host: 10.16.2.2, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530449):
        Timer          Starts    Wakeups            Next
        Retrans            86          0             0x0
        TimeWait            0          0             0x0
        AckHold            80         72             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:   55023811  snduna:   55027115  sndnxt:   55027115
        irs:  109992783  rcvnxt:  109995158

        sndwnd:  16616  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16327  scale:      0  delrcvwnd:     57

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 4 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 4236258 ms, Sent idletime: 4349 ms, Receive idletime: 4549 ms
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 536 bytes):
        Rcvd: 164 (out of order: 0), with data: 80, total data bytes: 2374
        Sent: 166 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 87, total data bytes: 3303

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E7EC  FREE

        BGP neighbor is 10.36.3.3,  remote AS 100, internal link
          BGP version 4, remote router ID 10.36.3.3
          BGP state = Established, up for 01:10:41
          Last read 00:00:04, last write 00:00:43, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family VPNv6 Unicast: advertised and received
            Graceful Restart Capability: received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, VPNv6 Unicast (was not preserved
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               11          6
            Keepalives:            75         74
            Route Refresh:          0          0
            Total:                 87         81
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.36.3.3
          Connections established 1; dropped 0
          Last reset never
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.64.4.4, Local port: 56031
        Foreign host: 10.36.3.3, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530638):
        Timer          Starts    Wakeups            Next
        Retrans            86          0             0x0
        TimeWait            0          0             0x0
        AckHold            80         73             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 2116369173  snduna: 2116372477  sndnxt: 2116372477
        irs: 4033842748  rcvnxt: 4033845123

        sndwnd:  16616  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16327  scale:      0  delrcvwnd:     57

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 3 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 4243393 ms, Sent idletime: 5375 ms, Receive idletime: 5575 ms
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 536 bytes):
        Rcvd: 165 (out of order: 0), with data: 80, total data bytes: 2374
        Sent: 167 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 87, total data bytes: 3303

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E85C  FREE

        BGP neighbor is 10.4.6.6,  vrf VRF1,  remote AS 300, external link
          Administratively shut down
          BGP version 4, remote router ID 10.4.6.6
          BGP state = Established, up for 01:01:59
          Last read 00:00:33, last write 00:00:30, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised
            Four-octets ASN Capability: advertised
            Address family IPv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                3          1
            Keepalives:            69         64
            Route Refresh:          0          0
            Total:                 73         66
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.4.6.6
          Connections established 2; dropped 1
          Last reset 01:02:11, due to Peer closed the session of session 1
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 10.4.6.4, Local port: 179
        Foreign host: 10.4.6.6, Foreign port: 11010
        Connection tableid (VRF): 1
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530A19):
        Timer          Starts    Wakeups            Next
        Retrans            71          0             0x0
        TimeWait            0          0             0x0
        AckHold            66         64             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:     271842  snduna:     273380  sndnxt:     273380
        irs:  930048172  rcvnxt:  930049503

        sndwnd:  32000  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15054  scale:      0  delrcvwnd:   1330

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3720132 ms, Sent idletime: 31107 ms, Receive idletime: 30999 ms
        Status Flags: passive open, gen tcbs
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1460 bytes):
        Rcvd: 137 (out of order: 0), with data: 66, total data bytes: 1330
        Sent: 138 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 72, total data bytes: 1537

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E62C  FREE

        BGP neighbor is 10.66.6.6,  vrf VRF2,  remote AS 400, external link
          BGP version 4, remote router ID 10.66.6.6
          BGP state = Established, up for 01:01:51
          Last read 00:00:24, last write 00:00:21, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised
            Four-octets ASN Capability: advertised
            Address family IPv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                1          1
            Keepalives:            69         64
            Route Refresh:          0          0
            Total:                 71         66
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.66.6.6
          Connections established 2; dropped 1
          Last reset 01:05:09, due to Active open failed
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 10.66.6.4, Local port: 179
        Foreign host: 10.66.6.6, Foreign port: 11003
        Connection tableid (VRF): 2
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530C0D):
        Timer          Starts    Wakeups            Next
        Retrans            70          0             0x0
        TimeWait            0          0             0x0
        AckHold            66         64             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 2048397580  snduna: 2048398972  sndnxt: 2048398972
        irs:  213294715  rcvnxt:  213296046

        sndwnd:  32000  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15054  scale:      0  delrcvwnd:   1330

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 2 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3712326 ms, Sent idletime: 21866 ms, Receive idletime: 21765 ms
        Status Flags: passive open, gen tcbs
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1460 bytes):
        Rcvd: 135 (out of order: 0), with data: 66, total data bytes: 1330
        Sent: 137 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 71, total data bytes: 1391

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E8CC  FREE


        For address family: VPNv6 Unicast
        BGP neighbor is 10.64.4.4,  remote AS 100, internal link
          Description: router2222222
          BGP version 4, remote router ID 10.64.4.4
          BGP state = Established, up for 01:10:38
          Last read 00:00:07, last write 00:00:12, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family VPNv6 Unicast: advertised and received
            Graceful Restart Capability: received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, VPNv6 Unicast (was not preserved
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               11          6
            Keepalives:            75         74
            Route Refresh:          0          0
            Total:                 87         81
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.16.2.2
          Connections established 1; dropped 0
          Last reset never
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.64.4.4, Local port: 35281
        Foreign host: 10.16.2.2, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530FF5):
        Timer          Starts    Wakeups            Next
        Retrans            86          0             0x0
        TimeWait            0          0             0x0
        AckHold            80         72             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:   55023811  snduna:   55027115  sndnxt:   55027115
        irs:  109992783  rcvnxt:  109995158

        sndwnd:  16616  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16327  scale:      0  delrcvwnd:     57

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 4 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 4239741 ms, Sent idletime: 7832 ms, Receive idletime: 8032 ms
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 536 bytes):
        Rcvd: 164 (out of order: 0), with data: 80, total data bytes: 2374
        Sent: 166 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 87, total data bytes: 3303

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E7EC  FREE

        BGP neighbor is 10.100.5.5,  remote AS 100, internal link
          BGP version 4, remote router ID 10.100.5.5
          BGP state = Established, up for 01:10:44
          Last read 00:00:08, last write 00:00:47, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family VPNv6 Unicast: advertised and received
            Graceful Restart Capability: received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, VPNv6 Unicast (was not preserved
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               11          6
            Keepalives:            75         74
            Route Refresh:          0          0
            Total:                 87         81
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.36.3.3
          Connections established 1; dropped 0
          Last reset never
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.64.4.4, Local port: 56031
        Foreign host: 10.36.3.3, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x5313D8):
        Timer          Starts    Wakeups            Next
        Retrans            86          0             0x0
        TimeWait            0          0             0x0
        AckHold            80         73             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 2116369173  snduna: 2116372477  sndnxt: 2116372477
        irs: 4033842748  rcvnxt: 4033845123

        sndwnd:  16616  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16327  scale:      0  delrcvwnd:     57

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 3 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 4246385 ms, Sent idletime: 8367 ms, Receive idletime: 8567 ms
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 536 bytes):
        Rcvd: 165 (out of order: 0), with data: 80, total data bytes: 2374
        Sent: 167 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 87, total data bytes: 3303

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E85C  FREE

        BGP neighbor is 2001:DB8:4:6::6,  vrf VRF1,  remote AS 300, external link
          BGP version 4, remote router ID 10.4.6.6
          BGP state = Established, up for 01:01:58
          Last read 00:00:32, last write 00:00:06, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised
            Four-octets ASN Capability: advertised
            Address family IPv6 Unicast: advertised and received
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                3          1
            Keepalives:            70         64
            Route Refresh:          0          0
            Total:                 74         66
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 2001:DB8:4:6::6
          Connections established 2; dropped 1
          Last reset 01:05:12, due to Active open failed
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 2001:DB8:4:6::4, Local port: 179
        Foreign host: 2001:DB8:4:6::6, Foreign port: 11003
        Connection tableid (VRF): 503316481
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x5315CE):
        Timer          Starts    Wakeups            Next
        Retrans            72          0             0x0
        TimeWait            0          0             0x0
        AckHold            66         64             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:  164676617  snduna:  164678296  sndnxt:  164678296
        irs: 1797203329  rcvnxt: 1797204710

        sndwnd:  32000  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15004  scale:      0  delrcvwnd:   1380

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3718683 ms, Sent idletime: 6954 ms, Receive idletime: 6849 ms
        Status Flags: passive open, gen tcbs
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1440 bytes):
        Rcvd: 138 (out of order: 0), with data: 66, total data bytes: 1380
        Sent: 139 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 139, total data bytes: 7246

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E9AC  FREE

        BGP neighbor is 2001:DB8:20:4:6::6,  vrf VRF2,  remote AS 400, external link
          BGP version 4, remote router ID 10.66.6.6
          BGP state = Established, up for 01:01:51
          Last read 00:00:22, last write 00:00:01, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised
            Four-octets ASN Capability: advertised
            Address family IPv6 Unicast: advertised and received
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                1          1
            Keepalives:            70         64
            Route Refresh:          0          0
            Total:                 72         66
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 2001:DB8:20:4:6::6
          Connections established 2; dropped 1
          Last reset 01:05:13, due to Active open failed
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 2001:DB8:20:4:6::4, Local port: 179
        Foreign host: 2001:DB8:20:4:6::6, Foreign port: 11003
        Connection tableid (VRF): 503316482
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x5319B5):
        Timer          Starts    Wakeups            Next
        Retrans            71          0             0x0
        TimeWait            0          0             0x0
        AckHold            66         64             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 3178074389  snduna: 3178075806  sndnxt: 3178075806
        irs:  693674496  rcvnxt:  693675877

        sndwnd:  32000  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15004  scale:      0  delrcvwnd:   1380

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 3 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3711535 ms, Sent idletime: 2335 ms, Receive idletime: 2277 ms
        Status Flags: passive open, gen tcbs
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1440 bytes):
        Rcvd: 137 (out of order: 0), with data: 66, total data bytes: 1380
        Sent: 138 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 138, total data bytes: 6944

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E93C  FREE


        For address family: IPv4 Multicast

        For address family: L2VPN E-VPN

        For address family: VPNv4 Multicast

        For address family: MVPNv4 Unicast

        For address family: MVPNv6 Unicast

        For address family: VPNv6 Multicast
        '''}

    golden_parsed_output2 = {
        'list_of_neighbors': ['192.168.165.120'],
        'vrf': 
            {'default': 
                {'neighbor': 
                    {'192.168.165.120': 
                        {'address_family': 
                            {'l2vpn vpls': 
                                {'advertise_bit': 0,
                                'bgp_table_version': 403,
                                'current_time': '0x233AE79E',
                                'dynamic_slow_peer_recovered': 'never',
                                'extended_community_attribute_sent': True,
                                'index': 4,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': '21:35:12',
                                'last_received_refresh_start_of_rib': '21:35:12',
                                'last_sent_refresh_end_of_rib': '04:52:14',
                                'last_sent_refresh_start_of_rib': '04:52:14',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'bestpath_from_this_peer': 'n/a',
                                        'originator_loop': 1608,
                                        'total': 1608},
                                    'outbound': 
                                        {'bestpath_from_this_peer': 1407,
                                        'originator_loop': 'n/a',
                                        'total': 1407}},
                                'max_nlri': 1,
                                'min_nlri': 0,
                                'neighbor_version': '403/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 1407,
                                        'prefixes_total': 1608,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0},
                                    'sent': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 1608,
                                        'prefixes_total': 1809,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 8,
                                        'refresh_start_of_rib': 8},
                                    'sent': 
                                        {'refresh_end_of_rib': 6,
                                        'refresh_start_of_rib': 6}},
                                'refresh_epoch': 9,
                                'refresh_in': 0,
                                'refresh_out': 0,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'suppress_ldp_signaling': True,
                                'update_group_member': 4},
                            'vpnv4 unicast': 
                                {'advertise_bit': 0,
                                'bgp_table_version': 33086714,
                                'community_attribute_sent': True,
                                'dynamic_slow_peer_recovered': 'never',
                                'extended_community_attribute_sent': True,
                                'index': 1954,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': '21:34:57',
                                'last_received_refresh_start_of_rib': '21:35:12',
                                'last_sent_refresh_end_of_rib': '04:51:02',
                                'last_sent_refresh_start_of_rib': '04:52:14',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'af_permit_check': 'n/a',
                                        'af_update_check': 'n/a',
                                        'bestpath_from_ibgp_peer': 'n/a',
                                        'bestpath_from_this_peer': 'n/a',
                                        'originator_loop': 191399,
                                        'total': 191399},
                                    'outbound': 
                                        {'af_permit_check': 84090,
                                        'af_update_check': 11509,
                                        'bestpath_from_ibgp_peer': 3488082,
                                        'bestpath_from_this_peer': 10473918,
                                        'originator_loop': 'n/a',
                                        'total': 14057599}},
                                'max_nlri': 270,
                                'min_nlri': 0,
                                'neighbor_version': '33086714/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 4059067,
                                        'implicit_withdraw': 12437988,
                                        'prefixes_total': 18498954,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0},
                                    'sent': 
                                        {'explicit_withdraw': 2045210,
                                        'implicit_withdraw': 81710,
                                        'prefixes_total': 131522,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 7,
                                        'refresh_start_of_rib': 8},
                                    'sent': 
                                        {'refresh_end_of_rib': 7,
                                        'refresh_start_of_rib': 7}},
                                'refresh_epoch': 9,
                                'refresh_in': 15,
                                'refresh_out': 72,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'update_group_member': 1954}},
                        'bgp_event_timer': 
                            {'next': 
                                {'ackhold': '0x0',
                                'deadwait': '0x0',
                                'giveup': '0x0',
                                'keepalive': '0x0',
                                'linger': '0x0',
                                'pmtuager': '0x0',
                                'processq': '0x0',
                                'retrans': '0x0',
                                'sendwnd': '0x0',
                                'timewait': '0x0'},
                            'starts': 
                                {'ackhold': 153946,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 1,
                                'processq': 0,
                                'retrans': 35475,
                                'sendwnd': 0,
                                'timewait': 0},
                            'wakeups': 
                                {'ackhold': 6831,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 1,
                                'processq': 0,
                                'retrans': 3,
                                'sendwnd': 0,
                                'timewait': 0}},
                                'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': 
                            {'enhanced_refresh': 'advertised '
                                                 'and '
                                                 'received',
                            'four_octets_asn': 'advertised '
                                               'and '
                                               'received',
                            'graceful_restart': 'advertised '
                                                'and '
                                                'received',
                            'graceful_restart_af_advertised_by_peer': ['vpnv4 '
                                                                       'unicast',
                                                                     'l2vpn '
                                                                       'vpls'],
                            'l2vpn_vpls': 'advertised '
                                          'and '
                                          'received',
                            'remote_restart_timer': 120,
                            'route_refresh': 'advertised '
                                             'and '
                                             'received(new)',
                            'stateful_switchover': 'NO '
                                                   'for '
                                                   'session '
                                                   '1',
                            'vpnv4_unicast': 'advertised '
                                             'and '
                                             'received'},
                        'bgp_negotiated_keepalive_timers': 
                            {'hold_time': 90,
                            'keepalive_interval': 30,
                            'min_holdtime': 15},
                        'bgp_neighbor_counters': 
                            {'messages': 
                                {'in_queue_depth': 0,
                                'out_queue_depth': 0,
                                'received': 
                                    {'keepalives': 4659,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 6,
                                    'total': 140627,
                                    'updates': 135930},
                                'sent': 
                                    {'keepalives': 5187,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 10,
                                    'total': 39192,
                                    'updates': 33968}}},
                        'bgp_session_transport': 
                            {'ack_hold': 200,
                            'address_tracking_status': 'enabled',
                            'connection': 
                                {'dropped': 3,
                                'established': 4,
                                'last_reset': '1d16h',
                                'reset_reason': 'Neighbor '
                                                'reset'},
                            'connection_state': 'estab',
                            'connection_tableid': 0,
                            'datagram': 
                                {'datagram_received': 
                                    {'out_of_order': 0,
                                    'total_data': 356569101,
                                    'value': 363804,
                                    'with_data': 281016},
                                'datagram_sent': 
                                    {'fastretransmit': 1,
                                    'partialack': 0,
                                    'retransmit': 3,
                                    'second_congestion': 0,
                                    'total_data': 76361745,
                                    'value': 423496,
                                    'with_data': 62849}},
                            'delrcvwnd': 323,
                            'ecn_connection': 'disabled',
                            'enqueued_packets': 
                                {'input_packet': 0,
                                'mis_ordered_packet': 0,
                                'retransmit_packet': 0},
                            'fast_lock_acquisition_failures': 0,
                            'gr_restart_time': 120,
                            'gr_stalepath_time': 360,
                            'graceful_restart': 'enabled',
                            'io_status': 1,
                            'ip_precedence_value': 6,
                            'irs': 3910340259,
                            'iss': 673876598,
                            'krtt': 0,
                            'lock_slow_path': 0,
                            'max_rtt': 1344,
                            'maximum_output_segment_queue_size': 50,
                            'maxrcvwnd': 16384,
                            'min_rtt': 0,
                            'min_time_between_advertisement_runs': 0,
                            'minimum_incoming_ttl': 0,
                            'option_flags': 'nagle, '
                                            'path '
                                            'mtu '
                                            'capable',
                            'outgoing_ttl': 255,
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'rcv_scale': 0,
                            'rcvnxt': 4266909361,
                            'rcvwnd': 16061,
                            'receive_idletime': 9542,
                            'rib_route_ip': '192.168.165.120',
                            'rtto': 1003,
                            'rtv': 3,
                            'sent_idletime': 9744,
                            'snd_scale': 0,
                            'sndnxt': 750238254,
                            'snduna': 750238254,
                            'sndwnd': 15567,
                            'srtt': 1000,
                            'sso': False,
                            'status_flags': 'active '
                                            'open',
                            'tcp_path_mtu_discovery': 'enabled',
                            'tcp_semaphore': '0x7FDED5D66E70',
                            'tcp_semaphore_status': 'FREE',
                            'transport': 
                                {'foreign_host': '192.168.165.120',
                                'foreign_port': '179',
                                'local_host': '10.169.197.254',
                                'local_port': '13949',
                                'mss': 1400},
                            'unread_input_bytes': 0,
                            'uptime': 144455028},
                        'bgp_version': 4,
                        'link': 'internal',
                        'remote_as': 5918,
                        'router_id': '192.168.165.120',
                        'session_state': 'Established',
                        'shutdown': False}}}}}

    golden_output2 = {'execute.return_value': '''
        Router#show bgp l2vpn vpls all neighbors 192.168.165.120
        Load for five secs: 29%/0%; one minute: 7%; five minutes: 5%
        Time source is NTP, 16:31:15.088 EST Tue Jun 8 2016

        BGP neighbor is 192.168.165.120,  remote AS 5918, internal link
          BGP version 4, remote router ID 192.168.165.120
          BGP state = Established, up for 1d16h
          Last read 00:00:26, last write 00:00:09, hold time is 90, keepalive interval is 30 seconds
          Configured hold time is 90, keepalive interval is 30 seconds
          Minimum holdtime from neighbor is 15 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family L2VPN Vpls: advertised and received
            Graceful Restart Capability: advertised and received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, L2VPN Vpls (was not preserved
            Enhanced Refresh Capability: advertised and received
            Multisession Capability: 
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0
            
                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:            33968     135930
            Keepalives:          5187       4659
            Route Refresh:         10          6
            Total:              39192     140627
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

         For address family: VPNv4 Unicast
          BGP diverse-paths computation is enabled 
          Session: 192.168.165.120
          BGP table version 33086714, neighbor version 33086714/0
          Output queue size : 0
          Index 1954, Advertise bit 0
          1954 update-group member
          Community attribute sent to this neighbor
          Extended-community attribute sent to this neighbor
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:           10202    2001899 (Consumes 240227880 bytes)
            Prefixes Total:            131522   18498954
            Implicit Withdraw:          81710   12437988
            Explicit Withdraw:        2045210    4059067
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            ORIGINATOR loop:                    n/a     191399
            Bestpath from this peer:       10473918        n/a
            Bestpath from iBGP peer:        3488082        n/a
            AF Permit Check:                  84090        n/a
            AF Update Check:                  11509        n/a
            Total:                         14057599     191399
          Number of NLRIs in the update sent: max 270, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 9
          Last Sent Refresh Start-of-rib: 04:52:14
          Last Sent Refresh End-of-rib: 04:51:02
          Refresh-Out took 72 seconds
          Last Received Refresh Start-of-rib: 21:35:12
          Last Received Refresh End-of-rib: 21:34:57
          Refresh-In took 15 seconds
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          7          8
              Refresh End-of-RIB            7          7

        For address family: L2VPN Vpls
          Session: 192.168.165.120
          BGP table version 403, neighbor version 403/0
          Output queue size : 0
          Index 4, Advertise bit 0
          4 update-group member
          Extended-community attribute sent to this neighbor
          Suppress LDP signaling protocol
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:             201        201 (Consumes 27336 bytes)
            Prefixes Total:              1809       1608
            Implicit Withdraw:           1608       1407
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            ORIGINATOR loop:                    n/a       1608
            Bestpath from this peer:           1407        n/a
            Total:                             1407       1608
          Number of NLRIs in the update sent: max 1, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 9
          Last Sent Refresh Start-of-rib: 04:52:14
          Last Sent Refresh End-of-rib: 04:52:14
          Refresh-Out took 0 seconds
          Last Received Refresh Start-of-rib: 21:35:12
          Last Received Refresh End-of-rib: 21:35:12
          Refresh-In took 0 seconds
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          6          8
              Refresh End-of-RIB            6          8

          Address tracking is enabled, the RIB does have a route to 192.168.165.120
          Connections established 4; dropped 3
          Last reset 1d16h, due to Neighbor reset
          Interface associated: (none) (peering address NOT in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is enabled, restart-time 120 seconds, stalepath-time 360 seconds
          SSO is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0            
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.169.197.254, Local port: 13949
        Foreign host: 192.168.165.120, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x233AE79E):
        Timer          Starts    Wakeups            Next
        Retrans         35475          3             0x0
        TimeWait            0          0             0x0
        AckHold        153946       6831             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:  673876598  snduna:  750238254  sndnxt:  750238254
        irs: 3910340259  rcvnxt: 4266909361

        sndwnd:  15567  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16061  scale:      0  delrcvwnd:    323

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 0 ms, maxRTT: 1344 ms, ACK hold: 200 ms
        uptime: 144455028 ms, Sent idletime: 9744 ms, Receive idletime: 9542 ms 
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1400 bytes):
        Rcvd: 363804 (out of order: 0), with data: 281016, total data bytes: 356569101
        Sent: 423496 (retransmit: 3, fastretransmit: 1, partialack: 0, Second Congestion: 0), with data: 62849, total data bytes: 76361745

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x7FDED5D66E70  FREE 
        Router#
        '''}

    golden_parsed_output3 = {
        'list_of_neighbors': ['192.168.165.119'],
        'vrf': {'default': {'neighbor': {'192.168.165.119': {'address_family': {'l2vpn vpls': {'advertise_bit': 0,
                                                                                        'bgp_table_version': 403,
                                                                                        'current_time': '0x233AE2F9',
                                                                                        'dynamic_slow_peer_recovered': 'never',
                                                                                        'extended_community_attribute_sent': True,
                                                                                        'index': 4,
                                                                                        'last_detected_dynamic_slow_peer': 'never',
                                                                                        'last_received_refresh_end_of_rib': '21:35:10',
                                                                                        'last_received_refresh_start_of_rib': '21:35:11',
                                                                                        'last_sent_refresh_end_of_rib': '04:52:13',
                                                                                        'last_sent_refresh_start_of_rib': '04:52:13',
                                                                                        'local_policy_denied_prefixes_counters': {'inbound': {'bestpath_from_this_peer': 'n/a',
                                                                                                                                              'originator_loop': 1206,
                                                                                                                                              'total': 1206},
                                                                                                                                  'outbound': {'bestpath_from_this_peer': 1407,
                                                                                                                                               'originator_loop': 'n/a',
                                                                                                                                               'total': 1407}},
                                                                                        'max_nlri': 1,
                                                                                        'min_nlri': 0,
                                                                                        'neighbor_version': '403/0',
                                                                                        'output_queue_size': 0,
                                                                                        'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                                  'implicit_withdraw': 1005,
                                                                                                                                  'prefixes_total': 1206,
                                                                                                                                  'used_as_bestpath': 201,
                                                                                                                                  'used_as_multipath': 0},
                                                                                                                     'sent': {'explicit_withdraw': 0,
                                                                                                                              'implicit_withdraw': 1608,
                                                                                                                              'prefixes_total': 1809,
                                                                                                                              'used_as_bestpath': 'n/a',
                                                                                                                              'used_as_multipath': 'n/a'}},
                                                                                        'refresh_activity_counters': {'received': {'refresh_end_of_rib': 6,
                                                                                                                                   'refresh_start_of_rib': 6},
                                                                                                                      'sent': {'refresh_end_of_rib': 2,
                                                                                                                               'refresh_start_of_rib': 2}},
                                                                                        'refresh_epoch': 7,
                                                                                        'refresh_in': 1,
                                                                                        'refresh_out': 0,
                                                                                        'slow_peer_detection': False,
                                                                                        'slow_peer_split_update_group_dynamic': False,
                                                                                        'suppress_ldp_signaling': True,
                                                                                        'update_group_member': 4},
                                                                         'vpnv4 unicast': {'advertise_bit': 0,
                                                                                           'bgp_table_version': 33086714,
                                                                                           'community_attribute_sent': True,
                                                                                           'dynamic_slow_peer_recovered': 'never',
                                                                                           'extended_community_attribute_sent': True,
                                                                                           'index': 1954,
                                                                                           'last_detected_dynamic_slow_peer': 'never',
                                                                                           'last_received_refresh_end_of_rib': '21:34:52',
                                                                                           'last_received_refresh_start_of_rib': '21:35:11',
                                                                                           'last_sent_refresh_end_of_rib': '04:51:01',
                                                                                           'last_sent_refresh_start_of_rib': '04:52:13',
                                                                                           'local_policy_denied_prefixes_counters': {'inbound': {'af_permit_check': 'n/a',
                                                                                                                                                 'af_update_check': 'n/a',
                                                                                                                                                 'bestpath_from_ibgp_peer': 'n/a',
                                                                                                                                                 'bestpath_from_this_peer': 'n/a',
                                                                                                                                                 'originator_loop': 151495,
                                                                                                                                                 'total': 151495},
                                                                                                                                     'outbound': {'af_permit_check': 84090,
                                                                                                                                                  'af_update_check': 11509,
                                                                                                                                                  'bestpath_from_ibgp_peer': 3488082,
                                                                                                                                                  'bestpath_from_this_peer': 10473918,
                                                                                                                                                  'originator_loop': 'n/a',
                                                                                                                                                  'total': 14057599}},
                                                                                           'max_nlri': 270,
                                                                                           'min_nlri': 0,
                                                                                           'neighbor_version': '33086714/0',
                                                                                           'output_queue_size': 0,
                                                                                           'prefix_activity_counters': {'received': {'explicit_withdraw': 4059067,
                                                                                                                                     'implicit_withdraw': 10255632,
                                                                                                                                     'prefixes_total': 16316598,
                                                                                                                                     'used_as_bestpath': 2005600,
                                                                                                                                     'used_as_multipath': 0},
                                                                                                                        'sent': {'explicit_withdraw': 2045210,
                                                                                                                                 'implicit_withdraw': 81710,
                                                                                                                                 'prefixes_total': 131522,
                                                                                                                                 'used_as_bestpath': 'n/a',
                                                                                                                                 'used_as_multipath': 'n/a'}},
                                                                                           'refresh_activity_counters': {'received': {'refresh_end_of_rib': 6,
                                                                                                                                      'refresh_start_of_rib': 6},
                                                                                                                         'sent': {'refresh_end_of_rib': 4,
                                                                                                                                  'refresh_start_of_rib': 4}},
                                                                                           'refresh_epoch': 7,
                                                                                           'refresh_in': 19,
                                                                                           'refresh_out': 72,
                                                                                           'slow_peer_detection': False,
                                                                                           'slow_peer_split_update_group_dynamic': False,
                                                                                           'update_group_member': 1954}},
                                                      'bgp_event_timer': {'next': {'ackhold': '0x0',
                                                                                   'deadwait': '0x0',
                                                                                   'giveup': '0x0',
                                                                                   'keepalive': '0x0',
                                                                                   'linger': '0x0',
                                                                                   'pmtuager': '0x0',
                                                                                   'processq': '0x0',
                                                                                   'retrans': '0x0',
                                                                                   'sendwnd': '0x0',
                                                                                   'timewait': '0x0'},
                                                                          'starts': {'ackhold': 137871,
                                                                                     'deadwait': 0,
                                                                                     'giveup': 0,
                                                                                     'keepalive': 0,
                                                                                     'linger': 0,
                                                                                     'pmtuager': 1,
                                                                                     'processq': 0,
                                                                                     'retrans': 55014,
                                                                                     'sendwnd': 8,
                                                                                     'timewait': 0},
                                                                          'wakeups': {'ackhold': 6940,
                                                                                      'deadwait': 0,
                                                                                      'giveup': 0,
                                                                                      'keepalive': 0,
                                                                                      'linger': 0,
                                                                                      'pmtuager': 1,
                                                                                      'processq': 0,
                                                                                      'retrans': 14,
                                                                                      'sendwnd': 0,
                                                                                      'timewait': 0}},
                                                                                      'bgp_neighbor_session': {
                                                                                        'sessions': 1,
                                                                                        },
                                                      'bgp_negotiated_capabilities': {'enhanced_refresh': 'advertised '
                                                                                                          'and '
                                                                                                          'received',
                                                                                      'four_octets_asn': 'advertised '
                                                                                                         'and '
                                                                                                         'received',
                                                                                      'graceful_restart': 'advertised '
                                                                                                          'and '
                                                                                                          'received',
                                                                                      'graceful_restart_af_advertised_by_peer': ['vpnv4 '
                                                                                                                                 'unicast',
                                                                                                                                 'l2vpn '
                                                                                                                                 'vpls'],
                                                                                      'l2vpn_vpls': 'advertised '
                                                                                                    'and '
                                                                                                    'received',
                                                                                      'remote_restart_timer': 120,
                                                                                      'route_refresh': 'advertised '
                                                                                                       'and '
                                                                                                       'received(new)',
                                                                                      'stateful_switchover': 'NO '
                                                                                                             'for '
                                                                                                             'session '
                                                                                                             '1',
                                                                                      'vpnv4_unicast': 'advertised '
                                                                                                       'and '
                                                                                                       'received'},
                                                      'bgp_negotiated_keepalive_timers': {'hold_time': 90,
                                                                                          'keepalive_interval': 30,
                                                                                          'min_holdtime': 15},
                                                      'bgp_neighbor_counters': {'messages': {'in_queue_depth': 0,
                                                                                             'out_queue_depth': 0,
                                                                                             'received': {'keepalives': 4709,
                                                                                                          'notifications': 0,
                                                                                                          'opens': 1,
                                                                                                          'route_refresh': 0,
                                                                                                          'total': 127376,
                                                                                                          'updates': 122642},
                                                                                             'sent': {'keepalives': 5188,
                                                                                                      'notifications': 0,
                                                                                                      'opens': 1,
                                                                                                      'route_refresh': 10,
                                                                                                      'total': 55036,
                                                                                                      'updates': 49825}}},
                                                      'bgp_session_transport': {'ack_hold': 200,
                                                                                'address_tracking_status': 'enabled',
                                                                                'connection': {'dropped': 3,
                                                                                               'established': 4,
                                                                                               'last_reset': '1d16h',
                                                                                               'reset_reason': 'Neighbor '
                                                                                                               'reset'},
                                                                                'connection_state': 'estab',
                                                                                'connection_tableid': 0,
                                                                                'datagram': {'datagram_received': {'out_of_order': 0,
                                                                                                                   'total_data': 322194190,
                                                                                                                   'value': 392625,
                                                                                                                   'with_data': 254123},
                                                                                             'datagram_sent': {'fastretransmit': 1992,
                                                                                                               'partialack': 1067,
                                                                                                               'retransmit': 22,
                                                                                                               'second_congestion': 0,
                                                                                                               'total_data': 131166632,
                                                                                                               'value': 434376,
                                                                                                               'with_data': 102975}},
                                                                                'delrcvwnd': 741,
                                                                                'ecn_connection': 'disabled',
                                                                                'enqueued_packets': {'input_packet': 0,
                                                                                                     'mis_ordered_packet': 0,
                                                                                                     'retransmit_packet': 0},
                                                                                'fast_lock_acquisition_failures': 0,
                                                                                'gr_restart_time': 120,
                                                                                'gr_stalepath_time': 360,
                                                                                'graceful_restart': 'enabled',
                                                                                'io_status': 1,
                                                                                'ip_precedence_value': 6,
                                                                                'irs': 3539951191,
                                                                                'iss': 61822047,
                                                                                'krtt': 0,
                                                                                'lock_slow_path': 0,
                                                                                'max_rtt': 1019,
                                                                                'maximum_output_segment_queue_size': 50,
                                                                                'maxrcvwnd': 16384,
                                                                                'min_rtt': 0,
                                                                                'min_time_between_advertisement_runs': 0,
                                                                                'minimum_incoming_ttl': 0,
                                                                                'option_flags': 'nagle, '
                                                                                                'path '
                                                                                                'mtu '
                                                                                                'capable',
                                                                                'outgoing_ttl': 255,
                                                                                'packet_fast_path': 0,
                                                                                'packet_fast_processed': 0,
                                                                                'packet_slow_path': 0,
                                                                                'rcv_scale': 0,
                                                                                'rcvnxt': 3862145382,
                                                                                'rcvwnd': 15643,
                                                                                'receive_idletime': 15525,
                                                                                'rib_route_ip': '192.168.165.119',
                                                                                'rtto': 1003,
                                                                                'rtv': 3,
                                                                                'sent_idletime': 15727,
                                                                                'snd_scale': 0,
                                                                                'sndnxt': 190308893,
                                                                                'snduna': 190308893,
                                                                                'sndwnd': 15510,
                                                                                'srtt': 1000,
                                                                                'sso': False,
                                                                                'status_flags': 'active '
                                                                                                'open',
                                                                                'tcp_path_mtu_discovery': 'enabled',
                                                                                'tcp_semaphore': '0x7FDE7F22E108',
                                                                                'tcp_semaphore_status': 'FREE',
                                                                                'transport': {'foreign_host': '192.168.165.119',
                                                                                              'foreign_port': '179',
                                                                                              'local_host': '10.169.197.254',
                                                                                              'local_port': '13427',
                                                                                              'mss': 1400},
                                                                                'unread_input_bytes': 0,
                                                                                'uptime': 144452788},
                                                      'bgp_version': 4,
                                                      'link': 'internal',
                                                      'remote_as': 5918,
                                                      'router_id': '192.168.165.119',
                                                      'session_state': 'Established',
                                                      'shutdown': False}}}}}

    golden_output3 = {'execute.return_value': '''
        Router#show bgp l2vpn vpls all neighbors 192.168.165.119
        Load for five secs: 4%/0%; one minute: 5%; five minutes: 4%
        Time source is NTP, 16:31:13.822 EST Tue Jun 8 2016

        BGP neighbor is 192.168.165.119,  remote AS 5918, internal link
          BGP version 4, remote router ID 192.168.165.119
          BGP state = Established, up for 1d16h
          Last read 00:00:23, last write 00:00:15, hold time is 90, keepalive interval is 30 seconds
          Configured hold time is 90, keepalive interval is 30 seconds
          Minimum holdtime from neighbor is 15 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family L2VPN Vpls: advertised and received
            Graceful Restart Capability: advertised and received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, L2VPN Vpls (was not preserved
            Enhanced Refresh Capability: advertised and received
            Multisession Capability: 
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0
            
                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:            49825     122642
            Keepalives:          5188       4709
            Route Refresh:         10          0
            Total:              55036     127376
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

         For address family: VPNv4 Unicast
          BGP diverse-paths computation is enabled 
          Session: 192.168.165.119
          BGP table version 33086714, neighbor version 33086714/0
          Output queue size : 0
          Index 1954, Advertise bit 0
          1954 update-group member
          Community attribute sent to this neighbor
          Extended-community attribute sent to this neighbor
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:           10202    2001899 (Consumes 240672000 bytes)
            Prefixes Total:            131522   16316598
            Implicit Withdraw:          81710   10255632
            Explicit Withdraw:        2045210    4059067
            Used as bestpath:             n/a    2005600
            Used as multipath:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            ORIGINATOR loop:                    n/a     151495
            Bestpath from this peer:       10473918        n/a
            Bestpath from iBGP peer:        3488082        n/a
            AF Permit Check:                  84090        n/a
            AF Update Check:                  11509        n/a
            Total:                         14057599     151495
          Number of NLRIs in the update sent: max 270, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 7
          Last Sent Refresh Start-of-rib: 04:52:13
          Last Sent Refresh End-of-rib: 04:51:01
          Refresh-Out took 72 seconds
          Last Received Refresh Start-of-rib: 21:35:11
          Last Received Refresh End-of-rib: 21:34:52
          Refresh-In took 19 seconds
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          4          6
              Refresh End-of-RIB            4          6

         For address family: L2VPN Vpls
          Session: 192.168.165.119
          BGP table version 403, neighbor version 403/0
          Output queue size : 0
          Index 4, Advertise bit 0
          4 update-group member
          Extended-community attribute sent to this neighbor
          Suppress LDP signaling protocol
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:             201        201 (Consumes 27336 bytes)
            Prefixes Total:              1809       1206
            Implicit Withdraw:           1608       1005
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a        201
            Used as multipath:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            ORIGINATOR loop:                    n/a       1206
            Bestpath from this peer:           1407        n/a
            Total:                             1407       1206
          Number of NLRIs in the update sent: max 1, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 7
          Last Sent Refresh Start-of-rib: 04:52:13
          Last Sent Refresh End-of-rib: 04:52:13
          Refresh-Out took 0 seconds
          Last Received Refresh Start-of-rib: 21:35:11
          Last Received Refresh End-of-rib: 21:35:10
          Refresh-In took 1 seconds
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          2          6
              Refresh End-of-RIB            2          6

          Address tracking is enabled, the RIB does have a route to 192.168.165.119
          Connections established 4; dropped 3
          Last reset 1d16h, due to Neighbor reset
          Interface associated: (none) (peering address NOT in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is enabled, restart-time 120 seconds, stalepath-time 360 seconds
          SSO is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0            
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.169.197.254, Local port: 13427
        Foreign host: 192.168.165.119, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x233AE2F9):
        Timer          Starts    Wakeups            Next
        Retrans         55014         14             0x0
        TimeWait            0          0             0x0
        AckHold        137871       6940             0x0
        SendWnd             8          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:   61822047  snduna:  190308893  sndnxt:  190308893
        irs: 3539951191  rcvnxt: 3862145382

        sndwnd:  15510  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15643  scale:      0  delrcvwnd:    741

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 0 ms, maxRTT: 1019 ms, ACK hold: 200 ms
        uptime: 144452788 ms, Sent idletime: 15727 ms, Receive idletime: 15525 ms 
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1400 bytes):
        Rcvd: 392625 (out of order: 0), with data: 254123, total data bytes: 322194190
        Sent: 434376 (retransmit: 22, fastretransmit: 1992, partialack: 1067, Second Congestion: 0), with data: 102975, total data bytes: 131166632

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x7FDE7F22E108  FREE 
        Router#
        '''}

    golden_parsed_output4 = {
        'list_of_neighbors': [
            '10.16.2.2',
            '10.36.3.3',
            '10.4.6.6',
            '10.66.6.6',
            '10.64.4.4',
            '10.100.5.5',
            '2001:DB8:4:6::6',
            '2001:DB8:20:4:6::6'
        ],
        'vrf': {
            'default': {
                'neighbor': {
                    '10.16.2.2': {
                        'remote_as': 100,
                        'link': 'internal',
                        'shutdown': False,
                        'address_family': {
                            'vpnv4 unicast': {
                                'session_state': 'Established',
                                'up_time': '01:10:35',
                                'last_read': '00:00:04',
                                'last_write': '00:00:09',
                                'current_time': '0x530449'
                            }
                        },
                        'bgp_version': 4,
                        'router_id': '10.16.2.2',
                        'session_state': 'Established',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 180,
                            'keepalive_interval': 60
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised and received(new)',
                            'four_octets_asn': 'advertised and received',
                            'vpnv4_unicast': 'advertised and received',
                            'vpnv6_unicast': 'advertised and received',
                            'graceful_restart': 'received',
                            'remote_restart_timer': 120,
                            'graceful_restart_af_advertised_by_peer': [
                                'vpnv4 unicast',
                                'vpnv6 unicast'
                            ],
                            'enhanced_refresh': 'advertised',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 11,
                                    'keepalives': 75,
                                    'route_refresh': 0,
                                    'total': 87
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 6,
                                    'keepalives': 74,
                                    'route_refresh': 0,
                                    'total': 81
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '10.16.2.2',
                            'connection': {
                                'established': 1,
                                'dropped': 0,
                                'last_reset': 'never'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'disabled',
                            'connection_state': 'estab',
                            'io_status': 1,
                            'unread_input_bytes': 0,
                            'ecn_connection': 'disabled',
                            'minimum_incoming_ttl': 0,
                            'outgoing_ttl': 255,
                            'transport': {
                                'local_host': '10.64.4.4',
                                'local_port': '35281',
                                'foreign_host': '10.16.2.2',
                                'foreign_port': '179',
                                'mss': 536
                            },
                            'connection_tableid': 0,
                            'maximum_output_segment_queue_size': 50,
                            'enqueued_packets': {
                                'retransmit_packet': 0,
                                'input_packet': 0,
                                'mis_ordered_packet': 0
                            },
                            'iss': 55023811,
                            'snduna': 55027115,
                            'sndnxt': 55027115,
                            'irs': 109992783,
                            'rcvnxt': 109995158,
                            'sndwnd': 16616,
                            'snd_scale': 0,
                            'maxrcvwnd': 16384,
                            'rcvwnd': 16327,
                            'rcv_scale': 0,
                            'delrcvwnd': 57,
                            'srtt': 1000,
                            'rtto': 1003,
                            'rtv': 3,
                            'krtt': 0,
                            'min_rtt': 4,
                            'max_rtt': 1000,
                            'ack_hold': 200,
                            'uptime': 4236258,
                            'sent_idletime': 4349,
                            'receive_idletime': 4549,
                            'status_flags': 'active open',
                            'option_flags': 'nagle, path mtu capable',
                            'ip_precedence_value': 6,
                            'datagram': {
                                'datagram_received': {
                                    'value': 164,
                                    'out_of_order': 0,
                                    'with_data': 80,
                                    'total_data': 2374
                                },
                                'datagram_sent': {
                                    'value': 166,
                                    'retransmit': 0,
                                    'fastretransmit': 0,
                                    'partialack': 0,
                                    'second_congestion': 0,
                                    'with_data': 87,
                                    'total_data': 3303
                                }
                            },
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'fast_lock_acquisition_failures': 0,
                            'lock_slow_path': 0,
                            'tcp_semaphore': '0x1286E7EC',
                            'tcp_semaphore_status': 'FREE'
                        },
                        'bgp_event_timer': {
                            'starts': {
                                'retrans': 86,
                                'timewait': 0,
                                'ackhold': 80,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 1,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'wakeups': {
                                'retrans': 0,
                                'timewait': 0,
                                'ackhold': 72,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 1,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'next': {
                                'retrans': '0x0',
                                'timewait': '0x0',
                                'ackhold': '0x0',
                                'sendwnd': '0x0',
                                'keepalive': '0x0',
                                'giveup': '0x0',
                                'pmtuager': '0x0',
                                'deadwait': '0x0',
                                'linger': '0x0',
                                'processq': '0x0'
                            }
                        }
                    },
                    '10.36.3.3': {
                        'remote_as': 100,
                        'link': 'internal',
                        'shutdown': False,
                        'address_family': {
                            'vpnv4 unicast': {
                                'session_state': 'Established',
                                'up_time': '01:10:41',
                                'last_read': '00:00:04',
                                'last_write': '00:00:43',
                                'current_time': '0x530638'
                            }
                        },
                        'bgp_version': 4,
                        'router_id': '10.36.3.3',
                        'session_state': 'Established',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 180,
                            'keepalive_interval': 60
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised and received(new)',
                            'four_octets_asn': 'advertised and received',
                            'vpnv4_unicast': 'advertised and received',
                            'vpnv6_unicast': 'advertised and received',
                            'graceful_restart': 'received',
                            'remote_restart_timer': 120,
                            'graceful_restart_af_advertised_by_peer': [
                                'vpnv4 unicast',
                                'vpnv6 unicast'
                            ],
                            'enhanced_refresh': 'advertised',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 11,
                                    'keepalives': 75,
                                    'route_refresh': 0,
                                    'total': 87
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 6,
                                    'keepalives': 74,
                                    'route_refresh': 0,
                                    'total': 81
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '10.36.3.3',
                            'connection': {
                                'established': 1,
                                'dropped': 0,
                                'last_reset': 'never'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'disabled',
                            'connection_state': 'estab',
                            'io_status': 1,
                            'unread_input_bytes': 0,
                            'ecn_connection': 'disabled',
                            'minimum_incoming_ttl': 0,
                            'outgoing_ttl': 255,
                            'transport': {
                                'local_host': '10.64.4.4',
                                'local_port': '56031',
                                'foreign_host': '10.36.3.3',
                                'foreign_port': '179',
                                'mss': 536
                            },
                            'connection_tableid': 0,
                            'maximum_output_segment_queue_size': 50,
                            'enqueued_packets': {
                                'retransmit_packet': 0,
                                'input_packet': 0,
                                'mis_ordered_packet': 0
                            },
                            'iss': 2116369173,
                            'snduna': 2116372477,
                            'sndnxt': 2116372477,
                            'irs': 4033842748,
                            'rcvnxt': 4033845123,
                            'sndwnd': 16616,
                            'snd_scale': 0,
                            'maxrcvwnd': 16384,
                            'rcvwnd': 16327,
                            'rcv_scale': 0,
                            'delrcvwnd': 57,
                            'srtt': 1000,
                            'rtto': 1003,
                            'rtv': 3,
                            'krtt': 0,
                            'min_rtt': 3,
                            'max_rtt': 1000,
                            'ack_hold': 200,
                            'uptime': 4243393,
                            'sent_idletime': 5375,
                            'receive_idletime': 5575,
                            'status_flags': 'active open',
                            'option_flags': 'nagle, path mtu capable',
                            'ip_precedence_value': 6,
                            'datagram': {
                                'datagram_received': {
                                    'value': 165,
                                    'out_of_order': 0,
                                    'with_data': 80,
                                    'total_data': 2374
                                },
                                'datagram_sent': {
                                    'value': 167,
                                    'retransmit': 0,
                                    'fastretransmit': 0,
                                    'partialack': 0,
                                    'second_congestion': 0,
                                    'with_data': 87,
                                    'total_data': 3303
                                }
                            },
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'fast_lock_acquisition_failures': 0,
                            'lock_slow_path': 0,
                            'tcp_semaphore': '0x1286E85C',
                            'tcp_semaphore_status': 'FREE'
                        },
                        'bgp_event_timer': {
                            'starts': {
                                'retrans': 86,
                                'timewait': 0,
                                'ackhold': 80,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 1,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'wakeups': {
                                'retrans': 0,
                                'timewait': 0,
                                'ackhold': 73,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 1,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'next': {
                                'retrans': '0x0',
                                'timewait': '0x0',
                                'ackhold': '0x0',
                                'sendwnd': '0x0',
                                'keepalive': '0x0',
                                'giveup': '0x0',
                                'pmtuager': '0x0',
                                'deadwait': '0x0',
                                'linger': '0x0',
                                'processq': '0x0'
                            }
                        }
                    },
                    '10.64.4.4': {
                        'remote_as': 100,
                        'link': 'internal',
                        'shutdown': False,
                        'address_family': {
                            'vpnv6 unicast': {
                                'session_state': 'Established',
                                'up_time': '01:10:38',
                                'last_read': '00:00:07',
                                'last_write': '00:00:12',
                                'current_time': '0x530FF5'
                            }
                        },
                        'description': 'router2222222',
                        'bgp_version': 4,
                        'router_id': '10.64.4.4',
                        'session_state': 'Established',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 180,
                            'keepalive_interval': 60
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised and received(new)',
                            'four_octets_asn': 'advertised and received',
                            'vpnv4_unicast': 'advertised and received',
                            'vpnv6_unicast': 'advertised and received',
                            'graceful_restart': 'received',
                            'remote_restart_timer': 120,
                            'graceful_restart_af_advertised_by_peer': [
                                'vpnv4 unicast',
                                'vpnv6 unicast'
                            ],
                            'enhanced_refresh': 'advertised',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 11,
                                    'keepalives': 75,
                                    'route_refresh': 0,
                                    'total': 87
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 6,
                                    'keepalives': 74,
                                    'route_refresh': 0,
                                    'total': 81
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '10.16.2.2',
                            'connection': {
                                'established': 1,
                                'dropped': 0,
                                'last_reset': 'never'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'disabled',
                            'connection_state': 'estab',
                            'io_status': 1,
                            'unread_input_bytes': 0,
                            'ecn_connection': 'disabled',
                            'minimum_incoming_ttl': 0,
                            'outgoing_ttl': 255,
                            'transport': {
                                'local_host': '10.64.4.4',
                                'local_port': '35281',
                                'foreign_host': '10.16.2.2',
                                'foreign_port': '179',
                                'mss': 536
                            },
                            'connection_tableid': 0,
                            'maximum_output_segment_queue_size': 50,
                            'enqueued_packets': {
                                'retransmit_packet': 0,
                                'input_packet': 0,
                                'mis_ordered_packet': 0
                            },
                            'iss': 55023811,
                            'snduna': 55027115,
                            'sndnxt': 55027115,
                            'irs': 109992783,
                            'rcvnxt': 109995158,
                            'sndwnd': 16616,
                            'snd_scale': 0,
                            'maxrcvwnd': 16384,
                            'rcvwnd': 16327,
                            'rcv_scale': 0,
                            'delrcvwnd': 57,
                            'srtt': 1000,
                            'rtto': 1003,
                            'rtv': 3,
                            'krtt': 0,
                            'min_rtt': 4,
                            'max_rtt': 1000,
                            'ack_hold': 200,
                            'uptime': 4239741,
                            'sent_idletime': 7832,
                            'receive_idletime': 8032,
                            'status_flags': 'active open',
                            'option_flags': 'nagle, path mtu capable',
                            'ip_precedence_value': 6,
                            'datagram': {
                                'datagram_received': {
                                    'value': 164,
                                    'out_of_order': 0,
                                    'with_data': 80,
                                    'total_data': 2374
                                },
                                'datagram_sent': {
                                    'value': 166,
                                    'retransmit': 0,
                                    'fastretransmit': 0,
                                    'partialack': 0,
                                    'second_congestion': 0,
                                    'with_data': 87,
                                    'total_data': 3303
                                }
                            },
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'fast_lock_acquisition_failures': 0,
                            'lock_slow_path': 0,
                            'tcp_semaphore': '0x1286E7EC',
                            'tcp_semaphore_status': 'FREE'
                        },
                        'bgp_event_timer': {
                            'starts': {
                                'retrans': 86,
                                'timewait': 0,
                                'ackhold': 80,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 1,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'wakeups': {
                                'retrans': 0,
                                'timewait': 0,
                                'ackhold': 72,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 1,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'next': {
                                'retrans': '0x0',
                                'timewait': '0x0',
                                'ackhold': '0x0',
                                'sendwnd': '0x0',
                                'keepalive': '0x0',
                                'giveup': '0x0',
                                'pmtuager': '0x0',
                                'deadwait': '0x0',
                                'linger': '0x0',
                                'processq': '0x0'
                            }
                        }
                    },
                    '10.100.5.5': {
                        'remote_as': 100,
                        'link': 'internal',
                        'shutdown': False,
                        'address_family': {
                            'vpnv6 unicast': {
                                'session_state': 'Established',
                                'up_time': '01:10:44',
                                'last_read': '00:00:08',
                                'last_write': '00:00:47',
                                'current_time': '0x5313D8'
                            }
                        },
                        'bgp_version': 4,
                        'router_id': '10.100.5.5',
                        'session_state': 'Established',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 180,
                            'keepalive_interval': 60
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised and received(new)',
                            'four_octets_asn': 'advertised and received',
                            'vpnv4_unicast': 'advertised and received',
                            'vpnv6_unicast': 'advertised and received',
                            'graceful_restart': 'received',
                            'remote_restart_timer': 120,
                            'graceful_restart_af_advertised_by_peer': [
                                'vpnv4 unicast',
                                'vpnv6 unicast'
                            ],
                            'enhanced_refresh': 'advertised',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 11,
                                    'keepalives': 75,
                                    'route_refresh': 0,
                                    'total': 87
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 6,
                                    'keepalives': 74,
                                    'route_refresh': 0,
                                    'total': 81
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '10.36.3.3',
                            'connection': {
                                'established': 1,
                                'dropped': 0,
                                'last_reset': 'never'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'disabled',
                            'connection_state': 'estab',
                            'io_status': 1,
                            'unread_input_bytes': 0,
                            'ecn_connection': 'disabled',
                            'minimum_incoming_ttl': 0,
                            'outgoing_ttl': 255,
                            'transport': {
                                'local_host': '10.64.4.4',
                                'local_port': '56031',
                                'foreign_host': '10.36.3.3',
                                'foreign_port': '179',
                                'mss': 536
                            },
                            'connection_tableid': 0,
                            'maximum_output_segment_queue_size': 50,
                            'enqueued_packets': {
                                'retransmit_packet': 0,
                                'input_packet': 0,
                                'mis_ordered_packet': 0
                            },
                            'iss': 2116369173,
                            'snduna': 2116372477,
                            'sndnxt': 2116372477,
                            'irs': 4033842748,
                            'rcvnxt': 4033845123,
                            'sndwnd': 16616,
                            'snd_scale': 0,
                            'maxrcvwnd': 16384,
                            'rcvwnd': 16327,
                            'rcv_scale': 0,
                            'delrcvwnd': 57,
                            'srtt': 1000,
                            'rtto': 1003,
                            'rtv': 3,
                            'krtt': 0,
                            'min_rtt': 3,
                            'max_rtt': 1000,
                            'ack_hold': 200,
                            'uptime': 4246385,
                            'sent_idletime': 8367,
                            'receive_idletime': 8567,
                            'status_flags': 'active open',
                            'option_flags': 'nagle, path mtu capable',
                            'ip_precedence_value': 6,
                            'datagram': {
                                'datagram_received': {
                                    'value': 165,
                                    'out_of_order': 0,
                                    'with_data': 80,
                                    'total_data': 2374
                                },
                                'datagram_sent': {
                                    'value': 167,
                                    'retransmit': 0,
                                    'fastretransmit': 0,
                                    'partialack': 0,
                                    'second_congestion': 0,
                                    'with_data': 87,
                                    'total_data': 3303
                                }
                            },
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'fast_lock_acquisition_failures': 0,
                            'lock_slow_path': 0,
                            'tcp_semaphore': '0x1286E85C',
                            'tcp_semaphore_status': 'FREE'
                        },
                        'bgp_event_timer': {
                            'starts': {
                                'retrans': 86,
                                'timewait': 0,
                                'ackhold': 80,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 1,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'wakeups': {
                                'retrans': 0,
                                'timewait': 0,
                                'ackhold': 73,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 1,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'next': {
                                'retrans': '0x0',
                                'timewait': '0x0',
                                'ackhold': '0x0',
                                'sendwnd': '0x0',
                                'keepalive': '0x0',
                                'giveup': '0x0',
                                'pmtuager': '0x0',
                                'deadwait': '0x0',
                                'linger': '0x0',
                                'processq': '0x0'
                            }
                        }
                    }
                }
            },
            'VRF1': {
                'neighbor': {
                    '10.4.6.6': {
                        'remote_as': 300,
                        'link': 'external',
                        'shutdown': True,
                        'address_family': {
                            'vpnv4 unicast': {
                                'session_state': 'Established',
                                'up_time': '01:01:59',
                                'last_read': '00:00:33',
                                'last_write': '00:00:30',
                                'current_time': '0x530A19'
                            }
                        },
                        'bgp_version': 4,
                        'router_id': '10.4.6.6',
                        'session_state': 'Established',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 180,
                            'keepalive_interval': 60
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised',
                            'four_octets_asn': 'advertised',
                            'ipv4_unicast': 'advertised and received',
                            'enhanced_refresh': 'advertised',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 3,
                                    'keepalives': 69,
                                    'route_refresh': 0,
                                    'total': 73
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 1,
                                    'keepalives': 64,
                                    'route_refresh': 0,
                                    'total': 66
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '10.4.6.6',
                            'connection': {
                                'established': 2,
                                'dropped': 1,
                                'last_reset': '01:02:11',
                                'reset_reason': 'Peer closed the session of session 1'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'disabled',
                            'connection_state': 'estab',
                            'io_status': 1,
                            'unread_input_bytes': 0,
                            'ecn_connection': 'disabled',
                            'minimum_incoming_ttl': 0,
                            'outgoing_ttl': 1,
                            'transport': {
                                'local_host': '10.4.6.4',
                                'local_port': '179',
                                'foreign_host': '10.4.6.6',
                                'foreign_port': '11010',
                                'mss': 1460
                            },
                            'connection_tableid': 1,
                            'maximum_output_segment_queue_size': 50,
                            'enqueued_packets': {
                                'retransmit_packet': 0,
                                'input_packet': 0,
                                'mis_ordered_packet': 0
                            },
                            'iss': 271842,
                            'snduna': 273380,
                            'sndnxt': 273380,
                            'irs': 930048172,
                            'rcvnxt': 930049503,
                            'sndwnd': 32000,
                            'snd_scale': 0,
                            'maxrcvwnd': 16384,
                            'rcvwnd': 15054,
                            'rcv_scale': 0,
                            'delrcvwnd': 1330,
                            'srtt': 1000,
                            'rtto': 1003,
                            'rtv': 3,
                            'krtt': 0,
                            'min_rtt': 1,
                            'max_rtt': 1000,
                            'ack_hold': 200,
                            'uptime': 3720132,
                            'sent_idletime': 31107,
                            'receive_idletime': 30999,
                            'status_flags': 'passive open, gen tcbs',
                            'option_flags': 'VRF id set, nagle, path mtu capable',
                            'ip_precedence_value': 6,
                            'datagram': {
                                'datagram_received': {
                                    'value': 137,
                                    'out_of_order': 0,
                                    'with_data': 66,
                                    'total_data': 1330
                                },
                                'datagram_sent': {
                                    'value': 138,
                                    'retransmit': 0,
                                    'fastretransmit': 0,
                                    'partialack': 0,
                                    'second_congestion': 0,
                                    'with_data': 72,
                                    'total_data': 1537
                                }
                            },
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'fast_lock_acquisition_failures': 0,
                            'lock_slow_path': 0,
                            'tcp_semaphore': '0x1286E62C',
                            'tcp_semaphore_status': 'FREE'
                        },
                        'bgp_event_timer': {
                            'starts': {
                                'retrans': 71,
                                'timewait': 0,
                                'ackhold': 66,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 0,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'wakeups': {
                                'retrans': 0,
                                'timewait': 0,
                                'ackhold': 64,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 0,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'next': {
                                'retrans': '0x0',
                                'timewait': '0x0',
                                'ackhold': '0x0',
                                'sendwnd': '0x0',
                                'keepalive': '0x0',
                                'giveup': '0x0',
                                'pmtuager': '0x0',
                                'deadwait': '0x0',
                                'linger': '0x0',
                                'processq': '0x0'
                            }
                        }
                    },
                    '2001:DB8:4:6::6': {
                        'remote_as': 300,
                        'link': 'external',
                        'shutdown': False,
                        'address_family': {
                            'vpnv6 unicast': {
                                'session_state': 'Established',
                                'up_time': '01:01:58',
                                'last_read': '00:00:32',
                                'last_write': '00:00:06',
                                'current_time': '0x5315CE'
                            }
                        },
                        'bgp_version': 4,
                        'router_id': '10.4.6.6',
                        'session_state': 'Established',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 180,
                            'keepalive_interval': 60
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised',
                            'four_octets_asn': 'advertised',
                            'ipv6_unicast': 'advertised and received',
                            'enhanced_refresh': 'advertised',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 3,
                                    'keepalives': 70,
                                    'route_refresh': 0,
                                    'total': 74
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 1,
                                    'keepalives': 64,
                                    'route_refresh': 0,
                                    'total': 66
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '2001:DB8:4:6::6',
                            'connection': {
                                'established': 2,
                                'dropped': 1,
                                'last_reset': '01:05:12',
                                'reset_reason': 'Active open failed'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'disabled',
                            'connection_state': 'estab',
                            'io_status': 1,
                            'unread_input_bytes': 0,
                            'ecn_connection': 'disabled',
                            'minimum_incoming_ttl': 0,
                            'outgoing_ttl': 1,
                            'transport': {
                                'local_host': '2001:DB8:4:6::4',
                                'local_port': '179',
                                'foreign_host': '2001:DB8:4:6::6',
                                'foreign_port': '11003',
                                'mss': 1440
                            },
                            'connection_tableid': 503316481,
                            'maximum_output_segment_queue_size': 50,
                            'enqueued_packets': {
                                'retransmit_packet': 0,
                                'input_packet': 0,
                                'mis_ordered_packet': 0
                            },
                            'iss': 164676617,
                            'snduna': 164678296,
                            'sndnxt': 164678296,
                            'irs': 1797203329,
                            'rcvnxt': 1797204710,
                            'sndwnd': 32000,
                            'snd_scale': 0,
                            'maxrcvwnd': 16384,
                            'rcvwnd': 15004,
                            'rcv_scale': 0,
                            'delrcvwnd': 1380,
                            'srtt': 1000,
                            'rtto': 1003,
                            'rtv': 3,
                            'krtt': 0,
                            'min_rtt': 1,
                            'max_rtt': 1000,
                            'ack_hold': 200,
                            'uptime': 3718683,
                            'sent_idletime': 6954,
                            'receive_idletime': 6849,
                            'status_flags': 'passive open, gen tcbs',
                            'option_flags': 'VRF id set, nagle, path mtu capable',
                            'ip_precedence_value': 6,
                            'datagram': {
                                'datagram_received': {
                                    'value': 138,
                                    'out_of_order': 0,
                                    'with_data': 66,
                                    'total_data': 1380
                                },
                                'datagram_sent': {
                                    'value': 139,
                                    'retransmit': 0,
                                    'fastretransmit': 0,
                                    'partialack': 0,
                                    'second_congestion': 0,
                                    'with_data': 139,
                                    'total_data': 7246
                                }
                            },
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'fast_lock_acquisition_failures': 0,
                            'lock_slow_path': 0,
                            'tcp_semaphore': '0x1286E9AC',
                            'tcp_semaphore_status': 'FREE'
                        },
                        'bgp_event_timer': {
                            'starts': {
                                'retrans': 72,
                                'timewait': 0,
                                'ackhold': 66,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 0,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'wakeups': {
                                'retrans': 0,
                                'timewait': 0,
                                'ackhold': 64,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 0,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'next': {
                                'retrans': '0x0',
                                'timewait': '0x0',
                                'ackhold': '0x0',
                                'sendwnd': '0x0',
                                'keepalive': '0x0',
                                'giveup': '0x0',
                                'pmtuager': '0x0',
                                'deadwait': '0x0',
                                'linger': '0x0',
                                'processq': '0x0'
                            }
                        }
                    }
                }
            },
            'VRF2': {
                'neighbor': {
                    '10.66.6.6': {
                        'remote_as': 400,
                        'link': 'external',
                        'shutdown': False,
                        'address_family': {
                            'vpnv4 unicast': {
                                'session_state': 'Established',
                                'up_time': '01:01:51',
                                'last_read': '00:00:24',
                                'last_write': '00:00:21',
                                'current_time': '0x530C0D'
                            },
                            'vpnv6 unicast': {}
                        },
                        'bgp_version': 4,
                        'router_id': '10.66.6.6',
                        'session_state': 'Established',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 180,
                            'keepalive_interval': 60
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised',
                            'four_octets_asn': 'advertised',
                            'ipv4_unicast': 'advertised and received',
                            'enhanced_refresh': 'advertised',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 1,
                                    'keepalives': 69,
                                    'route_refresh': 0,
                                    'total': 71
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 1,
                                    'keepalives': 64,
                                    'route_refresh': 0,
                                    'total': 66
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '10.66.6.6',
                            'connection': {
                                'established': 2,
                                'dropped': 1,
                                'last_reset': '01:05:09',
                                'reset_reason': 'Active open failed'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'disabled',
                            'connection_state': 'estab',
                            'io_status': 1,
                            'unread_input_bytes': 0,
                            'ecn_connection': 'disabled',
                            'minimum_incoming_ttl': 0,
                            'outgoing_ttl': 1,
                            'transport': {
                                'local_host': '10.66.6.4',
                                'local_port': '179',
                                'foreign_host': '10.66.6.6',
                                'foreign_port': '11003',
                                'mss': 1460
                            },
                            'connection_tableid': 2,
                            'maximum_output_segment_queue_size': 50,
                            'enqueued_packets': {
                                'retransmit_packet': 0,
                                'input_packet': 0,
                                'mis_ordered_packet': 0
                            },
                            'iss': 2048397580,
                            'snduna': 2048398972,
                            'sndnxt': 2048398972,
                            'irs': 213294715,
                            'rcvnxt': 213296046,
                            'sndwnd': 32000,
                            'snd_scale': 0,
                            'maxrcvwnd': 16384,
                            'rcvwnd': 15054,
                            'rcv_scale': 0,
                            'delrcvwnd': 1330,
                            'srtt': 1000,
                            'rtto': 1003,
                            'rtv': 3,
                            'krtt': 0,
                            'min_rtt': 2,
                            'max_rtt': 1000,
                            'ack_hold': 200,
                            'uptime': 3712326,
                            'sent_idletime': 21866,
                            'receive_idletime': 21765,
                            'status_flags': 'passive open, gen tcbs',
                            'option_flags': 'VRF id set, nagle, path mtu capable',
                            'ip_precedence_value': 6,
                            'datagram': {
                                'datagram_received': {
                                    'value': 135,
                                    'out_of_order': 0,
                                    'with_data': 66,
                                    'total_data': 1330
                                },
                                'datagram_sent': {
                                    'value': 137,
                                    'retransmit': 0,
                                    'fastretransmit': 0,
                                    'partialack': 0,
                                    'second_congestion': 0,
                                    'with_data': 71,
                                    'total_data': 1391
                                }
                            },
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'fast_lock_acquisition_failures': 0,
                            'lock_slow_path': 0,
                            'tcp_semaphore': '0x1286E8CC',
                            'tcp_semaphore_status': 'FREE'
                        },
                        'bgp_event_timer': {
                            'starts': {
                                'retrans': 70,
                                'timewait': 0,
                                'ackhold': 66,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 0,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'wakeups': {
                                'retrans': 0,
                                'timewait': 0,
                                'ackhold': 64,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 0,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'next': {
                                'retrans': '0x0',
                                'timewait': '0x0',
                                'ackhold': '0x0',
                                'sendwnd': '0x0',
                                'keepalive': '0x0',
                                'giveup': '0x0',
                                'pmtuager': '0x0',
                                'deadwait': '0x0',
                                'linger': '0x0',
                                'processq': '0x0'
                            }
                        }
                    },
                    '2001:DB8:20:4:6::6': {
                        'remote_as': 400,
                        'link': 'external',
                        'shutdown': False,
                        'address_family': {
                            'vpnv6 unicast': {
                                'session_state': 'Idle',
                                'last_read': '00:00:22',
                                'last_write': '00:00:01',
                                'current_time': '0x5319B5'
                            },
                            'ipv4 multicast': {},
                            'l2vpn evpn': {},
                            'vpnv4 multicast': {},
                            'mvpnv4 unicast': {},
                            'mvpnv6 unicast': {},
                            'vpnv6 multicast': {}
                        },
                        'bgp_version': 4,
                        'router_id': '10.66.6.6',
                        'session_state': 'Idle',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 180,
                            'keepalive_interval': 60
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1,
                            },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised',
                            'four_octets_asn': 'advertised',
                            'ipv6_unicast': 'advertised and received',
                            'enhanced_refresh': 'advertised',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 1,
                                    'keepalives': 70,
                                    'route_refresh': 0,
                                    'total': 72
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 1,
                                    'keepalives': 64,
                                    'route_refresh': 0,
                                    'total': 66
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '2001:DB8:20:4:6::6',
                            'connection': {
                                'established': 2,
                                'dropped': 1,
                                'last_reset': '01:05:13',
                                'reset_reason': 'Active open failed'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'disabled',
                            'connection_state': 'estab',
                            'io_status': 1,
                            'unread_input_bytes': 0,
                            'ecn_connection': 'disabled',
                            'minimum_incoming_ttl': 0,
                            'outgoing_ttl': 1,
                            'transport': {
                                'local_host': '2001:DB8:20:4:6::4',
                                'local_port': '179',
                                'foreign_host': '2001:DB8:20:4:6::6',
                                'foreign_port': '11003',
                                'mss': 1440
                            },
                            'connection_tableid': 503316482,
                            'maximum_output_segment_queue_size': 50,
                            'enqueued_packets': {
                                'retransmit_packet': 0,
                                'input_packet': 0,
                                'mis_ordered_packet': 0
                            },
                            'iss': 3178074389,
                            'snduna': 3178075806,
                            'sndnxt': 3178075806,
                            'irs': 693674496,
                            'rcvnxt': 693675877,
                            'sndwnd': 32000,
                            'snd_scale': 0,
                            'maxrcvwnd': 16384,
                            'rcvwnd': 15004,
                            'rcv_scale': 0,
                            'delrcvwnd': 1380,
                            'srtt': 1000,
                            'rtto': 1003,
                            'rtv': 3,
                            'krtt': 0,
                            'min_rtt': 3,
                            'max_rtt': 1000,
                            'ack_hold': 200,
                            'uptime': 3711535,
                            'sent_idletime': 2335,
                            'receive_idletime': 2277,
                            'status_flags': 'passive open, gen tcbs',
                            'option_flags': 'VRF id set, nagle, path mtu capable',
                            'ip_precedence_value': 6,
                            'datagram': {
                                'datagram_received': {
                                    'value': 137,
                                    'out_of_order': 0,
                                    'with_data': 66,
                                    'total_data': 1380
                                },
                                'datagram_sent': {
                                    'value': 138,
                                    'retransmit': 0,
                                    'fastretransmit': 0,
                                    'partialack': 0,
                                    'second_congestion': 0,
                                    'with_data': 138,
                                    'total_data': 6944
                                }
                            },
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'fast_lock_acquisition_failures': 0,
                            'lock_slow_path': 0,
                            'tcp_semaphore': '0x1286E93C',
                            'tcp_semaphore_status': 'FREE'
                        },
                        'bgp_event_timer': {
                            'starts': {
                                'retrans': 71,
                                'timewait': 0,
                                'ackhold': 66,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 0,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'wakeups': {
                                'retrans': 0,
                                'timewait': 0,
                                'ackhold': 64,
                                'sendwnd': 0,
                                'keepalive': 0,
                                'giveup': 0,
                                'pmtuager': 0,
                                'deadwait': 0,
                                'linger': 0,
                                'processq': 0
                            },
                            'next': {
                                'retrans': '0x0',
                                'timewait': '0x0',
                                'ackhold': '0x0',
                                'sendwnd': '0x0',
                                'keepalive': '0x0',
                                'giveup': '0x0',
                                'pmtuager': '0x0',
                                'deadwait': '0x0',
                                'linger': '0x0',
                                'processq': '0x0'
                            }
                        }
                    }
                }
            }
        }
    }

    golden_output4 = {'execute.return_value': '''
        router# show bgp all neighbors

        For address family: IPv4 Unicast

        For address family: IPv6 Unicast

        For address family: VPNv4 Unicast
        BGP neighbor is 10.16.2.2,  remote AS 100, internal link
          BGP version 4, remote router ID 10.16.2.2
          BGP state = Established, up for 01:10:35
          Last read 00:00:04, last write 00:00:09, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family VPNv6 Unicast: advertised and received
            Graceful Restart Capability: received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, VPNv6 Unicast (was not preserved
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               11          6
            Keepalives:            75         74
            Route Refresh:          0          0
            Total:                 87         81
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.16.2.2
          Connections established 1; dropped 0
          Last reset never
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.64.4.4, Local port: 35281
        Foreign host: 10.16.2.2, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530449):
        Timer          Starts    Wakeups            Next
        Retrans            86          0             0x0
        TimeWait            0          0             0x0
        AckHold            80         72             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:   55023811  snduna:   55027115  sndnxt:   55027115
        irs:  109992783  rcvnxt:  109995158

        sndwnd:  16616  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16327  scale:      0  delrcvwnd:     57

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 4 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 4236258 ms, Sent idletime: 4349 ms, Receive idletime: 4549 ms
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 536 bytes):
        Rcvd: 164 (out of order: 0), with data: 80, total data bytes: 2374
        Sent: 166 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 87, total data bytes: 3303

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E7EC  FREE

        BGP neighbor is 10.36.3.3,  remote AS 100, internal link
          BGP version 4, remote router ID 10.36.3.3
          BGP state = Established, up for 01:10:41
          Last read 00:00:04, last write 00:00:43, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family VPNv6 Unicast: advertised and received
            Graceful Restart Capability: received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, VPNv6 Unicast (was not preserved
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               11          6
            Keepalives:            75         74
            Route Refresh:          0          0
            Total:                 87         81
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.36.3.3
          Connections established 1; dropped 0
          Last reset never
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.64.4.4, Local port: 56031
        Foreign host: 10.36.3.3, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530638):
        Timer          Starts    Wakeups            Next
        Retrans            86          0             0x0
        TimeWait            0          0             0x0
        AckHold            80         73             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 2116369173  snduna: 2116372477  sndnxt: 2116372477
        irs: 4033842748  rcvnxt: 4033845123

        sndwnd:  16616  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16327  scale:      0  delrcvwnd:     57

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 3 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 4243393 ms, Sent idletime: 5375 ms, Receive idletime: 5575 ms
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 536 bytes):
        Rcvd: 165 (out of order: 0), with data: 80, total data bytes: 2374
        Sent: 167 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 87, total data bytes: 3303

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E85C  FREE

        BGP neighbor is 10.4.6.6,  vrf VRF1,  remote AS 300, external link
          Administratively shut down
          BGP version 4, remote router ID 10.4.6.6
          BGP state = Established, up for 01:01:59
          Last read 00:00:33, last write 00:00:30, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised
            Four-octets ASN Capability: advertised
            Address family IPv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                3          1
            Keepalives:            69         64
            Route Refresh:          0          0
            Total:                 73         66
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.4.6.6
          Connections established 2; dropped 1
          Last reset 01:02:11, due to Peer closed the session of session 1
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 10.4.6.4, Local port: 179
        Foreign host: 10.4.6.6, Foreign port: 11010
        Connection tableid (VRF): 1
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530A19):
        Timer          Starts    Wakeups            Next
        Retrans            71          0             0x0
        TimeWait            0          0             0x0
        AckHold            66         64             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:     271842  snduna:     273380  sndnxt:     273380
        irs:  930048172  rcvnxt:  930049503

        sndwnd:  32000  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15054  scale:      0  delrcvwnd:   1330

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3720132 ms, Sent idletime: 31107 ms, Receive idletime: 30999 ms
        Status Flags: passive open, gen tcbs
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1460 bytes):
        Rcvd: 137 (out of order: 0), with data: 66, total data bytes: 1330
        Sent: 138 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 72, total data bytes: 1537

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E62C  FREE

        BGP neighbor is 10.66.6.6,  vrf VRF2,  remote AS 400, external link
          BGP version 4, remote router ID 10.66.6.6
          BGP state = Established, up for 01:01:51
          Last read 00:00:24, last write 00:00:21, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised
            Four-octets ASN Capability: advertised
            Address family IPv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                1          1
            Keepalives:            69         64
            Route Refresh:          0          0
            Total:                 71         66
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.66.6.6
          Connections established 2; dropped 1
          Last reset 01:05:09, due to Active open failed
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 10.66.6.4, Local port: 179
        Foreign host: 10.66.6.6, Foreign port: 11003
        Connection tableid (VRF): 2
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530C0D):
        Timer          Starts    Wakeups            Next
        Retrans            70          0             0x0
        TimeWait            0          0             0x0
        AckHold            66         64             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 2048397580  snduna: 2048398972  sndnxt: 2048398972
        irs:  213294715  rcvnxt:  213296046

        sndwnd:  32000  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15054  scale:      0  delrcvwnd:   1330

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 2 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3712326 ms, Sent idletime: 21866 ms, Receive idletime: 21765 ms
        Status Flags: passive open, gen tcbs
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1460 bytes):
        Rcvd: 135 (out of order: 0), with data: 66, total data bytes: 1330
        Sent: 137 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 71, total data bytes: 1391

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E8CC  FREE


        For address family: VPNv6 Unicast
        BGP neighbor is 10.64.4.4,  remote AS 100, internal link
          Description: router2222222
          BGP version 4, remote router ID 10.64.4.4
          BGP state = Established, up for 01:10:38
          Last read 00:00:07, last write 00:00:12, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family VPNv6 Unicast: advertised and received
            Graceful Restart Capability: received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, VPNv6 Unicast (was not preserved
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               11          6
            Keepalives:            75         74
            Route Refresh:          0          0
            Total:                 87         81
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.16.2.2
          Connections established 1; dropped 0
          Last reset never
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.64.4.4, Local port: 35281
        Foreign host: 10.16.2.2, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x530FF5):
        Timer          Starts    Wakeups            Next
        Retrans            86          0             0x0
        TimeWait            0          0             0x0
        AckHold            80         72             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:   55023811  snduna:   55027115  sndnxt:   55027115
        irs:  109992783  rcvnxt:  109995158

        sndwnd:  16616  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16327  scale:      0  delrcvwnd:     57

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 4 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 4239741 ms, Sent idletime: 7832 ms, Receive idletime: 8032 ms
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 536 bytes):
        Rcvd: 164 (out of order: 0), with data: 80, total data bytes: 2374
        Sent: 166 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 87, total data bytes: 3303

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E7EC  FREE

        BGP neighbor is 10.100.5.5,  remote AS 100, internal link
          BGP version 4, remote router ID 10.100.5.5
          BGP state = Established, up for 01:10:44
          Last read 00:00:08, last write 00:00:47, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Address family VPNv6 Unicast: advertised and received
            Graceful Restart Capability: received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, VPNv6 Unicast (was not preserved
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               11          6
            Keepalives:            75         74
            Route Refresh:          0          0
            Total:                 87         81
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 10.36.3.3
          Connections established 1; dropped 0
          Last reset never
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.64.4.4, Local port: 56031
        Foreign host: 10.36.3.3, Foreign port: 179
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x5313D8):
        Timer          Starts    Wakeups            Next
        Retrans            86          0             0x0
        TimeWait            0          0             0x0
        AckHold            80         73             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          1             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 2116369173  snduna: 2116372477  sndnxt: 2116372477
        irs: 4033842748  rcvnxt: 4033845123

        sndwnd:  16616  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16327  scale:      0  delrcvwnd:     57

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 3 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 4246385 ms, Sent idletime: 8367 ms, Receive idletime: 8567 ms
        Status Flags: active open
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 536 bytes):
        Rcvd: 165 (out of order: 0), with data: 80, total data bytes: 2374
        Sent: 167 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 87, total data bytes: 3303

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E85C  FREE

        BGP neighbor is 2001:DB8:4:6::6,  vrf VRF1,  remote AS 300, external link
          BGP version 4, remote router ID 10.4.6.6
          BGP state = Established, up for 01:01:58
          Last read 00:00:32, last write 00:00:06, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised
            Four-octets ASN Capability: advertised
            Address family IPv6 Unicast: advertised and received
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                3          1
            Keepalives:            70         64
            Route Refresh:          0          0
            Total:                 74         66
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 2001:DB8:4:6::6
          Connections established 2; dropped 1
          Last reset 01:05:12, due to Active open failed
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 2001:DB8:4:6::4, Local port: 179
        Foreign host: 2001:DB8:4:6::6, Foreign port: 11003
        Connection tableid (VRF): 503316481
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x5315CE):
        Timer          Starts    Wakeups            Next
        Retrans            72          0             0x0
        TimeWait            0          0             0x0
        AckHold            66         64             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:  164676617  snduna:  164678296  sndnxt:  164678296
        irs: 1797203329  rcvnxt: 1797204710

        sndwnd:  32000  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15004  scale:      0  delrcvwnd:   1380

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3718683 ms, Sent idletime: 6954 ms, Receive idletime: 6849 ms
        Status Flags: passive open, gen tcbs
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1440 bytes):
        Rcvd: 138 (out of order: 0), with data: 66, total data bytes: 1380
        Sent: 139 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 139, total data bytes: 7246

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E9AC  FREE

        BGP neighbor is 2001:DB8:20:4:6::6,  vrf VRF2,  remote AS 400, external link
          BGP version 4, remote router ID 10.66.6.6
          BGP state = Idle
          Last read 00:00:22, last write 00:00:01, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised
            Four-octets ASN Capability: advertised
            Address family IPv6 Unicast: advertised and received
            Enhanced Refresh Capability: advertised
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                1          1
            Keepalives:            70         64
            Route Refresh:          0          0
            Total:                 72         66
          Default minimum time between advertisement runs is 0 seconds

          Address tracking is enabled, the RIB does have a route to 2001:DB8:20:4:6::6
          Connections established 2; dropped 1
          Last reset 01:05:13, due to Active open failed
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 2001:DB8:20:4:6::4, Local port: 179
        Foreign host: 2001:DB8:20:4:6::6, Foreign port: 11003
        Connection tableid (VRF): 503316482
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x5319B5):
        Timer          Starts    Wakeups            Next
        Retrans            71          0             0x0
        TimeWait            0          0             0x0
        AckHold            66         64             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 3178074389  snduna: 3178075806  sndnxt: 3178075806
        irs:  693674496  rcvnxt:  693675877

        sndwnd:  32000  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15004  scale:      0  delrcvwnd:   1380

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 3 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3711535 ms, Sent idletime: 2335 ms, Receive idletime: 2277 ms
        Status Flags: passive open, gen tcbs
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1440 bytes):
        Rcvd: 137 (out of order: 0), with data: 66, total data bytes: 1380
        Sent: 138 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 138, total data bytes: 6944

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x1286E93C  FREE


        For address family: IPv4 Multicast

        For address family: L2VPN E-VPN

        For address family: VPNv4 Multicast

        For address family: MVPNv4 Unicast

        For address family: MVPNv6 Unicast

        For address family: VPNv6 Multicast
        '''}
        
    def test_show_bgp_all_neighbors_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowBgpAllNeighbors(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_bgp_all_neighbors_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowBgpAllNeighbors(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_bgp_all_neighbors_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowBgpAllNeighbors(device=self.device)
        parsed_output = obj.parse(address_family='l2vpn vpls', neighbor='192.168.165.120')
        self.assertEqual(parsed_output, self.golden_parsed_output2)

    def test_show_bgp_all_neighbors_golden3(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output3)
        obj = ShowBgpAllNeighbors(device=self.device)
        parsed_output = obj.parse(address_family='l2vpn vpls', neighbor='192.168.165.119')
        self.assertEqual(parsed_output, self.golden_parsed_output3)

    def test_show_bgp_all_neighbors_golden4(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output4)
        obj = ShowBgpAllNeighbors(device=self.device)
        parsed_output = obj.parse()
        self.assertEqual(parsed_output, self.golden_parsed_output4)



# =================================================================
# Unit test for:
#   * 'show bgp {address_family} neighbors'
#   * 'show bgp {address_family}' vrf {vrf} neighbors {neighbor}'
# =================================================================
class test_show_bgp_neighbors(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'list_of_neighbors': ['10.1.1.1', '10.2.2.2'],
        'vrf': 
            {'default': 
                {'neighbor': 
                    {'10.1.1.1': 
                        {'address_family': 
                            {'ipv4 unicast': 
                                {'advertise_bit': 0,
                                'bgp_table_version': 1,
                                'dynamic_slow_peer_recovered': 'never',
                                'index': 1,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': 'never',
                                'last_received_refresh_start_of_rib': 'never',
                                'last_sent_refresh_end_of_rib': 'never',
                                'last_sent_refresh_start_of_rib': 'never',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'total': 0},
                                    'outbound': 
                                        {'total': 0}},
                                'max_nlri': 0,
                                'min_nlri': 0,
                                'neighbor_version': '1/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0,
                                        'used_as_secondary': 0},
                                    'sent': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                        'used_as_secondary': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0},
                                    'sent': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0}},
                                'refresh_epoch': 1,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'update_group_member': 1},
                            'vpnv4 unicast': 
                                {'advertise_bit': 1,
                                'bgp_table_version': 21,
                                'current_time': '0x13F885E6',
                                'dynamic_slow_peer_recovered': 'never',
                                'extended_community_attribute_sent': True,
                                'index': 3,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': 'never',
                                'last_received_refresh_start_of_rib': 'never',
                                'last_sent_refresh_end_of_rib': 'never',
                                'last_sent_refresh_start_of_rib': 'never',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'af_permit_check': 'n/a',
                                        'bestpath_from_ibgp_peer': 'n/a',
                                        'bestpath_from_this_peer': 'n/a',
                                        'originator_loop': 8,
                                        'total': 8},
                                    'outbound': 
                                        {'af_permit_check': 4,
                                        'bestpath_from_ibgp_peer': 4,
                                        'bestpath_from_this_peer': 4,
                                        'originator_loop': 'n/a',
                                        'total': 12}},
                                'max_nlri': 1,
                                'min_nlri': 0,
                                'neighbor_version': '21/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_total': 4,
                                        'used_as_bestpath': 4,
                                        'used_as_multipath': 0,
                                        'used_as_secondary': 0},
                                    'sent': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 4,
                                        'prefixes_total': 8,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                        'used_as_secondary': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0},
                                    'sent': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0}},
                                'refresh_epoch': 1,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'update_group_member': 3}},
                        'bgp_event_timer': 
                            {'next': 
                                {'ackhold': '0x0',
                                'deadwait': '0x0',
                                'giveup': '0x0',
                                'keepalive': '0x0',
                                'linger': '0x0',
                                'pmtuager': '0x0',
                                'processq': '0x0',
                                'retrans': '0x0',
                                'sendwnd': '0x0',
                                'timewait': '0x0'},
                            'starts': 
                                {'ackhold': 6150,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 6150,
                                'sendwnd': 0,
                                'timewait': 0},
                            'wakeups': 
                                {'ackhold': 6008,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 0,
                                'sendwnd': 0,
                                'timewait': 0}},
                                'bgp_neighbor_session': {
                            'sessions': 0,
                            'stateful_switchover': 'NO',
                            },
                            'bgp_neighbor_session': {
                    'sessions': 1,
                    },
                        'bgp_negotiated_capabilities': 
                            {'enhanced_refresh': 'advertised '
                                                 'and '
                                                 'received',
                            'four_octets_asn': 'advertised '
                                               'and '
                                               'received',
                            'ipv4_unicast': 'advertised '
                                            'and '
                                            'received',
                            'route_refresh': 'advertised '
                                             'and '
                                             'received(new)',
                            'stateful_switchover': 'NO '
                                                   'for '
                                                   'session '
                                                   '1',
                            'vpnv4_unicast': 'advertised '
                                             'and '
                                             'received'},
                        'bgp_negotiated_keepalive_timers': 
                            {'hold_time': 180,
                            'keepalive_interval': 60},
                        'bgp_neighbor_counters': 
                            {'messages': 
                                {'in_queue_depth': 0,
                                'out_queue_depth': 0,
                                'received': 
                                    {'keepalives': 6147,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 6162,
                                    'updates': 14},
                                'sent': 
                                    {'keepalives': 6146,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 6157,
                                    'updates': 10}}},
                        'bgp_session_transport': 
                            {'ack_hold': 200,
                            'address_tracking_status': 'enabled',
                            'connection': 
                                {'dropped': 0,
                                'established': 1,
                                'last_reset': 'never'},
                            'connection_state': 'estab',
                            'connection_tableid': 0,
                            'datagram': 
                                {'datagram_received': 
                                    {'out_of_order': 0,
                                    'total_data': 118194,
                                    'value': 12281,
                                    'with_data': 6151},
                                'datagram_sent': 
                                    {'fastretransmit': 0,
                                    'partialack': 0,
                                    'retransmit': 0,
                                    'second_congestion': 0,
                                    'total_data': 117635,
                                    'value': 12246,
                                    'with_data': 6151}},
                            'delrcvwnd': 19,
                            'ecn_connection': 'disabled',
                            'enqueued_packets': 
                                {'input_packet': 0,
                                'mis_ordered_packet': 0,
                                'retransmit_packet': 0},
                            'fast_lock_acquisition_failures': 0,
                            'graceful_restart': 'disabled',
                            'io_status': 1,
                            'ip_precedence_value': 6,
                            'irs': 547332975,
                            'iss': 3484933877,
                            'krtt': 0,
                            'lock_slow_path': 0,
                            'max_rtt': 1000,
                            'maximum_output_segment_queue_size': 50,
                            'maxrcvwnd': 16384,
                            'min_rtt': 1,
                            'min_time_between_advertisement_runs': 0,
                            'minimum_incoming_ttl': 0,
                            'option_flags': 'nagle, '
                                            'path '
                                            'mtu '
                                            'capable',
                            'outgoing_ttl': 255,
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'rcv_scale': 0,
                            'rcvnxt': 547451170,
                            'rcvwnd': 16365,
                            'receive_idletime': 33158,
                            'rib_route_ip': '10.1.1.1',
                            'rtto': 1003,
                            'rtv': 3,
                            'sent_idletime': 33361,
                            'snd_scale': 0,
                            'sndnxt': 3485051513,
                            'snduna': 3485051513,
                            'sndwnd': 15453,
                            'srtt': 1000,
                            'sso': False,
                            'status_flags': 'passive '
                                            'open, '
                                            'gen '
                                            'tcbs',
                            'tcp_path_mtu_discovery': 'enabled',
                            'tcp_semaphore': '0x7F59978AAB40',
                            'tcp_semaphore_status': 'FREE',
                            'transport': 
                                {'foreign_host': '10.1.1.1',
                                'foreign_port': '44730',
                                'local_host': '10.5.5.5',
                                'local_port': '179',
                                'mss': 1396},
                            'unread_input_bytes': 0,
                            'uptime': 334841877},
                        'bgp_version': 4,
                        'link': 'internal',
                        'remote_as': 65000,
                        'router_id': '10.1.1.1',
                        'session_state': 'Established',
                        'shutdown': False},
                    '10.2.2.2': 
                        {'address_family': 
                            {'ipv4 unicast': 
                                {'advertise_bit': 0,
                                'bgp_table_version': 1,
                                'dynamic_slow_peer_recovered': 'never',
                                'index': 1,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': 'never',
                                'last_received_refresh_start_of_rib': 'never',
                                'last_sent_refresh_end_of_rib': 'never',
                                'last_sent_refresh_start_of_rib': 'never',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'total': 0},
                                    'outbound': 
                                        {'total': 0}},
                                'max_nlri': 0,
                                'min_nlri': 0,
                                'neighbor_version': '1/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0,
                                        'used_as_secondary': 0},
                                    'sent': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                        'used_as_secondary': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0},
                                    'sent': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0}},
                                'refresh_epoch': 1,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'update_group_member': 1},
                            'vpnv4 unicast': 
                                {'advertise_bit': 1,
                                'bgp_table_version': 21,
                                'current_time': '0x13F886BA',
                                'dynamic_slow_peer_recovered': 'never',
                                'extended_community_attribute_sent': True,
                                'index': 3,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_read': '00:00:04',
                                'last_received_refresh_end_of_rib': 'never',
                                'last_received_refresh_start_of_rib': 'never',
                                'last_sent_refresh_end_of_rib': 'never',
                                'last_sent_refresh_start_of_rib': 'never',
                                'last_write': '00:00:28',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'af_permit_check': 'n/a',
                                        'bestpath_from_ibgp_peer': 'n/a',
                                        'bestpath_from_this_peer': 'n/a',
                                        'originator_loop': 8,
                                        'total': 8},
                                    'outbound': 
                                        {'af_permit_check': 4,
                                        'bestpath_from_ibgp_peer': 4,
                                        'bestpath_from_this_peer': 4,
                                        'originator_loop': 'n/a',
                                        'total': 12}},
                                'max_nlri': 1,
                                'min_nlri': 0,
                                'neighbor_version': '21/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_total': 4,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0,
                                        'used_as_secondary': 0},
                                    'sent': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 4,
                                        'prefixes_total': 8,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                        'used_as_secondary': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0},
                                    'sent': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0}},
                                'refresh_epoch': 1,
                                'session_state': 'Established',
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'up_time': '3d21h',
                                'update_group_member': 3}},
                        'bgp_event_timer': 
                            {'next': 
                                {'ackhold': '0x0',
                                'deadwait': '0x0',
                                'giveup': '0x0',
                                'keepalive': '0x0',
                                'linger': '0x0',
                                'pmtuager': '0x0',
                                'processq': '0x0',
                                'retrans': '0x0',
                                'sendwnd': '0x0',
                                'timewait': '0x0'},
                            'starts': 
                                {'ackhold': 6142,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 6139,
                                'sendwnd': 0,
                                'timewait': 0},
                            'wakeups': 
                                {'ackhold': 6023,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'pmtuager': 0,
                                'processq': 0,
                                'retrans': 0,
                                'sendwnd': 0,
                                'timewait': 0}},
                                'bgp_neighbor_session': {
                    'sessions': 1,
                    },
                        'bgp_negotiated_capabilities': 
                            {'enhanced_refresh': 'advertised '
                                                 'and '
                                                 'received',
                            'four_octets_asn': 'advertised '
                                               'and '
                                               'received',
                            'ipv4_unicast': 'advertised '
                                            'and '
                                            'received',
                            'route_refresh': 'advertised '
                                             'and '
                                             'received(new)',
                            'stateful_switchover': 'NO '
                                                   'for '
                                                   'session '
                                                   '1',
                            'vpnv4_unicast': 'advertised '
                                             'and '
                                             'received'},
                        'bgp_negotiated_keepalive_timers': 
                            {'hold_time': 180,
                            'keepalive_interval': 60},
                        'bgp_neighbor_counters': 
                            {'messages': 
                                {'in_queue_depth': 0,
                                'out_queue_depth': 0,
                                'received': 
                                    {'keepalives': 6139,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 6154,
                                    'updates': 14},
                                'sent': 
                                    {'keepalives': 6134,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 6145,
                                    'updates': 10}}},
                        'bgp_session_transport': 
                            {'ack_hold': 200,
                            'address_tracking_status': 'enabled',
                            'connection': 
                                {'dropped': 0,
                                'established': 1,
                                'last_reset': 'never'},
                            'connection_state': 'estab',
                            'connection_tableid': 0,
                            'datagram': 
                                {'datagram_received': 
                                    {'out_of_order': 0,
                                    'total_data': 118042,
                                    'value': 12256,
                                    'with_data': 6143},
                                'datagram_sent': 
                                    {'fastretransmit': 0,
                                    'partialack': 0,
                                    'retransmit': 0,
                                    'second_congestion': 0,
                                    'total_data': 117407,
                                    'value': 12248,
                                    'with_data': 6139}},
                            'delrcvwnd': 1273,
                            'ecn_connection': 'disabled',
                            'enqueued_packets': 
                                {'input_packet': 0,
                                'mis_ordered_packet': 0,
                                'retransmit_packet': 0},
                            'fast_lock_acquisition_failures': 0,
                            'graceful_restart': 'disabled',
                            'io_status': 1,
                            'ip_precedence_value': 6,
                            'irs': 2814267610,
                            'iss': 84959429,
                            'krtt': 0,
                            'lock_slow_path': 0,
                            'max_rtt': 1000,
                            'maximum_output_segment_queue_size': 50,
                            'maxrcvwnd': 16384,
                            'min_rtt': 1,
                            'min_time_between_advertisement_runs': 0,
                            'minimum_incoming_ttl': 0,
                            'option_flags': 'nagle, '
                                            'path '
                                            'mtu '
                                            'capable',
                            'outgoing_ttl': 255,
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'rcv_scale': 0,
                            'rcvnxt': 2814385653,
                            'rcvwnd': 15111,
                            'receive_idletime': 4619,
                            'rib_route_ip': '10.2.2.2',
                            'rtto': 1003,
                            'rtv': 3,
                            'sent_idletime': 4419,
                            'snd_scale': 0,
                            'sndnxt': 85076837,
                            'snduna': 85076837,
                            'sndwnd': 15681,
                            'srtt': 1000,
                            'sso': False,
                            'status_flags': 'passive '
                                            'open, '
                                            'gen '
                                            'tcbs',
                            'tcp_path_mtu_discovery': 'enabled',
                            'tcp_semaphore': '0x7F59978AAC10',
                            'tcp_semaphore_status': 'FREE',
                            'transport': 
                                {'foreign_host': '10.2.2.2',
                                'foreign_port': '43047',
                                'local_host': '10.5.5.5',
                                'local_port': '179',
                                'mss': 1396},
                            'unread_input_bytes': 0,
                            'uptime': 334847216},
                        'bgp_version': 4,
                        'link': 'internal',
                        'remote_as': 65000,
                        'router_id': '10.2.2.2',
                        'session_state': 'Established',
                        'shutdown': False}}}}}

    golden_output1 = {'execute.return_value': '''
        show bgp ipv4 unicast neighbors
        BGP neighbor is 10.1.1.1,  remote AS 65000, internal link
          BGP version 4, remote router ID 10.1.1.1
          BGP state = Established, up for 3d21h
          Last read 00:00:46, last write 00:00:33, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family IPv4 Unicast: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised and received
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               10         14
            Keepalives:          6146       6147
            Route Refresh:          0          0
            Total:               6157       6162
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

         For address family: IPv4 Unicast
          Session: 10.1.1.1
          BGP table version 1, neighbor version 1/0
          Output queue size : 0
          Index 1, Advertise bit 0
          1 update-group member
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               0          0
            Prefixes Total:                 0          0
            Implicit Withdraw:              0          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Total:                                0          0
          Number of NLRIs in the update sent: max 0, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

         For address family: VPNv4 Unicast
          Session: 10.1.1.1
          BGP table version 21, neighbor version 21/0
          Output queue size : 0
          Index 3, Advertise bit 1
          3 update-group member
          Extended-community attribute sent to this neighbor
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               4          4 (Consumes 544 bytes)
            Prefixes Total:                 8          4
            Implicit Withdraw:              4          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          4
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            ORIGINATOR loop:                    n/a          8
            Bestpath from this peer:              4        n/a
            Bestpath from iBGP peer:              4        n/a
            AF Permit Check:                      4        n/a
            Total:                               12          8
          Number of NLRIs in the update sent: max 1, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

          Address tracking is enabled, the RIB does have a route to 10.1.1.1
          Route to peer address reachability Up: 2; Down: 1
            Last notification 3d20h
          Connections established 1; dropped 0
          Last reset never
          Interface associated: (none) (peering address NOT in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
          SSO is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.5.5.5, Local port: 179
        Foreign host: 10.1.1.1, Foreign port: 44730
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x13F885E6):
        Timer          Starts    Wakeups            Next
        Retrans          6150          0             0x0
        TimeWait            0          0             0x0
        AckHold          6150       6008             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 3484933877  snduna: 3485051513  sndnxt: 3485051513
        irs:  547332975  rcvnxt:  547451170

        sndwnd:  15453  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16365  scale:      0  delrcvwnd:     19

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 334841877 ms, Sent idletime: 33361 ms, Receive idletime: 33158 ms
        Status Flags: passive open, gen tcbs
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1396 bytes):
        Rcvd: 12281 (out of order: 0), with data: 6151, total data bytes: 118194
        Sent: 12246 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 6151, total data bytes: 117635

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x7F59978AAB40  FREE

        BGP neighbor is 10.2.2.2,  remote AS 65000, internal link
          BGP version 4, remote router ID 10.2.2.2
          BGP state = Established, up for 3d21h
          Last read 00:00:04, last write 00:00:28, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family IPv4 Unicast: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised and received
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               10         14
            Keepalives:          6134       6139
            Route Refresh:          0          0
            Total:               6145       6154
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

         For address family: IPv4 Unicast
          Session: 10.2.2.2
          BGP table version 1, neighbor version 1/0
          Output queue size : 0
          Index 1, Advertise bit 0
          1 update-group member
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               0          0
            Prefixes Total:                 0          0
            Implicit Withdraw:              0          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Total:                                0          0
          Number of NLRIs in the update sent: max 0, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

         For address family: VPNv4 Unicast
          Session: 10.2.2.2
          BGP table version 21, neighbor version 21/0
          Output queue size : 0
          Index 3, Advertise bit 1
          3 update-group member
          Extended-community attribute sent to this neighbor
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               4          4 (Consumes 544 bytes)
            Prefixes Total:                 8          4
            Implicit Withdraw:              4          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            ORIGINATOR loop:                    n/a          8
            Bestpath from this peer:              4        n/a
            Bestpath from iBGP peer:              4        n/a
            AF Permit Check:                      4        n/a
            Total:                               12          8
          Number of NLRIs in the update sent: max 1, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

          Address tracking is enabled, the RIB does have a route to 10.2.2.2
          Route to peer address reachability Up: 2; Down: 1
            Last notification 3d20h
          Connections established 1; dropped 0
          Last reset never
          Interface associated: (none) (peering address NOT in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
          SSO is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.5.5.5, Local port: 179
        Foreign host: 10.2.2.2, Foreign port: 43047
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x13F886BA):
        Timer          Starts    Wakeups            Next
        Retrans          6139          0             0x0
        TimeWait            0          0             0x0
        AckHold          6142       6023             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:   84959429  snduna:   85076837  sndnxt:   85076837
        irs: 2814267610  rcvnxt: 2814385653

        sndwnd:  15681  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15111  scale:      0  delrcvwnd:   1273

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 334847216 ms, Sent idletime: 4419 ms, Receive idletime: 4619 ms
        Status Flags: passive open, gen tcbs
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1396 bytes):
        Rcvd: 12256 (out of order: 0), with data: 6143, total data bytes: 118042
        Sent: 12248 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 6139, total data bytes: 117407

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x7F59978AAC10  FREE

        PE1#
        '''}

    golden_parsed_output2 = {
        'list_of_neighbors': ['172.17.211.2'],
        'vrf': 
            {'VRF200': 
                {'neighbor': 
                    {'172.17.211.2': 
                        {'address_family': 
                            {'vpnv4 unicast': 
                                {'advertise_bit': 0,
                                'bgp_table_version': 21,
                                'current_time': '0x194B93DC',
                                'dynamic_slow_peer_recovered': 'never',
                                'index': 2,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': 'never',
                                'last_received_refresh_start_of_rib': 'never',
                                'last_sent_refresh_end_of_rib': 'never',
                                'last_sent_refresh_start_of_rib': 'never',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'bestpath_from_this_peer': 'n/a',
                                        'total': 0},
                                    'outbound': 
                                        {'bestpath_from_this_peer': 2,
                                        'total': 2}},
                                'max_nlri': 1,
                                'min_nlri': 0,
                                'neighbor_version': '21/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_total': 1,
                                        'used_as_bestpath': 1,
                                        'used_as_multipath': 0,
                                        'used_as_secondary': 0},
                                    'sent': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 3,
                                        'prefixes_total': 6,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                        'used_as_secondary': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0},
                                    'sent': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0}},
                                'refresh_epoch': 1,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'update_group_member': 2}},
                        'bgp_event_timer': 
                            {'next': 
                                {'ackhold': '0x0',
                                'deadwait': '0x0',
                                'giveup': '0x0',
                                'keepalive': '0x0',
                                'linger': '0x0',
                                'processq': '0x0',
                                'retrans': '0x0',
                                'sendwnd': '0x0',
                                'timewait': '0x0'},
                            'starts': 
                                {'ackhold': 7773,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'processq': 0,
                                'retrans': 7787,
                                'sendwnd': 0,
                                'timewait': 0},
                            'wakeups': 
                                {'ackhold': 7659,
                                'deadwait': 0,
                                'giveup': 0,
                                'keepalive': 0,
                                'linger': 0,
                                'processq': 0,
                                'retrans': 1,
                                'sendwnd': 0,
                                'timewait': 0}},
                                'bgp_neighbor_session': {
                    'sessions': 1,
                    },
                        'bgp_negotiated_capabilities': 
                            {'enhanced_refresh': 'advertised '
                                                 'and '
                                                 'received',
                            'four_octets_asn': 'advertised '
                                               'and '
                                               'received',
                            'ipv4_unicast': 'advertised '
                                            'and '
                                            'received',
                            'route_refresh': 'advertised '
                                             'and '
                                             'received(new)',
                            'stateful_switchover': 'NO '
                                                   'for '
                                                   'session '
                                                   '1'},
                        'bgp_negotiated_keepalive_timers': 
                            {'hold_time': 180,
                            'keepalive_interval': 60},
                        'bgp_neighbor_counters': 
                            {'messages': 
                                {'in_queue_depth': 0,
                                'out_queue_depth': 0,
                                'received': 
                                    {'keepalives': 7772,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 7775,
                                    'updates': 2},
                                'sent': 
                                    {'keepalives': 7779,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 7787,
                                    'updates': 7}}},
                        'bgp_session_transport': 
                            {'ack_hold': 200,
                            'address_tracking_status': 'enabled',
                            'connection': 
                                {'dropped': 0,
                                'established': 1,
                                'last_reset': 'never'},
                            'connection_state': 'estab',
                            'connection_tableid': 2,
                            'datagram': 
                                {'datagram_received': 
                                    {'out_of_order': 0,
                                    'total_data': 147802,
                                    'value': 15515,
                                    'with_data': 7774},
                                'datagram_sent': 
                                    {'fastretransmit': 0,
                                    'partialack': 0,
                                    'retransmit': 1,
                                    'second_congestion': 0,
                                    'total_data': 148185,
                                    'value': 15549,
                                    'with_data': 7785}},
                            'delrcvwnd': 38,
                            'ecn_connection': 'disabled',
                            'enqueued_packets': 
                                {'input_packet': 0,
                                'mis_ordered_packet': 0,
                                'retransmit_packet': 0},
                            'fast_lock_acquisition_failures': 0,
                            'graceful_restart': 'disabled',
                            'io_status': 1,
                            'ip_precedence_value': 6,
                            'irs': 950953285,
                            'iss': 3848368441,
                            'krtt': 0,
                            'lock_slow_path': 0,
                            'max_rtt': 1000,
                            'maximum_output_segment_queue_size': 50,
                            'maxrcvwnd': 16384,
                            'min_rtt': 1,
                            'min_time_between_advertisement_runs': 0,
                            'minimum_incoming_ttl': 0,
                            'option_flags': 'VRF '
                                            'id '
                                            'set, '
                                            'nagle, '
                                            'path '
                                            'mtu '
                                            'capable',
                            'outgoing_ttl': 1,
                            'packet_fast_path': 0,
                            'packet_fast_processed': 0,
                            'packet_slow_path': 0,
                            'rcv_scale': 0,
                            'rcvnxt': 951101088,
                            'rcvwnd': 16346,
                            'receive_idletime': 39810,
                            'rib_route_ip': '172.17.211.2',
                            'rtto': 1003,
                            'rtv': 3,
                            'sent_idletime': 39610,
                            'snd_scale': 0,
                            'sndnxt': 3848516627,
                            'snduna': 3848516627,
                            'sndwnd': 15966,
                            'srtt': 1000,
                            'sso': False,
                            'status_flags': 'active '
                                            'open',
                            'tcp_path_mtu_discovery': 'enabled',
                            'tcp_semaphore': '0x7F59978AAE80',
                            'tcp_semaphore_status': 'FREE',
                            'transport': 
                                {'foreign_host': '172.17.211.2',
                                'foreign_port': '179',
                                'local_host': '172.17.211.1',
                                'local_port': '48585',
                                'mss': 1460},
                            'unread_input_bytes': 0,
                            'uptime': 424227580},
                        'bgp_version': 4,
                        'link': 'external',
                        'remote_as': 65001,
                        'router_id': '172.16.1.156',
                        'session_state': 'Established',
                        'shutdown': False}}}}}

    golden_output2 = {'execute.return_value': '''
        show bgp vpnv4 unicast vrf VRF200 neighbors
        BGP neighbor is 172.17.211.2,  vrf VRF200,  remote AS 65001, external link
          BGP version 4, remote router ID 172.16.1.156
          BGP state = Established, up for 4d21h
          Last read 00:00:39, last write 00:00:39, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family IPv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised and received
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:                7          2
            Keepalives:          7779       7772
            Route Refresh:          0          0
            Total:               7787       7775
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

         For address family: VPNv4 Unicast
          Translates address family IPv4 Unicast for VRF VRF200
          Session: 172.17.211.2
          BGP table version 21, neighbor version 21/0
          Output queue size : 0
          Index 2, Advertise bit 0
          2 update-group member
          Overrides the neighbor AS with my AS before sending updates
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               3          1 (Consumes 136 bytes)
            Prefixes Total:                 6          1
            Implicit Withdraw:              3          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          1
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Bestpath from this peer:              2        n/a
            Total:                                2          0
          Number of NLRIs in the update sent: max 1, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

          Address tracking is enabled, the RIB does have a route to 172.17.211.2
          Route to peer address reachability Up: 1; Down: 0
            Last notification 4d21h
          Connections established 1; dropped 0
          Last reset never
          External BGP neighbor configured for connected checks (single-hop no-disable-connected-check)
          Interface associated: GigabitEthernet3.200 (peering address in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
          SSO is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 172.17.211.1, Local port: 48585
        Foreign host: 172.17.211.2, Foreign port: 179
        Connection tableid (VRF): 2
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x194B93DC):
        Timer          Starts    Wakeups            Next
        Retrans          7787          1             0x0
        TimeWait            0          0             0x0
        AckHold          7773       7659             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger       422049     422048      0x194B94AF
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 3848368441  snduna: 3848516627  sndnxt: 3848516627
        irs:  950953285  rcvnxt:  951101088

        sndwnd:  15966  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16346  scale:      0  delrcvwnd:     38

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 424227580 ms, Sent idletime: 39610 ms, Receive idletime: 39810 ms
        Status Flags: active open
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1460 bytes):
        Rcvd: 15515 (out of order: 0), with data: 7774, total data bytes: 147802
        Sent: 15549 (retransmit: 1, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 7785, total data bytes: 148185

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x7F59978AAE80  FREE

        PE1#
        '''}

    def test_show_bgp_neighbors_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowBgpNeighbors(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_bgp_neighbors_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowBgpNeighbors(device=self.device)
        parsed_output = obj.parse(address_family='ipv4 unicast')
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_bgp_neighbors_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowBgpNeighbors(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4 unicast', vrf='VRF200')
        self.assertEqual(parsed_output, self.golden_parsed_output2)


# =============================================
# Unit test for:
#   * 'show ip bgp neighbors {neighbor}'
#   * 'show ip bgp {address_family} neighbors'
# =============================================
class test_show_ip_bgp_neighbors(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'list_of_neighbors': ['192.168.197.254'],
        'vrf': 
            {'default': 
                {'neighbor': 
                    {'192.168.197.254': 
                        {'address_family': 
                            {'ipv4 unicast': 
                                {'advertise_bit': 0,
                                'bgp_table_version': 1,
                                'dynamic_slow_peer_recovered': 'never',
                                'index': 0,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': 'never',
                                'last_received_refresh_start_of_rib': 'never',
                                'last_sent_refresh_end_of_rib': '1w5d',
                                'last_sent_refresh_start_of_rib': '1w5d',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'total': 0},
                                    'outbound': 
                                        {'total': 0}},
                                'max_nlri': 0,
                                'min_nlri': 0,
                                'neighbor_version': '1/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0},
                                    'sent': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 0,
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 0,
                                        'refresh_start_of_rib': 0},
                                    'sent': 
                                        {'refresh_end_of_rib': 1,
                                        'refresh_start_of_rib': 1}},
                                'refresh_epoch': 1,
                                'refresh_out': 0,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False},
                            'l2vpn vpls': 
                                {'advertise_bit': 1,
                                'bgp_table_version': 9431,
                                'community_attribute_sent': True,
                                'dynamic_slow_peer_recovered': 'never',
                                'extended_community_attribute_sent': True,
                                'index': 38,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': '02:01:32',
                                'last_received_refresh_start_of_rib': '02:01:36',
                                'last_sent_refresh_end_of_rib': '02:41:38',
                                'last_sent_refresh_start_of_rib': '02:41:38',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'bestpath_from_this_peer': 'n/a',
                                        'total': 0},
                                    'outbound': 
                                        {'bestpath_from_this_peer': 402,
                                        'total': 402}},
                                'max_nlri': 199,
                                'min_nlri': 0,
                                'neighbor_version': '9431/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 0,
                                        'implicit_withdraw': 402,
                                        'prefixes_total': 603,
                                        'used_as_bestpath': 201,
                                        'used_as_multipath': 0},
                                    'sent': 
                                        {'explicit_withdraw': 307,
                                        'implicit_withdraw': 5646,
                                        'prefixes_total': 6356,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 2,
                                        'refresh_start_of_rib': 2},
                                    'sent': 
                                        {'refresh_end_of_rib': 1,
                                        'refresh_start_of_rib': 1}},
                                'refresh_epoch': 3,
                                'refresh_in': 4,
                                'refresh_out': 0,
                                'route_reflector_client': True,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'suppress_ldp_signaling': True,
                                'update_group_member': 38},
                            'vpnv4 unicast': 
                                {'advertise_bit': 2,
                                'bgp_table_version': 29454374,
                                'dynamic_slow_peer_recovered': 'never',
                                'extended_community_attribute_sent': True,
                                'index': 44,
                                'last_detected_dynamic_slow_peer': 'never',
                                'last_received_refresh_end_of_rib': '02:01:32',
                                'last_received_refresh_start_of_rib': '02:01:36',
                                'last_sent_refresh_end_of_rib': '02:41:11',
                                'last_sent_refresh_start_of_rib': '02:41:38',
                                'local_policy_denied_prefixes_counters': 
                                    {'inbound': 
                                        {'bestpath_from_this_peer': 'n/a',
                                        'total': 0},
                                    'outbound': 
                                        {'bestpath_from_this_peer': 3100,
                                        'total': 3100}},
                                'max_nlri': 270,
                                'min_nlri': 0,
                                'neighbor_version': '29454374/0',
                                'output_queue_size': 0,
                                'prefix_activity_counters': 
                                    {'received': 
                                        {'explicit_withdraw': 206,
                                        'implicit_withdraw': 40708,
                                        'prefixes_total': 61115,
                                        'used_as_bestpath': 20201,
                                        'used_as_multipath': 0},
                                    'sent': 
                                        {'explicit_withdraw': 1131817,
                                        'implicit_withdraw': 64677991,
                                        'prefixes_total': 68207251,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a'}},
                                'refresh_activity_counters': 
                                    {'received': 
                                        {'refresh_end_of_rib': 1,
                                        'refresh_start_of_rib': 1},
                                    'sent': 
                                        {'refresh_end_of_rib': 1,
                                        'refresh_start_of_rib': 1}},
                                'refresh_epoch': 2,
                                'refresh_in': 4,
                                'refresh_out': 27,
                                'route_reflector_client': True,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'update_group_member': 44}},
                                'bgp_neighbor_session': {
                    'sessions': 1,
                    },
                        'bgp_negotiated_capabilities': 
                            {'enhanced_refresh': 'advertised '
                                                 'and '
                                                 'received',
                            'four_octets_asn': 'advertised '
                                               'and '
                                               'received',
                            'graceful_restart': 'advertised '
                                                'and '
                                                'received',
                            'graceful_restart_af_advertised_by_peer': ['vpnv4 '
                                                                       'unicast',
                                                                       'l2vpn '
                                                                       'vpls'],
                            'ipv4_unicast': 'advertised',
                            'l2vpn_vpls': 'advertised '
                                          'and '
                                          'received',
                            'multisession': 'advertised',
                            'remote_restart_timer': 120,
                            'route_refresh': 'advertised '
                                             'and '
                                             'received(new)',
                            'stateful_switchover': 'NO '
                                                   'for '
                                                   'session '
                                                   '1',
                            'vpnv4_unicast': 'advertised '
                                             'and '
                                             'received'},
                        'bgp_negotiated_keepalive_timers': 
                            {'hold_time': 90,
                            'keepalive_interval': 30,
                            'min_holdtime': 0},
                        'bgp_neighbor_counters': 
                            {'messages': 
                                {'in_queue_depth': 0,
                                'out_queue_depth': 0,
                                'received': 
                                    {'keepalives': 346,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 0,
                                    'total': 13183,
                                    'updates': 12830},
                                'sent': 
                                    {'keepalives': 347,
                                    'notifications': 0,
                                    'opens': 1,
                                    'route_refresh': 4,
                                    'total': 12180,
                                    'updates': 11824}}},
                        'bgp_session_transport': 
                            {'address_tracking_status': 'enabled',
                            'connection': 
                                {'dropped': 38,
                                'established': 39,
                                'last_reset': '02:42:06',
                                'reset_reason': 'Peer '
                                                'closed '
                                                'the '
                                                'session'},
                            'gr_restart_time': 120,
                            'gr_stalepath_time': 360,
                            'graceful_restart': 'enabled',
                            'min_time_between_advertisement_runs': 0,
                            'rib_route_ip': '192.168.197.254',
                            'sso': False,
                            'tcp_connection': False,
                            'tcp_path_mtu_discovery': 'enabled'},
                        'bgp_version': 4,
                        'link': 'internal',
                        'remote_as': 5918,
                        'router_id': '192.168.197.254',
                        'session_state': 'Idle',
                        'shutdown': False}}}}}

    golden_output1 = {'execute.return_value': '''
        RR-1_ASR-1001X#show ip bgp neighbors 192.168.197.254
        BGP neighbor is 192.168.197.254,  remote AS 5918, internal link
          BGP version 4, remote router ID 192.168.197.254
          BGP state = Idle
          Configured hold time is 90, keepalive interval is 30 seconds
          Minimum holdtime from neighbor is 0 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family IPv4 Unicast: advertised
            Address family VPNv4 Unicast: advertised and received
            Address family L2VPN Vpls: advertised and received
            Graceful Restart Capability: advertised and received
              Remote Restart timer is 120 seconds
              Address families advertised by peer:
                VPNv4 Unicast (was not preserved, L2VPN Vpls (was not preserved
              Address families advertised by peer before restart:
                IPv4 Unicast, VPNv4 Unicast, L2VPN Vpls
            Enhanced Refresh Capability: advertised and received
            Multisession Capability: advertised
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0
            
                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:            11824      12830
            Keepalives:           347        346
            Route Refresh:          4          0
            Total:              12180      13183
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

          For address family: IPv4 Unicast
          BGP table version 1, neighbor version 1/0
          Output queue size : 0
          Index 0, Advertise bit 0
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               0          0
            Prefixes Total:                 0          0
            Implicit Withdraw:              0          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Total:                                0          0
          Number of NLRIs in the update sent: max 0, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: 1w5d
          Last Sent Refresh End-of-rib: 1w5d
          Refresh-Out took 0 seconds
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          1          0
              Refresh End-of-RIB            1          0

         For address family: VPNv4 Unicast
          Session: 192.168.197.254
          BGP table version 29454374, neighbor version 29454374/0
          Output queue size : 0
          Index 44, Advertise bit 2
          Route-Reflector Client
          44 update-group member
          Extended-community attribute sent to this neighbor
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:         2022201      20201 (Consumes 2424120 bytes)
            Prefixes Total:          68207251      61115
            Implicit Withdraw:       64677991      40708
            Explicit Withdraw:        1131817        206
            Used as bestpath:             n/a      20201
            Used as multipath:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Bestpath from this peer:           3100        n/a
            Total:                             3100          0
          Number of NLRIs in the update sent: max 270, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 2
          Last Sent Refresh Start-of-rib: 02:41:38
          Last Sent Refresh End-of-rib: 02:41:11
          Refresh-Out took 27 seconds
          Last Received Refresh Start-of-rib: 02:01:36
          Last Received Refresh End-of-rib: 02:01:32
          Refresh-In took 4 seconds
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          1          1
              Refresh End-of-RIB            1          1

         For address family: L2VPN Vpls
          Session: 192.168.197.254
          BGP table version 9431, neighbor version 9431/0
          Output queue size : 0
          Index 38, Advertise bit 1
          Route-Reflector Client
          38 update-group member
          Community attribute sent to this neighbor
          Extended-community attribute sent to this neighbor
          Suppress LDP signaling protocol
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:             403        201 (Consumes 27336 bytes)
            Prefixes Total:              6356        603
            Implicit Withdraw:           5646        402
            Explicit Withdraw:            307          0
            Used as bestpath:             n/a        201
            Used as multipath:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Bestpath from this peer:            402        n/a
            Total:                              402          0
          Number of NLRIs in the update sent: max 199, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 3
          Last Sent Refresh Start-of-rib: 02:41:38
          Last Sent Refresh End-of-rib: 02:41:38
          Refresh-Out took 0 seconds
          Last Received Refresh Start-of-rib: 02:01:36
          Last Received Refresh End-of-rib: 02:01:32
          Refresh-In took 4 seconds
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          1          2
              Refresh End-of-RIB            1          2

          Address tracking is enabled, the RIB does have a route to 192.168.197.254
          Connections established 39; dropped 38
          Last reset 02:42:06, due to Peer closed the session
          Interface associated: (none) (peering address NOT in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is enabled, restart-time 120 seconds, stalepath-time 360 seconds
          SSO is disabled
          No active TCP connection
        '''}

    golden_parsed_output2 = {
        'list_of_neighbors': ['10.1.1.1', '10.2.2.2'],
        'vrf': {'default': {'neighbor': {'10.1.1.1': {'address_family': {'ipv4 unicast': {'advertise_bit': 0,
                                                                                   'bgp_table_version': 1,
                                                                                   'dynamic_slow_peer_recovered': 'never',
                                                                                   'index': 1,
                                                                                   'last_detected_dynamic_slow_peer': 'never',
                                                                                   'last_received_refresh_end_of_rib': 'never',
                                                                                   'last_received_refresh_start_of_rib': 'never',
                                                                                   'last_sent_refresh_end_of_rib': 'never',
                                                                                   'last_sent_refresh_start_of_rib': 'never',
                                                                                   'local_policy_denied_prefixes_counters': {'inbound': {'total': 0},
                                                                                                                             'outbound': {'total': 0}},
                                                                                   'max_nlri': 0,
                                                                                   'min_nlri': 0,
                                                                                   'neighbor_version': '1/0',
                                                                                   'output_queue_size': 0,
                                                                                   'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                             'implicit_withdraw': 0,
                                                                                                                             'prefixes_current': 0,
                                                                                                                             'prefixes_total': 0,
                                                                                                                             'used_as_bestpath': 0,
                                                                                                                             'used_as_multipath': 0,
                                                                                                                             'used_as_secondary': 0},
                                                                                                                'sent': {'explicit_withdraw': 0,
                                                                                                                         'implicit_withdraw': 0,
                                                                                                                         'prefixes_current': 0,
                                                                                                                         'prefixes_total': 0,
                                                                                                                         'used_as_bestpath': 'n/a',
                                                                                                                         'used_as_multipath': 'n/a',
                                                                                                                         'used_as_secondary': 'n/a'}},
                                                                                   'refresh_activity_counters': {'received': {'refresh_end_of_rib': 0,
                                                                                                                              'refresh_start_of_rib': 0},
                                                                                                                 'sent': {'refresh_end_of_rib': 0,
                                                                                                                          'refresh_start_of_rib': 0}},
                                                                                   'refresh_epoch': 1,
                                                                                   'slow_peer_detection': False,
                                                                                   'slow_peer_split_update_group_dynamic': False,
                                                                                   'update_group_member': 1},
                                                                  'vpnv4 unicast': {'advertise_bit': 1,
                                                                                    'bgp_table_version': 21,
                                                                                    'current_time': '0x196C6065',
                                                                                    'dynamic_slow_peer_recovered': 'never',
                                                                                    'extended_community_attribute_sent': True,
                                                                                    'index': 3,
                                                                                    'last_detected_dynamic_slow_peer': 'never',
                                                                                    'last_received_refresh_end_of_rib': 'never',
                                                                                    'last_received_refresh_start_of_rib': 'never',
                                                                                    'last_sent_refresh_end_of_rib': 'never',
                                                                                    'last_sent_refresh_start_of_rib': 'never',
                                                                                    'local_policy_denied_prefixes_counters': {'inbound': {'af_permit_check': 'n/a',
                                                                                                                                          'bestpath_from_ibgp_peer': 'n/a',
                                                                                                                                          'bestpath_from_this_peer': 'n/a',
                                                                                                                                          'originator_loop': 8,
                                                                                                                                          'total': 8},
                                                                                                                              'outbound': {'af_permit_check': 4,
                                                                                                                                           'bestpath_from_ibgp_peer': 4,
                                                                                                                                           'bestpath_from_this_peer': 4,
                                                                                                                                           'originator_loop': 'n/a',
                                                                                                                                           'total': 12}},
                                                                                    'max_nlri': 1,
                                                                                    'min_nlri': 0,
                                                                                    'neighbor_version': '21/0',
                                                                                    'output_queue_size': 0,
                                                                                    'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                              'implicit_withdraw': 0,
                                                                                                                              'prefixes_total': 4,
                                                                                                                              'used_as_bestpath': 4,
                                                                                                                              'used_as_multipath': 0,
                                                                                                                              'used_as_secondary': 0},
                                                                                                                 'sent': {'explicit_withdraw': 0,
                                                                                                                          'implicit_withdraw': 4,
                                                                                                                          'prefixes_total': 8,
                                                                                                                          'used_as_bestpath': 'n/a',
                                                                                                                          'used_as_multipath': 'n/a',
                                                                                                                          'used_as_secondary': 'n/a'}},
                                                                                    'refresh_activity_counters': {'received': {'refresh_end_of_rib': 0,
                                                                                                                               'refresh_start_of_rib': 0},
                                                                                                                  'sent': {'refresh_end_of_rib': 0,
                                                                                                                           'refresh_start_of_rib': 0}},
                                                                                    'refresh_epoch': 1,
                                                                                    'slow_peer_detection': False,
                                                                                    'slow_peer_split_update_group_dynamic': False,
                                                                                    'update_group_member': 3}},
                                               'bgp_event_timer': {'next': {'ackhold': '0x0',
                                                                            'deadwait': '0x0',
                                                                            'giveup': '0x0',
                                                                            'keepalive': '0x0',
                                                                            'linger': '0x0',
                                                                            'pmtuager': '0x0',
                                                                            'processq': '0x0',
                                                                            'retrans': '0x0',
                                                                            'sendwnd': '0x0',
                                                                            'timewait': '0x0'},
                                                                   'starts': {'ackhold': 7831,
                                                                              'deadwait': 0,
                                                                              'giveup': 0,
                                                                              'keepalive': 0,
                                                                              'linger': 0,
                                                                              'pmtuager': 0,
                                                                              'processq': 0,
                                                                              'retrans': 7830,
                                                                              'sendwnd': 0,
                                                                              'timewait': 0},
                                                                   'wakeups': {'ackhold': 7651,
                                                                               'deadwait': 0,
                                                                               'giveup': 0,
                                                                               'keepalive': 0,
                                                                               'linger': 0,
                                                                               'pmtuager': 0,
                                                                               'processq': 0,
                                                                               'retrans': 0,
                                                                               'sendwnd': 0,
                                                                               'timewait': 0}},
                                                                               'bgp_neighbor_session': {
                                                                                'sessions': 1,
                                                                                },
                                               'bgp_negotiated_capabilities': {'enhanced_refresh': 'advertised '
                                                                                                   'and '
                                                                                                   'received',
                                                                               'four_octets_asn': 'advertised '
                                                                                                  'and '
                                                                                                  'received',
                                                                               'ipv4_unicast': 'advertised '
                                                                                               'and '
                                                                                               'received',
                                                                               'route_refresh': 'advertised '
                                                                                                'and '
                                                                                                'received(new)',
                                                                               'stateful_switchover': 'NO '
                                                                                                      'for '
                                                                                                      'session '
                                                                                                      '1',
                                                                               'vpnv4_unicast': 'advertised '
                                                                                                'and '
                                                                                                'received'},
                                               'bgp_negotiated_keepalive_timers': {'hold_time': 180,
                                                                                   'keepalive_interval': 60},
                                               'bgp_neighbor_counters': {'messages': {'in_queue_depth': 0,
                                                                                      'out_queue_depth': 0,
                                                                                      'received': {'keepalives': 7828,
                                                                                                   'notifications': 0,
                                                                                                   'opens': 1,
                                                                                                   'route_refresh': 0,
                                                                                                   'total': 7843,
                                                                                                   'updates': 14},
                                                                                      'sent': {'keepalives': 7826,
                                                                                               'notifications': 0,
                                                                                               'opens': 1,
                                                                                               'route_refresh': 0,
                                                                                               'total': 7837,
                                                                                               'updates': 10}}},
                                               'bgp_session_transport': {'ack_hold': 200,
                                                                         'address_tracking_status': 'enabled',
                                                                         'connection': {'dropped': 0,
                                                                                        'established': 1,
                                                                                        'last_reset': 'never'},
                                                                         'connection_state': 'estab',
                                                                         'connection_tableid': 0,
                                                                         'datagram': {'datagram_received': {'out_of_order': 0,
                                                                                                            'total_data': 150133,
                                                                                                            'value': 15627,
                                                                                                            'with_data': 7832},
                                                                                      'datagram_sent': {'fastretransmit': 0,
                                                                                                        'partialack': 0,
                                                                                                        'retransmit': 0,
                                                                                                        'second_congestion': 0,
                                                                                                        'total_data': 149555,
                                                                                                        'value': 15591,
                                                                                                        'with_data': 7831}},
                                                                         'delrcvwnd': 1026,
                                                                         'ecn_connection': 'disabled',
                                                                         'enqueued_packets': {'input_packet': 0,
                                                                                              'mis_ordered_packet': 0,
                                                                                              'retransmit_packet': 0},
                                                                         'fast_lock_acquisition_failures': 0,
                                                                         'graceful_restart': 'disabled',
                                                                         'io_status': 1,
                                                                         'ip_precedence_value': 6,
                                                                         'irs': 547332975,
                                                                         'iss': 3484933877,
                                                                         'krtt': 0,
                                                                         'lock_slow_path': 0,
                                                                         'max_rtt': 1000,
                                                                         'maximum_output_segment_queue_size': 50,
                                                                         'maxrcvwnd': 16384,
                                                                         'min_rtt': 1,
                                                                         'min_time_between_advertisement_runs': 0,
                                                                         'minimum_incoming_ttl': 0,
                                                                         'option_flags': 'nagle, '
                                                                                         'path '
                                                                                         'mtu '
                                                                                         'capable',
                                                                         'outgoing_ttl': 255,
                                                                         'packet_fast_path': 0,
                                                                         'packet_fast_processed': 0,
                                                                         'packet_slow_path': 0,
                                                                         'rcv_scale': 0,
                                                                         'rcvnxt': 547483109,
                                                                         'rcvwnd': 15358,
                                                                         'receive_idletime': 3314,
                                                                         'rib_route_ip': '10.1.1.1',
                                                                         'rtto': 1003,
                                                                         'rtv': 3,
                                                                         'sent_idletime': 3516,
                                                                         'snd_scale': 0,
                                                                         'sndnxt': 3485083433,
                                                                         'snduna': 3485083433,
                                                                         'sndwnd': 15871,
                                                                         'srtt': 1000,
                                                                         'sso': False,
                                                                         'status_flags': 'passive '
                                                                                         'open, '
                                                                                         'gen '
                                                                                         'tcbs',
                                                                         'tcp_path_mtu_discovery': 'enabled',
                                                                         'tcp_semaphore': '0x7F59978AAB40',
                                                                         'tcp_semaphore_status': 'FREE',
                                                                         'transport': {'foreign_host': '10.1.1.1',
                                                                                       'foreign_port': '44730',
                                                                                       'local_host': '10.5.5.5',
                                                                                       'local_port': '179',
                                                                                       'mss': 1396},
                                                                         'unread_input_bytes': 0,
                                                                         'uptime': 426320531},
                                               'bgp_version': 4,
                                               'link': 'internal',
                                               'remote_as': 65000,
                                               'router_id': '10.1.1.1',
                                               'session_state': 'Established',
                                               'shutdown': False},
                                  '10.2.2.2': {'address_family': {'ipv4 unicast': {'advertise_bit': 0,
                                                                                   'bgp_table_version': 1,
                                                                                   'dynamic_slow_peer_recovered': 'never',
                                                                                   'index': 1,
                                                                                   'last_detected_dynamic_slow_peer': 'never',
                                                                                   'last_received_refresh_end_of_rib': 'never',
                                                                                   'last_received_refresh_start_of_rib': 'never',
                                                                                   'last_sent_refresh_end_of_rib': 'never',
                                                                                   'last_sent_refresh_start_of_rib': 'never',
                                                                                   'local_policy_denied_prefixes_counters': {'inbound': {'total': 0},
                                                                                                                             'outbound': {'total': 0}},
                                                                                   'max_nlri': 0,
                                                                                   'min_nlri': 0,
                                                                                   'neighbor_version': '1/0',
                                                                                   'output_queue_size': 0,
                                                                                   'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                             'implicit_withdraw': 0,
                                                                                                                             'prefixes_current': 0,
                                                                                                                             'prefixes_total': 0,
                                                                                                                             'used_as_bestpath': 0,
                                                                                                                             'used_as_multipath': 0,
                                                                                                                             'used_as_secondary': 0},
                                                                                                                'sent': {'explicit_withdraw': 0,
                                                                                                                         'implicit_withdraw': 0,
                                                                                                                         'prefixes_current': 0,
                                                                                                                         'prefixes_total': 0,
                                                                                                                         'used_as_bestpath': 'n/a',
                                                                                                                         'used_as_multipath': 'n/a',
                                                                                                                         'used_as_secondary': 'n/a'}},
                                                                                   'refresh_activity_counters': {'received': {'refresh_end_of_rib': 0,
                                                                                                                              'refresh_start_of_rib': 0},
                                                                                                                 'sent': {'refresh_end_of_rib': 0,
                                                                                                                          'refresh_start_of_rib': 0}},
                                                                                   'refresh_epoch': 1,
                                                                                   'slow_peer_detection': False,
                                                                                   'slow_peer_split_update_group_dynamic': False,
                                                                                   'update_group_member': 1},
                                                                  'vpnv4 unicast': {'advertise_bit': 1,
                                                                                    'bgp_table_version': 21,
                                                                                    'current_time': '0x196C6142',
                                                                                    'dynamic_slow_peer_recovered': 'never',
                                                                                    'extended_community_attribute_sent': True,
                                                                                    'index': 3,
                                                                                    'last_detected_dynamic_slow_peer': 'never',
                                                                                    'last_read': '00:00:57',
                                                                                    'last_received_refresh_end_of_rib': 'never',
                                                                                    'last_received_refresh_start_of_rib': 'never',
                                                                                    'last_sent_refresh_end_of_rib': 'never',
                                                                                    'last_sent_refresh_start_of_rib': 'never',
                                                                                    'last_write': '00:00:15',
                                                                                    'local_policy_denied_prefixes_counters': {'inbound': {'af_permit_check': 'n/a',
                                                                                                                                          'bestpath_from_ibgp_peer': 'n/a',
                                                                                                                                          'bestpath_from_this_peer': 'n/a',
                                                                                                                                          'originator_loop': 8,
                                                                                                                                          'total': 8},
                                                                                                                              'outbound': {'af_permit_check': 4,
                                                                                                                                           'bestpath_from_ibgp_peer': 4,
                                                                                                                                           'bestpath_from_this_peer': 4,
                                                                                                                                           'originator_loop': 'n/a',
                                                                                                                                           'total': 12}},
                                                                                    'max_nlri': 1,
                                                                                    'min_nlri': 0,
                                                                                    'neighbor_version': '21/0',
                                                                                    'output_queue_size': 0,
                                                                                    'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                              'implicit_withdraw': 0,
                                                                                                                              'prefixes_total': 4,
                                                                                                                              'used_as_bestpath': 0,
                                                                                                                              'used_as_multipath': 0,
                                                                                                                              'used_as_secondary': 0},
                                                                                                                 'sent': {'explicit_withdraw': 0,
                                                                                                                          'implicit_withdraw': 4,
                                                                                                                          'prefixes_total': 8,
                                                                                                                          'used_as_bestpath': 'n/a',
                                                                                                                          'used_as_multipath': 'n/a',
                                                                                                                          'used_as_secondary': 'n/a'}},
                                                                                    'refresh_activity_counters': {'received': {'refresh_end_of_rib': 0,
                                                                                                                               'refresh_start_of_rib': 0},
                                                                                                                  'sent': {'refresh_end_of_rib': 0,
                                                                                                                           'refresh_start_of_rib': 0}},
                                                                                    'refresh_epoch': 1,
                                                                                    'session_state': 'Established',
                                                                                    'slow_peer_detection': False,
                                                                                    'slow_peer_split_update_group_dynamic': False,
                                                                                    'up_time': '4d22h',
                                                                                    'update_group_member': 3}},
                                               'bgp_event_timer': {'next': {'ackhold': '0x0',
                                                                            'deadwait': '0x0',
                                                                            'giveup': '0x0',
                                                                            'keepalive': '0x0',
                                                                            'linger': '0x0',
                                                                            'pmtuager': '0x0',
                                                                            'processq': '0x0',
                                                                            'retrans': '0x0',
                                                                            'sendwnd': '0x0',
                                                                            'timewait': '0x0'},
                                                                   'starts': {'ackhold': 7818,
                                                                              'deadwait': 0,
                                                                              'giveup': 0,
                                                                              'keepalive': 0,
                                                                              'linger': 0,
                                                                              'pmtuager': 0,
                                                                              'processq': 0,
                                                                              'retrans': 7818,
                                                                              'sendwnd': 0,
                                                                              'timewait': 0},
                                                                   'wakeups': {'ackhold': 7666,
                                                                               'deadwait': 0,
                                                                               'giveup': 0,
                                                                               'keepalive': 0,
                                                                               'linger': 0,
                                                                               'pmtuager': 0,
                                                                               'processq': 0,
                                                                               'retrans': 0,
                                                                               'sendwnd': 0,
                                                                               'timewait': 0}},
                                                                               'bgp_neighbor_session': {
                                                                            'sessions': 1,
                                                                            },
                                               'bgp_negotiated_capabilities': {'enhanced_refresh': 'advertised '
                                                                                                   'and '
                                                                                                   'received',
                                                                               'four_octets_asn': 'advertised '
                                                                                                  'and '
                                                                                                  'received',
                                                                               'ipv4_unicast': 'advertised '
                                                                                               'and '
                                                                                               'received',
                                                                               'route_refresh': 'advertised '
                                                                                                'and '
                                                                                                'received(new)',
                                                                               'stateful_switchover': 'NO '
                                                                                                      'for '
                                                                                                      'session '
                                                                                                      '1',
                                                                               'vpnv4_unicast': 'advertised '
                                                                                                'and '
                                                                                                'received'},
                                               'bgp_negotiated_keepalive_timers': {'hold_time': 180,
                                                                                   'keepalive_interval': 60},
                                               'bgp_neighbor_counters': {'messages': {'in_queue_depth': 0,
                                                                                      'out_queue_depth': 0,
                                                                                      'received': {'keepalives': 7815,
                                                                                                   'notifications': 0,
                                                                                                   'opens': 1,
                                                                                                   'route_refresh': 0,
                                                                                                   'total': 7830,
                                                                                                   'updates': 14},
                                                                                      'sent': {'keepalives': 7813,
                                                                                               'notifications': 0,
                                                                                               'opens': 1,
                                                                                               'route_refresh': 0,
                                                                                               'total': 7824,
                                                                                               'updates': 10}}},
                                               'bgp_session_transport': {'ack_hold': 200,
                                                                         'address_tracking_status': 'enabled',
                                                                         'connection': {'dropped': 0,
                                                                                        'established': 1,
                                                                                        'last_reset': 'never'},
                                                                         'connection_state': 'estab',
                                                                         'connection_tableid': 0,
                                                                         'datagram': {'datagram_received': {'out_of_order': 0,
                                                                                                            'total_data': 149886,
                                                                                                            'value': 15608,
                                                                                                            'with_data': 7819},
                                                                                      'datagram_sent': {'fastretransmit': 0,
                                                                                                        'partialack': 0,
                                                                                                        'retransmit': 0,
                                                                                                        'second_congestion': 0,
                                                                                                        'total_data': 149308,
                                                                                                        'value': 15593,
                                                                                                        'with_data': 7818}},
                                                                         'delrcvwnd': 779,
                                                                         'ecn_connection': 'disabled',
                                                                         'enqueued_packets': {'input_packet': 0,
                                                                                              'mis_ordered_packet': 0,
                                                                                              'retransmit_packet': 0},
                                                                         'fast_lock_acquisition_failures': 0,
                                                                         'graceful_restart': 'disabled',
                                                                         'io_status': 1,
                                                                         'ip_precedence_value': 6,
                                                                         'irs': 2814267610,
                                                                         'iss': 84959429,
                                                                         'krtt': 0,
                                                                         'lock_slow_path': 0,
                                                                         'max_rtt': 1000,
                                                                         'maximum_output_segment_queue_size': 50,
                                                                         'maxrcvwnd': 16384,
                                                                         'min_rtt': 1,
                                                                         'min_time_between_advertisement_runs': 0,
                                                                         'minimum_incoming_ttl': 0,
                                                                         'option_flags': 'nagle, '
                                                                                         'path '
                                                                                         'mtu '
                                                                                         'capable',
                                                                         'outgoing_ttl': 255,
                                                                         'packet_fast_path': 0,
                                                                         'packet_fast_processed': 0,
                                                                         'packet_slow_path': 0,
                                                                         'rcv_scale': 0,
                                                                         'rcvnxt': 2814417497,
                                                                         'rcvwnd': 15605,
                                                                         'receive_idletime': 16017,
                                                                         'rib_route_ip': '10.2.2.2',
                                                                         'rtto': 1003,
                                                                         'rtv': 3,
                                                                         'sent_idletime': 16219,
                                                                         'snd_scale': 0,
                                                                         'sndnxt': 85108738,
                                                                         'snduna': 85108738,
                                                                         'sndwnd': 16118,
                                                                         'srtt': 1000,
                                                                         'sso': False,
                                                                         'status_flags': 'passive '
                                                                                         'open, '
                                                                                         'gen '
                                                                                         'tcbs',
                                                                         'tcp_path_mtu_discovery': 'enabled',
                                                                         'tcp_semaphore': '0x7F59978AAC10',
                                                                         'tcp_semaphore_status': 'FREE',
                                                                         'transport': {'foreign_host': '10.2.2.2',
                                                                                       'foreign_port': '43047',
                                                                                       'local_host': '10.5.5.5',
                                                                                       'local_port': '179',
                                                                                       'mss': 1396},
                                                                         'unread_input_bytes': 0,
                                                                         'uptime': 426325909},
                                               'bgp_version': 4,
                                               'link': 'internal',
                                               'remote_as': 65000,
                                               'router_id': '10.2.2.2',
                                               'session_state': 'Established',
                                               'shutdown': False}}}}}

    golden_output2 = {'execute.return_value': '''
        show ip bgp ipv4 unicast neighbors
        BGP neighbor is 10.1.1.1,  remote AS 65000, internal link
          BGP version 4, remote router ID 10.1.1.1
          BGP state = Established, up for 4d22h
          Last read 00:00:32, last write 00:00:03, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family IPv4 Unicast: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised and received
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               10         14
            Keepalives:          7826       7828
            Route Refresh:          0          0
            Total:               7837       7843
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

         For address family: IPv4 Unicast
          Session: 10.1.1.1
          BGP table version 1, neighbor version 1/0
          Output queue size : 0
          Index 1, Advertise bit 0
          1 update-group member
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               0          0
            Prefixes Total:                 0          0
            Implicit Withdraw:              0          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Total:                                0          0
          Number of NLRIs in the update sent: max 0, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

         For address family: VPNv4 Unicast
          Session: 10.1.1.1
          BGP table version 21, neighbor version 21/0
          Output queue size : 0
          Index 3, Advertise bit 1
          3 update-group member
          Extended-community attribute sent to this neighbor
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               4          4 (Consumes 544 bytes)
            Prefixes Total:                 8          4
            Implicit Withdraw:              4          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          4
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            ORIGINATOR loop:                    n/a          8
            Bestpath from this peer:              4        n/a
            Bestpath from iBGP peer:              4        n/a
            AF Permit Check:                      4        n/a
            Total:                               12          8
          Number of NLRIs in the update sent: max 1, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

          Address tracking is enabled, the RIB does have a route to 10.1.1.1
          Route to peer address reachability Up: 2; Down: 1
            Last notification 4d22h
          Connections established 1; dropped 0
          Last reset never
          Interface associated: (none) (peering address NOT in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
          SSO is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.5.5.5, Local port: 179
        Foreign host: 10.1.1.1, Foreign port: 44730
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x196C6065):
        Timer          Starts    Wakeups            Next
        Retrans          7830          0             0x0
        TimeWait            0          0             0x0
        AckHold          7831       7651             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss: 3484933877  snduna: 3485083433  sndnxt: 3485083433
        irs:  547332975  rcvnxt:  547483109

        sndwnd:  15871  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15358  scale:      0  delrcvwnd:   1026

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 426320531 ms, Sent idletime: 3516 ms, Receive idletime: 3314 ms
        Status Flags: passive open, gen tcbs
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1396 bytes):
        Rcvd: 15627 (out of order: 0), with data: 7832, total data bytes: 150133
        Sent: 15591 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 7831, total data bytes: 149555

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x7F59978AAB40  FREE

        BGP neighbor is 10.2.2.2,  remote AS 65000, internal link
          BGP version 4, remote router ID 10.2.2.2
          BGP state = Established, up for 4d22h
          Last read 00:00:57, last write 00:00:15, hold time is 180, keepalive interval is 60 seconds
          Neighbor sessions:
            1 active, is not multisession capable (disabled)
          Neighbor capabilities:
            Route refresh: advertised and received(new)
            Four-octets ASN Capability: advertised and received
            Address family IPv4 Unicast: advertised and received
            Address family VPNv4 Unicast: advertised and received
            Enhanced Refresh Capability: advertised and received
            Multisession Capability:
            Stateful switchover support enabled: NO for session 1
          Message statistics:
            InQ depth is 0
            OutQ depth is 0

                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          0          0
            Updates:               10         14
            Keepalives:          7813       7815
            Route Refresh:          0          0
            Total:               7824       7830
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

         For address family: IPv4 Unicast
          Session: 10.2.2.2
          BGP table version 1, neighbor version 1/0
          Output queue size : 0
          Index 1, Advertise bit 0
          1 update-group member
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               0          0
            Prefixes Total:                 0          0
            Implicit Withdraw:              0          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Total:                                0          0
          Number of NLRIs in the update sent: max 0, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

         For address family: VPNv4 Unicast
          Session: 10.2.2.2
          BGP table version 21, neighbor version 21/0
          Output queue size : 0
          Index 3, Advertise bit 1
          3 update-group member
          Extended-community attribute sent to this neighbor
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               4          4 (Consumes 544 bytes)
            Prefixes Total:                 8          4
            Implicit Withdraw:              4          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            ORIGINATOR loop:                    n/a          8
            Bestpath from this peer:              4        n/a
            Bestpath from iBGP peer:              4        n/a
            AF Permit Check:                      4        n/a
            Total:                               12          8
          Number of NLRIs in the update sent: max 1, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

          Address tracking is enabled, the RIB does have a route to 10.2.2.2
          Route to peer address reachability Up: 2; Down: 1
            Last notification 4d22h
          Connections established 1; dropped 0
          Last reset never
          Interface associated: (none) (peering address NOT in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is disabled
          SSO is disabled
        Connection state is ESTAB, I/O status: 1, unread input bytes: 0
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 255
        Local host: 10.5.5.5, Local port: 179
        Foreign host: 10.2.2.2, Foreign port: 43047
        Connection tableid (VRF): 0
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x196C6142):
        Timer          Starts    Wakeups            Next
        Retrans          7818          0             0x0
        TimeWait            0          0             0x0
        AckHold          7818       7666             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            0          0             0x0
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:   84959429  snduna:   85108738  sndnxt:   85108738
        irs: 2814267610  rcvnxt: 2814417497

        sndwnd:  16118  scale:      0  maxrcvwnd:  16384
        rcvwnd:  15605  scale:      0  delrcvwnd:    779

        SRTT: 1000 ms, RTTO: 1003 ms, RTV: 3 ms, KRTT: 0 ms
        minRTT: 1 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 426325909 ms, Sent idletime: 16219 ms, Receive idletime: 16017 ms
        Status Flags: passive open, gen tcbs
        Option Flags: nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1396 bytes):
        Rcvd: 15608 (out of order: 0), with data: 7819, total data bytes: 149886
        Sent: 15593 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 7818, total data bytes: 149308

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x7F59978AAC10  FREE

        PE1#
        '''}

    golden_parsed_output3 = {
        'list_of_neighbors': [
            '192.168.36.120'
        ],
        'vrf': {
            'default': {
                'neighbor': {
                    '192.168.36.120': {
                        'remote_as': 65109,
                        'link': 'internal',
                        'shutdown': False,
                        'bgp_version': 4,
                        'router_id': '192.168.36.120',
                        'session_state': 'Idle',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 90,
                            'keepalive_interval': 30,
                            'min_holdtime': 15
                        },
                        'bgp_neighbor_session': {
                            'sessions': 1
                        },
                        'bgp_negotiated_capabilities': {
                            'route_refresh': 'advertised and received(new)',
                            'four_octets_asn': 'advertised and received',
                            'vpnv4_unicast': 'advertised and received',
                            'l2vpn_vpls': 'advertised and received',
                            'link-state_link-state': 'advertised',
                            'graceful_restart': 'advertised and received',
                            'remote_restart_timer': 120,
                            'graceful_restart_af_advertised_by_peer': [
                                'vpnv4 unicast',
                                'l2vpn vpls'
                            ],
                            'enhanced_refresh': 'advertised and received',
                            'stateful_switchover': 'NO for session 1'
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 405,
                                    'keepalives': 4,
                                    'route_refresh': 0,
                                    'total': 414
                                },
                                'received': {
                                    'opens': 1,
                                    'notifications': 0,
                                    'updates': 1504,
                                    'keepalives': 4,
                                    'route_refresh': 0,
                                    'total': 1513
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0
                            }
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 0,
                            'address_tracking_status': 'enabled',
                            'rib_route_ip': '192.168.36.120',
                            'connection': {
                                'established': 2,
                                'dropped': 1,
                                'last_reset': '00:01:26',
                                'reset_reason': 'Capability changed of session 1'
                            },
                            'tcp_path_mtu_discovery': 'enabled',
                            'graceful_restart': 'enabled',
                            'gr_restart_time': 120,
                            'gr_stalepath_time': 360,
                            'sso': False,
                            'tcp_connection': False
                        },
                        'address_family': {
                            'vpnv4 unicast': {
                                'bgp_table_version': 1266,
                                'neighbor_version': '1266/0',
                                'output_queue_size': 0,
                                'index': 1,
                                'advertise_bit': 0,
                                'update_group_member': 1,
                                'extended_community_attribute_sent': True,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'prefix_activity_counters': {
                                    'sent': {
                                        'prefixes_total': 402,
                                        'implicit_withdraw': 201,
                                        'explicit_withdraw': 0,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                        'used_as_secondary': 'n/a'
                                    },
                                    'received': {
                                        'prefixes_total': 497,
                                        'implicit_withdraw': 0,
                                        'explicit_withdraw': 0,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0,
                                        'used_as_secondary': 0
                                    }
                                },
                                'local_policy_denied_prefixes_counters': {
                                    'outbound': {
                                        'originator_loop': 'n/a',
                                        'bestpath_from_this_peer': 994,
                                        'af_permit_check': 497,
                                        'total': 1491
                                    },
                                    'inbound': {
                                        'originator_loop': 201,
                                        'bestpath_from_this_peer': 'n/a',
                                        'af_permit_check': 'n/a',
                                        'total': 201
                                    }
                                },
                                'max_nlri': 1,
                                'min_nlri': 0,
                                'last_detected_dynamic_slow_peer': 'never',
                                'dynamic_slow_peer_recovered': 'never',
                                'refresh_epoch': 2,
                                'last_sent_refresh_start_of_rib': '00:01:25',
                                'last_sent_refresh_end_of_rib': '00:01:22',
                                'refresh_out': 3,
                                'last_received_refresh_start_of_rib': '00:01:24',
                                'last_received_refresh_end_of_rib': '00:01:16',
                                'refresh_in': 8,
                                'refresh_activity_counters': {
                                    'sent': {
                                        'refresh_start_of_rib': 1,
                                        'refresh_end_of_rib': 1
                                    },
                                    'received': {
                                        'refresh_start_of_rib': 1,
                                        'refresh_end_of_rib': 1
                                    }
                                }
                            },
                            'l2vpn vpls': {
                                'bgp_table_version': 621,
                                'neighbor_version': '621/0',
                                'output_queue_size': 0,
                                'index': 1,
                                'advertise_bit': 0,
                                'update_group_member': 1,
                                'extended_community_attribute_sent': True,
                                'suppress_ldp_signaling': True,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'prefix_activity_counters': {
                                    'sent': {
                                        'prefixes_total': 404,
                                        'implicit_withdraw': 202,
                                        'explicit_withdraw': 0,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                        'used_as_secondary': 'n/a'
                                    },
                                    'received': {
                                        'prefixes_total': 101,
                                        'implicit_withdraw': 0,
                                        'explicit_withdraw': 0,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0,
                                        'used_as_secondary': 0
                                    }
                                },
                                'local_policy_denied_prefixes_counters': {
                                    'outbound': {
                                        'originator_loop': 'n/a',
                                        'bestpath_from_this_peer': 477,
                                        'total': 477
                                    },
                                    'inbound': {
                                        'originator_loop': 202,
                                        'bestpath_from_this_peer': 'n/a',
                                        'total': 202
                                    }
                                },
                                'max_nlri': 1,
                                'min_nlri': 0,
                                'last_detected_dynamic_slow_peer': 'never',
                                'dynamic_slow_peer_recovered': 'never',
                                'refresh_epoch': 2,
                                'last_sent_refresh_start_of_rib': '00:01:25',
                                'last_sent_refresh_end_of_rib': '00:01:25',
                                'refresh_out': 0,
                                'last_received_refresh_start_of_rib': '00:01:24',
                                'last_received_refresh_end_of_rib': '00:01:22',
                                'refresh_in': 2,
                                'refresh_activity_counters': {
                                    'sent': {
                                        'refresh_start_of_rib': 1,
                                        'refresh_end_of_rib': 1
                                    },
                                    'received': {
                                        'refresh_start_of_rib': 1,
                                        'refresh_end_of_rib': 1
                                    }
                                }
                            },
                            'linkstate linkstate': {
                                'bgp_table_version': 1,
                                'neighbor_version': '1/0',
                                'output_queue_size': 0,
                                'index': 0,
                                'advertise_bit': 0,
                                'slow_peer_detection': False,
                                'slow_peer_split_update_group_dynamic': False,
                                'prefix_activity_counters': {
                                    'sent': {
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'implicit_withdraw': 0,
                                        'explicit_withdraw': 0,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                        'used_as_secondary': 'n/a'
                                    },
                                    'received': {
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'implicit_withdraw': 0,
                                        'explicit_withdraw': 0,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0,
                                        'used_as_secondary': 0
                                    }
                                },
                                'local_policy_denied_prefixes_counters': {
                                    'outbound': {
                                        'total': 0
                                    },
                                    'inbound': {
                                        'total': 0
                                    }
                                },
                                'max_nlri': 0,
                                'min_nlri': 0,
                                'last_detected_dynamic_slow_peer': 'never',
                                'dynamic_slow_peer_recovered': 'never',
                                'refresh_epoch': 1,
                                'last_sent_refresh_start_of_rib': 'never',
                                'last_sent_refresh_end_of_rib': 'never',
                                'last_received_refresh_start_of_rib': 'never',
                                'last_received_refresh_end_of_rib': 'never',
                                'refresh_activity_counters': {
                                    'sent': {
                                        'refresh_start_of_rib': 0,
                                        'refresh_end_of_rib': 0
                                    },
                                    'received': {
                                        'refresh_start_of_rib': 0,
                                        'refresh_end_of_rib': 0
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    golden_output3 = {'execute.return_value': '''
        #show ip bgp link-state link-state neighbors
        BGP neighbor is 192.168.36.120,  remote AS 65109, internal link
        BGP version 4, remote router ID 192.168.36.120
        BGP state = Idle, down for never
        Configured hold time is 90, keepalive interval is 30 seconds
        Minimum holdtime from neighbor is 15 seconds
        Neighbor sessions:
        1 active, is not multisession capable (disabled)
        Neighbor capabilities:
        Route refresh: advertised and received(new)
        Four-octets ASN Capability: advertised and received
        Address family VPNv4 Unicast: advertised and received
        Address family L2VPN Vpls: advertised and received
        Address family link-state link-state: advertised
        Graceful Restart Capability: advertised and received
          Remote Restart timer is 120 seconds
          Address families advertised by peer:
            VPNv4 Unicast (was not preserved, L2VPN Vpls (was not preserved
        Enhanced Refresh Capability: advertised and received
        Multisession Capability:
        Stateful switchover support enabled: NO for session 1
        Message statistics:
        InQ depth is 0
        OutQ depth is 0

                             Sent       Rcvd
        Opens:                  1          1
        Notifications:          0          0
        Updates:              405       1504
        Keepalives:             4          4
        Route Refresh:          0          0
        Total:                414       1513
        Do log neighbor state changes (via global configuration)
        Default minimum time between advertisement runs is 0 seconds

        For address family: VPNv4 Unicast
        Session: 192.168.36.120
        BGP table version 1266, neighbor version 1266/0
        Output queue size : 0
        Index 1, Advertise bit 0
        1 update-group member
        Extended-community attribute sent to this neighbor
        Slow-peer detection is disabled
        Slow-peer split-update-group dynamic is disabled
                                     Sent       Rcvd
        Prefix activity:               ----       ----
        Prefixes Current:             201        497 (Consumes 67592 bytes)
        Prefixes Total:               402        497
        Implicit Withdraw:            201          0
        Explicit Withdraw:              0          0
        Used as bestpath:             n/a          0
        Used as multipath:            n/a          0
        Used as secondary:            n/a          0

                                       Outbound    Inbound
        Local Policy Denied Prefixes:    --------    -------
        ORIGINATOR loop:                    n/a        201
        Bestpath from this peer:            994        n/a
        AF Permit Check:                    497        n/a
        Total:                             1491        201
        Number of NLRIs in the update sent: max 1, min 0
        Last detected as dynamic slow peer: never
        Dynamic slow peer recovered: never
        Refresh Epoch: 2
        Last Sent Refresh Start-of-rib: 00:01:25
        Last Sent Refresh End-of-rib: 00:01:22
        Refresh-Out took 3 seconds
        Last Received Refresh Start-of-rib: 00:01:24
        Last Received Refresh End-of-rib: 00:01:16
        Refresh-In took 8 seconds
                                           Sent       Rcvd
            Refresh activity:              ----       ----
              Refresh Start-of-RIB          1          1
              Refresh End-of-RIB            1          1

        For address family: L2VPN Vpls
        Session: 192.168.36.120
        BGP table version 621, neighbor version 621/0
        Output queue size : 0
        Index 1, Advertise bit 0
        1 update-group member
        Extended-community attribute sent to this neighbor
        Suppress LDP signaling protocol
        Slow-peer detection is disabled
        Slow-peer split-update-group dynamic is disabled
                                     Sent       Rcvd
        Prefix activity:               ----       ----
        Prefixes Current:             202        101 (Consumes 14544 bytes)
        Prefixes Total:               404        101
        Implicit Withdraw:            202          0
        Explicit Withdraw:              0          0
        Used as bestpath:             n/a          0
        Used as multipath:            n/a          0
        Used as secondary:            n/a          0

                                       Outbound    Inbound
        Local Policy Denied Prefixes:    --------    -------
        ORIGINATOR loop:                    n/a        202
        Bestpath from this peer:            477        n/a
        Total:                              477        202
        Number of NLRIs in the update sent: max 1, min 0
        Last detected as dynamic slow peer: never
        Dynamic slow peer recovered: never
        Refresh Epoch: 2
        Last Sent Refresh Start-of-rib: 00:01:25
        Last Sent Refresh End-of-rib: 00:01:25
        Refresh-Out took 0 seconds
        Last Received Refresh Start-of-rib: 00:01:24
        Last Received Refresh End-of-rib: 00:01:22
        Refresh-In took 2 seconds
                                           Sent       Rcvd
            Refresh activity:              ----       ----
              Refresh Start-of-RIB          1          1
              Refresh End-of-RIB            1          1

        For address family: link-state link-state
        BGP table version 1, neighbor version 1/0
        Output queue size : 0
        Index 0, Advertise bit 0
        Slow-peer detection is disabled
        Slow-peer split-update-group dynamic is disabled
                                     Sent       Rcvd
        Prefix activity:               ----       ----
        Prefixes Current:               0          0
        Prefixes Total:                 0          0
        Implicit Withdraw:              0          0
        Explicit Withdraw:              0          0
        Used as bestpath:             n/a          0
        Used as multipath:            n/a          0
        Used as secondary:            n/a          0

                                       Outbound    Inbound
        Local Policy Denied Prefixes:    --------    -------
        Total:                                0          0
        Number of NLRIs in the update sent: max 0, min 0
        Last detected as dynamic slow peer: never
        Dynamic slow peer recovered: never
        Refresh Epoch: 1
        Last Sent Refresh Start-of-rib: never
        Last Sent Refresh End-of-rib: never
        Last Received Refresh Start-of-rib: never
        Last Received Refresh End-of-rib: never
                                           Sent       Rcvd
            Refresh activity:              ----       ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

        Address tracking is enabled, the RIB does have a route to 192.168.36.120
        Route to peer address reachability Up: 1; Down: 0
        Last notification 1d21h
        Connections established 2; dropped 1
        Last reset 00:01:26, due to Capability changed of session 1
        Interface associated: (none) (peering address NOT in same link)
        Transport(tcp) path-mtu-discovery is enabled
        Graceful-Restart is enabled, restart-time 120 seconds, stalepath-time 360 seconds
        SSO is disabled
        No active TCP connection
    '''}

    golden_parsed_output4 = {
        "list_of_neighbors": [
            "192.168.10.253"
        ],
        "vrf": {
            "CE1test": {
                "neighbor": {
                    "192.168.10.253": {
                        "remote_as": 65555,
                        "link": "external",
                        "shutdown": False,
                        "bgp_version": 4,
                        "router_id": "192.168.10.253",
                        "session_state": "Closing",
                        "bgp_negotiated_keepalive_timers": {
                            "hold_time": 90,
                            "keepalive_interval": 30,
                            "min_holdtime": 15
                        },
                        "bgp_neighbor_session": {
                            "sessions": 0,
                            "stateful_switchover": "NO for session 0, 0"
                        },
                        "bgp_neighbor_counters": {
                            "multisession_messages": {
                                "192.168.10.253 active": {
                                    "sent": {
                                        "opens": 1,
                                        "notifications": 1,
                                        "updates": 0,
                                        "keepalives": 0,
                                        "route_refresh": 0,
                                        "total": 2
                                    },
                                    "received": {
                                        "opens": 1,
                                        "notifications": 0,
                                        "updates": 0,
                                        "keepalives": 0,
                                        "route_refresh": 0,
                                        "total": 2
                                    },
                                    "in_queue_depth": 0,
                                    "out_queue_depth": 0
                                },
                                "192.168.10.253 passive": {
                                    "sent": {
                                        "opens": 0,
                                        "notifications": 1,
                                        "updates": 0,
                                        "keepalives": 0,
                                        "route_refresh": 0,
                                        "total": 1
                                    },
                                    "received": {
                                        "opens": 1,
                                        "notifications": 0,
                                        "updates": 0,
                                        "keepalives": 0,
                                        "route_refresh": 0,
                                        "total": 1
                                    },
                                    "in_queue_depth": 0,
                                    "out_queue_depth": 0
                                }
                            }
                        },
                        "bgp_session_transport": {
                            "min_time_between_advertisement_runs": 0,
                            "address_tracking_status": "enabled",
                            "rib_route_ip": "192.168.10.253",
                            "connection": {
                                "established": 0,
                                "dropped": 0,
                                "last_reset": "never"
                            },
                            "tcp_path_mtu_discovery": "enabled",
                            "graceful_restart": "enabled",
                            "gr_restart_time": 120,
                            "gr_stalepath_time": 360,
                            "sso": False,
                            "connection_state": "closewait",
                            "io_status": 1,
                            "unread_input_bytes": 0,
                            "ecn_connection": "disabled",
                            "minimum_incoming_ttl": 0,
                            "outgoing_ttl": 1,
                            "transport": {
                                "local_host": "192.168.10.254",
                                "local_port": "26883",
                                "foreign_host": "192.168.10.253",
                                "foreign_port": "179",
                                "mss": 1460
                            },
                            "connection_tableid": 1,
                            "maximum_output_segment_queue_size": 50,
                            "enqueued_packets": {
                                "retransmit_packet": 0,
                                "input_packet": 0,
                                "mis_ordered_packet": 0
                            },
                            "iss": 168450936,
                            "snduna": 168451027,
                            "sndnxt": 168451027,
                            "irs": 3682975333,
                            "rcvnxt": 3682975411,
                            "sndwnd": 16294,
                            "snd_scale": 0,
                            "maxrcvwnd": 16384,
                            "rcvwnd": 16308,
                            "rcv_scale": 0,
                            "delrcvwnd": 76,
                            "srtt": 330,
                            "rtto": 3159,
                            "rtv": 2829,
                            "krtt": 0,
                            "min_rtt": 3,
                            "max_rtt": 1000,
                            "ack_hold": 200,
                            "uptime": 3222,
                            "sent_idletime": 3177,
                            "receive_idletime": 3178,
                            "status_flags": "active open",
                            "option_flags": "VRF id set, nagle, path mtu capable",
                            "ip_precedence_value": 6,
                            "datagram": {
                                "datagram_received": {
                                    "value": 5,
                                    "out_of_order": 0,
                                    "with_data": 2,
                                    "total_data": 76
                                },
                                "datagram_sent": {
                                    "value": 6,
                                    "retransmit": 0,
                                    "fastretransmit": 0,
                                    "partialack": 0,
                                    "second_congestion": 0,
                                    "with_data": 2,
                                    "total_data": 90
                                }
                            },
                            "packet_fast_path": 0,
                            "packet_fast_processed": 0,
                            "packet_slow_path": 0,
                            "fast_lock_acquisition_failures": 0,
                            "lock_slow_path": 0,
                            "tcp_semaphore": "0x7F2C7331EBC8",
                            "tcp_semaphore_status": "FREE"
                        },
                        "address_family": {
                            "vpnv4 unicast": {
                                "bgp_table_version": 239,
                                "neighbor_version": "1/239",
                                "output_queue_size": 0,
                                "index": 0,
                                "advertise_bit": 0,
                                "slow_peer_detection": False,
                                "slow_peer_split_update_group_dynamic": False,
                                "prefix_activity_counters": {
                                    "sent": {
                                        "prefixes_current": 0,
                                        "prefixes_total": 0,
                                        "implicit_withdraw": 0,
                                        "explicit_withdraw": 0,
                                        "used_as_bestpath": "n/a",
                                        "used_as_multipath": "n/a",
                                        "used_as_secondary": "n/a"
                                    },
                                    "received": {
                                        "prefixes_current": 0,
                                        "prefixes_total": 0,
                                        "implicit_withdraw": 0,
                                        "explicit_withdraw": 0,
                                        "used_as_bestpath": 0,
                                        "used_as_multipath": 0,
                                        "used_as_secondary": 0
                                    }
                                },
                                "local_policy_denied_prefixes_counters": {
                                    "outbound": {
                                        "total": 0
                                    },
                                    "inbound": {
                                        "total": 0
                                    }
                                },
                                "max_nlri": 0,
                                "min_nlri": 0,
                                "last_detected_dynamic_slow_peer": "never",
                                "dynamic_slow_peer_recovered": "never",
                                "refresh_epoch": 1,
                                "last_sent_refresh_start_of_rib": "never",
                                "last_sent_refresh_end_of_rib": "never",
                                "last_received_refresh_start_of_rib": "never",
                                "last_received_refresh_end_of_rib": "never",
                                "refresh_activity_counters": {
                                    "sent": {
                                        "refresh_start_of_rib": 0,
                                        "refresh_end_of_rib": 0
                                    },
                                    "received": {
                                        "refresh_start_of_rib": 0,
                                        "refresh_end_of_rib": 0
                                    }
                                },
                                "current_time": "0x65B4C8"
                            }
                        },
                        "bgp_event_timer": {
                            "starts": {
                                "retrans": 3,
                                "timewait": 0,
                                "ackhold": 2,
                                "sendwnd": 0,
                                "keepalive": 0,
                                "giveup": 0,
                                "deadwait": 0,
                                "linger": 0,
                                "processq": 0
                            },
                            "wakeups": {
                                "retrans": 0,
                                "timewait": 0,
                                "ackhold": 0,
                                "sendwnd": 0,
                                "keepalive": 0,
                                "giveup": 0,
                                "deadwait": 0,
                                "linger": 0,
                                "processq": 0
                            },
                            "next": {
                                "retrans": "0x0",
                                "timewait": "0x0",
                                "ackhold": "0x0",
                                "sendwnd": "0x0",
                                "keepalive": "0x0",
                                "giveup": "0x0",
                                "deadwait": "0x0",
                                "linger": "0x0",
                                "processq": "0x0"
                            }
                        }
                    }
                }
            }
        }
    }

    golden_output4 = {'execute.return_value': '''
        show ip bgp vpnv4 vrf CE1test neighbors
        Load for five secs: 65%/1%; one minute: 29%; five minutes: 24%
        Time source is NTP, 02:22:21.112 EST Wed Jul 17 2019

        BGP neighbor is 192.168.10.253,  vrf CE1test,  remote AS 65555, external link
          BGP version 4, remote router ID 192.168.10.253
          Session state = Closing
          Last read 00:00:03, last write 00:00:03, hold time is 90, keepalive interval is 30 seconds
          BGP multisession with 2 sessions
          Configured hold time is 90, keepalive interval is 30 seconds
          Minimum holdtime from neighbor is 15 seconds
          Neighbor sessions:
            0 active, is not multisession capable (disabled)
            Stateful switchover support enabled: NO for session 0, 0
          Message statistics for 192.168.10.253 active:
            InQ depth is 0
            OutQ depth is 0
            
                                 Sent       Rcvd
            Opens:                  1          1
            Notifications:          1          0
            Updates:                0          0
            Keepalives:             0          0
            Route Refresh:          0          0
            Total:                  2          2
          Message statistics for 192.168.10.253 passive:
            InQ depth is 0
            OutQ depth is 0
            
                                 Sent       Rcvd
            Opens:                  0          1
            Notifications:          1          0
            Updates:                0          0
            Keepalives:             0          0
            Route Refresh:          0          0
            Total:                  1          1
          Do log neighbor state changes (via global configuration)
          Default minimum time between advertisement runs is 0 seconds

         For address family: VPNv4 Unicast
          Translates address family IPv4 Unicast for VRF CE1test
          Session: 192.168.10.253 active
          BGP table version 239, neighbor version 1/239
          Output queue size : 0
          Index 0, Advertise bit 0
          session 0 member
          Overrides the neighbor AS with my AS before sending updates
          Slow-peer detection is disabled
          Slow-peer split-update-group dynamic is disabled
                                         Sent       Rcvd
          Prefix activity:               ----       ----
            Prefixes Current:               0          0
            Prefixes Total:                 0          0
            Implicit Withdraw:              0          0
            Explicit Withdraw:              0          0
            Used as bestpath:             n/a          0
            Used as multipath:            n/a          0
            Used as secondary:            n/a          0

                                           Outbound    Inbound
          Local Policy Denied Prefixes:    --------    -------
            Total:                                0          0
          Number of NLRIs in the update sent: max 0, min 0
          Last detected as dynamic slow peer: never
          Dynamic slow peer recovered: never
          Refresh Epoch: 1
          Last Sent Refresh Start-of-rib: never
          Last Sent Refresh End-of-rib: never
          Last Received Refresh Start-of-rib: never
          Last Received Refresh End-of-rib: never
                               Sent   Rcvd
            Refresh activity:          ----   ----
              Refresh Start-of-RIB          0          0
              Refresh End-of-RIB            0          0

          Address tracking is enabled, the RIB does have a route to 192.168.10.253
          Route to peer address reachability Up: 1; Down: 0
            Last notification 00:03:30
          Connections established 0; dropped 0
          Last reset never
          External BGP neighbor configured for connected checks (single-hop no-disable-connected-check)
          Interface associated: (none) (peering address in same link)
          Transport(tcp) path-mtu-discovery is enabled
          Graceful-Restart is enabled, restart-time 120 seconds, stalepath-time 360 seconds
          SSO is disabled
        Connection state is CLOSEWAIT, I/O status: 1, unread input bytes: 0            
        Connection is ECN Disabled, Mininum incoming TTL 0, Outgoing TTL 1
        Local host: 192.168.10.254, Local port: 26883
        Foreign host: 192.168.10.253, Foreign port: 179
        Connection tableid (VRF): 1
        Maximum output segment queue size: 50

        Enqueued packets for retransmit: 0, input: 0  mis-ordered: 0 (0 bytes)

        Event Timers (current time is 0x65B4C8):
        Timer          Starts    Wakeups            Next
        Retrans             3          0             0x0
        TimeWait            0          0             0x0
        AckHold             2          0             0x0
        SendWnd             0          0             0x0
        KeepAlive           0          0             0x0
        GiveUp              0          0             0x0
        PmtuAger            1          0        0x6ED083
        DeadWait            0          0             0x0
        Linger              0          0             0x0
        ProcessQ            0          0             0x0

        iss:  168450936  snduna:  168451027  sndnxt:  168451027
        irs: 3682975333  rcvnxt: 3682975411

        sndwnd:  16294  scale:      0  maxrcvwnd:  16384
        rcvwnd:  16308  scale:      0  delrcvwnd:     76

        SRTT: 330 ms, RTTO: 3159 ms, RTV: 2829 ms, KRTT: 0 ms
        minRTT: 3 ms, maxRTT: 1000 ms, ACK hold: 200 ms
        uptime: 3222 ms, Sent idletime: 3177 ms, Receive idletime: 3178 ms 
        Status Flags: active open
        Option Flags: VRF id set, nagle, path mtu capable
        IP Precedence value : 6

        Datagrams (max data segment is 1460 bytes):
        Rcvd: 5 (out of order: 0), with data: 2, total data bytes: 76
        Sent: 6 (retransmit: 0, fastretransmit: 0, partialack: 0, Second Congestion: 0), with data: 2, total data bytes: 90

         Packets received in fast path: 0, fast processed: 0, slow path: 0
         fast lock acquisition failures: 0, slow path: 0
        TCP Semaphore      0x7F2C7331EBC8  FREE 

    '''}

    golden_parsed_output5 = {
        'list_of_neighbors': ['192.168.10.254'],
        'vrf': {
            'default': {
                'neighbor': {
                    '192.168.10.254': {
                        'remote_as': 65109,
                        'link': 'external',
                        'shutdown': False,
                        'bgp_version': 4,
                        'router_id': '0.0.0.0',
                        'session_state': 'Idle',
                        'bgp_negotiated_keepalive_timers': {
                            'hold_time': 90,
                            'keepalive_interval': 30,
                            'min_holdtime': 15,
                        },
                        'bgp_neighbor_counters': {
                            'messages': {
                                'sent': {
                                    'opens': 0,
                                    'notifications': 0,
                                    'updates': 0,
                                    'keepalives': 0,
                                    'route_refresh': 0,
                                    'total': 0,
                                },
                                'received': {
                                    'opens': 0,
                                    'notifications': 0,
                                    'updates': 0,
                                    'keepalives': 0,
                                    'route_refresh': 0,
                                    'total': 0,
                                },
                                'in_queue_depth': 0,
                                'out_queue_depth': 0,
                            },
                        },
                        'bgp_session_transport': {
                            'min_time_between_advertisement_runs': 30,
                            'connection': {
                                'established': 0,
                                'dropped': 0,
                                'last_reset': 'never',
                            },
                            'tcp_connection': False,
                        },
                        'address_family': {
                            'ipv4 unicast': {
                                'bgp_table_version': 1,
                                'neighbor_version': '0/0',
                                'output_queue_size': 0,
                                'update_group_member': 0,
                                'community_attribute_sent': True,
                                'prefix_activity_counters': {
                                    'sent': {
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'implicit_withdraw': 0,
                                        'explicit_withdraw': 0,
                                        'used_as_bestpath': 'n/a',
                                        'used_as_multipath': 'n/a',
                                    },
                                    'received': {
                                        'prefixes_current': 0,
                                        'prefixes_total': 0,
                                        'implicit_withdraw': 0,
                                        'explicit_withdraw': 0,
                                        'used_as_bestpath': 0,
                                        'used_as_multipath': 0,
                                    },
                                },
                                'local_policy_denied_prefixes_counters': {
                                    'outbound': {
                                        'total': 0,
                                    },
                                    'inbound': {
                                        'total': 0,
                                    },
                                },
                                'max_nlri': 0,
                                'min_nlri': 0,
                            },
                        },
                    },
                },
            },
        },
    }
    golden_output5 = {'execute.return_value': '''
        show ip bgp neighbors 192.168.10.254
        BGP neighbor is 192.168.10.254,  remote AS 65109, external link
        BGP version 4, remote router ID 0.0.0.0
        BGP state = Idle
        Last read 00:00:00, last write 00:00:00, hold time is 180, keepalive interval is 60 seconds
        Configured hold time is 90, keepalive interval is 30 seconds
        Minimum holdtime from neighbor is 15 seconds
        Message statistics:
            InQ depth is 0
            OutQ depth is 0
                                Sent       Rcvd
            Opens:                  0          0
            Notifications:          0          0
            Updates:                0          0
            Keepalives:             0          0
            Route Refresh:          0          0
            Total:                  0          0
        Default minimum time between advertisement runs is 30 seconds

        For address family: IPv4 Unicast
        BGP table version 1, neighbor version 0/0
        Output queue size: 0
        0 update-group member
        Community attribute sent to this neighbor
        Scheduled for new neighbor index allocation
                                        Sent       Rcvd
        Prefix activity:               ----       ----
          Prefixes Current:               0          0
          Prefixes Total:                 0          0
          Implicit Withdraw:              0          0
          Explicit Withdraw:              0          0
          Used as bestpath:             n/a          0
          Used as multipath:            n/a          0

                                        Outbound    Inbound
        Local Policy Denied Prefixes:    --------    -------
          Total:                                0          0
        Number of NLRIs in the update sent: max 0, min 0

        Connections established 0; dropped 0
        Last reset never
        External BGP neighbor not directly connected.
        No active TCP connection
    '''}

    def test_show_ip_bgp_neighbors_empty(self):
        self.device = Mock(**self.empty_output)
        obj = ShowIpBgpNeighbors(device=self.device)
        with self.assertRaises(SchemaEmptyParserError):
            parsed_output = obj.parse()

    def test_show_ip_bgp_neighbors_golden1(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output1)
        obj = ShowIpBgpNeighbors(device=self.device)
        parsed_output = obj.parse(neighbor='192.168.197.254')
        self.assertEqual(parsed_output, self.golden_parsed_output1)

    def test_show_ip_bgp_neighbors_golden2(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output2)
        obj = ShowIpBgpNeighbors(device=self.device)
        parsed_output = obj.parse(address_family='ipv4 unicast')
        self.assertEqual(parsed_output, self.golden_parsed_output2)

    def test_show_ip_bgp_neighbors_golden3(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output3)
        obj = ShowIpBgpNeighbors(device=self.device)
        parsed_output = obj.parse(address_family='link-state link-state')
        self.assertEqual(parsed_output, self.golden_parsed_output3)

    def test_show_ip_bgp_neighbors_golden4(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output4)
        obj = ShowIpBgpNeighbors(device=self.device)
        parsed_output = obj.parse(address_family='vpnv4', vrf='CE1test')
        self.assertEqual(parsed_output, self.golden_parsed_output4)

    def test_show_ip_bgp_neighbors_golden5(self):
        self.maxDiff = None
        self.device = Mock(**self.golden_output5)
        obj = ShowIpBgpNeighbors(device=self.device)
        parsed_output = obj.parse(neighbor='192.168.10.254')
        self.assertEqual(parsed_output, self.golden_parsed_output5)


# ===========================================
# Unit test for:
#   * 'show ip bgp all neighbors {neighbor}'
# ===========================================
class test_show_ip_bgp_all_neighbors(unittest.TestCase):

    device = Device(name='aDevice')
    empty_output = {'execute.return_value': ''}

    golden_parsed_output1 = {
        'list_of_neighbors': ['10.1.1.1', '10.2.2.2', '172.17.111.2', '172.17.211.2'],
        'vrf': 
            {'VRF100': 
                {'neighbor': {'172.17.111.2': {'address_family': {'vpnv4 unicast': {'advertise_bit': 0,
                                                                                       'bgp_table_version': 21,
                                                                                       'current_time': '0x197E192D',
                                                                                       'dynamic_slow_peer_recovered': 'never',
                                                                                       'index': 1,
                                                                                       'last_detected_dynamic_slow_peer': 'never',
                                                                                       'last_read': '00:00:18',
                                                                                       'last_received_refresh_end_of_rib': 'never',
                                                                                       'last_received_refresh_start_of_rib': 'never',
                                                                                       'last_sent_refresh_end_of_rib': 'never',
                                                                                       'last_sent_refresh_start_of_rib': 'never',
                                                                                       'last_write': '00:00:46',
                                                                                       'local_policy_denied_prefixes_counters': {'inbound': {'bestpath_from_this_peer': 'n/a',
                                                                                                                                             'total': 0},
                                                                                                                                 'outbound': {'bestpath_from_this_peer': 2,
                                                                                                                                              'total': 2}},
                                                                                       'max_nlri': 1,
                                                                                       'min_nlri': 0,
                                                                                       'neighbor_version': '21/0',
                                                                                       'output_queue_size': 0,
                                                                                       'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                                 'implicit_withdraw': 0,
                                                                                                                                 'prefixes_total': 1,
                                                                                                                                 'used_as_bestpath': 1,
                                                                                                                                 'used_as_multipath': 0,
                                                                                                                                 'used_as_secondary': 0},
                                                                                                                    'sent': {'explicit_withdraw': 0,
                                                                                                                             'implicit_withdraw': 3,
                                                                                                                             'prefixes_total': 6,
                                                                                                                             'used_as_bestpath': 'n/a',
                                                                                                                             'used_as_multipath': 'n/a',
                                                                                                                             'used_as_secondary': 'n/a'}},
                                                                                       'refresh_activity_counters': {'received': {'refresh_end_of_rib': 0,
                                                                                                                                  'refresh_start_of_rib': 0},
                                                                                                                     'sent': {'refresh_end_of_rib': 0,
                                                                                                                              'refresh_start_of_rib': 0}},
                                                                                       'refresh_epoch': 1,
                                                                                       'session_state': 'Established',
                                                                                       'slow_peer_detection': False,
                                                                                       'slow_peer_split_update_group_dynamic': False,
                                                                                       'up_time': '4d22h',
                                                                                       'update_group_member': 1}},
                                                  'bgp_event_timer': {'next': {'ackhold': '0x0',
                                                                               'deadwait': '0x0',
                                                                               'giveup': '0x0',
                                                                               'keepalive': '0x0',
                                                                               'linger': '0x0',
                                                                               'pmtuager': '0x0',
                                                                               'processq': '0x0',
                                                                               'retrans': '0x0',
                                                                               'sendwnd': '0x0',
                                                                               'timewait': '0x0'},
                                                                      'starts': {'ackhold': 7837,
                                                                                 'deadwait': 0,
                                                                                 'giveup': 0,
                                                                                 'keepalive': 0,
                                                                                 'linger': 0,
                                                                                 'pmtuager': 0,
                                                                                 'processq': 0,
                                                                                 'retrans': 7842,
                                                                                 'sendwnd': 0,
                                                                                 'timewait': 0},
                                                                      'wakeups': {'ackhold': 7720,
                                                                                  'deadwait': 0,
                                                                                  'giveup': 0,
                                                                                  'keepalive': 0,
                                                                                  'linger': 0,
                                                                                  'pmtuager': 0,
                                                                                  'processq': 0,
                                                                                  'retrans': 1,
                                                                                  'sendwnd': 0,
                                                                                  'timewait': 0}},
                                                                                  'bgp_neighbor_session': {
                                                                                    'sessions': 1,
                                                                                    },
                                                  'bgp_negotiated_capabilities': {'enhanced_refresh': 'advertised '
                                                                                                      'and '
                                                                                                      'received',
                                                                                  'four_octets_asn': 'advertised '
                                                                                                     'and '
                                                                                                     'received',
                                                                                  'ipv4_unicast': 'advertised '
                                                                                                  'and '
                                                                                                  'received',
                                                                                  'route_refresh': 'advertised '
                                                                                                   'and '
                                                                                                   'received(new)',
                                                                                  'stateful_switchover': 'NO '
                                                                                                         'for '
                                                                                                         'session '
                                                                                                         '1'},
                                                  'bgp_negotiated_keepalive_timers': {'hold_time': 180,
                                                                                      'keepalive_interval': 60},
                                                  'bgp_neighbor_counters': {'messages': {'in_queue_depth': 0,
                                                                                         'out_queue_depth': 0,
                                                                                         'received': {'keepalives': 7835,
                                                                                                      'notifications': 0,
                                                                                                      'opens': 1,
                                                                                                      'route_refresh': 0,
                                                                                                      'total': 7838,
                                                                                                      'updates': 2},
                                                                                         'sent': {'keepalives': 7835,
                                                                                                  'notifications': 0,
                                                                                                  'opens': 1,
                                                                                                  'route_refresh': 0,
                                                                                                  'total': 7843,
                                                                                                  'updates': 7}}},
                                                  'bgp_session_transport': {'ack_hold': 200,
                                                                            'address_tracking_status': 'enabled',
                                                                            'connection': {'dropped': 0,
                                                                                           'established': 1,
                                                                                           'last_reset': 'never'},
                                                                            'connection_state': 'estab',
                                                                            'connection_tableid': 1,
                                                                            'datagram': {'datagram_received': {'out_of_order': 0,
                                                                                                               'total_data': 148999,
                                                                                                               'value': 15638,
                                                                                                               'with_data': 7837},
                                                                                         'datagram_sent': {'fastretransmit': 0,
                                                                                                           'partialack': 0,
                                                                                                           'retransmit': 1,
                                                                                                           'second_congestion': 0,
                                                                                                           'total_data': 149249,
                                                                                                           'value': 15664,
                                                                                                           'with_data': 7841}},
                                                                            'delrcvwnd': 1235,
                                                                            'ecn_connection': 'disabled',
                                                                            'enqueued_packets': {'input_packet': 0,
                                                                                                 'mis_ordered_packet': 0,
                                                                                                 'retransmit_packet': 0},
                                                                            'fast_lock_acquisition_failures': 0,
                                                                            'graceful_restart': 'disabled',
                                                                            'io_status': 1,
                                                                            'ip_precedence_value': 6,
                                                                            'irs': 3629657489,
                                                                            'iss': 3636194669,
                                                                            'krtt': 0,
                                                                            'lock_slow_path': 0,
                                                                            'max_rtt': 1000,
                                                                            'maximum_output_segment_queue_size': 50,
                                                                            'maxrcvwnd': 16384,
                                                                            'min_rtt': 1,
                                                                            'min_time_between_advertisement_runs': 0,
                                                                            'minimum_incoming_ttl': 0,
                                                                            'option_flags': 'VRF '
                                                                                            'id '
                                                                                            'set, '
                                                                                            'nagle, '
                                                                                            'path '
                                                                                            'mtu '
                                                                                            'capable',
                                                                            'outgoing_ttl': 1,
                                                                            'packet_fast_path': 0,
                                                                            'packet_fast_processed': 0,
                                                                            'packet_slow_path': 0,
                                                                            'rcv_scale': 0,
                                                                            'rcvnxt': 3629806489,
                                                                            'rcvwnd': 15149,
                                                                            'receive_idletime': 18940,
                                                                            'rib_route_ip': '172.17.111.2',
                                                                            'rtto': 1003,
                                                                            'rtv': 3,
                                                                            'sent_idletime': 18740,
                                                                            'snd_scale': 0,
                                                                            'sndnxt': 3636343919,
                                                                            'snduna': 3636343919,
                                                                            'sndwnd': 16365,
                                                                            'srtt': 1000,
                                                                            'sso': False,
                                                                            'status_flags': 'passive '
                                                                                            'open, '
                                                                                            'gen '
                                                                                            'tcbs',
                                                                            'tcp_path_mtu_discovery': 'enabled',
                                                                            'tcp_semaphore': '0x7F59978AAF50',
                                                                            'tcp_semaphore_status': 'FREE',
                                                                            'transport': {'foreign_host': '172.17.111.2',
                                                                                          'foreign_port': '14223',
                                                                                          'local_host': '172.17.111.1',
                                                                                          'local_port': '179',
                                                                                          'mss': 1460},
                                                                            'unread_input_bytes': 0,
                                                                            'uptime': 427542926},
                                                  'bgp_version': 4,
                                                  'link': 'external',
                                                  'remote_as': 65001,
                                                  'router_id': '172.16.1.156',
                                                  'session_state': 'Established',
                                                  'shutdown': False}}},
         'VRF200': {'neighbor': {'172.17.211.2': {'address_family': {'vpnv4 unicast': {'advertise_bit': 0,
                                                                                       'bgp_table_version': 21,
                                                                                       'current_time': '0x197E19C1',
                                                                                       'dynamic_slow_peer_recovered': 'never',
                                                                                       'index': 2,
                                                                                       'last_detected_dynamic_slow_peer': 'never',
                                                                                       'last_read': '00:00:00',
                                                                                       'last_received_refresh_end_of_rib': 'never',
                                                                                       'last_received_refresh_start_of_rib': 'never',
                                                                                       'last_sent_refresh_end_of_rib': 'never',
                                                                                       'last_sent_refresh_start_of_rib': 'never',
                                                                                       'last_write': '00:00:45',
                                                                                       'local_policy_denied_prefixes_counters': {'inbound': {'bestpath_from_this_peer': 'n/a',
                                                                                                                                             'total': 0},
                                                                                                                                 'outbound': {'bestpath_from_this_peer': 2,
                                                                                                                                              'total': 2}},
                                                                                       'max_nlri': 1,
                                                                                       'min_nlri': 0,
                                                                                       'neighbor_version': '21/0',
                                                                                       'output_queue_size': 0,
                                                                                       'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                                 'implicit_withdraw': 0,
                                                                                                                                 'prefixes_total': 1,
                                                                                                                                 'used_as_bestpath': 1,
                                                                                                                                 'used_as_multipath': 0,
                                                                                                                                 'used_as_secondary': 0},
                                                                                                                    'sent': {'explicit_withdraw': 0,
                                                                                                                             'implicit_withdraw': 3,
                                                                                                                             'prefixes_total': 6,
                                                                                                                             'used_as_bestpath': 'n/a',
                                                                                                                             'used_as_multipath': 'n/a',
                                                                                                                             'used_as_secondary': 'n/a'}},
                                                                                       'refresh_activity_counters': {'received': {'refresh_end_of_rib': 0,
                                                                                                                                  'refresh_start_of_rib': 0},
                                                                                                                     'sent': {'refresh_end_of_rib': 0,
                                                                                                                              'refresh_start_of_rib': 0}},
                                                                                       'refresh_epoch': 1,
                                                                                       'session_state': 'Established',
                                                                                       'slow_peer_detection': False,
                                                                                       'slow_peer_split_update_group_dynamic': False,
                                                                                       'up_time': '4d22h',
                                                                                       'update_group_member': 2}},
                                                  'bgp_event_timer': {'next': {'ackhold': '0x0',
                                                                               'deadwait': '0x0',
                                                                               'giveup': '0x0',
                                                                               'keepalive': '0x0',
                                                                               'linger': '0x0',
                                                                               'processq': '0x0',
                                                                               'retrans': '0x0',
                                                                               'sendwnd': '0x0',
                                                                               'timewait': '0x0'},
                                                                      'starts': {'ackhold': 7835,
                                                                                 'deadwait': 0,
                                                                                 'giveup': 0,
                                                                                 'keepalive': 0,
                                                                                 'linger': 0,
                                                                                 'processq': 0,
                                                                                 'retrans': 7847,
                                                                                 'sendwnd': 0,
                                                                                 'timewait': 0},
                                                                      'wakeups': {'ackhold': 7721,
                                                                                  'deadwait': 0,
                                                                                  'giveup': 0,
                                                                                  'keepalive': 0,
                                                                                  'linger': 0,
                                                                                  'processq': 0,
                                                                                  'retrans': 1,
                                                                                  'sendwnd': 0,
                                                                                  'timewait': 0}},
                                                                                  'bgp_neighbor_session': {
                    'sessions': 1,
                    },
                                                  'bgp_negotiated_capabilities': {'enhanced_refresh': 'advertised '
                                                                                                      'and '
                                                                                                      'received',
                                                                                  'four_octets_asn': 'advertised '
                                                                                                     'and '
                                                                                                     'received',
                                                                                  'ipv4_unicast': 'advertised '
                                                                                                  'and '
                                                                                                  'received',
                                                                                  'route_refresh': 'advertised '
                                                                                                   'and '
                                                                                                   'received(new)',
                                                                                  'stateful_switchover': 'NO '
                                                                                                         'for '
                                                                                                         'session '
                                                                                                         '1'},
                                                  'bgp_negotiated_keepalive_timers': {'hold_time': 180,
                                                                                      'keepalive_interval': 60},
                                                  'bgp_neighbor_counters': {'messages': {'in_queue_depth': 0,
                                                                                         'out_queue_depth': 0,
                                                                                         'received': {'keepalives': 7834,
                                                                                                      'notifications': 0,
                                                                                                      'opens': 1,
                                                                                                      'route_refresh': 0,
                                                                                                      'total': 7837,
                                                                                                      'updates': 2},
                                                                                         'sent': {'keepalives': 7839,
                                                                                                  'notifications': 0,
                                                                                                  'opens': 1,
                                                                                                  'route_refresh': 0,
                                                                                                  'total': 7847,
                                                                                                  'updates': 7}}},
                                                  'bgp_session_transport': {'ack_hold': 200,
                                                                            'address_tracking_status': 'enabled',
                                                                            'connection': {'dropped': 0,
                                                                                           'established': 1,
                                                                                           'last_reset': 'never'},
                                                                            'connection_state': 'estab',
                                                                            'connection_tableid': 2,
                                                                            'datagram': {'datagram_received': {'out_of_order': 0,
                                                                                                               'total_data': 148980,
                                                                                                               'value': 15637,
                                                                                                               'with_data': 7836},
                                                                                         'datagram_sent': {'fastretransmit': 0,
                                                                                                           'partialack': 0,
                                                                                                           'retransmit': 1,
                                                                                                           'second_congestion': 0,
                                                                                                           'total_data': 149325,
                                                                                                           'value': 15671,
                                                                                                           'with_data': 7845}},
                                                                            'delrcvwnd': 1216,
                                                                            'ecn_connection': 'disabled',
                                                                            'enqueued_packets': {'input_packet': 0,
                                                                                                 'mis_ordered_packet': 0,
                                                                                                 'retransmit_packet': 0},
                                                                            'fast_lock_acquisition_failures': 0,
                                                                            'graceful_restart': 'disabled',
                                                                            'io_status': 1,
                                                                            'ip_precedence_value': 6,
                                                                            'irs': 950953285,
                                                                            'iss': 3848368441,
                                                                            'krtt': 0,
                                                                            'lock_slow_path': 0,
                                                                            'max_rtt': 1000,
                                                                            'maximum_output_segment_queue_size': 50,
                                                                            'maxrcvwnd': 16384,
                                                                            'min_rtt': 1,
                                                                            'min_time_between_advertisement_runs': 0,
                                                                            'minimum_incoming_ttl': 0,
                                                                            'option_flags': 'VRF '
                                                                                            'id '
                                                                                            'set, '
                                                                                            'nagle, '
                                                                                            'path '
                                                                                            'mtu '
                                                                                            'capable',
                                                                            'outgoing_ttl': 1,
                                                                            'packet_fast_path': 0,
                                                                            'packet_fast_processed': 0,
                                                                            'packet_slow_path': 0,
                                                                            'rcv_scale': 0,
                                                                            'rcvnxt': 951102266,
                                                                            'rcvwnd': 15168,
                                                                            'receive_idletime': 580,
                                                                            'rib_route_ip': '172.17.211.2',
                                                                            'rtto': 1003,
                                                                            'rtv': 3,
                                                                            'sent_idletime': 321,
                                                                            'snd_scale': 0,
                                                                            'sndnxt': 3848517767,
                                                                            'snduna': 3848517767,
                                                                            'sndwnd': 16289,
                                                                            'srtt': 1000,
                                                                            'sso': False,
                                                                            'status_flags': 'active '
                                                                                            'open',
                                                                            'tcp_path_mtu_discovery': 'enabled',
                                                                            'tcp_semaphore': '0x7F59978AAE80',
                                                                            'tcp_semaphore_status': 'FREE',
                                                                            'transport': {'foreign_host': '172.17.211.2',
                                                                                          'foreign_port': '179',
                                                                                          'local_host': '172.17.211.1',
                                                                                          'local_port': '48585',
                                                                                          'mss': 1460},
                                                                            'unread_input_bytes': 0,
                                                                            'uptime': 427538469},
                                                  'bgp_version': 4,
                                                  'link': 'external',
                                                  'remote_as': 65001,
                                                  'router_id': '172.16.1.156',
                                                  'session_state': 'Established',
                                                  'shutdown': False}}},
         'default': {'neighbor': {'10.1.1.1': {'address_family': {'ipv4 unicast': {'advertise_bit': 0,
                                                                                   'bgp_table_version': 1,
                                                                                   'dynamic_slow_peer_recovered': 'never',
                                                                                   'index': 1,
                                                                                   'last_detected_dynamic_slow_peer': 'never',
                                                                                   'last_received_refresh_end_of_rib': 'never',
                                                                                   'last_received_refresh_start_of_rib': 'never',
                                                                                   'last_sent_refresh_end_of_rib': 'never',
                                                                                   'last_sent_refresh_start_of_rib': 'never',
                                                                                   'local_policy_denied_prefixes_counters': {'inbound': {'total': 0},
                                                                                                                             'outbound': {'total': 0}},
                                                                                   'max_nlri': 0,
                                                                                   'min_nlri': 0,
                                                                                   'neighbor_version': '1/0',
                                                                                   'output_queue_size': 0,
                                                                                   'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                             'implicit_withdraw': 0,
                                                                                                                             'prefixes_current': 0,
                                                                                                                             'prefixes_total': 0,
                                                                                                                             'used_as_bestpath': 0,
                                                                                                                             'used_as_multipath': 0,
                                                                                                                             'used_as_secondary': 0},
                                                                                                                'sent': {'explicit_withdraw': 0,
                                                                                                                         'implicit_withdraw': 0,
                                                                                                                         'prefixes_current': 0,
                                                                                                                         'prefixes_total': 0,
                                                                                                                         'used_as_bestpath': 'n/a',
                                                                                                                         'used_as_multipath': 'n/a',
                                                                                                                         'used_as_secondary': 'n/a'}},
                                                                                   'refresh_activity_counters': {'received': {'refresh_end_of_rib': 0,
                                                                                                                              'refresh_start_of_rib': 0},
                                                                                                                 'sent': {'refresh_end_of_rib': 0,
                                                                                                                          'refresh_start_of_rib': 0}},
                                                                                   'refresh_epoch': 1,
                                                                                   'slow_peer_detection': False,
                                                                                   'slow_peer_split_update_group_dynamic': False,
                                                                                   'update_group_member': 1},
                                                                  'vpnv4 unicast': {'advertise_bit': 1,
                                                                                    'bgp_table_version': 21,
                                                                                    'current_time': '0x197E167D',
                                                                                    'dynamic_slow_peer_recovered': 'never',
                                                                                    'extended_community_attribute_sent': True,
                                                                                    'index': 3,
                                                                                    'last_detected_dynamic_slow_peer': 'never',
                                                                                    'last_received_refresh_end_of_rib': 'never',
                                                                                    'last_received_refresh_start_of_rib': 'never',
                                                                                    'last_sent_refresh_end_of_rib': 'never',
                                                                                    'last_sent_refresh_start_of_rib': 'never',
                                                                                    'local_policy_denied_prefixes_counters': {'inbound': {'af_permit_check': 'n/a',
                                                                                                                                          'bestpath_from_ibgp_peer': 'n/a',
                                                                                                                                          'bestpath_from_this_peer': 'n/a',
                                                                                                                                          'originator_loop': 8,
                                                                                                                                          'total': 8},
                                                                                                                              'outbound': {'af_permit_check': 4,
                                                                                                                                           'bestpath_from_ibgp_peer': 4,
                                                                                                                                           'bestpath_from_this_peer': 4,
                                                                                                                                           'originator_loop': 'n/a',
                                                                                                                                           'total': 12}},
                                                                                    'max_nlri': 1,
                                                                                    'min_nlri': 0,
                                                                                    'neighbor_version': '21/0',
                                                                                    'output_queue_size': 0,
                                                                                    'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                              'implicit_withdraw': 0,
                                                                                                                              'prefixes_total': 4,
                                                                                                                              'used_as_bestpath': 4,
                                                                                                                              'used_as_multipath': 0,
                                                                                                                              'used_as_secondary': 0},
                                                                                                                 'sent': {'explicit_withdraw': 0,
                                                                                                                          'implicit_withdraw': 4,
                                                                                                                          'prefixes_total': 8,
                                                                                                                          'used_as_bestpath': 'n/a',
                                                                                                                          'used_as_multipath': 'n/a',
                                                                                                                          'used_as_secondary': 'n/a'}},
                                                                                    'refresh_activity_counters': {'received': {'refresh_end_of_rib': 0,
                                                                                                                               'refresh_start_of_rib': 0},
                                                                                                                  'sent': {'refresh_end_of_rib': 0,
                                                                                                                           'refresh_start_of_rib': 0}},
                                                                                    'refresh_epoch': 1,
                                                                                    'slow_peer_detection': False,
                                                                                    'slow_peer_split_update_group_dynamic': False,
                                                                                    'update_group_member': 3}},
                                               'bgp_event_timer': {'next': {'ackhold': '0x0',
                                                                            'deadwait': '0x0',
                                                                            'giveup': '0x0',
                                                                            'keepalive': '0x0',
                                                                            'linger': '0x0',
                                                                            'pmtuager': '0x0',
                                                                            'processq': '0x0',
                                                                            'retrans': '0x0',
                                                                            'sendwnd': '0x0',
                                                                            'timewait': '0x0'},
                                                                   'starts': {'ackhold': 7852,
                                                                              'deadwait': 0,
                                                                              'giveup': 0,
                                                                              'keepalive': 0,
                                                                              'linger': 0,
                                                                              'pmtuager': 0,
                                                                              'processq': 0,
                                                                              'retrans': 7851,
                                                                              'sendwnd': 0,
                                                                              'timewait': 0},
                                                                   'wakeups': {'ackhold': 7671,
                                                                               'deadwait': 0,
                                                                               'giveup': 0,
                                                                               'keepalive': 0,
                                                                               'linger': 0,
                                                                               'pmtuager': 0,
                                                                               'processq': 0,
                                                                               'retrans': 0,
                                                                               'sendwnd': 0,
                                                                               'timewait': 0}},
                                                                               'bgp_neighbor_session': {
                                                                        'sessions': 1,
                                                                        },
                                               'bgp_negotiated_capabilities': {'enhanced_refresh': 'advertised '
                                                                                                   'and '
                                                                                                   'received',
                                                                               'four_octets_asn': 'advertised '
                                                                                                  'and '
                                                                                                  'received',
                                                                               'ipv4_unicast': 'advertised '
                                                                                               'and '
                                                                                               'received',
                                                                               'route_refresh': 'advertised '
                                                                                                'and '
                                                                                                'received(new)',
                                                                               'stateful_switchover': 'NO '
                                                                                                      'for '
                                                                                                      'session '
                                                                                                      '1',
                                                                               'vpnv4_unicast': 'advertised '
                                                                                                'and '
                                                                                                'received'},
                                               'bgp_negotiated_keepalive_timers': {'hold_time': 180,
                                                                                   'keepalive_interval': 60},
                                               'bgp_neighbor_counters': {'messages': {'in_queue_depth': 0,
                                                                                      'out_queue_depth': 0,
                                                                                      'received': {'keepalives': 7849,
                                                                                                   'notifications': 0,
                                                                                                   'opens': 1,
                                                                                                   'route_refresh': 0,
                                                                                                   'total': 7864,
                                                                                                   'updates': 14},
                                                                                      'sent': {'keepalives': 7847,
                                                                                               'notifications': 0,
                                                                                               'opens': 1,
                                                                                               'route_refresh': 0,
                                                                                               'total': 7858,
                                                                                               'updates': 10}}},
                                               'bgp_session_transport': {'ack_hold': 200,
                                                                         'address_tracking_status': 'enabled',
                                                                         'connection': {'dropped': 0,
                                                                                        'established': 1,
                                                                                        'last_reset': 'never'},
                                                                         'connection_state': 'estab',
                                                                         'connection_tableid': 0,
                                                                         'datagram': {'datagram_received': {'out_of_order': 0,
                                                                                                            'total_data': 150532,
                                                                                                            'value': 15669,
                                                                                                            'with_data': 7853},
                                                                                      'datagram_sent': {'fastretransmit': 0,
                                                                                                        'partialack': 0,
                                                                                                        'retransmit': 0,
                                                                                                        'second_congestion': 0,
                                                                                                        'total_data': 149954,
                                                                                                        'value': 15633,
                                                                                                        'with_data': 7852}},
                                                                         'delrcvwnd': 19,
                                                                         'ecn_connection': 'disabled',
                                                                         'enqueued_packets': {'input_packet': 0,
                                                                                              'mis_ordered_packet': 0,
                                                                                              'retransmit_packet': 0},
                                                                         'fast_lock_acquisition_failures': 0,
                                                                         'graceful_restart': 'disabled',
                                                                         'io_status': 1,
                                                                         'ip_precedence_value': 6,
                                                                         'irs': 547332975,
                                                                         'iss': 3484933877,
                                                                         'krtt': 0,
                                                                         'lock_slow_path': 0,
                                                                         'max_rtt': 1000,
                                                                         'maximum_output_segment_queue_size': 50,
                                                                         'maxrcvwnd': 16384,
                                                                         'min_rtt': 1,
                                                                         'min_time_between_advertisement_runs': 0,
                                                                         'minimum_incoming_ttl': 0,
                                                                         'option_flags': 'nagle, '
                                                                                         'path '
                                                                                         'mtu '
                                                                                         'capable',
                                                                         'outgoing_ttl': 255,
                                                                         'packet_fast_path': 0,
                                                                         'packet_fast_processed': 0,
                                                                         'packet_slow_path': 0,
                                                                         'rcv_scale': 0,
                                                                         'rcvnxt': 547483508,
                                                                         'rcvwnd': 16365,
                                                                         'receive_idletime': 20991,
                                                                         'rib_route_ip': '10.1.1.1',
                                                                         'rtto': 1003,
                                                                         'rtv': 3,
                                                                         'sent_idletime': 21193,
                                                                         'snd_scale': 0,
                                                                         'sndnxt': 3485083832,
                                                                         'snduna': 3485083832,
                                                                         'sndwnd': 15472,
                                                                         'srtt': 1000,
                                                                         'sso': False,
                                                                         'status_flags': 'passive '
                                                                                         'open, '
                                                                                         'gen '
                                                                                         'tcbs',
                                                                         'tcp_path_mtu_discovery': 'enabled',
                                                                         'tcp_semaphore': '0x7F59978AAB40',
                                                                         'tcp_semaphore_status': 'FREE',
                                                                         'transport': {'foreign_host': '10.1.1.1',
                                                                                       'foreign_port': '44730',
                                                                                       'local_host': '10.5.5.5',
                                                                                       'local_port': '179',
                                                                                       'mss': 1396},
                                                                         'unread_input_bytes': 0,
                                                                         'uptime': 427481259},
                                               'bgp_version': 4,
                                               'link': 'internal',
                                               'remote_as': 65000,
                                               'router_id': '10.1.1.1',
                                               'session_state': 'Established',
                                               'shutdown': False},
                                  '10.2.2.2': {'address_family': {'ipv4 unicast': {'advertise_bit': 0,
                                                                                   'bgp_table_version': 1,
                                                                                   'dynamic_slow_peer_recovered': 'never',
                                                                                   'index': 1,
                                                                                   'last_detected_dynamic_slow_peer': 'never',
                                                                                   'last_received_refresh_end_of_rib': 'never',
                                                                                   'last_received_refresh_start_of_rib': 'never',
                                                                                   'last_sent_refresh_end_of_rib': 'never',
                                                                                   'last_sent_refresh_start_of_rib': 'never',
                                                                                   'local_policy_denied_prefixes_counters': {'inbound': {'total': 0},
                                                                                                                             'outbound': {'total': 0}},
                                                                                   'max_nlri': 0,
                                                                                   'min_nlri': 0,
                                                                                   'neighbor_version': '1/0',
                                                                                   'output_queue_size': 0,
                                                                                   'prefix_activity_counters': {'received': {'explicit_withdraw': 0,
                                                                                                                             'implicit_withdraw': 0,
                                                                                                                             'prefixes_current': 0,
                                                                                                                             'prefixes_total': 0,
                                                                                                                             'used_as_bestpath': 0,
                                                                                                                             'used_as_multipath': 0,
                                                                                                                             'used_as_secondary': 0},
                                                                                                                'sent': {'explicit_withdraw': 0,
                                                                                                                         'implicit_withdraw': 0,
                                                                                                                         'prefixes_current': 0,
                                                                                                                         'prefixes_total': 0,
                                                                                                                         'used_as_bestpath': 'n/a',
                              