import pandas as pd

from .base_operation import BaseOperation


class RecordCount(BaseOperation):
    def _execute_operation(self) -> pd.Series:
        """
        Returns number of records in the dataset as pd.Series like:
        0    5
        1    5
        2    5
        3    5
        4    5
        dtype: int64
        """
        record_count: int = len(self.params.dataframe)
        return pd.Series([record_count] * record_count)
