#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Jan 31 15:52:45 2013 by generateDS.py version 2.8b.
#

import sys
import getopt
import re as re_
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = list(range(3))
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, str) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, str) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class scpd(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, specVersion=None, actionList=None, serviceStateTable=None):
        self.specVersion = specVersion
        self.actionList = actionList
        self.serviceStateTable = serviceStateTable
    def factory(*args_, **kwargs_):
        if scpd.subclass:
            return scpd.subclass(*args_, **kwargs_)
        else:
            return scpd(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_specVersion(self): return self.specVersion
    def set_specVersion(self, specVersion): self.specVersion = specVersion
    def get_actionList(self): return self.actionList
    def set_actionList(self, actionList): self.actionList = actionList
    def get_serviceStateTable(self): return self.serviceStateTable
    def set_serviceStateTable(self, serviceStateTable): self.serviceStateTable = serviceStateTable
    def export(self, outfile, level, namespace_='', name_='scpd', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scpd')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='scpd'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='scpd', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.specVersion is not None:
            self.specVersion.export(outfile, level, namespace_, name_='specVersion', pretty_print=pretty_print)
        if self.actionList is not None:
            self.actionList.export(outfile, level, namespace_, name_='actionList', pretty_print=pretty_print)
        if self.serviceStateTable is not None:
            self.serviceStateTable.export(outfile, level, namespace_, name_='serviceStateTable', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.specVersion is not None or
            self.actionList is not None or
            self.serviceStateTable is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='scpd'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.specVersion is not None:
            showIndent(outfile, level)
            outfile.write('specVersion=model_.SpecVersionType(\n')
            self.specVersion.exportLiteral(outfile, level, name_='specVersion')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.actionList is not None:
            showIndent(outfile, level)
            outfile.write('actionList=model_.ActionListType(\n')
            self.actionList.exportLiteral(outfile, level, name_='actionList')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.serviceStateTable is not None:
            showIndent(outfile, level)
            outfile.write('serviceStateTable=model_.ServiceStateTableType(\n')
            self.serviceStateTable.exportLiteral(outfile, level, name_='serviceStateTable')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'specVersion':
            obj_ = SpecVersionType.factory()
            obj_.build(child_)
            self.set_specVersion(obj_)
        elif nodeName_ == 'actionList':
            obj_ = ActionListType.factory()
            obj_.build(child_)
            self.set_actionList(obj_)
        elif nodeName_ == 'serviceStateTable':
            obj_ = ServiceStateTableType.factory()
            obj_.build(child_)
            self.set_serviceStateTable(obj_)
# end class scpd


class SpecVersionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, major=None, minor=None):
        self.major = major
        self.minor = minor
    def factory(*args_, **kwargs_):
        if SpecVersionType.subclass:
            return SpecVersionType.subclass(*args_, **kwargs_)
        else:
            return SpecVersionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_major(self): return self.major
    def set_major(self, major): self.major = major
    def get_minor(self): return self.minor
    def set_minor(self, minor): self.minor = minor
    def export(self, outfile, level, namespace_='', name_='SpecVersionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpecVersionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpecVersionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SpecVersionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.major is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smajor>%s</%smajor>%s' % (namespace_, self.gds_format_integer(self.major, input_name='major'), namespace_, eol_))
        if self.minor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sminor>%s</%sminor>%s' % (namespace_, self.gds_format_integer(self.minor, input_name='minor'), namespace_, eol_))
    def hasContent_(self):
        if (
            self.major is not None or
            self.minor is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SpecVersionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.major is not None:
            showIndent(outfile, level)
            outfile.write('major=%d,\n' % self.major)
        if self.minor is not None:
            showIndent(outfile, level)
            outfile.write('minor=%d,\n' % self.minor)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'major':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'major')
            self.major = ival_
        elif nodeName_ == 'minor':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'minor')
            self.minor = ival_
# end class SpecVersionType


class ActionListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, action=None):
        if action is None:
            self.action = []
        else:
            self.action = action
    def factory(*args_, **kwargs_):
        if ActionListType.subclass:
            return ActionListType.subclass(*args_, **kwargs_)
        else:
            return ActionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_action(self): return self.action
    def set_action(self, action): self.action = action
    def add_action(self, value): self.action.append(value)
    def insert_action(self, index, value): self.action[index] = value
    def export(self, outfile, level, namespace_='', name_='ActionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ActionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ActionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for action_ in self.action:
            action_.export(outfile, level, namespace_, name_='action', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.action
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('action=[\n')
        level += 1
        for action_ in self.action:
            showIndent(outfile, level)
            outfile.write('model_.ActionType(\n')
            action_.exportLiteral(outfile, level, name_='ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'action':
            obj_ = ActionType.factory()
            obj_.build(child_)
            self.action.append(obj_)
# end class ActionListType


class ActionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, argumentList=None):
        self.name = name
        self.argumentList = argumentList
    def factory(*args_, **kwargs_):
        if ActionType.subclass:
            return ActionType.subclass(*args_, **kwargs_)
        else:
            return ActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_argumentList(self): return self.argumentList
    def set_argumentList(self, argumentList): self.argumentList = argumentList
    def export(self, outfile, level, namespace_='', name_='ActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ActionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.argumentList is not None:
            self.argumentList.export(outfile, level, namespace_, name_='argumentList', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.name is not None or
            self.argumentList is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.argumentList is not None:
            showIndent(outfile, level)
            outfile.write('argumentList=model_.ArgumentListType(\n')
            self.argumentList.exportLiteral(outfile, level, name_='argumentList')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'argumentList':
            obj_ = ArgumentListType.factory()
            obj_.build(child_)
            self.set_argumentList(obj_)
# end class ActionType


class ArgumentListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, argument=None):
        if argument is None:
            self.argument = []
        else:
            self.argument = argument
    def factory(*args_, **kwargs_):
        if ArgumentListType.subclass:
            return ArgumentListType.subclass(*args_, **kwargs_)
        else:
            return ArgumentListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_argument(self): return self.argument
    def set_argument(self, argument): self.argument = argument
    def add_argument(self, value): self.argument.append(value)
    def insert_argument(self, index, value): self.argument[index] = value
    def export(self, outfile, level, namespace_='', name_='ArgumentListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArgumentListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ArgumentListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ArgumentListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for argument_ in self.argument:
            argument_.export(outfile, level, namespace_, name_='argument', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.argument
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ArgumentListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('argument=[\n')
        level += 1
        for argument_ in self.argument:
            showIndent(outfile, level)
            outfile.write('model_.ArgumentType(\n')
            argument_.exportLiteral(outfile, level, name_='ArgumentType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'argument':
            obj_ = ArgumentType.factory()
            obj_.build(child_)
            self.argument.append(obj_)
# end class ArgumentListType


class ArgumentType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, direction=None, relatedStateVariable=None, retval=None):
        self.name = name
        self.direction = direction
        self.relatedStateVariable = relatedStateVariable
        self.retval = retval
    def factory(*args_, **kwargs_):
        if ArgumentType.subclass:
            return ArgumentType.subclass(*args_, **kwargs_)
        else:
            return ArgumentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_direction(self): return self.direction
    def set_direction(self, direction): self.direction = direction
    def get_relatedStateVariable(self): return self.relatedStateVariable
    def set_relatedStateVariable(self, relatedStateVariable): self.relatedStateVariable = relatedStateVariable
    def get_retval(self): return self.retval
    def set_retval(self, retval): self.retval = retval
    def export(self, outfile, level, namespace_='', name_='ArgumentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArgumentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ArgumentType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ArgumentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.direction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdirection>%s</%sdirection>%s' % (namespace_, self.gds_format_string(quote_xml(self.direction).encode(ExternalEncoding), input_name='direction'), namespace_, eol_))
        if self.relatedStateVariable is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srelatedStateVariable>%s</%srelatedStateVariable>%s' % (namespace_, self.gds_format_string(quote_xml(self.relatedStateVariable).encode(ExternalEncoding), input_name='relatedStateVariable'), namespace_, eol_))
        if self.retval is not None:
            self.retval.export(outfile, level, namespace_, name_='retval', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.name is not None or
            self.direction is not None or
            self.relatedStateVariable is not None or
            self.retval is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ArgumentType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.direction is not None:
            showIndent(outfile, level)
            outfile.write('direction=%s,\n' % quote_python(self.direction).encode(ExternalEncoding))
        if self.relatedStateVariable is not None:
            showIndent(outfile, level)
            outfile.write('relatedStateVariable=%s,\n' % quote_python(self.relatedStateVariable).encode(ExternalEncoding))
        if self.retval is not None:
            showIndent(outfile, level)
            outfile.write('retval=model_.retvalType(\n')
            self.retval.exportLiteral(outfile, level, name_='retval')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'direction':
            direction_ = child_.text
            direction_ = self.gds_validate_string(direction_, node, 'direction')
            self.direction = direction_
        elif nodeName_ == 'relatedStateVariable':
            relatedStateVariable_ = child_.text
            relatedStateVariable_ = self.gds_validate_string(relatedStateVariable_, node, 'relatedStateVariable')
            self.relatedStateVariable = relatedStateVariable_
        elif nodeName_ == 'retval':
            obj_ = retvalType.factory()
            obj_.build(child_)
            self.set_retval(obj_)
# end class ArgumentType


class ServiceStateTableType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, stateVariable=None):
        if stateVariable is None:
            self.stateVariable = []
        else:
            self.stateVariable = stateVariable
    def factory(*args_, **kwargs_):
        if ServiceStateTableType.subclass:
            return ServiceStateTableType.subclass(*args_, **kwargs_)
        else:
            return ServiceStateTableType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_stateVariable(self): return self.stateVariable
    def set_stateVariable(self, stateVariable): self.stateVariable = stateVariable
    def add_stateVariable(self, value): self.stateVariable.append(value)
    def insert_stateVariable(self, index, value): self.stateVariable[index] = value
    def export(self, outfile, level, namespace_='', name_='ServiceStateTableType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceStateTableType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ServiceStateTableType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ServiceStateTableType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for stateVariable_ in self.stateVariable:
            stateVariable_.export(outfile, level, namespace_, name_='stateVariable', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.stateVariable
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ServiceStateTableType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('stateVariable=[\n')
        level += 1
        for stateVariable_ in self.stateVariable:
            showIndent(outfile, level)
            outfile.write('model_.StateVariableType(\n')
            stateVariable_.exportLiteral(outfile, level, name_='StateVariableType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'stateVariable':
            obj_ = StateVariableType.factory()
            obj_.build(child_)
            self.stateVariable.append(obj_)
# end class ServiceStateTableType


class StateVariableType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sendEvents='yes', name=None, dataType=None, defaultValue=None, allowedValueList=None, allowedValueRange=None):
        self.sendEvents = _cast(None, sendEvents)
        self.name = name
        self.dataType = dataType
        self.defaultValue = defaultValue
        self.allowedValueList = allowedValueList
        self.allowedValueRange = allowedValueRange
    def factory(*args_, **kwargs_):
        if StateVariableType.subclass:
            return StateVariableType.subclass(*args_, **kwargs_)
        else:
            return StateVariableType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_dataType(self): return self.dataType
    def set_dataType(self, dataType): self.dataType = dataType
    def get_defaultValue(self): return self.defaultValue
    def set_defaultValue(self, defaultValue): self.defaultValue = defaultValue
    def get_allowedValueList(self): return self.allowedValueList
    def set_allowedValueList(self, allowedValueList): self.allowedValueList = allowedValueList
    def get_allowedValueRange(self): return self.allowedValueRange
    def set_allowedValueRange(self, allowedValueRange): self.allowedValueRange = allowedValueRange
    def get_sendEvents(self): return self.sendEvents
    def set_sendEvents(self, sendEvents): self.sendEvents = sendEvents
    def export(self, outfile, level, namespace_='', name_='StateVariableType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StateVariableType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StateVariableType'):
        if self.sendEvents is not None and 'sendEvents' not in already_processed:
            already_processed.append('sendEvents')
            outfile.write(' sendEvents=%s' % (self.gds_format_string(quote_attrib(self.sendEvents).encode(ExternalEncoding), input_name='sendEvents'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StateVariableType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.dataType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataType>%s</%sdataType>%s' % (namespace_, self.gds_format_string(quote_xml(self.dataType).encode(ExternalEncoding), input_name='dataType'), namespace_, eol_))
        if self.defaultValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdefaultValue>%s</%sdefaultValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.defaultValue).encode(ExternalEncoding), input_name='defaultValue'), namespace_, eol_))
        if self.allowedValueList is not None:
            self.allowedValueList.export(outfile, level, namespace_, name_='allowedValueList', pretty_print=pretty_print)
        if self.allowedValueRange is not None:
            self.allowedValueRange.export(outfile, level, namespace_, name_='allowedValueRange', pretty_print=pretty_print)
    def hasContent_(self):
        if (
            self.name is not None or
            self.dataType is not None or
            self.defaultValue is not None or
            self.allowedValueList is not None or
            self.allowedValueRange is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StateVariableType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.sendEvents is not None and 'sendEvents' not in already_processed:
            already_processed.append('sendEvents')
            showIndent(outfile, level)
            outfile.write('sendEvents = "%s",\n' % (self.sendEvents,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.dataType is not None:
            showIndent(outfile, level)
            outfile.write('dataType=%s,\n' % quote_python(self.dataType).encode(ExternalEncoding))
        if self.defaultValue is not None:
            showIndent(outfile, level)
            outfile.write('defaultValue=%s,\n' % quote_python(self.defaultValue).encode(ExternalEncoding))
        if self.allowedValueList is not None:
            showIndent(outfile, level)
            outfile.write('allowedValueList=model_.AllowedValueListType(\n')
            self.allowedValueList.exportLiteral(outfile, level, name_='allowedValueList')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.allowedValueRange is not None:
            showIndent(outfile, level)
            outfile.write('allowedValueRange=model_.AllowedValueRangeType(\n')
            self.allowedValueRange.exportLiteral(outfile, level, name_='allowedValueRange')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('sendEvents', node)
        if value is not None and 'sendEvents' not in already_processed:
            already_processed.append('sendEvents')
            self.sendEvents = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'dataType':
            dataType_ = child_.text
            dataType_ = self.gds_validate_string(dataType_, node, 'dataType')
            self.dataType = dataType_
        elif nodeName_ == 'defaultValue':
            defaultValue_ = child_.text
            defaultValue_ = self.gds_validate_string(defaultValue_, node, 'defaultValue')
            self.defaultValue = defaultValue_
        elif nodeName_ == 'allowedValueList':
            obj_ = AllowedValueListType.factory()
            obj_.build(child_)
            self.set_allowedValueList(obj_)
        elif nodeName_ == 'allowedValueRange':
            obj_ = AllowedValueRangeType.factory()
            obj_.build(child_)
            self.set_allowedValueRange(obj_)
# end class StateVariableType


class AllowedValueListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, allowedValue=None):
        if allowedValue is None:
            self.allowedValue = []
        else:
            self.allowedValue = allowedValue
    def factory(*args_, **kwargs_):
        if AllowedValueListType.subclass:
            return AllowedValueListType.subclass(*args_, **kwargs_)
        else:
            return AllowedValueListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_allowedValue(self): return self.allowedValue
    def set_allowedValue(self, allowedValue): self.allowedValue = allowedValue
    def add_allowedValue(self, value): self.allowedValue.append(value)
    def insert_allowedValue(self, index, value): self.allowedValue[index] = value
    def export(self, outfile, level, namespace_='', name_='AllowedValueListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AllowedValueListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AllowedValueListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='AllowedValueListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for allowedValue_ in self.allowedValue:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sallowedValue>%s</%sallowedValue>%s' % (namespace_, self.gds_format_string(quote_xml(allowedValue_).encode(ExternalEncoding), input_name='allowedValue'), namespace_, eol_))
    def hasContent_(self):
        if (
            self.allowedValue
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AllowedValueListType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('allowedValue=[\n')
        level += 1
        for allowedValue_ in self.allowedValue:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(allowedValue_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'allowedValue':
            allowedValue_ = child_.text
            allowedValue_ = self.gds_validate_string(allowedValue_, node, 'allowedValue')
            self.allowedValue.append(allowedValue_)
# end class AllowedValueListType


class AllowedValueRangeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, minimum=None, maximum=None, step=None):
        self.minimum = minimum
        self.maximum = maximum
        self.step = step
    def factory(*args_, **kwargs_):
        if AllowedValueRangeType.subclass:
            return AllowedValueRangeType.subclass(*args_, **kwargs_)
        else:
            return AllowedValueRangeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_minimum(self): return self.minimum
    def set_minimum(self, minimum): self.minimum = minimum
    def get_maximum(self): return self.maximum
    def set_maximum(self, maximum): self.maximum = maximum
    def get_step(self): return self.step
    def set_step(self, step): self.step = step
    def export(self, outfile, level, namespace_='', name_='AllowedValueRangeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AllowedValueRangeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AllowedValueRangeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='AllowedValueRangeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.minimum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sminimum>%s</%sminimum>%s' % (namespace_, self.gds_format_float(self.minimum, input_name='minimum'), namespace_, eol_))
        if self.maximum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smaximum>%s</%smaximum>%s' % (namespace_, self.gds_format_float(self.maximum, input_name='maximum'), namespace_, eol_))
        if self.step is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstep>%s</%sstep>%s' % (namespace_, self.gds_format_float(self.step, input_name='step'), namespace_, eol_))
    def hasContent_(self):
        if (
            self.minimum is not None or
            self.maximum is not None or
            self.step is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AllowedValueRangeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.minimum is not None:
            showIndent(outfile, level)
            outfile.write('minimum=%f,\n' % self.minimum)
        if self.maximum is not None:
            showIndent(outfile, level)
            outfile.write('maximum=%f,\n' % self.maximum)
        if self.step is not None:
            showIndent(outfile, level)
            outfile.write('step=%f,\n' % self.step)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'minimum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'minimum')
            self.minimum = fval_
        elif nodeName_ == 'maximum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'maximum')
            self.maximum = fval_
        elif nodeName_ == 'step':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'step')
            self.step = fval_
# end class AllowedValueRangeType


class retvalType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if retvalType.subclass:
            return retvalType.subclass(*args_, **kwargs_)
        else:
            return retvalType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='retvalType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='retvalType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='retvalType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='retvalType', fromsubclass_=False, pretty_print=True):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='retvalType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class retvalType


GDSClassesMapping = {
    'argumentList': ArgumentListType,
    'actionList': ActionListType,
    'retval': retvalType,
    'stateVariable': StateVariableType,
    'argument': ArgumentType,
    'action': ActionType,
    'serviceStateTable': ServiceStateTableType,
    'allowedValueRange': AllowedValueRangeType,
    'specVersion': SpecVersionType,
    'allowedValueList': AllowedValueListType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'scpd'
        rootClass = scpd
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    return rootObj


def parseString(inString):
    from io import BytesIO
    doc = parsexml_(BytesIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'scpd'
        rootClass = scpd
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'scpd'
        rootClass = scpd
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from service import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import service as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "ActionListType",
    "ActionType",
    "AllowedValueListType",
    "AllowedValueRangeType",
    "ArgumentListType",
    "ArgumentType",
    "ServiceStateTableType",
    "SpecVersionType",
    "StateVariableType",
    "retvalType",
    "scpd"
    ]
